//genesis
// Neuron.g

prompt		"Neuron !"		// set the prompt
setclock	0	0.01		// simulation time step in msec
					// max size for reasonable accuracy
setclock	1	0.05		// output interval

echo SIMULATION CONFIGURATION
echo =========================
echo Hodgkin-Huxley 
echo multi-compartmental neuron (soma + dendrite)
echo with synaptic connections

int NCableSects = 0 // start with no passive compartments between dendrites

//==================================================
//                  STARTUP SCRIPTS
//==================================================
include constants.g
include tools.g
include channel.g
include compartment.g
include cell.g
include inputs.g
include make_cable.g
include forms.g

//=========================================================================
//  Some functions used in the main script
//
//  SendPlotMsgs  - sends messages to the graphics forms
//
//  ResetDefaults - similar to the main script, but graph forms pre-exist
//=========================================================================
  
function SendPlotMsgs
  push /output/dend1graphs
  sendmsg  /input/injectpulse   input_grf PLOT output *Inject *black
  sendmsg  /input/Apulse/spiketrain  input_grf PLOTSCALE \
                              state *SourceA *red {getclock(0)} 2
  sendmsg  /input/Bpulse/spiketrain  input_grf PLOTSCALE \
                              state *SourceB *blue {getclock(0)} 4
  // The scale is getclock(0) - adjustspikes should reset this
  sendmsg  /cell/dend1/Ex_channel    dend1Gk_grf PLOT Gk *Gex *black
  sendmsg  /cell/dend1/Inh_channel   dend1Gk_grf PLOT Gk *Ginh *red
  sendmsg  /cell/dend1               dend1Vm_grf PLOT Vm *dend1 *black
  pop

  push /output/dend2graphs
  sendmsg  /cell/dend2/Ex_channel    dend2Gk_grf PLOT Gk *Gex *black
  sendmsg  /cell/dend2/Inh_channel   dend2Gk_grf PLOT Gk *Ginh *red
  sendmsg  /cell/dend2               dend2Vm_grf PLOT Vm *dend2 *black
  pop

  push /output/somagraphs
  sendmsg  /cell/soma/Ex_channel/m     activation_grf PLOT m *m *black
  sendmsg  /cell/soma/Ex_channel/h     activation_grf PLOT m *h *red
  sendmsg  /cell/soma/Inh_channel/n    activation_grf PLOT m *n *blue

  sendmsg  /cell/soma/Ex_channel     somaGk_grf PLOT Gk *Na *black
  sendmsg  /cell/soma/Inh_channel      somaGk_grf PLOT Gk *K *red
  sendmsg  /cell/soma           somaVm_grf PLOT Vm *soma *black
  pop
end  // SendPlotMsgs

function ResetDefaults
    stop
    delete /cell
    delete /input
    delete /output/control
    delete /output/popups
    xhide /output/dend2graphs  // re-initialize toggle state
    NCableSects = 0
    makeneuron(/cell,{soma_l},{soma_d},{dend_l},{dend_d})  // in cell.g
    makeinputs                                            // inputs.g
    loadcontrol
    SendPlotMsgs
    check
    reset_kludge  // in cell.g
    adjustspike

end

//=========================================================================
//
//                         MAIN SCRIPT - Neuron   
//
//=========================================================================

//==================================================
// check and initialize the simulation
//==================================================
makeneuron(/cell,{soma_l},{soma_d},{dend_l},{dend_d})  // in cell.g
makeinputs                                            // inputs.g
loadgraphs	// in forms.g (This is done after the elements are created)
loadcontrol
SendPlotMsgs
check
reset_kludge	// in cell.g
adjustspike

echo ==================
echo Simulation loaded.
echo ==================
