//genesis

str quit_form = "Do you really want to quit ?"
str help_form = "Using the Neuron simulation kit"
str file_form = "file_form"
str select_form = "Select Level of analysis"
str chosencell = "Selected cell name"
str iocell = "Cell for IO"
str author = "Your Name"

function check_iocell

str io = get(/{file_form}/{iocell},value)

	if ({findchar({io},/)} != 0)
		echo Invalid cell for I/O. Cell must be of form '/cellname'.
		set /{file_form}/{iocell} value /cell
		return
	end
	if ({findchar({substring({io},1)},/)} != -1)
		echo Invalid cell for I/O. Cell must be of form '/cellname'.
		set /{file_form}/{iocell} value /cell
	end
end

function do_title_bar

	create xform /title_bar [0,0,{user_screenwidth},25] -nolabel
	ce ^
	disable .
    create xbutton quit [1%,2,13%,20] \
        -script popup_quit
    create xbutton help [15%,2,14%,20] \
        -script popup_help
    create xbutton "file" [30%,2,14%,20] \
        -script popup_file
    create xbutton "run cell" [45%,2,14%,20] \
        -script "set_level run_neuron"
    create xbutton "edit cell" [60%,2,14%,20] \
        -script "set_level neuron"
    create xbutton "edit compt" [75%,2,12%,20] \
        -script "set_level compt"
    create xbutton "edit channel" [88%,2,11%,20] \
        -script "set_level channel"
	
	create xform /{quit_form} [0,40,300,100]
	ce ^
	disable .
	create xbutton yes -script quit
	create xbutton no -script popdown_quit

	create xform /{help_form} [160,40,600,850] -notitle
	ce ^
	disable .
	create xlabel /{help_form}/header [1%,2,98%,25] -title {help_form}
	create xlabel /{help_form}/instr [1%,28,98%,25] \
		-title "Left and right buttons move up and down; double clicks move a page at a time"
	create xtext /{help_form}/text \
		[1%,55,98%,87%] -file {user_help}
	create xbutton "CANCEL" -script popdown_help

	create xform /{select_form} [480,40,300,100]
	ce ^
	disable .
	create xbutton "Single Neuron level" -script "set_level neuron"
	create xbutton "Compartment level" -script "set_level compt"
	create xbutton "Channel level" -script "set_level channel"
	create xbutton "CANCEL" -script popdown_select

	create xform /{file_form} [320,40,300,325] -nolabel
	ce ^
	disable .
	create xlabel "Cell Selection"
	create xdialog {chosencell} \
		-value /mit -script "choose_cell "<widget> 
	create xlabel "Cell Parameter IO"
	create xdialog {iocell} \
		-value /camit -script check_iocell
	create xdialog source_file_name -value camit.p
	create xbutton "Load from file" -script do_cell_load
	create xdialog "Save to file" \
		-script "do_cell_save "<widget> -value newcamit.p
	create xdialog {author} -value " "
	create xbutton "New Cell" -script "do_new_cell "<widget> \
		-value "/newcell"
	create xlabel " "
	create xbutton "CANCEL" -script popdown_file
	create neutral /dummy

    set /file_form/"Selected cell name" value {user_cell}
	check_iocell
    set /file_form/"Cell for IO" value {user_cell}
    set /file_form/"source_file_name" value {user_pfile}
    set /file_form/"Save to file" value new{user_pfile}
    set /file_form/{author} value {user_name}
end

function popup_quit
	xshow_on_top /{quit_form}
end

function popup_help
	xshow_on_top /{help_form}
end

function popup_file
	xshow_on_top /{file_form}
end

function popup_select
	xshow_on_top /{select_form}
end


function popdown_quit
	xhide /{quit_form}
end

function popdown_help
	xhide /{help_form}
end

function popdown_file
	xhide /{file_form}
end

function popdown_select
	xhide /{select_form}
end

function choose_cell(widget)
	str widget

	int n
	str num,cellw

    push /{file_form}
	xhide .
	str newcell = get({chosencell},value)

	if (!{exists({newcell})})
		echo {newcell} does not exist
		return
	end
	if (strcmp({cellpath},{newcell}) == 0)
		return
	end

	if (exists({cellpath}))
   		disable {cellpath}
		for (n=1; n<=2; n=n+1)
			num=n
			if ({exists({cellpath}xout{num})})
				disable {cellpath}graph{num}
				disable {cellpath}xout{num}
				xhide {cellpath}graph{num}
				xhide {cellpath}xout{num}
			end
		end
	end

    cellpath = newcell
	for (n=1; n<=2; n=n+1)
		num=n
		if (!{exists({cellpath}xout{num})})
			do_xout({num})
			do_xgraph({num})
		end
		if (strcmp({analysis_level},"run_neuron") == 0)
			if (num <= user_numxouts)
				xshow_on_top {newcell}graph{num}
				xshow_on_top {newcell}xout{num}
			end
		end
	end
   	enable {cellpath}
	for (n=1; n<={user_numxouts}; n=n+1)
		num=n
		enable {cellpath}graph{num}
		enable {cellpath}xout{num}
	end
    reset

	for (n=1; n<=2; n=n+1)
	  num = n
	  cellw = {cellpath} + "xout" + {num} + "/draw/cell"
	  set {cellw} autofat TRUE
	  set {cellw} fatfix FALSE
	  if ({user_symcomps})
   		set {cellw} path {cellpath}"/##[TYPE=symcompartment]"
   		set /compt_select/draw/cell path {cellpath}"/##[TYPE=symcompartment]"
	  else
   		set {cellw} path {cellpath}"/##[TYPE=compartment]"
   		set /compt_select/draw/cell path {cellpath}"/##[TYPE=compartment]"
	  end
	  set {cellw} fatfix TRUE
	  set {cellw} autofat FALSE
	end
	set /file_IO/field_path value {cellpath}/{user_filefieldpath}
	pop
end

function do_cell_load
	str wid = "/" + {file_form} + "/source_file_name"
	str name
	
	push /{file_form}
	read_cell {get({wid},value)} {get({iocell},value)}
	reset
	push /{file_form}
    set {chosencell} value {get({iocell},value)}
    choose_cell {chosencell}
	/* find type of first compartment, assume they are all same type */
	foreach name ({element_list({cellpath}/#[])})
		if (strcmp({get({name},object->name)},compartment) == 0)
			user_symcomps = 0
		else
			user_symcomps = 1
		end
		break	/* exit after first iteration of the loop */
	end
    pop
	xhide /{file_form}
	intmethod "/cell_run_control/method"  /* set correct integration method */
end

function do_cell_save(widget)
	str widget

	push /{file_form}
	write_cell {get({widget},value)} {get({iocell},value)} \
		-author {get({author},value)}
    pop
	xhide /{file_form}
end

function do_new_cell(widget)
	str widget

	echo not yet implemented
end

function set_level(level)
	str level

	if (!{exists({cellpath})})
		echo {cellpath} is not defined yet : a cell must be loaded in.
		return
	end

	if ({strcmp({analysis_level},{level})} == 0)
		return
	end

	if ({strcmp({level},"run_neuron")} == 0)
		xshow_on_top /cell_run_control
		xshow_on_top {cellpath}xout1
		xshow_on_top {cellpath}graph1
		if ({user_numxouts}>1)
			xshow_on_top {cellpath}xout2
			xshow_on_top {cellpath}graph2
		end
		/*
		if ({user_symcomps})
			set {cellpath}/##[TYPE=symcompartment] inject 0.0
		else
			set {cellpath}/##[TYPE=compartment] inject 0.0
		end
		*/
		do_run_clickmode(/cell_run_control/Recording)

		xhide /compt_display
		xhide /compt_select
		xhide /compt_lib_form
	else
		if ({strcmp({analysis_level},"new")} == 0)
		xshow_on_top /compt_display
		set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
		xshow_on_top /compt_select
		xshow_on_top /compt_lib_form
		end
	end
	if ({strcmp({level},"neuron")} == 0)
		xshow_on_top /cell_params
	end
	if ({strcmp({level},"compt")} == 0)
		xshow_on_top /compt_params
	end
	if ({strcmp({level},"channel")} == 0)
		xshow_on_top /channel_params
	end

	if ({strcmp({analysis_level},"run_neuron")} == 0)
		xshow_on_top /compt_display
		if ({user_symcomps})
			set /compt_select/draw/cell path {cellpath}/##[TYPE=symcompartment]
		else
			set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
		end
		xshow_on_top /compt_select
		xshow_on_top /compt_lib_form

		xhide /cell_run_control
		xhide /file_IO
		xhide {cellpath}xout1
		xhide {cellpath}graph1
		xhide {cellpath}xout2
		xhide {cellpath}graph2
	end
	if ({strcmp({analysis_level},"neuron")} == 0)
		xhide /cell_params
	end
	if ({strcmp({analysis_level},"compt")} == 0)
		xhide /compt_params
	end
	if ({strcmp({analysis_level},"channel")} == 0)
		xhide /channel_params
	end

	analysis_level = level
end
