//genesis

function do_xselect_funcs
	int channo

	create xform /compt_display [480,50,520,370]
	disable /compt_display
	create xdraw /compt_display/draw [0,2,100%,335] \
		-transform z2d -wx 18 -wy 18 -cx 9 -cy 9 -refresh_flag FALSE
	ce ^
	copy /xproto/draw/hhna.icon hh.icon
		set hh.icon pixcolor Orange linewidth 2
	copy /xproto/draw/excsyn.icon syn.icon
		set syn.icon pixcolor Green linewidth 2
	copy /xproto/draw/soma.icon rec.icon
	copy /xproto/draw/fillbox.icon vdep.icon
	copy /xproto/draw/comptshape compt
	copy /xproto/draw/hilight hilight
	create xshape dummy.icon
	create xshape comptpath -tx 10 -ty 10
	/* This is a brutish hack. We need to handle all this much better */
	for (channo = 0 ; channo < 20 ; channo = channo + 1)
		create xshape chan{channo} \
			-tx { 6 + 2.2 * (channo%5)} -ty {3.5 + 0.82 * channo}
	end
	create xtoggle /compt_display/mouse_mode \
		-script "set_compt_disp_mode "<widget>
		set /compt_display/mouse_mode	label0	"Select" \
						label1	"Cut-n-Paste"
	setup_mouse(/compt_display/draw,0,0,paste,do_chanpaste,cut,do_chancut,copy,do_chancopy)
	setup_mouse(/compt_display/draw,0,0, \
		select,"do_channelselect /compt_display/draw", \
		dummy,do_dummy,dummy,do_dummy)


	create xform /compt_select [0,440,480,450]
	disable /compt_select
	create xdraw /compt_select/draw [0,2,100%,415] \
		-transform ortho3d -wx 0.0015 -wy 0.0015 \
		-cz 0.2e-3 -vx 10 -vy -15 -vz 7
	set ^ wx {user_wx} wy {user_wy} cx {user_cx} cy {user_cy} cz {user_cz}
	create xtoggle /compt_select/scope [0,5,49%,20] \
		-widgets [NULL,draw.bottom,NULL,NULL]
		set /compt_select/scope	label0 "Select One Compartment" \
						label1 "Select Sub Tree"
	create xtoggle /compt_select/mouse_mode [51%,5,49%,20] \
		-widgets [NULL,draw.bottom,NULL,NULL] \
		-script "set_compt_sel_mode "<widget>
		set /compt_select/mouse_mode	label0	"Edit" \
						label1	"Cut-n-Paste"
	setup_mouse(/compt_select/draw,0,0,paste,do_comptpaste,cut,do_comptcut,copy,do_comptcopy)
	setup_mouse(/compt_select/draw,0,0,select,do_comptselect,stretch,do_stretch,rotate,do_rotate)
	create xcell /compt_select/draw/cell \
		-colfield activation \
		-colmin -1 -colmax 2 -fatfield dia -autocol FALSE
end

function sub_hilight(name)
	str name

	int nmsgs
	int i
	str child

	set {name} activation 1

	nmsgs = getmsg({name},IN,-count)

	for(i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({name},IN,{i},type)},RAXIAL) == 0)
			child = getmsg({name},IN,{i},src)
			sub_hilight {child}
		end
	end
end

function hilight_compt(name)
	str name

	int scope = get(/compt_select/scope,state)

	if ({user_symcomps})
		set {cellpath}/##[TYPE=symcompartment] activation 0
	else
		set {cellpath}/##[TYPE=compartment] activation 0
	end
	if ({scope} == 0) // local
		set {name} activation 1
	else
		sub_hilight({name})
	end

	xupdatepix /compt_select/draw cell
end

function display_compt(name)
	str name
	str chan
	int channo = 0

	foreach chan ({element_list(/compt_display/draw/chan#)})
		set {chan} text "" iconname dummy.icon
	end

	push /compt_display/draw

	foreach chan ({element_list({name}/#[TYPE=tabchannel])})
		set chan{channo} text {get({chan},name)} iconname hh.icon
		channo = channo + 1
	end
	foreach chan ({element_list({name}/#[TYPE=hh_channel])})
		set chan{channo} text {get({chan},name)} iconname hh.icon
		channo = channo + 1
	end
	foreach chan ({element_list({name}/#[TYPE=channelC2])})
		set chan{channo} text {get({chan},name)} iconname syn.icon
		channo = channo + 1
	end
	foreach chan ({element_list({name}/#[TYPE=vdep_channel])})
		set chan{channo} text {get({chan},name)} iconname vdep.icon
		channo = channo + 1
	end
	foreach chan ({element_list({name}/#[TYPE=receptor2])})
		set chan{channo} text {get({chan},name)} iconname rec.icon
		channo = channo + 1
	end

	set comptpath text {comptpath}

	foreach chan ({element_list(/compt_display/draw/chan#)})
		if (strcmp({get({chan},text)},{channelname}) == 0)
			set hilight tx {get({chan},tx)} ty {get({chan},ty)}
			xupdate /compt_display/draw
			pop
			return
		end
		set hilight tx -10 ty -10
	end

	xupdate .
	pop
end


function do_comptcut
	str src = get(/compt_select/draw,value)

	hilight_compt({src})
	cut_to_lib(compt_lib,{src},{get(/compt_select/scope,state)})
	if ({user_symcomps})
		set /compt_select/draw/cell path {cellpath}/##[TYPE=symcompartment]
	else
		set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
	end
end


function do_comptcopy
	str src = get(/compt_select/draw,value)

	hilight_compt({src})
	copy_to_lib(compt_lib,{src},{get(/compt_select/scope,state)})
end

function do_comptpaste
	str dst = get(/compt_select/draw,value)
	str elm = get(/compt_lib_form/sel,value)
	str elmname = get({elm},name) + "[" + get({elm},index) + "]"
	str src = {cellpath} + "/" + {elmname}
	float x,y,z
	int rename_flag = get(/compt_lib_form/auto_rename,state)
	str newname

	if (strcmp({get({elm}/{elmname},object->name)},"compartment") != 0)
		echo Only compartments may be pasted onto the cell.
		return
	end

	hilight_compt({dst})

	if ({!rename_flag} && {exists({cellpath}/{elmname})})
		echo Element {elmname} already exists. Paste not done.
		return
	end
	if (exists(/buffer/temp2))
		delete /buffer/temp2
	end
	copy {elm} /buffer/temp2
	if (rename_flag)
		newname = do_child_rename(/buffer/temp2/{elmname},{dst})
		src = {cellpath} + "/" + {newname}
		subtree_move(/buffer/temp2/{newname},{cellpath})
	else
		subtree_move(/buffer/temp2/{elmname},{cellpath});
	end

	sendmsg {dst} {src} AXIAL Vm
	sendmsg {src} {dst} RAXIAL Ra Vm
	x = get({dst},x)
	y = get({dst},y)
	z = get({dst},z)
	position {src} R{x} R{y} R{z}
	// refresh the cell display

	if ({user_symcomps})
		set /compt_select/draw/cell path {cellpath}/##[TYPE=symcompartment]
		set {cellpath}xout1/draw/cell path {cellpath}/##[TYPE=symcompartment]
		set {cellpath}xout2/draw/cell path {cellpath}/##[TYPE=symcompartment]
	else
		set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
		set {cellpath}xout1/draw/cell path {cellpath}/##[TYPE=compartment]
		set {cellpath}xout2/draw/cell path {cellpath}/##[TYPE=compartment]
	end
end


function do_channelselect(widget)
	str widget

	str icon = get({widget},pixchoose)

	channelname = {get({widget}/{icon},text)}
	channelpath = {comptpath} + "/" + {channelname}
	hilight_channel
	if ({exists({channelpath})})
		if ({strcmp({analysis_level},neuron)} == 0)
			update_neuron_params
		end
		/*
		if ({strcmp({analysis_level},compt)} == 0)
			update_compt_params
		end
		*/
		if ({strcmp({analysis_level},channel)} == 0)
			update_channel_params
		end
	end
end


function do_chancut
	do_channelselect(/compt_display/draw)

	hilight_channel
	cut_to_lib(compt_lib,{channelpath},{get(/compt_select/scope,state)})
	display_compt({comptpath})
end


function do_chancopy
	do_channelselect(/compt_display/draw)

	hilight_channel
	copy_to_lib(compt_lib,{channelpath},{get(/compt_select/scope,state)})
end

function do_chanpaste
	str elm = get(/compt_lib_form/sel,value)
	str elmname = get({elm},name) + "[" + get({elm},index) + "]"
	str src = "/compt_lib/" + {elmname} + "/" + {elmname}
	str chtype = get({src},object->name)
	str name

	if (strcmp({chtype},"compartment") == 0)
		echo element {elmname} is not a channel
		return
	end

	if ({get(/compt_select/scope,state)} == 1) // global
		foreach name ({EL({cellpath}/#[][activation>0.99])})
			if (exists({name}/{elmname}))
				echo Element {elmname} already exists. Paste not done.
			else
				paste_channel {src} {name}
			end
		end
	else // local
		if (exists({comptpath}/{elmname}))
			echo Element {elmname} already exists. Paste not done.
			return
		end
		paste_channel {src} {comptpath}
	end
		
	hilight_compt({comptpath})

	display_compt({comptpath})
end


function do_comptselect
	str name

	name = get(/compt_select/draw,value)
	if ({exists({name})})
		comptpath = name
		comptname = get({name},name)
		channelpath = {comptpath} + "/" + {channelname}
		hilight_compt({comptpath})
		// hilight_compt({comptpath},{get(/compt_select/scope,state)})
		if ({strcmp({analysis_level},neuron)} == 0)
			update_neuron_params
		end
		if ({strcmp({analysis_level},compt)} == 0)
			update_compt_params
		end
		if ({strcmp({analysis_level},channel)} == 0)
			update_channel_params
		end
		display_compt({comptpath})
	end
end

function set_compt_sel_mode(widget)
    str widget

    int state = get({widget},state)

    if (state == 1)
        select_mouse(/compt_select/draw,paste,do_comptpaste, \
			cut,do_comptcut,copy,do_comptcopy)
    else
        select_mouse(/compt_select/draw,select,do_comptselect, \
			stretch,do_stretch,rotate,do_rotate)
    end
end

function set_compt_disp_mode(widget)
    str widget

    int state = get({widget},state)

    if (state == 1)
        select_mouse(/compt_display/draw,paste,do_chanpaste, \
			cut,do_chancut,copy,do_chancopy)
    else
        select_mouse(/compt_display/draw, \
			select,"do_channelselect /compt_display/draw", \
			dummy,do_dummy,dummy,do_dummy)
    end
end
