//genesis

float dt = user_dt
float refresh_factor = user_refresh
int i
int col1 = 15
int col2 = 15

function do_xcell_run_control
	for (i = 0 ; i < 10 ; i = i + 1)
		setclock {i} {dt}
	end
	setclock 9 {dt * refresh_factor}
	
	create xform /cell_run_control [0,50,380,500] -nolabel
	ce ^ 
	disable .
	create xlabel "SIMULATION CONTROL PANEL" [0,0,100%,40]
	create xbutton stop [2%,45,30%,22] \
		-widgets [NULL,NULL,NULL,NULL] -script finish_run
	create xbutton reset [7,45,30%,22] \
		-widgets [stop.right,NULL,NULL,NULL] -script reset
	create xbutton run [7,45,30%,22] \
		-widgets [reset.right,NULL,NULL,NULL] \
		-script runsteps
	create xbutton save [2%,72,30%,22] \
		-script save_sim
	create xbutton restore [7,72,30%,22] \
		-widgets [save.right,NULL,NULL,NULL] \
		-script restore_sim
	create xbutton "run paradigm" [7,72,30%,22] \
		-widgets [restore.right,NULL,NULL,NULL] \
		-script do_paradigm
	create xdialog nstep -script "nstep "<widget> -value 10000
	create xdialog runtime [8,5,64%,30] -ywidget nstep.bottom \
		-script "runtime "<widget> -value 0.1
	create xdialog method [4,5,30%,30] \
		-widgets [runtime.right,nstep.bottom,NULL,NULL] \
		-script "intmethod "<widget> -value 0
	set /cell_run_control/method value {user_intmethod}
	
	/* If we change the clock used by a script_out element to one with
	** another period, we can get commands executed different rates. 
	** Here, clock 1 starts up at 1/10 the simulation clock rate so
	** the script is executed every 10 timesteps */
	
	create script_out /output/refresh_out
	create disk_out /output/field_out 
	disable /output/field_out
	create asc_file /output/field_aout 
	disable /output/field_aout
	create disk_out /output/plot_out
	disable /output/plot_out
	set /output/refresh_out command get_current_time
	useclock /output/refresh_out 9
	useclock /output/field_out 9
	useclock /output/field_aout 9
	useclock /output/plot_out 9

	create xlabel /cell_run_control/"TIMING (sec)"
	create xdialog current_time -script get_current_time -value 0.000
	create xdialog clock [2%,5,50%,30] \
		-ywidget current_time.bottom \
		-value {dt} -script "setdt <widget> "
	create xdialog refresh_factor [7,5,44%,30] \
		-widgets [clock.right,current_time.bottom,NULL,NULL] \
		-script "setrefresh <widget>" -value {refresh_factor}

	set runtime value {user_runtime}
	set nstep value {user_runtime /user_dt}

	create xlabel "ELECTROPHYSIOLOGY"

	create xtoggle Recording [2%,4,15%,20] \
		-ywidget ELECTROPHYSIOLOGY.bottom \
		-script "do_run_clickmode "<widget> 
	create xtoggle Iclamp [18%,4,15%,20] \
		-ywidget ELECTROPHYSIOLOGY.bottom \
		-script "do_run_clickmode "<widget> 
	create xtoggle Vclamp [34%,4,15%,20] \
		-ywidget ELECTROPHYSIOLOGY.bottom \
		-script "do_run_clickmode "<widget> 
	create xtoggle "Syn act" [50%,4,15%,20] \
		-ywidget ELECTROPHYSIOLOGY.bottom \
		-script "do_run_clickmode "<widget> 
	create xtoggle "Syn spike" [66%,4,15%,20] \
		-ywidget ELECTROPHYSIOLOGY.bottom \
		-script "do_run_clickmode "<widget> 
	create xtoggle "Syn rand" [82%,4,16%,20] \
		-ywidget ELECTROPHYSIOLOGY.bottom \
		-script "do_run_clickmode "<widget> 

	create neutral /stimulus
	create random /stimulus/rand
		set ^ rate 100.0 \
			min_amp	1 \
			max_amp	1
	create axon /stimulus/axon
	sendmsg /stimulus/rand /stimulus/axon BUFFER name


	create xdialog "inject (nanoAmps)"  \
        -widgets [NULL,ELECTROPHYSIOLOGY.bottom,NULL,NULL] \
		-script "update_inject "<widget>
	set "inject (nanoAmps)" value {user_inject}

	create xdialog "Clamp voltage (mV)" [2%,29,96%,30] \ 
		-widgets [NULL,ELECTROPHYSIOLOGY.bottom,NULL,NULL] \
		-script "set_vclamp "<widget>
	set "Clamp voltage (mV)" value {user_clamp}

	create xdialog "Spike rate (Hz)" [2%,29,48%,30] \ 
		-widgets [NULL,ELECTROPHYSIOLOGY.bottom,NULL,NULL] \
		-script "set_rand_rate "<widget>
	set "Spike rate (Hz)" value {user_rate}

	create xdialog "Spike weight" [50%,29,48%,30] \ 
		-widgets [NULL,ELECTROPHYSIOLOGY.bottom,NULL,NULL] \
		-script "set_rand_wt "<widget>
	set "Spike weight" value {user_weight}

	create xdialog "Amount of synaptic activation" [2%,29,96%,30] \ 
		-widgets [NULL,ELECTROPHYSIOLOGY.bottom,NULL,NULL] \
		-script "set_act_dummy "<widget>
	set "Amount of synaptic activation" value {user_activ}
	create xdialog "Weight of spike" [2%,29,96%,30] \ 
		-widgets [NULL,ELECTROPHYSIOLOGY.bottom,NULL,NULL] 
	set "Weight of spike" value {user_spike}

	create xdialog click_site1 -script click_site(1) -value none
	create xdialog click_site2 -script click_site(2) -value none 
	create xbutton {user_syntype1} [2%,3,15%,30] \
		-widgets [NULL,click_site2.bottom,NULL,NULL] \
		-script set_syn_type1
	create xbutton {user_syntype2} [18%,3,15%,30] \
		-widgets [NULL,click_site2.bottom,NULL,NULL] \
		-script set_syn_type2
	create xdialog "Syn Type" [32%,3,64%,30] \
		-widgets [NULL,click_site2.bottom,NULL,NULL] \
		-value {user_syntype1} 
	create xbutton "Remove all electrophysiology probes" -script remplot
	create xtoggle "FILE IO" [2%,23,47%,20] \
		-widgets [NULL,NULL.bottom,NULL,NULL] \
		-script "popup_file_io "<widget>
		set ^ label0 "Show Simulation IO control" \
			label1 "Hide Simulation IO control"
	create xtoggle toggle_xout2  [51%,23,47%,20] \
		-widgets [NULL,NULL.bottom,NULL,NULL] \
		-script "show_xout2 "<widget>
		set ^ label0 "Show extra cell window" \
			label1 "Hide extra cell window"
		
	create xform /file_IO [0,555,380,350] -nolabel
	ce ^ 
	disable .
	create xdialog filepath
	set filepath value {user_filepath}
	create xdialog save_restore_file
	set save_restore_file value {user_restorefile}
	create xdialog file_index -value 0

	create xtoggle save_run_info
		set ^ label1 "Save run info" label0 "Do Not Save run info"
	create xdialog info_file -value test
	create xdialog notes -value " "

	create xtoggle save_plot
		set ^ label1 "Save Plots (graph1)" \
			  label0 "Do Not Save Plots (graph1)"
	create xdialog plot_file -value testplot

	create xtoggle save_field [2%,4,46%,20] \
		-ywidget plot_file.bottom
		set ^ label1 "Save Field" label0 "Do Not Save Field"
	create xtoggle save_type [52%,4,46%,20] \
		-ywidget plot_file.bottom
		set ^ label1 "Ascii" label0 "Binary"
	create xdialog field
	set field value {user_filefield}
	create xdialog field_path 
	set field_path value {cellpath}/{user_filefieldpath}
	create xdialog field_file
	set field_file value {user_filename}
end

function get_current_time
	set /cell_run_control/current_time value {status(-time)}
end

function nstep(widget)
str widget
	float nsteps = {get({widget},value)}
	set /cell_run_control/runtime value {nsteps * dt}
end

function runtime(widget)
str widget
	float runtime = {get({widget},value)}
	int nsteps

	nsteps = runtime / dt + 0.5
	set /cell_run_control/nstep value {nsteps}
end

function intmethod(widget)
str widget
	int imethod = {get({widget},value)}
	if ({imethod} == 10)
		if (!{exists({cellpath}/solve)})
			create hsolve {cellpath}/solve 
			set ^ path {cellpath}/##[][TYPE=compartment]
			call {cellpath}/solve SETUP
			setmethod {cellpath}/solve  10
			echo Warning : the previous integration scheme will still apply for elements other
			echo than compartments and tabchannels

			echo Note : a reset may be necessary
		else
			setmethod {cellpath}/solve  10
		end
	end
	if ({imethod} == 11)
		if (!{exists({cellpath}/solve)})
			create hsolve {cellpath}/solve 
			set ^ path {cellpath}/##[][TYPE=compartment]
			call {cellpath}/solve SETUP
			setmethod {cellpath}/solve 11
			echo Warning : the previous integration scheme will still apply for elements other
			echo than compartments and tabchannels
			echo Note : a reset may be necessary
		else
			setmethod {cellpath}/solve 11
		end
	end

	if ({imethod} < -1)
		echo illegal entry, setting to exponential method
		imethod = 0
		set /cell_run_control/method value 0
	end
	if ({{imethod} != 10} && {{imethod} != 11})
		if ({exists({cellpath}/solve)})
			delete {cellpath}/solve
			echo reset may be necessary
		end
		if ({imethod} > 7)
			echo illegal entry, setting to exponential method
		end
	end

	setmethod {cellpath}/## {imethod}
/*
**	This is what we ought to do, but method fields are not universal
	if ({user_symcomps})
		set {cellpath}/##[][TYPE=symcompartment] method {imethod}
	else
		set {cellpath}/##[][TYPE=compartment] method {imethod}
	end
*/
end

function setrefresh(widget)
str widget
	echo setting refresh_factor to {get({widget},value)} 
	refresh_factor = {get({widget},value)}
	setclock 9 {{getclock(0)} * refresh_factor}  //sec : for the refresh views
end

function showtoggle(widget,form)
str widget
str form
	echo {widget} {form}
	if ({get({widget},state)} == 1)
		xhide {form}
	else
		xshow {form}
	end
end 

function do_nothing // a dummy function
end

function setdt(widget)
str widget
str cell
int clockno, nsteps

	dt = get({widget},value)
	echo setting {cell} timesteps to {dt}
	echo a reset may be necessary.
	setclock {clockno} {dt} // sec
	if (clockno == 0)
		setclock 9 {dt * refresh_factor} 
	end
	nsteps ={get(/cell_run_control/runtime, value) / dt + 0.5}
	set /cell_run_control/nstep value {nsteps}
end

function run_func
	source cellparms.g
end

/*
function run_para
	set dummy_para script {get(paradigm_file,value)}


	if (strcmp({get(paradigm_file,value)},"cellparms") == 0)
		cellparms
		return
	end
	if (strcmp({get(paradigm_file,value)},"para1") == 0)
		para1
		return
	end
	if (strcmp({get(paradigm_file,value)},"para2") == 0)
		para2
		return
	end
	// Default op is to step as many as specified
	nstep /cell_run_control/nstep
end
*/

str info_file
str plot_file
str field_file

function start_run
	push /file_IO

	info_file = {get(filepath,value)} + "/" + \
		{get(info_file,value)} + {get(file_index,value)}
	plot_file = {get(filepath,value)} + "/" + \
		{get(plot_file,value)} + {get(file_index,value)}
	field_file = {get(filepath,value)} + "/" + \
		{get(field_file,value)} + {get(file_index,value)}

	if ({get(save_run_info,state)} == 1)
		echo saving run info in {info_file}
		openfile {info_file} "a" 
		writefile {info_file}
		writefile {info_file} {date}
		/*
		writefile {info_file} paradigm : {get(paradigm_file,value)}
		*/
		writefile {info_file} Cell input res = {calc_Rm({cellpath}/soma)}
		writefile {info_file} Approx Cell cap = {calc_Cm({cellpath})}
		writefile {info_file} notes : {get(notes,value)}
		writefile {info_file}
    	if ({get(save_plot,state)} == 1)
        	writefile {info_file} storing plots in {plot_file}
    	end
	
    	if ({get(save_field,state)} == 1)
        	writefile {info_file} storing field '{get(field,value)}' in {field_file}
    	end
	end

	/* This makes the data go to a new file with the new header info.
	** It should overwrite existing files with the same name, so
	** beware ! */
	if ({get(save_plot,state)} == 1)
		enable /output/plot_out
		set /output/plot_out filename {plot_file} initialize 1
	end

	if ({get(save_field,state)} == 1)
		if ({get(save_type,state)} == 1)
			enable /output/field_aout
			set /output/field_aout filename {field_file} initialize 1
			call /output/field_aout RESET
		else
			enable /output/field_out
			set /output/field_out filename {field_file} initialize 1
			call /output/field_out RESET
		end
	end

	pop
end

function make_output_messages
	str name
	str field
	str src
	int nmsgs
	int	i

	push /file_IO
	if ({get(save_plot,state)} == 1)

		set /output/plot_out filename {plot_file} append 1 leave_open 1
		nmsgs = getmsg({cellpath}graph1/graph,IN,-count)

		for ( i = 0 ; i < nmsgs ; i = i + 1)
			src = getmsg({cellpath}graph1/graph,IN,{i},src)
			sendmsg {src} /output/plot_out SAVE Vm
		end
		// look at all messages going to the graph, and send them to
		// a file as well

		// openfile {plot_file} "a"
	end

	if ({get(save_field,state)} == 1)
		field = {get(field,value)}
		if ({get(save_type,state)} == 1)
			set /output/field_aout filename {field_file} append 1 \
											leave_open 1 flush 1
		else
			set /output/field_out filename {field_file} append 1 \
											leave_open 1 flush 1
		end

		foreach name ({element_list({get(field_path,value)})})
			if ({get(save_type,state)} == 1)
				sendmsg {name} /output/field_aout SAVE {field}
			else
				sendmsg {name} /output/field_out SAVE {field}
			end
		end
		reset
	end
	pop
end

function finish_run
	push /file_IO

	stop

	if ({get(save_run_info,state)} == 1)
		closefile {info_file}
	end
	pop
	disable /output/field_out
	disable /output/field_aout
	disable /output/plot_out
end

function clean_output_messages
	int nmsgs,i
	push /file_IO
	/* Getting rid of the messages */
	if ({get(save_plot,state)} == 1)
		nmsgs = getmsg(/output/plot_out,IN,-count)
		for ( i = 0 ; i < nmsgs ; i = i + 1)
			deletemsg /output/plot_out IN 0
		end
	end

	if ({get(save_field,state)} == 1)
		if ({get(save_type,state)} == 1)
			nmsgs = getmsg(/output/field_aout,IN,-count)
			for ( i = 0 ; i < nmsgs ; i = i + 1)
				deletemsg /output/field_aout IN 0
			end
		else
			nmsgs = getmsg(/output/field_out,IN,-count)
			for ( i = 0 ; i < nmsgs ; i = i + 1)
				deletemsg /output/field_out IN 0
			end
		end
	end
	pop
end

function do_dummy
	click_site 1
end

function set_rand_rate(widget)
	set /stimulus/rand rate {get({widget},value)}
end

function set_rand_wt(widget)
	set /stimulus/axon:0 weight {get({widget},value)}
end

function do_run_clickmode(widget)
	str widget

	str widgname = get({widget},name)
	int n
	str num,draww

	ce /cell_run_control
	if ({get(Recording,state)} == 0)
		set Recording state 1
	end
	if ({get(Iclamp,state)} == 0)
		set Iclamp state 1
	end
	if ({get(Vclamp,state)} == 0)
		set Vclamp state 1
	end
	if ({get("Syn act",state)} == 0)
		set "Syn act" state 1
	end
	if ({get("Syn spike",state)} == 0)
		set "Syn spike" state 1
	end
	if ({get("Syn rand",state)} == 0)
		set "Syn rand" state 1
	end
	set {widget} state 0

	for (n=1; n<=2; n=n+1)
		num = n
		draww = {cellpath} + "xout" + {num} + "/draw"
		if (strcmp({widgname},"Recording") == 0)
			select_mouse({draww},add_plot,"add_plot "{num}, \
				drop_plot,"drop_plot "{num},dummy,do_dummy)
		end
		if (strcmp({widgname},"Iclamp") == 0)
			select_mouse({draww},inject,"do_inject "{num}, \
				unject,"clear_inject "{num},dummy,do_dummy)
			xraise "inject (nanoAmps)"
		end
		if (strcmp({widgname},"Vclamp") == 0)
			select_mouse({draww},Vclamp,"do_vclamp "{num}, \
				unclamp,"clear_vclamp "{num},dummy,do_dummy)
			xraise "Clamp voltage (mV)"
		end
		if (strcmp({widgname},"Syn act") == 0)
			xraise "Amount of synaptic activation"
			select_mouse({draww},SynAct,"do_act "{num}, \
				UnAct,"do_unact "{num},dummy,do_dummy)
		end
		if (strcmp({widgname},"Syn spike") == 0)
			xraise /cell_run_control/"Weight of spike"
			select_mouse({draww},SynSpike, "do_spike "{num}, \
				UnSpike,"do_unspike "{num},dummy,do_dummy)
		end
		if (strcmp({widgname},"Syn rand") == 0)
			xraise /cell_run_control/"Spike rate (Hz)"
			xraise /cell_run_control/"Spike weight"
			select_mouse({draww},RandSyn,"do_rand "{num}, \
				UnRand,"do_unrand "{num},dummy,do_dummy)
		end
	end
end


function set_act_dummy(widget)
	str widget

	int n
	float act
	str compt,channame,iname,num

	for (n=1; n<= user_numxouts; n=n+1)
		num=n
		compt = get({cellpath}xout{num}/draw,value)
		channame = get(/cell_run_control/"Syn Type",value)
		iname = get({compt},name) + get({compt},index)
		act = get({widget},value)
		if (exists({cellpath}xout{num}/draw/act{channame}{iname}/dummy))
		 set {cellpath}xout{num}/draw/act{channame}{iname}/dummy z {act}
		end
	end
end

function remplot
	int nmsgs,i,n
	str name,num

	for (n=1; n<= user_numxouts; n=n+1)
		num=n
		nmsgs = getmsg({cellpath}graph{num}/graph,IN,-count)
		for ( i = 0 ; i < nmsgs ; i = i + 1)
			deletemsg({cellpath}graph{num}/graph,IN,0)
		end
		foreach name ({element_list({cellpath}xout{num}/draw/Tr#)})
			delete {name}
		end
		foreach name ({element_list({cellpath}xout{num}/draw/Inj#)})
			delete {name}
		end
		foreach name ({element_list({cellpath}/#[]/Vclamp#)})
			delete {name}
		end
		foreach name ({element_list({cellpath}xout{num}/draw/rand#)})
			delete {name}
		end
		delete /stimulus/axon:0
		foreach name ({element_list({cellpath}xout{num}/draw/act#)})
			delete {name}
		end
	end
	if ({user_symcomps})
		foreach name ({element_list({cellpath}/##[TYPE=symcompartment])})
			set {name} inject 0.0
		end
	else
		foreach name ({element_list({cellpath}/##[TYPE=compartment])})
			set {name} inject 0.0
		end
	end
	echo removed all electrophysiology probes
end

function update_inject(widget)
	str widget

	if ({strcmp({lastinjectsite1},"none")} != 0)
	    set {lastinjectsite1} inject {get({widget},value) / 1.0e9}
	    echo "setting injection on "{lastinjectsite1}" to "{get({widget},value)}" nA"
	end
	if ({strcmp({lastinjectsite2},"none")} != 0)
	    set {lastinjectsite2} inject {get({widget},value) / 1.0e9}
	    echo "setting injection on "{lastinjectsite2}" to "{get({widget},value)}" nA"
	end
end

function set_vclamp(widget)
	str widget
	float temp = get({widget},value)
	str draww,iname
	
	draww = {cellpath} + "xout1/draw"
	if ({strcmp({lastinjectsite1},"none")} != 0)
		iname = get({lastinjectsite1},name)+get({lastinjectsite1},index)
		if ({exists({draww}/Vclamp{iname})})
			temp = temp/1.0e3
			/*
			set {draww}/Vclamp{iname}/Vclamp x {temp}
			*/
			set {lastinjectsite1}/Vclamp x {temp}
		end
	end
	draww = {cellpath} + "xout2/draw"
	if ({strcmp({lastinjectsite2},"none")} != 0)
		iname = get({lastinjectsite2},name)+get({lastinjectsite2},index)
		if ({exists({draww}/Vclamp{iname})})
			temp = temp/1.0e3
			/*
			set {draww}/Vclamp{iname}/Vclamp x {temp}
			*/
			set {lastinjectsite2}/Vclamp x {temp}
		end
	end
end

function runsteps
	echo doing {get(/cell_run_control/nstep,value)} steps
	start_run
	make_output_messages
	reschedule
	step {get(/cell_run_control/nstep,value)}
	finish_run
	clean_output_messages
	echo finished {get(/cell_run_control/nstep,value)} steps
end

function set_syn_type1
	set /cell_run_control/"Syn Type" value {user_syntype1}
end

function set_syn_type2
	set /cell_run_control/"Syn Type" value {user_syntype2}
end

function show_xout2(widget)
	str widget

	if ({get({widget},state)} == 0)
    	disable {cellpath}graph2
    	disable {cellpath}xout2
    	xhide {cellpath}xout2
    	xhide {cellpath}graph2
		set {cellpath}xout1 width 600
		set {cellpath}graph1 width 600
		user_numxouts = 1
	else
		set {cellpath}xout1 width {(user_screenwidth - 380)/2}
		set {cellpath}graph1 width {(user_screenwidth - 380)/2}
    	enable {cellpath}graph2
    	enable {cellpath}xout2
    	xshow_on_top {cellpath}xout2
    	xshow_on_top {cellpath}graph2
		user_numxouts = 2
	end
end

function popup_file_io(widget)
	str widget
	if ({get({widget},state)} == 0)
		xhide /file_IO
	else
		xshow_on_top /file_IO
	end
end

function save_sim
	str file_name = {get(/file_IO/save_restore_file,value)} + \
						 {get(/file_IO/file_index,value)}

	save {file_name}
end

function restore_sim
	str file_name = {get(/file_IO/save_restore_file,value)} + \
						 {get(/file_IO/file_index,value)}

	restore {file_name}
end
