//genesis

str lastinjectsite1 = "none"
str lastinjectsite2 = "none"

// This function is accessed from the 'when' command in the xsout file
function set_field(widget,view)
str widget
str view
	set {view} field {get({widget},value)}
end

// This function is accessed from the 'when' command in the xsout file
function autoscale_toggle(widget,view)
str widget
	if ({get({widget},state)} == 1)
		set {view} autoscale TRUE
	else
		set {view} autoscale FALSE
	end
end

function click_site(num)
	str num

	set /cell_run_control/click_site{num} value \
		{get({cellpath}xout{num}/draw,value)}
end

function do_inject(num)
	str num
	int inum = num
	str widget = {cellpath} + "xout" + {num} + "/draw"

	str name = get({widget},value)
	str iname = get({name},name) + get({name},index)

	click_site({num})

	set {name} inject {get(/cell_run_control/"inject (nanoAmps)",value) / 1e9}
	if (inum == 1)
		lastinjectsite1 = name
	else
		lastinjectsite2 = name
	end
	echo Setting injection on {name} to  {get(/cell_run_control/"inject (nanoAmps)",value)} nA.
	if ({exists({widget}/Inj{iname})})
		return
	end

	copy /xproto/draw/Inj {widget}/Inj{iname}
	set {widget}/Inj{iname} \
		tx {get({name},x)} ty {get({name},y)} \
		tz {get({name},z)}
end

function clear_inject(num)
	str num
	int inum = num
	str widget = {cellpath} + "xout" + {num} + "/draw"

	str name = get({widget},value)
	str iname = get({name},name) + get({name},index)
	click_site({num})

	set {name} inject {0.0}
	if (inum == 1)
		lastinjectsite1 = "none"
	else
		lastinjectsite2 = "none"
	end
	echo Setting injection on {name} to  0 nA.
	if ({exists({widget}/Inj{iname})})
		delete {widget}/Inj{iname}
	end
end


function do_vclamp(num)
	str num
	int inum = num
	str widget = {cellpath} + "xout" + {num} + "/draw"
	float temp

	str name = get({widget},value)
	str iname = get({name},name) + get({name},index)
	if (inum == 1)
		lastinjectsite1 = name
	else
		lastinjectsite2 = name
	end
	click_site({num})

	if ({exists({widget}/Vclamp{iname})})
		temp = get({name}/Vclamp,x)
		temp = temp * 1e3
		set /cell_run_control/"Clamp voltage (mV)" value {temp}
		return
	end

	copy /xproto/draw/Vclamp {widget}/Vclamp{iname}
	set {widget}/Vclamp{iname} \
		tx {get({name},x)} ty {get({name},y)} \
		tz {get({name},z)}

	/*
	copy /library/Vclamp {widget}/Vclamp{iname}
	push {widget}/Vclamp{iname}/Vclamp
	*/
	copy /library/Vclamp {name}
	push {name}/Vclamp

	temp = get(/cell_run_control/"Clamp voltage (mV)",value)
	echo Setting clamp Voltage on {name} to  {temp} mV.
	set . x {temp/1.0e3}
	sendmsg	.		lowpass	INJECT	x
	sendmsg	{name}	PID		SNS		Vm
	sendmsg	PID		{name}	INJECT	output
	reschedule
	pop
end


function clear_vclamp(num)
	str num
	int	inum
	str widget = {cellpath} + "xout" + {num} + "/draw"

str name = get({widget},value)
str iname = get({name},name) + get({name},index)
	click_site({num})

	set {name} inject {0.0}
	if (inum == 1)
		lastinjectsite1 = "none"
	else
		lastinjectsite2 = "none"
	end
	echo Removing Voltage clamp from {name}
	if ({exists({widget}/Vclamp{iname})})
		delete {widget}/Vclamp{iname}
		delete {name}/Vclamp
	end
end


int col1 = 15
int col2 = 15
function add_plot(num)
	str num
	str draww = {cellpath} + "xout" + {num} + "/draw"
	str graphw = {cellpath} + "graph" + {num} + "/graph"
	str newplot = get({draww},value)
    str fieldpath = {newplot} + "/" + {get({draww}/cell,fieldpath)}
    str field = get({draww}/cell,colfield)
    str name
	int col 
    click_site({num})

	if (strcmp({num},"1") == 0)
		col = col1
	else
		col = col2
	end
	name = {get({newplot},name)} + "[" + {get({newplot},index)} + "]"
    if ({exists({draww}/Tr{name})})
        echo already recording from {newplot}, {name}
        return
    end
	if (!{exists({fieldpath})})
		echo cannot record from {fieldpath} : it does not exist 
		return
	end
    sendmsg {fieldpath} {graphw} PLOT {field} *{name} *hot{col}
	set {graphw} YUnits {get({draww}/cell,fieldpath)}:{field}
	copy /xproto/draw/Trode {draww}/Tr{name} 
	set {draww}/Tr{name} pixcolor "hot"{col} \
        tx {get({newplot},x)} ty {get({newplot},y)} \
        tz {get({newplot},z) + 0.00001}
    col = col + 15
	if (col > 80)
        col = col - 70
    end
	if (strcmp({num},"1") == 0)
		col1 = col
	else
		col2 = col
	end
    echo adding plot for element '{fieldpath}' of {field}
end

function drop_plot(num)
	str num
	str draww = {cellpath} + "xout" + {num} + "/draw"
	str graphw = {cellpath} + "graph" + {num} + "/graph"
    int nmsgs,i
    str oldplot = get({draww},value)
    str fieldpath = EL({oldplot}/{get({draww}/cell,fieldpath)})
    str src,name
    str field = get({draww}/cell,colfield)
    click_site({num})

    nmsgs = getmsg({graphw},IN,-count)

    for ( i = 0 ; i < nmsgs ; i = i + 1)
        src = getmsg({graphw},IN,{i},src)
        if (strcmp({src},{fieldpath}) == 0)
            deletemsg({graphw},IN,{i})
            i = i - 1
            nmsgs = nmsgs - 1
			/*
            name = {get({oldplot},name)}+ {get({oldplot},index)}+{field}
			*/
            name = {get({oldplot},name)}+"["+{get({oldplot},index)}+"]"
            delete {draww}/Tr{name}
    		echo dropping plot for '{field}' on element '{fieldpath}'
        end
    end

end

function color_plot(num)
	str num
	str draww = {cellpath} + "xout" + {num} + "/draw"
	str graphw = {cellpath} + "graph" + {num} + "/graph"
    int nmsgs,i,k,l
	int col 
    str oldplot,src,name,char
    str field = get({draww}/cell,colfield)
    str fieldpath =  {get({draww}/cell,fieldpath)}
	str otype

	if (strcmp({num},"1") == 0)
		col = col1
	else
		col = col2
	end
    nmsgs = getmsg({graphw},IN,-count)
    col = col + 15
	if (col > 80)
        col = col - 70
    end
	if (strcmp({num},"1") == 0)
		col1 = col
	else
		col2 = col
	end

    for ( i = 0 ; i < nmsgs ; i = i + 1)
        src = getmsg({graphw},IN,{0},src)
        deletemsg({graphw},IN,{0})
		/*
		k = strlen({src})	
		for (l=k; l>0; l=l-1) 
			char=substring({src},{l},{l})
			if (strcmp({char},"/")==0)
				break
			end
		end
		if (strcmp({fieldpath},".") == 0) //plot is not a subelement
			oldplot = {src}
		else
			l = l - 1
			oldplot = substring({src},0,{l})
		end
        name = {get({oldplot},name)}+ {get({oldplot},index)}+{field}
        name = {get({oldplot},name)}+"["+{get({oldplot},index)}+"]"
		*/
		/*
		*/
		oldplot = {src}
		if (strcmp({fieldpath},".") != 0) //plot is a subelement
			for (k = 0 ; k < 5 ; k = k + 1)
				oldplot = {EL({oldplot}/..)}
				otype = get({oldplot},object->name)
				if (({strcmp({otype},compartment)} == 0) || ({strcmp({otype},symcompartment)} == 0))
					break
				end
			end
		end
        name = {get({oldplot},name)}+"["+{get({oldplot},index)}+"]"
    	sendmsg {src} {graphw} PLOT {field} *{name} *hot{col}
		set {draww}/Tr{name} pixcolor "hot"{col}
    end
end

function do_spike(num)
	str num
	str compt = get({cellpath}xout{num}/draw,value)
	str channame = get(/cell_run_control/"Syn Type",value)
	str chanpath = {compt} + "/" + {channame}
	float temp1,temp2,act
	click_site({num})

	if (!{exists({chanpath})})
		echo channel '{chanpath}' does not exist
		return
	end

	temp1 = get(/cell_run_control/"Weight of spike",value)
	if (strcmp({get({chanpath},object->name)},manuelconduct) == 0)
    	temp2 = get({chanpath},Z)
		act = temp2 + temp1
    	set {chanpath} Z {act}
	else	// it is a channelC or channelC2 object
    	temp2 = get({chanpath},xconst1)
    	act = temp1 * temp2
    	temp1 = get({chanpath},xconst2)
    	temp2 = get({chanpath},X)
    	act = act + temp1 * temp2
    	set {chanpath} X {act}
	end
    echo delivering spike to '{chanpath}'
end

function do_unspike(num)
	str num
	str compt = get({cellpath}xout{num}/draw,value)
	str channame = get(/cell_run_control/"Syn Type",value)
	str chanpath = {compt} + "/" + {channame}
	click_site({num})

	if (!{exists({chanpath})})
		echo channel '{chanpath}' does not exist
		return
	end
    set {chanpath} X 0.0
    set {chanpath} Y 0.0
end

function do_act(num)
	str num
	str draww = {cellpath} + "xout" + {num} + "/draw"
	str compt = get({draww},value)
	str channame = get(/cell_run_control/"Syn Type",value)
	str chanpath = {compt} + "/" + {channame}
	str iname = get({compt},name) + get({compt},index)
	float act
	click_site({num})

	if (!{exists({chanpath})})
		echo channel '{chanpath}' does not exist
		return
	end

    act = get(/cell_run_control/"Amount of synaptic activation",value)

	push {draww}
	if (!{exists(act{channame}{iname})})
    	if (exists(/xproto/draw/act{channame}))
    		copy /xproto/draw/act{channame} act{channame}{iname}
		else
    		copy /xproto/draw/actACh act{channame}{iname}
		end
    	set {draww}/act{channame}{iname} \
        	tx {get({compt},x)} ty {get({compt},y)} tz {get({compt},z)}
		create neutral act{channame}{iname}/dummy
		sendmsg act{channame}{iname}/dummy {chanpath} ACTIVATION z
	end
   	echo setting activation on {chanpath} to {act}
	set act{channame}{iname}/dummy z {act}
	pop
end

function do_unact(num)
	str num
	str draww = {cellpath} + "xout" + {num} + "/draw"
	str compt = get({draww},value)
	str channame = get(/cell_run_control/"Syn Type",value)
	str chanpath = {compt} + "/" + {channame}
	str iname = get({compt},name) + get({compt},index)
	click_site({num})

	if (!{exists({chanpath})})
		echo channel '{chanpath}' does not exist
		return
	end

	push {draww}
	if (exists(act{channame}{iname}))
		delete act{channame}{iname}
	else
		echo no activation has been set on {channame}
	end
	pop
end

function do_rand(num)
	str num
	str draww = {cellpath} + "xout" + {num} + "/draw"
	str compt = get({draww},value)
	str channame = get(/cell_run_control/"Syn Type",value)
	str chanpath = {compt} + "/" + {channame}
	str iname = get({compt},name) + get({compt},index)
	float rate,weight
	click_site({num})

	if (!{exists({chanpath})})
		echo channel '{chanpath}' does not exist
		return
	end

	push {draww}

    if ({exists(rand{channame}{iname})})
		echo rand input already being sent to {chanpath}
		pop
		return
	end
    connect /stimulus/axon to {chanpath} with synapse
    set /stimulus/axon:0 \
		weight {get(/cell_run_control/"Spike weight",value)}
	set /stimulus/rand \
		rate {get(/cell_run_control/"Spike rate (Hz)",value)}
   	if (exists(/xproto/draw/rand{channame}))
    	copy /xproto/draw/rand{channame} rand{channame}{iname}
	else
    	copy /xproto/draw/randACh rand{channame}{iname}
	end
    set rand{channame}{iname} \
        tx {get({compt},x)} ty {get({compt},y)} tz {get({compt},z)}
    echo delivering rand spikes to '{chanpath}'
	pop
end

function do_unrand(num)
	str num
	str draww = {cellpath} + "xout" + {num} + "/draw"
	str compt = get({draww},value)
	str channame = get(/cell_run_control/"Syn Type",value)
	str chanpath = {compt} + "/" + {channame}
	str iname = get({compt},name) + get({compt},index)
	click_site({num})

	if (!{exists({chanpath})})
		echo channel '{chanpath}' does not exist
		return
	end

	push {draww}
    if ({exists(rand{channame}{iname})})
            echo deleting random spike input to {chanpath}
            delete_connection /stimulus/axon {chanpath}
            delete rand{channame}{iname}
	end
	pop
end

function setup_mouse(draw,x,y,but1,func1,but2,func2,but3,func3)
	str draw,but1,but2,but3,func1,func2,func3
	int	x,y

	if ({exists({draw})} == 0)
		le /
		le {cellpath}xout
		echo draw widget '{draw}' does not exist.
		return
	end

	/*
	x = get({draw},x) + x
	y = get({draw},y) + y
	*/

	if (!{exists({draw}/../MOUSE)})
		push {draw}/..
		create xlabel MOUSE [{x},{y},250,32] \
			-title "MOUSE                          "
	else
		push {draw}/..
	end

	if (!{exists({but1})})
		create xbutton {but1} [{x + 70},{y + 2},50,25]
	end

	if (!{exists({but2})})
		create xbutton {but2} [{x + 136},{y + 2},50,25]
	end
	if (!{exists({but3})})
		create xbutton {but3} [{x + 204},{y + 2},50,25]
	end

	dropwhen {draw} all
	when {draw} click1 do {func1}
	when {draw} click2 do {func2}
	when {draw} click3 do {func3}

	pop
end

function select_mouse(draw,but1,func1,but2,func2,but3,func3)
	str draw,but1,but2,but3
	str func1,func2,func3

	if (!{exists({draw})})
		echo draw widget '{draw}' does not exist.
		return
	end

	push {draw}/..

	if ({exists({but1})} && {exists({but2})} && {exists({but3})})
		xraise {but1}
		xraise {but2}
		xraise {but3}

		dropwhen {draw} all
		when {draw} click1 do {func1}
		when {draw} click2 do {func2}
		when {draw} click3 do {func3}
	end
	pop
end

function scalecell(cell)
    str cell

    int x,y,w
    str temp

    temp = get({cell}/..,form)
    x = get({temp},x)
    y = get({temp},y)
    w = get({temp},width)

    create xform {cell}_scale -title Scale [{x},{y},200,415]
    create xbutton {cell}/scale [0,0,40,20] \
        -script "disp_cellscale "{cell}

    push {cell}_scale
    create xdialog colfield -value {get({cell},colfield)}
    create xdialog fatfield -value {get({cell},fatfield)}
    create xdialog colmin -value {get({cell},colmin)}
    create xdialog colmax -value {get({cell},colmax)}
    create xdialog fatmin -value {get({cell},fatmin)}
    create xdialog fatmax -value {get({cell},fatmax)}

    create xtoggle autocol [1%,3,48%,20] \
        -widgets [NULL,fatmax.bottom,NULL,NULL] -state 0
    set autocol label0 "Autocol OFF" label1 "Autocol ON"

    create xtoggle colfix [51%,3,48%,20] \
        -widgets [NULL,fatmax.bottom,NULL,NULL] -state 0
    set colfix label0 "Colfix OFF" label1 "Colfix ON"

    create xtoggle autofat [1%,3,48%,20] \
        -widgets [NULL,autocol.bottom,NULL,NULL] -state 0
    set autofat label0 "Autofat OFF" label1 "Autofat ON"

    create xtoggle fatfix [51%,3,48%,20] \
        -widgets [NULL,autocol.bottom,NULL,NULL] -state 1
    set fatfix label0 "Fatfix OFF" label1 "Fatfix ON" state 1

    create xdialog fatrange -value {get({cell},fatrange)}
    create xdialog fieldpath -value {get({cell},fieldpath)}
    create xbutton APPLY -script "applycellscale "{cell}" "{cell}_scale" 0"
    create xbutton APPLY_AND_VANISH -script "applycellscale "{cell}" "{cell}_scale" 1"

    pop
end


function disp_cellscale(cell)
    str cell
    push {cell}_scale

    set colmin value {get({cell},colmin)}
    set colmax value {get({cell},colmax)}
    set fatmin value {get({cell},fatmin)}
    set fatmax value {get({cell},fatmax)}
    pop
    xshow_on_top {cell}_scale
end

function set_cell_flag(cell,flagname,flag)
    str cell,flagname
    int flag
    str state = "FALSE"

    if (flag == 1)
        state = "TRUE"
    end
    if (strcmp({state},{get({cell},{flagname})}) != 0)
        set {cell} {flagname} {state}
    end
end

function applycellscale(cell,cellscale,hide)
    str cell,cellscale
    int hide

    str colfield,fatfield,fieldpath
    float colmin,colmax,fatmin,fatmax,fatrange
    int autofat,autocol,fatfix,colfix

	int l =strlen({cellpath}) + 4
	str num = substring({cell},{l},{l})
	str graphw = {cellpath} + "graph" + {num} + "/graph"
    int nmsgs,i
    str field = get({cell},colfield)
    str path,oldplot,src,name,char
	str col

    push {cellscale}
    colfield = get(colfield,value)
    fatfield = get(fatfield,value)
    fieldpath = get(fieldpath,value)
    autocol = get(autocol,state)
    autofat = get(autofat,state)
    colfix = get(colfix,state)
    fatfix = get(fatfix,state)
    colmin = get(colmin,value)
    colmax = get(colmax,value)
    fatmin = get(fatmin,value)
    fatmax = get(fatmax,value)
    fatrange = get(fatrange,value)
    if ((strcmp({colfield},{field}) != 0) || \
    	(strcmp({fatfield},{get({cell},fatfield)}) != 0) || \
    	(strcmp({fieldpath},{get({cell},fieldpath)}) != 0))
    	nmsgs = getmsg({graphw},IN,-count)
    	for ( i = 0 ; i < nmsgs ; i = i + 1)
        	src = getmsg({graphw},IN,{0},src)
        	deletemsg({graphw},IN,{0})
    	end
		foreach name ({element_list({cell}/../Tr#[])})
        	oldplot = {substring({get({name},name)},2)}+"["+{get({name},index)}+"]"
			col = get({name},pixcolor)
    		path = {cellpath} + "/" + {oldplot} + "/" + {fieldpath}
			if ({exists({path})})
    			sendmsg {path} {graphw} PLOT {colfield} *{oldplot} *{col}
			end
		end
        set {cell} colfield {colfield}
        set {cell} fatfield {fatfield}
        set {cell} fieldpath {fieldpath}
		set {graphw} YUnits {fieldpath}:{colfield}
    end

    set_cell_flag({cell},autofat,{autofat})
    set_cell_flag({cell},autocol,{autocol})
    set_cell_flag({cell},colfix,{colfix})
    set_cell_flag({cell},fatfix,{fatfix})

    if (autocol == 0)
        if (colmin != {get({cell},colmin)})
            set {cell} colmin {colmin}
        end
        if (colmax != {get({cell},colmax)})
            set {cell} colmax {colmax}
        end
    end
    if (autofat == 0)
        if (fatmin != {get({cell},fatmin)})
            set {cell} fatmin {fatmin}
        end
        if (fatmax != {get({cell},fatmax)})
            set {cell} fatmax {fatmax}
        end
    end
    if (fatrange != {get({cell},fatrange)})
        set {cell} fatrange {fatrange}
    end


    if (hide)
        xhide {cellscale}
    end
end

function do_xout(num)
	str num

	str draww = {cellpath} + "xout" + {num} + "/draw"
	int xoutwidth = (user_screenwidth - 380)/2
	if (strcmp({num},"1")==0)
		if ({user_numxouts}==1)
			create xform {cellpath}xout1 [380,50,600,470]
		else
			create xform {cellpath}xout1 [380,50,{xoutwidth},470]
		end
	else
		create xform {cellpath}xout2 [{380+xoutwidth},50,{xoutwidth},470]
	end
	push {cellpath}xout{num}
	disable .
	create xlabel "CELL GEOMETRY" [1%,2,70%,30] 
	create xdraw draw [1%,2,98%,2] \
		-widgets [NULL,NULL,NULL,NULL.bottom] \
     	-wx {1.4e-3} -wy {1.4e-3} -cz 0.2e-3 \
	 	-vx 10 -vy -15 -vz 7 -transform ortho3d
	set ^ wx {user_wx} wy {user_wy} cx {user_cx} cy {user_cy} cz {user_cz}
	if ({user_symcomps})
		create xcell draw/cell -path {cellpath}/##[TYPE=symcompartment] \
			-fatfield dia -colfield Vm -autocol FALSE \
			-colmin -0.1  -colmax 0.05 
	else
		create xcell draw/cell -path {cellpath}/##[TYPE=compartment] \
			-fatfield dia -colfield Vm -autocol FALSE \
			-colmin -0.1  -colmax 0.05
	end
	if (strcmp({num},"1")==0)
		set {draww}/cell	fatrange {user_fatrange1} \
					fieldpath {user_path1} \
					colfield {user_field1} \
                            colmax {user_colmax1} \
                            colmin {user_colmin1} \
                            labelmode none \
					rooticon none
    	set_cell_flag({cellpath}xout1/draw/cell,colfix,{user_colfix1})
    	set_cell_flag({cellpath}xout1/draw/cell,fatfix,{user_fatfix1})
	else
		set {draww}/cell	fatrange {user_fatrange2} \
					fieldpath {user_path2} \
					colfield {user_field2} \
                            colmax {user_colmax2} \
                            colmin {user_colmin2} \
                            labelmode none \
					rooticon none
    	set_cell_flag({cellpath}xout2/draw/cell,colfix,{user_colfix2})
    	set_cell_flag({cellpath}xout2/draw/cell,fatfix,{user_fatfix2})
	end
   	scalecell({draww}"/cell")

   	setup_mouse({draww},50,0,inject, \
		"do_inject "{num},unject,"clear_inject "{num},dummy,do_dummy)
	setup_mouse({draww},50,0,Vclamp, \
		"do_vclamp "{num},unclamp,"clear_vclamp "{num},dummy,do_dummy)
   	setup_mouse({draww},50,0,add_plot, \
		"add_plot "{num},drop_plot,"drop_plot "{num},dummy,do_dummy)
	setup_mouse({draww},50,0,RandSyn, \
		"do_rand "{num},UnRand,"do_unrand "{num},dummy,do_dummy)
	setup_mouse({draww},50,0,SynAct, \
		"do_act "{num},UnAct,"do_unact "{num},dummy,do_dummy)
	setup_mouse({draww},50,0,SynSpike, \
		"do_spike "{num},UnSpike,"do_unspike "{num},dummy,do_dummy)
	useclock draw/cell 9
//	draw_control draw 0 0
	pop
end


