//genesis


function create_lib_infrastructure
	create neutral /buffer
	create neutral /buffer/temp
end

function create_lib(libname)
	str libname

	create xform /{libname}_form [0,50,480,370] -nolabel
	disable /{libname}_form
	create xdraw /{libname}_form/draw [0,0,100%,300] -wx 20 -wy 20 \
		-cx 7 -cy 8
	set /{libname}_form/draw refresh_flag FALSE
	setup_mouse(/{libname}_form/draw,0,0,select,"do_lib_select "{libname},dummy,do_dummy,delete,"do_lib_delete "{libname})
	copy /xproto/draw/hilight /{libname}_form/draw
	create neutral /{libname}
	disable /{libname}
	create xdialog /{libname}_form/sel -script "do_lib_rename "{libname}
	create xtoggle /{libname}_form/auto_rename
	set ^		label0	"Use sel name when pasting" \
				label1	"Do Rall renaming"
end

/*
** add_to_lib : Assumes that the element being added already lives on
** its own neutral carrier which has been named appropriately
*/
function add_to_lib(libname,elm,icon)
	str libname
	str elm
	str icon
	str temp
	int nkids = 0
	str iname = get({elm},name) + "[" + get({elm},index) + "]"
	int x

	if (exists(/{libname}/{iname}))
		delete /{libname}/{iname}
	else
		// copy icon over
		// find how many items in this library
		foreach temp ({element_list(/{libname}/#)})
			nkids = nkids + 1
		end
		copy /xproto/draw/{icon} /{libname}_form/draw/{iname}
		x = 3 * (nkids%6) 
		set /{libname}_form/draw/{iname} \
			text	{iname} \
			tx		{x} \
			ty		{nkids/2.0} \
			value	/{libname}/{iname}
	
		xupdate /{libname}_form/draw
	end

	move {elm} /{libname}/{iname}
end

function move_from_lib(libname,elm,dest)
	str libname
	str elm
	str dest
	str iname = get({elm},name) + get({elm},index)
	int nkids = 0
	str temp

	move {elm} {dest}
	delete /{libname}_form/draw/{iname}

	foreach temp ({element_list(/{libname}_form/draw/#)})
		nkids = nkids + 1
		set {temp} \
			tx		{2 * (nkids%4) - 3} \
			ty		{2 * (nkids/4)}
	end

	xupdate /{libname}_form/draw
end

function do_lib_select(libname)
	str libname
	str selname = get(/{libname}_form/draw,value)
	str iname = get({selname},name) + "[" + get({selname},index) + "]"

	push /{libname}_form
	selname = "draw/" + {iname}
	set draw/hilight tx {get({selname},tx)} ty {get({selname},ty)}
	set sel value {get(draw,value)}
	xupdate draw
	pop
end


function do_lib_delete(libname)
	str libname
	str selname = get(/{libname}_form/draw,value)
	str iname = get({selname},name) + "[" + get({selname},index) + "]"

	delete {selname}
	delete /{libname}_form/draw/{iname}
	xupdate /{libname}_form/draw
end


/*
** function do_rename(fullname,new_name,index)
**
** This function traverses the message heirarchy in a cell and renames
** the elements according to Rall's convention, building on the 
** core 'new_name'. Array indices in root names are not 'built on', so
** xy12[3] would have children xy121 and xy122. When there is only
** one child of a given element, it assumes that it is part of a branch
** and uses array indices with the same core name, eg xy12[0],xy12[1]..
** The routine may fail if any new name overlaps existing ones.
*/
function do_rename(fullname,new_name,index)
	str fullname
	str new_name
	int index

	str dst
	int nmsgs,i
	str child
	int nkids = 0
	int kidno = 1
	str skidno
	str kidname
	str sindex

	sindex = index
	
	ce {fullname}/..
	dst = {new_name} + "[" + {sindex} + "]"
	if ({exists({dst})})
		echo do_rename failed at duplicated name '{dst}'
		return
	end

	nmsgs = getmsg({fullname},IN,-count)
	for(i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({fullname},IN,{i},type)},RAXIAL) == 0)
			nkids = nkids + 1
		end
	end
	for(i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({fullname},IN,{i},type)},RAXIAL) == 0)
			child = getmsg({fullname},IN,{i},src)
			if ({nkids} > 1)
				skidno = kidno
				kidname = {new_name} + {skidno}
				kidno = kidno + 1
				do_rename {child} {kidname} 0
			else
				do_rename {child} {new_name} {index + 1}
			end
		end
	end

//	echo move {fullname} {dst}
	move {fullname} {dst}
	ce /
end

function do_child_rename(orig,dst)
	str orig,dst

	str newname
	int nmsgs,i,nkids = 0
	int dstindex = get({dst},index)
	str dstname = get({dst},name)
	int kidindex
	str skidindex
	str kidname

	nmsgs = getmsg({dst},IN,-count)
	for(i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({dst},IN,{i},type)},RAXIAL) == 0)
			nkids = nkids + 1
		end
	end

	if (nkids == 0)
		kidindex = 1 + dstindex
		kidname = dstname
	end
	if (nkids > 0)
		kidindex = 0
		kidname = {dstname} + {nkids}
	end

	do_rename({orig},{kidname},{kidindex})

	skidindex = {kidindex}
	newname = {kidname} + "[" + {skidindex} + "]"
	return({newname})
end



function do_lib_rename(libname)
	str libname

	str newelm = get(/{libname}_form/sel,value)
	str oldelm = get(/{libname}_form/draw,value)
	str oldiname = get({oldelm},name) + "[" + get({oldelm},index) + "]"

	move {oldelm} {newelm}
	str iname = get({newelm},name) + "[" + get({newelm},index) + "]"

	// This is where the Rall renaming routine fits in
	if (strcmp({get({newelm}/{oldiname},object->name)},"compartment") == 0)
		//	function do_rename(fullname,new_name,index)
		do_rename({newelm}/{oldiname},{get({newelm},name)}, \
			{get({newelm},index)})
	else
		move {newelm}/{oldiname} {newelm}/{iname}
	end

	move /{libname}_form/draw/{oldiname} /{libname}_form/draw/{iname}

	set /{libname}_form/draw/{iname}	value /{libname}/{iname} \
										text {iname}
	set /{libname}_form/draw value /{libname}/{iname}

	xupdate /{libname}_form/draw
end


/*
** function subtree_copy(src,dst)
**
** copies the subtree off src to the directory dst, including
** all messages (I hope !). This is done in a sly way, by 
** moving all the originals to a temporary element, then
** copying that element to the dst element, then moving
** the originals back. This convoluted approach is necessary because
** somewhere along the line I made the design decision to put
** all the compartments in the same directory.
*/
function subtree_move(src,dst)
	str src,dst

	int nmsgs,i
	str child

	nmsgs = getmsg({src},IN,-count)

	for(i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({src},IN,{i},type)},RAXIAL) == 0)
			child = getmsg({src},IN,{i},src)
			subtree_move {child} {dst}
		end
	end
	move {src} {dst}
end

function reposition_elm(src,dupli)
	str src,dupli

	str parent_dend
	float x,y,z
	int nmsgs,i

	if (strcmp({get({src},object->name)},"compartment") == 0)
        nmsgs = getmsg({src},IN,-count)
        for (i = 0 ; i < nmsgs ; i = i + 1)
            if (strcmp({getmsg({src},IN,{i},type)},AXIAL) == 0)
                parent_dend = getmsg({src},IN,{i},src)
				break
            end
        end
		if (!{exists({parent_dend})})
			return
		end
        x = {get({parent_dend},x)}
        y = {get({parent_dend},y)}
        z = {get({parent_dend},z)}
		position {dupli} R{-x} R{-y} R{-z}
	end
end


function glue_kids(src)
	str src

	str parent_dend
	str kid
	float x,y,z,temp
	int nmsgs,i

	if (strcmp({get({src},object->name)},"compartment") == 0)
        nmsgs = getmsg({src},IN,-count)
        for (i = 0 ; i < nmsgs ; i = i + 1)
            if (strcmp({getmsg({src},IN,{i},type)},AXIAL) == 0)
                parent_dend = getmsg({src},IN,{i},src)
				break
            end
        end
        x = {get({parent_dend},x)}
        x = x - {get({src},x)}
        y = {get({parent_dend},y)}
        y = y - {get({src},y)}
        z = {get({parent_dend},z)}
        z = z - {get({src},z)}
        nmsgs = getmsg({src},IN,-count)
        for (i = 0 ; i < nmsgs ; i = i + 1)
            if (strcmp({getmsg({src},IN,{i},type)},RAXIAL) == 0)
                kid = getmsg({src},IN,{i},src)
				rel_position {kid} {x} {y} {z}
				sendmsg {parent_dend} {kid} AXIAL	Vm
				sendmsg {kid} {parent_dend} RAXIAL	Ra Vm
            end
        end
	end
end


function copy_to_lib(libname,src,mode)
	str libname
	str src
	int mode

	str icon = getobjenv({get({src},object->name)},ICON)
	str parent
	str elmname = {get({src},name)} + "[" + {get({src},index)} + "]"

	parent = EL({src}/..)

	if ({exists(/buffer/temp2)})
		delete /buffer/temp2
	end

	if (mode == 0) // copy element and its direct kids only
		create neutral /buffer/temp2
		copy {src} /buffer/temp2
	else // copy entire subtree
		subtree_move {src} /buffer/temp
		copy /buffer/temp /buffer/temp2
		// moving original back to where it came from
		subtree_move /buffer/temp/{elmname} {parent}
	end
	// repositioning elm if it is a compt, to compensate for parent
	reposition_elm({src},/buffer/temp2)
	// Need to put in routine to inspect source elm type for icon
	// renaming temp2 correctly
	move /buffer/temp2 /buffer/{elmname}
	// moving copy to library
	add_to_lib({libname},/buffer/{elmname},{icon})
end

function cut_to_lib(libname,src,mode)
	str libname
	str src
	int mode

	str icon = getobjenv({get({src},object->name)},ICON)
	str elmname = {get({src},name)} + "[" + {get({src},index)} + "]"

	if ({exists(/buffer/temp2)})
		delete /buffer/temp2
	end

	if (mode == 0) // need to put in glue stuff for later compts
		glue_kids({src})
		move {src} /buffer/temp
		copy /buffer/temp /buffer/temp2
		// repositioning elm if it is a compt, to compensate for parent
		reposition_elm(/buffer/temp,/buffer/temp2)
		delete /buffer/temp
		create neutral /buffer/temp
	else
		subtree_move {src} /buffer/temp
		copy /buffer/temp /buffer/temp2
		// repositioning elm if it is a compt, to compensate for parent
		reposition_elm(/buffer/temp,/buffer/temp2)
		//	getting rid of original
		delete /buffer/temp
		create neutral /buffer/temp
	end
	// moving copy to library
	// renaming temp2 correctly
	move /buffer/temp2 /buffer/{elmname}
	add_to_lib({libname},/buffer/{elmname},{icon})
end
