//genesis

function do_xcompt_funcs

	int channo

	create xform /compt_params [480,440,520,450] -nolabel
	ce ^
	disable .
	create xlabel "COMPARTMENT PARAMETERS"
	create xdialog "Selected Compartment" -value {comptpath}
	create xdialog "Parent Compartment"
	create xlabel "Electrical properties"
	create xdialog "Membrane resistance (Ohms)" \
		-script "set_Rm "<widget>
	create xdialog "Axial resistance (Ohms)" -script "set_Ra "<widget>
	create xdialog "Membrane capacitance (Farads)" \
		-script "set_Cm "<widget>
	create xlabel "Constants"
	create xdialog "Membrane Resistivity (Ohm m^2)" \
		-script "set_RM "<widget>
	create xdialog "Axial Resistivity (Ohm m)" -script "set_RA "<widget>
	create xdialog "Membrane Capacitance (F m^-2)" \
		-script "set_CM "<widget>
	create xlabel Geometry \
		-title "Compartment Geometry. All values in microns"
	create xdialog Length -value 0 -script "set_len "<widget> \
		[2%,3,47%,30] -widgets [NULL,Geometry.bottom,NULL,NULL]
	create xdialog Diameter -value 1 -script "set_dia "<widget> \
		[51%,3,47%,30] -widgets [NULL,Geometry.bottom,NULL,NULL]
	create xdialog x -script "set_x "<widget> \
		[2%,36,30%,30] -widgets [NULL,Geometry.bottom,NULL,NULL]
	create xdialog y -script "set_y "<widget> \
		[34%,36,32%,30] -widgets [NULL,Geometry.bottom,NULL,NULL]
	create xdialog z -script "set_z "<widget> \
		[68%,36,30%,30] -widgets [NULL,Geometry.bottom,NULL,NULL]
end

function find_parent(compt)
	str compt
	int i,nmsgs

	nmsgs = getmsg({compt},IN,-count)
	for (i = 0 ; i < nmsgs ; i = i + 1)
		if (strcmp({getmsg({compt},IN,{i},type)},AXIAL) == 0)
			return({getmsg({compt},IN,{i},src)})
		end
	end
	return("none")
end

function calc_len(compt)
	str compt

	str parent
	float len,l1,l2,Ra,Rm,dia

	parent = find_parent({compt})
	if (strcmp({parent},none) == 0)
		dia = get({compt},dia)
		if (dia > 0.0) 
			len = get({compt},Cm)
			len = len/(CM * PI * dia)
			return({len})
		else
			Rm = get({compt},Rm)
			Ra = get({compt},Ra)
			len = RM * RM * Ra / (4 * PI * RA * Rm * Rm)
			len = log({len})
			len = exp({len/3})
			return({len})
		end
	end
	l1 = get({compt},x)
	l2 = get({parent},x)
	len = (l1 -l2) * (l1 - l2)

	l1 = get({compt},y)
	l2 = get({parent},y)
	len = len + (l1 -l2) * (l1 - l2)

	l1 = get({compt},z)
	l2 = get({parent},z)
	len = len + (l1 -l2) * (l1 - l2)

	len = sqrt({len})

	return({len})
end

function calc_dia(compt)
	str compt

	float dia,len,res,cap

	dia = get({compt},dia)
	if (dia <= 0.0)
		len = calc_len({compt})
		cap = get({compt},Cm)
		res = get({compt},Rm)
		dia = RM / (res * len * PI)
	//	dia = cap / (CM * len * PI)
	end
	return({dia})
end

function update_compt_params
	float temp
	push /compt_params

	// Compartment identifiers
	set "Selected Compartment" value {comptpath}
	set "Parent Compartment" value {find_parent({comptpath})}

	// Electrical properties
	set "Membrane resistance (Ohms)" value {get({comptpath},Rm)}
	set "Axial resistance (Ohms)" value {get({comptpath},Ra)}
	set "Membrane capacitance (Farads)" value {get({comptpath},Cm)}

	// Electrical Constants
	set "Membrane Resistivity (Ohm m^2)" value {RM}
	set "Axial Resistivity (Ohm m)" value {RA}
	set "Membrane Capacitance (F m^-2)" value {CM}

	// Geometry
	temp = calc_len({comptpath})
	set Length value {temp * 1e6}
	temp = calc_dia({comptpath})
	set Diameter value {temp * 1e6}
	temp = get({comptpath},x)
	set x value {temp * 1e6}
	temp = get({comptpath},y)
	set y value {temp * 1e6}
	temp = get({comptpath},z)
	set z value {temp * 1e6}
	pop
end

function set_Rm(widget)
	str widget
	set {comptpath} Rm {get({widget},value)}
end

function set_Ra(widget)
	str widget
	set {comptpath} Ra {get({widget},value)}
end

function set_Cm(widget)
	str widget
	set {comptpath} Cm {get({widget},value)}
end

function set_RM(widget)
	str widget
	RM = get({widget},value)
end

function set_RA(widget)
	str widget
	RA = get({widget},value)
end

function set_CM(widget)
	str widget
	CM = get({widget},value)
end

function set_len(widget)
	str widget
	str parent
	float len,old_len,ratio
	float dx,dy,dz,temp

	old_len = calc_len({comptpath})
	len = get({widget},value)
	len = len / 1e6
	if (len <= 0)
		echo Invalid compartment length 
		return
	end
	ratio = len/old_len

	// Setting electrical properties
	temp = get({comptpath},Rm)
	set {comptpath} Rm {temp / ratio}
	temp = get({comptpath},Ra)
	set {comptpath} Ra {temp * ratio}
	temp = get({comptpath},Cm)
	set {comptpath} Cm {temp * ratio}

	// Setting geometry
	parent = find_parent({comptpath})
	if ({strcmp({parent},none)} == 0) // changing soma only
		update_compt_params
		return
	end

	temp = get({parent},x)
	dx = get({comptpath},x)
	dx = (dx - temp) * (ratio - 1)
	temp = get({parent},y)
	dy = get({comptpath},y)
	dy = (dy - temp) * (ratio - 1)
	temp = get({parent},z)
	dz = get({comptpath},z)
	dz = (dz - temp) * (ratio - 1)

	do_rel_position {comptpath} {dx} {dy} {dz}

	update_compt_params
	if ({user_symcomps})
		set /compt_select/draw/cell path {cellpath}/##[TYPE=symcompartment]
	else
		set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
	end
end

function set_dia(widget)
	str widget
	float dia,old_dia,ratio
	float dx,dy,dz,temp

	old_dia = calc_dia({comptpath})
	dia = get({widget},value)
	dia = dia / 1e6
	if (dia <= 0)
		echo Invalid compartment diameter 
		return
	end
	ratio = dia/old_dia

	// Setting electrical properties
	temp = get({comptpath},Rm)
	set {comptpath} Rm {temp / ratio}
	temp = get({comptpath},Ra)
	set {comptpath} Ra {temp / (ratio * ratio)}
	temp = get({comptpath},Cm)
	set {comptpath} Cm {temp * ratio}
	set {comptpath} dia {dia}

	update_compt_params
	if ({user_symcomps})
		set /compt_select/draw/cell path {cellpath}/##[TYPE=symcompartment]
	else
		set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
	end
end

function set_x(widget)
	str widget
	float len,old_len,ratio,temp
	float oldx,newx,dx

	old_len = calc_len({comptpath})
	newx = get({widget},value)
	newx = newx / 1e6
	oldx = get({comptpath},x)
	dx = newx - oldx
	do_rel_position {comptpath} {dx} 0 0 

	len = calc_len({comptpath})
	if (len <= 0)
		echo Invalid compartment length 
		return
	end
	ratio = len/old_len

	// Setting electrical properties
	temp = get({comptpath},Rm)
	set {comptpath} Rm {temp / ratio}
	temp = get({comptpath},Ra)
	set {comptpath} Ra {temp * ratio}
	temp = get({comptpath},Cm)
	set {comptpath} Cm {temp * ratio}

	// updating the screen
	update_compt_params
	if ({user_symcomps})
		set /compt_select/draw/cell path {cellpath}/##[TYPE=symcompartment]
	else
		set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
	end
end

function set_y(widget)
	str widget
	float len,old_len,ratio,temp
	float oldy,newy,dy

	old_len = calc_len({comptpath})
	newy = get({widget},value)
	newy = newy / 1e6
	oldy = get({comptpath},y)
	dy = newy - oldy
	do_rel_position {comptpath} 0 {dy} 0 

	len = calc_len({comptpath})
	if (len <= 0)
		echo Invalid compartment length 
		return
	end
	ratio = len/old_len

	// Setting electrical properties
	temp = get({comptpath},Rm)
	set {comptpath} Rm {temp / ratio}
	temp = get({comptpath},Ra)
	set {comptpath} Ra {temp * ratio}
	temp = get({comptpath},Cm)
	set {comptpath} Cm {temp * ratio}

	// updating the screen
	update_compt_params
	if ({user_symcomps})
		set /compt_select/draw/cell path {cellpath}/##[TYPE=symcompartment]
	else
		set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
	end
end

function set_z(widget)
	str widget
	float len,old_len,ratio,temp
	float oldz,newz,dz

	old_len = calc_len({comptpath})
	newz = get({widget},value)
	newz = newz / 1e6
	oldz = get({comptpath},z)
	dz = newz - oldz
	do_rel_position {comptpath} 0 0 {dz}

	len = calc_len({comptpath})
	if (len <= 0)
		echo Invalid compartment length 
		return
	end
	ratio = len/old_len

	// Setting electrical properties
	temp = get({comptpath},Rm)
	set {comptpath} Rm {temp / ratio}
	temp = get({comptpath},Ra)
	set {comptpath} Ra {temp * ratio}
	temp = get({comptpath},Cm)
	set {comptpath} Cm {temp * ratio}

	// updating the screen
	update_compt_params
	if ({user_symcomps})
		set /compt_select/draw/cell path {cellpath}/##[TYPE=symcompartment]
	else
		set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
	end
end

