//genesis

int kincolor = 15

function do_xchannel_funcs
	create xform /channel_params [480,440,{user_screenwidth - 480},450]
	disable /channel_params
	push /channel_params
	create xgraph alpha [0,0,50%,42%] -range [-0.1,0,0.1,1]
	set alpha ymin 0 overlay 0 XUnits Volts YUnits "1/sec"
	create xgraph beta [50%,0,50%,42%] -range [-0.1,0,0.1,1]
	set beta ymin 0 overlay 0 XUnits Volts YUnits "1/sec"
	create xgraph taus	[0,42%,50%,42%] -range [-0.1,0,0.1,1]
	set taus ymin 0 overlay 0 XUnits Volts YUnits "sec"
	create xgraph minf	[50%,42%,50%,42%] -range [-0.1,0,0.1,1]
	set minf ymin 0 overlay 0 XUnits Volts YUnits "minf"
	create xdialog gate [4,4,19%,30] \
		-widgets [NULL,minf.bottom,NULL,NULL] -value "X" \
		-script "do_plot_kinetics "<widget>
	create xtoggle overlay [20%,4,19%,30] \
		-widgets [NULL,minf.bottom,NULL,NULL]
	set ^ label0 "overlay off" label1 "overlay on"
	create xlabel MODIFY [40%,4,11%,30] -title "MODIFY:" \
		-widgets [NULL,minf.bottom,NULL,NULL]
	create xbutton alphabutton [52%,4,11%,30] -title alpha \
		-widgets [NULL,minf.bottom,NULL,NULL] \
		-script "scale_gate alpha"
	create xbutton betabutton [64%,4,11%,30] -title beta \
		-widgets [NULL,minf.bottom,NULL,NULL] \
		-script "scale_gate beta"
	create xbutton taubutton [76%,4,11%,30] -title tau \
		-widgets [NULL,minf.bottom,NULL,NULL] \
		-script "scale_gate tau"
	create xbutton minfbutton [88%,4,11%,30] -title m_inf \
		-widgets [NULL,minf.bottom,NULL,NULL] \
		-script "scale_gate minf"

	create xbutton duplicate [4,4,9%,30] -title "Dup Gate" \
		-widgets [NULL,overlay.bottom,NULL,NULL] \
		-script dup_gate
	create xbutton restore [10%,4,9%,30] -title "Restore" \
		-widgets [NULL,overlay.bottom,NULL,NULL] \
		-script "echo Not yet implemented"
	create xdialog sx [20%,4,19%,30] -value 1.0 \
		-widgets [NULL,overlay.bottom,NULL,NULL]
	create xdialog sy [40%,4,19%,30] -value 1.0 \
		-widgets [NULL,overlay.bottom,NULL,NULL]
	create xdialog ox [60%,4,19%,30] -value 0.0 \
		-widgets [NULL,overlay.bottom,NULL,NULL]
	create xdialog oy [80%,4,19%,30] -value 0.0 \
		-widgets [NULL,overlay.bottom,NULL,NULL]
	pop
end

function calc_cond(name)
	str name
	float len,dia,gmax
	float area = get({comptpath},Cm)

	/*
	len = calc_len({comptpath})
	dia = calc_dia({comptpath})
	*/
	area = area / CM
	if ((strcmp({get({channelpath},object->name)},hh_channel) == 0) || \
		(strcmp({get({channelpath},object->name)},tabchannel) == 0))
		gmax = get({name},Gbar)
	else
		if (strcmp({get({channelpath},object->name)},vdep_channel) == 0)
			gmax = get({name},gbar)
		else
			gmax = get({name},gmax)
		end
	end

	/*
	return({gmax/(len * dia * PI)})

	As a general rule, CM is less likely to be tweaked than RM and RA
	*/
	return({gmax/area})
end

function calc_reversal(name)
	str name
	float rev
	if (strcmp({get({channelpath},object->name)},hh_channel) == 0)
		rev = get({name},Ek)
	else
		rev = get({name},Ek)
	end

	return({rev})
end

function set_cond(widget)
	str widget

	/*
	float len,dia
	*/
	float gmax = get({widget},value)
	float area
	str name, chan
	float temp

	chan = get(/compt_display/draw/{get(/compt_display/draw,pixchoose)},text)
		

	if ({get(/compt_select/scope,state)} == 1) // global
		if ((strcmp({get({channelpath},object->name)},hh_channel) == 0) || (strcmp({get({channelpath},object->name)},tabchannel) == 0))
			foreach name ({EL({cellpath}/#[][activation>0.99])})
				area = get({name},Cm)
				area = area/CM
				temp = gmax * area
				set {name}/{chan} Gbar	{temp}
			end
		else
			if (strcmp({get({channelpath},object->name)},vdep_channel) == 0)
				foreach name ({EL({cellpath}/#[][activation>0.99])})
					area = get({name},Cm)
					area = area/CM
					temp = gmax * area
					set {name}/{chan} gbar	{temp}
				end
			else
				foreach name ({EL({cellpath}/#[][activation>0.99])})
					area = get({name},Cm)
					area = area/CM
					temp = gmax * area
					set {name}/{chan} gmax	{temp}
				end
			end
		end
	else	// local
		area = get({comptpath},Cm)
		area = area/CM
	
		gmax = gmax * area
	
		if ((strcmp({get({channelpath},object->name)},hh_channel) == 0) || (strcmp({get({channelpath},object->name)},tabchannel) == 0))
			set {channelpath} Gbar {gmax}
		else
			if (strcmp({get({channelpath},object->name)},vdep_channel) == 0)
				set {channelpath} gbar {gmax}
			else
				set {channelpath} gmax {gmax}
			end
		end
	end
end

function set_revpotl(widget)
	str widget

	float rev = get({widget},value)
	float area
	str name, chan
	float temp

	chan = get(/compt_display/draw/{get(/compt_display/draw,pixchoose)},text)
	if ({get(/compt_select/scope,state)} == 1) // global
		foreach name ({EL({cellpath}/#[][activation>0.99])})
			set {name}/{chan} Ek {rev}
		end
	else // local
		set {channelpath} Ek {rev}
	end
end

function update_channel_params
	/*
	echo updating channel parameters
	*/
end

function hilight_channel
	float x,y
	str pix

	push /compt_display/draw
	pix = get(.,pixchoose) 
	set hilight tx {get({pix},tx)} ty {get({pix},ty)} 
	xupdate .
	pop
end

function do_plot_kinetics(widget)
	str widget
	str gate = get({widget},value)
	str channeltype
	str gatepath
	float x,y,a,b,tau
	float xmin=-0.1,xmax=0.07,dx=0.002
	float amax=-1.0,bmax=-1.0,mmax=-1.0,tmax=-1.0
	str	kinname
	int i

	ce /channel_params
	dx = 0.005

	if (!{exists({channelpath})})
		return
	end

	kinname = get({channelpath},name) + "->" + {gate}

	channeltype = get({channelpath},object->name)
	if ({get(/channel_params/overlay,state)} == 0)
		call alpha RESET
		call beta RESET
		call taus RESET
		call minf RESET
		set alpha ymax 1e6
		set beta ymax 1e6
		set taus ymax 1e6
		set taus ymax 1e6
		kincolor = 15
	else
		kincolor = kincolor + 15
		if (kincolor > 99)
			kincolor = kincolor - 95
		end
		amax=get(alpha,ymax) 
		bmax=get(beta,ymax) 
		mmax=get(minf,ymax) 
		tmax=get(taus,ymax) 
	end

	if (strcmp({channeltype},hh_channel) == 0)
		if (!((strcmp({gate},"X") == 0) || (strcmp({gate},"Y") == 0)))
			echo For hh channels, gate must be X or Y
			return
		end
	end

	if (strcmp({channeltype},tabchannel) == 0)
		if (!((strcmp({gate},"X") == 0) || (strcmp({gate},"Y") == 0) || (strcmp({gate},"Z") == 0)))
			echo For vdep channels, gate must be X or Y or Z
			return
		end
		if (get({channelpath},{gate}_alloced) == 1) 
			xmin = get({channelpath},{gate}_A->xmin)
			xmax = get({channelpath},{gate}_A->xmax)
			dx = get({channelpath},{gate}_A->dx)
			if (dx < {(xmax - xmin)/100.0})
				dx = (xmax - xmin)/100.0
			end
		else
			echo gate {gate} not allocated
			return
		end
	end

	if ((strcmp({channeltype},hh_channel) == 0) || \
		(strcmp({channeltype},tabchannel) == 0))
		for (x = xmin ; x <= xmax ; x = x + dx)

			a = call({channelpath},CALC_ALPHA,{gate},{x})
			if (amax < a )
				amax = a
			end

			b = call({channelpath},CALC_BETA,{gate},{x})
			if (bmax < b)
				bmax = b
			end
			tau = 1/(a+b)
			if (tau > tmax)
				tmax = tau
			end
			xaddpts alpha -plotname {kinname} \
				-color hot{kincolor} {x} {a}
			xaddpts beta -plotname {kinname} -color hot{kincolor} {x} {b}
			xaddpts taus -plotname {kinname} -color hot{kincolor} {x} {tau}
		end

		for (x = xmin ; x <= xmax ; x = x + dx)
			y = call({channelpath},CALC_MINF,{gate},{x})
			if (y > mmax)
				mmax = y
			end
			xaddpts minf -plotname {kinname} -color hot{kincolor} {x} {y}
		end

		set alpha ymax {amax} xmin {xmin} xmax {xmax}
		set beta ymax {bmax} xmin {xmin} xmax {xmax}
		set taus ymax {tmax} xmin {xmin} xmax {xmax}
		set minf ymax {mmax} xmin {xmin} xmax {xmax}
	end

	if (strcmp({channeltype},vdep_channel) == 0)
		gatepath = {channelpath} + "/" + {gate}
		if (!{exists({gatepath})})
			echo Gate {gatepath} does not exist.
			return
		end
		if (strcmp({get({gatepath},object->name)},vdep_gate) != 0)
			xmin = get({gatepath},alpha->xmin)
			xmax = get({gatepath},alpha->xmax)
			dx = get({gatepath},alpha->dx)
			if (dx < {(xmax - xmin)/100.0})
				dx = (xmax - xmin)/100.0
			end
		end
		for (x = xmin ; x <= xmax ; x = x + dx)

			a = call({gatepath},CALC_ALPHA,{x})
			if (amax < a )
				amax = a
			end

			b = call({gatepath},CALC_BETA,{x})
			if (bmax < b)
				bmax = b
			end
			tau = 1/(a+b)
			if (tau > tmax)
				tmax = tau
			end
			xaddpts alpha -plotname {kinname} -color hot{kincolor} {x} {a}
			xaddpts beta -plotname {kinname} -color hot{kincolor} {x} {b}
			xaddpts taus -plotname {kinname} -color hot{kincolor} {x} {tau}
		end

		for (x = xmin ; x <= xmax ; x = x + dx)
			y = call({gatepath},CALC_MINF,{x})
			if (y > mmax)
				mmax = y
			end
			xaddpts minf -plotname {kinname} -color hot{kincolor} {x} {y}
		end

		set alpha ymax {amax} xmin {xmin} xmax {xmax}
		set beta ymax {bmax} xmin {xmin} xmax {xmax}
		set taus ymax {tmax} xmin {xmin} xmax {xmax}
		set minf ymax {mmax} xmin {xmin} xmax {xmax}
	end
	if (strcmp({channeltype},channelC2) == 0)
	end
	if (strcmp({channeltype},table) == 0)
	end

	ce /
end // do_plot_kinetics

function scale_gate(mode)
	str mode
	str gate
	float sx = get(/channel_params/sx,value)
	float sy = get(/channel_params/sy,value)
	float ox = get(/channel_params/ox,value)
	float oy = get(/channel_params/oy,value)
	str channeltype = get({channelpath},object->name)

	if (strcmp({channeltype},tabchannel) == 0)
		gate = get(/channel_params/gate,value)
		scale_tabchan {channelpath} {gate} {mode} {sx} {sy} {ox} {oy}
		do_plot_kinetics /channel_params/gate
		return
	end
	if (strcmp({channeltype},vdep_channel) == 0)
		gate = {channelpath} + "/" + {get(/channel_params/gate,value)}
		if (!exists({gate}))
			echo gate '{gate}' does not exist
			return
		end
		if (strcmp({get({gate},object->name)},tabgate) != 0)
			echo gate '{gate}' is not a tabgate
			return
		end
// For tabgates, argv[1] is the tabgate path and argv[2] is ignored
		scale_tabchan {gate} {gate} {mode} {sx} {sy} {ox} {oy}
		do_plot_kinetics /channel_params/gate
		return
	end
	echo channel type {channeltype} cannot be manipulated this way
end

function dup_gate
	str gate
	str channeltype = get({channelpath},object->name)
	if (strcmp({channeltype},tabchannel) == 0)
		gate = get(/channel_params/gate,value)
		duplicate_table {channelpath} {gate}
		return
	end
	if (strcmp({channeltype},vdep_channel) == 0)
		gate = {channelpath} + "/" + {get(/channel_params/gate,value)}
		if (!exists({gate}))
			echo gate '{gate}' does not exist
			return
		end
		if (strcmp({get({gate},object->name)},tabgate) != 0)
			echo gate '{gate}' is not a tabgate
			return
		end
// For tabgates, argv[1] is the tabgate path and argv[2] is ignored
		duplicate_table {gate} {gate}
		return
	end
	echo channel type {channeltype} cannot be manipulated this way
end
