//genesis

function do_xcell_funcs
	create xform /cell_params [480,470,520,450] -nolabel
	ce ^
	disable .
	create xlabel "CELL PARAMETERS"
	create xdialog "Cell Name" -value {cellpath}
	create xlabel "COMPARTMENT PARAMETERS"
	create xdialog "Selected Compartment" -value {comptpath}
	create xdialog Length -script "set_len "<widget>
	create xdialog Diameter -script "set_dia "<widget>
	create xlabel "CHANNEL PARAMETERS"
	create xdialog "Selected Channel" -value {channelpath}
	create xdialog "Channel Type"
	create xdialog "Conductance (S m^-2)" -script "set_cond "<widget>
	create xdialog "Reversal Potential" -script "set_revpotl "<widget>
	ce /
end

function update_neuron_params
	float temp
	push /cell_params
	set "Cell Name" value {cellpath}

	set "Selected Compartment" value {comptpath}
	temp = calc_len({comptpath})
	set Length value {temp * 1e6}
	temp = calc_dia({comptpath})
	set Diameter value {temp * 1e6}

	if (exists({channelpath}))
		set "Selected Channel" value {channelpath}
		set "Channel Type" value {get({channelpath},object->name)}
		temp = calc_cond({channelpath})
		set "Conductance (S m^-2)" value {temp}
		temp = calc_reversal({channelpath})
		set "Reversal Potential" value {temp}
	else
		set "Selected Channel" value "No '"{channelname}"' channel here"
		set "Channel Type" value ""
		set "Conductance (S m^-2)" value 0
		set "Reversal Potential" value 0
	end
	pop
end

function do_cellselect
	str name

	name = get(/cell_select/draw,value)
	if ({exists({name})})
		cellpath = name
		cellname = get({name},name)
		comptpath = {cellpath} + "/" + {comptname}
		channelpath = {comptpath} + "/" + {channelname}

		hilight_compt({comptpath})
		/*
		hilight_compt({comptpath},{get(/compt_select/scope,state)})
		*/

		if ({strcmp({analysis_level},neuron)} == 0)
			update_neuron_params
		end
		if ({strcmp({analysis_level},compt)} == 0)
			update_compt_params
		end
		if ({strcmp({analysis_level},channel)} == 0)
			update_channel_params
		end
		display_compt({comptpath})
	end
end
