//genesis

/* FILE INFORMATION
** Voltage clamp circuit
** Implemented by : Mark Nelson in the SQUID DEMO
*/



function make_Vclamp
	if ({exists(Vclamp)})
		return
	end

	create	diffamp	Vclamp
	set	^	saturation	999.0 \ // unitless I hope
			gain		0.002 // 1/R  from the lowpass filter input

	create	RC	Vclamp/lowpass
	set	^ 	R	500.0	\	// ohms
			C	0.1e-6		// Farads; for a tau of 50 us.
	
	create	PID	Vclamp/PID
	set	^	gain	1e-6	\	// 10/Rinput of cell
			tau_i	20e-6	\	// seconds
			tau_d	5e-6	\	// seconds
			saturation	999.0 	// unitless I hope

	sendmsg Vclamp/lowpass Vclamp	PLUS	state
	sendmsg Vclamp Vclamp/PID	CMD	output

	/*
	** Where the remaining messages typically go
	sendmsg dummy Vclamp/lowpass	INJECT	x	// Voltage to clamp at
	sendmsg {dend} Vclamp/PID	SNS	Vm	// The fb from the dend
	sendmsg Vclamp/PID {dend}	INJECT	output	// Current into the dend
	*/
end
