//genesis

/***********************************************************************
**                                                                    **
**	  Spiny.g : compartment definition file, neuron builder kit       **
**                                                                    **
**      By U.S. Bhalla March 1991                                     **
***********************************************************************/

/* FUNCTIONS TO MAKE DEFAULT LIBRARY COMPARTMENTS */
/* Note the use of environment variables Len(gth) and Dia(meter)
**	these should always be present in /library definitions of
**	compartments, otherwise scaling of conductance_Gbars and 
**	pool_volumes in .p-files may not be correct and the
**	*spherical options in the parsing routines will not work! 
** A Len(gth) == 0.0 makes the (sym)compartment spherical to the
**	parsing routines, if you want to use the *spherical
**	routines the library must contain prototypes for spherical
**	compartments.  They should be named ..._sphere.
** Note also that all copies of these library compartments
**	keep the original Len and Dia values */


function internal_make_spiny(compt,clen,cdia,nlen,ndia,hlen,hdia)
	str compt
	str clen,cdia,nlen,ndia,hlen,hdia


	float	len = {clen}
	float	dia = {cdia}
	float surface = len * dia * PI
	float temp


	if (!{exists({compt})})
		create	compartment {compt}
		create	compartment {compt}/neck
		create	compartment {compt}/head

		sendmsg {compt} {compt}/neck AXIAL Vm
		sendmsg {compt}/neck {compt} RAXIAL Ra Vm

		sendmsg {compt}/neck {compt}/head AXIAL Vm
		sendmsg {compt}/head {compt}/neck RAXIAL Ra Vm
	
		set {compt} \
			Cm		{CM * surface} \		// F
			Ra		{4.0*RA*len / (dia*dia*PI)} \	// ohm
			Em  	{EREST_ACT} \			// V
			Rm		{RM / surface} \ 		// ohm
			inject		0.0
		set -env {compt} \
			Len		{clen}	 \	// m, >0 is cylinder
			Dia		{cdia}		// m
	
	
		len = {nlen}
		dia = {ndia}
		surface = len * dia * PI
		set {compt}/neck \
			Cm		{CM * surface} \		// F
			Ra		{4.0*RA*len / (dia*dia*PI)} \	// ohm
			Em  	{EREST_ACT} \			// V
			Rm		{RM / surface} \ 		// ohm
			inject		0.0			\
			x			{len}	\
			y			0
	
	
		temp = len
		len = {hlen}
		dia = {hdia}
		surface = len * dia * PI
		set {compt}/head \
			Cm		{CM * surface} \		// F
			Ra		{4.0*RA*len / (dia*dia*PI)} \	// ohm
			Em  	{EREST_ACT} \			// V
			Rm		{RM / surface} \ 		// ohm
			inject		0.0		\
			x			{len + temp}	\
			y			0
	
	end
end

function make_spiny_compartment
	internal_make_spiny(spiny,10e-6,1e-6, 1e-6,0.2e-6, 3e-6,1e-6)
end

function make_spiny2_compartment
	internal_make_spiny(spiny2,10e-6,1e-6, 1e-6,0.3e-6, 2e-6,1e-6)
end
