//genesis

if (!{exists(/library/mGABA)})
	create	channelC2	/library/mGABA
end
	set	/library/mGABA \
		Ek	{EK} \
		tau1	4e-3	\	// sec
		tau2	4e-3	\	// sec
		gmax	{GMAX_K} // Siemens

if (!{exists(/library/mglu)})
	create	channelC2	/library/mglu
end
	set	/library/mglu \
		Ek	{ENA} \
		tau1	2e-3	\	// sec
		tau2	2e-3	\	// sec
		gmax	{DISTAL_GMAX_NA} // Siemens

if (!{exists(/library/gglu)})
	create	channelC2	/library/gglu
end
	set	/library/gglu \
		Ek	{ENA} \
		tau1	2e-3	\	// sec
		tau2	2e-3	\	// sec
		gmax	{DISTAL_GMAX_NA} // Siemens

if (!{exists(/library/aspike)})
	create	spike /library/aspike
		set /library/aspike \
			thresh		-0.01	\	// V
			abs_refract	0.01	\	// sec
			output_amp	1		
	create axon	/library/aspike/axon
	sendmsg /library/aspike /library/aspike/axon BUFFER name
end

if (!{exists(/library/term)})
	create	channelA /library/term
		set /library/term \
			Gk		5e-9 \		// Seimens
			Ek		1.0			// V 
end

EREST_ACT = -0.065 // See mit definition file
/* Adjusting the EREST dependent terms to fit with rest pot of cell */
set /library/MHH_Na_channel \
        X_alpha_V0       { 0.013 + EREST_ACT } \               // V
        X_beta_V0       { 40.0e-3 + EREST_ACT } \               // V
        Y_alpha_V0      { 0.017 + EREST_ACT } \                 // V
        Y_beta_V0       { 40.0e-3 + EREST_ACT }                 // V

set /library/MHH_K_channel \
        X_alpha_V0      {0.015+EREST_ACT} \                     // V
        X_beta_V0       {0.010+EREST_ACT}                       // V



EREST_ACT = -0.06 // See gran definition file
/* Adjusting the EREST dependent terms to fit with rest pot of cell */
set /library/GHH_Na_channel \
        X_alpha_V0      { 0.023 + EREST_ACT } \                 // V
        X_beta_V0       { 50.0e-3 + EREST_ACT } \               // V
        Y_alpha_V0       { 0.027 + EREST_ACT }  \               // V
        Y_beta_V0       { 50.0e-3 + EREST_ACT }                 // V

set /library/GHH_K_channel \
        X_alpha_V0      {0.025+EREST_ACT} \                     // V
        X_beta_V0       {0.020+EREST_ACT}                       // V


if (!{exists(/library/YCa)})
	int ndivs

	create vdep_channel /library/YCa
	set	/library/YCa \
	Ek		{ECA_ACT}	\				// V
	gbar	{ 200 * SOMA_A }			// S

	create tabgate /library/YCa/mgate
	call /library/YCa/mgate TABCREATE alpha 100 -0.2 0.1
	call /library/YCa/mgate TABCREATE beta 100 -0.2 0.1
	x = get(/library/YCa/mgate,alpha->xmin)
	dx = get(/library/YCa/mgate,alpha->dx)
	ndivs = get(/library/YCa/mgate,alpha->xdivs)
	EREST_ACT = -0.065 // Mit definitions
	for (i = 0 ; i <= ndivs ; i = i + 1)
		if (x < -0.032)
			set /library/YCa/mgate alpha->table[{i}] 0.0

			y = (exp({(x + 0.006 - EREST_ACT)/0.016}) +				\
				exp({-(x + 0.006 - EREST_ACT)/0.016})) / 7.8e-3
			set /library/YCa/mgate beta->table[{i}] {y}
		else
			y = (exp({(x + 0.006 - EREST_ACT)/0.016}) +			\
			exp({-(x + 0.006 - EREST_ACT)/0.016})) /		\
			(7.8e-3 * (1.0 + exp({-(x - 0.003 - EREST_ACT)/0.008})))
			set /library/YCa/mgate alpha->table[{i}] {y}

			y = (exp({(x + 0.006 - EREST_ACT)/0.016}) +				\
			exp({-(x + 0.006 - EREST_ACT)/0.016})) / 7.8e-3 * 		\
			(1.0 - 1.0 / (1.0 + exp({-(x - 0.003 - EREST_ACT)/0.008})))
			set /library/YCa/mgate beta->table[{i}] {y}
		end
		x = x + dx
	end


	create table /library/YCa/hgate
	call /library/YCa/hgate  TABCREATE 100 0.0 1.0
	x = get(/library/YCa/hgate,table->xmin)
	dx = get(/library/YCa/hgate,table->dx)
	ndivs = get(/library/YCa/hgate,table->xdivs)
	for (i = 0 ; i <= ndivs ; i = i + 1)
		y = 0.01/(0.01 + x)
		set /library/YCa/hgate table->table[{i}] {y}
		x = x + dx
	end

	create table /library/YCa/nernst
	call /library/YCa/nernst  TABCREATE 1000 0.00005 0.01
	x = get(/library/YCa/nernst,table->xmin)
	dx = get(/library/YCa/nernst,table->dx)
	ndivs = get(/library/YCa/nernst,table->xdivs)
	for (i = 0 ; i <= ndivs ; i = i + 1)
		y = 12.5e-3 * log({4.0 / x})
		set /library/YCa/nernst table->table[{i}] {y}
		x = x + dx
	end

	create Ca_concen /library/YCa/conc
	set  /library/YCa/conc \
		tau		0.00001 \					// sec
		B		5.2e-6 \	// Moles per coulomb, later scaled to conc
		Ca_base	1.0e-4						// Moles per cubic m

	sendmsg /library/YCa /library/YCa/conc I_Ca Ik
	sendmsg /library/YCa/conc /library/YCa/nernst INPUT Ca
	sendmsg /library/YCa/conc /library/YCa/hgate INPUT Ca
	sendmsg /library/YCa/nernst /library/YCa EK output
	sendmsg /library/YCa/hgate /library/YCa MULTGATE output 1
	sendmsg /library/YCa/mgate /library/YCa MULTGATE m 1


end
