//genesis

/***********************************************************************
**                                                                    **
**	  Compartments.g : compartment definition file, neuron builder kit**
**                                                                    **
**      By E. De Schutter, Nov 1990                                   **
**      Modified June 1990                                            **
******************************************************************************/

/* FUNCTIONS TO MAKE DEFAULT LIBRARY COMPARTMENTS */
/* Note the use of the environment variable Shape.  Default value is
**  "cylinder", it can also be set to "sphere" by the cell_reader. */

function make_cylind_compartment
	float	len = 100.0e-6
	str		Len = "100.0e-6"
	float	dia = 2.0e-6
	str		Dia = "2.0e-6"
	float surface = len * dia * PI

	if (!{exists(compartment)})
		create	compartment compartment
	end
	set compartment \
		Cm		{CM * surface} \		// F
		Ra		{4.0*RA*len / (dia*dia*PI)} \	// ohm
		Em  	{EREST_ACT} \			// V
		Rm		{RM / surface} \ 		// ohm
                dia             {dia} \
		inject		0.0
	set -env compartment \
		Shape	"cylinder"
end

function make_cylind_symcompartment
	float	len = 100.0e-6
	str		Len = "100.0e-6"
	float	dia = 2.0e-6
	str		Dia = "2.0e-6"
	float surface = len * dia * PI

	if (!{exists(symcompartment)})
		create	symcompartment symcompartment
	end
	set symcompartment \
		Cm		{CM * surface} \		// F
		Ra		{4.0*RA*len / (dia*dia*PI)} \	// ohm
		Em  	{EREST_ACT} \			// V
		Rm		{RM / surface} \ 		// ohm
                dia             {dia} \
		inject		0.0
	set -env symcompartment \
		Shape	"cylinder"
end

/******************************************************************************/
/* These functions are included for compatibility with older neurokit
**  versions, one does not need to call them anymore though! */

function make_sphere_compartment
	float	dia = 20.0e-6
	str		Dia = "20.0e-6"
	float surface = dia * dia * PI

	if (!{exists(compartment_sphere)})
		create	compartment compartment_sphere
	end
	set compartment_sphere \
		Cm		{CM * surface} \	// F
		Ra		{8.0*RA / (dia*PI)} \	// ohm
		Em  	{EREST_ACT} \			// V
		Rm		{RM / surface} \ 		// ohm
                dia             {dia} \
		inject		0.0
	set -env compartment_sphere \
		Shape	"sphere"
end

function make_sphere_symcompartment
	float	dia = 20.0e-6
	str		Dia = "20.0e-6"
	float surface = dia * dia * PI

	if (!{exists(symcompartment_sphere)})
		create	symcompartment symcompartment_sphere
	end
	set symcompartment_sphere \
		Cm		{CM * surface} \		// F
		Ra		{8.0*RA / (dia*PI)} \	// ohm
		Em  	{EREST_ACT} \			// V
		Rm		{RM / surface} \ 		// ohm
                dia             {dia} \
		inject		0.0
	set -env symcompartment_sphere \
		Shape	"sphere"
end
