// genesis

/* FILE INFORMATION
** Rat Na channel, cloned, in oocyte expression system.
** Data from :
** Stuhmer, Methfessel, Sakmann, Noda an Numa, Eur Biophys J 1987
**	14:131-138
**
** Expts carred out at 16 deg Celsius.
** 
** Implemented in tabchan format by Upinder S. Bhalla March 1991
** This file depends on functions and constants defined in defaults.g
*/

// CONSTANTS
float   ENa             =        0.045      // (I-current)
float	SOMA_A			=		1e-9		// sq m


/*********************************************************************
**                          I-Current (Na)
*********************************************************************/

function make_Na_rat_smsnn	// Na current
	float   ENa             =        0.045      // (I-current)
	float x,y,dx
	int i
    if({exists(Na_rat_smsnn)})
        return
    end

    create  tabchannel  Na_rat_smsnn
    set  Na_rat_smsnn  \
         Ek     {ENa}             \
         Gbar   {1200.0 * SOMA_A} \
         Ik     0                 \
         Gk     0					\
		 Xpower	3	\
		 Ypower	1	\
		 Zpower	0

	call Na_rat_smsnn TABCREATE X 30 -0.1 0.05

    set		Na_rat_smsnn \
		X_A->table[0] 	1.0e-4 \	// -0.100 Volts
		X_A->table[1] 	1.0e-4 \	// -0.095 Volts
		X_A->table[2] 	1.2e-4 \	// -0.090 Volts
		X_A->table[3] 	1.45e-4 \	// -0.085 Volts
		X_A->table[4] 	1.67e-4 \	// -0.080 Volts
		X_A->table[5] 	2.03e-4 \	// -0.075 Volts
		X_A->table[6] 	2.47e-4 \	// -0.070 Volts
		X_A->table[7] 	3.20e-4 \	// -0.065 Volts
		X_A->table[8] 	3.63e-4 \	// -0.060 Volts
		X_A->table[9] 	4.94e-4 \	// -0.055 Volts
		X_A->table[10] 	4.07e-4 \	// -0.050 Volts
		X_A->table[11] 	4.00e-4 \	// -0.045 Volts
		X_A->table[12] 	3.56e-4 \	// -0.040 Volts
    	X_A->table[13] 	3.49e-4 \       
    	X_A->table[14]	3.12e-4 \	// -0.030
    	X_A->table[15]	2.83e-4 \
    	X_A->table[16]	2.62e-4 \	// -0.020
    	X_A->table[17]	2.25e-4 \
    	X_A->table[18]	2.03e-4 \	// -0.010
    	X_A->table[19]	1.74e-4 \
    	X_A->table[20]	1.67e-4 \	// 0.0
    	X_A->table[21]	1.31e-4 \
    	X_A->table[22]	1.23e-4 \	// 0.010
    	X_A->table[23]	1.16e-4 \
    	X_A->table[24]	1.02e-4 \	// 0.020
    	X_A->table[25]	0.87e-4 \	     
    	X_A->table[26]	0.73e-4 \	// 0.030
    	X_A->table[27]	0.80e-4 \ 	     
    	X_A->table[28]	0.80e-4 \	// 0.040
    	X_A->table[29]	0.80e-4 \ 	     
    	X_A->table[30]	0.80e-4	// 0.050

	x = -0.1
	dx = 0.15/30.0

	for (i = 0 ; i <= 30 ; i = i + 1)
		y = 1.0 / (1.0 + exp({-(x + 0.041)/0.0086}))
		set Na_rat_smsnn X_B->table[{i}] {y}
		x = x + dx
	end
	tau_tweak_tabchan(Na_rat_smsnn,X)
	set Na_rat_smsnn X_A->calc_mode 0 X_B->calc_mode 0
	call Na_rat_smsnn TABFILL X 3000 0


	call Na_rat_smsnn TABCREATE Y 30 -0.1 0.05
   // settab2const(Na_rat_smsnn,Y_A,0,10,6.4e-3)
	//-0.1 thru -0.05=>0.0

    set		Na_rat_smsnn \
		Y_A->table[0] 	0.9e-3 \	// -0.100 Volts
		Y_A->table[1] 	1.0e-3 \	// -0.095 Volts
		Y_A->table[2] 	1.2e-3 \	// -0.090 Volts
		Y_A->table[3] 	1.45e-3 \	// -0.085 Volts
		Y_A->table[4] 	1.7e-3 \	// -0.080 Volts
		Y_A->table[5] 	2.05e-3 \	// -0.075 Volts
		Y_A->table[6] 	2.55e-3 \	// -0.070 Volts
		Y_A->table[7] 	3.2e-3 \	// -0.065 Volts
		Y_A->table[8] 	4.0e-3 \	// -0.060 Volts
		Y_A->table[9] 	5.0e-3 \	// -0.055 Volts
		Y_A->table[10] 	6.49e-3 \	// -0.050 Volts
		Y_A->table[11] 	6.88e-3 \	// -0.045 Volts
		Y_A->table[12] 	4.07e-3 \	// -0.040 Volts
    	Y_A->table[13] 	2.71e-3 \       
    	Y_A->table[14]	2.03e-3 \	// -0.030
    	Y_A->table[15]	1.55e-3 \
    	Y_A->table[16]	1.26e-3 \	// -0.020
    	Y_A->table[17]	1.07e-3 \
    	Y_A->table[18]	0.87e-3 \	// -0.010
    	Y_A->table[19]	0.78e-3 \
    	Y_A->table[20]	0.68e-3 \	// 0.0
    	Y_A->table[21]	0.63e-3 \
    	Y_A->table[22]	0.58e-3 \	// 0.010
    	Y_A->table[23]	0.53e-3 \
    	Y_A->table[24]	0.48e-3 \	// 0.020
    	Y_A->table[25]	0.48e-3 \	     
    	Y_A->table[26]	0.48e-3 \	// 0.030
    	Y_A->table[27]	0.48e-3 \ 	     
    	Y_A->table[28]	0.48e-3 \	// 0.040
    	Y_A->table[29]	0.43e-3 \ 	     
    	Y_A->table[30]	0.39e-3	// 0.050

	x = -0.1
	dx = 0.15/30.0
	for (i = 0 ; i <= 30 ; i = i + 1)
		y = 1.0 / (1.0 + exp({(x + 0.064)/0.0102}))
		set Na_rat_smsnn Y_B->table[{i}] {y}
		x = x + dx
	end
	tau_tweak_tabchan(Na_rat_smsnn,Y)
	set Na_rat_smsnn Y_A->calc_mode 0 Y_B->calc_mode 0
	call Na_rat_smsnn TABFILL Y 3000 0
end

/*********************************************************************/
