// genesis
//
// helpdemo.g
//
// Demonstration of the ximage widget for the display of GIF files
// and the xtext widget for scrolling of text files
//
//=====================================================================
// makegif(formpath,x,y,image_width,image_height,gif_file,title)
// Creates a form to display a GIF file with label and "DONE" button
// The form will have width=image_width+10 and height=image_height+25
//=====================================================================
function makegif(formpath,x,y,image_width,image_height,gif_file,title)
   str formpath,gif_file,title
   int x,y,image_width,image_height
   create xform {formpath} [{x},{y},{image_width+10},{image_height+25}] \
       -nolabel
   create xlabel {formpath}"/titlebar" [5,0,{image_width},20] \
       -title {title}
   create xbutton {formpath}"/DONE" [15,3,80,15] -script "xhide "{formpath}
   create ximage {formpath}"/image" [5,20,{image_width},{image_height}]
   set ^ wx {image_width} wy {image_height} filename {gif_file}
end

//=====================================================================
// textwindow(formpath,x,y,textfile)
// creates a form 580 pixels wide and 336 pixels high at x,y to display
// the specified text file with scrolling and paging
//=====================================================================
function textwindow(formpath,x,y,textfile)
   str formpath,textfile,XREV
   int x,y, width, height
   height = 336
   XREV   = "R4"
   width  = 580  // the default width will be the large one for X11 R4 fonts
   if (argc > 4) // look for a 5th argument
        XREV = $5
   end
// if not explicitly R3, play it safe and use larger R4 width
   if ({XREV} == "R3")
        width  = 490 // for X11R3 fonts
   end
   create xform {formpath} [{x},{y},{width},{height}] -nolabel
   push {formpath}
   create xlabel textbar [40,0,{100*(width-40)/width}%,20] -title \
       "b/f - back/forward by page | j/k - by line | a/z - begin/end"
   create xbutton DONE [0,0,40,20] -script "xhide "{formpath}
   create xtext text [0%,20,100%,94%] -file {textfile}
   pop
end
//-------------------------------------------------------------------------
function loadhelp
// create the forms with help screens
   create neutral /testgif
   makegif(/testgif/test1,0,0,640,350,neuron1.gif,"Neuron Inputs")
   makegif(/testgif/test3,0,0,576,380,aplysia1.gif,Aplysia)
   makegif(/testgif/test4,400,400,576,350,bursts.gif,"Bursts of spikes")
   makegif(/testgif/test2,0,0,640,350,compart.gif,"Compartment Model")
   textwindow(/testgif/testtext,10,378,helpdemo.g)

// create help menu
    create xform /testgif/helpmenu [770,10,250,255] \
           -title "Help Menu"
    push /testgif/helpmenu
    create xbutton test1 [5,40,240,30] -title "Image #1" \
           -script "xshow_on_top /testgif/test1"
    create xbutton test2 [5,75,240,30] -title "Image #2" \
           -script "xshow_on_top /testgif/test2"
    create xbutton test3 [5,110,240,30] -title "Image #3" \
           -script "xshow_on_top /testgif/test3"
    create xbutton test4 [5,145,240,30] -title "Image #4" \
           -script "xshow_on_top /testgif/test4"
    create xbutton text1 [5,180,240,30] -title "Text #1" \
           -script "xshow_on_top /testgif/testtext"
    create xbutton quit [5,215,240,30] -title "Quit Test" \
           -script quit
    pop
end

xon
xcolorscale hot
loadhelp
xshow /testgif/helpmenu
