//genesis - example of the sigmoid object

// create a compartment to generate input to the sigmoid
create compartment /compt

// set some internal fields with injection to give a rising Vm
// values were chosen to be within default scales of xgraph object
// Vm will rise from 0 to almost 100 over 100 time units as Cm is charged

set /compt Rm 10 Cm 2 Em 0 inject 10

// create and display a graph inside a form
create xform /data
create xgraph /data/voltage
xshow /data

// send a message (PLOT Vm) to the graph
sendmsg /compt /data/voltage PLOT Vm *volts *red

// now make a sigmoid element to receive input from the compartment
create sigmoid /sigmoid

/*
The sigmoid object has the fields:

        input        state        amplitude        thresh        gain

The equation being applied is

        state = amplitude*(tanh(gain*(input - thresh)) + 1)/2.0;

The valid messages to the the sigmoid are:

	INPUT	input
	THRESH	threshold
	GAIN	gain
	AMP	amplitude

The first of these is used to provide input to the sigmoid, and the other
three provide a way to set the parameter fields with messages.

In this example, we want to choose parameters which will give the tanh
function a moderate rate of increase over the range of Vm
*/

set sigmoid amplitude 50 gain 0.02 thresh 50
sendmsg /compt /sigmoid INPUT Vm
sendmsg /sigmoid /data/voltage PLOT state *sigmoid *black

// make some buttons to execute simulation commands
create xbutton /data/RESET -script reset
create xbutton /data/RUN -script "step 100"
create xbutton /data/QUIT -script quit

reset
