//genesis

/* This is an example of the use of hsolve elements for doing the
** hines numbering scheme for solution of a compartmental model of
** a neuron */

// This line should be added to your schedule.g file in genesis/startup
// after the membrane objects have been scheduled
// addschedule Simulate /##[CLASS=hsolver] -action PROCESS


float RA = 0.5
float RM = 10
float CM = 0.01
float EREST_ACT = -0.065
xstartup

float dt=50e-6

function setup
	str name


create neutral /library
create compartment /library/compartment

read_cell hinescell.p /test

create xform /form [20,20,500,500] -nolabel
create xdraw /form/draw [0,0,100%,100%] -wx 2e-3 -wy 2e-3 -transform ortho3d
create xcell /form/draw/cell -path "/test/##[][TYPE=compartment]" \
	-colfield Vm -colmin -0.09 -colmax 0.05 -autocol FALSE 
xshow /form

create xform /gform [520,20,600,500] -nolabel
create xgraph /gform/graph [0,0,100%,100%] 
set ^ xmax 0.1 ymax 0.05 ymin -0.09 overlay 1
xshow /gform
sendmsg /test/soma /gform/graph PLOT Vm *soma *red
sendmsg /test/second_dend11 /gform/graph PLOT Vm *sec_dend *green
sendmsg /test/glom1 /gform/graph PLOT Vm *glom *blue
set /test/soma inject 1.0e-9

create hsolve /test/solve
set /test/solve path "/test/##[][TYPE=compartment]"

call /test/solve SETUP

setclock 0 {dt}

show /test/solve *


	disable /library
reset
end


function listarrays
	int i = 0
	str name
	echo "index  parents   nkids    hnum    elmnum   diag   elmname"
	foreach name ({EL(/test/##[][TYPE=compartment])})
		echo {i} "    " {get(/test/solve,parents[{i}])} "       " {get(/test/solve,nkids[{i}])} "      " {get(/test/solve,hnum[{i}])} "     " {get(/test/solve,elmnum[{i}])} "      " {get(/test/solve,diag[{i}])} "      " {name}
		i = i + 1
	end
end

function showmatrix
	int i,j,k
	int ncompts
	str line
	int nextrowindex,nextp

	ncompts = get(/test/solve,ncompts)
	k=0
	for (i=0;i<ncompts;i=i+1)
		line = ""
		nextp = get(/test/solve,cip[{i+1}])
		nextrowindex = get(/test/solve,ri[{k}])
		for (j=0;j<ncompts;j=j+1)
			if (j==nextrowindex)
				line = {line}+" X"
				k = k + 1
				if (k >= nextp)
					nextrowindex = -1
				else
					nextrowindex = get(/test/solve,ri[{k}])
				end
			else
				line = {line}+" ."
			end
		end
		echo {line}
	end
end

setup
listarrays
showmatrix
echo running simulation with hsolver
step -t 0.1

echo running simulation without hsolver
delete /test/solve
deletemsg /gform/graph IN 0
deletemsg /gform/graph IN 0
deletemsg /gform/graph IN 0
sendmsg /test/soma /gform/graph PLOT Vm *soma *magenta
sendmsg /test/second_dend11 /gform/graph PLOT Vm *sec_dend *turquoise
sendmsg /test/glom1 /gform/graph PLOT Vm *glom *cyan
reset
step -t 0.1
