//genesis
// script1.g from "Using the Draw Widget" in the GENESIS Reference Manual
/* Creating the form and draw widgets */
create xform /ex1 [20,20,600,400]
create xdraw /ex1/draw -wx 10 -wy 10
xshow /ex1

/* creating a tetrahedron wire frame in blue. */
create xshape /ex1/draw/tetra -coords \
[0.6,0,0]       [-0.4,0.6,0]    [-0.4,-0.6,0]   [0.6,0,0] \
[0,0,1]         [-0.4,0.6,0]    [-0.4,-0.6,0]   [0,0,1] \
-drawmode DrawLines -pixcolor {Blue}

/* creating a filled hexagon (smeared in the z dimension) in red. */
create xshape /ex1/draw/hex -coords \
[0,1,0.5]       [-1,0.6,1]      [-1,-0.6,1]     [0,-1,-0.5] \
[1,-0.6,-1]     [1,0.6,-1] \
-drawmode FillPoly -pixcolor {Red}

/* copying the hexagon to 'hex.icon' so that 'thrips' can use it */
copy /ex1/draw/hex to /ex1/draw/hex.icon

/* creating a green shape entry which uses icons and has a value, but
** no coords of its own */
create xshape /ex1/draw/thrips -text thrips -textmode fill \
-textcolor {Green} -value "Thrips are green" -tx 3 \
-iconname hex.icon

/* creating a triangle in purple with all the shape frills */
create xshape /ex1/draw/aphids -coords \
[-2,-1.5,0][2,-1.5,0][0,2.5,0][-2,-1.5,0] \
-drawmode DrawLines -pixcolor {Purple} -linewidth 4 \
-linestyle LineOnOffDash -capstyle CapProjecting -joinstyle Joinmiter \
-text "aphids are thrips" -textmode fill -textcolor {Orange} \
-iconname hex.icon  -tx -2 -ty -1
