//genesis

setclock 0 1e-5
setclock 1 1e-4
create compartment /compt
	set ^ Rm 1e9 Cm 10e-12 Ra 1e6 Em -0.07

create channelC2 /compt/syn
	set ^ Ek 0.05 tau1 0.01 tau2 0.02 gmax 2e-8
	sendmsg /compt/syn /compt CHANNEL Gk Ek
	sendmsg /compt /compt/syn VOLTAGE Vm

create table /compt/syn/table
	call /compt/syn/table TABCREATE 10 -0.1 0.1
	set /compt/syn/table \
		table->table[0] 0 \
		table->table[1] 0.02 \
		table->table[2] 0.05 \
		table->table[3] 0.1 \
		table->table[4] 0.2 \
		table->table[5] 0.5 \
		table->table[6] 0.8 \
		table->table[7] 0.9 \
		table->table[8] 0.95 \
		table->table[9] 0.98 \
		table->table[10] 1
	call /compt/syn/table TABFILL 1000 0
	set /compt/syn/table x -0.07
	sendmsg /compt/syn/table /compt/syn/table INPUT x

	sendmsg /compt/syn/table /compt/syn ACTIVATION output


create ddsyn /compt/ddsyn
	set ^ Ek 0.05 tau1 0.01 tau2 0.02 gmax 2e-8
	sendmsg /compt/ddsyn /compt CHANNEL Gk Ek
	sendmsg /compt /compt/ddsyn VOLTAGE Vm

	call /compt/ddsyn TABCREATE 10 -0.1 0.1
	set /compt/ddsyn \
		transf->table[0] 0 \
		transf->table[1] 0.02 \
		transf->table[2] 0.05 \
		transf->table[3] 0.1 \
		transf->table[4] 0.2 \
		transf->table[5] 0.5 \
		transf->table[6] 0.8 \
		transf->table[7] 0.9 \
		transf->table[8] 0.95 \
		transf->table[9] 0.98 \
		transf->table[10] 1
	call /compt/ddsyn TABFILL 1000 0
	set /compt/ddsyn x -0.07
	sendmsg /compt/ddsyn /compt/ddsyn V_PRESYN x

xstartup
create xform /form [0,0,800,400]
create xgraph /form/graph [0,0,100%,100%] -range [0,-0.1,1.0,0.05]
	set ^ overlay 1
useclock /form/graph 1
xshow /form

sendmsg /compt /form/graph PLOT Vm *channelC2 *blue
reset
step -t 0.1
set /compt/syn/table x -0.03
step -t 0.1
set /compt/syn/table x 0.0
step -t 0.1
set /compt/syn/table x 0.03
step -t 0.1
set /compt/syn/table x 0.05
step -t 0.1
set /compt/syn/table x 0.1
step -t 0.1
set /compt/syn/table x -0.1
step -t 0.4
set /compt/syn/table x -0.07

deletemsg(/form/graph,IN,0)
sendmsg /compt /form/graph PLOT Vm *channelC2 *red
reset
step -t 0.1
set /compt/ddsyn x -0.03
step -t 0.1
set /compt/ddsyn x 0.0
step -t 0.1
set /compt/ddsyn x 0.03
step -t 0.1
set /compt/ddsyn x 0.05
step -t 0.1
set /compt/ddsyn x 0.1
step -t 0.1
set /compt/ddsyn x -0.1
step -t 0.4

