//genesis

float	CA_FRACT	=	1.000
float   PI      =   3.14159
float   CM = 0.01           // Farads/m^2
float   RA = 0.5            // Ohms m
float   RM = 0.2            // Ohms m^2
float   EREST_ACT = -0.070  // Volts
int i

/**********************************************************************
** Sets up NMDA- & non-NMDA-synaptic firing experiment for Ca 
**	concentrations in a dendritic spine
**  by E. De Schutter, November 1990
** Uses granule.p file or spine.p model file (for spine.p file: 
**	decrease all (NON_)NMDA_G values by factor 10, very high RN!).
**
** Reference: Holmes WR & Levy WB: Insights into associative
**	long-term potentiation from computational models of NMDA
**	receptor-mediated caclcium influx and intracellular calcium
**	concentrations changes.  J. Neurophysiol. 63, 1148-1168, 1990.  
**********************************************************************/

/*********************************************************************/
function make_the_spine_prototypes
/* separate function so we can have local variables */
/* This script uses the *compt feature of the cell_reader.  All types of
**  compartments, with their channels and diffusion elements attached to them
**  in a subtree (including the messages), are created in a library.  The
**  cell_reader then copies to over 1000 compartments in the final model
**  and scales all fields correctly for surface and volume (except for
**  gbar, gmax, Len or Vol fields which have a negative value). */
/* we need 3 types of comps: one with [buffer]=100uM (base), one with 
** [buffer]=200uM (head2) and idem + NMDA & non-NMDA receptor (head1) */

	echo Making spine library.

	float len,dia,surf,vol,kPump
	int i,ndivs
	//cable parameters
		CM = 0.01
		RM = 1.20
		RA = 0.70
		EREST_ACT = -0.070
	//minimal concentration
		float   STEADY_CA   =   0.000020
	//diffusion constant
		float   DIFFC_CA    =   0.6e-9
	//effective fraction of compartment volume available for diffusion
		float   DIFFVOLFR   =   1.0
	//for Holmes Levy spine model tau is determined by 1/kp with kp in m/s
		float   PUMP_KP     =   0.7e-6
	//total buffer concentration
		float   BUFFER_HTOT  =   0.200
		float   BUFFER_BTOT  =   0.100
	//forward rate constant for buffer
		float   BUFFER_FRATE =   500000.0
	//backward rate constant for buffer
		float   BUFFER_BRATE =   500.0
	/* About the non-NMDA and NMDA-channels.  These are here
	**	implemented by the manuelconduct object.  Though Holmes and
	**	Levy refer to this scheme, they do not implement it exactly.
	**	The non-NMDA-channel follows a slightly different scheme, which
	**	I "massaged" into the manuelconduct form, the NMDA-channel is
	**	correct.  For both channels the total number of receptors
	**	should be known, as activation is expressed relative to that
	**	total number.  As there is no evidence for receptor-binding
	**	saturation (the binding is supposed to be infinitely fast), I
	**	take the total number of receptors to be 20000000, so that each
	**	transmitter pulse (200 units) binds a fraction of 0.00001. 
	**  The large number of receptors reduces the stiffness a bit.
	** These channels may be activated by setting Z = Z + 0.00001.
	**  In practice however a larger pulse has to be given to
	**	compensate for the small differences in channel kinetics.  */
	//alpha1 NMDA receptor/channel kinetics, changed to get it
	//	into the manuelconduct form.  This is OK as long as
	//	alpha1+alpha2=340 1/s (p 1153).
		float	NMDA_ALPHA1	=	170.0
	//alpha2 NMDA receptor/channel kinetics
		float	NMDA_ALPHA2	=	170.0
	//beta NMDA receptor/channel kinetics
		float	NMDA_BETA	=	0.600
	//k-1 NMDA receptor/channel kinetics
		float	NMDA_K	=	20.0
	//single NMDA channel conductance (negative value: no scaling)
		float	NMDA_G	=	-50.0e-12
	//reversal potential NMDA channel
		float	NMDA_EK	=	0.0
	//NMDA Mg block A-factor (scaled to mM units)
		float	MGBLOCK_A	=	8.80
	//NMDA Mg block B-factor
		float	MGBLOCK_B	=	0.0125	//scaled for V instead of mV
	//Mg concentration
		float	STEADY_MG	=	1.2
	//reversal potential non-NMDA channel
		float	NON_NMDA_EK	=	0.0
	//alpha1 non-NMDA receptor/channel kinetics: same trick as for
	//	the NMDA channel, here this creates however a somewhat
	//	different equation from the Holmes and Levy one.
		float	NON_NMDA_ALPHA1	=	1200.0
	//alpha2 non-NMDA receptor/channel kinetics
		float	NON_NMDA_ALPHA2	=	800.0
	//beta non-NMDA receptor/channel kinetics
		float	NON_NMDA_BETA	=	2000.0
	//k-1 non-NMDA receptor/channel kinetics
		float	NON_NMDA_K	=	2000.0
	//single non-NMDA channel conductance (negative value: no scaling)
		float	NON_NMDA_G	= -5.0e-12
	
	/* make 200uM [buffer] head prototype */
	len = 0.05e-6
	dia = 0.55e-6
	surf = len * dia * PI
	if (!{exists(head2comp)})
		create	symcompartment head2comp
	end
	set head2comp \
		Cm		{CM * surf} \		// F
		Ra		{4.0*RA*len / (dia*dia*PI)} \	// ohm
		Em  	{EREST_ACT} \			// V
		Rm		{RM / surf} \ 		// ohm
		dia		{dia} \
		inject	0.0 
	set -env head2comp \
		Shape   "cylinder"

	push head2comp

    /* create the diffusion element.  Vol is volume of the element, 
	**  Len is the lenght along the axis of diffusion (one-dimensional)  */
	/* note that Len and Vol will be scaled by the cell_reader, (unless
	**  a negative value is specified), which assumes that Len scales 
	**  with the length of the compartment */
	vol = DIFFVOLFR * len * dia * dia * PI / 4.0
	if (!{exists(Ca_pool)})
		create	difpool	Ca_pool
	end
	set Ca_pool \
		Co      {STEADY_CA}  \  // mM
    	Cmin    {STEADY_CA}  \   // mM
    	D       {DIFFC_CA} \    // D in m^2/s
    	Len     {len} \         // m
    	Vol     {vol}          // m^3
	/* messages outside of the prototype definitions (between neighbouring
	**  difpools in this case) need to be send to the cell_reader by the
	**  set -env mechanisms.  An exception are the (R)AXIAL messages which 
	**  the cell_reader knows how to handle. */
	set -env Ca_pool \
		sendmsg1	"-/Ca_pool	./Ca_pool	DIFFUSE	Len Vol Co" \
		sendmsg2	"./Ca_pool	-/Ca_pool	DIFFUSE	Len Vol Co"
	
	if (!{exists(Ca_buffer)})
		create poolbuffer Ca_buffer
	end
	set Ca_buffer \
    	Btot    {BUFFER_HTOT} \     // mM
    	kBf     {BUFFER_FRATE} \    // 1/mM.s
    	kBb     {BUFFER_BRATE}     // 1/s
	sendmsg	Ca_pool		Ca_buffer	CONCEN	Co
	sendmsg	Ca_buffer	Ca_pool		BUFFER	kBf kBb Btot Bfree
	
	pop 	//back to library level
	
	/* make 100uM [buffer] base prototype for heads */
	if (!{exists(headcomp)})
		copy head2comp	headcomp
	end
	set headcomp/Ca_buffer \
    	Btot    {BUFFER_BTOT}      // mM

	/* make 100uM [buffer] base prototype for dendrites */
	if (!{exists(basecomp)})
		copy head2comp	basecomp
	end
	set basecomp/Ca_buffer \
    	Btot    {BUFFER_BTOT}      // mM
	
	/* make 100uM [buffer] base prototype for tails */
	if (!{exists(tailcomp)})
		copy basecomp	tailcomp
	end
	
	/* make 200uM [buffer] NMDA+non-NMDA head prototype */
	if (!{exists(head1comp)})
		copy head2comp	head1comp
	end
	push head1comp

	/* Described by manuelconduct object.  Internally field H
	**	corresponds to AR* and field Z to AR */
	if (!{exists(NMDA)})
		create manuelconduct	NMDA
	end
	set NMDA \
		tau_g	{NMDA_ALPHA1/NMDA_BETA} \
		tau_h	{1/NMDA_ALPHA2} \
		tau_d	{0.0000020} \  /* infinitely fast removal */
		K_r		{NMDA_K/400000} \  /* immediate receptor binding */
		gmax	{20000000 * NMDA_G} \ /* normalized by # of receptors */
		Ek		{NMDA_EK}  		//V

	//fraction NMDA-current carried by Ca2+ ions, constant fraction
	//	approximation is valid for Vm = -0.100 to 0, in [Ca2+]i range
	//	0.000 to 0.050 mM, for [Ca2+]o at 2mM (less than 1% error);
	//	range 0.050 to 0.200 mM: less than 5% error;
	//	range 0.200 to 0.500 mM: less than 10% error).
	//additionaly we change this by a control factor, neutral = 1.0
	if (!{exists(Ca_fract_tab)})
		create	table	Ca_fract_tab	
	end
	call Ca_fract_tab	TABCREATE 100 -0.10 0.00
	/* input is compartment voltage, output is Ca-charge Zk scaled
	**	by the fraction of total NMDA-current that is Ca-current */
	set Ca_fract_tab table->table[0] {2.0/(CA_FRACT*0.127218)}
	set Ca_fract_tab table->table[1] {2.0/(CA_FRACT*0.1272235)}
	set Ca_fract_tab table->table[2] {2.0/(CA_FRACT*0.1272294)}
	set Ca_fract_tab table->table[3] {2.0/(CA_FRACT*0.1272357)}
	set Ca_fract_tab table->table[4] {2.0/(CA_FRACT*0.1272424)}
	set Ca_fract_tab table->table[5] {2.0/(CA_FRACT*0.1272497)}
	set Ca_fract_tab table->table[6] {2.0/(CA_FRACT*0.1272574)}
	set Ca_fract_tab table->table[7] {2.0/(CA_FRACT*0.1272657)}
	set Ca_fract_tab table->table[8] {2.0/(CA_FRACT*0.1272745)}
	set Ca_fract_tab table->table[9] {2.0/(CA_FRACT*0.127284)}
	set Ca_fract_tab table->table[10] {2.0/(CA_FRACT*0.1272942)}
	set Ca_fract_tab table->table[11] {2.0/(CA_FRACT*0.1273051)}
	set Ca_fract_tab table->table[12] {2.0/(CA_FRACT*0.1273167)}
	set Ca_fract_tab table->table[13] {2.0/(CA_FRACT*0.1273293)}
	set Ca_fract_tab table->table[14] {2.0/(CA_FRACT*0.1273427)}
	set Ca_fract_tab table->table[15] {2.0/(CA_FRACT*0.1273571)}
	set Ca_fract_tab table->table[16] {2.0/(CA_FRACT*0.1273726)}
	set Ca_fract_tab table->table[17] {2.0/(CA_FRACT*0.1273892)}
	set Ca_fract_tab table->table[18] {2.0/(CA_FRACT*0.127407)}
	set Ca_fract_tab table->table[19] {2.0/(CA_FRACT*0.1274261)}
	set Ca_fract_tab table->table[20] {2.0/(CA_FRACT*0.1274467)}
	set Ca_fract_tab table->table[21] {2.0/(CA_FRACT*0.1274688)}
	set Ca_fract_tab table->table[22] {2.0/(CA_FRACT*0.1274925)}
	set Ca_fract_tab table->table[23] {2.0/(CA_FRACT*0.127518)}
	set Ca_fract_tab table->table[24] {2.0/(CA_FRACT*0.1275454)}
	set Ca_fract_tab table->table[25] {2.0/(CA_FRACT*0.1275749)}
	set Ca_fract_tab table->table[26] {2.0/(CA_FRACT*0.1276066)}
	set Ca_fract_tab table->table[27] {2.0/(CA_FRACT*0.1276407)}
	set Ca_fract_tab table->table[28] {2.0/(CA_FRACT*0.1276774)}
	set Ca_fract_tab table->table[29] {2.0/(CA_FRACT*0.1277169)}
	set Ca_fract_tab table->table[30] {2.0/(CA_FRACT*0.1277594)}
	set Ca_fract_tab table->table[31] {2.0/(CA_FRACT*0.1278051)}
	set Ca_fract_tab table->table[32] {2.0/(CA_FRACT*0.1278544)}
	set Ca_fract_tab table->table[33] {2.0/(CA_FRACT*0.1279075)}
	set Ca_fract_tab table->table[34] {2.0/(CA_FRACT*0.1279646)}
	set Ca_fract_tab table->table[35] {2.0/(CA_FRACT*0.1280262)}
	set Ca_fract_tab table->table[36] {2.0/(CA_FRACT*0.1280925)}
	set Ca_fract_tab table->table[37] {2.0/(CA_FRACT*0.1281641)}
	set Ca_fract_tab table->table[38] {2.0/(CA_FRACT*0.1282412)}
	set Ca_fract_tab table->table[39] {2.0/(CA_FRACT*0.1283243)}
	set Ca_fract_tab table->table[40] {2.0/(CA_FRACT*0.128414)}
	set Ca_fract_tab table->table[41] {2.0/(CA_FRACT*0.1285107)}
	set Ca_fract_tab table->table[42] {2.0/(CA_FRACT*0.1286151)}
	set Ca_fract_tab table->table[43] {2.0/(CA_FRACT*0.1287278)}
	set Ca_fract_tab table->table[44] {2.0/(CA_FRACT*0.1288494)}
	set Ca_fract_tab table->table[45] {2.0/(CA_FRACT*0.1289807)}
	set Ca_fract_tab table->table[46] {2.0/(CA_FRACT*0.1291225)}
	set Ca_fract_tab table->table[47] {2.0/(CA_FRACT*0.1292756)}
	set Ca_fract_tab table->table[48] {2.0/(CA_FRACT*0.1294412)}
	set Ca_fract_tab table->table[49] {2.0/(CA_FRACT*0.1296201)}
	set Ca_fract_tab table->table[50] {2.0/(CA_FRACT*0.1298135)}
	set Ca_fract_tab table->table[51] {2.0/(CA_FRACT*0.1300227)}
	set Ca_fract_tab table->table[52] {2.0/(CA_FRACT*0.130249)}
	set Ca_fract_tab table->table[53] {2.0/(CA_FRACT*0.130494)}
	set Ca_fract_tab table->table[54] {2.0/(CA_FRACT*0.1307592)}
	set Ca_fract_tab table->table[55] {2.0/(CA_FRACT*0.1310464)}
	set Ca_fract_tab table->table[56] {2.0/(CA_FRACT*0.1313575)}
	set Ca_fract_tab table->table[57] {2.0/(CA_FRACT*0.1316949)}
	set Ca_fract_tab table->table[58] {2.0/(CA_FRACT*0.1320607)}
	set Ca_fract_tab table->table[59] {2.0/(CA_FRACT*0.1324576)}
	set Ca_fract_tab table->table[60] {2.0/(CA_FRACT*0.1328884)}
	set Ca_fract_tab table->table[61] {2.0/(CA_FRACT*0.1333564)}
	set Ca_fract_tab table->table[62] {2.0/(CA_FRACT*0.133865)}
	set Ca_fract_tab table->table[63] {2.0/(CA_FRACT*0.1344182)}
	set Ca_fract_tab table->table[64] {2.0/(CA_FRACT*0.1350203)}
	set Ca_fract_tab table->table[65] {2.0/(CA_FRACT*0.1356761)}
	set Ca_fract_tab table->table[66] {2.0/(CA_FRACT*0.1363909)}
	set Ca_fract_tab table->table[67] {2.0/(CA_FRACT*0.1371709)}
	set Ca_fract_tab table->table[68] {2.0/(CA_FRACT*0.1380227)}
	set Ca_fract_tab table->table[69] {2.0/(CA_FRACT*0.138954)}
	set Ca_fract_tab table->table[70] {2.0/(CA_FRACT*0.1399734)}
	set Ca_fract_tab table->table[71] {2.0/(CA_FRACT*0.1410906)}
	set Ca_fract_tab table->table[72] {2.0/(CA_FRACT*0.1423167)}
	set Ca_fract_tab table->table[73] {2.0/(CA_FRACT*0.1436643)}
	set Ca_fract_tab table->table[74] {2.0/(CA_FRACT*0.145148)}
	set Ca_fract_tab table->table[75] {2.0/(CA_FRACT*0.1467845)}
	set Ca_fract_tab table->table[76] {2.0/(CA_FRACT*0.1485931)}
	set Ca_fract_tab table->table[77] {2.0/(CA_FRACT*0.1505963)}
	set Ca_fract_tab table->table[78] {2.0/(CA_FRACT*0.1528206)}
	set Ca_fract_tab table->table[79] {2.0/(CA_FRACT*0.1552969)}
	set Ca_fract_tab table->table[80] {2.0/(CA_FRACT*0.1580623)}
	set Ca_fract_tab table->table[81] {2.0/(CA_FRACT*0.1611609)}
	set Ca_fract_tab table->table[82] {2.0/(CA_FRACT*0.1646458)}
	set Ca_fract_tab table->table[83] {2.0/(CA_FRACT*0.168582)}
	set Ca_fract_tab table->table[84] {2.0/(CA_FRACT*0.1730491)}
	set Ca_fract_tab table->table[85] {2.0/(CA_FRACT*0.1781465)}
	set Ca_fract_tab table->table[86] {2.0/(CA_FRACT*0.183999)}
	set Ca_fract_tab table->table[87] {2.0/(CA_FRACT*0.1907667)}
	set Ca_fract_tab table->table[88] {2.0/(CA_FRACT*0.1986572)}
	set Ca_fract_tab table->table[89] {2.0/(CA_FRACT*0.2079454)}
	set Ca_fract_tab table->table[90] {2.0/(CA_FRACT*0.2190033)}
	set Ca_fract_tab table->table[91] {2.0/(CA_FRACT*0.2323465)}
	set Ca_fract_tab table->table[92] {2.0/(CA_FRACT*0.2487114)}
	set Ca_fract_tab table->table[93] {2.0/(CA_FRACT*0.2691874)}
	set Ca_fract_tab table->table[94] {2.0/(CA_FRACT*0.2954579)}
	set Ca_fract_tab table->table[95] {2.0/(CA_FRACT*0.3302683)}
	set Ca_fract_tab table->table[96] {2.0/(CA_FRACT*0.3784214)}
	set Ca_fract_tab table->table[97] {2.0/(CA_FRACT*0.4491494)}
	set Ca_fract_tab table->table[98] {2.0/(CA_FRACT*0.5627494)}
	set Ca_fract_tab table->table[99] {2.0/(CA_FRACT*0.7742576)}
	set Ca_fract_tab table->table[100] {2.0/(CA_FRACT*1.307355)}

	if (!{exists(Mg_NMDA_block)})
		create	Mg_block	Mg_NMDA_block
	end
	set Mg_NMDA_block \
		KMg_A	{MGBLOCK_A} \
		KMg_B	{MGBLOCK_B} \
		CMg		{STEADY_MG} \
		Ek		{NMDA_EK} \ 		//V
		Zk		2
	/* block of NMDA-current by Mg: */
	sendmsg	NMDA	Mg_NMDA_block	CHANNEL1	Gk	
	/* Ca inflow through NMDA-channel to Ca-pool; */
	sendmsg Ca_fract_tab	Mg_NMDA_block	CHARGE	output
	sendmsg	Mg_NMDA_block	Ca_pool	INJECT	Zk	Ik

	if (!{exists(non_NMDA)})
		create manuelconduct	non_NMDA
	end
	set non_NMDA \
		tau_g	{NON_NMDA_ALPHA1/NON_NMDA_BETA} \
		tau_h	{1/NON_NMDA_ALPHA2} \
		tau_d	{0.000001} \  /* infinitely fast removal */
		K_r		{NON_NMDA_K/1000000} \  /* immediate receptor binding */
		gmax	{20000000 * NON_NMDA_G}\/* normalized by # receptors */
		Ek	{NON_NMDA_EK} 		//V

	pop 	//back to library level

	/* As kPump is constant, we do not need a separate pump element.
	**	For convenience we use Ca_buffer as the src of the PUMP msg.
	** The Holmes and Levy pump rate is dependent on the surface to volume
	**	ratio of the compartment, for a cylindrical comp this is equal to
	**	4/dia */
	kPump = 4 * PUMP_KP / 0.55e-6
	sendmsg	head1comp/Ca_buffer	head1comp/Ca_pool	PUMP	{kPump} {STEADY_CA}
	sendmsg	head2comp/Ca_buffer	head2comp/Ca_pool	PUMP	{kPump} {STEADY_CA}
	sendmsg	headcomp/Ca_buffer	headcomp/Ca_pool	PUMP	{kPump} {STEADY_CA}
	kPump = 4 * PUMP_KP / 0.10e-6
	sendmsg	basecomp/Ca_buffer	tailcomp/Ca_pool	PUMP	{kPump} {STEADY_CA}
	kPump = 4 * PUMP_KP / 1.00e-6
	sendmsg	basecomp/Ca_buffer	basecomp/Ca_pool	PUMP	{kPump} {STEADY_CA}

	/* connect channels to compartment */
	/* The VOLTAGE messages to (non_)NMDA are needed only when you
	**  want to output Ik, here they are not used to speed things up */
//	sendmsg	head1comp	head1comp/non_NMDA	VOLTAGE	Vm  
	sendmsg	head1comp/non_NMDA	head1comp	CHANNEL Gk	Ek
//	sendmsg	head1comp	head1comp/NMDA	VOLTAGE	Vm
	sendmsg	head1comp	head1comp/Ca_fract_tab	INPUT	Vm
	sendmsg	head1comp	head1comp/Mg_NMDA_block	VOLTAGE	Vm
	sendmsg	head1comp/Mg_NMDA_block	head1comp	CHANNEL Gk	Ek

end
