//genesis - view.g

float	SEPX = 1.05

//====================================================================
// Create the view form, graphs and buttons
//====================================================================
setclock 2 0.1  // use slow clock for updates
create xform /viewform [0,445,800,235] -nolabel

push /viewform
create xlabel label [5,5,98%,30] \
    -title "Propagation of Vm Along the Cable"
create xtoggle autoscale [5,195,25%,30] -script "autoscale_toggle <widget>"

set autoscale label0 "Autoscaling OFF" label1 "Autoscaling ON" state 0

create xdialog Vmin -value 0.0 -script "set_Vmin <widget>" \
        [10,195,34%,30] -widgets [autoscale.right,NULL,NULL,NULL]
create xdialog Vmax -value 20.0 -script "set_Vmax <widget>" \
        [10,195,34%,30] -widgets [Vmin.right,NULL,NULL,NULL]

pop
//===================================================================
//		Functions invoked by buttons
//===================================================================

function set_Vmin(widget)
    str min
    min = {get({widget},value)}
    set /viewform/draw/cable vmin {min}
end

function set_Vmax(widget)
    str max
    max = {get({widget},value)}
    set /viewform/draw/cable vmax {max}
end

function autoscale_toggle(widget)
str widget
        if ({get({widget},state)} == 1)
                set /viewform/draw/cable autoscale TRUE
        else
                set /viewform/draw/cable autoscale FALSE
		set_Vmin(/viewform/Vmin)
		set_Vmax(/viewform/Vmax)
        end
end

//========================================================================
// Functions to create and delete the draw and view widgets for the cable
//========================================================================
function make_draw(Ncompart)
  float Ncompart  // number of compartments (soma + cable)
  create xdraw /viewform/draw [5,40,98%,150] \
     -wx {1.2 * (SEPX * {Ncompart})} -wy 3.0  -transform z2d
  set ^ refresh_flag FALSE
  useclock /viewform/draw 2

  create xview /viewform/draw/cable -path /cell/##[TYPE=compartment] \
	 -field Vm -vmin 0 -vmax 20 -viewmode ycolbar \
	-ox {-0.45 * SEPX * {Ncompart}}
  autoscale_toggle /viewform/autoscale	// set autoscale from toggle
  useclock /viewform/draw/cable 2       // use a slow clock for updates
// Apparently needs to be reset before it will properly plot
  reset
end

function delete_draw
  delete /viewform/draw/cable
  delete /viewform/draw
  check		// Without this, I get core dumps!
end
