//genesis
// forms.g - for the cable tutorial

include xtools.g
include helpforms.g

// ==========================================
//   Functions used for popup parameter menus
// ==========================================

// Popup Menu for timing, value and location of injection current
function make_inject_menu // Dialog boxes for injection current and timing
    create xform  /output/inject_menu [695,365,330,215] -nolabel
    push /output/inject_menu
    create xtoggle injtoggle -title "" -script inj_toggle  // in inputs.g
    set injtoggle label0 "Current Injection OFF"
    set injtoggle label1 "Current Injection ON" state 1
    inj_toggle // initialize
    create xbutton APPLY [5,25,157,20] -script "set_injection" // in inputs.g
    create xbutton DISMISS [167,25,157,20] -script "xhide /output/inject_menu"
    create xdialog inject  -title "Current (uA)" \
	   -value {injcurrent}
    create xdialog delay  -title "Delay (msec)" -value {injdelay}
    create xdialog width  -title "Width (msec)" -value {injwidth}
    create xlabel numbering -title "Compartment #0 = Soma"
    create xdialog comp_no -title "Inject Compartment:" -value 0
    pop
end

// Popup Menu for location and parameters for synaptic input
function make_synapse_menu
    create xform  /output/synapse_menu [365,45,330,255] -nolabel
    push /output/synapse_menu
    create xtoggle syntoggle -title "" -script syn_toggle  // in inputs.g
    set syntoggle label0 "Synaptic Input OFF"
    set syntoggle label1 "Synaptic Input ON" state 0 // initially  OFF
    syn_toggle // initialize
    create xbutton APPLY [5,25,157,25] -script "set_inputs" // in inputs.g
    create xbutton DISMISS [167,25,157,25] -script "xhide /output/synapse_menu"
    create xdialog delay  -title "Delay (msec)" -value {syndelay}
    create xdialog gsyn   -title "gsyn (mS)"    -value {gsyn}
    create xdialog tsyn	  -title "tsyn (msec)"  -value {tsyn}
    create xdialog vsyn   -title "Esyn (mV)"  -value {Vsyn}
    create xlabel numbering -title "Compartment #0 = Soma"
    create xdialog comp_no -title "Input to Compartment:" -value 0
    pop
end

// Menu for setting the integration method (uses set_method in compartment.g)
function make_method_menu
    create xform  /output/method_menu [695,615,330,285] \
                -title "Integration Method"
    push /output/method_menu
    create xbutton DISMISS -script "xhide /output/method_menu"
    create xbutton euler -title "Euler Method" -script "set_method -1"
    create xbutton exponential -title "Exponential Method" \
		-script "set_method 0"
    create xbutton trapezoidal -title "Trapezoidal Method" \
		-script "set_method 4"
    create xbutton gear -title "Gear Method" \
		-script "set_method 1"
    create xbutton abash2 -title "Adams-Bashforth #2" \
		-script "set_method 2"
    create xbutton abash3 -title "Adams-Bashforth #3" \
		-script "set_method 3"
    create xbutton abash4 -title "Adams-Bashforth #4" \
		-script "set_method 5"
    create xbutton abash5 -title "Adams-Bashforth #5" \
		-script "set_method 6"
    create xbutton rungek -title "Runge Kutta Method" \
		-script "set_method 7"
    pop
end

// Menu for changing cell parameters
function make_param_menu
    str compartment
    str formpath	= "/output/param_menu"
    create xform {formpath} [695,0,330,345] -nolabel
    disable {formpath}
    push {formpath}
    create xlabel   cell_params -title "Cell Parameters"
    create xbutton  APPLY   [5,25,157,20]   -script "set_cell_params"
    create xbutton  DISMISS [167,25,157,20] -script "xhide "{formpath}
    create xlabel specific_rc -title "Specific Resistance/Capacitance"
    create xdialog  RM  -title "RM (Kohm*cm^2)" -value {RM} -script setRM
    create xdialog  CM  -title "CM (uF/cm^2)"   -value {CM} -script setCM
    create xdialog  RA  -title "RA (Kohm*cm)"   -value {RA} -script setRA
    create xlabel sizes -title "Compartment length/diameter"
    create xdialog  soma_l -title "soma length (cm)" -value {soma_l} \
    	-script setsoma_l
    create xdialog  soma_d -title "soma diam (cm)" -value {soma_d} \
       	-script setsoma_d
    create xdialog  dend_l -title "cable compt length (cm)" -value {dend_l} \
    	-script setdend_l
    create xdialog  dend_d -title "cable compt diam (cm)" -value {dend_d} \
    	-script setdend_d
    pop
end

// The following six specialized functions represent an offensively ugly
// kludge to deal with the way the "-script" field is parsed by Genesis

function setRM
  RM = {get(/output/param_menu/RM, value)}
  echo "RM now set to "{RM}
end

function setCM
  CM = {get(/output/param_menu/CM, value)}
  echo "CM now set to "{CM}
end

function setRA
  RA = {get(/output/param_menu/RA, value)}
  echo "RA now set to "{RA}
end

function setsoma_l
  soma_l = {get(/output/param_menu/soma_l, value)}
  echo "soma_l now set to "{soma_l}
end

function setsoma_d
  soma_d = {get(/output/param_menu/soma_d, value)}
  echo "soma_d now set to "{soma_d}
end

function setdend_l
  dend_l = {get(/output/param_menu/dend_l, value)}
  echo "dend_l now set to "{dend_l}
end

function setdend_d
  dend_d = {get(/output/param_menu/dend_d, value)}
  echo "dend_d now set to "{dend_d}
end

function set_cell_params	// uses global RM, CM, RA, len, diam
  int i
  push /cell
  setcompartment(soma, {soma_l}, {soma_d}, {EREST})
  echo
  echo "Soma Rm (membrane resistance, Kohms) = "{get(soma,Rm)}
  echo "Soma Cm (membrane capacitance, uF)   = "{get(soma,Cm)}
  echo "Soma Ra (axial resistance, Kohms)    = "{get(soma,Ra)}
  if (NCableSects != 0)
     for (i=0; i<NCableSects; i=i+1)
       setcompartment(/cell/cable[{i}],{dend_l},{dend_d},{EREST})
     end
  echo "Cable compartment Rm (membrane resistance, Kohms) = "{get(cable[0],Rm)}
  echo "Cable compartment Cm (membrane capacitance, uF)   = "{get(cable[0],Cm)}
  echo "Cable compartment Ra (axial resistance, Kohms)    = "{get(cable[0],Ra)}
  echo "Total cable length = "{NCableSects*dend_l}\
        " cm. ("{NCableSects}" sections)" 
  end // if
  pop
//  if we set the xcell fatfield to calc_dia, we need to remake the widget
//  however, propagation_toggle is defined later in this script
//  set /output/control/propagation state 0
//  propagation_toggle
end

// Popup menu for adding/removing cable Vm plots
function make_plot_menu
    create xform /output/plot_menu [215,50,220,120] -title "Add/Remove Plots"
    push /output/plot_menu
    create xbutton DISMISS -script "xhide /output/plot_menu"
    create xbutton remove -title "Remove Cable Plots" \
    		-script "remove_cable_plots"
    create xdialog add -title "Plot Sect #" -value 0  \
    		-script "add_cable_plot"
    pop
end

//functions used to add and remove cable plots
function add_cable_plot
  int section 			// cable section to plot (numbered from 1)
  section = {get(/output/plot_menu/add, value)}
  if (exists(/cab_logtable[{section-1}]))
     echo "Plot already exists!"
     return
  end
  if ({section} < 1)
     echo "In our notation, the first cable section is #1."
     return
  end
  
  if ({section} > {NCableSects})
    echo "There are only "{NCableSects}" cable sections!"
  else
    copy /logtable /cab_logtable[{section-1}]
    push /output/somagraphs
    sendmsg  /cell/cable[{section-1}] somaVm_grf PLOT Vm \
    		*"cable "{section} *red
    sendmsg /cell/cable[{section-1}] /cab_logtable[{section-1}] INPUT Vm
    sendmsg /cab_logtable[{section-1}] loggraph   PLOT output \
    		*"cable "{section} *red
    pop
    echo "Vm plots added for cable section #"{section}
    reset	// needed to initialize the table
  end
end

function remove_cable_plots
  int i, n, nmsg
  for (i=0; i < NCableSects; i=i+1)
    if (exists(/cab_logtable[{i}])) // then plot messages exist for cable[{i}]
     // To play it safe, we don't assume we know the message number
     nmsg=getmsg(/cell/cable[{i}],OUT,-count) //loop over outgoing messages
     for (n=0; n<nmsg; n=n+1)
      if(getmsg(/cell/cable[{i}],OUT,{n},dst)=="/output/somagraphs/somaVm_grf")
       deletemsg(/cell/cable[{i}],OUT,{n}) // should be the "PLOT Vm" message
       break // bail out of "for" loop - we found the message
      end // if
     end // for n
     delete /cab_logtable[{i}] // get rid of table and all messages to/from
    end //if exists
  end  // for i
  set /output/plot_menu/add value 0
  echo "Plotting of Vm for cable sections disabled."
end

// functions used in MAIN CONTROL PANEL
//
// change_stepsize  -  sets clock 0
//
function change_stepsize
    dt  = {get(/output/control/stepsize,value)}
    setclock 0 {dt}
    echo dt = {dt}
    set /##[TYPE=spike] output_amp {1.0/getclock(0)}
end

// toggle the display of channel conductance
function conductance_toggle
  if (get(/output/control/conductance,state) == 1)
      xshow_on_top /output/condgraphs
  else
      xhide /output/condgraphs
  end
end

// toggle the display of Vm along the cable
function propagation_toggle
  if (get(/output/control/propagation,state) == 1)
      make_draw({NCableSects + 1})
      xshow_on_top /viewform
  else
      if (exists(/viewform/draw))
          delete_draw
      end
      xhide /viewform
  end
end

// =======================================================
//  The two main functions, loadgraphs and loadcontrol
//  set up the forms used for graphs and control buttons
// =======================================================
function loadgraphs
     xon				// activate XODUS
// While forms are being loaded, put up some credits
     echo " "
     echo "*************************************************"
     echo "*                                               *"
     echo "*                    CABLE                      *"
     echo "*                                               *"
     echo "*        A simulation of a simple CABLE         *"
     echo "*                                               *"
     echo "*                (version 0.3)                  *"
     echo "*                                               *"
     echo "*                  D. Beeman                    *"
     echo "*                                               *"
     echo "*            UNIVERSITY OF COLORADO             *"
     echo "*                                               *"
     echo "*************************************************"
     echo " "
    xcolorscale hot		// give it color

// make graphs for soma Vm
    create xform	/output/somagraphs [215,0,480,600] -nolabel
    push /output/somagraphs
    create xgraph 	somaVm_grf [0,0,480,300] \
			-title "Soma membrane potential Vm (mV)" 
    set somaVm_grf xmin 0 xmax {tmax} ymin 0 ymax 25 XUnits "msec" \
                   YUnits "Vm (mV)"
    useclock somaVm_grf 1
    makegraphscale /output/somagraphs/somaVm_grf

    create xgraph loggraph [0,300,480,300] \
			-title "natural log of Vm"
    set loggraph xmax {tmax} ymin -1 ymax 4  XUnits "msec" \
                   YUnits "ln(Vm)"
    useclock loggraph 1
    makegraphscale /output/somagraphs/loggraph
    pop
    xshow /output/somagraphs

// make a graph for conductances
    create xform /output/condgraphs [215,320,480,300] -nolabel
    push /output/condgraphs
    create xgraph channel_Gk [0,0,480,300] -title "Channel Conductance (mS)"
    set channel_Gk xmin 0 xmax {tmax} ymin 0 ymax {gsyn*2}
    set channel_Gk XUnits "msec" YUnits "Gk (mS)"
    useclock channel_Gk 1
    makegraphscale /output/condgraphs/channel_Gk
    pop
    set /output/condgraphs height 300 // work around bug that sets it to 415
end     // loadgraphs

    // =================================================
    //                MAIN CONTROL PANEL
    // =================================================
function loadcontrol
    create xform 	/output/control [0,0,215,425] -nolabel
    push /output/control
    create xbutton 	HELP -script "xshow_on_top /output/helpmenu"
    create xbutton 	reset  -title RESET  -script reset
    create xbutton 	stop   -title STOP  -script stop
    create xbutton 	quit   -title QUIT \
				    -script "quitbutton <widget>"
    makeconfirm(quit,"Quit CABLE?","quit","cancelquit <widget>",10,10)

    create xtoggle 	overlay   -title "" \
				    -script "overlaytoggle <widget>"
    set overlay label0 "Overlay OFF" label1 "Overlay ON" state 0
    overlaytoggle /output/control/overlay
// be sure that it is in state 0 after Reset Defaults
    create xbutton	resetdefaults -title "Reset Defaults" \
                        -script "ResetDefaults"
    create xdialog 	step  -title "STEP (msec)" \
			-script "stepbutton <widget>"  -value {tmax}
    create xdialog 	stepsize   -title "dt" \
			-script "change_stepsize"   -value {dt}
    create xbutton	params -title "Change Cell Parameters" \
    			-script "xshow /output/param_menu"
    create xbutton	inject -title "Change Current Injection" \
    			-script "xshow /output/inject_menu"
    create xbutton	synapse -title "Change Synaptic Input" \
    			-script "xshow /output/synapse_menu"
    create xbutton	method -title "Change Integration Method"\
    			-script "xshow /output/method_menu"
    create xdialog	nsections  -title "No. of Cable Sects." \
			-value 0 -script "add_cable" // defined in addcable.g
    create xbutton	addplot -title "Add/Remove Plots" \
    			-script "xshow /output/plot_menu"

    create xtoggle	conductance -title "" -script conductance_toggle
        set conductance label0 "Conductance Plot Hidden"
	set conductance label1 "Conductance Plot Visible" state 0
	conductance_toggle	// be sure it is properly initialized

    create xtoggle	propagation -title "" -script propagation_toggle
        set propagation label0 "Vm Propagation Hidden"
	set propagation label1 "Vm Propagation Visible" state 0
	propagation_toggle	// be sure it is properly initialized
    pop
    make_param_menu
    make_inject_menu
    make_synapse_menu
    make_method_menu
    make_plot_menu
    xshow /output/control
end // loadcontrol
