//genesis
/* compartment.g

	functions defined in this script
=============================================================================
	FUNCTION NAME		ARGUMENTS
=============================================================================
	makecompartment		(path,l,d,Erest)
	setcompartment		(path,l,d,Erest)
	set_method		(method)
=============================================================================
*/

//=================================================
//                    COMPARTMENT
//=================================================
function makecompartment(path,l,d,Erest)
    str path
    float l,d
    float Erest
    float area = l*PI*d
    float xarea = PI*d*d/4
/* global variables defined in cable.g
    float RM				// Kohm-cm^2
    float CM				// uF/cm^2
    float RA				// Kohm-cm
*/
    create 	compartment	{path}
    set		{path} \
		Em	{ Erest } \  		// mV
		Rm	{ RM/area } \  		// Kohm
		Cm	{ CM*area } \  		// uF
		Ra	{ RA*l/xarea } 		// Kohm
end

function setcompartment(path,l,d,Erest)
    str path
    float l,d
    float Erest
    float area = l*PI*d
    float xarea = PI*d*d/4
    set		{path} \
		Em	{ Erest } \  		// mV
		Rm	{ RM/area } \  		// Kohm
		Cm	{ CM*area } \  		// uF
		Ra	{ RA*l/xarea } 		// Kohm
end

function set_method(method)  // sets integration method for all compartments
    int method
    setmethod  /cell/##[TYPE=compartment] {method}
    IntegMethod = {method}   // save the current method in a global variable
end
