//genesis
// addcable.g - routines to add a passive cable to the soma
//
// From the standpoint of the user, cable sections are labeled from
// 1 to NCableSects.  (Zero means none exist.)  However, the actual
// cable elements are labeled cable[0] through cable[{NCableSects-1}].

function link_compartment(comp1, comp2)
    str comp1, comp2
    sendmsg   {comp1}   {comp2}  AXIAL   previous_state
    sendmsg   {comp2}   {comp1}  RAXIAL  Ra   previous_state
end

function make_cable(nsects)
    int nsects, i
    makecompartment(/cell/cable[{0}],{dend_l},{dend_d},{EREST})
     set /cell/cable[0] x 1.0  // give it an x-coord for view
    if(nsects>0)
      for (i=1; i<nsects; i=i+1)
        makecompartment(/cell/cable[{i}],{dend_l},{dend_d},{EREST})
	set /cell/cable[{i}] x {i+1} // give it an x-coord for view
	link_compartment(/cell/cable[{i-1}],/cell/cable[{i}])
      end
    end
end

/* NOTE: If a cable exists, it is deleted and a new one is created.  This
   means that messages for current injection, synaptic input and plotting
   must be reestablished.  (The latter has not yet been done.)  It may be
   better to retain any sections (with their messages) which will be used
   in the new cable.
*/

function add_cable
    int i, nsects       // number of cable sections after function call
    int comp_no		// compartment for injection or synaptic input 
// global variables used:
//	int NCableSects = number of existing cable sections
//	int IntegMethod = the current integration method
    nsects=get(/output/control/nsections, value)
    if(nsects < 0)
        nsects=0
    end
    if(nsects != NCableSects) // otherwise, do nothing
        if(NCableSects > 0)   // delete the cable
	    for (i=0;i<NCableSects;i=i+1)
	        delete /cell/cable[{i}]  // also deletes messages to soma
                if (exists(/cab_logtable[{i}])) // delete log lookup table
                   delete /cab_logtable[{i}]    // PLOT messages also deleted
                end
	    end
	end
	if(nsects > 0)
	    make_cable({nsects})
	    link_compartment(/cell/soma,/cell/cable[0])
        end
        NCableSects={nsects}		// new number of cable sections
        // re-establish the current injection and synaptic input to cable
	comp_no = {get(/output/inject_menu/comp_no,value)}
	if ({comp_no}> 0)	        // if injection was to cable 
	    if ({comp_no}>{nsects})     // if compartment no longer exists
		comp_no = 0		// then inject soma
	    set /output/inject_menu/comp_no value 0
	    end
	    add_injection({comp_no})
	end
	comp_no = {get(/output/synapse_menu/comp_no,value)}
	if ({comp_no}> 0)	        // if input was to cable 
	    if ({comp_no}>{nsects})     // if compartment no longer exists
		comp_no = 0		// then input to soma
	    set /output/synapse_menu/comp_no value 0
	    end
	    add_syn_input({comp_no})
	end
        set /output/plot_menu/add value 0 // cable plots will have been lost
        reset // simulator must be reset after altering connections
	if (exists(/viewform/draw))	// delete the draw and view
	   delete_draw
	end
	if (get(/output/control/propagation,state) == 1)
 	    make_draw({nsects+1}) //If propagation visible, create widgets
	end
    end
    echo {nsects}" passive cable sections added to soma"
    set_method({IntegMethod})	// use the current integration method
end
