
//genesis
// cable.g - main script

//==================================================
// global variables used in the simulation
//==================================================

int NCableSects = 0 // start with no passive cable compartments
int IntegMethod = 0 // use the exponential numerical integration method 
float tmax = 50	    // default time to run simulation (msecs)
float dt = 0.01     // default integration time step  (msecs)
float   PI              =       3.14159
float   EREST           =       0       // resting membrane potential

// Specific resistances and capacitance
float RM = 10.0                         // Kohm-cm^2
float CM = 1.0                          // uF/cm^2
float RA = 0.05                         // Kohm-cm

// compartment dimensions (cm.)
float soma_l = 50e-4
float soma_d = 50e-4
float dend_l = 100e-4
float dend_d = 2e-4

// default (initial) parameters for current injection
float injwidth  =   10  // msec
float injdelay  =    0
float injcurrent       = 2e-4  // uA (200 nA)

// default (initial) parameters synaptic input
float syndelay	=  0	// msec
float synwidth 	= 1000	// choose width and interval to give a single spike
float syninterval	= 100000

float gsyn	= 1e-6	// milliSiemen
float tsyn	= 1		// milliseconds
float Vsyn	= 50		// mV above resting potential (defined as zero)
// for comparison
// Vsyn = 125 ==> Na channel (+55 mV with Erest = -70)
// Vsyn = -12 ==>  K channel (-82 mV with Erest = -70)

//==================================================
//                  STARTUP SCRIPTS
//==================================================
include compartment.g
include inputs.g
include logifier.g	// constructs lookup tables for log plots
include view.g		// graphics for propagation along the cable
include addcable.g	// functions to add and delete cable sections
include forms.g		// Control Panel and Graphs

//=========================================================================
//  Some functions used in the main script
//
//  SendPlotMsgs  - sends messages to the graphics forms
//
//  ResetGlobals  - resets the values of the global variables to defaults
//
//  ResetDefaults - similar to the main script, but graph forms pre-exist
//=========================================================================
  
function SendPlotMsgs
  push /output/somagraphs
  sendmsg  /cell/soma           somaVm_grf PLOT Vm *soma *black
  sendmsg /cell/soma /logtable INPUT Vm
  sendmsg /logtable loggraph   PLOT output *soma *black
  sendmsg /cell/syn_channel /output/condgraphs/channel_Gk \
        PLOT Gk *Gk *blue
  pop
end  // SendPlotMsgs

function ResetGlobals
    NCableSects = 0 // start with no passive cable compartments
    IntegMethod = 0
    tmax = 50	    // default time to run simulation (msecs)
    dt = 0.01       // default integration time step  (msecs)
    RM = 10.0                         // Kohm-cm^2
    CM = 1.0                          // uF/cm^2
    RA = 0.05                         // Kohm-cm
    soma_l = 50e-4
    soma_d = 50e-4
    dend_l = 100e-4
    dend_d = 2e-4
end 

function ResetDefaults
    stop
    remove_cable_plots	// in case we are plotting cable sections
    delete /cell
    delete /input
    delete /output/control
    delete /output/param_menu
    delete /output/inject_menu
    delete /output/synapse_menu
    delete /output/method_menu
    delete /output/plot_menu
    ResetGlobals		// re-initialize global constants
    setclock	0	{dt}		// simulation time step in msec
    create neutral /cell
    makecompartment(/cell/soma,{soma_l},{soma_d},{EREST})
    makeinputs                                            // inputs.g
    loadcontrol
    SendPlotMsgs
    adjustspike
    check
    reset
end

//=========================================================================
//
//                         MAIN SCRIPT - Cable
//
//=========================================================================

//==================================================
// check and initialize the simulation
//==================================================

prompt		"Cable !"		// set the prompt
setclock	0	{dt}		// simulation time step in msec
					// max size for reasonable accuracy
setclock	1	0.05		// output interval

create neutral /cell
makecompartment(/cell/soma,{soma_l},{soma_d},{EREST})
makeinputs                                            // inputs.g
loadgraphs	// in forms.g (This is done after the elements are created)
loadcontrol
loadhelp
SendPlotMsgs
adjustspike
check
reset

echo ==================
echo Simulation loaded.
echo ==================
