//genesis - I_plots.g -- functions to make plots of activation parameters

function make_Igraphs
    create xform /output/Iform [385,0,765,525] -nolabel
    push /output/Iform
    create xlabel label [0, 5, 100%, 20] -widgets [NULL, NULL, NULL, NULL] \
        -title "Channel Currents"
    create xbutton hide [10, 0, 100, 18] -title "Hide Plots"\
	-widgets [label.left, label.top, NULL, NULL] \
	-script "xhide /output/Iform"
    create xbutton delete [-110, 0, 100, 18] -title "Delete Plots"\
	-widgets [label.right, label.top, NULL, NULL] \
	-script delete_plots
    create xgraph Na [0, 5, 50%, 160] -title "Na current" \
        -widgets [NULL, label.bottom, NULL, NULL]
    set ^ XUnits Sec xmax {user_xmax1} ymax 5e-7 YUnits Amperes
    create xgraph Ca [50%, 5, 50%, 160] -title "Ca current" \
        -widgets [NULL, label.bottom, NULL, NULL]
    set ^ XUnits Sec xmax {user_xmax1} ymax 5e-7 YUnits Amperes
    create xgraph K [0, 5, 50%, 160] -title "K current" \
        -widgets [NULL, Na.bottom, NULL, NULL]
    set ^ XUnits Sec xmax {user_xmax1} ymin -5e-7 ymax 0 YUnits Amperes
    create xgraph B [50%, 5, 50%, 160] -title "B current" \
        -widgets [NULL, Na.bottom, NULL, NULL]
    set ^ XUnits Sec xmax {user_xmax1} ymax 2e-8 YUnits Amperes
    create xgraph A [0, 5, 50%, 160] -title "A current" \
        -widgets [NULL, K.bottom, NULL, NULL]
    set ^ XUnits Sec xmax {user_xmax1} ymin -5e-8 ymax 0 YUnits Amperes
    create xgraph C [50%, 5, 50%, 160] -title "C current" \
        -widgets [NULL, K.bottom, NULL, NULL]
    set ^ XUnits Sec xmax {user_xmax1} ymin -2e-8 ymax 0 YUnits Amperes
    pop
end

function send_Imsgs(cellpath)
    str cellpath
    str compt = {cellpath} + "/soma"
    push /output/Iform
    sendmsg {compt}/Na Na PLOT Ik *Ik *blue
    sendmsg {compt}/K K PLOT Ik *Ik *blue
    sendmsg {compt}/A A PLOT Ik *Ik *blue
    if(exists({compt}/Ca))
        sendmsg {compt}/Ca Ca PLOT Ik *Ik *blue
    end // this could be done for all with a foreach loop over an EL
    sendmsg {compt}/B   B PLOT Ik *Ik *blue
    sendmsg {compt}/K_C C PLOT Ik *Ik *blue
    pop
end

function do_paradigm
    if (exists(/output/Iform))
        set /output/Iform/#[OBJECT=xgraph] \
	    xmin {get(/molluscgraph1/graph, xmin)} \
	    xmax {get(/molluscgraph1/graph, xmax)}
	xshow_on_top /output/Iform
    else
	if ({cellpath} != "/new")  // if cell has been loaded
	    make_Igraphs
	    send_Imsgs({cellpath})
	    xshow_on_top /output/Iform
	end
    end
end

function delete_plots
    stop	// it core dumps if plots deleted while running
    sleep 1
    delete /output/Iform
end

