//genesis

/* 
	functions defined in this script
=============================================================================
	FUNCTION NAME		ARGUMENTS
=============================================================================
 	loadgraphics
 	conductance_form	(graphicspath,cellpath,channelname,x,y)
 	connection_form		(graphicspath,path,num,x,y)
 	injection_form		(graphicspath,cellpath,name,x,y)
 	makegraphics		(path)
=============================================================================
*/

include xtools.g
include buttons.g

function loadgraphics
    xon				// activate XODUS
    xcolorscale hot		// give it color
    // =================================================
    //                MAIN CONTROL PANEL
    // =================================================
    create xform 	/output/main_control [10,10,420,100] \
    -title "MultiCell - A simple neuronal network simulation by M.Wilson 6/88" 
    push /output/main_control
    create xbutton 	reset 	    [10,35,80,30] \
				    -script reset \
				    -title RESET
    create xtoggle 	overlay     [92,35,80,30] \
				    -title "overlay" \
				    -script "overlaytoggle <widget>"
    create xbutton 	stop 	    [174,35,80,30] \
				    -title STOP \
				    -script stop
    create xbutton 	quit 	    [330,35,80,30] \
				    -title QUIT \
				    -script "quitbutton <widget>"
    makeconfirm(quit,"Quit MultiCell?","quit","cancelquit <widget>",500,10)
    create xdialog 	step 	    [10,67,200,30] \
				    -script "stepbutton <widget>" \
				    -title "STEP (msec)" \
				    -value 500
    create xdialog 	stepsize    [210,67,200,30] \
				    -title "dt (msec)" \
				    -script "setstepsize <widget>" \
				    -value {getclock(0)}
    pop
    xshow /output/main_control
    // =================================================
    //                CELL CONTROL PANEL
    // =================================================
    create xform /output/cells [430,10,80,30] -nolabel
    xshow /output/cells
end

function conductance_form(graphicspath,cellpath,channelname,x,y)
str graphicspath
str cellpath
str channelname
float x,y
str 	target	= {cellpath} + "/" + {channelname}

    create xlabel {graphicspath}/{channelname}	[{x},{y},160,30] \
	-title {channelname}
    push {graphicspath}/{channelname}
    create xdialog 	E 	[{x},{y+35},160,30] \
			-script "fieldbutton "{target}" Ek <widget>" \
			-title "Eequil (mV)" \
			-value {get({target},Ek)}
    create xdialog 	gmax 	[{x},{y+70},160,30] \
			-script "fieldbutton "{target}" gmax <widget>" \
			-title "Gm (mS/syn)" \
			-value {get({target},gmax)}
    create xdialog 	tau1 	[{x},{y+105},160,30] \
			-script "fieldbutton "{target}" tau1 <widget>" \
			-title "Tau1 (msec)" \
			-value {get({target},tau1)}
    create xdialog 	tau2 	[{x},{y+140},160,30] \
			-script "fieldbutton "{target}" tau2 <widget>" \
			-title "Tau2 (msec)" \
			-value {get({target},tau2)}
    pop
end

function connection_form(graphicspath,path,num,x,y)
str 	graphicspath, axonname, num
float 	x,y
str 	graphics	= graphicspath + "/conn" + num
str	connection	= path + ":" + num

    create xlabel {graphics} 	[{x},{y},160,30] \
	-title "to "{get({connection},target)}
    push {graphics}
    create xdialog 	weight 	[{x},{y+35},160,30] \
			-script "fieldbutton "{connection}" weight <widget>" \
			-title "weight (syn)" \
			-value {get({connection},weight)}
    create xdialog 	delay 	[{x},{y+70},160,30] \
			-script "fieldbutton "{connection}" delay <widget>" \
			-title "delay (msec)" \
			-value {get({connection},delay)}
    pop
end

function injection_form(graphicspath,cellpath,name,x,y)
    str graphicspath, cellpath, name
    float value

    create xdialog 	{graphicspath}/{name}inject 	[{x},{y},160,30] \
			-title "I "{name}" (uA)"  \
			-script "fieldbutton "{cellpath}" inject <widget>" \
			-value {get({cellpath},inject)}
end

function makegraphics(path)
    if(argc < 1)
	echo usage: makegraphics path [x y]
	return
    end
    if(argc > 1)
	// optionally read in the form position
	int fx = $2
	int fy = $3
    else
	int fx = 10
	int fy = 120
    end
    // path gives the location of the cell
    // graphics path gives the location of the control form for the cell
    str path
    str graphicspath = {path} + "/graphics"

    // add a toggle for this cell in the main cell control panel
    create xtoggle 	/output/cells/{pathname({path},-tail)} \
			-script "celltoggle <widget> "{graphicspath}

    // =================================================
    //                    main form
    // =================================================
    create xform	{graphicspath}		[{fx},{fy},565,775] \
	-title {graphicspath}
    push {graphicspath}

    // =================================================
    //      make graph1 for intracellular potentials
    // =================================================
    create xgraph 	graph1 	[5,50,400,350] \
			-title "intracellular potential Vm (mV)" 
    sendmsg  {path}/soma/dend 	graph1 PLOT Vm *dend *red
    sendmsg  {path}/soma 	graph1 PLOT Vm *soma *black
    set graph1 yoffset 150
    set graph1 xmin 0 xmax 500 ymin -90 ymax 200
    useclock graph1 1
    makegraphscale {graphicspath}/graph1

    // =================================================
    //       make graph2 for synaptic conductances
    // =================================================
    create xgraph 	graph2 	[5,410,400,350] \
			-title "GNa and GK (mS)" 
    sendmsg  {path}/soma/dend/Na_channel 	graph2 PLOT Gk *Na *black
    sendmsg  {path}/soma/dend/K_channel 	graph2 PLOT Gk *K *red
    set graph2 yoffset 0
    set graph2 xmin 0 xmax 500 ymin -0.1e-5 ymax 5e-5
    useclock graph2 1
    makegraphscale {graphicspath}/graph2 

    // =================================================
    //                 current injection 
    // =================================================
    create xlabel {graphicspath}/injectlabel 	[410,50,160,30] \
	-title "current injection"
    injection_form 	{graphicspath} {path}/soma/dend		dend 	410 85
    injection_form 	{graphicspath} {path}/soma		soma  	410 120

    // =================================================
    //               conductance parameters 
    // =================================================
    conductance_form 	{graphicspath} {path}/soma/dend	Na_channel	410 400
    conductance_form 	{graphicspath} {path}/soma/dend	K_channel	410 600

    // =================================================
    //               connection parameters 
    // =================================================
    connection_form	{graphicspath} {path}/axon	0	410 180

    /* display the widgets and prepare to start */
    xshow {graphicspath}
    pop
end
