/************************************************************************************************************************

	PROGRAM:	BIOSIM

	FILENAME:	sendhelp.c

	PURPOSE:	interclient communication with help server

	FUNCTIONS:	in order of appearance

	bad_window_handler	- catch Xlib-Error handler for testing the existance of a window
	sendhelp		- sends data consisting of book and topic to help server

************************************************************************************************************************/

#ifndef BATCH
#include "copying.h"
#include "biosim.h"
#include "functions.h"

/* global variables */

Atom ICCM_COMMAND;	/* command for inter client communication */
Atom ICCM_SERVERID;	/* server id for inter client communication */

/************************************************************************************************************************

 	FUNCTION	: bad_window_handler(disp, err)
 
	PURPOSE		: catch Xlib-Error handler for testing the existance of a window

	RETURNS		: status

************************************************************************************************************************/

int bad_window_handler(disp, err)
Display *disp;		/* display of screen */
XErrorEvent *err;	/* error event */
{
	return(0);	/* do nothing */
}

/************************************************************************************************************************

 	FUNCTION	: sendhelp(w, service, book, topic)
 
	PURPOSE		: sends data consisting of book and topic to help server

	RETURNS		: status of send request, 0 = failure, 1 = success

************************************************************************************************************************/

int sendhelp(w, service, book, topic)
Widget w;				/* widget which wants the help */
char *service;				/* service name, here helpserver */
char *book;				/* help file name without .hlp extension */
char *topic;				/* theme within the help file */
{
	FILE *fp;			/* test existance of helpserver */
	int (*old_handler)();		/* error handler */
	int SEND = 0;			/* flag if help server is present */
	int format;			/* format of property */
	int i = 0;			/* loop variable */
	int dummy;			/* variable not really used */
	Display *disp;			/* display */
	unsigned long	num_gets,	/* returned from get window property */
			bytes_left,	/* returned from get window property */
			offset = 0L;	/* offset in 32-bit quantities for data retrieval */
	char dataForClient[512];	/* information send to client */
	char strbuffer[512];		/* temporary buffer */
	Window rootWindow;		/* root window of screen */
	Atom type;			/* type of property */
	Window *server_data;		/* server data */

	/* save old event handler and reset it by a pseudo event handler */

	old_handler = XSetErrorHandler(bad_window_handler);

	disp = XtDisplay(w);
	rootWindow = DefaultRootWindow(disp);

	/* create data string to send to client */

	sprintf(dataForClient, "%s:%.512s", book, topic);

	/* create Atoms needed for communication */

	sprintf(strbuffer, "%s", service);
	ICCM_COMMAND = XInternAtom(disp, strbuffer, 0);

	sprintf(strbuffer, "%s_slot", service);
	ICCM_SERVERID = XInternAtom(disp, strbuffer, 0);

	/* look if help server is running by generation a geometry request */

	do
	{
		if (XGetWindowProperty(disp, rootWindow, ICCM_SERVERID, offset, 8L, FALSE,
			XA_WINDOW, &type, &format, &num_gets, &bytes_left,
			(unsigned char**) &server_data) == Success &&  type == XA_WINDOW)
		{
			for (i = 0; i < num_gets; i++)
				if (XGetGeometry(disp, *(server_data + i), &rootWindow,
					&dummy, &dummy, &dummy, &dummy, &dummy, &dummy))
				{
					SEND = TRUE; /* communication to client is possible */
					break;
				}
			offset += 8;
		}
	} while (! SEND && bytes_left != 0);

	/* check if communication to client is possible */

	if (SEND)
	{
		/* send data to client (help server) */

		XChangeProperty(disp, rootWindow, ICCM_COMMAND, XA_STRING, 8,
			PropModeReplace, (char*) dataForClient, strlen(dataForClient));
	}
	else	/* no communication possible, hence start help server and try it again */
	{
		XDeleteProperty(disp, rootWindow, ICCM_SERVERID);

		/* now look if help server is present at given location */

		strcpy(strbuffer, helpServerPath);
		strcat(strbuffer, "/helpserver");
		if (! (fp = fopen(strbuffer, "r")))
		{
			fprintf(stderr, "\nError: Help server is not available under %s\n", strbuffer);

			/* reset original error handler and return */

			XSetErrorHandler(old_handler);
			return(SEND);
		}
		fclose(fp);

		/* change directory to the help server directory and start it from there */

		strcpy(strbuffer, "cd ");
		strcat(strbuffer, helpServerPath);
		strcat(strbuffer, "; ");
		strcat(strbuffer, helpServerPath);
		strcat(strbuffer, "/helpserver");
		strcat(strbuffer, " & >/dev/null");

		/* start help server in background and wait to come up */

		system(strbuffer);

		/* send data to client (help server) */

		XChangeProperty(disp, rootWindow, ICCM_COMMAND, XA_STRING, 8,
			PropModeReplace, (char*) dataForClient, strlen(dataForClient));
	}

	/* reset original error handler and return */

	(void) XSetErrorHandler(old_handler);
	return(SEND);
}
#endif
