/************************************************************************************************************************

	PROGRAM:	BIOSIM

	FILENAME:	parameter.h

	PURPOSE:	here are for all input parameters the range and default values defined

************************************************************************************************************************/

/******	sodium channel equilibrium potential	******/

#define NAEQ_MIN	-200	/* unit: mV */
#define NAEQ_MAX	200	/* unit: mV */
#define NAEQ_ONOFF_DEF	50	/* unit: mV */
#define NAEQ_SWIM_DEF	50	/* unit: mV */
#define NAEQ_HH_DEF	50	/* unit: mV */
#define NAEQ_GB_DEF	50	/* unit: mV */

/******	sodium channel conductance		******/

#define NACON_MIN	0	/* unit: nS */
#define NACON_MAX	5000000	/* unit: nS */
#define NACONONOFF_DEF	800	/* unit: nS */
#define NACON_SWIM_DEF	1000	/* unit: nS */
#define NACON_HH_DEF	1200	/* unit: nS */
#define NACON_GB_DEF	2300000	/* unit: nS */

/******	sodium channel opening duration		******/

#define NADUR_MIN	0	/* unit: ms */
#define NADUR_MAX	10	/* unit: ms */
#define NADUR_DEF	0.3	/* unit: ms */

/******	spike threshold				******/

#define STH_MIN		-200	/* unit: mV */
#define STH_MAX		200	/* unit: mV */
#define STH_DEF		-40	/* unit: mV */

/******	potassium channel equilibrium potential	******/

#define KEQ_MIN		-200	/* unit: mV */
#define KEQ_MAX		200	/* unit: mV */
#define KEQ_ONOFF_DEF	-90	/* unit: mV */
#define KEQ_SWIM_DEF	-90	/* unit: mV */
#define KEQ_HH_DEF	-77	/* unit: mV */
#define KEQ_GB_DEF	-80	/* unit: mV */

/******	potassium channel conductance		******/

#define KCON_MIN	0	/* unit: nS */
#define KCON_MAX	50000	/* unit: nS */
#define KCONONOFF_DEF	320	/* unit: nS */
#define KCON_SWIM_DEF	600	/* unit: nS */
#define KCON_HH_DEF	360	/* unit: nS */
#define KCON_GB_DEF	350	/* unit: nS */

/******	potassium channel starting point	******/

#define KSTART_MIN	0	/* unit: ms */
#define KSTART_MAX	10	/* unit: ms */
#define KSTART_DEF	0.4	/* unit: ms */

/******	potassium channel opening duration	******/

#define KDUR_MIN	0	/* unit: ms */
#define KDUR_MAX	10	/* unit: ms */
#define KDUR_DEF	2.0	/* unit: ms */

/******	calcium channel equilibrium potential	******/

#define CAEQ_MIN	-200	/* unit: mV */
#define CAEQ_MAX	200	/* unit: mV */
#define CAEQ_ONOFF_DEF	150	/* unit: mV */
#define CAEQ_SWIM_DEF	150	/* unit: mV */

/******	calcium channel conductance		******/

#define CACON_MIN	0	/* unit: nS */
#define CACON_MAX	50000	/* unit: nS */
#define CACONONOFF_DEF	10	/* unit: nS */
#define CACON_SWIM_DEF	10	/* unit: nS */
#define CA1CON_GB_DEF	210	/* unit: nS */
#define CA2CON_GB_DEF	47	/* unit: nS */

/******	calcium channel starting point		******/

#define CASTART_MIN	0	/* unit: ms */
#define CASTART_MAX	10	/* unit: ms */
#define CASTART_DEF	1.7	/* unit: ms */

/******	calcium channel opening duration	******/

#define CADUR_MIN	0	/* unit: ms */
#define CADUR_MAX	10	/* unit: ms */
#define CADUR_DEF	0.7	/* unit: ms */

/******	calcium dependend potassium channel equilibrium potential	******/

#define KCAEQ_MIN	-200	/* unit: mV */
#define KCAEQ_MAX	200	/* unit: mV */
#define KCAEQ_GB_DEF	-80	/* unit: mV */

/******	calcium dependend potassium channel conductance	******/

#define KCACON_MIN	0	/* unit: nS */
#define KCACON_MAX	50000	/* unit: nS */
#define KCACON_GB_DEF	3200	/* unit: nS */

/******	A channel equilibrium potential	******/

#define AEQ_MIN		-200	/* unit: mV */
#define AEQ_MAX		200	/* unit: mV */
#define AEQ_GB_DEF	-80	/* unit: mV */

/******	A channel conductance	******/

#define ACON_MIN	0	/* unit: nS */
#define ACON_MAX	50000	/* unit: nS */
#define ACON_GB_DEF	2200	/* unit: nS */

/******	IR channel equilibrium potential	******/

#define IREQ_MIN	-200	/* unit: mV */
#define IREQ_MAX	200	/* unit: mV */
#define IREQ_GB_DEF	-10	/* unit: mV */

/******	IR channel conductance	******/

#define IRCON_MIN	0	/* unit: nS */
#define IRCON_MAX	50000	/* unit: nS */
#define IRCON_GB_DEF	37	/* unit: nS */

/******	P channel equilibrium potential	******/

#define PEQ_MIN		-200	/* unit: mV */
#define PEQ_MAX		200	/* unit: mV */
#define PEQ_GB_DEF	-10	/* unit: mV */

/******	P channel conductance	******/

#define PCON_MIN	0	/* unit: nS */
#define PCON_MAX	50000	/* unit: nS */
#define PCON_GB_DEF	90	/* unit: nS */

/******	soma membrane conductance		******/

#define CON_MIN		0	/* unit: nS */
#define CON_MAX		10000	/* unit: nS */
#define CON_ONOFF_DEF	3	/* unit: nS */
#define CON_SWIM_DEF	3	/* unit: nS */
#define CON_HH_DEF	3	/* unit: nS */
#define CON_GB_DEF	100	/* unit: nS */

/******	soma resting potential			******/

#define LEAK_MIN	-200	/* unit: mV */
#define LEAK_MAX	200	/* unit: mV */
#define LEAK_ONOFF_DEF	-70	/* unit: mV */
#define LEAK_SWIM_DEF	-70	/* unit: mV */
#define LEAK_HH_DEF	-65	/* unit: mV */
#define LEAK_GB_DEF	-50	/* unit: mV */

/******	soma capacity				******/

#define CAP_MIN		0.01	/* unit: pF */
#define CAP_MAX		100000	/* unit: pF */
#define CAP_ONOFF_DEF	100	/* unit: pF */
#define CAP_SWIM_DEF	30	/* unit: pF */
#define CAP_HH_DEF	10	/* unit: pF */
#define CAP_GB_DEF	1700	/* unit: pF */

/******	soma starting potential			******/

#define POT_MIN		-200		/* unit: mV */
#define POT_MAX		200		/* unit: mV */
#define POT_ONOFF_DEF	LEAK_ONOFF_DEF	/* unit: mV */
#define POT_SWIM_DEF	LEAK_SWIM_DEF	/* unit: mV */
#define POT_HH_DEF	LEAK_HH_DEF	/* unit: mV */
#define POT_GB_DEF	-47		/* unit: mV */

/******	conductance from soma to dendrite	******/

#define TOD_MIN		0.01	/* unit: nS */
#define TOD_MAX		100000	/* unit: nS */
#define TOD_DEF		40	/* unit: nS */

/******	dendrite conductance			******/

#define DCON_MIN	0	/* unit: nS */
#define DCON_MAX	10000	/* unit: nS */
#define DCON_DEF	9.6	/* unit: nS */

/******	dendrite resting potential		******/

#define DLEAK_MIN	LEAK_MIN	/* unit: mV */
#define DLEAK_MAX	LEAK_MAX	/* unit: mV */
#define DLEAK_ONOFF_DEF	LEAK_ONOFF_DEF	/* unit: mV */
#define DLEAK_SWIM_DEF	LEAK_SWIM_DEF	/* unit: mV */
#define DLEAK_HH_DEF	LEAK_HH_DEF	/* unit: mV */
#define DLEAK_GB_DEF	LEAK_GB_DEF	/* unit: mV */

/******	dendrite capacity			******/

#define DCAP_MIN	0.01	/* unit: pF */
#define DCAP_MAX	10000	/* unit: pF */
#define DCAP_DEF	300	/* unit: pF */

/******	dendrite starting potential		******/

#define DPOT_MIN	POT_MIN		/* unit: mV */
#define DPOT_MAX	POT_MAX		/* unit: mV */
#define DPOT_ONOFF_DEF	POT_ONOFF_DEF	/* unit: mV */
#define DPOT_SWIM_DEF	POT_SWIM_DEF	/* unit: mV */
#define DPOT_HH_DEF	POT_HH_DEF	/* unit: mV */
#define DPOT_GB_DEF	POT_GB_DEF	/* unit: mV */

/******	conductance between dendritic compartments	******/

#define TOS_MIN		0.01	/* unit: nS */
#define TOS_MAX		10000	/* unit: nS */
#define TOS_DEF		40	/* unit: nS */

/******	synaptic connection strength		******/

#define STR_MIN		0	/* unit: nS */
#define STR_MAX		50000	/* unit: nS */
#define STR_DEF		500	/* unit: nS */

/******	axo-axonic synaptic connection strength	******/

#define ASTR_MIN	0	/* unit: - */
#define ASTR_MAX	1	/* unit: - */
#define ASTR_DEF	0.4	/* unit: - */

/******	maximal synaptic connection strength	******/

#define MAXSTR_MIN	0	/* unit: nS */
#define MAXSTR_MAX	50000	/* unit: nS */
#define MAXSTR_DEF	5000	/* unit: nS */

/******	maximal axo-axonic synaptic connection strength	******/

#define MAXASTR_MIN	0	/* unit: - */
#define MAXASTR_MAX	1	/* unit: - */
#define MAXASTR_DEF	0.8	/* unit: - */

/******	simulation step size			******/

#define SIMSIZE_MIN	0.001	/* unit: ms */
#define SIMSIZE_MAX	5	/* unit: ms */
#define SIMSIZE_DEF	0.1	/* unit: ms */

/******	simulation duration			******/

#define SIMLEN_MIN	5	/* unit: ms */
#define SIMLEN_MAX	60000	/* unit: ms */
#define SIMLEN_DEF	1000	/* unit: ms */

/******	neuron activity interval		******/

#define NACTINT_MIN	1	/* unit: - */
#define NACTINT_MAX	100	/* unit: - */
#define NACTINT_DEF	10	/* unit: - */

/******	synaptic transmission time		******/

#define TT_MIN		SIMSIZE_MIN	/* unit: ms */
#define TT_MAX		SIMLEN_DEF	/* unit: ms */
#define TT_DEF		1		/* unit: ms */

/******	transmitter release threshold		******/

#define TRT_MIN		-200	/* unit: mV */
#define TRT_MAX		200	/* unit: mV */
#define TRT_DEF		-40	/* unit: mV */

/******	transmitter satiation threshold		******/

#define TRS_MIN		-200	/* unit: mV */
#define TRS_MAX		200	/* unit: mV */
#define TRS_DEF		50	/* unit: mV */

/******	synaptic location			******/

#define TARGET_MIN	0	/* unit: - */
#define TARGET_MAX	20	/* unit: - */
#define TARGET_DEF	0	/* unit: - */

/******	slope of learning curve			******/

#define SLOPE_MIN	0.01	/* unit: - */
#define SLOPE_MAX	1	/* unit: - */
#define SLOPE_DEF	0.2	/* unit: - */

/******	short term memory 			******/

#define STM_MIN		1	/* unit: s */
#define STM_MAX		1000	/* unit: s */
#define STM_DEF		20	/* unit: s */

/******	long term threshold 			******/

#define LTT_MIN		0	/* unit: - */
#define LTT_MAX		1	/* unit: - */
#define LTT_DEF		0.5	/* unit: - */

/******	long term minimum 			******/

#define LTM_MIN		0	/* unit: % */
#define LTM_MAX		100	/* unit: % */
#define LTM_DEF		25	/* unit: % */

/******	hebb intervall 				******/

#define HI_MIN		1	/* unit: ms */
#define HI_MAX		1000	/* unit: ms */
#define HI_DEF		3	/* unit: ms */

/******	hebb learn factor			******/

#define HLF_MIN		0	/* unit: - */
#define HLF_MAX		10	/* unit: - */
#define HLF_DEF		1	/* unit: - */

/******	competitive learn factor		******/

#define COMPLF_MIN	0.0	/* unit: - */
#define COMPLF_MAX	1.0	/* unit: - */
#define COMPLF_DEF	0.1	/* unit: - */

/******	short term plasticity learn factor	******/

#define KLF_MIN		-10	/* unit: - */
#define KLF_MAX		10	/* unit: - */
#define KLF_DEF		1	/* unit: - */

/******	conditioning learn factor		******/

#define CLF_MIN		-10	/* unit: - */
#define CLF_MAX		10	/* unit: - */
#define CLF_DEF		1	/* unit: - */

/******	external soma current			******/

#define SCUR_MIN	-100	/* unit: nA */
#define SCUR_MAX	100	/* unit: nA */
#define SCUR_DEF	0	/* unit: nA */

/******	external dendrite current		******/

#define DCUR_MIN	-1000	/* unit: nA */
#define DCUR_MAX	1000	/* unit: nA */
#define DCUR_DEF	0	/* unit: nA */

/******	start time for external soma current 	******/

#define SSTART_MIN	0		/* unit: ms */
#define SSTART_MAX	SIMLEN_MAX	/* unit: ms */
#define SSTART_DEF	0		/* unit: ms */

/******	end time for external soma current	******/

#define SEND_MIN	0		/* unit: ms */
#define SEND_MAX	SIMLEN_MAX	/* unit: ms */
#define SEND_DEF	SIMLEN_DEF	/* unit: ms */

/******	start time for external dendrite current ******/

#define DSTART_MIN	0		/* unit: ms */
#define DSTART_MAX	SIMLEN_MAX	/* unit: ms */
#define DSTART_DEF	0		/* unit: ms */

/******	end time for external dendrite current	******/

#define DEND_MIN	0		/* unit: ms */
#define DEND_MAX	SIMLEN_MAX	/* unit: ms */
#define DEND_DEF	SIMLEN_DEF	/* unit: ms */

/******	synaptic equilibrium potential		******/

#define SEQ_MIN		-200		/* unit: mV */
#define SEQ_MAX		200		/* unit: mV */
#define SEQ_DEF		-90		/* unit: mV */

/******	scaling of x-axis			******/

#define XSC_MIN		0		/* unit: ms */
#define XSSC_DEF	0		/* unit: ms */
#define XESC_DEF	SIMLEN_DEF	/* unit: ms */

/******	scaling of y-axis			******/

#define YSC_MIN		-1000000	/* unit: mV */
#define YSC_MAX		1000000		/* unit: mV */
#define YSSC_DEF	-90		/* unit: mV */
#define YESC_DEF	60		/* unit: mV */

/******	zooming of x-axis			******/

#define XZO_MIN		0.1		/* unit: - */
#define XZO_MAX		1000		/* unit: - */
#define XZO_DEF		1		/* unit: - */

/******	zooming of y-axis			******/

#define YZO_MIN		0.1		/* unit: - */
#define YZO_MAX		1000		/* unit: - */
#define YZO_DEF		1		/* unit: - */

/******	graph output interval			******/

#define ASCOUT_MIN	SIMSIZE_MIN	/* unit: ms */
#define ASCOUT_MAX	100		/* unit: ms */
#define ASCOUT_DEF	SIMSIZE_DEF	/* unit: ms */

/****** noise parameters			******/

#define NOISE_INTENSITY	1000		/* unit: - */
#define NOISE_STRENGTH	1.0		/* unit: nA */
#define NOISE_DECAY	1.0		/* unit: ms */

/****** standard deviation parameter		******/

#define IPOT_STD	5.0		/* unit: - */
#define SYNG_STD	200.0		/* unit: - */
#define AXOS_STD	0.1		/* unit: - */
#define SYNT_STD	0.5   		/* unit: - */
