/************************************************************************************************************************

	PROGRAM:	BIOSIM

	FILENAME:	neurvars.h

	PURPOSE:	abbreviations of variables frequently used in calculation of BIOSIM

************************************************************************************************************************/


/******	Soma Definitions ******/


#define    SOMA_REST_Gm 	    currentNeuron->neuronParameters[SOMA_PLACE + 0]
#define    SOMA_Eleak_INITIAL	    currentNeuron->neuronParameters[SOMA_PLACE + 1]
#define    SOMA_Cm		    currentNeuron->neuronParameters[SOMA_PLACE + 2]
#define    SOMA_E_INITIAL	    currentNeuron->neuronParameters[SOMA_PLACE + 3]
#define    SOMA_Gcore		    currentNeuron->neuronParameters[SOMA_PLACE + 4]


/******	Dendrite Definitions ******/


#define	   ACTUAL_DENDRITIC_STEMS   currentNeuron->neuronParameters[DENDRITE_PLACE + 0]
#define    ACTUAL_DENDRITIC_REGIONS currentNeuron->neuronParameters[DENDRITE_PLACE + 1]
#define    DENDRITE_REST_Gm	    currentNeuron->neuronParameters[DENDRITE_PLACE + 2]
#define    DENDRITE_Eleak_INITIAL   currentNeuron->neuronParameters[DENDRITE_PLACE + 3]
#define    DENDRITE_Cm		    currentNeuron->neuronParameters[DENDRITE_PLACE + 4]
#define    DENDRITE_Gcore	    currentNeuron->neuronParameters[DENDRITE_PLACE + 5]
#define    DENDRITE_E_INITIAL	    currentNeuron->neuronParameters[DENDRITE_PLACE + 6]


/******	Onoff Definitions	******/


#define  ONOFF_NA_E		currentNeuron->neuronParameters[ONOFF_PLACE+0]
#define  ONOFF_NA_CONDUCTANCE   currentNeuron->neuronParameters[ONOFF_PLACE+1]
#define  ONOFF_NA_DURATION	currentNeuron->neuronParameters[ONOFF_PLACE+2]
#define  ONOFF_K_E		currentNeuron->neuronParameters[ONOFF_PLACE+3]
#define  ONOFF_K_CONDUCTANCE    currentNeuron->neuronParameters[ONOFF_PLACE+4]
#define  ONOFF_K_START          currentNeuron->neuronParameters[ONOFF_PLACE+5]
#define  ONOFF_K_DURATION	currentNeuron->neuronParameters[ONOFF_PLACE+6]
#define  ONOFF_CA_E		currentNeuron->neuronParameters[ONOFF_PLACE+7]
#define  ONOFF_CA_CONDUCTANCE   currentNeuron->neuronParameters[ONOFF_PLACE+8]
#define  ONOFF_CA_START         currentNeuron->neuronParameters[ONOFF_PLACE+9]
#define  ONOFF_CA_DURATION	currentNeuron->neuronParameters[ONOFF_PLACE+10]
#define  ONOFF_SPIKE_THRESHOLD	currentNeuron->neuronParameters[ONOFF_PLACE+11]


/******	Hodgkin-Huxley Definitions *****/


#define	   HH_NA_E 		   currentNeuron->neuronParameters[HH_PLACE + 0]
#define    HH_NA_G 		   currentNeuron->neuronParameters[HH_PLACE + 1]
#define    HH_K_E		   currentNeuron->neuronParameters[HH_PLACE + 2]
#define    HH_K_G		   currentNeuron->neuronParameters[HH_PLACE + 3]
#define    HH_Form_Alpha_M	   currentNeuron->neuronParameters[HH_PLACE + 4]
#define    HH_AalphaM		   currentNeuron->neuronParameters[HH_PLACE + 5]
#define    HH_V0alphaM		   currentNeuron->neuronParameters[HH_PLACE + 6]
#define    HH_BalphaM		   currentNeuron->neuronParameters[HH_PLACE + 7]
#define    HH_Form_Beta_M	   currentNeuron->neuronParameters[HH_PLACE + 8]
#define    HH_AbetaM		   currentNeuron->neuronParameters[HH_PLACE + 9]
#define    HH_V0betaM		   currentNeuron->neuronParameters[HH_PLACE + 10]
#define    HH_BbetaM		   currentNeuron->neuronParameters[HH_PLACE + 11]
#define    HH_M_POWER		   currentNeuron->neuronParameters[HH_PLACE + 12]
#define    HH_M_INITIAL	   	   currentNeuron->neuronParameters[HH_PLACE + 13]
#define    HH_Form_Alpha_H	   currentNeuron->neuronParameters[HH_PLACE + 14]
#define    HH_AalphaH		   currentNeuron->neuronParameters[HH_PLACE + 15]
#define    HH_V0alphaH		   currentNeuron->neuronParameters[HH_PLACE + 16]
#define    HH_BalphaH		   currentNeuron->neuronParameters[HH_PLACE + 17]
#define    HH_Form_Beta_H	   currentNeuron->neuronParameters[HH_PLACE + 18]
#define    HH_AbetaH		   currentNeuron->neuronParameters[HH_PLACE + 19]
#define    HH_V0betaH		   currentNeuron->neuronParameters[HH_PLACE + 20]
#define    HH_BbetaH		   currentNeuron->neuronParameters[HH_PLACE + 21]
#define    HH_H_POWER		   currentNeuron->neuronParameters[HH_PLACE + 22]
#define    HH_H_INITIAL	   	   currentNeuron->neuronParameters[HH_PLACE + 23]
#define    HH_Form_Alpha_N	   currentNeuron->neuronParameters[HH_PLACE + 24]
#define    HH_AalphaN		   currentNeuron->neuronParameters[HH_PLACE + 25]
#define    HH_V0alphaN		   currentNeuron->neuronParameters[HH_PLACE + 26]
#define    HH_BalphaN		   currentNeuron->neuronParameters[HH_PLACE + 27]
#define    HH_Form_Beta_N	   currentNeuron->neuronParameters[HH_PLACE + 28]
#define    HH_AbetaN		   currentNeuron->neuronParameters[HH_PLACE + 29]
#define    HH_V0betaN		   currentNeuron->neuronParameters[HH_PLACE + 30]
#define    HH_BbetaN		   currentNeuron->neuronParameters[HH_PLACE + 31]
#define    HH_N_POWER		   currentNeuron->neuronParameters[HH_PLACE + 32]
#define    HH_N_INITIAL	   	   currentNeuron->neuronParameters[HH_PLACE + 33]
#define    HH_SPIKE_THRESHOLD      currentNeuron->neuronParameters[HH_PLACE + 34]


/******	SWIM Definitions *****/


#define	   SWIM_NA_E 		   currentNeuron->neuronParameters[SWIM_PLACE + 0]
#define    SWIM_NA_G 		   currentNeuron->neuronParameters[SWIM_PLACE + 1]
#define    SWIM_Form_Alpha_M	   currentNeuron->neuronParameters[SWIM_PLACE + 2]
#define    SWIM_AalphaM		   currentNeuron->neuronParameters[SWIM_PLACE + 3]
#define    SWIM_V0alphaM	   currentNeuron->neuronParameters[SWIM_PLACE + 4]
#define    SWIM_BalphaM		   currentNeuron->neuronParameters[SWIM_PLACE + 5]
#define    SWIM_Form_Beta_M	   currentNeuron->neuronParameters[SWIM_PLACE + 6]
#define    SWIM_AbetaM		   currentNeuron->neuronParameters[SWIM_PLACE + 7]
#define    SWIM_V0betaM		   currentNeuron->neuronParameters[SWIM_PLACE + 8]
#define    SWIM_BbetaM		   currentNeuron->neuronParameters[SWIM_PLACE + 9]
#define    SWIM_M_POWER		   currentNeuron->neuronParameters[SWIM_PLACE + 10]
#define    SWIM_M_INITIAL	   currentNeuron->neuronParameters[SWIM_PLACE + 11]
#define    SWIM_Form_Alpha_H	   currentNeuron->neuronParameters[SWIM_PLACE + 12]
#define    SWIM_AalphaH		   currentNeuron->neuronParameters[SWIM_PLACE + 13]
#define    SWIM_V0alphaH	   currentNeuron->neuronParameters[SWIM_PLACE + 14]
#define    SWIM_BalphaH		   currentNeuron->neuronParameters[SWIM_PLACE + 15]
#define    SWIM_Form_Beta_H	   currentNeuron->neuronParameters[SWIM_PLACE + 16]
#define    SWIM_AbetaH		   currentNeuron->neuronParameters[SWIM_PLACE + 17]
#define    SWIM_V0betaH		   currentNeuron->neuronParameters[SWIM_PLACE + 18]
#define    SWIM_BbetaH		   currentNeuron->neuronParameters[SWIM_PLACE + 19]
#define    SWIM_H_POWER		   currentNeuron->neuronParameters[SWIM_PLACE + 20]
#define    SWIM_H_INITIAL	   currentNeuron->neuronParameters[SWIM_PLACE + 21]
#define    SWIM_K_E		   currentNeuron->neuronParameters[SWIM_PLACE + 22]
#define    SWIM_K_G		   currentNeuron->neuronParameters[SWIM_PLACE + 23]
#define    SWIM_Form_Alpha_N	   currentNeuron->neuronParameters[SWIM_PLACE + 24]
#define    SWIM_AalphaN		   currentNeuron->neuronParameters[SWIM_PLACE + 25]
#define    SWIM_V0alphaN	   currentNeuron->neuronParameters[SWIM_PLACE + 26]
#define    SWIM_BalphaN		   currentNeuron->neuronParameters[SWIM_PLACE + 27]
#define    SWIM_Form_Beta_N	   currentNeuron->neuronParameters[SWIM_PLACE + 28]
#define    SWIM_AbetaN		   currentNeuron->neuronParameters[SWIM_PLACE + 29]
#define    SWIM_V0betaN		   currentNeuron->neuronParameters[SWIM_PLACE + 30]
#define    SWIM_BbetaN		   currentNeuron->neuronParameters[SWIM_PLACE + 31]
#define    SWIM_N_POWER		   currentNeuron->neuronParameters[SWIM_PLACE + 32]
#define    SWIM_N_INITIAL	   currentNeuron->neuronParameters[SWIM_PLACE + 33]
#define    SWIM_CA_E 		   currentNeuron->neuronParameters[SWIM_PLACE + 34]
#define    SWIM_CA_G 		   currentNeuron->neuronParameters[SWIM_PLACE + 35]
#define    SWIM_Form_Alpha_C	   currentNeuron->neuronParameters[SWIM_PLACE + 36]
#define    SWIM_AalphaC		   currentNeuron->neuronParameters[SWIM_PLACE + 37]
#define    SWIM_V0alphaC	   currentNeuron->neuronParameters[SWIM_PLACE + 38]
#define    SWIM_BalphaC		   currentNeuron->neuronParameters[SWIM_PLACE + 39]
#define    SWIM_Form_Beta_C	   currentNeuron->neuronParameters[SWIM_PLACE + 40]
#define    SWIM_AbetaC		   currentNeuron->neuronParameters[SWIM_PLACE + 41]
#define    SWIM_V0betaC		   currentNeuron->neuronParameters[SWIM_PLACE + 42]
#define    SWIM_BbetaC		   currentNeuron->neuronParameters[SWIM_PLACE + 43]
#define    SWIM_C_POWER		   currentNeuron->neuronParameters[SWIM_PLACE + 44]
#define    SWIM_C_INITIAL	   currentNeuron->neuronParameters[SWIM_PLACE + 45]
#define	   SWIM_SPIKE_THRESHOLD	   currentNeuron->neuronParameters[SWIM_PLACE + 46]


/******	Golowasch-Buchholz Definitions	******/


#define    GB_CA_INITIAL	   currentNeuron->neuronParameters[GB_PLACE + 0]
#define    GB_K_ICA		   currentNeuron->neuronParameters[GB_PLACE + 1]
#define    GB_K_CA		   currentNeuron->neuronParameters[GB_PLACE + 2]
#define    GB_C0_CA		   currentNeuron->neuronParameters[GB_PLACE + 3]
#define    GB_CA_CA		   currentNeuron->neuronParameters[GB_PLACE + 4]
#define    GB_TEMP		   currentNeuron->neuronParameters[GB_PLACE + 5]
#define    GB_M_POWER		   currentNeuron->neuronParameters[GB_PLACE + 6]
#define    GB_M_INITIAL		   currentNeuron->neuronParameters[GB_PLACE + 7]
#define    GB_H_POWER		   currentNeuron->neuronParameters[GB_PLACE + 8]
#define    GB_H_INITIAL		   currentNeuron->neuronParameters[GB_PLACE + 9]
#define    GB_NA_G		   currentNeuron->neuronParameters[GB_PLACE + 10]
#define    GB_NA_E		   currentNeuron->neuronParameters[GB_PLACE + 11]
#define    GB_Form_Alpha_M	   currentNeuron->neuronParameters[GB_PLACE + 12]
#define    GB_AalphaM		   currentNeuron->neuronParameters[GB_PLACE + 13]
#define    GB_V0alphaM		   currentNeuron->neuronParameters[GB_PLACE + 14]
#define    GB_BalphaM		   currentNeuron->neuronParameters[GB_PLACE + 15]
#define    GB_Form_Beta_M	   currentNeuron->neuronParameters[GB_PLACE + 16]
#define    GB_AbetaM		   currentNeuron->neuronParameters[GB_PLACE + 17]
#define    GB_V0betaM		   currentNeuron->neuronParameters[GB_PLACE + 18]
#define    GB_BbetaM		   currentNeuron->neuronParameters[GB_PLACE + 19]
#define    GB_Form_Alpha_H	   currentNeuron->neuronParameters[GB_PLACE + 20]
#define    GB_AalphaH		   currentNeuron->neuronParameters[GB_PLACE + 21]
#define    GB_V0alphaH		   currentNeuron->neuronParameters[GB_PLACE + 22]
#define    GB_BalphaH		   currentNeuron->neuronParameters[GB_PLACE + 23]
#define    GB_Form_Beta_H	   currentNeuron->neuronParameters[GB_PLACE + 24]
#define    GB_AbetaH		   currentNeuron->neuronParameters[GB_PLACE + 25]
#define    GB_V0betaH		   currentNeuron->neuronParameters[GB_PLACE + 26]
#define    GB_BbetaH		   currentNeuron->neuronParameters[GB_PLACE + 27]
#define    GB_N_POWER		   currentNeuron->neuronParameters[GB_PLACE + 28]
#define    GB_N_INITIAL		   currentNeuron->neuronParameters[GB_PLACE + 29]
#define    GB_K_G		   currentNeuron->neuronParameters[GB_PLACE + 30]
#define    GB_K_E		   currentNeuron->neuronParameters[GB_PLACE + 31]
#define    GB_Form_Alpha_N	   currentNeuron->neuronParameters[GB_PLACE + 32]
#define    GB_AinfinityN	   currentNeuron->neuronParameters[GB_PLACE + 33]
#define    GB_V0infinityN	   currentNeuron->neuronParameters[GB_PLACE + 34]
#define    GB_BinfinityN	   currentNeuron->neuronParameters[GB_PLACE + 35]
#define    GB_Form_Beta_N	   currentNeuron->neuronParameters[GB_PLACE + 36]
#define    GB_AtauN		   currentNeuron->neuronParameters[GB_PLACE + 37]
#define    GB_V0tauN		   currentNeuron->neuronParameters[GB_PLACE + 38]
#define    GB_BtauN		   currentNeuron->neuronParameters[GB_PLACE + 39]
#define    GB_A_POWER		   currentNeuron->neuronParameters[GB_PLACE + 40]
#define    GB_A_INITIAL		   currentNeuron->neuronParameters[GB_PLACE + 41]
#define    GB_B1_POWER		   currentNeuron->neuronParameters[GB_PLACE + 42]
#define    GB_B1_INITIAL	   currentNeuron->neuronParameters[GB_PLACE + 43]
#define    GB_B2_POWER		   currentNeuron->neuronParameters[GB_PLACE + 44]
#define    GB_B2_INITIAL	   currentNeuron->neuronParameters[GB_PLACE + 45]
#define    GB_G_POWER		   currentNeuron->neuronParameters[GB_PLACE + 46]
#define    GB_G_INITIAL		   currentNeuron->neuronParameters[GB_PLACE + 47]
#define    GB_A_G		   currentNeuron->neuronParameters[GB_PLACE + 48]
#define    GB_A_E		   currentNeuron->neuronParameters[GB_PLACE + 49]
#define    GB_Form_Alpha_A	   currentNeuron->neuronParameters[GB_PLACE + 50]
#define    GB_V0a		   currentNeuron->neuronParameters[GB_PLACE + 51]
#define    GB_Ba		   currentNeuron->neuronParameters[GB_PLACE + 52]
#define    GB_Form_Beta_A	   currentNeuron->neuronParameters[GB_PLACE + 53]
#define    GB_Ta		   currentNeuron->neuronParameters[GB_PLACE + 54]
#define    GB_Form_Alpha_B1   	   currentNeuron->neuronParameters[GB_PLACE + 55]
#define    GB_V0b1		   currentNeuron->neuronParameters[GB_PLACE + 56]
#define    GB_Bb1		   currentNeuron->neuronParameters[GB_PLACE + 57]
#define    GB_Form_Beta_B1	   currentNeuron->neuronParameters[GB_PLACE + 58]
#define    GB_Tb1		   currentNeuron->neuronParameters[GB_PLACE + 59]
#define    GB_Form_Alpha_B2   	   currentNeuron->neuronParameters[GB_PLACE + 60]
#define    GB_V0alphab2		   currentNeuron->neuronParameters[GB_PLACE + 61]
#define    GB_Balphab2		   currentNeuron->neuronParameters[GB_PLACE + 62]
#define    GB_Form_Beta_B2	   currentNeuron->neuronParameters[GB_PLACE + 63]
#define    GB_Ab2		   currentNeuron->neuronParameters[GB_PLACE + 64]
#define    GB_V0b2		   currentNeuron->neuronParameters[GB_PLACE + 65]
#define    GB_Bb2		   currentNeuron->neuronParameters[GB_PLACE + 66]
#define    GB_V0g		   currentNeuron->neuronParameters[GB_PLACE + 67]
#define    GB_Bg		   currentNeuron->neuronParameters[GB_PLACE + 68]
#define    GB_C_POWER		   currentNeuron->neuronParameters[GB_PLACE + 69]
#define    GB_C_INITIAL		   currentNeuron->neuronParameters[GB_PLACE + 70]
#define    GB_D_POWER		   currentNeuron->neuronParameters[GB_PLACE + 71]
#define    GB_D_INITIAL		   currentNeuron->neuronParameters[GB_PLACE + 72]
#define    GB_CA1_G		   currentNeuron->neuronParameters[GB_PLACE + 73]
#define    GB_Form_Alpha_C	   currentNeuron->neuronParameters[GB_PLACE + 74]
#define    GB_V0c		   currentNeuron->neuronParameters[GB_PLACE + 75]
#define    GB_Bc		   currentNeuron->neuronParameters[GB_PLACE + 76]
#define    GB_Form_Beta_C	   currentNeuron->neuronParameters[GB_PLACE + 77]
#define    GB_Tc		   currentNeuron->neuronParameters[GB_PLACE + 78]
#define    GB_Form_Alpha_D	   currentNeuron->neuronParameters[GB_PLACE + 79]
#define    GB_V0d		   currentNeuron->neuronParameters[GB_PLACE + 80]
#define    GB_Bd		   currentNeuron->neuronParameters[GB_PLACE + 81]
#define    GB_Form_Beta_D	   currentNeuron->neuronParameters[GB_PLACE + 82]
#define    GB_Td		   currentNeuron->neuronParameters[GB_PLACE + 83]
#define    GB_E_POWER		   currentNeuron->neuronParameters[GB_PLACE + 84]
#define    GB_E_INITIAL		   currentNeuron->neuronParameters[GB_PLACE + 85]
#define    GB_CA2_G		   currentNeuron->neuronParameters[GB_PLACE + 86]
#define    GB_Form_Alpha_E	   currentNeuron->neuronParameters[GB_PLACE + 87]
#define    GB_V0e		   currentNeuron->neuronParameters[GB_PLACE + 88]
#define    GB_Be		   currentNeuron->neuronParameters[GB_PLACE + 89]
#define    GB_Form_Beta_E	   currentNeuron->neuronParameters[GB_PLACE + 90]
#define    GB_Te		   currentNeuron->neuronParameters[GB_PLACE + 91]
#define    GB_P_POWER		   currentNeuron->neuronParameters[GB_PLACE + 92]
#define    GB_P_INITIAL		   currentNeuron->neuronParameters[GB_PLACE + 93]
#define    GB_Q_POWER		   currentNeuron->neuronParameters[GB_PLACE + 94]
#define    GB_Q_INITIAL		   currentNeuron->neuronParameters[GB_PLACE + 95]
#define    GB_KCA_G		   currentNeuron->neuronParameters[GB_PLACE + 96]
#define    GB_KCA_E		   currentNeuron->neuronParameters[GB_PLACE + 97]
#define    GB_Form_Alpha_P	   currentNeuron->neuronParameters[GB_PLACE + 98]
#define    GB_V0p1		   currentNeuron->neuronParameters[GB_PLACE + 99]
#define    GB_Bp1		   currentNeuron->neuronParameters[GB_PLACE + 100]
#define    GB_Form_Beta_P	   currentNeuron->neuronParameters[GB_PLACE + 101]
#define    GB_V0p2		   currentNeuron->neuronParameters[GB_PLACE + 102]
#define    GB_Bp2		   currentNeuron->neuronParameters[GB_PLACE + 103]
#define    GB_Tp		   currentNeuron->neuronParameters[GB_PLACE + 104]
#define    GB_Cca		   currentNeuron->neuronParameters[GB_PLACE + 105]
#define    GB_C1		   currentNeuron->neuronParameters[GB_PLACE + 106]
#define    GB_Form_Alpha_Q	   currentNeuron->neuronParameters[GB_PLACE + 107]
#define    GB_C2		   currentNeuron->neuronParameters[GB_PLACE + 108]
#define    GB_C3		   currentNeuron->neuronParameters[GB_PLACE + 109]
#define    GB_Form_Beta_Q	   currentNeuron->neuronParameters[GB_PLACE + 110]
#define    GB_Tq		   currentNeuron->neuronParameters[GB_PLACE + 111]
#define    GB_R_POWER		   currentNeuron->neuronParameters[GB_PLACE + 112]
#define    GB_R_INITIAL		   currentNeuron->neuronParameters[GB_PLACE + 113]
#define    GB_IR_G		   currentNeuron->neuronParameters[GB_PLACE + 114]
#define    GB_IR_E		   currentNeuron->neuronParameters[GB_PLACE + 115]
#define    GB_Form_Alpha_R	   currentNeuron->neuronParameters[GB_PLACE + 116]
#define    GB_V0r		   currentNeuron->neuronParameters[GB_PLACE + 117]
#define    GB_Br		   currentNeuron->neuronParameters[GB_PLACE + 118]
#define    GB_Form_Beta_R	   currentNeuron->neuronParameters[GB_PLACE + 119]
#define    GB_Atau_r		   currentNeuron->neuronParameters[GB_PLACE + 120]
#define    GB_V0tau_r		   currentNeuron->neuronParameters[GB_PLACE + 121]
#define    GB_Btau_r		   currentNeuron->neuronParameters[GB_PLACE + 122]
#define    GB_S_POWER		   currentNeuron->neuronParameters[GB_PLACE + 123]
#define    GB_S_INITIAL		   currentNeuron->neuronParameters[GB_PLACE + 124]
#define    GB_P_G		   currentNeuron->neuronParameters[GB_PLACE + 125]
#define    GB_P_E		   currentNeuron->neuronParameters[GB_PLACE + 126]
#define    GB_Form_Alpha_S	   currentNeuron->neuronParameters[GB_PLACE + 127]
#define    GB_V0s		   currentNeuron->neuronParameters[GB_PLACE + 128]
#define    GB_Bs		   currentNeuron->neuronParameters[GB_PLACE + 129]
#define    GB_Form_Beta_S	   currentNeuron->neuronParameters[GB_PLACE + 130]
#define    GB_Ts		   currentNeuron->neuronParameters[GB_PLACE + 131]
#define    GB_SPIKE_THRESHOLD      currentNeuron->neuronParameters[GB_PLACE + 132]


/******	General Simulation Variables ******/


#define    LTSTOP		   simulation.length
#define    STEP 		   simulation.step


/******	Needed Variables for each neuron	******/


#define	   GB_GAMMA		currentNeuron->gamma
#define	   GB_CONC_CA		currentNeuron->conc_ca
#define    GB_CA_E		currentNeuron->ca_e
#define    GB_I_A		currentNeuron->iA
#define    GB_I_CA1		currentNeuron->iCA1
#define    GB_I_CA2		currentNeuron->iCA2
#define    GB_I_KCA		currentNeuron->iKCA
#define    GB_I_IR		currentNeuron->iIR
#define    GB_I_P		currentNeuron->iP
#define	   I_NA 		currentNeuron->iNA
#define	   I_K			currentNeuron->iK
#define	   I_CA			currentNeuron->iCA
#define    M_CONST		currentNeuron->M
#define    N_CONST		currentNeuron->N
#define    H_CONST		currentNeuron->H
#define    A_CONST		currentNeuron->A
#define    B1_CONST		currentNeuron->B1
#define    B2_CONST		currentNeuron->B2
#define    G_CONST		currentNeuron->G
#define    C_CONST		currentNeuron->C
#define    D_CONST		currentNeuron->D
#define    E_CONST		currentNeuron->E
#define    P_CONST		currentNeuron->P
#define    Q_CONST		currentNeuron->Q
#define    R_CONST		currentNeuron->R
#define    S_CONST		currentNeuron->S
#define    E_POT		currentNeuron->neuronPotentials
#define    SomaCur		currentNeuron->somaCurrent
#define    SCSTRT		currentNeuron->somaSCStart
#define    SCSTP		currentNeuron->somaSCEnd
#define    DendCur		currentNeuron->dendCurrent
#define    SDSTRT		currentNeuron->dendSCStart
#define    SDSTP		currentNeuron->dendSCEnd
#define	   ActualIRegion	currentNeuron->dendSCLocation
#define	   IRegion		currentNeuron->usedDendSCLocation
#define    ActualIStem		currentNeuron->dendSCStem
#define    IStem		currentNeuron->usedDendSCStem
#define	   ICUR			currentNeuron->inputCurrent
#define    ICH			currentNeuron->currentChemical
#define	   IEL			currentNeuron->currentElectrical
#define    I_NOISE		currentNeuron->iNoise
#define	   SPIKE		currentNeuron->onoffSpikeTimer
#define	   SPIKE_IN_PROCESS	currentNeuron->onoffSpikeOccuring
#define    SpikeCounter		currentNeuron->spikeCnt
#define    Noise		currentNeuron->noise
#define	   DENDRITE_STEMS	currentNeuron->neuronStems
#define	   DENDRITE_REGIONS	currentNeuron->neuronRegions
#define    SynCur		currentNeuron->synapticCurrent
#define    TotCur		currentNeuron->totalCurrent
#define    PseudoSomaCur	currentNeuron->pseudoSomaCurrent
#define    PseudoSCSTRT		currentNeuron->pseudoSCStart
#define    PseudoSCSTP		currentNeuron->pseudoSCEnd
#define    SLmSG		currentNeuron->SLmSG_const
#define    SGmDSmDG		currentNeuron->SGmDSmDG_const
#define    DLmDG		currentNeuron->DLmDG_const
#define    SGdSC		currentNeuron->SGdSC_const
#define    SGpDSmDG		currentNeuron->SGpDSmDG_const
#define    SGpDSmDGdSC		currentNeuron->SGpDSmDGdSC_const
#define    SWIM_NAEmNAG		currentNeuron->SWIM_NAEmNAG_const
#define    SWIM_KEmKG		currentNeuron->SWIM_KEmKG_const
#define    SWIM_CAEmCAG		currentNeuron->SWIM_CAEmCAG_const
#define    HH_NAEmNAG		currentNeuron->HH_NAEmNAG_const
#define    HH_KEmKG		currentNeuron->HH_KEmKG_const
#define    GB_NAEmNAG		currentNeuron->GB_NAEmNAG_const
#define    GB_KEmKG		currentNeuron->GB_KEmKG_const
#define    GB_AEmAG		currentNeuron->GB_AEmAG_const
#define    GB_KCAEmKCAG		currentNeuron->GB_KCAEmKCAG_const
#define    GB_IREmIRG		currentNeuron->GB_IREmIRG_const
#define    GB_PEmPG		currentNeuron->GB_PEmPG_const

#define    TTdSS		currentSynapse->TTdSS_const
#define    TSmTRT		currentSynapse->TSmTRT_const
#define    LEXP			currentSynapse->LEXP_const
#define    SFCONST		currentSynapse->SFCONST_const
#define    LFCONST              currentSynapse->LFCONST_const

#define    LTTdSS		currentPool->LTTdSS_const

#define    DSeg			currentGraph->dendritSegment
#define    SOMA			currentGraph->soma
#define    DENDRITE		currentGraph->dend
#define    SYNC			currentGraph->synC
#define    TOTC			currentGraph->totC
#define    INA			currentGraph->iNA
#define    IK			currentGraph->iK
#define    ICA			currentGraph->iCA
#define    ICA1			currentGraph->iCA1
#define    ICA2			currentGraph->iCA2
#define    IKCA			currentGraph->iKCA
#define    IA			currentGraph->iA
#define    IIR			currentGraph->iIR
#define	   IP			currentGraph->iP
#define    IN			currentGraph->iN

#define    MEM			currentGraphS->mem
#define    POT			currentGraphS->pot
#define    STR			currentGraphS->str
#define    CON			currentGraphS->con
