/************************************************************************************************************************

	PROGRAM:	BIOSIM

	FILENAME:	menu4.c

	PURPOSE:	dialog handling for complex models

	FUNCTIONS:	in order of appearance

	- create_axoSynapse			create dialog box for axo-axonic connections
	- create_learnParam			create dialog box for learn parameter
	- dialog_text4_CB			handles callbacks for text widgets
	- dialog_scale4_CB			handles callbacks for scale widgets
	- dialog_def4_CB			handles callbacks for default buttons
	- dialog_accept4_CB			handles callbacks for ok buttons
	- dialog_help4_CB			handles callbacks for help buttons

************************************************************************************************************************/

#ifndef BATCH
#include "copying.h"
#include "biosim.h"
#include "functions.h"
#include "menu4.h"

/****** global variables ******/

Widget axoSynapseBB;					/* bulletin board in axo-axonic dialog */
Widget learnParamBB;					/* bulletin board in learn parameter dialog */
Widget axoSynapseTTText;				/* text widget in axo-axonic dialog */
Widget axoSynapseTTScale;				/* scale widget in axo-axonic dialog */
Widget axoSynapseStrText;				/* text widget in axo-axonic dialog */
Widget axoSynapseStrScale;				/* scale widget in axo-axonic dialog */
Widget axoSynapseMaxStrText;				/* text widget in axo-axonic dialog */
Widget axoSynapseMaxStrScale;				/* scale widget in axo-axonic dialog */
Widget axoSynapseTRTText;               	        /* text widget in axo-axonic dialog */
Widget axoSynapseTRTScale;              	        /* scale widget in axo-axonic dialog */
Widget axoSynapseTRSText;               	        /* text widget in axo-axonic dialog */
Widget axoSynapseTRSScale;              	        /* scale widget in axo-axonic dialog */
Widget axoSynapseLearnButton;				/* learn parameter button in axo-axonic dialog */

/****** local variables ******/

static Widget learnParamSlopeText;			/* text widget in learn parameter dialog */
static Widget learnParamSlopeScale;			/* scale widget in learn parameter dialog */
static Widget learnParamSTMText;			/* text widget in learn parameter dialog */
static Widget learnParamSTMScale;			/* scale widget in learn parameter dialog */
static Widget learnParamLTThresholdText;		/* text widget in learn parameter dialog */
static Widget learnParamLTThresholdScale;		/* scale widget in learn parameter dialog */
static Widget learnParamLTMinimumText;			/* text widget in learn parameter dialog */
static Widget learnParamLTMinimumScale;			/* scale widget in learn parameter dialog */
static Widget learnParamHIText;				/* text widget in learn parameter dialog */
static Widget learnParamHIScale;			/* scale widget in learn parameter dialog */
static Widget learnParamHLFText;			/* text widget in learn parameter dialog */
static Widget learnParamHLFScale;			/* scale widget in learn parameter dialog */
static Widget learnParamCompLFText;			/* text widget in learn parameter dialog */
static Widget learnParamCompLFScale;			/* scale widget in learn parameter dialog */
static Widget learnParamKLFText;			/* text widget in learn parameter dialog */
static Widget learnParamKLFScale;			/* scale widget in learn parameter dialog */
static Widget learnParamCLFText;			/* text widget in learn parameter dialog */
static Widget learnParamCLFScale;			/* scale widget in learn parameter dialog */

static struct SynapseSelection synapseSelection;	/* selected synapse learn parameters */
static double TT;
static double STRENGTH;
static double MAXSTR;
static double TRT;
static double TRS;
static double SLOPE;
static double STM;
static double LTT;
static double LTM;
static double HI;
static double HLF;
static double COMPLF;
static double KLF;
static double CLF;

/****** functions       ******/

/************************************************************************************************************************

 	FUNCTION	: create_axoSynapse(parent)
 
	PURPOSE		: creates dialog box for axo-axonic connections

	RETURNS		: nothing

************************************************************************************************************************/

void create_axoSynapse( parent )
Widget parent;
{
	Widget children[25];            /* Children to manage */
	Arg al[64];                     /* Arg List */
	register int ac = 0;            /* Arg Count */
	XmString xmstrings[10];    	/* temporary storage for XmStrings */
	char text[20];          	/* string containing number */
	Widget 	axoSynapse,
		axoSynapseForm,
		axoSynapseTTLabel,
		axoSynapseTTDefButton,
		axoSynapseStrLabel,
		axoSynapseStrDefButton,
		axoSynapseMaxStrLabel,
		axoSynapseMaxStrDef,
		axoSynapseTRTLabel,
		axoSynapseTRTDef,
		axoSynapseTRSLabel,
		axoSynapseTRSDef,
		axoSynapseSep,
		axoSynapseOkButton,
		axoSynapseNoButton,
		axoSynapseHelpButton;	/* used for internal use */

	XtSetArg(al[ac], XmNtitle, axoAxonicConnectionString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	axoSynapse = XmCreateDialogShell ( parent, "axoSynapse", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	axoSynapseBB = XmCreateBulletinBoard ( axoSynapse, "axoSynapseBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseForm = XmCreateForm ( axoSynapseBB, "axoSynapseForm", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(transmissionTimeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	axoSynapseTTLabel = XmCreateLabel ( axoSynapseForm, "axoSynapseTTLabel", al, ac );

	ac = 0;
	sprintf(text, "%f", (double) TT_DEF);
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseTTText = XmCreateText ( axoSynapseForm, "axoSynapseTTText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, TT_MIN * 10); ac++;
	XtSetArg(al[ac], XmNmaximum, TT_MAX * 10); ac++;
	XtSetArg(al[ac], XmNvalue, TT_DEF * 10); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 1); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseTTScale = XmCreateScale ( axoSynapseForm, "axoSynapseTTScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseTTDefButton = XmCreatePushButton ( axoSynapseForm, "axoSynapseTTDefButton", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(inhibitionFactorString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	axoSynapseStrLabel = XmCreateLabel ( axoSynapseForm, "axoSynapseStrLabel", al, ac );

	ac = 0;
	sprintf(text, "%f", (double) ASTR_DEF);
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseStrText = XmCreateText ( axoSynapseForm, "axoSynapseStrText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, ASTR_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, ASTR_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) (ASTR_DEF * P_SCALE)); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseStrScale = XmCreateScale ( axoSynapseForm, "axoSynapseStrScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseStrDefButton = XmCreatePushButton ( axoSynapseForm, "axoSynapseStrDefButton", al, ac );
        ac = 0;
        XmStringFree ( xmstrings [ 0 ] );
        xmstrings[0] = XmStringCreateLtoR(maxInhibitionString, defaultFont);
        XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
        axoSynapseMaxStrLabel = XmCreateLabel ( axoSynapseForm, "axoSynapseMaxStrLabel", al, ac );

        ac = 0;
	sprintf(text, "%f", (double) MAXASTR_DEF);
        XmStringFree ( xmstrings [ 0 ] );
        XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
        axoSynapseMaxStrText = XmCreateText ( axoSynapseForm, "axoSynapseMaxStrText", al, ac );

        ac = 0;
        XtSetArg(al[ac], XmNminimum, MAXASTR_MIN * 100); ac++;
        XtSetArg(al[ac], XmNmaximum, MAXASTR_MAX * 100); ac++;
        XtSetArg(al[ac], XmNvalue, (int) (MAXASTR_DEF * P_SCALE)); ac++;
        XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
        XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
        XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
        XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
        axoSynapseMaxStrScale = XmCreateScale ( axoSynapseForm, "axoSynapseMaxStrScale", al, ac );

        ac = 0;
        xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
        XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
        axoSynapseMaxStrDef = XmCreatePushButton ( axoSynapseForm, "axoSynapseMaxStrDef", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(transmitterReleaseString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	axoSynapseTRTLabel = XmCreateLabel ( axoSynapseForm, "axoSynapseTRTLabel", al, ac );

	ac = 0;
	sprintf(text, "%f", (double) TRT_DEF);
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseTRTText = XmCreateText ( axoSynapseForm, "axoSynapseTRTText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, TRT_MIN * 10); ac++;
	XtSetArg(al[ac], XmNmaximum, TRT_MAX * 10); ac++;
	XtSetArg(al[ac], XmNvalue, TRT_DEF * 10); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 1); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseTRTScale = XmCreateScale ( axoSynapseForm, "axoSynapseTRTScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseTRTDef = XmCreatePushButton ( axoSynapseForm, "axoSynapseTRTDef", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(transmitterSatiationString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	axoSynapseTRSLabel = XmCreateLabel ( axoSynapseForm, "axoSynapseTRSLabel", al, ac );

	ac = 0;
	sprintf(text, "%f", (double) TRS_DEF);
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseTRSText = XmCreateText ( axoSynapseForm, "axoSynapseTRSText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, TRS_MIN * 10); ac++;
	XtSetArg(al[ac], XmNmaximum, TRS_MAX * 10); ac++;
	XtSetArg(al[ac], XmNvalue, TRS_DEF * 10); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 1); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseTRSScale = XmCreateScale ( axoSynapseForm, "axoSynapseTRSScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseTRSDef = XmCreatePushButton ( axoSynapseForm, "axoSynapseTRSDef", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	axoSynapseSep = XmCreateSeparator ( axoSynapseForm, "axoSynapseSep", al, ac );
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseOkButton = XmCreatePushButton ( axoSynapseForm, "axoSynapseOkButton", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseNoButton = XmCreatePushButton ( axoSynapseForm, "axoSynapseNoButton", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNsensitive, FALSE); ac++;
	xmstrings[0] = XmStringCreateLtoR(learnParameterString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseLearnButton = XmCreatePushButton ( axoSynapseForm, "axoSynapseLearnButton", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	axoSynapseHelpButton = XmCreatePushButton ( axoSynapseForm, "axoSynapseHelpButton", al, ac );

	XmStringFree ( xmstrings [ 0 ] );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseTTLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 110); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseTTLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseTTText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseTTText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseTTScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseTTScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseTTDefButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseTTText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseStrLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseStrLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseTTText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseStrText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseStrText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseStrText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseStrScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseStrScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseStrScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseStrDefButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseMaxStrText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseTRTLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseTRTLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseTTText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseTRTText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseTRTText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseTRTText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseTRTScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseTRTScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseTRTScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseTRTDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseTRTText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseTRSLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseTRSLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseTTText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseTRSText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseTRSText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseTRSText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseTRSScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseTRSScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseTRSScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseTRSDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseTRSText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( axoSynapseSep,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseSep); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseSep); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 35); ac++;
        XtSetValues ( axoSynapseNoButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseSep); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( axoSynapseHelpButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseStrText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseMaxStrLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseMaxStrLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseTTText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseMaxStrText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseMaxStrText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseMaxStrText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseMaxStrScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseMaxStrScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, axoSynapseMaxStrScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( axoSynapseMaxStrDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, axoSynapseSep); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 75); ac++;
        XtSetValues ( axoSynapseLearnButton,al, ac );

	XmAddTabGroup ( axoSynapseForm );
	XmAddTabGroup ( axoSynapseTTText );
	XmAddTabGroup ( axoSynapseTTScale );
	XmAddTabGroup ( axoSynapseStrText );
	XmAddTabGroup ( axoSynapseStrScale );
        XmAddTabGroup ( axoSynapseMaxStrText );
        XmAddTabGroup ( axoSynapseMaxStrScale );
	XmAddTabGroup ( axoSynapseTRTText );
	XmAddTabGroup ( axoSynapseTRTScale );
	XmAddTabGroup ( axoSynapseTRSText );
	XmAddTabGroup ( axoSynapseTRSScale );

	XtAddCallback (axoSynapseTTText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_TT);
	XtAddCallback (axoSynapseTTScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_TT);
	XtAddCallback (axoSynapseTTScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_TT);
	XtAddCallback (axoSynapseTTDefButton, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_TT);
	XtAddCallback (axoSynapseStrText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_STR);
	XtAddCallback (axoSynapseStrScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_STR);
	XtAddCallback (axoSynapseStrScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_STR);
	XtAddCallback (axoSynapseStrDefButton, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_STR);
        XtAddCallback (axoSynapseMaxStrText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_AMAXSTR);
        XtAddCallback (axoSynapseMaxStrScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_AMAXSTR);
        XtAddCallback (axoSynapseMaxStrScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_AMAXSTR);
        XtAddCallback (axoSynapseMaxStrDef, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_AMAXSTR);
	XtAddCallback (axoSynapseTRTText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_TRT);
	XtAddCallback (axoSynapseTRTScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_TRT);
	XtAddCallback (axoSynapseTRTScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_TRT);
	XtAddCallback (axoSynapseTRTDef, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_TRT);
	XtAddCallback (axoSynapseTRSText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_TRS);
	XtAddCallback (axoSynapseTRSScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_TRS);
	XtAddCallback (axoSynapseTRSScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_TRS);
	XtAddCallback (axoSynapseTRSDef, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_TRS);
	XtAddCallback (axoSynapseOkButton, XmNactivateCallback, dialog_accept4_CB, (caddr_t *) DIALOG_AXOSYNAPSE);
	XtAddCallback (axoSynapseNoButton,XmNactivateCallback, unmanage_link_CB, (caddr_t *) &axoSynapseBB);
	XtAddCallback (axoSynapseNoButton,XmNactivateCallback, unmanage_link_CB, (caddr_t *) &learnParamBB);
	XtAddCallback (axoSynapseNoButton, XmNactivateCallback, remove_selected_objects_from_selectionList_CB, (caddr_t *) NULL);
        XtAddCallback (axoSynapseLearnButton, XmNactivateCallback, dialog_accept4_CB, (caddr_t *) DIALOG_SELECT_LEARNPARAM);
	XtAddCallback (axoSynapseHelpButton, XmNactivateCallback, dialog_help4_CB, (caddr_t *) DIALOG_AXOSYNAPSE);

	ac = 0;
	children[ac++] = axoSynapseTTLabel;
	children[ac++] = axoSynapseTTText;
	children[ac++] = axoSynapseTTScale;
	children[ac++] = axoSynapseTTDefButton;
	children[ac++] = axoSynapseStrLabel;
	children[ac++] = axoSynapseStrText;
	children[ac++] = axoSynapseStrScale;
	children[ac++] = axoSynapseStrDefButton;
        children[ac++] = axoSynapseMaxStrLabel;
        children[ac++] = axoSynapseMaxStrText;
        children[ac++] = axoSynapseMaxStrScale;
        children[ac++] = axoSynapseMaxStrDef;
	children[ac++] = axoSynapseTRTLabel;
	children[ac++] = axoSynapseTRTText;
	children[ac++] = axoSynapseTRTScale;
	children[ac++] = axoSynapseTRTDef;
	children[ac++] = axoSynapseTRSLabel;
	children[ac++] = axoSynapseTRSText;
	children[ac++] = axoSynapseTRSScale;
	children[ac++] = axoSynapseTRSDef;
	children[ac++] = axoSynapseSep;
	children[ac++] = axoSynapseOkButton;
	children[ac++] = axoSynapseNoButton;
        children[ac++] = axoSynapseLearnButton;
	children[ac++] = axoSynapseHelpButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = axoSynapseForm;
	XtManageChildren(children, ac);

} /* end of create_axoSynapse */

/************************************************************************************************************************

 	FUNCTION	: create_learnParam(parent)
 
	PURPOSE		: create dialog box for learn parameter

	RETURNS		: nothing

************************************************************************************************************************/

void create_learnParam( parent )
Widget parent;
{
	Widget children[44];      	/* Children to manage */
	Arg al[64];           		/* Arg List */
	register int ac = 0;      	/* Arg Count */
	XmString xmstrings[10];    	/* temporary storage for XmStrings */
	char text[20];		        /* string containing number */
	Widget 	learnParam,
		learnParamForm,
		learnParamTitle1,
		learnParamSlopeLabel,
		learnParamSlopeDef,
		learnParamTitle2,
		learnParamSTMLabel,
		learnParamSTMDef,
		learnParamLTThresholdLabel,
		learnParamLTThresholdDef,
		learnParamTitle3,
		learnParamLTMinimumLabel,
		learnParamLTMinimumDef,
		learnParamTitle4,
		learnParamHILabel,
		learnParamHIDef,
		learnParamHLFLabel,
		learnParamHLFDef,
		learnParamCompLFLabel,
		learnParamCompLFDef,
		learnParamKLFLabel,
		learnParamKLFDef,
		learnParamCLFLabel,
		learnParamCLFDef,
		learnParamSeparator,
		learnParamOkButton,
		learnParamNoButton,
		learnParamHelpButton;	/* used for internal use */

	XtSetArg(al[ac], XmNtitle, learnParameterString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	learnParam = XmCreateDialogShell ( parent, "learnParam", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	learnParamBB = XmCreateBulletinBoard ( learnParam, "learnParamBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamForm = XmCreateForm ( learnParamBB, "learnParamForm", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(learnCurveParamsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	learnParamTitle1 = XmCreateLabel ( learnParamForm, "learnParamTitle1", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(learnCurveSlopeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	learnParamSlopeLabel = XmCreateLabel ( learnParamForm, "learnParamSlopeLabel", al, ac );

	ac = 0;
	sprintf(text, "%f", (double) SLOPE_DEF);
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamSlopeText = XmCreateText ( learnParamForm, "learnParamSlopeText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, SLOPE_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, SLOPE_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) (SLOPE_DEF * P_SCALE)); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamSlopeScale = XmCreateScale ( learnParamForm, "learnParamSlopeScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamSlopeDef = XmCreatePushButton ( learnParamForm, "learnParamSlopeDef", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(shortTermParameterString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	learnParamTitle2 = XmCreateLabel ( learnParamForm, "learnParamTitle2", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(shortTermMemoryString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	learnParamSTMLabel = XmCreateLabel ( learnParamForm, "learnParamSTMLabel", al, ac );

	ac = 0;
	sprintf(text, "%f", (double) STM_DEF);
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamSTMText = XmCreateText ( learnParamForm, "learnParamSTMText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, STM_MIN * 10); ac++;
	XtSetArg(al[ac], XmNmaximum, STM_MAX * 10); ac++;
	XtSetArg(al[ac], XmNvalue, STM_DEF * 10); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 1); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamSTMScale = XmCreateScale ( learnParamForm, "learnParamSTMScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamSTMDef = XmCreatePushButton ( learnParamForm, "learnParamSTMDef", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(longTermThresholdString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	learnParamLTThresholdLabel = XmCreateLabel ( learnParamForm, "learnParamLTThresholdLabel", al, ac );

	ac = 0;
	sprintf(text, "%f", (double) LTT_DEF);
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamLTThresholdText = XmCreateText ( learnParamForm, "learnParamLTThresholdText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, LTT_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, LTT_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) (LTT_DEF * P_SCALE)); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamLTThresholdScale = XmCreateScale ( learnParamForm, "learnParamLTThresholdScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamLTThresholdDef = XmCreatePushButton ( learnParamForm, "learnParamLTThresholdDef", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(longTermParametersString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	learnParamTitle3 = XmCreateLabel ( learnParamForm, "learnParamTitle3", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(longTermMinimumString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	learnParamLTMinimumLabel = XmCreateLabel ( learnParamForm, "learnParamLTMinimumLabel", al, ac );

	ac = 0;
	sprintf(text, "%f", (double) LTM_DEF);
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamLTMinimumText = XmCreateText ( learnParamForm, "learnParamLTMinimumText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, LTM_MIN * 10); ac++;
	XtSetArg(al[ac], XmNmaximum, LTM_MAX * 10); ac++;
	XtSetArg(al[ac], XmNvalue, LTM_DEF * 10); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 1); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamLTMinimumScale = XmCreateScale ( learnParamForm, "learnParamLTMinimumScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamLTMinimumDef = XmCreatePushButton ( learnParamForm, "learnParamLTMinimumDef", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(learnParameterString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	learnParamTitle4 = XmCreateLabel ( learnParamForm, "learnParamTitle4", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(hebbIntervalString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	learnParamHILabel = XmCreateLabel ( learnParamForm, "learnParamHILabel", al, ac );

	ac = 0;
	sprintf(text, "%f", (double) HI_DEF);
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamHIText = XmCreateText ( learnParamForm, "learnParamHIText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, HI_MIN * 10); ac++;
	XtSetArg(al[ac], XmNmaximum, HI_MAX * 10); ac++;
	XtSetArg(al[ac], XmNvalue, HI_DEF * 10); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 1); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamHIScale = XmCreateScale ( learnParamForm, "learnParamHIScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamHIDef = XmCreatePushButton ( learnParamForm, "learnParamHIDef", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(hebbLearnFactorString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	learnParamHLFLabel = XmCreateLabel ( learnParamForm, "learnParamHLFLabel", al, ac );

	ac = 0;
	sprintf(text, "%f", (double) HLF_DEF);
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamHLFText = XmCreateText ( learnParamForm, "learnParamHLFText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, HLF_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, HLF_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) (HLF_DEF * P_SCALE)); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamHLFScale = XmCreateScale ( learnParamForm, "learnParamHLFScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamHLFDef = XmCreatePushButton ( learnParamForm, "learnParamHLFDef", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(competitiveLearnFactorString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	learnParamCompLFLabel = XmCreateLabel ( learnParamForm, "learnParamCompLFLabel", al, ac );

	ac = 0;
	sprintf(text, "%f", (double) COMPLF_DEF);
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamCompLFText = XmCreateText ( learnParamForm, "learnParamCompLFText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, COMPLF_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, COMPLF_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) (COMPLF_DEF * P_SCALE)); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamCompLFScale = XmCreateScale ( learnParamForm, "learnParamCompLFScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamCompLFDef = XmCreatePushButton ( learnParamForm, "learnParamCompLFDef", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(shortTermLearnFactorString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	learnParamKLFLabel = XmCreateLabel ( learnParamForm, "learnParamKLFLabel", al, ac );

	ac = 0;
	sprintf(text, "%f", (double) KLF_DEF);
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamKLFText = XmCreateText ( learnParamForm, "learnParamKLFText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, KLF_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, KLF_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) (KLF_DEF * P_SCALE)); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamKLFScale = XmCreateScale ( learnParamForm, "learnParamKLFScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamKLFDef = XmCreatePushButton ( learnParamForm, "learnParamKLFDef", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(conditioningLearnFactorString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	learnParamCLFLabel = XmCreateLabel ( learnParamForm, "learnParamCLFLabel", al, ac );

	ac = 0;
	sprintf(text, "%f", (double) CLF_DEF);
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamCLFText = XmCreateText ( learnParamForm, "learnParamCLFText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, CLF_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, CLF_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) (CLF_DEF * P_SCALE)); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamCLFScale = XmCreateScale ( learnParamForm, "learnParamCLFScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamCLFDef = XmCreatePushButton ( learnParamForm, "learnParamCLFDef", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNseparatorType, XmSINGLE_LINE); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	learnParamSeparator = XmCreateSeparator ( learnParamForm, "learnParamSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamOkButton = XmCreatePushButton ( learnParamForm, "learnParamOkButton", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamNoButton = XmCreatePushButton ( learnParamForm, "learnParamNoButton", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	learnParamHelpButton = XmCreatePushButton ( learnParamForm, "learnParamHelpButton", al, ac );

	XmStringFree ( xmstrings [ 0 ] );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamTitle1,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamTitle1); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamSlopeLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamSlopeLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 105); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamSlopeLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamSlopeText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamSlopeText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamSlopeText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamSlopeScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamSlopeScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamSlopeScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamSlopeDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 20); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamSlopeText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamTitle2,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamTitle2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamSTMLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamSTMLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamSTMLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamSTMText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamSTMText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamSTMText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamSTMScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamSTMScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamSTMScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamSTMDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamSTMText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamLTThresholdLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamLTThresholdLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamSTMText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamLTThresholdText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamLTThresholdText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamLTThresholdText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamLTThresholdScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamLTThresholdScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamLTThresholdScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamLTThresholdDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 20); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamLTThresholdText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamTitle3,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamTitle3); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamLTMinimumLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamLTMinimumLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamSTMText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamLTMinimumText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamLTMinimumText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamLTMinimumText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamLTMinimumScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamLTMinimumScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamLTMinimumScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamLTMinimumDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 20); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamLTMinimumText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamTitle4,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamTitle4); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamHILabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamHILabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamLTThresholdText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamHIText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamHIText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamHIText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamHIScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamHIScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamHIScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamHIDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamHIText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamHLFLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamHLFLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamSTMText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamHLFText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamHLFText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamHLFText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamHLFScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamHLFScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamHLFScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamHLFDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamHLFText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamCompLFLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamCompLFLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamSTMText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamCompLFText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamCompLFText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamCompLFText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamCompLFScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamCompLFScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamCompLFScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamCompLFDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamCompLFText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamKLFLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamKLFLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamSTMText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamKLFText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamKLFText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamKLFText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamKLFScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamKLFScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamKLFScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamKLFDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamKLFText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamCLFLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamCLFLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamSTMText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamCLFText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamCLFText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamCLFText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamCLFScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamCLFScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, learnParamCLFScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamCLFDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamCLFText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( learnParamSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( learnParamOkButton,al, ac );

	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamOkButton); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
        XtSetValues ( learnParamNoButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, learnParamNoButton); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( learnParamHelpButton,al, ac );

	XmAddTabGroup ( learnParamForm );
	XmAddTabGroup ( learnParamSlopeText );
	XmAddTabGroup ( learnParamSlopeScale );
	XmAddTabGroup ( learnParamSTMText );
	XmAddTabGroup ( learnParamSTMScale );
	XmAddTabGroup ( learnParamLTThresholdText );
	XmAddTabGroup ( learnParamLTThresholdScale );
	XmAddTabGroup ( learnParamLTMinimumText );
	XmAddTabGroup ( learnParamLTMinimumScale );
	XmAddTabGroup ( learnParamHIText );
	XmAddTabGroup ( learnParamHIScale );
	XmAddTabGroup ( learnParamHLFText );
	XmAddTabGroup ( learnParamHLFScale );
	XmAddTabGroup ( learnParamCompLFText );
	XmAddTabGroup ( learnParamCompLFScale );
	XmAddTabGroup ( learnParamKLFText );
	XmAddTabGroup ( learnParamKLFScale );
	XmAddTabGroup ( learnParamCLFText );
	XmAddTabGroup ( learnParamCLFScale );

	XtAddCallback (learnParamSlopeText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_SLOPE);
	XtAddCallback (learnParamSlopeScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_SLOPE);
	XtAddCallback (learnParamSlopeScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_SLOPE);
	XtAddCallback (learnParamSlopeDef, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_SLOPE);
	XtAddCallback (learnParamSTMText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_STM);
	XtAddCallback (learnParamSTMScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_STM);
	XtAddCallback (learnParamSTMScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_STM);
	XtAddCallback (learnParamSTMDef, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_STM);
	XtAddCallback (learnParamLTThresholdText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_LTT);
	XtAddCallback (learnParamLTThresholdScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_LTT);
	XtAddCallback (learnParamLTThresholdScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_LTT);
	XtAddCallback (learnParamLTThresholdDef, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_LTT);
	XtAddCallback (learnParamLTMinimumText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_LTM);
	XtAddCallback (learnParamLTMinimumScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_LTM);
	XtAddCallback (learnParamLTMinimumScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_LTM);
	XtAddCallback (learnParamLTMinimumDef, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_LTM);
	XtAddCallback (learnParamHIText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_HI);
	XtAddCallback (learnParamHIScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_HI);
	XtAddCallback (learnParamHIScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_HI);
	XtAddCallback (learnParamHIDef, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_HI);
	XtAddCallback (learnParamHLFText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_HLF);
	XtAddCallback (learnParamHLFScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_HLF);
	XtAddCallback (learnParamHLFScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_HLF);
	XtAddCallback (learnParamHLFDef, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_HLF);
	XtAddCallback (learnParamCompLFText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_COMPLF);
	XtAddCallback (learnParamCompLFScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_COMPLF);
	XtAddCallback (learnParamCompLFScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_COMPLF);
	XtAddCallback (learnParamCompLFDef, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_COMPLF);
	XtAddCallback (learnParamKLFText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_KLF);
	XtAddCallback (learnParamKLFScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_KLF);
	XtAddCallback (learnParamKLFScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_KLF);
	XtAddCallback (learnParamKLFDef, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_KLF);
	XtAddCallback (learnParamCLFText, XmNvalueChangedCallback, dialog_text4_CB, (caddr_t *) DIALOG_TEXT_CLF);
	XtAddCallback (learnParamCLFScale, XmNdragCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_CLF);
	XtAddCallback (learnParamCLFScale, XmNvalueChangedCallback, dialog_scale4_CB, (caddr_t *) DIALOG_SCALE_CLF);
	XtAddCallback (learnParamCLFDef, XmNactivateCallback, dialog_def4_CB, (caddr_t *) DIALOG_DEF_CLF);
	XtAddCallback (learnParamOkButton, XmNactivateCallback, dialog_accept4_CB, (caddr_t *) DIALOG_LEARNPARAM);
	XtAddCallback (learnParamNoButton,XmNactivateCallback, unmanage_link_CB, (caddr_t *) &learnParamBB);
	XtAddCallback (learnParamHelpButton, XmNactivateCallback, dialog_help4_CB, (caddr_t *) DIALOG_LEARNPARAM);

	ac = 0;
	children[ac++] = learnParamTitle1;
	children[ac++] = learnParamSlopeLabel;
	children[ac++] = learnParamSlopeText;
	children[ac++] = learnParamSlopeScale;
	children[ac++] = learnParamSlopeDef;
	children[ac++] = learnParamTitle2;
	children[ac++] = learnParamSTMLabel;
	children[ac++] = learnParamSTMText;
	children[ac++] = learnParamSTMScale;
	children[ac++] = learnParamSTMDef;
	children[ac++] = learnParamLTThresholdLabel;
	children[ac++] = learnParamLTThresholdText;
	children[ac++] = learnParamLTThresholdScale;
	children[ac++] = learnParamLTThresholdDef;
	children[ac++] = learnParamTitle3;
	children[ac++] = learnParamLTMinimumLabel;
	children[ac++] = learnParamLTMinimumText;
	children[ac++] = learnParamLTMinimumScale;
	children[ac++] = learnParamLTMinimumDef;
	children[ac++] = learnParamTitle4;
	children[ac++] = learnParamHILabel;
	children[ac++] = learnParamHIText;
	children[ac++] = learnParamHIScale;
	children[ac++] = learnParamHIDef;
	children[ac++] = learnParamHLFLabel;
	children[ac++] = learnParamHLFText;
	children[ac++] = learnParamHLFScale;
	children[ac++] = learnParamHLFDef;
	children[ac++] = learnParamCompLFLabel;
	children[ac++] = learnParamCompLFText;
	children[ac++] = learnParamCompLFScale;
	children[ac++] = learnParamCompLFDef;
	children[ac++] = learnParamKLFLabel;
	children[ac++] = learnParamKLFText;
	children[ac++] = learnParamKLFScale;
	children[ac++] = learnParamKLFDef;
	children[ac++] = learnParamCLFLabel;
	children[ac++] = learnParamCLFText;
	children[ac++] = learnParamCLFScale;
	children[ac++] = learnParamCLFDef;
	children[ac++] = learnParamSeparator;
	children[ac++] = learnParamOkButton;
	children[ac++] = learnParamNoButton;
	children[ac++] = learnParamHelpButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = learnParamForm;
	XtManageChildren(children, ac);

} /* end of create_learnParam */

/************************************************************************************************************************

 	FUNCTION	: dialog_text4_CB(w, client_data, call_data)
 
	PURPOSE		: handles callback of text widgets

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_text4_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
        Arg             args[20];               /* argument list for manipulating widgets */
        Cardinal        n;                      /* used as argument counter for manipulating widgets */
        char            *value = NULL;          /* used for detection of valid number string */
        int             scaleValue;             /* value of scale widget */
        int             sF;                     /* scaling factor */
        short int       decimals;               /* number of decimals for scale widget */
        double          number;                 /* number read from text widget */

        /* check if number beginns with a valid sign */

        value = XmTextGetString(w);

        if ((strlen(value) == 0) ||
            (strcmp(value,"+") == 0) ||
            (strcmp(value,"-") == 0) ||
            (strcmp(value,".") == 0) ||
            (strcmp(value," +") == 0) ||
            (strcmp(value," -") == 0) ||
            (strcmp(value," .") == 0) ||
            (strcmp(value,"+ ") == 0) ||
            (strcmp(value,"- ") == 0) ||
            (strcmp(value," + ") == 0) ||
            (strcmp(value," - ") == 0))
	{
		free(value);
                return;
	}
        number = strtod(value, (char **) NULL);

        /* check number dependend on the widget from which it comes */

        switch((int) client_data)
        {
        case DIALOG_TEXT_TT:	/* transmission time */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			TT = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(axoSynapseTTScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (TT_MAX * sF))
				scaleValue = (TT_MAX * sF);
			else if (scaleValue < (TT_MIN * sF))
				scaleValue = (TT_MIN * sF);

			XmScaleSetValue(axoSynapseTTScale, scaleValue);
                        free(value);
                }
                break;

        case DIALOG_TEXT_STR:	/* synaptic strength (inhibition factor) */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			STRENGTH = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(axoSynapseStrScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (ASTR_MAX * sF))
				scaleValue = (ASTR_MAX * sF);
			else if (scaleValue < (ASTR_MIN * sF))
				scaleValue = (ASTR_MIN * sF);

			XmScaleSetValue(axoSynapseStrScale, scaleValue);
                        free(value);
                }
                break;

        case DIALOG_TEXT_AMAXSTR:	/* maximal synaptic strength (inhibition factor) */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			MAXSTR = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(axoSynapseMaxStrScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (MAXASTR_MAX * sF))
				scaleValue = (MAXASTR_MAX * sF);
			else if (scaleValue < (MAXASTR_MIN * sF))
				scaleValue = (MAXASTR_MIN * sF);

			XmScaleSetValue(axoSynapseMaxStrScale, scaleValue);
                        free(value);
                }
                break;

        case DIALOG_TEXT_TRT:	/* transmitter release threshold */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			TRT = number / E_SCALE;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(axoSynapseTRTScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (TRT_MAX * sF))
				scaleValue = (TRT_MAX * sF);
			else if (scaleValue < (TRT_MIN * sF))
				scaleValue = (TRT_MIN * sF);

			XmScaleSetValue(axoSynapseTRTScale, scaleValue);
                        free(value);
                }
                break;

        case DIALOG_TEXT_TRS:	/* transmitter satiate */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			TRS = number / E_SCALE;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(axoSynapseTRSScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (TRS_MAX * sF))
				scaleValue = (TRS_MAX * sF);
			else if (scaleValue < (TRS_MIN * sF))
				scaleValue = (TRS_MIN * sF);

			XmScaleSetValue(axoSynapseTRSScale, scaleValue);
                        free(value);
                }
                break;

        case DIALOG_TEXT_SLOPE:	/* slope of learning curve */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			SLOPE = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(learnParamSlopeScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (SLOPE_MAX * sF))
				scaleValue = (SLOPE_MAX * sF);
			else if (scaleValue < (SLOPE_MIN * sF))
				scaleValue = (SLOPE_MIN * sF);

			XmScaleSetValue(learnParamSlopeScale, scaleValue);
                        free(value);
                }
                break;

        case DIALOG_TEXT_STM:	/* short tearm memory */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			STM = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(learnParamSTMScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (STM_MAX * sF))
				scaleValue = (STM_MAX * sF);
			else if (scaleValue < (STM_MIN * sF))
				scaleValue = (STM_MIN * sF);

			XmScaleSetValue(learnParamSTMScale, scaleValue);
                        free(value);
                }
                break;

        case DIALOG_TEXT_LTT:	/* threshold to long tearm forgetting  */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			LTT = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(learnParamLTThresholdScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (LTT_MAX * sF))
				scaleValue = (LTT_MAX * sF);
			else if (scaleValue < (LTT_MIN * sF))
				scaleValue = (LTT_MIN * sF);

			XmScaleSetValue(learnParamLTThresholdScale, scaleValue);
                        free(value);
                }
                break;

        case DIALOG_TEXT_LTM:	/* long term memory minimum */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			LTM = number / P_SCALE;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(learnParamLTMinimumScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (LTM_MAX * sF))
				scaleValue = (LTM_MAX * sF);
			else if (scaleValue < (LTM_MIN * sF))
				scaleValue = (LTM_MIN * sF);

			XmScaleSetValue(learnParamLTMinimumScale, scaleValue);
                        free(value);
                }
                break;

        case DIALOG_TEXT_HI:	/* hebb intervall */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			HI = number / T_SCALE;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(learnParamHIScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (HI_MAX * sF))
				scaleValue = (HI_MAX * sF);
			else if (scaleValue < (HI_MIN * sF))
				scaleValue = (HI_MIN * sF);

			XmScaleSetValue(learnParamHIScale, scaleValue);
                        free(value);
                }
                break;

        case DIALOG_TEXT_HLF:	/* hebb learn factor */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			HLF = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(learnParamHLFScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (HLF_MAX * sF))
				scaleValue = (HLF_MAX * sF);
			else if (scaleValue < (HLF_MIN * sF))
				scaleValue = (HLF_MIN * sF);

			XmScaleSetValue(learnParamHLFScale, scaleValue);
                        free(value);
                }
                break;

        case DIALOG_TEXT_COMPLF:	/* competitive learn factor */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			COMPLF = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(learnParamCompLFScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (COMPLF_MAX * sF))
				scaleValue = (COMPLF_MAX * sF);
			else if (scaleValue < (COMPLF_MIN * sF))
				scaleValue = (COMPLF_MIN * sF);

			XmScaleSetValue(learnParamCompLFScale, scaleValue);
                        free(value);
                }
                break;

        case DIALOG_TEXT_KLF:	/* short term plasticity learn factor */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			KLF = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(learnParamKLFScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (KLF_MAX * sF))
				scaleValue = (KLF_MAX * sF);
			else if (scaleValue < (KLF_MIN * sF))
				scaleValue = (KLF_MIN * sF);

			XmScaleSetValue(learnParamKLFScale, scaleValue);
                        free(value);
                }
                break;

        case DIALOG_TEXT_CLF:	/* conditioning learn factor */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else    /* get number of decimals, compute scaling factor and set scale value */
		{

			CLF = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(learnParamCLFScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (CLF_MAX * sF))
				scaleValue = (CLF_MAX * sF);
			else if (scaleValue < (CLF_MIN * sF))
				scaleValue = (CLF_MIN * sF);

			XmScaleSetValue(learnParamCLFScale, scaleValue);
                        free(value);
                }
                break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in TEXT4_DIALOG occured !\n");
		break;
	}
} /* end of dialog_text4_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_scale4_CB(w, client_data, call_data)
 
	PURPOSE		: callback for scale widgets

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_scale4_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	Arg		args[20];		/* argument list for manipulating widgets */
	Cardinal	n;			/* used as argument counter for manipulating widgets */
	int		value;			/* value of the scale widget */
	short int 	decimals;		/* number of decimals for scale widget */
	double		number;			/* number of scale value */
	char		text[20];		/* text representation of number */

	/* set text value dependend on the widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_SCALE_TT:	/* transmission time */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(axoSynapseTTText, text);
		break;

	case DIALOG_SCALE_STR:		/* synaptic strength (inhibition factor) */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);
		XmTextSetString(axoSynapseStrText, text);
		break;

	case DIALOG_SCALE_AMAXSTR:	/* maximal synaptic strength (inhibition factor) */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);
		XmTextSetString(axoSynapseMaxStrText, text);
		break;

	case DIALOG_SCALE_TRT:		/* transmitter release threshold */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);
		XmTextSetString(axoSynapseTRTText, text);
		break;

	case DIALOG_SCALE_TRS:		/* transmitter satiate */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);
		XmTextSetString(axoSynapseTRSText, text);
		break;

	case DIALOG_SCALE_SLOPE:	/* slope of learning curve */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(learnParamSlopeText, text);
		break;

	case DIALOG_SCALE_STM:	/* short tearm memory */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(learnParamSTMText, text);
		break;

	case DIALOG_SCALE_LTT:	/* threshold to long term forgetting */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(learnParamLTThresholdText, text);
		break;

	case DIALOG_SCALE_LTM:	/* long term memory minimum */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(learnParamLTMinimumText, text);
		break;

	case DIALOG_SCALE_HI:	/* hebb intervall */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(learnParamHIText, text);
		break;

	case DIALOG_SCALE_HLF:	/* hebb learn factor */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(learnParamHLFText, text);
		break;

	case DIALOG_SCALE_COMPLF:	/* competitive learn factor */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(learnParamCompLFText, text);
		break;

	case DIALOG_SCALE_KLF:	/* short term plasticity learn factor */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(learnParamKLFText, text);
		break;

	case DIALOG_SCALE_CLF:	/* conditioning learn factor */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(learnParamCLFText, text);
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in SCALE4_DIALOG occured !\n");
		break;
	}

} /* end of dialog_scale4_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_accept4_CB(w, client_data, call_data)
 
	PURPOSE		: callback for ok buttons

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_accept4_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	Arg		args[20];		/* argument list for manipulating widgets */
	Cardinal	n;			/* used as argument counter for manipulating widgets */
	char		*value = NULL;		/* number as string from textwidget */
	char		textnumber[20];		/* number as string */
	short int	decimals;		/* number of decimals for scale widget */
	double		number;			/* number of scale value */
	int		sF;			/* scaling factor */
	int		scaleValue;		/* value of scale widget */
	SelectionListSynapses *actualSynapse;	/* synapses in the selection list */
	Boolean		strChanged,
			maxStrChanged,
			ttChanged,
			trtChanged,
			trsChanged;		/* TRUE if value of dialog box has been changed */

	/* check number dependend on the widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_AXOSYNAPSE:		/* check if values for axo-axonic connections are ok */

		value = XmTextGetString(axoSynapseTTText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < TT_MIN) || (number > TT_MAX))
		{
			error(28);
			free(value);
			break;
		}
		else TT = number / T_SCALE;
		free(value);

		value = XmTextGetString(axoSynapseStrText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < ASTR_MIN) || (number > ASTR_MAX))
		{
			error(61);
			free(value);
			break;
		}
		else STRENGTH = number;
		free(value);

		value = XmTextGetString(axoSynapseMaxStrText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < MAXASTR_MIN) || (number > MAXASTR_MAX))
		{
			error(73);
			free(value);
			break;
		}
		else MAXSTR = number;
		free(value);

		value = XmTextGetString(axoSynapseTRTText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < TRT_MIN) || (number > TRT_MAX))
		{
			error(35);
			free(value);
			break;
		}
		else TRT = number / E_SCALE;
		free(value);

		value = XmTextGetString(axoSynapseTRSText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < TRS_MIN) || (number > TRS_MAX))
		{
			error(36);
			free(value);
			break;
		}
		else TRS = number / E_SCALE;
		free(value);

		if (TRS <= TRT)
		{
			error(37);
			break;
		}

		XtUnmanageChild(axoSynapseBB);
		XtUnmanageChild(learnParamBB);

		if (selectionListNeuronsCounter > 0)	/* create new connection */
		{
			connect_neurons(selectionListNeuronsHead->neuronPtr,
					selectionListSynapsesHead->synapsePtr->targetNeuron,
					0, STRENGTH, TT, TRT, TRS, -1, selectionListSynapsesHead->synapsePtr);
			selectionListNeuronsHead->neuronPtr->connectionList->maxInhibitionFactor = MAXSTR;
		}
		else	/* change only values */
		{
			if (selectionListSynapsesHead->synapsePtr->initialInhibitionFactor != STRENGTH)
				strChanged = TRUE;
			else	strChanged = FALSE;

			if (selectionListSynapsesHead->synapsePtr->maxInhibitionFactor != MAXSTR)
				maxStrChanged = TRUE;
			else	maxStrChanged = FALSE;

			if (selectionListSynapsesHead->synapsePtr->deliveryTime != TT)
				ttChanged = TRUE;
			else	ttChanged = FALSE;

			if (selectionListSynapsesHead->synapsePtr->transmitterReleaseThreshold != TRT)
				trtChanged = TRUE;
			else	trtChanged = FALSE;

			if (selectionListSynapsesHead->synapsePtr->transmitterSatiate != TRS)
				trsChanged = TRUE;
			else	trsChanged = FALSE;

			for (actualSynapse = selectionListSynapsesHead; actualSynapse != NULL;
				actualSynapse = actualSynapse->next)
			{
				double str, maxStr, tt, trt, trs;	/* help variables */

				currentSynapse = actualSynapse->synapsePtr;

				if (strChanged)
					str = STRENGTH;
				else	str = currentSynapse->initialInhibitionFactor;

				if (maxStrChanged)
					maxStr = MAXSTR;
				else	maxStr = currentSynapse->maxInhibitionFactor;

				if (ttChanged)
					tt = TT;
				else	tt = currentSynapse->deliveryTime;

				if (trtChanged)
					trt = TRT;
				else	trt = currentSynapse->transmitterReleaseThreshold;

				if (trsChanged)
					trs = TRS;
				else	trs = currentSynapse->transmitterSatiate;

				/* change synaptic values */

				change_synaptic_values(currentSynapse, 0, str, tt, trt, trs, -1);
				currentSynapse->maxInhibitionFactor = maxStr;
			}
		}

		remove_selected_objects_from_selectionList();
		break;

	case DIALOG_SELECT_LEARNPARAM:	/* show mask with learn parameters and fill up defaut values */

		currentSynapse = selectionListSynapsesHead->synapsePtr;

		synapseSelection.SLOPE = currentSynapse->slope;
		sprintf(textnumber,"%f", synapseSelection.SLOPE);
		XmTextSetString(learnParamSlopeText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamSlopeScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (synapseSelection.SLOPE * sF);
		XmScaleSetValue(learnParamSlopeScale, scaleValue);

		synapseSelection.STM = currentSynapse->shortTermMemory;
		sprintf(textnumber,"%f", synapseSelection.STM);
		XmTextSetString(learnParamSTMText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamSTMScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (synapseSelection.STM * sF);
		XmScaleSetValue(learnParamSTMScale, scaleValue);

		synapseSelection.LTT = currentSynapse->longTermThreshold;
		sprintf(textnumber,"%f", synapseSelection.LTT);
		XmTextSetString(learnParamLTThresholdText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamLTThresholdScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (synapseSelection.LTT * sF);
		XmScaleSetValue(learnParamLTThresholdScale, scaleValue);

		synapseSelection.LTM = currentSynapse->longTermMinimum * P_SCALE;
		sprintf(textnumber,"%f", synapseSelection.LTM);
		XmTextSetString(learnParamLTMinimumText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamLTMinimumScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (synapseSelection.LTM * sF);
		XmScaleSetValue(learnParamLTMinimumScale, scaleValue);

		synapseSelection.HI = currentSynapse->hebbIntervall * T_SCALE;
		sprintf(textnumber,"%f", synapseSelection.HI);
		XmTextSetString(learnParamHIText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamHIScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (synapseSelection.HI * sF);
		XmScaleSetValue(learnParamHIScale, scaleValue);

		synapseSelection.HLF = currentSynapse->hebbLearnFactor;
		sprintf(textnumber,"%f", synapseSelection.HLF);
		XmTextSetString(learnParamHLFText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamHLFScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (synapseSelection.HLF * sF);
		XmScaleSetValue(learnParamHLFScale, scaleValue);

		synapseSelection.KLF = currentSynapse->shortTermPlasticityLearnFactor;
		sprintf(textnumber,"%f", synapseSelection.KLF);
		XmTextSetString(learnParamKLFText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamKLFScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (synapseSelection.KLF * sF);
		XmScaleSetValue(learnParamKLFScale, scaleValue);

		synapseSelection.CLF = currentSynapse->conditioningLearnFactor;
		sprintf(textnumber,"%f", synapseSelection.CLF);
		XmTextSetString(learnParamCLFText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamCLFScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (synapseSelection.CLF * sF);
		XmScaleSetValue(learnParamCLFScale, scaleValue);

		XtManageChild(learnParamBB);

		break;

	case DIALOG_LEARNPARAM:		/* check if values for learning are ok */

		value = XmTextGetString(learnParamSlopeText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < SLOPE_MIN) || (number > SLOPE_MAX))
		{
			error(62);
			free(value);
			break;
		}
		else SLOPE = number;
		free(value);

		value = XmTextGetString(learnParamSTMText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < STM_MIN) || (number > STM_MAX))
		{
			error(65);
			free(value);
			break;
		}
		else STM = number;
		free(value);

		value = XmTextGetString(learnParamLTThresholdText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < LTT_MIN) || (number > LTT_MAX))
		{
			error(66);
			free(value);
			break;
		}
		else LTT = number;
		free(value);

		value = XmTextGetString(learnParamLTMinimumText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < LTM_MIN) || (number > LTM_MAX))
		{
			error(67);
			free(value);
			break;
		}
		else LTM = number / P_SCALE;
		free(value);

		value = XmTextGetString(learnParamHIText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < HI_MIN) || (number > HI_MAX))
		{
			error(68);
			free(value);
			break;
		}
		else HI = number / T_SCALE;
		free(value);

		value = XmTextGetString(learnParamHLFText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < HLF_MIN) || (number > HLF_MAX))
		{
			error(69);
			free(value);
			break;
		}
		else HLF = number;
		free(value);

		value = XmTextGetString(learnParamCompLFText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < COMPLF_MIN) || (number > COMPLF_MAX))
		{
			error(78);
			free(value);
			break;
		}
		else COMPLF = number;
		free(value);

		value = XmTextGetString(learnParamKLFText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < KLF_MIN) || (number > KLF_MAX))
		{
			error(70);
			free(value);
			break;
		}
		else KLF = number;
		free(value);

		value = XmTextGetString(learnParamCLFText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < CLF_MIN) || (number > CLF_MAX))
		{
			error(71);
			free(value);
			break;
		}
		else CLF = number;
		free(value);

		XtUnmanageChild(learnParamBB);

		for (actualSynapse = selectionListSynapsesHead; actualSynapse != NULL;
			actualSynapse = actualSynapse->next)
		{
			currentSynapse = actualSynapse->synapsePtr;

			if (synapseSelection.SLOPE != SLOPE)
				currentSynapse->slope = SLOPE;
			
			if (synapseSelection.STM != STM)
				currentSynapse->shortTermMemory = STM;

			if (synapseSelection.LTT != LTT)
				currentSynapse->longTermThreshold = LTT;
			
			if (synapseSelection.LTM != LTM)
				currentSynapse->longTermMinimum = LTM;

			if (synapseSelection.HI != HI)
				currentSynapse->hebbIntervall = HI;

			if (synapseSelection.HLF != HLF)
				currentSynapse->hebbLearnFactor = HLF;

			if (synapseSelection.COMPLF != COMPLF)
				currentSynapse->competitiveLearnFactor = COMPLF;

			if (synapseSelection.KLF != KLF)
				currentSynapse->shortTermPlasticityLearnFactor = KLF;

			if (synapseSelection.CLF != CLF)
				currentSynapse->conditioningLearnFactor = CLF;
		}

		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in ACCEPT4_DIALOG occured !\n");
		break;
	}

} /* end of dialog_accept4_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_help4_CB(w, client_data, call_data)
 
	PURPOSE		: callback for help buttons

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_help4_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	/* check widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_AXOSYNAPSE:

		sendhelp(w, "helpserver", "biosim", HELP_AXOSYNAPSE);
		break;

	case DIALOG_LEARNPARAM:

		sendhelp(w, "helpserver", "biosim", HELP_LEARNPARAM);
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in HELP4_DIALOG occured !\n");
		break;
	}

} /* end of dialog_help4_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_def4_CB(w, client_data, call_data)
 
	PURPOSE		: callback for default buttons

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_def4_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	Arg		args[20];		/* argument list for manipulating widgets */
	Cardinal	n;			/* used as argument counter for manipulating widgets */
	short int 	decimals;		/* number of decimals for scale widget */
	char		text[20];		/* number as string */

	/* check widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_DEF_TT:		/* transmission time */

		sprintf(text,"%f", (double) TT_DEF);
		XmTextSetString(axoSynapseTTText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(axoSynapseTTScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (TT_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(axoSynapseTTScale, args, n);
		break;

	case DIALOG_DEF_STR:		/* synaptic strength (inhibition factor) */

		sprintf(text,"%f", (double) ASTR_DEF);
		XmTextSetString(axoSynapseStrText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(axoSynapseStrScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (ASTR_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(axoSynapseStrScale, args, n);
		break;

	case DIALOG_DEF_AMAXSTR:	/* maximal synaptic strength (inhibition factor) */

		sprintf(text,"%f", (double) MAXASTR_DEF);
		XmTextSetString(axoSynapseMaxStrText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(axoSynapseMaxStrScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (MAXASTR_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(axoSynapseMaxStrScale, args, n);
		break;

	case DIALOG_DEF_TRT:		/* transmitter release threshold */

		sprintf(text,"%f", (double) TRT_DEF);
		XmTextSetString(axoSynapseTRTText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(axoSynapseTRTScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (TRT_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(axoSynapseTRTScale, args, n);
		break;

	case DIALOG_DEF_TRS:		/* transmitter satiate */

		sprintf(text,"%f", (double) TRS_DEF);
		XmTextSetString(axoSynapseTRSText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(axoSynapseTRSScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (TRS_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(axoSynapseTRSScale, args, n);
		break;

	case DIALOG_DEF_SLOPE:		/* slope of learning curve */

		sprintf(text,"%f", (double) SLOPE_DEF);
		XmTextSetString(learnParamSlopeText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamSlopeScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (SLOPE_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(learnParamSlopeScale, args, n);
		break;

	case DIALOG_DEF_STM:		/* short term memory */

		sprintf(text,"%f", (double) STM_DEF);
		XmTextSetString(learnParamSTMText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamSTMScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (STM_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(learnParamSTMScale, args, n);
		break;

	case DIALOG_DEF_LTT:		/* threshold to long term forgetting */

		sprintf(text,"%f", (double) LTT_DEF);
		XmTextSetString(learnParamLTThresholdText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamLTThresholdScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (LTT_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(learnParamLTThresholdScale, args, n);
		break;

	case DIALOG_DEF_LTM:		/* long term memory minimum */

		sprintf(text,"%f", (double) LTM_DEF);
		XmTextSetString(learnParamLTMinimumText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamLTMinimumScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (LTM_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(learnParamLTMinimumScale, args, n);
		break;

	case DIALOG_DEF_HI:		/* hebb intervall */

		sprintf(text,"%f", (double) HI_DEF);
		XmTextSetString(learnParamHIText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamHIScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (HI_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(learnParamHIScale, args, n);
		break;

	case DIALOG_DEF_HLF:		/* hebb learn factor */

		sprintf(text,"%f", (double) HLF_DEF);
		XmTextSetString(learnParamHLFText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamHLFScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (HLF_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(learnParamHLFScale, args, n);
		break;

	case DIALOG_DEF_COMPLF:		/* competitive learn factor */

		sprintf(text,"%f", (double) COMPLF_DEF);
		XmTextSetString(learnParamCompLFText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamCompLFScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (COMPLF_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(learnParamCompLFScale, args, n);
		break;

	case DIALOG_DEF_KLF:		/* short term plasticity learn factor */

		sprintf(text,"%f", (double) KLF_DEF);
		XmTextSetString(learnParamKLFText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamKLFScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (KLF_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(learnParamKLFScale, args, n);
		break;

	case DIALOG_DEF_CLF:		/* condition learn factor */

		sprintf(text,"%f", (double) CLF_DEF);
		XmTextSetString(learnParamCLFText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(learnParamCLFScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (CLF_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(learnParamCLFScale, args, n);
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in DEF4_DIALOG occured !\n");
		break;
	}
} /* end of dialog_def4_CB */
#endif
