/************************************************************************************************************************

PROGRAM:	BIOSIM

FILENAME:	menu3.c

PURPOSE:	handles all functions for the graph windows

FUNCTIONS:	in order of appearance

create_asciiOutputInterval	- generates a dialog box for asking the graph output interval
create_newGraphYZoom		- generates a dialog box for asking the new y-axis zoom value
create_newGraphXZoom		- generates a dialog box for asking the new x-axis zoom value
create_newGraphYScaling		- generates a dialog box for asking the new y-axis scaling value
create_newGraphXScaling		- generates a dialog box for asking the new x-axis scaling value
create_newGraph			- generates a new graph window with a menu bar and pull down menus
create_askDendrit		- create a dialog box for asking the dendrit segment number for plotting
create_asciiOutputIntervalS	- generates a dialog box for asking the graph output interval for synapses
create_newGraphYZoomS		- generates a dialog box for asking the new y-axis zoom value for synapses
create_newGraphXZoomS		- generates a dialog box for asking the new x-axis zoom value for synapses
create_newGraphYScalingS	- generates a dialog box for asking the new y-axis scaling value for synapses
create_newGraphXScalingS	- generates a dialog box for asking the new x-axis scaling value for synapses
create_newGraphS		- generates a new graph window with a menu bar and pull down menus for synapses
draw_graph_CB			- callback for drawing the neuron graph
determine_current_graph		- function for determining the current neuron graph
get_neuron_from_graph_title	- gets the neuron from the graph title information
save_graph_CB			- callback for saving neuron graph data
draw_graphS_CB			- callback for drawing the synapse graph
determine_current_graphS	- function for determining the current synapse graph
get_synapse_from_graph_title	- gets the synapse from the graph title information
save_graphS_CB			- callback for saving synapse graph data
dialog_text3_CB			- callback for text widgets
dialog_scale3_CB		- callback for scale widgets
dialog_accept3_CB		- callback for ok buttons
dialog_help3_CB			- callback for help buttons
dialog_toggle3_CB		- callback for toggle buttons
dialog_def3_CB			- callback for default buttons

************************************************************************************************************************/

#include "copying.h"
#include "biosim.h"
#include "functions.h"
#include "menu3.h"

/****** global variables ******/

Graph *currentGraph = NULL;			/* current neuron graph for graph switching */
SGraph *currentGraphS = NULL;			/* current synapse graph for graph switching */
int graphNumber = 0;				/* number of graphs in net */
int graphNumberS = 0;				/* number of synaptic graphs in net */
int graphNumberAS = 0;				/* number of axo-synaptic graphs in net */
#ifndef BATCH
Boolean zoomAllWindows = FALSE; 		/* flag for zooming all windows */
Boolean zoomAllSWindows = FALSE; 		/* flag for zooming all windows */
Boolean scaleAllWindows = FALSE; 		/* flag for scaling all windows */
Boolean scaleAllSWindows = FALSE; 		/* flag for scaling all windows */
Widget newGraphOptionsGridXToggle;		/* toggle button in graph window */
Widget newGraphOptionsGridYToggle;		/* toggle button in graph window */
Widget newGraphOptionsGridDotsToggle;		/* toggle button in graph window */
Widget newGraphOptionsGridLinesToggle;		/* toggle button in graph window */
Widget newGraphParameterSomaToggle;		/* toggle button in graph window */
Widget newGraphParameterDendritToggle;		/* toggle button in graph window */
Widget newGraphParameterSynapticCurrentToggle;	/* toggle button in graph window */
Widget newGraphParameterTotalCurrentToggle;	/* toggle button in graph window */
Widget newGraphParameterNToggle;		/* toggle button in graph window */
Widget newGraphParameterNAToggle;		/* toggle button in graph window */
Widget newGraphParameterKToggle;		/* toggle button in graph window */
Widget newGraphParameterCAToggle;		/* toggle button in graph window */
Widget newGraphParameterCA1Toggle;		/* toggle button in graph window */
Widget newGraphParameterCA2Toggle;		/* toggle button in graph window */
Widget newGraphParameterKCAToggle;		/* toggle button in graph window */
Widget newGraphParameterAToggle;		/* toggle button in graph window */
Widget newGraphParameterIRToggle;		/* toggle button in graph window */
Widget newGraphParameterPToggle;		/* toggle button in graph window */
Widget newGraphSOptionsGridXToggle;		/* toggle button in graph window */
Widget newGraphSOptionsGridYToggle;		/* toggle button in graph window */
Widget newGraphSOptionsGridDotsToggle;		/* toggle button in graph window */
Widget newGraphSOptionsGridLinesToggle;		/* toggle button in graph window */
Widget newGraphSParameterPotToggle;             /* toggle button in graph window */
Widget newGraphSParameterMemToggle;             /* toggle button in graph window */
Widget newGraphSParameterStrToggle;             /* toggle button in graph window */
Widget newGraphSParameterConToggle;             /* toggle button in graph window */
Widget newGraphYScalingEndScale;		/* scale widget */
Widget newGraphXScalingEndScale;		/* scale widget */
Widget newGraphYScalingSEndScale;		/* scale widget */
Widget newGraphXScalingSEndScale;		/* scale widget */
Widget newGraphYScalingStartScale;		/* scale widget */
Widget newGraphXScalingStartScale;		/* scale widget */
Widget newGraphYScalingSStartScale;		/* scale widget */
Widget newGraphXScalingSStartScale;		/* scale widget */
Widget newGraphYScalingStartText;		/* text widget */
Widget newGraphYScalingEndText;			/* text widget */
Widget newGraphXScalingStartText;		/* text widget */
Widget newGraphXScalingEndText;			/* text widget */
Widget newGraphYScalingSStartText;		/* text widget */
Widget newGraphYScalingSEndText;		/* text widget */
Widget newGraphXScalingSStartText;		/* text widget */
Widget newGraphXScalingSEndText;		/* text widget */

/****** local variables ******/

static Widget askDendritBB;			/* bulletin board widget */
static Widget asciiOutputIntervalBB;		/* bulletin board widget */
static Widget newGraphXScalingBB;		/* bulletin board widget */
static Widget newGraphYScalingBB;		/* bulletin board widget */
static Widget newGraphXZoomBB;			/* bulletin board widget */
static Widget newGraphYZoomBB;			/* bulletin board widget */
static Widget asciiOutputIntervalSBB;		/* bulletin board widget */
static Widget newGraphXScalingSBB;		/* bulletin board widget */
static Widget newGraphYScalingSBB;		/* bulletin board widget */
static Widget newGraphXZoomSBB;			/* bulletin board widget */
static Widget newGraphYZoomSBB;			/* bulletin board widget */

static Widget askDendritText;			/* text widget */
static Widget asciiOutputIntervalText;		/* text widget */
static Widget newGraphYZoomMagText;		/* text widget */
static Widget newGraphXZoomMagText;		/* text widget */
static Widget asciiOutputIntervalSText;		/* text widget */
static Widget newGraphYZoomSMagText;		/* text widget */
static Widget newGraphXZoomSMagText;		/* text widget */

static Widget asciiOutputIntervalScale;		/* scale widget */
static Widget newGraphYZoomMagScale;		/* scale widget */
static Widget newGraphXZoomMagScale;		/* scale widget */
static Widget asciiOutputIntervalSScale;	/* scale widget */
static Widget newGraphYZoomSMagScale;		/* scale widget */
static Widget newGraphXZoomSMagScale;		/* scale widget */

static Widget newGraphXScalingAllWindowsToggle; /* toggle button */
static Widget newGraphYScalingAllWindowsToggle; /* toggle button */
static Widget newGraphXZoomAllWindowsToggle;	/* toggle button */
static Widget newGraphYZoomAllWindowsToggle;	/* toggle button */
static Widget newGraphXScalingSAllWindowsToggle;/* toggle button */
static Widget newGraphYScalingSAllWindowsToggle;/* toggle button */
static Widget newGraphXZoomSAllWindowsToggle;	/* toggle button */
static Widget newGraphYZoomSAllWindowsToggle;	/* toggle button */

static Widget saveGraphDialog;			/* dialog widget */
static Widget saveGraphSDialog;			/* dialog widget */

static double	XZO;				/* input value of zoom x-axis */
static double	YZO;				/* input value of zoom y-axis */
static double	XSSC;				/* input value of scaling start x-axis */
static double	YSSC;				/* input value of scaling start y-axis */
static double	XESC;				/* input value of scaling end x-axis */
static double	YESC;				/* input value of scaling end y-axis */
static double  ASCOUT;				/* input value of graph output interval */

/******	functions 	******/

/************************************************************************************************************************

FUNCTION	: create_asciiOutputInterval( parent )

PURPOSE		: generates a dialog box for asking the graph output interval

RETURNS		: nothing

************************************************************************************************************************/

void create_asciiOutputInterval( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	asciiOutputInterval,
		asciiOutputIntervalForm,
		asciiOutputIntervalLabel,
		asciiOutputIntervalDefButton,
		asciiOutputIntervalSeparator,
		asciiOutputIntervalOkButton,
		asciiOutputIntervalNoButton,
		asciiOutputIntervalHelpButton; /* internal used widgets */

	Widget children[8];	/* Children to manage */
	Arg al[64];           	/* Arg List */
	register int ac = 0;    /* Arg Count */
	XmString xmstrings[10]; /* temporary storage for XmStrings */
	char text[20];		/* string containing number */

	/* create widgets */

	XtSetArg(al[ac], XmNtitle, asciiDataOutputTitleString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	asciiOutputInterval = XmCreateDialogShell ( parent, "asciiOutputInterval", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	asciiOutputIntervalBB = XmCreateBulletinBoard ( asciiOutputInterval, "asciiOutputIntervalBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalForm = XmCreateForm ( asciiOutputIntervalBB, "asciiOutputIntervalForm", al, ac );
	XmAddTabGroup(asciiOutputIntervalForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(asciiDataOutputIntervalString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	asciiOutputIntervalLabel = XmCreateLabel ( asciiOutputIntervalForm, "asciiOutputIntervalLabel", al, ac );
	XmStringFree ( xmstrings [ 0 ] );

	ac = 0;
	sprintf(text, "%f", (double) ASCOUT_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalText = XmCreateText ( asciiOutputIntervalForm, "asciiOutputIntervalText", al, ac );

	XmAddTabGroup(asciiOutputIntervalText);
	XtAddCallback(asciiOutputIntervalText, XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_ASCII);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) (ASCOUT_MIN * 100)); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) (ASCOUT_MAX * 100)); ac++;
	XtSetArg(al[ac], XmNvalue, (int) (ASCOUT_DEF * 100)); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalScale = XmCreateScale ( asciiOutputIntervalForm, "asciiOutputIntervalScale", al, ac );

	XmAddTabGroup(asciiOutputIntervalScale);
	XtAddCallback(asciiOutputIntervalScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_ASCII);
	XtAddCallback(asciiOutputIntervalScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_ASCII);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalDefButton = XmCreatePushButton ( asciiOutputIntervalForm, "asciiOutputIntervalDefButton",
		al, ac );

	XtAddCallback(asciiOutputIntervalDefButton, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_ASCII);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	asciiOutputIntervalSeparator = XmCreateSeparator ( asciiOutputIntervalForm, "asciiOutputIntervalSeparator",
		al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalOkButton = XmCreatePushButton ( asciiOutputIntervalForm, "asciiOutputIntervalOkButton",
		al, ac );

	XtAddCallback(asciiOutputIntervalOkButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_ASCII);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalNoButton = XmCreatePushButton ( asciiOutputIntervalForm, "asciiOutputIntervalNoButton",
		al, ac );

	XtAddCallback(asciiOutputIntervalNoButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &asciiOutputIntervalBB);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalHelpButton = XmCreatePushButton ( asciiOutputIntervalForm, "asciiOutputIntervalHelpButton",
		al, ac );

	XtAddCallback(asciiOutputIntervalHelpButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_ASCII);

	/* attach widgets */

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( asciiOutputIntervalLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, asciiOutputIntervalLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( asciiOutputIntervalText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, asciiOutputIntervalText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( asciiOutputIntervalScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, asciiOutputIntervalScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( asciiOutputIntervalDefButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, asciiOutputIntervalText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( asciiOutputIntervalSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, asciiOutputIntervalSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( asciiOutputIntervalOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, asciiOutputIntervalSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
	XtSetValues ( asciiOutputIntervalNoButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, asciiOutputIntervalSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( asciiOutputIntervalHelpButton,al, ac );

	/* manage widgets */

	ac = 0;
	children[ac++] = asciiOutputIntervalLabel;
	children[ac++] = asciiOutputIntervalText;
	children[ac++] = asciiOutputIntervalScale;
	children[ac++] = asciiOutputIntervalDefButton;
	children[ac++] = asciiOutputIntervalSeparator;
	children[ac++] = asciiOutputIntervalOkButton;
	children[ac++] = asciiOutputIntervalNoButton;
	children[ac++] = asciiOutputIntervalHelpButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = asciiOutputIntervalForm;
	XtManageChildren(children, ac);

} /* end of create_asciiOutputInterval */

/************************************************************************************************************************

FUNCTION	: create_newGraphYZoom( parent )

PURPOSE		: generates a dialog box for asking the new y-axis zoom value

RETURNS		: nothing

************************************************************************************************************************/

void create_newGraphYZoom( parent )
Widget parent;
{
	Widget 	newGraphYZoom,
		newGraphYZoomForm,
		newGraphYZoomLabel,
		newGraphYZoomMagDef,
		newGraphYZoomSeparator,
		newGraphYZoomMagLabel,
		newGraphYZoomSeparator2,
		newGraphYZoomOkButton,
		newGraphYZoomCancelButton,
		newGraphYZoomHelpButton; /* widgets for internal use */

	Arg al[25];    	  	/* Arg List */
	register int ac;	/* Arg Count */
	char text[20];	 	/* string containing number */
	XmString xmstrings[10];	/* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, graphZoomString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	newGraphYZoom = XmCreateDialogShell ( parent, "newGraphYZoom", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	newGraphYZoomBB = XmCreateBulletinBoard ( newGraphYZoom, "newGraphYZoomBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomForm = XmCreateForm ( newGraphYZoomBB, "newGraphYZoomForm", al, ac );
	XmAddTabGroup(newGraphYZoomForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(zoomYValueString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphYZoomLabel = XmCreateLabel ( newGraphYZoomForm, "newGraphYZoomLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(allWindowsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphYZoomAllWindowsToggle = XmCreateToggleButtonGadget ( newGraphYZoomForm, "newGraphYZoomAllWindowsToggle",
		al, ac );
	XmAddTabGroup(newGraphYZoomAllWindowsToggle);
	XtAddCallback (newGraphYZoomAllWindowsToggle, XmNvalueChangedCallback, dialog_toggle3_CB,
		(caddr_t *) DIALOG_ZOOM_ALL);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphYZoomSeparator = XmCreateSeparator ( newGraphYZoomForm, "newGraphYZoomSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(magFactorString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphYZoomMagLabel = XmCreateLabel ( newGraphYZoomForm, "newGraphYZoomMagLabel", al, ac );
	XmStringFree(xmstrings[0]);

	sprintf(text, "%f", (double) YZO_DEF);
	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomMagText = XmCreateText ( newGraphYZoomForm, "newGraphYZoomMagText", al, ac );

	XmAddTabGroup(newGraphYZoomMagText);
	XtAddCallback(newGraphYZoomMagText, XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_YZO);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) YZO_MIN * 10); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) YZO_MAX * 10); ac++;
	XtSetArg(al[ac], XmNvalue, (int) YZO_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 1); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomMagScale = XmCreateScale ( newGraphYZoomForm, "newGraphYZoomMagScale", al, ac );

	XmAddTabGroup(newGraphYZoomMagScale);
	XtAddCallback(newGraphYZoomMagScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_YZO);
	XtAddCallback(newGraphYZoomMagScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_YZO);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomMagDef = XmCreatePushButton ( newGraphYZoomForm, "newGraphYZoomMagDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYZoomMagDef, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_YZO);

	ac = 0;
	newGraphYZoomSeparator2 = XmCreateSeparator ( newGraphYZoomForm, "newGraphYZoomSeparator2", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomOkButton = XmCreatePushButton ( newGraphYZoomForm, "newGraphYZoomOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYZoomOkButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_YZO);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomCancelButton = XmCreatePushButton ( newGraphYZoomForm, "newGraphYZoomCancelButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYZoomCancelButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &newGraphYZoomBB);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomHelpButton = XmCreatePushButton ( newGraphYZoomForm, "newGraphYZoomHelpButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYZoomHelpButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_YZO);

	/* manage widgets */

	XtManageChild(newGraphYZoomLabel);
	XtManageChild(newGraphYZoomAllWindowsToggle);
	XtManageChild(newGraphYZoomSeparator);
	XtManageChild(newGraphYZoomMagLabel);
	XtManageChild(newGraphYZoomMagText);
	XtManageChild(newGraphYZoomMagScale);
	XtManageChild(newGraphYZoomMagDef);
	XtManageChild(newGraphYZoomSeparator2);
	XtManageChild(newGraphYZoomOkButton);
	XtManageChild(newGraphYZoomCancelButton);
	XtManageChild(newGraphYZoomHelpButton);
	XtManageChild(newGraphYZoomForm);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYZoomLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomAllWindowsToggle,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomMagLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomMagLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYZoomMagLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomMagText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomMagText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYZoomMagText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomMagScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomMagScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYZoomMagScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomMagDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomMagText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomSeparator2,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
	XtSetValues ( newGraphYZoomCancelButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( newGraphYZoomHelpButton,al, ac );

} /* end of create_newGraphYZoom */

/************************************************************************************************************************

FUNCTION	: create_newGraphXZoom( parent )

PURPOSE		: generates a dialog box for asking the new x-axis zoom value

RETURNS		: nothing

************************************************************************************************************************/

void create_newGraphXZoom( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	newGraphXZoom,
		newGraphXZoomForm,
		newGraphXZoomLabel,
		newGraphXZoomSeparator,
		newGraphXZoomMagLabel,
		newGraphXZoomMagDef,
		newGraphXZoomSeparator2,
		newGraphXZoomOkButton,
		newGraphXZoomCancelButton,
		newGraphXZoomHelpButton; /* widgets for internal use */

	Arg al[25];    	  	/* Arg List */
	register int ac;	/* Arg Count */
	char text[20];	 	/* string containing number */
	XmString xmstrings[10]; /* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, "Graph-Zoom"); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	newGraphXZoom = XmCreateDialogShell ( parent, "newGraphXZoom", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	newGraphXZoomBB = XmCreateBulletinBoard ( newGraphXZoom, "newGraphXZoomBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomForm = XmCreateForm ( newGraphXZoomBB, "newGraphXZoomForm", al, ac );
	XmAddTabGroup(newGraphXZoomForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(zoomXValueString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphXZoomLabel = XmCreateLabel ( newGraphXZoomForm, "newGraphXZoomLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(allWindowsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphXZoomAllWindowsToggle = XmCreateToggleButtonGadget ( newGraphXZoomForm, "newGraphXZoomAllWindowsToggle",
		al, ac );
	XmAddTabGroup(newGraphXZoomAllWindowsToggle);
	XtAddCallback (newGraphXZoomAllWindowsToggle, XmNvalueChangedCallback, dialog_toggle3_CB,
		(caddr_t *) DIALOG_ZOOM_ALL);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphXZoomSeparator = XmCreateSeparator ( newGraphXZoomForm, "newGraphXZoomSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(magFactorString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphXZoomMagLabel = XmCreateLabel ( newGraphXZoomForm, "newGraphXZoomMagLabel", al, ac );
	XmStringFree(xmstrings[0]);

	sprintf(text, "%f", (double) XZO_DEF);
	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomMagText = XmCreateText ( newGraphXZoomForm, "newGraphXZoomMagText", al, ac );

	XmAddTabGroup(newGraphXZoomMagText);
	XtAddCallback(newGraphXZoomMagText, XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_XZO);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) XZO_MIN * 10); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) XZO_MAX * 10); ac++;
	XtSetArg(al[ac], XmNvalue, (int) XZO_DEF * 10); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 1); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomMagScale = XmCreateScale ( newGraphXZoomForm, "newGraphXZoomMagScale", al, ac );

	XmAddTabGroup(newGraphXZoomMagScale);
	XtAddCallback(newGraphXZoomMagScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_XZO);
	XtAddCallback(newGraphXZoomMagScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_XZO);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomMagDef = XmCreatePushButton ( newGraphXZoomForm, "newGraphXZoomMagDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXZoomMagDef, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_XZO);

	ac = 0;
	newGraphXZoomSeparator2 = XmCreateSeparator ( newGraphXZoomForm, "newGraphXZoomSeparator2", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomOkButton = XmCreatePushButton ( newGraphXZoomForm, "newGraphXZoomOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXZoomOkButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_XZO);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomCancelButton = XmCreatePushButton ( newGraphXZoomForm, "newGraphXZoomCancelButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXZoomCancelButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &newGraphXZoomBB);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomHelpButton = XmCreatePushButton ( newGraphXZoomForm, "newGraphXZoomHelpButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXZoomHelpButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_XZO);

	/* manage widgets */

	XtManageChild(newGraphXZoomLabel);
	XtManageChild(newGraphXZoomAllWindowsToggle);
	XtManageChild(newGraphXZoomSeparator);
	XtManageChild(newGraphXZoomMagLabel);
	XtManageChild(newGraphXZoomMagText);
	XtManageChild(newGraphXZoomMagScale);
	XtManageChild(newGraphXZoomMagDef);
	XtManageChild(newGraphXZoomSeparator2);
	XtManageChild(newGraphXZoomOkButton);
	XtManageChild(newGraphXZoomCancelButton);
	XtManageChild(newGraphXZoomHelpButton);
	XtManageChild(newGraphXZoomForm);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXZoomLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomAllWindowsToggle,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomMagLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomMagLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXZoomMagLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomMagText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomMagText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXZoomMagText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomMagScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomMagScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXZoomMagScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomMagDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomMagText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomSeparator2,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
	XtSetValues ( newGraphXZoomCancelButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( newGraphXZoomHelpButton,al, ac );

} /* end of create_newGraphXZoom */

/************************************************************************************************************************

FUNCTION	: create_newGraphYScaling( parent )

PURPOSE		: generates a dialog box for asking the new y-axis scaling value

RETURNS		: nothing

************************************************************************************************************************/

void create_newGraphYScaling( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	newGraphYScaling,
		newGraphYScalingForm,
		newGraphYScalingLabel,
		newGraphYScalingSeparator,
		newGraphYScalingStartLabel,
		newGraphYScalingStartDef,
		newGraphYScalingEndLabel,
		newGraphYScalingEndDef,
		newGraphYScalingSeparator2,
		newGraphYScalingOkButton,
		newGraphYScalingCancelButton,
		newGraphYScalingHelpButton;	/* widgets for internal use */

	Arg al[25];      	/* Arg List */
	register int ac;	/* Arg Count */
	char text[20];	 	/* string containing number */
	XmString xmstrings[10];	/* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, "Graph-Skalierung"); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	newGraphYScaling = XmCreateDialogShell ( parent, "newGraphYScaling", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	newGraphYScalingBB = XmCreateBulletinBoard ( newGraphYScaling, "newGraphYScalingBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingForm = XmCreateForm ( newGraphYScalingBB, "newGraphYScalingForm", al, ac );
	XmAddTabGroup(newGraphYScalingForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(scalingYString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphYScalingLabel = XmCreateLabel ( newGraphYScalingForm, "newGraphYScalingLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(allWindowsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphYScalingAllWindowsToggle = XmCreateToggleButtonGadget ( newGraphYScalingForm,
		"newGraphYScalingAllWindowsToggle", al, ac );
	XmAddTabGroup(newGraphYScalingAllWindowsToggle);
	XtAddCallback (newGraphYScalingAllWindowsToggle, XmNvalueChangedCallback, dialog_toggle3_CB,
		(caddr_t *) DIALOG_SCALE_ALL);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphYScalingSeparator = XmCreateSeparator ( newGraphYScalingForm, "newGraphYScalingSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(startYValueString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphYScalingStartLabel = XmCreateLabel ( newGraphYScalingForm, "newGraphYScalingStartLabel", al, ac );
	XmStringFree(xmstrings[0]);

	sprintf(text, "%f", (double) YSSC_DEF);
	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingStartText = XmCreateText ( newGraphYScalingForm, "newGraphYScalingStartText", al, ac );

	XmAddTabGroup(newGraphYScalingStartText);
	XtAddCallback(newGraphYScalingStartText, XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_YSSC);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) YSC_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) YSC_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) YSSC_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingStartScale = XmCreateScale ( newGraphYScalingForm, "newGraphYScalingStartScale", al, ac );

	XmAddTabGroup(newGraphYScalingStartScale);
	XtAddCallback(newGraphYScalingStartScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_YSSC);
	XtAddCallback(newGraphYScalingStartScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_YSSC);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingStartDef = XmCreatePushButton ( newGraphYScalingForm, "newGraphYScalingStartDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYScalingStartDef, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_YSSC);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(endYValueString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphYScalingEndLabel = XmCreateLabel ( newGraphYScalingForm, "newGraphYScalingEndLabel", al, ac );
	XmStringFree(xmstrings[0]);

	sprintf(text, "%f", (double) YESC_DEF);
	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingEndText = XmCreateText ( newGraphYScalingForm, "newGraphYScalingEndText", al, ac );

	XmAddTabGroup(newGraphYScalingEndText);
	XtAddCallback(newGraphYScalingEndText , XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_YESC);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) YSC_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) YSC_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) YESC_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingEndScale = XmCreateScale ( newGraphYScalingForm, "newGraphYScalingEndScale", al, ac );

	XmAddTabGroup(newGraphYScalingEndScale);
	XtAddCallback(newGraphYScalingEndScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_YESC);
	XtAddCallback(newGraphYScalingEndScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_YESC);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphYScalingEndDef = XmCreatePushButton ( newGraphYScalingForm, "newGraphYScalingEndDef", al, ac );
	XtAddCallback(newGraphYScalingEndDef, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_YESC);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphYScalingSeparator2 = XmCreateSeparator ( newGraphYScalingForm, "newGraphYScalingSeparator2", al, ac);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingOkButton = XmCreatePushButton ( newGraphYScalingForm, "newGraphYScalingOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYScalingOkButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_YSC);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingCancelButton = XmCreatePushButton ( newGraphYScalingForm, "newGraphYScalingCancelButton", al, ac);
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYScalingCancelButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &newGraphYScalingBB);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingHelpButton = XmCreatePushButton ( newGraphYScalingForm, "newGraphYScalingHelpButton", al, ac);
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYScalingHelpButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_YSC);

	/* manage widgets */

	XtManageChild(newGraphYScalingLabel);
	XtManageChild(newGraphYScalingAllWindowsToggle);
	XtManageChild(newGraphYScalingSeparator);
	XtManageChild(newGraphYScalingStartLabel);
	XtManageChild(newGraphYScalingStartText);
	XtManageChild(newGraphYScalingStartScale);
	XtManageChild(newGraphYScalingStartDef);
	XtManageChild(newGraphYScalingEndLabel);
	XtManageChild(newGraphYScalingEndText);
	XtManageChild(newGraphYScalingEndScale);
	XtManageChild(newGraphYScalingEndDef);
	XtManageChild(newGraphYScalingSeparator2);
	XtManageChild(newGraphYScalingOkButton);
	XtManageChild(newGraphYScalingCancelButton);
	XtManageChild(newGraphYScalingHelpButton);
	XtManageChild(newGraphYScalingForm);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingAllWindowsToggle,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingStartLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingStartLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingStartLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingStartText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingStartText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingStartText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingStartScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingStartScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingStartScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingStartDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingStartText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingEndLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingEndLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingStartText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingEndText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingEndText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingStartScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingEndScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingEndScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingEndScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingEndDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingEndText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSeparator2,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
	XtSetValues ( newGraphYScalingCancelButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( newGraphYScalingHelpButton,al, ac );

} /* end of create_newGraphYScaling */

/************************************************************************************************************************

FUNCTION	: create_newGraphXScaling( parent )

PURPOSE		: generates a dialog box for asking the new x-axis scaling value

RETURNS		: nothing

************************************************************************************************************************/

void create_newGraphXScaling( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	newGraphXScaling,
		newGraphXScalingForm,
		newGraphXScalingLabel,
		newGraphXScalingSeparator,
		newGraphXScalingStartLabel,
		newGraphXScalingStartDef,
		newGraphXScalingEndLabel,
		newGraphXScalingEndDef,
		newGraphXScalingSeparator2,
		newGraphXScalingOkButton,
		newGraphXScalingCancelButton,
		newGraphXScalingHelpButton; /* widgets for internal use */

	Arg al[25];      	/* Arg List */
	register int ac; 	/* Arg Count */
	char text[20];	 	/* string containing number */
	XmString xmstrings[10];	/* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, "Graph-Skalierung"); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	newGraphXScaling = XmCreateDialogShell ( parent, "newGraphXScaling", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	newGraphXScalingBB = XmCreateBulletinBoard ( newGraphXScaling, "newGraphXScalingBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingForm = XmCreateForm ( newGraphXScalingBB, "newGraphXScalingForm", al, ac );
	XmAddTabGroup(newGraphXScalingForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(scalingXString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphXScalingLabel = XmCreateLabel ( newGraphXScalingForm, "newGraphXScalingLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(allWindowsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphXScalingAllWindowsToggle = XmCreateToggleButtonGadget ( newGraphXScalingForm,
		"newGraphXScalingAllWindowsToggle", al, ac );
	XmAddTabGroup(newGraphXScalingAllWindowsToggle);
	XtAddCallback (newGraphXScalingAllWindowsToggle, XmNvalueChangedCallback, dialog_toggle3_CB,
		(caddr_t *) DIALOG_SCALE_ALL);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphXScalingSeparator = XmCreateSeparator ( newGraphXScalingForm, "newGraphXScalingSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(startXValueString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphXScalingStartLabel = XmCreateLabel ( newGraphXScalingForm, "newGraphXScalingStartLabel", al, ac );
	XmStringFree(xmstrings[0]);

	sprintf(text, "%f", (double) XSSC_DEF);
	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingStartText = XmCreateText ( newGraphXScalingForm, "newGraphXScalingStartText", al, ac );

	XmAddTabGroup(newGraphXScalingStartText);
	XtAddCallback(newGraphXScalingStartText, XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_XSSC);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) XSC_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) XESC_DEF); ac++;
	XtSetArg(al[ac], XmNvalue, (int) XSSC_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingStartScale = XmCreateScale ( newGraphXScalingForm, "newGraphXScalingStartScale", al, ac );

	XmAddTabGroup(newGraphXScalingStartScale);
	XtAddCallback(newGraphXScalingStartScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_XSSC);
	XtAddCallback(newGraphXScalingStartScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_XSSC);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingStartDef = XmCreatePushButton ( newGraphXScalingForm, "newGraphXScalingStartDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXScalingStartDef, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_XSSC);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(endXValueString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphXScalingEndLabel = XmCreateLabel ( newGraphXScalingForm, "newGraphXScalingEndLabel", al, ac );
	XmStringFree(xmstrings[0]);

	sprintf(text, "%f", (double) XESC_DEF);
	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingEndText = XmCreateText ( newGraphXScalingForm, "newGraphXScalingEndText", al, ac );

	XmAddTabGroup(newGraphXScalingEndText);
	XtAddCallback(newGraphXScalingEndText, XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_XESC);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) XSC_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) XESC_DEF); ac++;
	XtSetArg(al[ac], XmNvalue, (int) XESC_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingEndScale = XmCreateScale ( newGraphXScalingForm, "newGraphXScalingEndScale", al, ac );

	XmAddTabGroup(newGraphXScalingEndScale);
	XtAddCallback(newGraphXScalingEndScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_XESC);
	XtAddCallback(newGraphXScalingEndScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_XESC);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingEndDef = XmCreatePushButton ( newGraphXScalingForm, "newGraphXScalingStartDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXScalingEndDef, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_XESC);

	ac = 0;
	newGraphXScalingSeparator2 = XmCreateSeparator ( newGraphXScalingForm, "newGraphXScalingSeparator2", al, ac);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingOkButton = XmCreatePushButton ( newGraphXScalingForm, "newGraphXScalingOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXScalingOkButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_XSC);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingCancelButton = XmCreatePushButton ( newGraphXScalingForm, "newGraphXScalingCancelButton", al, ac);
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXScalingCancelButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &newGraphXScalingBB);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingHelpButton = XmCreatePushButton ( newGraphXScalingForm, "newGraphXScalingHelpButton", al, ac);
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXScalingHelpButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_XSC);

	/* manage widgets */

	XtManageChild(newGraphXScalingLabel);
	XtManageChild(newGraphXScalingAllWindowsToggle);
	XtManageChild(newGraphXScalingSeparator);
	XtManageChild(newGraphXScalingStartLabel);
	XtManageChild(newGraphXScalingStartText);
	XtManageChild(newGraphXScalingStartScale);
	XtManageChild(newGraphXScalingStartDef);
	XtManageChild(newGraphXScalingEndLabel);
	XtManageChild(newGraphXScalingEndText);
	XtManageChild(newGraphXScalingEndScale);
	XtManageChild(newGraphXScalingEndDef);
	XtManageChild(newGraphXScalingSeparator2);
	XtManageChild(newGraphXScalingOkButton);
	XtManageChild(newGraphXScalingCancelButton);
	XtManageChild(newGraphXScalingHelpButton);
	XtManageChild(newGraphXScalingForm);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingAllWindowsToggle,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingStartLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingStartLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingStartLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingStartText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingStartText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingStartText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingStartScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingStartScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingStartScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingStartDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingStartText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingEndLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingEndLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingStartText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingEndText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingEndText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingStartScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingEndScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingEndScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingEndScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingEndDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingEndText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSeparator2,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
	XtSetValues ( newGraphXScalingCancelButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( newGraphXScalingHelpButton,al, ac );

} /* end of create_newGraphXScaling */
#endif

/************************************************************************************************************************

FUNCTION	: create_newGraph( parent )

PURPOSE		: generates a new graph window with a menu bar and pull down menus for all selected neurons

RETURNS		: nothing

************************************************************************************************************************/

#ifndef BATCH
void create_newGraph( parent )
Widget parent;	/* widget id of parent widget */
#else
void create_newGraph()
#endif
{
#ifndef BATCH
	Widget 	newGraph,
		newGraphMenu,
		newGraphDrawingArea,
		newGraphFileMenu,
		newGraphFileSubMenu,
		newGraphCloseButton,
		newGraphSaveButton,
		newGraphFileSeparator,
		newGraphFileBiosimButton,
		newGraphOptionsMenu,
		newGraphOptionsSubMenu,
		newGraphOptionsScalingCascade,
		newGraphOptionsScalingSubMenu,
		newGraphOptionsScalingXButton,
		newGraphOptionsScalingYButton,
		newGraphOptionsZoomingCascade,
		newGraphOptionsZoomingSubMenu,
		newGraphOptionsZoomingXButton,
		newGraphOptionsZoomingYButton,
		newGraphOptionsGridCascade,
		newGraphOptionsGridSubMenu,
		newGraphOptionsGridSeparator,
		newGraphOptionsOutputIntervalButton,
		newGraphOptionsUpdateWindowButton,
		newGraphOptionsGateVariablesButton,
		newGraphParameterMenu,
		newGraphParameterSubMenu,
		newGraphHelpMenu,
		newGraphHelpSubMenu,
		newGraphHelpIndexButton,
		newGraphHelpFeaturesButton,
		newGraphHelpIntroButton,
		newGraphHelpTargetButton,
		newGraphHelpCellModelButton,
		newGraphHelpContextButton,
		newGraphHelpMouseButton,
		newGraphHelpKeyboardButton,
		newGraphHelpGlossaryButton,
		newGraphHelpSeparator,
		newGraphHelpBiosimButton;	/* widgets for internal use */

	Arg al[25];      		/* Arg List */
	register int ac; 		/* Arg Count */
	XrmDatabase applicationDB;	/* application data base */
	XrmValue value;			/* value returned by resource manager */
	Boolean resourceFileFound;	/* flag for resource file test */
	char *buffer;			/* buffer used to read in helptext file */
	char resourceFile[128];		/* name of resource file */
	char *str_type[20];		/* used to read resource file */
	char text[20];			/* string containing number */
	char title[80];			/* title of graph window */
	Dimension width, height;	/* width and height of graph */
	double temp;			/* temporary variable */
	XmString xmstrings[10]; 	/* temporary storage for XmStrings */
	Atom xa_wm_delete_window;	/* atom for resource deleteResponse */
#endif
	SelectionListNeurons *actptr;	/* help variables */
	unsigned int graphLength;	/* length of current graph */
	Graph *graph;			/* graph structure */

	for (actptr = selectionListNeuronsHead; actptr != NULL; actptr = actptr->next)
	{
	/* check if a graph window of the selected neuron already exists */

	if (actptr->neuronPtr->graph) return; /* only one graph should exist, so return */

	/* create a new graph */

	graph = (Graph *) malloc((size_t) sizeof(Graph));
	if (! graph)
	{
		error(127);
		return;
	}

	/* allocate memory for traces */

	graphLength = (unsigned int) rint((LTSTOP * T_SCALE - XSSC_DEF + 2) / STEP / T_SCALE * sizeof(float));

	graph->soma = (float *) malloc((size_t) graphLength);

	if (! graph->soma)
	{
		error(127);
		return;
	}

	graph->dend = (float *) malloc((size_t) graphLength);

	if (! graph->dend)
	{
		error(127);
		return;
	}

	graph->synC = (float *) malloc((size_t) graphLength);

	if (! graph->synC)
	{
		error(127);
		return;
	}

	graph->totC = (float *) malloc((size_t) graphLength);

	if (! graph->totC)
	{
		error(127);
		return;
	}

	graph->iN = (float *) malloc((size_t) graphLength);

	if (! graph->iN)
	{
		error(127);
		return;
	}

	graph->iNA = (float *) malloc((size_t) graphLength);

	if (! graph->iNA)
	{
		error(127);
		return;
	}

	graph->iK = (float *) malloc((size_t) graphLength);

	if (! graph->iK)
	{
		error(127);
		return;
	}

	graph->iCA = (float *) malloc((size_t) graphLength);

	if (! graph->iCA)
	{
		error(127);
		return;
	}

	graph->iCA1 = (float *) malloc((size_t) graphLength);

	if (! graph->iCA1)
	{
		error(127);
		return;
	}

	graph->iCA2 = (float *) malloc((size_t) graphLength);

	if (! graph->iCA2)
	{
		error(127);
		return;
	}

	graph->iKCA = (float *) malloc((size_t) graphLength);

	if (! graph->iKCA)
	{
		error(127);
		return;
	}

	graph->iA = (float *) malloc((size_t) graphLength);

	if (! graph->iA)
	{
		error(127);
		return;
	}

	graph->iIR = (float *) malloc((size_t) graphLength);

	if (! graph->iIR)
	{
		error(127);
		return;
	}

	graph->iP = (float *) malloc((size_t) graphLength);

	if (! graph->iP)
	{
		error(127);
		return;
	}

	graph->graphSize = graphLength;

#ifndef BATCH
	/* create graph title and icon name for graph window */

	sprintf(title, "%s%d", graphWindowString, actptr->neuronPtr->neuronId);
	sprintf(text, "NW %d", actptr->neuronPtr->neuronId);

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, title); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	newGraph = XmCreateDialogShell (parent, text, al, ac);

	xa_wm_delete_window = XmInternAtom(disp, "WM_DELETE_WINDOW", TRUE);
	XmAddWMProtocolCallback(newGraph, xa_wm_delete_window, dialog_accept3_CB, (caddr_t *) DIALOG_CLOSE_GRAPH);

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphForm = XmCreateForm ( newGraph, "newGraphForm", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmenuAccelerator, "<Key>F4"); ac++;
	newGraphMenu = XmCreateMenuBar ( newGraphForm, "newGraphMenu", al, ac );

	ac = 0;
	newGraphFileSubMenu = XmCreatePulldownMenu ( newGraphMenu, "newGraphFileSubMenu", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(closeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, closeMnemonic); ac++;
	newGraphCloseButton = XmCreatePushButton ( newGraphFileSubMenu, "newGraphCloseButton", al, ac );
	XtAddCallback (newGraphCloseButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_CLOSE_GRAPH);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(saveString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, saveMnemonic); ac++;
	newGraphSaveButton = XmCreatePushButton ( newGraphFileSubMenu, "newGraphSaveButton", al, ac );
	XtAddCallback (newGraphSaveButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_SAVE_GRAPH);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphFileSeparator = XmCreateSeparator ( newGraphFileSubMenu, "newGraphFileSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(overBiosimString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, aboutBiosimMnemonic); ac++;
	newGraphFileBiosimButton = XmCreatePushButton ( newGraphFileSubMenu, "newGraphFileBiosimButton", al, ac );
	XtAddCallback (newGraphFileBiosimButton, XmNactivateCallback, manage_link_CB, (caddr_t *) &overBiosimDialog);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(fileString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, fileMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphFileSubMenu); ac++;
	newGraphFileMenu = XmCreateCascadeButton ( newGraphMenu, "newGraphFileMenu", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphOptionsSubMenu = XmCreatePulldownMenu ( newGraphMenu, "newGraphOptionsSubMenu", al, ac );

	ac = 0;
	newGraphOptionsScalingSubMenu = XmCreatePulldownMenu ( newGraphOptionsSubMenu, "newGraphOptionsScalingSubMenu",
	    al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(xAxesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, xAxesMnemonic); ac++;
	newGraphOptionsScalingXButton = XmCreatePushButton ( newGraphOptionsScalingSubMenu,
		"newGraphOptionsScalingXButton", al, ac );
	XtAddCallback (newGraphOptionsScalingXButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_X_AXE_INIT);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(yAxesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, yAxesMnemonic); ac++;
	newGraphOptionsScalingYButton = XmCreatePushButton ( newGraphOptionsScalingSubMenu,
		"newGraphOptionsScalingYButton", al, ac );
	XtAddCallback (newGraphOptionsScalingYButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_Y_AXE_INIT);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(scalingString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, scalingMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphOptionsScalingSubMenu); ac++;
	newGraphOptionsScalingCascade = XmCreateCascadeButton ( newGraphOptionsSubMenu, "newGraphOptionsScalingCascade",
	    al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphOptionsZoomingSubMenu = XmCreatePulldownMenu ( newGraphOptionsSubMenu, "newGraphOptionsZoomingSubMenu",
	    al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(xAxesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, xAxesMnemonic); ac++;
	newGraphOptionsZoomingXButton = XmCreatePushButton ( newGraphOptionsZoomingSubMenu,
		"newGraphOptionsZoomingXButton", al, ac );
	XtAddCallback (newGraphOptionsZoomingXButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_X_ZOOM_INIT);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(yAxesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, yAxesMnemonic); ac++;
	newGraphOptionsZoomingYButton = XmCreatePushButton ( newGraphOptionsZoomingSubMenu,
		"newGraphOptionsZoomingYButton", al, ac );
	XtAddCallback (newGraphOptionsZoomingYButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_Y_ZOOM_INIT);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(zoomingString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, zoomingMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphOptionsZoomingSubMenu); ac++;
	newGraphOptionsZoomingCascade = XmCreateCascadeButton ( newGraphOptionsSubMenu, "newGraphOptionsZoomingCascade",
	    al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphOptionsGridSubMenu = XmCreatePulldownMenu ( newGraphOptionsSubMenu, "newGraphOptionsGridSubMenu", al,
	    ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(xAxesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, xAxesMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphOptionsGridXToggle = XmCreateToggleButtonGadget ( newGraphOptionsGridSubMenu,
		"newGraphOptionsGridXToggle", al, ac );
	XtAddCallback (newGraphOptionsGridXToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_X_AXE);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(yAxesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, yAxesMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphOptionsGridYToggle = XmCreateToggleButtonGadget ( newGraphOptionsGridSubMenu,
		"newGraphOptionsGridYToggle", al, ac );
	XtAddCallback (newGraphOptionsGridYToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_Y_AXE);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphOptionsGridSeparator = XmCreateSeparator ( newGraphOptionsGridSubMenu, "newGraphOptionsGridSeparator",
	    al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(dotsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, dotsMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphOptionsGridDotsToggle = XmCreateToggleButtonGadget ( newGraphOptionsGridSubMenu,
		"newGraphOptionsGridDotsToggle", al, ac );
	XtAddCallback (newGraphOptionsGridDotsToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_DOTS);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(linesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, linesMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	XtSetArg(al[ac], XmNset, TRUE); ac++;
	newGraphOptionsGridLinesToggle = XmCreateToggleButtonGadget ( newGraphOptionsGridSubMenu,
		"newGraphOptionsGridLinesToggle", al, ac );
	XtAddCallback (newGraphOptionsGridLinesToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_LINES);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(gridString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, gridMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphOptionsGridSubMenu); ac++;
	newGraphOptionsGridCascade = XmCreateCascadeButton ( newGraphOptionsSubMenu, "newGraphOptionsGridCascade",
		al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(asciiDataOutputTitleString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, asciiOutputMnemonic); ac++;
	newGraphOptionsOutputIntervalButton = XmCreatePushButton ( newGraphOptionsSubMenu,
		"newGraphOptionsOutputIntervalButton", al, ac );
	XtAddCallback (newGraphOptionsOutputIntervalButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_ASCOUT);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(refreshWindowString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, refreshWindowMnemonic); ac++;
	newGraphOptionsUpdateWindowButton = XmCreatePushButton ( newGraphOptionsSubMenu,
		"newGraphOptionsUpdateWindowButton", al, ac );
	XtAddCallback (newGraphOptionsUpdateWindowButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_REFRESH_WINDOW);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(gateVariablesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, gateVariablesMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphOptionsGateVariablesButton = XmCreateToggleButtonGadget ( newGraphOptionsSubMenu,
		"newGraphOptionsGateVariablesButton", al, ac );
	XtAddCallback (newGraphOptionsGateVariablesButton, XmNvalueChangedCallback, dialog_toggle3_CB,
		(caddr_t *) DIALOG_GATE_VARIABLES);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(optionString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, optionsMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphOptionsSubMenu); ac++;
	newGraphOptionsMenu = XmCreateCascadeButton ( newGraphMenu, "newGraphOptionsMenu", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphParameterSubMenu = XmCreatePulldownMenu ( newGraphMenu, "XmMenu", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(somaParString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, somaMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	XtSetArg(al[ac], XmNset, TRUE); ac++;
	newGraphParameterSomaToggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu,
		"newGraphParameterSomaToggle", al, ac );
	XtAddCallback (newGraphParameterSomaToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_SOMA);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(dendritParString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, dendritMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphParameterDendritToggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu,
		"newGraphParameterDendritToggle", al, ac );
	XtAddCallback (newGraphParameterDendritToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_DENDRIT);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(synapticCurrentString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, synapticCurrentMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphParameterSynapticCurrentToggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu,
		"newGraphParameterSynapticCurrentToggle", al, ac );
	XtAddCallback (newGraphParameterSynapticCurrentToggle, XmNvalueChangedCallback, dialog_toggle3_CB,
		(caddr_t *) DIALOG_SYNAPTIC_CURRENT);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(totalCurrentString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, totalCurrentMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphParameterTotalCurrentToggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu,
		"newGraphParameterTotalCurrentToggle", al, ac );
	XtAddCallback (newGraphParameterTotalCurrentToggle, XmNvalueChangedCallback, dialog_toggle3_CB,
		(caddr_t *) DIALOG_TOTAL_CURRENT);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(nChannelsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, nMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphParameterNToggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu, "newGraphParameterNToggle",
		al, ac );
	XtAddCallback (newGraphParameterNToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_N);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(naChannelsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, naMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphParameterNAToggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu, "newGraphParameterNAToggle",
		al, ac );
	XtAddCallback (newGraphParameterNAToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_NA);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(kChannelsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, kMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphParameterKToggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu, "newGraphParameterKToggle",
		al, ac );
	XtAddCallback (newGraphParameterKToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_K);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(caChannelsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, caMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphParameterCAToggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu, "newGraphParameterCAToggle",
		al, ac );
	XtAddCallback (newGraphParameterCAToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_CA);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(ca1ChannelsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, ca1Mnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphParameterCA1Toggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu, "newGraphParameterCA1Toggle",
		al, ac );
	XtAddCallback (newGraphParameterCA1Toggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_CA1);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(ca2ChannelsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, ca2Mnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphParameterCA2Toggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu, "newGraphParameterCA2Toggle",
		al, ac );
	XtAddCallback (newGraphParameterCA2Toggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_CA2);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(kcaChannelsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, kcaMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphParameterKCAToggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu, "newGraphParameterKCAToggle",
		al, ac );
	XtAddCallback (newGraphParameterKCAToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_KCA);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(aChannelsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, aMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphParameterAToggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu, "newGraphParameterAToggle",
		al, ac );
	XtAddCallback (newGraphParameterAToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_A);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(irChannelsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, irMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphParameterIRToggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu, "newGraphParameterIRToggle",
		al, ac );
	XtAddCallback (newGraphParameterIRToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_IR);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(pChannelsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, pMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphParameterPToggle = XmCreateToggleButtonGadget ( newGraphParameterSubMenu, "newGraphParameterPToggle",
		al, ac );
	XtAddCallback (newGraphParameterPToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_P);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(parameterString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, parameterMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphParameterSubMenu); ac++;
	newGraphParameterMenu = XmCreateCascadeButton ( newGraphMenu, "newGraphParameterMenu", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphHelpSubMenu = XmCreatePulldownMenu ( newGraphMenu, "newGraphHelpSubMenu", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(indexString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, indexMnemonic); ac++;
	newGraphHelpIndexButton = XmCreatePushButton ( newGraphHelpSubMenu, "newGraphHelpIndexButton", al, ac );
	XtAddCallback (newGraphHelpIndexButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_INDEX);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(featuresString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, featuresMnemonic); ac++;
	newGraphHelpFeaturesButton = XmCreatePushButton ( newGraphHelpSubMenu, "newGraphHelpFeaturesButton", al, ac );
	XtAddCallback (newGraphHelpFeaturesButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_FEATURES);
	XtManageChild(newGraphHelpFeaturesButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(introString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, introMnemonic); ac++;
	newGraphHelpIntroButton = XmCreatePushButton ( newGraphHelpSubMenu, "newGraphHelpIntroButton", al, ac );
	XtAddCallback (newGraphHelpIntroButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_INTRO);
	XtManageChild(newGraphHelpIntroButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(targetString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, targetMnemonic); ac++;
	newGraphHelpTargetButton = XmCreatePushButton ( newGraphHelpSubMenu, "newGraphHelpTargetButton", al, ac );
	XtAddCallback (newGraphHelpTargetButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_TARGET);
	XtManageChild(newGraphHelpTargetButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(cellModelString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, cellModelMnemonic); ac++;
	newGraphHelpCellModelButton = XmCreatePushButton ( newGraphHelpSubMenu, "newGraphHelpCellModelButton", al, ac );
	XtAddCallback (newGraphHelpCellModelButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_CELLMODEL);
	XtManageChild(newGraphHelpCellModelButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(contextString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, contextMnemonic); ac++;
	newGraphHelpContextButton = XmCreatePushButton ( newGraphHelpSubMenu, "newGraphHelpContextButton", al, ac );
	XtAddCallback (newGraphHelpContextButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_CONTEXT);
	XtManageChild(newGraphHelpContextButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(mouseString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, mouseMnemonic); ac++;
	newGraphHelpMouseButton = XmCreatePushButton ( newGraphHelpSubMenu, "newGraphHelpMouseButton", al, ac );
	XtAddCallback (newGraphHelpMouseButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_MOUSE);
	XtManageChild(newGraphHelpMouseButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(keyboardString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, keyboardMnemonic); ac++;
	newGraphHelpKeyboardButton = XmCreatePushButton ( newGraphHelpSubMenu, "newGraphHelpKeyboardButton",al,ac);
	XtAddCallback (newGraphHelpKeyboardButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_KEYBOARD);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(glossaryString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, glossaryMnemonic); ac++;
	newGraphHelpGlossaryButton = XmCreatePushButton ( newGraphHelpSubMenu, "newGraphHelpGlossaryButton", al, ac );
	XtAddCallback (newGraphHelpGlossaryButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_GLOSSAR);
	XtManageChild(newGraphHelpGlossaryButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphHelpSeparator = XmCreateSeparator ( newGraphHelpSubMenu, "newGraphHelpSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(overBiosimString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, aboutBiosimMnemonic); ac++;
	newGraphHelpBiosimButton = XmCreatePushButton ( newGraphHelpSubMenu, "newGraphHelpBiosimButton", al, ac );
	XtAddCallback (newGraphHelpBiosimButton, XmNactivateCallback, manage_link_CB, (caddr_t *) &overBiosimDialog);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, helpMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphHelpSubMenu); ac++;
	newGraphHelpMenu = XmCreateCascadeButton ( newGraphMenu, "newGraphHelpMenu", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNmenuHelpWidget, newGraphHelpMenu); ac++;
	XtSetValues ( newGraphMenu,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 0); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 0); ac++;
	newGraphDrawingArea = XmCreateDrawingArea ( newGraphForm, "newGraphDrawingArea", al, ac );
	XtAddCallback (newGraphDrawingArea, XmNexposeCallback, draw_graph_CB, (caddr_t *) NULL);

	/* manage widgets */

	XtManageChild(newGraphMenu);
	XtManageChild(newGraphFileMenu);
	XtManageChild(newGraphCloseButton);
	XtManageChild(newGraphSaveButton);
	XtManageChild(newGraphFileSeparator);
	XtManageChild(newGraphFileBiosimButton);
	XtManageChild(newGraphOptionsMenu);
	XtManageChild(newGraphOptionsScalingCascade);
	XtManageChild(newGraphOptionsScalingXButton);
	XtManageChild(newGraphOptionsScalingYButton);
	XtManageChild(newGraphOptionsZoomingCascade);
	XtManageChild(newGraphOptionsZoomingXButton);
	XtManageChild(newGraphOptionsZoomingYButton);
	XtManageChild(newGraphOptionsGridCascade);
	XtManageChild(newGraphOptionsGridXToggle);
	XtManageChild(newGraphOptionsGridYToggle);
	XtManageChild(newGraphOptionsGridSeparator);
	XtManageChild(newGraphOptionsGridDotsToggle);
	XtManageChild(newGraphOptionsGridLinesToggle);
	XtManageChild(newGraphOptionsOutputIntervalButton);
	XtManageChild(newGraphOptionsUpdateWindowButton);
	XtManageChild(newGraphOptionsGateVariablesButton);
	XtManageChild(newGraphParameterMenu);
	XtManageChild(newGraphParameterSomaToggle);
	XtManageChild(newGraphParameterDendritToggle);
	XtManageChild(newGraphParameterSynapticCurrentToggle);
	XtManageChild(newGraphParameterTotalCurrentToggle);
	XtManageChild(newGraphParameterNAToggle);
	XtManageChild(newGraphParameterKToggle);
	XtManageChild(newGraphParameterCAToggle);
	XtManageChild(newGraphParameterCA1Toggle);
	XtManageChild(newGraphParameterCA2Toggle);
	XtManageChild(newGraphParameterKCAToggle);
	XtManageChild(newGraphParameterAToggle);
	XtManageChild(newGraphParameterIRToggle);
	XtManageChild(newGraphParameterPToggle);
	XtManageChild(newGraphParameterNToggle);
	XtManageChild(newGraphHelpMenu);
	XtManageChild(newGraphHelpIndexButton);
	XtManageChild(newGraphHelpFeaturesButton);
	XtManageChild(newGraphHelpIntroButton);
	XtManageChild(newGraphHelpTargetButton);
	XtManageChild(newGraphHelpCellModelButton);
	XtManageChild(newGraphHelpContextButton);
	XtManageChild(newGraphHelpMouseButton);
	XtManageChild(newGraphHelpKeyboardButton);
	XtManageChild(newGraphHelpGlossaryButton);
	XtManageChild(newGraphHelpSeparator);
	XtManageChild(newGraphHelpBiosimButton);
	XtManageChild(newGraphDrawingArea);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphMenu,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphMenu); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphDrawingArea,al, ac );

	/* make graph window visible */

	XSync(disp, FALSE);
	XtManageChild(newGraphForm);

	/* get width and height of drawing area of graph */

	buffer = getenv("HOME");
	strcpy(resourceFile, buffer);
	strcat(resourceFile, "/Biosim");

	if (! (applicationDB = XrmGetFileDatabase(resourceFile)))
	{
		/* now try default application directory */

		strcpy(resourceFile, "/usr/lib/X11/app-defaults/Biosim");
		if (! (applicationDB = XrmGetFileDatabase(resourceFile)))
		{
			fprintf(stderr, "Warning: No resource file found ! Using default values.\n");
			width = 552;
			height = 220;
			resourceFileFound = FALSE;
		}
		else	resourceFileFound = TRUE;
	}
	else	resourceFileFound = TRUE;

	if (resourceFileFound)
	{
		if (XrmGetResource(applicationDB, "biosim.drawingAreaWidth", "Biosim.DrawingAreaWidth", str_type, &value))
		{
			strncpy(text, value.addr, (int) value.size);
			width = atoi(text);
		}
		else
		{
			fprintf(stderr, "Error: Resource drawingAreaWidth not found. Defaulting to 552\n");
			width = 552;
		}

		if (XrmGetResource(applicationDB, "biosim.drawingAreaHeight", "Biosim.DrawingAreaHeight", str_type, &value))
		{
			strncpy(text, value.addr, (int) value.size);
			height = atoi(text);
		}
		else
		{
			fprintf(stderr, "Error: Resource drawingAreaHeight not found. Defaulting to 220\n");
			height = 220;
		}
	}
#endif

	/* initialize graph data */

	currentGraph = graph;
	currentNeuron = actptr->neuronPtr;
	graph->neuron = currentNeuron;
	currentNeuron->graph = graph;
#ifndef BATCH
	graph->drawingArea = newGraphDrawingArea;
	graph->formWidget = newGraphForm;
	graph->dendritToggle = newGraphParameterDendritToggle;
#endif
	graph->dendritSegment = 0;

	graph->hasValues = FALSE;
	graph->gateVariables = FALSE;
	graph->traceSoma = TRUE;
	graph->traceDendrit = FALSE;
	graph->traceSynapticCurrent = FALSE;
	graph->traceTotalCurrent = FALSE;
	graph->traceN = FALSE;
	graph->traceNA = FALSE;
	graph->traceK = FALSE;
	graph->traceCA = FALSE;
	graph->traceCA1 = FALSE;
	graph->traceCA2 = FALSE;
	graph->traceKCA = FALSE;
	graph->traceA = FALSE;
	graph->traceIR = FALSE;
	graph->traceP = FALSE;

	graph->lastX = (double) LTSTOP * T_SCALE;
#ifndef BATCH
	graph->width = (int) (width - mvSpace);
	graph->height = (int) (height - msSpace);
	graph->highestY = (double) YESC_DEF;
	graph->lowestY = (double) YSSC_DEF;
	graph->firstX = (double) XSSC_DEF;
	graph->xScale = (double) graph->width / (graph->lastX - graph->firstX);
	temp = graph->highestY - graph->lowestY;
	temp = fabs(temp);
	graph->yScale = (double) graph->height / temp;
	graph->yStep = graph->yScale;
	graph->axis = 0;
	graph->gridType = 2;
#endif
	graph->asciiDataOutputInterval = ASCOUT_DEF / T_SCALE;

#ifndef BATCH
	/* select input focus of graph window */

	XSelectInput(disp, XtWindow(newGraph), VisibilityChangeMask | StructureNotifyMask);

	/* initialize graph values for x - and y - axis */

	set_x_axis(graph);
	set_y_axis(graph);

	/* draw the graph from scratch */

	draw_graph(currentNeuron);

#endif

	/* increase total graph number */

	graphNumber++;

	}
} /* end of create_newGraph */

#ifndef BATCH
/************************************************************************************************************************

FUNCTION	: create_asciiOutputIntervalS( parent )

PURPOSE		: generates a dialog box for asking the graph output interval

RETURNS		: nothing

************************************************************************************************************************/

void create_asciiOutputIntervalS( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	asciiOutputIntervalS,
		asciiOutputIntervalSForm,
		asciiOutputIntervalSLabel,
		asciiOutputIntervalSDefButton,
		asciiOutputIntervalSSeparator,
		asciiOutputIntervalSOkButton,
		asciiOutputIntervalSNoButton,
		asciiOutputIntervalSHelpButton; /* internal used widgets */

	Widget children[8];	/* Children to manage */
	Arg al[64];           	/* Arg List */
	register int ac = 0;    /* Arg Count */
	XmString xmstrings[10]; /* temporary storage for XmStrings */
	char text[20];		/* string containing number */

	/* create widgets */

	XtSetArg(al[ac], XmNtitle, asciiDataOutputTitleString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	asciiOutputIntervalS = XmCreateDialogShell ( parent, "asciiOutputIntervalS", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	asciiOutputIntervalSBB = XmCreateBulletinBoard ( asciiOutputIntervalS, "asciiOutputIntervalSBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalSForm = XmCreateForm ( asciiOutputIntervalSBB, "asciiOutputIntervalSForm", al, ac );
	XmAddTabGroup(asciiOutputIntervalSForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(asciiDataOutputIntervalString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	asciiOutputIntervalSLabel = XmCreateLabel ( asciiOutputIntervalSForm, "asciiOutputIntervalSLabel", al, ac );
	XmStringFree ( xmstrings [ 0 ] );

	ac = 0;
	sprintf(text, "%f", (double) ASCOUT_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalSText = XmCreateText ( asciiOutputIntervalSForm, "asciiOutputIntervalSText", al, ac );

	XmAddTabGroup(asciiOutputIntervalSText);
	XtAddCallback(asciiOutputIntervalSText, XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_ASCIIS);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) (ASCOUT_MIN * 100)); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) (ASCOUT_MAX * 100)); ac++;
	XtSetArg(al[ac], XmNvalue, (int) (ASCOUT_DEF * 100)); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalSScale = XmCreateScale ( asciiOutputIntervalSForm, "asciiOutputIntervalSScale", al, ac );

	XmAddTabGroup(asciiOutputIntervalSScale);
	XtAddCallback(asciiOutputIntervalSScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_ASCIIS);
	XtAddCallback(asciiOutputIntervalSScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_ASCIIS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalSDefButton = XmCreatePushButton ( asciiOutputIntervalSForm, "asciiOutputIntervalSDefButton",
		al, ac );

	XtAddCallback(asciiOutputIntervalSDefButton, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_ASCIIS);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	asciiOutputIntervalSSeparator = XmCreateSeparator ( asciiOutputIntervalSForm, "asciiOutputIntervalSSeparator",
		al, ac );
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalSOkButton = XmCreatePushButton ( asciiOutputIntervalSForm, "asciiOutputIntervalSOkButton",
		al, ac );

	XtAddCallback(asciiOutputIntervalSOkButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_ASCIIS);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalSNoButton = XmCreatePushButton ( asciiOutputIntervalSForm, "asciiOutputIntervalSNoButton",
		al, ac );

	XtAddCallback(asciiOutputIntervalSNoButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &asciiOutputIntervalSBB);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	asciiOutputIntervalSHelpButton = XmCreatePushButton ( asciiOutputIntervalSForm, "asciiOutputIntervalSHelpButton",
		al, ac );

	XtAddCallback(asciiOutputIntervalSHelpButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_ASCIIS);

	/* attach widgets */

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( asciiOutputIntervalSLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, asciiOutputIntervalSLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( asciiOutputIntervalSText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, asciiOutputIntervalSText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( asciiOutputIntervalSScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, asciiOutputIntervalSScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( asciiOutputIntervalSDefButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, asciiOutputIntervalSText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( asciiOutputIntervalSSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, asciiOutputIntervalSSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( asciiOutputIntervalSOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, asciiOutputIntervalSSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
	XtSetValues ( asciiOutputIntervalSNoButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, asciiOutputIntervalSSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( asciiOutputIntervalSHelpButton,al, ac );

	/* manage widgets */

	ac = 0;
	children[ac++] = asciiOutputIntervalSLabel;
	children[ac++] = asciiOutputIntervalSText;
	children[ac++] = asciiOutputIntervalSScale;
	children[ac++] = asciiOutputIntervalSDefButton;
	children[ac++] = asciiOutputIntervalSSeparator;
	children[ac++] = asciiOutputIntervalSOkButton;
	children[ac++] = asciiOutputIntervalSNoButton;
	children[ac++] = asciiOutputIntervalSHelpButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = asciiOutputIntervalSForm;
	XtManageChildren(children, ac);

} /* end of create_asciiOutputIntervalS */

/************************************************************************************************************************

FUNCTION	: create_newGraphYZoomS( parent )

PURPOSE		: generates a dialog box for asking the new y-axis zoom value

RETURNS		: nothing

************************************************************************************************************************/

void create_newGraphYZoomS( parent )
Widget parent;
{
	Widget 	newGraphYZoomS,
		newGraphYZoomSForm,
		newGraphYZoomSLabel,
		newGraphYZoomSMagDef,
		newGraphYZoomSSeparator,
		newGraphYZoomSMagLabel,
		newGraphYZoomSSeparator2,
		newGraphYZoomSOkButton,
		newGraphYZoomSCancelButton,
		newGraphYZoomSHelpButton; /* widgets for internal use */

	Arg al[25];      	/* Arg List */
	register int ac; 	/* Arg Count */
	char text[20];	 	/* string containing number */
	XmString xmstrings[10]; /* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, graphZoomString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	newGraphYZoomS = XmCreateDialogShell ( parent, "newGraphYZoomS", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	newGraphYZoomSBB = XmCreateBulletinBoard ( newGraphYZoomS, "newGraphYZoomSBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomSForm = XmCreateForm ( newGraphYZoomSBB, "newGraphYZoomSForm", al, ac );
	XmAddTabGroup(newGraphYZoomSForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(zoomYValueString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphYZoomSLabel = XmCreateLabel ( newGraphYZoomSForm, "newGraphYZoomSLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(allWindowsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphYZoomSAllWindowsToggle = XmCreateToggleButtonGadget ( newGraphYZoomSForm, "newGraphYZoomSAllWindowsToggle",
		al, ac );
	XmAddTabGroup(newGraphYZoomSAllWindowsToggle);
	XtAddCallback (newGraphYZoomSAllWindowsToggle, XmNvalueChangedCallback, dialog_toggle3_CB,
		(caddr_t *) DIALOG_S_ZOOM_ALL);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphYZoomSSeparator = XmCreateSeparator ( newGraphYZoomSForm, "newGraphYZoomSSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(magFactorString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphYZoomSMagLabel = XmCreateLabel ( newGraphYZoomSForm, "newGraphYZoomSMagLabel", al, ac );
	XmStringFree(xmstrings[0]);

	sprintf(text, "%f", (double) YZO_DEF);
	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomSMagText = XmCreateText ( newGraphYZoomSForm, "newGraphYZoomSMagText", al, ac );

	XmAddTabGroup(newGraphYZoomSMagText);
	XtAddCallback(newGraphYZoomSMagText, XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_YZOS);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) YZO_MIN * 10); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) YZO_MAX * 10); ac++;
	XtSetArg(al[ac], XmNvalue, (int) YZO_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 1); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomSMagScale = XmCreateScale ( newGraphYZoomSForm, "newGraphYZoomSMagScale", al, ac );

	XmAddTabGroup(newGraphYZoomSMagScale);
	XtAddCallback(newGraphYZoomSMagScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_YZOS);
	XtAddCallback(newGraphYZoomSMagScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_YZOS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomSMagDef = XmCreatePushButton ( newGraphYZoomSForm, "newGraphYZoomSMagDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYZoomSMagDef, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_YZOS);

	ac = 0;
	newGraphYZoomSSeparator2 = XmCreateSeparator ( newGraphYZoomSForm, "newGraphYZoomSSeparator2", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomSOkButton = XmCreatePushButton ( newGraphYZoomSForm, "newGraphYZoomSOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYZoomSOkButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_YZOS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomSCancelButton = XmCreatePushButton ( newGraphYZoomSForm, "newGraphYZoomSCancelButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYZoomSCancelButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &newGraphYZoomSBB);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYZoomSHelpButton = XmCreatePushButton ( newGraphYZoomSForm, "newGraphYZoomSHelpButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYZoomSHelpButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_YZOS);

	/* manage widgets */

	XtManageChild(newGraphYZoomSLabel);
	XtManageChild(newGraphYZoomSAllWindowsToggle);
	XtManageChild(newGraphYZoomSSeparator);
	XtManageChild(newGraphYZoomSMagLabel);
	XtManageChild(newGraphYZoomSMagText);
	XtManageChild(newGraphYZoomSMagScale);
	XtManageChild(newGraphYZoomSMagDef);
	XtManageChild(newGraphYZoomSSeparator2);
	XtManageChild(newGraphYZoomSOkButton);
	XtManageChild(newGraphYZoomSCancelButton);
	XtManageChild(newGraphYZoomSHelpButton);
	XtManageChild(newGraphYZoomSForm);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomSLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYZoomSLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomSAllWindowsToggle,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomSSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomSMagLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSMagLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYZoomSMagLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomSMagText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSMagText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYZoomSMagText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomSMagScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSMagScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYZoomSMagScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomSMagDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSMagText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomSSeparator2,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYZoomSOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
	XtSetValues ( newGraphYZoomSCancelButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYZoomSSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( newGraphYZoomSHelpButton,al, ac );

} /* end of create_newGraphYZoomS */

/************************************************************************************************************************

FUNCTION	: create_newGraphXZoomS( parent )

PURPOSE		: generates a dialog box for asking the new x-axis zoom value

RETURNS		: nothing

************************************************************************************************************************/

void create_newGraphXZoomS( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	newGraphXZoomS,
		newGraphXZoomSForm,
		newGraphXZoomSLabel,
		newGraphXZoomSSeparator,
		newGraphXZoomSMagLabel,
		newGraphXZoomSMagDef,
		newGraphXZoomSSeparator2,
		newGraphXZoomSOkButton,
		newGraphXZoomSCancelButton,
		newGraphXZoomSHelpButton; /* widgets for internal use */

	Arg al[25];      	/* Arg List */
	register int ac; 	/* Arg Count */
	char text[20];	 	/* string containing number */
	XmString xmstrings[10];	/* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, "Graph-Zoom"); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	newGraphXZoomS = XmCreateDialogShell ( parent, "newGraphXZoomS", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	newGraphXZoomSBB = XmCreateBulletinBoard ( newGraphXZoomS, "newGraphXZoomSBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomSForm = XmCreateForm ( newGraphXZoomSBB, "newGraphXZoomSForm", al, ac );
	XmAddTabGroup(newGraphXZoomSForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(zoomXValueString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphXZoomSLabel = XmCreateLabel ( newGraphXZoomSForm, "newGraphXZoomSLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(allWindowsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphXZoomSAllWindowsToggle = XmCreateToggleButtonGadget ( newGraphXZoomSForm, "newGraphXZoomSAllWindowsToggle",
		al, ac );
	XmAddTabGroup(newGraphXZoomSAllWindowsToggle);
	XtAddCallback (newGraphXZoomSAllWindowsToggle, XmNvalueChangedCallback, dialog_toggle3_CB,
		(caddr_t *) DIALOG_S_ZOOM_ALL);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphXZoomSSeparator = XmCreateSeparator ( newGraphXZoomSForm, "newGraphXZoomSSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(magFactorString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphXZoomSMagLabel = XmCreateLabel ( newGraphXZoomSForm, "newGraphXZoomSMagLabel", al, ac );
	XmStringFree(xmstrings[0]);

	sprintf(text, "%f", (double) XZO_DEF);
	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomSMagText = XmCreateText ( newGraphXZoomSForm, "newGraphXZoomSMagText", al, ac );

	XmAddTabGroup(newGraphXZoomSMagText);
	XtAddCallback(newGraphXZoomSMagText, XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_XZOS);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) XZO_MIN * 10); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) XZO_MAX * 10); ac++;
	XtSetArg(al[ac], XmNvalue, (int) XZO_DEF * 10); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 1); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomSMagScale = XmCreateScale ( newGraphXZoomSForm, "newGraphXZoomSMagScale", al, ac );

	XmAddTabGroup(newGraphXZoomSMagScale);
	XtAddCallback(newGraphXZoomSMagScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_XZOS);
	XtAddCallback(newGraphXZoomSMagScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_XZOS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomSMagDef = XmCreatePushButton ( newGraphXZoomSForm, "newGraphXZoomSMagDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXZoomSMagDef, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_XZOS);

	ac = 0;
	newGraphXZoomSSeparator2 = XmCreateSeparator ( newGraphXZoomSForm, "newGraphXZoomSSeparator2", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomSOkButton = XmCreatePushButton ( newGraphXZoomSForm, "newGraphXZoomSOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXZoomSOkButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_XZOS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomSCancelButton = XmCreatePushButton ( newGraphXZoomSForm, "newGraphXZoomSCancelButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXZoomSCancelButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &newGraphXZoomSBB);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXZoomSHelpButton = XmCreatePushButton ( newGraphXZoomSForm, "newGraphXZoomSHelpButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXZoomSHelpButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_XZOS);

	/* manage widgets */

	XtManageChild(newGraphXZoomSLabel);
	XtManageChild(newGraphXZoomSAllWindowsToggle);
	XtManageChild(newGraphXZoomSSeparator);
	XtManageChild(newGraphXZoomSMagLabel);
	XtManageChild(newGraphXZoomSMagText);
	XtManageChild(newGraphXZoomSMagScale);
	XtManageChild(newGraphXZoomSMagDef);
	XtManageChild(newGraphXZoomSSeparator2);
	XtManageChild(newGraphXZoomSOkButton);
	XtManageChild(newGraphXZoomSCancelButton);
	XtManageChild(newGraphXZoomSHelpButton);
	XtManageChild(newGraphXZoomSForm);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomSLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXZoomSLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomSAllWindowsToggle,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomSSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomSMagLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSMagLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXZoomSMagLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomSMagText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSMagText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXZoomSMagText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomSMagScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSMagScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXZoomSMagScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomSMagDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSMagText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomSSeparator2,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXZoomSOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
	XtSetValues ( newGraphXZoomSCancelButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXZoomSSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( newGraphXZoomSHelpButton,al, ac );

} /* end of create_newGraphXZoomS */

/************************************************************************************************************************

FUNCTION	: create_newGraphYScalingS( parent )

PURPOSE		: generates a dialog box for asking the new y-axis scaling value

RETURNS		: nothing

************************************************************************************************************************/

void create_newGraphYScalingS( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	newGraphYScalingS,
		newGraphYScalingSForm,
		newGraphYScalingSLabel,
		newGraphYScalingSSeparator,
		newGraphYScalingSStartLabel,
		newGraphYScalingSStartDef,
		newGraphYScalingSEndLabel,
		newGraphYScalingSEndDef,
		newGraphYScalingSSeparator2,
		newGraphYScalingSOkButton,
		newGraphYScalingSCancelButton,
		newGraphYScalingSHelpButton;	/* widgets for internal use */

	Arg al[25];      	/* Arg List */
	register int ac; 	/* Arg Count */
	char text[20];	 	/* string containing number */
	XmString xmstrings[10];	/* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, "Graph-Skalierung"); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	newGraphYScalingS = XmCreateDialogShell ( parent, "newGraphYScalingS", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	newGraphYScalingSBB = XmCreateBulletinBoard ( newGraphYScalingS, "newGraphYScalingSBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingSForm = XmCreateForm ( newGraphYScalingSBB, "newGraphYScalingSForm", al, ac );
	XmAddTabGroup(newGraphYScalingSForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(scalingYString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphYScalingSLabel = XmCreateLabel ( newGraphYScalingSForm, "newGraphYScalingSLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(allWindowsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphYScalingSAllWindowsToggle = XmCreateToggleButtonGadget ( newGraphYScalingSForm,
		"newGraphYScalingSAllWindowsToggle", al, ac );
	XmAddTabGroup(newGraphYScalingSAllWindowsToggle);
	XtAddCallback (newGraphYScalingSAllWindowsToggle, XmNvalueChangedCallback, dialog_toggle3_CB,
		(caddr_t *) DIALOG_S_SCALE_ALL);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphYScalingSSeparator = XmCreateSeparator ( newGraphYScalingSForm, "newGraphYScalingSSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(startYValueString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphYScalingSStartLabel = XmCreateLabel ( newGraphYScalingSForm, "newGraphYScalingSStartLabel", al, ac );
	XmStringFree(xmstrings[0]);

	sprintf(text, "%f", (double) YSSC_DEF);
	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingSStartText = XmCreateText ( newGraphYScalingSForm, "newGraphYScalingSStartText", al, ac );

	XmAddTabGroup(newGraphYScalingSStartText);
	XtAddCallback(newGraphYScalingSStartText, XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_YSSCS);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) YSC_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) YSC_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) YSSC_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingSStartScale = XmCreateScale ( newGraphYScalingSForm, "newGraphYScalingSStartScale", al, ac );

	XmAddTabGroup(newGraphYScalingSStartScale);
	XtAddCallback(newGraphYScalingSStartScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_YSSCS);
	XtAddCallback(newGraphYScalingSStartScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_YSSCS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingSStartDef = XmCreatePushButton ( newGraphYScalingSForm, "newGraphYScalingSStartDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYScalingSStartDef, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_YSSCS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(endYValueString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphYScalingSEndLabel = XmCreateLabel ( newGraphYScalingSForm, "newGraphYScalingSEndLabel", al, ac );
	XmStringFree(xmstrings[0]);

	sprintf(text, "%f", (double) YESC_DEF);
	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingSEndText = XmCreateText ( newGraphYScalingSForm, "newGraphYScalingSEndText", al, ac );

	XmAddTabGroup(newGraphYScalingSEndText);
	XtAddCallback(newGraphYScalingSEndText , XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_YESCS);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) YSC_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) YSC_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) YESC_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingSEndScale = XmCreateScale ( newGraphYScalingSForm, "newGraphYScalingSEndScale", al, ac );

	XmAddTabGroup(newGraphYScalingSEndScale);
	XtAddCallback(newGraphYScalingSEndScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_YESCS);
	XtAddCallback(newGraphYScalingSEndScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_YESCS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingSEndDef = XmCreatePushButton ( newGraphYScalingSForm, "newGraphYScalingSEndDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYScalingSEndDef, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_YESCS);

	ac = 0;
	newGraphYScalingSSeparator2 = XmCreateSeparator ( newGraphYScalingSForm, "newGraphYScalingSSeparator2", al, ac);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingSOkButton = XmCreatePushButton ( newGraphYScalingSForm, "newGraphYScalingSOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYScalingSOkButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_YSCS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingSCancelButton = XmCreatePushButton ( newGraphYScalingSForm, "newGraphYScalingSCancelButton", al,
	    ac );

	XtAddCallback(newGraphYScalingSCancelButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &newGraphYScalingSBB);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphYScalingSHelpButton = XmCreatePushButton ( newGraphYScalingSForm, "newGraphYScalingSHelpButton", al, ac);
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphYScalingSHelpButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_YSCS);

	/* manage widgets */

	XtManageChild(newGraphYScalingSLabel);
	XtManageChild(newGraphYScalingSAllWindowsToggle);
	XtManageChild(newGraphYScalingSSeparator);
	XtManageChild(newGraphYScalingSStartLabel);
	XtManageChild(newGraphYScalingSStartText);
	XtManageChild(newGraphYScalingSStartScale);
	XtManageChild(newGraphYScalingSStartDef);
	XtManageChild(newGraphYScalingSEndLabel);
	XtManageChild(newGraphYScalingSEndText);
	XtManageChild(newGraphYScalingSEndScale);
	XtManageChild(newGraphYScalingSEndDef);
	XtManageChild(newGraphYScalingSSeparator2);
	XtManageChild(newGraphYScalingSOkButton);
	XtManageChild(newGraphYScalingSCancelButton);
	XtManageChild(newGraphYScalingSHelpButton);
	XtManageChild(newGraphYScalingSForm);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingSLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSAllWindowsToggle,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSStartLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSStartLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingSStartLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSStartText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSStartText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingSStartText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSStartScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSStartScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingSStartScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSStartDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSStartText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSEndLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSEndLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingSStartText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSEndText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSEndText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingSStartScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSEndScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSEndScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphYScalingSEndScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSEndDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSEndText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSSeparator2,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphYScalingSOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
	XtSetValues ( newGraphYScalingSCancelButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphYScalingSSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( newGraphYScalingSHelpButton,al, ac );

} /* end of create_newGraphYScalingS */

/************************************************************************************************************************

FUNCTION	: create_newGraphXScalingS( parent )

PURPOSE		: generates a dialog box for asking the new x-axis scaling value

RETURNS		: nothing

************************************************************************************************************************/

void create_newGraphXScalingS( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	newGraphXScalingS,
		newGraphXScalingSForm,
		newGraphXScalingSLabel,
		newGraphXScalingSSeparator,
		newGraphXScalingSStartLabel,
		newGraphXScalingSStartDef,
		newGraphXScalingSEndLabel,
		newGraphXScalingSEndDef,
		newGraphXScalingSSeparator2,
		newGraphXScalingSOkButton,
		newGraphXScalingSCancelButton,
		newGraphXScalingSHelpButton; /* widgets for internal use */

	Arg al[25];      	/* Arg List */
	register int ac; 	/* Arg Count */
	char text[20];	 	/* string containing number */
	XmString xmstrings[10];	/* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, "Graph-Skalierung"); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	newGraphXScalingS = XmCreateDialogShell ( parent, "newGraphXScalingS", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	newGraphXScalingSBB = XmCreateBulletinBoard ( newGraphXScalingS, "newGraphXScalingSBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingSForm = XmCreateForm ( newGraphXScalingSBB, "newGraphXScalingSForm", al, ac );
	XmAddTabGroup(newGraphXScalingSForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(scalingXString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphXScalingSLabel = XmCreateLabel ( newGraphXScalingSForm, "newGraphXScalingSLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(allWindowsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphXScalingSAllWindowsToggle = XmCreateToggleButtonGadget ( newGraphXScalingSForm,
		"newGraphXScalingSAllWindowsToggle", al, ac );
	XmAddTabGroup(newGraphXScalingSAllWindowsToggle);
	XtAddCallback (newGraphXScalingSAllWindowsToggle, XmNvalueChangedCallback, dialog_toggle3_CB,
		(caddr_t *) DIALOG_S_SCALE_ALL);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphXScalingSSeparator = XmCreateSeparator ( newGraphXScalingSForm, "newGraphXScalingSSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(startXValueString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphXScalingSStartLabel = XmCreateLabel ( newGraphXScalingSForm, "newGraphXScalingSStartLabel", al, ac );
	XmStringFree(xmstrings[0]);

	sprintf(text, "%f", (double) XSSC_DEF);
	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingSStartText = XmCreateText ( newGraphXScalingSForm, "newGraphXScalingSStartText", al, ac );

	XmAddTabGroup(newGraphXScalingSStartText);
	XtAddCallback(newGraphXScalingSStartText, XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_XSSCS);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) XSC_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) XESC_DEF); ac++;
	XtSetArg(al[ac], XmNvalue, (int) XSSC_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingSStartScale = XmCreateScale ( newGraphXScalingSForm, "newGraphXScalingSStartScale", al, ac );

	XmAddTabGroup(newGraphXScalingSStartScale);
	XtAddCallback(newGraphXScalingSStartScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_XSSCS);
	XtAddCallback(newGraphXScalingSStartScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_XSSCS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingSStartDef = XmCreatePushButton ( newGraphXScalingSForm, "newGraphXScalingSStartDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXScalingSStartDef, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_XSSCS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(endXValueString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newGraphXScalingSEndLabel = XmCreateLabel ( newGraphXScalingSForm, "newGraphXScalingSEndLabel", al, ac );
	XmStringFree(xmstrings[0]);

	sprintf(text, "%f", (double) XESC_DEF);
	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingSEndText = XmCreateText ( newGraphXScalingSForm, "newGraphXScalingSEndText", al, ac );

	XmAddTabGroup(newGraphXScalingSEndText);
	XtAddCallback(newGraphXScalingSEndText, XmNvalueChangedCallback, dialog_text3_CB, (caddr_t *) DIALOG_TEXT_XESCS);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) XSC_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) XESC_DEF); ac++;
	XtSetArg(al[ac], XmNvalue, (int) XESC_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingSEndScale = XmCreateScale ( newGraphXScalingSForm, "newGraphXScalingSEndScale", al, ac );

	XmAddTabGroup(newGraphXScalingSEndScale);
	XtAddCallback(newGraphXScalingSEndScale, XmNvalueChangedCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_XESCS);
	XtAddCallback(newGraphXScalingSEndScale, XmNdragCallback, dialog_scale3_CB, (caddr_t *) DIALOG_SCALE_XESCS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingSEndDef = XmCreatePushButton ( newGraphXScalingSForm, "newGraphXScalingSStartDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXScalingSEndDef, XmNactivateCallback, dialog_def3_CB, (caddr_t *) DIALOG_XESCS);

	ac = 0;
	newGraphXScalingSSeparator2 = XmCreateSeparator ( newGraphXScalingSForm, "newGraphXScalingSSeparator2", al, ac);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingSOkButton = XmCreatePushButton ( newGraphXScalingSForm, "newGraphXScalingSOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXScalingSOkButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_XSCS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingSCancelButton = XmCreatePushButton ( newGraphXScalingSForm, "newGraphXScalingSCancelButton", al,
	    ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXScalingSCancelButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &newGraphXScalingSBB);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphXScalingSHelpButton = XmCreatePushButton ( newGraphXScalingSForm, "newGraphXScalingSHelpButton", al, ac);
	XmStringFree(xmstrings[0]);

	XtAddCallback(newGraphXScalingSHelpButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_XSCS);

	/* manage widgets */

	XtManageChild(newGraphXScalingSLabel);
	XtManageChild(newGraphXScalingSAllWindowsToggle);
	XtManageChild(newGraphXScalingSSeparator);
	XtManageChild(newGraphXScalingSStartLabel);
	XtManageChild(newGraphXScalingSStartText);
	XtManageChild(newGraphXScalingSStartScale);
	XtManageChild(newGraphXScalingSStartDef);
	XtManageChild(newGraphXScalingSEndLabel);
	XtManageChild(newGraphXScalingSEndText);
	XtManageChild(newGraphXScalingSEndScale);
	XtManageChild(newGraphXScalingSEndDef);
	XtManageChild(newGraphXScalingSSeparator2);
	XtManageChild(newGraphXScalingSOkButton);
	XtManageChild(newGraphXScalingSCancelButton);
	XtManageChild(newGraphXScalingSHelpButton);
	XtManageChild(newGraphXScalingSForm);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingSLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSAllWindowsToggle,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSStartLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSStartLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingSStartLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSStartText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSStartText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingSStartText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSStartScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSStartScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingSStartScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSStartDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSStartText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSEndLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSEndLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingSStartText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSEndText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSEndText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingSStartScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSEndScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSEndScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newGraphXScalingSEndScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSEndDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSEndText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSSeparator2,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphXScalingSOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
	XtSetValues ( newGraphXScalingSCancelButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphXScalingSSeparator2); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( newGraphXScalingSHelpButton,al, ac );

} /* end of create_newGraphXScalingS */
#endif

/************************************************************************************************************************

FUNCTION	: create_newGraphS( parent )

PURPOSE		: generates a new graph window with a menu bar and pull down menus for all selected synapses

RETURNS		: nothing

************************************************************************************************************************/

#ifndef BATCH
void create_newGraphS( parent )
Widget parent;	/* widget id of parent widget */
#else
void create_newGraphS()
#endif
{
#ifndef BATCH
	Widget 	newGraphS,
		newGraphSMenu,
		newGraphSDrawingArea,
		newGraphSFileMenu,
		newGraphSFileSubMenu,
		newGraphSCloseButton,
		newGraphSSaveButton,
		newGraphSFileSeparator,
		newGraphSFileBiosimButton,
		newGraphSOptionsMenu,
		newGraphSOptionsSubMenu,
		newGraphSOptionsScalingCascade,
		newGraphSOptionsScalingSubMenu,
		newGraphSOptionsScalingXButton,
		newGraphSOptionsScalingYButton,
		newGraphSOptionsZoomingCascade,
		newGraphSOptionsZoomingSubMenu,
		newGraphSOptionsZoomingXButton,
		newGraphSOptionsZoomingYButton,
		newGraphSOptionsGridCascade,
		newGraphSOptionsGridSubMenu,
		newGraphSOptionsGridSeparator,
		newGraphSOptionsOutputIntervalButton,
		newGraphSOptionsUpdateWindowButton,
		newGraphSParameterMenu,
		newGraphSParameterSubMenu,
		newGraphSHelpMenu,
		newGraphSHelpSubMenu,
		newGraphSHelpIndexButton,
		newGraphSHelpFeaturesButton,
		newGraphSHelpIntroButton,
		newGraphSHelpTargetButton,
		newGraphSHelpCellModelButton,
		newGraphSHelpContextButton,
		newGraphSHelpMouseButton,
		newGraphSHelpKeyboardButton,
		newGraphSHelpGlossaryButton,
		newGraphSHelpSeparator,
		newGraphSHelpBiosimButton;	/* widgets for internal use */

	Arg al[25];      		/* Arg List */
	register int ac; 		/* Arg Count */
	XrmDatabase applicationDB;	/* application data base */
	XrmValue value;			/* value returned by resource manager */
	Boolean resourceFileFound;	/* flag for resource file test */
	char *buffer;			/* buffer used to read in helptext file */
	char resourceFile[128];		/* name of resource file */
	char *str_type[20];		/* used to read resource file */
	char text[20];			/* string containing number */
	char title[80];			/* title of graph window */
	Dimension width, height;	/* width and height of graph */
	double temp;			/* temporary variable */
	XmString xmstrings[10]; 	/* temporary storage for XmStrings */
	Atom xa_wm_delete_window;	/* atom for resource deleteResponse */
#endif
	SelectionListSynapses *actptr;	/* help variables */
	unsigned int graphLength;	/* length of current graph */
	SGraph *graph;			/* graph structure */

	for (actptr = selectionListSynapsesHead; actptr != NULL; actptr = actptr->next)
	{
	/* check if a graph window of the selected neuron already exists */

	if (actptr->synapsePtr->graph) return; /* only one graph should exist, so return */

	/* create a new graph */

	graph = (SGraph *) malloc((size_t) sizeof(SGraph));
	if (! graph)
	{
		error(127);
		return;
	}

	/* allocate memory for traces */

	graphLength = (unsigned int) rint((LTSTOP * T_SCALE - XSSC_DEF + 2) / STEP / T_SCALE * sizeof(float));

	graph->pot = (float *) malloc((size_t) graphLength);

	if (! graph->pot)
	{
		error(127);
		return;
	}

	graph->mem = (float *) malloc((size_t) graphLength);

	if (! graph->mem)
	{
		error(127);
		return;
	}

	graph->str = (float *) malloc((size_t) graphLength);

	if (! graph->str)
	{
		error(127);
		return;
	}

	graph->con = (float *) malloc((size_t) graphLength);

	if (! graph->con)
	{
		error(127);
		return;
	}

	graph->graphSize = graphLength;

#ifndef BATCH
	/* create graph title and icon name for graph window */

	sprintf(text, "SW %d", actptr->synapsePtr->synapseID);
	sprintf(title, "%s%d%s%d%s%d%s%d%s", graphWindowSString, actptr->synapsePtr->synapseID, " (Neuron: ",
		actptr->synapsePtr->parentNeuron->neuronId, " -> ",
		actptr->synapsePtr->targetNeuron->neuronId, " Region: ",
		actptr->synapsePtr->targetArea, ")");

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, title); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	newGraphS = XmCreateDialogShell (parent, text, al, ac);

	xa_wm_delete_window = XmInternAtom(disp, "WM_DELETE_WINDOW", TRUE);
	XmAddWMProtocolCallback(newGraphS, xa_wm_delete_window, dialog_accept3_CB, (caddr_t *) DIALOG_CLOSE_GRAPHS);

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newGraphSForm = XmCreateForm ( newGraphS, "newGraphSForm", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmenuAccelerator, "<Key>F4"); ac++;
	newGraphSMenu = XmCreateMenuBar ( newGraphSForm, "newGraphSMenu", al, ac );

	ac = 0;
	newGraphSFileSubMenu = XmCreatePulldownMenu ( newGraphSMenu, "newGraphSFileSubMenu", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(closeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, closeMnemonic); ac++;
	newGraphSCloseButton = XmCreatePushButton ( newGraphSFileSubMenu, "newGraphSCloseButton", al, ac );
	XtAddCallback (newGraphSCloseButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_CLOSE_GRAPHS);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(saveString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, saveMnemonic); ac++;
	newGraphSSaveButton = XmCreatePushButton ( newGraphSFileSubMenu, "newGraphSSaveButton", al, ac );
	XtAddCallback (newGraphSSaveButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_SAVE_GRAPHS);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphSFileSeparator = XmCreateSeparator ( newGraphSFileSubMenu, "newGraphSFileSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(overBiosimString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, aboutBiosimMnemonic); ac++;
	newGraphSFileBiosimButton = XmCreatePushButton ( newGraphSFileSubMenu, "newGraphSFileBiosimButton", al, ac );
	XtAddCallback (newGraphSFileBiosimButton, XmNactivateCallback, manage_link_CB, (caddr_t *) &overBiosimDialog);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(fileString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, fileMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphSFileSubMenu); ac++;
	newGraphSFileMenu = XmCreateCascadeButton ( newGraphSMenu, "newGraphSFileMenu", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphSOptionsSubMenu = XmCreatePulldownMenu ( newGraphSMenu, "newGraphSOptionsSubMenu", al, ac );

	ac = 0;
	newGraphSOptionsScalingSubMenu = XmCreatePulldownMenu ( newGraphSOptionsSubMenu, "newGraphSOptionsScalingSubMenu",
	    al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(xAxesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, xAxesMnemonic); ac++;
	newGraphSOptionsScalingXButton = XmCreatePushButton ( newGraphSOptionsScalingSubMenu,
		"newGraphSOptionsScalingXButton", al, ac );
	XtAddCallback (newGraphSOptionsScalingXButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_X_AXE_S_INIT);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(yAxesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, yAxesMnemonic); ac++;
	newGraphSOptionsScalingYButton = XmCreatePushButton ( newGraphSOptionsScalingSubMenu,
		"newGraphSOptionsScalingYButton", al, ac );
	XtAddCallback (newGraphSOptionsScalingYButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_Y_AXE_S_INIT);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(scalingString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, scalingMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphSOptionsScalingSubMenu); ac++;
	newGraphSOptionsScalingCascade = XmCreateCascadeButton ( newGraphSOptionsSubMenu, "newGraphSOptionsScalingCascade",
	    al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphSOptionsZoomingSubMenu = XmCreatePulldownMenu ( newGraphSOptionsSubMenu, "newGraphSOptionsZoomingSubMenu",
	    al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(xAxesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, xAxesMnemonic); ac++;
	newGraphSOptionsZoomingXButton = XmCreatePushButton ( newGraphSOptionsZoomingSubMenu,
		"newGraphSOptionsZoomingXButton", al, ac );
	XtAddCallback (newGraphSOptionsZoomingXButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_X_ZOOM_S_INIT);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(yAxesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, yAxesMnemonic); ac++;
	newGraphSOptionsZoomingYButton = XmCreatePushButton ( newGraphSOptionsZoomingSubMenu,
		"newGraphSOptionsZoomingYButton", al, ac );
	XtAddCallback (newGraphSOptionsZoomingYButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_Y_ZOOM_S_INIT);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(zoomingString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, zoomingMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphSOptionsZoomingSubMenu); ac++;
	newGraphSOptionsZoomingCascade = XmCreateCascadeButton ( newGraphSOptionsSubMenu, "newGraphSOptionsZoomingCascade",
	    al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphSOptionsGridSubMenu = XmCreatePulldownMenu ( newGraphSOptionsSubMenu, "newGraphSOptionsGridSubMenu", al,
	    ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(xAxesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, xAxesMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphSOptionsGridXToggle = XmCreateToggleButtonGadget ( newGraphSOptionsGridSubMenu,
		"newGraphSOptionsGridXToggle", al, ac );
	XtAddCallback (newGraphSOptionsGridXToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_X_AXES);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(yAxesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, yAxesMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphSOptionsGridYToggle = XmCreateToggleButtonGadget ( newGraphSOptionsGridSubMenu,
		"newGraphSOptionsGridYToggle", al, ac );
	XtAddCallback (newGraphSOptionsGridYToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_Y_AXES);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphSOptionsGridSeparator = XmCreateSeparator ( newGraphSOptionsGridSubMenu, "newGraphSOptionsGridSeparator",
	    al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(dotsString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, dotsMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphSOptionsGridDotsToggle = XmCreateToggleButtonGadget ( newGraphSOptionsGridSubMenu,
		"newGraphSOptionsGridDotsToggle", al, ac );
	XtAddCallback (newGraphSOptionsGridDotsToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_DOTSS);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(linesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, linesMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	XtSetArg(al[ac], XmNset, TRUE); ac++;
	newGraphSOptionsGridLinesToggle = XmCreateToggleButtonGadget ( newGraphSOptionsGridSubMenu,
		"newGraphSOptionsGridLinesToggle", al, ac );
	XtAddCallback (newGraphSOptionsGridLinesToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_LINESS);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(gridString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, gridMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphSOptionsGridSubMenu); ac++;
	newGraphSOptionsGridCascade = XmCreateCascadeButton ( newGraphSOptionsSubMenu, "newGraphSOptionsGridCascade",
		al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(asciiDataOutputTitleString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, asciiOutputMnemonic); ac++;
	newGraphSOptionsOutputIntervalButton = XmCreatePushButton ( newGraphSOptionsSubMenu,
		"newGraphSOptionsOutputIntervalButton", al, ac );
	XtAddCallback (newGraphSOptionsOutputIntervalButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_ASCOUTS);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(refreshWindowString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, refreshWindowMnemonic); ac++;
	newGraphSOptionsUpdateWindowButton = XmCreatePushButton ( newGraphSOptionsSubMenu,
		"newGraphSOptionsUpdateWindowButton", al, ac );
	XtAddCallback (newGraphSOptionsUpdateWindowButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_REFRESH_WINDOWS);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(optionString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, optionsMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphSOptionsSubMenu); ac++;
	newGraphSOptionsMenu = XmCreateCascadeButton ( newGraphSMenu, "newGraphSOptionsMenu", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphSParameterSubMenu = XmCreatePulldownMenu ( newGraphSMenu, "XmMenu", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(synPotString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, synPotMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	XtSetArg(al[ac], XmNset, TRUE); ac++;
	newGraphSParameterPotToggle = XmCreateToggleButtonGadget ( newGraphSParameterSubMenu,
		"newGraphSParameterPotToggle", al, ac );
	XtAddCallback (newGraphSParameterPotToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_POTENTIAL);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(memString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, memMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphSParameterMemToggle = XmCreateToggleButtonGadget ( newGraphSParameterSubMenu,
		"newGraphSParameterMemToggle", al, ac );
	XtAddCallback (newGraphSParameterMemToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_MEMORY);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(condString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, condMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphSParameterConToggle = XmCreateToggleButtonGadget ( newGraphSParameterSubMenu,
		"newGraphSParameterConToggle", al, ac );
	XtAddCallback (newGraphSParameterConToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_CONDUCTANCE);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(strString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, strMnemonic); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newGraphSParameterStrToggle = XmCreateToggleButtonGadget ( newGraphSParameterSubMenu,
		"newGraphSParameterStrToggle", al, ac );
	XtAddCallback (newGraphSParameterStrToggle, XmNvalueChangedCallback, dialog_toggle3_CB, (caddr_t *) DIALOG_INHIBITION);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(parameterString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, parameterMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphSParameterSubMenu); ac++;
	newGraphSParameterMenu = XmCreateCascadeButton ( newGraphSMenu, "newGraphSParameterMenu", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphSHelpSubMenu = XmCreatePulldownMenu ( newGraphSMenu, "newGraphSHelpSubMenu", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(indexString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, indexMnemonic); ac++;
	newGraphSHelpIndexButton = XmCreatePushButton ( newGraphSHelpSubMenu, "newGraphSHelpIndexButton", al, ac );
	XtAddCallback (newGraphSHelpIndexButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_INDEX);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(featuresString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, featuresMnemonic); ac++;
	newGraphSHelpFeaturesButton = XmCreatePushButton ( newGraphSHelpSubMenu, "newGraphSHelpFeaturesButton", al, ac );
	XtAddCallback (newGraphSHelpFeaturesButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_FEATURES);
	XtManageChild(newGraphSHelpFeaturesButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(introString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, introMnemonic); ac++;
	newGraphSHelpIntroButton = XmCreatePushButton ( newGraphSHelpSubMenu, "newGraphSHelpIntroButton", al, ac );
	XtAddCallback (newGraphSHelpIntroButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_INTRO);
	XtManageChild(newGraphSHelpIntroButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(targetString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, targetMnemonic); ac++;
	newGraphSHelpTargetButton = XmCreatePushButton ( newGraphSHelpSubMenu, "newGraphSHelpTargetButton", al, ac );
	XtAddCallback (newGraphSHelpTargetButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_TARGET);
	XtManageChild(newGraphSHelpTargetButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(cellModelString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, cellModelMnemonic); ac++;
	newGraphSHelpCellModelButton = XmCreatePushButton ( newGraphSHelpSubMenu, "newGraphSHelpCellModelButton", al, ac );
	XtAddCallback (newGraphSHelpCellModelButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_CELLMODEL);
	XtManageChild(newGraphSHelpCellModelButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(contextString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, contextMnemonic); ac++;
	newGraphSHelpContextButton = XmCreatePushButton ( newGraphSHelpSubMenu, "newGraphSHelpContextButton", al, ac );
	XtAddCallback (newGraphSHelpContextButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_CONTEXT);
	XtManageChild(newGraphSHelpContextButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(mouseString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, mouseMnemonic); ac++;
	newGraphSHelpMouseButton = XmCreatePushButton ( newGraphSHelpSubMenu, "newGraphSHelpMouseButton", al, ac );
	XtAddCallback (newGraphSHelpMouseButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_MOUSE);
	XtManageChild(newGraphSHelpMouseButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(keyboardString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, keyboardMnemonic); ac++;
	newGraphSHelpKeyboardButton = XmCreatePushButton ( newGraphSHelpSubMenu, "newGraphSHelpKeyboardButton",al,ac);
	XtAddCallback (newGraphSHelpKeyboardButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_KEYBOARD);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(glossaryString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, glossaryMnemonic); ac++;
	newGraphSHelpGlossaryButton = XmCreatePushButton ( newGraphSHelpSubMenu, "newGraphSHelpGlossaryButton", al, ac );
	XtAddCallback (newGraphSHelpGlossaryButton, XmNactivateCallback, dialog_help3_CB, (caddr_t *) DIALOG_HELP_GLOSSAR);
	XtManageChild(newGraphSHelpGlossaryButton);
	XmStringFree(xmstrings[0]);

	ac = 0;
	newGraphSHelpSeparator = XmCreateSeparator ( newGraphSHelpSubMenu, "newGraphSHelpSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(overBiosimString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, aboutBiosimMnemonic); ac++;
	newGraphSHelpBiosimButton = XmCreatePushButton ( newGraphSHelpSubMenu, "newGraphSHelpBiosimButton", al, ac );
	XtAddCallback (newGraphSHelpBiosimButton, XmNactivateCallback, manage_link_CB, (caddr_t *) &overBiosimDialog);
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNmnemonic, helpMnemonic); ac++;
	XtSetArg(al[ac], XmNsubMenuId, newGraphSHelpSubMenu); ac++;
	newGraphSHelpMenu = XmCreateCascadeButton ( newGraphSMenu, "newGraphSHelpMenu", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNmenuHelpWidget, newGraphSHelpMenu); ac++;
	XtSetValues ( newGraphSMenu,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 0); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 0); ac++;
	newGraphSDrawingArea = XmCreateDrawingArea ( newGraphSForm, "newGraphSDrawingArea", al, ac );
	XtAddCallback (newGraphSDrawingArea, XmNexposeCallback, draw_graphS_CB, (caddr_t *) NULL);

	/* manage widgets */

	XtManageChild(newGraphSMenu);
	XtManageChild(newGraphSFileMenu);
	XtManageChild(newGraphSCloseButton);
	XtManageChild(newGraphSSaveButton);
	XtManageChild(newGraphSFileSeparator);
	XtManageChild(newGraphSFileBiosimButton);
	XtManageChild(newGraphSOptionsMenu);
	XtManageChild(newGraphSOptionsScalingCascade);
	XtManageChild(newGraphSOptionsScalingXButton);
	XtManageChild(newGraphSOptionsScalingYButton);
	XtManageChild(newGraphSOptionsZoomingCascade);
	XtManageChild(newGraphSOptionsZoomingXButton);
	XtManageChild(newGraphSOptionsZoomingYButton);
	XtManageChild(newGraphSOptionsGridCascade);
	XtManageChild(newGraphSOptionsGridXToggle);
	XtManageChild(newGraphSOptionsGridYToggle);
	XtManageChild(newGraphSOptionsGridSeparator);
	XtManageChild(newGraphSOptionsGridDotsToggle);
	XtManageChild(newGraphSOptionsGridLinesToggle);
	XtManageChild(newGraphSOptionsOutputIntervalButton);
	XtManageChild(newGraphSOptionsUpdateWindowButton);
	XtManageChild(newGraphSParameterMenu);
	XtManageChild(newGraphSParameterPotToggle);
	XtManageChild(newGraphSParameterMemToggle);
	XtManageChild(newGraphSParameterConToggle);
	XtManageChild(newGraphSParameterStrToggle);
	XtManageChild(newGraphSHelpMenu);
	XtManageChild(newGraphSHelpIndexButton);
	XtManageChild(newGraphSHelpFeaturesButton);
	XtManageChild(newGraphSHelpIntroButton);
	XtManageChild(newGraphSHelpTargetButton);
	XtManageChild(newGraphSHelpCellModelButton);
	XtManageChild(newGraphSHelpContextButton);
	XtManageChild(newGraphSHelpMouseButton);
	XtManageChild(newGraphSHelpKeyboardButton);
	XtManageChild(newGraphSHelpGlossaryButton);
	XtManageChild(newGraphSHelpSeparator);
	XtManageChild(newGraphSHelpBiosimButton);
	XtManageChild(newGraphSDrawingArea);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphSMenu,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newGraphSMenu); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( newGraphSDrawingArea,al, ac );

	/* make graph window visible */

	XtManageChild(newGraphSForm);

	/* get width and height of drawing area of graph */

	buffer = getenv("HOME");
	strcpy(resourceFile, buffer);
	strcat(resourceFile, "/Biosim");

	if (! (applicationDB = XrmGetFileDatabase(resourceFile)))
	{
		/* now try default application directory */

		strcpy(resourceFile, "/usr/lib/X11/app-defaults/Biosim");
		if (! (applicationDB = XrmGetFileDatabase(resourceFile)))
		{
			fprintf(stderr, "Warning: No resource file found ! Using default values.\n");
			width = 552;
			height = 220;
			resourceFileFound = FALSE;
		}
		else	resourceFileFound = TRUE;
	}
	else	resourceFileFound = TRUE;

	if (resourceFileFound)
	{
		if (XrmGetResource(applicationDB, "biosim.drawingAreaWidth", "Biosim.DrawingAreaWidth", str_type, &value))
		{
			strncpy(text, value.addr, (int) value.size);
			width = atoi(text);
		}
		else
		{
			fprintf(stderr, "Error: Resource drawingAreaWidth not found. Defaulting to 552\n");
			width = 552;
		}

		if (XrmGetResource(applicationDB, "biosim.drawingAreaHeight", "Biosim.DrawingAreaHeight", str_type, &value))
		{
			strncpy(text, value.addr, (int) value.size);
			height = atoi(text);
		}
		else
		{
			fprintf(stderr, "Error: Resource drawingAreaHeight not found. Defaulting to 220\n");
			height = 220;
		}
	}
#endif

	/* initialize graph data */

	currentGraphS = graph;
	currentSynapse = actptr->synapsePtr;
	graph->synapse = currentSynapse;
	currentSynapse->graph = graph;
#ifndef BATCH
	graph->drawingArea = newGraphSDrawingArea;
	graph->formWidget = newGraphSForm;
#endif

	graph->hasValues = FALSE;
	graph->tracePot = TRUE;
	graph->traceMem = FALSE;
	graph->traceStr = FALSE;
	graph->traceCon = FALSE;

	graph->lastX = (double) LTSTOP * T_SCALE;
#ifndef BATCH
	graph->width = (int) (width - mvSpace);
	graph->height = (int) (height - msSpace);
	graph->highestY = (double) YESC_DEF;
	graph->lowestY = (double) YSSC_DEF;
	graph->firstX = (double) XSSC_DEF;
	graph->xScale = (double) graph->width / (graph->lastX - graph->firstX);
	temp = graph->highestY - graph->lowestY;
	temp = fabs(temp);
	graph->yScale = (double) graph->height / temp;
	graph->yStep = graph->yScale;
	graph->axis = 0;
	graph->gridType = 2;
#endif
	graph->asciiDataOutputInterval = ASCOUT_DEF / T_SCALE;
#ifndef BATCH

	/* select input focus of graph window */

	XSelectInput(disp, XtWindow(newGraphS), VisibilityChangeMask | StructureNotifyMask);

	/* initialize graph values for x - and y - axis */

	set_x_axisS(graph);
	set_y_axisS(graph);

	/* draw the graph from scratch */

	draw_graphS(currentSynapse);
#endif

	/* increase total graph number */

	if (currentSynapse->axoSynapseNumber > 0)	/* axo-axonic synapse */
		graphNumberAS++;
	else	graphNumberS++;

	}
} /* end of create_newGraphS */

#ifndef BATCH
/************************************************************************************************************************

FUNCTION	: create_askDendrit(parent)

PURPOSE		: create a dialog box for asking the dendrit segment number for plotting

RETURNS		: nothing

************************************************************************************************************************/

void create_askDendrit( parent )
Widget parent;
{
	Widget children[4];	/* Children to manage */
	Arg al[64];		/* Arg List */
	register int ac = 0;	/* Arg Count */
	char text[20];		/* used for number conversion */
	XmString xmstrings[10];	/* temporary storage for XmStrings */
	Widget	askDendrit,
		askDendritForm,
		askDendritLabel,
		askDendritSeparator,
		askDendritButton;	/* used for internal use */

	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	XtSetArg(al[ac], XmNtitle, dendritString); ac++;
	askDendrit = XmCreateDialogShell ( parent, "askDendrit", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	askDendritBB = XmCreateBulletinBoard ( askDendrit, "askDendritBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	askDendritForm = XmCreateForm ( askDendritBB, "askDendritForm", al, ac );
	XmAddTabGroup(askDendritForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(dendritSegmentNumberString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	askDendritLabel = XmCreateLabel ( askDendritForm, "askDendritLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	sprintf(text, "%d", curNumOfDendSegs);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	askDendritText = XmCreateText ( askDendritForm, "askDendritText", al, ac );

	XmAddTabGroup ( askDendritText );

	ac = 0;
	askDendritSeparator = XmCreateSeparator ( askDendritForm, "askDendritSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNlabelString, XmStringCreateLtoR(okString, defaultFont)); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	askDendritButton = XmCreatePushButton ( askDendritForm, "askDendritButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback (askDendritButton, XmNactivateCallback, dialog_accept3_CB, (caddr_t *) DIALOG_DENDRIT_NUMBER);

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( askDendritLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, askDendritLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( askDendritText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, askDendritText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( askDendritSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, askDendritSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( askDendritButton,al, ac );

	ac = 0;
	children[ac++] = askDendritLabel;
	children[ac++] = askDendritText;
	children[ac++] = askDendritSeparator;
	children[ac++] = askDendritButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = askDendritForm;
	XtManageChildren(children, ac);

} /* end of create_askDendrit */

/************************************************************************************************************************

 	FUNCTION	: draw_graph_CB(w, client_data, call_data)
 
	PURPOSE		: callback for drawing the neuron graph

	RETURNS		: nothing

************************************************************************************************************************/

void draw_graph_CB(w, client_data, call_data)
Widget          w;              	/*  widget id           */
caddr_t         client_data;    	/*  data from application   */
XmDrawingAreaCallbackStruct *call_data; /*  data from widget class  */
{
	Neuron 		*neuron;		/* current neuron of the graph */

	/* check if manual update window flag is set, if so -> return */

	if (manualWindowUpdate)
		return;

	/* check if pending expose events exist */

	XSync(disp, FALSE);
	XmUpdateDisplay(w);	/* processes all pending exposure events immediately */
	XSync(disp, FALSE);

	if (call_data->event->xexpose.count != 0)
		return;		/* pending expose events exist, so return */

	/* determine neuron of graph window and update graph */

	neuron = get_neuron_from_graph_title(XtParent(XtParent(w)));
	draw_graph(neuron);

} /* end of draw_graph_CB */

/************************************************************************************************************************

 	FUNCTION	: determine_current_graph(w, client_data)
 
	PURPOSE		: function for determining the current neuron graph

	RETURNS		: nothing

************************************************************************************************************************/

void determine_current_graph(w, client_data)
Widget          w;              /*  widget id           */
int	        client_data;    /*  data from application   */
{
	Neuron *neuron;		/* current neuron */
	Widget graph;		/* current graph */

	/* evaluate client data */

	switch(client_data)
	{
	case DIALOG_ASCII:
	case DIALOG_REFRESH_WINDOW:
	case DIALOG_GATE_VARIABLES:

		/* get graph widget and than the current neuron and graph */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);
		currentGraph = neuron->graph;
		break;

	case DIALOG_XSC:
	case DIALOG_YSC:
	case DIALOG_XZO:
	case DIALOG_YZO:

		/* get graph widget and than the current neuron and graph */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(XtParent(w))))));
		neuron = get_neuron_from_graph_title(graph);
		currentGraph = neuron->graph;
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in DETERMINE_CURRENT_GRAPH occured !\n");
		break;
	}

} /* end of determine_current_graph */

/************************************************************************************************************************

 	FUNCTION	: get_neuron_from_graph_title(graph)
 
	PURPOSE		: gets the neuron from the graph title information

	RETURNS		: the neuron, which is referenced in the graph title

************************************************************************************************************************/

Neuron *get_neuron_from_graph_title(graph)
Widget graph;	/* current graph widget */
{
	Arg		args[10];		/* argument list for manipulating widgets */
	Cardinal	n;			/* used as argument counter for manipulating widgets */
	char 		*title, *text;		/* temporary pointers */
	int 		neuronNum;		/* neuron number */
	Neuron 		*neuron;		/* neuron */

	/* get title of graph */

	n = 0;
	XtSetArg(args[n], XmNtitle, &title); n++;
	XtGetValues(graph, args, n);

	/* search neuron number in title */

	for (text = title; isdigit((int) text[0]) == 0; text++);

	/* convert neuron number string into integer */

	neuronNum = atoi(text);

	/* search neuron with the neuron number extraced */

	for (neuron = neuronListHead; neuron->neuronId != neuronNum; neuron = neuron->next);

	/* return found neuron */

	return(neuron);

} /* end of get_neuron_from_graph_title */

/************************************************************************************************************************

 	FUNCTION	: save_graph_CB(w, client_data, call_data)
 
	PURPOSE		: callback for saving neuron graph data

	RETURNS		: nothing

************************************************************************************************************************/

void save_graph_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	XmFileSelectionBoxCallbackStruct *selection = (XmFileSelectionBoxCallbackStruct *) call_data;
	Widget	graphWidget = (Widget) client_data;	/* widget id from which the callback was called */
	Widget	graph;					/* widget id of the dialog shell of the graph */
	Neuron 	*neuron;				/* current neuron */
	char 	*filename = NULL; 			/* selected filename */
	char 	temp[128];				/* temporary variable */
	char 	*ptr;					/* pointer to look for the filename extension */

	/* get the neuron from the graph title of the graph window */

	graph = XtParent(XtParent(XtParent(XtParent(XtParent(graphWidget)))));
	neuron = get_neuron_from_graph_title(graph);

	/* get the filename from the selection value */

	XmStringGetLtoR(selection->value, defaultFont, &filename);
	strcpy(temp, filename);

	/* check filename extension if there, or add correct extension .asc to the filename */

	if (! strchr(temp, (int) '/')) /* contains the filename no subdirectory ? */
	{
		/* set default output directory for the filename */

		strcpy(temp, graphOutputDirectory);
		temp[strlen(temp) - 5] = '\0'; /* cut extension */
		strcat(temp, filename);
		if (! strchr(temp, (int) '.')) /* does no extension exist ? */
		{
			strcat(temp, ".asc");
		}
		else
		{
			ptr = strrchr(temp, (int) '.');
			if ((*(ptr + 1) != 'a') || (*(ptr + 2) != 's') || (*(ptr + 3) != 'c'))
			{
				error(77);
				XtManageChild(saveGraphDialog);
				return;
			}
		}
	}
	else
	{
		if (! strchr(temp, (int) '.')) /* does no extension exist ? */
		{
			strcat(temp, ".asc");
		}
		else
		{
			ptr = strrchr(temp, (int) '.');
			if ((*(ptr + 1) != 'a') || (*(ptr + 2) != 's') || (*(ptr + 3) != 'c'))
			{
				error(77);
				XtManageChild(saveGraphDialog);
				return;
			}
		}
	}

	/* save current neuron graph values to the file */

	save_graph(temp, neuron);

	XtUnmanageChild(saveGraphDialog);

} /* end of save_graph_CB */

/************************************************************************************************************************

 	FUNCTION	: draw_graphS_CB(w, client_data, call_data)
 
	PURPOSE		: callback for drawing the synapse graph

	RETURNS		: nothing

************************************************************************************************************************/

void draw_graphS_CB(w, client_data, call_data)
Widget          w;              	/*  widget id           */
caddr_t         client_data;    	/*  data from application   */
XmDrawingAreaCallbackStruct *call_data; /*  data from widget class  */
{
	Connection	*synapse;		/* current synapse of the graph */

	/* check if manual update window flag is set, if so -> return */

	if (manualWindowUpdate)
		return;

	/* check if pending expose events exist */

	XSync(disp, FALSE);
	XmUpdateDisplay(w);	/* processes all pending exposure events immediately */
	XSync(disp, FALSE);

	if (call_data->event->xexpose.count != 0)
		return;		/* pending expose events exist, so return */

	/* determine neuron of graph window and update graph */

	synapse = get_synapse_from_graph_title(XtParent(XtParent(w)));
	draw_graphS(synapse);

} /* end of draw_graphS_CB */

/************************************************************************************************************************

 	FUNCTION	: determine_current_graphS(w, client_data)
 
	PURPOSE		: function for determining the current synapse graph

	RETURNS		: nothing

************************************************************************************************************************/

void determine_current_graphS(w, client_data)
Widget          w;              /*  widget id           */
int	        client_data;    /*  data from application   */
{
	Connection *synapse;	/* current synapse */
	Widget graph;		/* current graph */

	/* evaluate client data */

	switch(client_data)
	{
	case DIALOG_ASCIIS:
	case DIALOG_REFRESH_WINDOWS:

		/* get graph widget and than the current neuron and graph */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		synapse = get_synapse_from_graph_title(graph);
		currentGraphS = synapse->graph;
		break;

	case DIALOG_XSCS:
	case DIALOG_YSCS:
	case DIALOG_XZOS:
	case DIALOG_YZOS:

		/* get graph widget and than the current neuron and graph */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(XtParent(w))))));
		synapse = get_synapse_from_graph_title(graph);
		currentGraphS = synapse->graph;
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in DETERMINE_CURRENT_GRAPHS occured !\n");
		break;
	}

} /* end of determine_current_graphS */

/************************************************************************************************************************

 	FUNCTION	: get_synapse_from_graph_title(graph)
 
	PURPOSE		: gets the synapse from the graph title information

	RETURNS		: the synapse, which is referenced in the graph title

************************************************************************************************************************/

Connection *get_synapse_from_graph_title(graph)
Widget graph;	/* current graph widget */
{
	Arg		args[10];		/* argument list for manipulating widgets */
	Cardinal	n;			/* used as argument counter for manipulating widgets */
	char 		*title, *text;		/* temporary pointers */
	int 		synapseNum;		/* synapse number */
	Neuron		*neuron;		/* neuron */
	Connection	*synapse;		/* synapse */

	/* get title of graph */

	n = 0;
	XtSetArg(args[n], XmNtitle, &title); n++;
	XtGetValues(graph, args, n);

	/* search synapse number in title */

	for (text = title; isdigit((int) text[0]) == 0; text++);

	/* convert synapse number string into integer */

	synapseNum = atoi(text);

	/* search synapse with the synapse number extraced */

	for (neuron = neuronListHead; neuron != NULL; neuron = neuron->next)
	{
		for (synapse = neuron->connectionList; ((synapse != NULL) && (synapse->synapseID != synapseNum));
		     synapse = synapse->nextConnection);

		if (synapse != NULL)
			break;
	}

	/* return found synapse */

	return(synapse);

} /* end of get_synapse_from_graph_title */

/************************************************************************************************************************

 	FUNCTION	: save_graphS_CB(w, client_data, call_data)
 
	PURPOSE		: callback for saving synapse graph data

	RETURNS		: nothing

************************************************************************************************************************/

void save_graphS_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	XmFileSelectionBoxCallbackStruct *selection = (XmFileSelectionBoxCallbackStruct *) call_data;
	Widget	graphWidget = (Widget) client_data;	/* widget id from which the callback was called */
	Widget	graph;					/* widget id of the dialog shell of the graph */
	Connection *synapse;				/* current synapse */
	char 	*filename = NULL; 			/* selected filename */
	char 	temp[128];				/* temporary variable */
	char 	*ptr;					/* pointer to look for the filename extension */

	/* get the synapse from the graph title of the graph window */

	graph = XtParent(XtParent(XtParent(XtParent(XtParent(graphWidget)))));
	synapse = get_synapse_from_graph_title(graph);

	/* get the filename from the selection value */

	XmStringGetLtoR(selection->value, defaultFont, &filename);
	strcpy(temp, filename);

	/* check filename extension if there, or add correct extension .asc to the filename */

	if (! strchr(temp, (int) '/')) /* contains the filename no subdirectory ? */
	{
		/* set default output directory for the filename */

		strcpy(temp, graphOutputDirectory);
		temp[strlen(temp) - 5] = '\0'; /* cut extension */
		strcat(temp, filename);
		if (! strchr(temp, (int) '.')) /* does no extension exist ? */
		{
			strcat(temp, ".asc");
		}
		else
		{
			ptr = strrchr(temp, (int) '.');
			if ((*(ptr + 1) != 'a') || (*(ptr + 2) != 's') || (*(ptr + 3) != 'c'))
			{
				error(77);
				XtManageChild(saveGraphSDialog);
				return;
			}
		}
	}
	else
	{
		if (! strchr(temp, (int) '.')) /* does no extension exist ? */
		{
			strcat(temp, ".asc");
		}
		else
		{
			ptr = strrchr(temp, (int) '.');
			if ((*(ptr + 1) != 'a') || (*(ptr + 2) != 's') || (*(ptr + 3) != 'c'))
			{
				error(77);
				XtManageChild(saveGraphSDialog);
				return;
			}
		}
	}

	/* save current synapse graph values to the file */

	save_graphS(temp, synapse);

	XtUnmanageChild(saveGraphSDialog);

} /* end of save_graphS_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_text3_CB(w, client_data, call_data)
 
	PURPOSE		: callback for text widgets

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_text3_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	Arg		args[20];		/* argument list for manipulating widgets */
	Cardinal	n;			/* used as argument counter for manipulating widgets */
	char		*value = NULL;		/* used for detection of valid number string */
	int		scaleValue;		/* value of scale widget */
	int		sF;			/* scaling factor */
	short int	decimals;		/* number of decimals for scale widget */
	double		number;			/* number read from text widget */

	/* check if number beginns with a valid sign */

	value = XmTextGetString(w);

	if ((strlen(value) == 0) ||
	    (strcmp(value,"+") == 0) ||
	    (strcmp(value,"-") == 0) ||
	    (strcmp(value,".") == 0) ||
	    (strcmp(value," +") == 0) ||
	    (strcmp(value," -") == 0) ||
	    (strcmp(value," .") == 0) ||
	    (strcmp(value,"+ ") == 0) ||
	    (strcmp(value,"- ") == 0) ||
	    (strcmp(value," + ") == 0) ||
	    (strcmp(value," - ") == 0))
	{
		free(value);
		return;
	}
	number = strtod(value, (char **) NULL);

	/* check number dependend on the widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_TEXT_ASCII:		/* output graph interval */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			ASCOUT = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(asciiOutputIntervalScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (ASCOUT_MAX * sF))
				scaleValue = (ASCOUT_MAX * sF);
			else if (scaleValue < (ASCOUT_MIN * sF))
				scaleValue = (ASCOUT_MIN * sF);

			XmScaleSetValue(asciiOutputIntervalScale, scaleValue);
		}
		free(value);
		break;

	case DIALOG_TEXT_XZO:		/* zoom x-axis */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			XZO = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(newGraphXZoomMagScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (XZO_MAX * sF))
				scaleValue = (XZO_MAX * sF);
			else if (scaleValue < (XZO_MIN * sF))
				scaleValue = (XZO_MIN * sF);

			XmScaleSetValue(newGraphXZoomMagScale, scaleValue);
		}
		free(value);
		break;

	case DIALOG_TEXT_YZO:		/* zoom y-axis */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			YZO = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(newGraphYZoomMagScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (YZO_MAX * sF))
				scaleValue = (YZO_MAX * sF);
			else if (scaleValue < (YZO_MIN * sF))
				scaleValue = (YZO_MIN * sF);

			XmScaleSetValue(newGraphYZoomMagScale, scaleValue);
		}
		free(value);
		break;

	case DIALOG_TEXT_XSSC:		/* start value of x-scaling */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			XSSC = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(newGraphXScalingStartScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (LTSTOP * T_SCALE * sF))
				scaleValue = (LTSTOP * T_SCALE * sF);
			else if (scaleValue < (XSC_MIN * sF))
				scaleValue = (XSC_MIN * sF);

			XmScaleSetValue(newGraphXScalingStartScale, scaleValue);
		}
		free(value);
		break;

	case DIALOG_TEXT_YSSC:		/* start value of y-scaling */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			YSSC = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(newGraphYScalingStartScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (YSC_MAX * sF))
				scaleValue = (YSC_MAX * sF);
			else if (scaleValue < (YSC_MIN * sF))
				scaleValue = (YSC_MIN * sF);

			XmScaleSetValue(newGraphYScalingStartScale, scaleValue);
		}
		free(value);
		break;

	case DIALOG_TEXT_XESC:		/* end value of x-scaling */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			XESC = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(newGraphXScalingEndScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (LTSTOP * T_SCALE * sF))
				scaleValue = (LTSTOP * T_SCALE * sF);
			else if (scaleValue < (XSC_MIN * sF))
				scaleValue = (XSC_MIN * sF);

			XmScaleSetValue(newGraphXScalingEndScale, scaleValue);
		}
		free(value);
		break;

	case DIALOG_TEXT_YESC:		/* end value of y-scaling */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			YESC = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(newGraphYScalingEndScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (YSC_MAX * sF))
				scaleValue = (YSC_MAX * sF);
			else if (scaleValue < (YSC_MIN * sF))
				scaleValue = (YSC_MIN * sF);

			XmScaleSetValue(newGraphYScalingEndScale, scaleValue);
		}
		free(value);
		break;

	case DIALOG_TEXT_ASCIIS:		/* output graph interval for synapses */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			ASCOUT = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(asciiOutputIntervalSScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (ASCOUT_MAX * sF))
				scaleValue = (ASCOUT_MAX * sF);
			else if (scaleValue < (ASCOUT_MIN * sF))
				scaleValue = (ASCOUT_MIN * sF);

			XmScaleSetValue(asciiOutputIntervalSScale, scaleValue);
		}
		free(value);
		break;

	case DIALOG_TEXT_XZOS:		/* zoom x-axis for synapses */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			XZO = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(newGraphXZoomSMagScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (XZO_MAX * sF))
				scaleValue = (XZO_MAX * sF);
			else if (scaleValue < (XZO_MIN * sF))
				scaleValue = (XZO_MIN * sF);

			XmScaleSetValue(newGraphXZoomSMagScale, scaleValue);
		}
		free(value);
		break;

	case DIALOG_TEXT_YZOS:		/* zoom y-axis for synapses */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			YZO = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(newGraphYZoomSMagScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (YZO_MAX * sF))
				scaleValue = (YZO_MAX * sF);
			else if (scaleValue < (YZO_MIN * sF))
				scaleValue = (YZO_MIN * sF);

			XmScaleSetValue(newGraphYZoomSMagScale, scaleValue);
		}
		free(value);
		break;

	case DIALOG_TEXT_XSSCS:		/* start value of x-scaling for synapses */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			XSSC = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(newGraphXScalingSStartScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (LTSTOP * T_SCALE * sF))
				scaleValue = (LTSTOP * T_SCALE * sF);
			else if (scaleValue < (XSC_MIN * sF))
				scaleValue = (XSC_MIN * sF);

			XmScaleSetValue(newGraphXScalingSStartScale, scaleValue);
		}
		free(value);
		break;

	case DIALOG_TEXT_YSSCS:		/* start value of y-scaling for synapses */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			YSSC = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(newGraphYScalingSStartScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (YSC_MAX * sF))
				scaleValue = (YSC_MAX * sF);
			else if (scaleValue < (YSC_MIN * sF))
				scaleValue = (YSC_MIN * sF);

			XmScaleSetValue(newGraphYScalingSStartScale, scaleValue);
		}
		free(value);
		break;

	case DIALOG_TEXT_XESCS:		/* end value of x-scaling for synapses */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			XESC = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(newGraphXScalingSEndScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (LTSTOP * T_SCALE * sF))
				scaleValue = (LTSTOP * T_SCALE * sF);
			else if (scaleValue < (XSC_MIN * sF))
				scaleValue = (XSC_MIN * sF);

			XmScaleSetValue(newGraphXScalingSEndScale, scaleValue);
		}
		free(value);
		break;

	case DIALOG_TEXT_YESCS:		/* end value of y-scaling for synapses */

		/* write out an error message if its not a number */

		if (! is_it_a_number(value))
			error(45);
		else 	/* get number of decimals, compute scaling factor and set scale value */
		{

			YESC = number;

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(newGraphYScalingSEndScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) number * sF;

			if (scaleValue > (YSC_MAX * sF))
				scaleValue = (YSC_MAX * sF);
			else if (scaleValue < (YSC_MIN * sF))
				scaleValue = (YSC_MIN * sF);

			XmScaleSetValue(newGraphYScalingSEndScale, scaleValue);
		}
		free(value);
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in TEXT3_DIALOG occured !\n");
		break;
	}

} /* end of dialog_text3_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_scale3_CB(w, client_data, call_data)
 
	PURPOSE		: callback for scale widgets

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_scale3_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	Arg		args[20];		/* argument list for manipulating widgets */
	Cardinal	n;			/* used as argument counter for manipulating widgets */
	int		value;			/* value of the scale widget */
	short int 	decimals;		/* number of decimals for scale widget */
	double		number;			/* number of scale value */
	char		text[20];		/* text representation of number */

	/* set text value dependend on the widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_SCALE_ASCII:	/* output graph interval */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(asciiOutputIntervalText, text);
		break;

	case DIALOG_SCALE_XZO:		/* zoom x-axis */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);
		XmTextSetString(newGraphXZoomMagText, text);

		break;

	case DIALOG_SCALE_YZO:		/* zoom y-axis */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(newGraphYZoomMagText, text);
		break;

	case DIALOG_SCALE_XSSC:		/* start value of x-scaling */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(newGraphXScalingStartText, text);
		break;

	case DIALOG_SCALE_YSSC:		/* start value of y-scaling */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(newGraphYScalingStartText, text);
		break;

	case DIALOG_SCALE_XESC:		/* end value of x-scaling */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(newGraphXScalingEndText, text);
		break;

	case DIALOG_SCALE_YESC:		/* end value of y-scaling */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(newGraphYScalingEndText, text);
		break;

	case DIALOG_SCALE_ASCIIS:	/* output graph interval for synapses */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(asciiOutputIntervalSText, text);
		break;

	case DIALOG_SCALE_XZOS:		/* zoom x-axis for synapses */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);
		XmTextSetString(newGraphXZoomSMagText, text);

		break;

	case DIALOG_SCALE_YZOS:		/* zoom y-axis for synapses */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(newGraphYZoomSMagText, text);
		break;

	case DIALOG_SCALE_XSSCS:	/* start value of x-scaling for synapses */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(newGraphXScalingSStartText, text);
		break;

	case DIALOG_SCALE_YSSCS:	/* start value of y-scaling for synapses */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(newGraphYScalingSStartText, text);
		break;

	case DIALOG_SCALE_XESCS:	/* end value of x-scaling for synapses */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(newGraphXScalingSEndText, text);
		break;

	case DIALOG_SCALE_YESCS:	/* end value of y-scaling for synapses */

		n = 0;
		XtSetArg(args[n], XmNvalue, &value); n++;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(w, args, n);

		number = (double) value / pow((double) 10, (double) decimals);
		sprintf(text,"%f", number);

		XmTextSetString(newGraphYScalingSEndText, text);
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in SCALE3_DIALOG occured !\n");
		break;
	}

} /* end of dialog_scale3_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_accept3_CB(w, client_data, call_data)
 
	PURPOSE		: callback for ok buttons

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_accept3_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	Arg		args[20];		/* argument list for manipulating widgets */
	Cardinal	n;			/* used as argument counter for manipulating widgets */
	char		*value = NULL;		/* number as string from textwidget */
	char		val[20];		/* number as string */
	char		tmp[10];		/* temporary string */
	short int	decimals;		/* number of decimals for scale widget */
	unsigned int	graphLength;		/* length of current graph */
	Dimension 	width, height;		/* dimension of the graph */
	Dimension 	oldwidth, oldheight;	/* old width and height of the drawingArea */
	Position 	x, y;			/* position of the graph */
	double		number;			/* number of scale value */
	double		temp, temp2, temp3,
			temp4;			/* temporary variables */
	Widget		graph;			/* current graph */
	Neuron 		*neuron;		/* current neuron */
	Connection	*synapse;		/* current synapse */
	XmString 	xmstrings[10]; 		/* temporary storage for XmStrings */

	/* check number dependend on the widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_X_AXE_INIT:		/* fill up mask with default values */

		value = XmTextGetString(newGraphXScalingEndText);
		number = strtod(value, (char **) NULL);

		if (number > LTSTOP * T_SCALE)
		{
			sprintf(value, "%f", LTSTOP * T_SCALE);
			XmTextSetString(newGraphXScalingEndText, value);
			XmScaleSetValue(newGraphXScalingEndScale, (int) (LTSTOP * T_SCALE));
		}

		free(value);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphXScalingEndScale, args, n);
		n = 0;
		XtSetArg(args[n], XmNmaximum, (int) (LTSTOP * T_SCALE * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphXScalingEndScale, args, n);

		value = XmTextGetString(newGraphXScalingStartText);
		number = strtod(value, (char **) NULL);

		if (number > LTSTOP * T_SCALE)
		{
			sprintf(value, "%f", LTSTOP * T_SCALE);
			XmTextSetString(newGraphXScalingStartText, value);
			XmScaleSetValue(newGraphXScalingStartScale, (int) (LTSTOP * T_SCALE));
		}

		free(value);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphXScalingStartScale, args, n);
		n = 0;
		XtSetArg(args[n], XmNmaximum, (int) (LTSTOP * T_SCALE * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphXScalingStartScale, args, n);

		/* determine current graph */

		determine_current_graph(w, DIALOG_XSC);

		XmToggleButtonGadgetSetState(newGraphXScalingAllWindowsToggle, FALSE, TRUE);
		XtManageChild(newGraphXScalingBB);

		break;

	case DIALOG_Y_AXE_INIT:		/* determine current graph and show mask values */

		/* determine current graph */

		determine_current_graph(w, DIALOG_YSC);

		XmToggleButtonGadgetSetState(newGraphYScalingAllWindowsToggle, FALSE, TRUE);
		XtManageChild(newGraphYScalingBB);

		break;

	case DIALOG_X_ZOOM_INIT:	/* determine current graph and show mask values */

		/* determine current graph */

		determine_current_graph(w, DIALOG_XZO);

		XmToggleButtonGadgetSetState(newGraphXZoomAllWindowsToggle, FALSE, TRUE);
		XtManageChild(newGraphXZoomBB);

		break;

	case DIALOG_Y_ZOOM_INIT:	/* determine current graph and show mask values */

		/* determine current graph */

		determine_current_graph(w, DIALOG_YZO);

		XmToggleButtonGadgetSetState(newGraphYZoomAllWindowsToggle, FALSE, TRUE);
		XtManageChild(newGraphYZoomBB);

		break;

	case DIALOG_X_AXE_S_INIT:	/* fill up mask with default values */

		value = XmTextGetString(newGraphXScalingSEndText);
		number = strtod(value, (char **) NULL);

		if (number > LTSTOP * T_SCALE)
		{
			sprintf(value, "%f", LTSTOP * T_SCALE);
			XmTextSetString(newGraphXScalingSEndText, value);
			XmScaleSetValue(newGraphXScalingSEndScale, (int) (LTSTOP * T_SCALE));
		}

		free(value);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphXScalingSEndScale, args, n);
		n = 0;
		XtSetArg(args[n], XmNmaximum, (int) (LTSTOP * T_SCALE * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphXScalingSEndScale, args, n);

		value = XmTextGetString(newGraphXScalingSStartText);
		number = strtod(value, (char **) NULL);

		if (number > LTSTOP * T_SCALE)
		{
			sprintf(value, "%f", LTSTOP * T_SCALE);
			XmTextSetString(newGraphXScalingSStartText, value);
			XmScaleSetValue(newGraphXScalingSStartScale, (int) (LTSTOP * T_SCALE));
		}

		free(value);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphXScalingSStartScale, args, n);
		n = 0;
		XtSetArg(args[n], XmNmaximum, (int) (LTSTOP * T_SCALE * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphXScalingSStartScale, args, n);

		/* determine current graph */

		determine_current_graphS(w, DIALOG_XSCS);

		XmToggleButtonGadgetSetState(newGraphXScalingSAllWindowsToggle, FALSE, TRUE);
		XtManageChild(newGraphXScalingSBB);

		break;

	case DIALOG_Y_AXE_S_INIT:	/* determine current graph and show mask values */

		/* determine current graph */

		determine_current_graphS(w, DIALOG_YSCS);

		XmToggleButtonGadgetSetState(newGraphYScalingSAllWindowsToggle, FALSE, TRUE);
		XtManageChild(newGraphYScalingSBB);

		break;

	case DIALOG_X_ZOOM_S_INIT:	/* determine current graph and show mask values */

		/* determine current graph */

		determine_current_graphS(w, DIALOG_XZOS);

		XmToggleButtonGadgetSetState(newGraphXZoomSAllWindowsToggle, FALSE, TRUE);
		XtManageChild(newGraphXZoomSBB);

		break;

	case DIALOG_Y_ZOOM_S_INIT:	/* determine current graph and show mask values */

		/* determine current graph */

		determine_current_graphS(w, DIALOG_YZOS);

		XmToggleButtonGadgetSetState(newGraphYZoomSAllWindowsToggle, FALSE, TRUE);
		XtManageChild(newGraphYZoomSBB);

		break;

	case DIALOG_DENDRIT_NUMBER:	/* check dendrit number for plotting */

		value = XmTextGetString(askDendritText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < TARGET_MIN) || (number > curNumOfDendSegs))
		{
			error(74);
			free(value);
			break;
		}
		else currentGraph->dendritSegment = atoi(value);

		free(value);
		XtUnmanageChild(askDendritBB);

		/* set label of dendrit toggle */

		n = 0;
		value = strchr(dendritParString, (int) '/');
		strncpy(val, dendritParString, strlen(dendritParString) - strlen(value));
		val[strlen(dendritParString) - strlen(value)] = '\0';
		val[strlen(val) - 1] = '\0';
		sprintf(tmp, "%d",currentGraph->dendritSegment);
		strcat(val, tmp);
		strcat(val, value);
		xmstrings[0] = XmStringCreateLtoR(val, defaultFont);
		XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
		XtSetArg(args[n], XmNlabelString, XmStringCreateLtoR(val, defaultFont)); n++;
		XtSetValues(currentGraph->dendritToggle, args, n);
		XmStringFree(xmstrings[0]);

		break;

	case DIALOG_REFRESH_WINDOW:	/* update graph window */

		/* determine current graph */

		determine_current_graph(w, DIALOG_REFRESH_WINDOW);

		/* resize window and draw the graph from scratch */

		/* get position and dimension of graph */

		n = 0;
		XtSetArg(args[n], XmNx, &x); n++;
		XtSetArg(args[n], XmNy, &y); n++;
		XtSetArg(args[n], XmNwidth, &oldwidth); n++;
		XtSetArg(args[n], XmNheight, &oldheight); n++;
		XtGetValues(currentGraph->drawingArea, args, n);
		n = 0;
		XtSetArg(args[n], XmNwidth, &width); n++;
		XtSetArg(args[n], XmNheight, &height); n++;
		XtGetValues(XtParent(currentGraph->formWidget), args, n);

		if (width >= 100 && height >= 100)
		{
			/* resize graph */

			XtResizeWidget(currentGraph->drawingArea, (Dimension) (width - x),
				(Dimension) (height - y), 0);

			/* set new graph values */

			currentGraph->width = (int) (width - x - mvSpace);
			currentGraph->height = (int) (height - y - msSpace);
			currentGraph->xScale = ((double) currentGraph->width /
				(currentGraph->lastX - currentGraph->firstX));
			temp = currentGraph->highestY - currentGraph->lowestY;
			temp = fabs(temp);
			currentGraph->yScale = (double) currentGraph->height / temp;

			/* initialize x- and y-axis of graph */

			set_x_axis(currentGraph);
			set_y_axis(currentGraph);

			/* draw the graph from scratch */

			draw_graph(currentGraph->neuron);
		}

		break;

	case DIALOG_ASCOUT:		/* show dialog box for input of graph output interval */

		number = currentGraph->asciiDataOutputInterval * T_SCALE;

		if ((number < ASCOUT_MIN) || (number > ASCOUT_MAX))
			number = (double) ASCOUT_DEF;

		sprintf(val, "%f", number);
		XmTextSetString(asciiOutputIntervalText, val);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(asciiOutputIntervalScale, args, n);

		number *= pow((double) 10, (double) decimals);
		n = 0;
		XtSetArg(args[n], XmNvalue, (int) number); n++;
		XtSetValues(asciiOutputIntervalScale, args, n);

		XtManageChild(asciiOutputIntervalBB);

		/* determine current graph */

		determine_current_graph(w, DIALOG_ASCII);

		break;

	case DIALOG_ASCII:		/* graph output interval */

		value = XmTextGetString(asciiOutputIntervalText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < ASCOUT_MIN) || (number > ASCOUT_MAX))
		{
			error(46);
			free(value);
			break;
		}
		else ASCOUT = number;
		free(value);

		currentGraph->asciiDataOutputInterval = (double) (ASCOUT / T_SCALE);
		XtUnmanageChild(asciiOutputIntervalBB);
		break;

	case DIALOG_XSC:		/* scaling x-axis */

		/* get start scaling of x-axis */

		value = XmTextGetString(newGraphXScalingStartText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < XSC_MIN) || (number > LTSTOP * T_SCALE))
		{
			error(47);
			free(value);
			break;
		}
		else XSSC = number;
		free(value);

		/* get end scaling of x-axis */

		value = XmTextGetString(newGraphXScalingEndText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < XSC_MIN) || (number > LTSTOP * T_SCALE))
		{
			error(48);
			free(value);
			break;
		}
		else XESC = number;
		free(value);

		if (! ((XESC - XSSC) >= 1))
			error(49);
		else if (! (XESC > XSSC))
			error(50);
		else if (! (XSSC >= 0))
			error(51);
		else if (! (XESC <= LTSTOP * T_SCALE))
			error(52);
		else
		{
			/* look if this value should be applied to all existing neuron graph windows */

			if (scaleAllWindows)
			{
				for (currentNeuron = neuronListHead; currentNeuron != NULL;
				     currentNeuron = currentNeuron->next)
				{
					/* look if graph for this neuron exist */

					currentGraph = currentNeuron->graph;
					if (currentGraph)
					{
						/* reallocate memory for graph traces */

						graphLength = (unsigned int) rint((XESC + 2) / STEP / T_SCALE
							* sizeof(float));

						realloc_graph(currentGraph, graphLength);

						/* set scale values for x-axis in graph */

						currentGraph->firstX = (double) XSSC;
						currentGraph->lastX = (double) XESC;

						/* set graph scaling for x-axis and redraw graph window */

						currentGraph->xScale = ((double) currentGraph->width / (XESC - XSSC));

						set_x_axis(currentGraph);
						draw_graph(currentGraph->neuron);
					}
				}
				XtUnmanageChild(newGraphXScalingBB);
			}
			else	/* update only for this window */
			{
				/* reallocate memory for graph traces */

				graphLength = (unsigned int) rint((XESC + 2) / STEP / T_SCALE * sizeof(float));

				realloc_graph(currentGraph, graphLength);

				/* set scale values for x-axis in graph */

				currentGraph->firstX = (double) XSSC;
				currentGraph->lastX = (double) XESC;

				/* set graph scaling for x-axis and redraw graph window */

				currentGraph->xScale = ((double) currentGraph->width / (XESC - XSSC));

				set_x_axis(currentGraph);
				draw_graph(currentGraph->neuron);

				XtUnmanageChild(newGraphXScalingBB);
			}
		}
		break;

	case DIALOG_YSC:		/* scaling y-axis */

		/* get start scaling of y-axis */

		value = XmTextGetString(newGraphYScalingStartText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < YSC_MIN) || (number > YSC_MAX))
		{
			error(53);
			free(value);
			break;
		}
		else YSSC = number;
		free(value);

		/* get end scaling of y-axis */

		value = XmTextGetString(newGraphYScalingEndText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < YSC_MIN) || (number > YSC_MAX))
		{
			error(54);
			free(value);
			break;
		}
		else YESC = number;
		free(value);

		if (! ((YESC - YSSC) >= 0.001))
			error(55);
		else if (! (YESC > YSSC))
			error(56);
		else if (! (YESC <= YSC_MAX))
			error(57);
		else if (! (YSSC >= YSC_MIN))
			error(58);
		else
		{
			/* look if this value should be applied to all existing neuron graph windows */

			if (scaleAllWindows)
			{
				for (currentNeuron = neuronListHead; currentNeuron != NULL; currentNeuron = currentNeuron->next)
				{
					/* look if graph for this neuron exist */

					currentGraph = currentNeuron->graph;
					if (currentGraph)
					{
						/* set scale values for y-axis in graph */

						currentGraph->lowestY = (double) YSSC;
						currentGraph->highestY = (double) YESC;
						temp = YESC - YSSC;
						temp = fabs(temp);
						currentGraph->yScale = (double) currentGraph->height / temp;

						/* set graph scaling for y-axis and redraw graph window */

						set_y_axis(currentGraph);
						draw_graph(currentGraph->neuron);

						XtUnmanageChild(newGraphYScalingBB);
					}
				}
				XtUnmanageChild(newGraphYScalingBB);
			}
			else	/* update only for this window */
			{
				/* set scale values for y-axis in graph */

				currentGraph->lowestY = (double) YSSC;
				currentGraph->highestY = (double) YESC;
				temp = YESC - YSSC;
				temp = fabs(temp);
				currentGraph->yScale = (double) currentGraph->height / temp;

				/* set graph scaling for y-axis and redraw graph window */

				set_y_axis(currentGraph);
				draw_graph(currentGraph->neuron);

				XtUnmanageChild(newGraphYScalingBB);
			}
		}
		break;

	case DIALOG_XZO:		/* zoom x-axis */

		/* get zoom factor of x-axis */

		value = XmTextGetString(newGraphXZoomMagText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < XZO_MIN) || (number > XZO_MAX))
		{
			error(59);
			free(value);
			break;
		}
		else XZO = number;
		free(value);

		/* look if this value should be applied to all existing neuron graph windows */

		if (zoomAllWindows)
		{
			for (currentNeuron = neuronListHead; currentNeuron != NULL; currentNeuron = currentNeuron->next)
			{
				/* look if graph for this neuron exist */

				currentGraph = currentNeuron->graph;
				if (currentGraph)
				{
					temp = fabs(currentGraph->lastX - currentGraph->firstX);
					temp2 = temp / (double) XZO;
					temp3 = currentGraph->firstX + 0.5 * (temp - temp2);
					temp4 = currentGraph->lastX + 0.5 * (temp2 - temp);

					/* reallocate memory for graph traces */

					graphLength = (unsigned int) rint((temp4 + 2) / STEP / T_SCALE
						* sizeof(float));

					realloc_graph(currentGraph, graphLength);

					/* set zoom value in graph -> calculate x-scaling */

					currentGraph->firstX = temp3;
					currentGraph->lastX = temp4;
					currentGraph->xScale = ((double) currentGraph->width / (temp4 - temp3));

					/* set x-axis and redraw graph window */

					set_x_axis(currentGraph);
					draw_graph(currentGraph->neuron);
				}
			}
			XtUnmanageChild(newGraphXZoomBB);
		}
		else	/* update only for this window */
		{
			temp = fabs(currentGraph->lastX - currentGraph->firstX);
			temp2 = temp / (double) XZO;
			temp3 = currentGraph->firstX + 0.5 * (temp - temp2);
			temp4 = currentGraph->lastX + 0.5 * (temp2 - temp);

			/* reallocate memory for graph traces */

			graphLength = (unsigned int) rint((temp4 + 2) / STEP / T_SCALE * sizeof(float));

			realloc_graph(currentGraph, graphLength);

			/* set zoom value in graph -> calculate x-scaling */

			currentGraph->firstX = temp3;
			currentGraph->lastX = temp4;
			currentGraph->xScale = ((double) currentGraph->width / (temp4 - temp3));

			/* set x-axis and redraw graph window */

			set_x_axis(currentGraph);
			draw_graph(currentGraph->neuron);

			XtUnmanageChild(newGraphXZoomBB);
		}
		break;

	case DIALOG_YZO:		/* zoom y-axis */

		/* get zoom factor of y-axis */

		value = XmTextGetString(newGraphYZoomMagText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < YZO_MIN) || (number > YZO_MAX))
		{
			error(60);
			free(value);
			break;
		}
		else YZO = number;
		free(value);

		/* look if this value should be applied to all existing neuron graph windows */

		if (zoomAllWindows)
		{
			for (currentNeuron = neuronListHead; currentNeuron != NULL; currentNeuron = currentNeuron->next)
			{
				/* look if graph for this neuron exist */

				currentGraph = currentNeuron->graph;
				if (currentGraph)
				{
					/* set zoom value in graph -> calculate y-scaling */

					temp = fabs(currentGraph->highestY - currentGraph->lowestY);
					temp2 = temp / (double) YZO;
					currentGraph->lowestY += temp / 2.0 - (temp2 / 2.0);
					currentGraph->highestY -= temp / 2.0 - (temp2 / 2.0);
					temp = currentGraph->highestY - currentGraph->lowestY;
					temp = fabs(temp);
					currentGraph->yScale = (double) currentGraph->height / temp;

					/* set y-axis and redraw graph window */

					set_y_axis(currentGraph);
					draw_graph(currentGraph->neuron);
				}
			}
			XtUnmanageChild(newGraphYZoomBB);
		}
		else	/* update only for this window */
		{
			/* set zoom value in graph -> calculate y-scaling */

			temp = fabs(currentGraph->highestY - currentGraph->lowestY);
			temp2 = temp / (double) YZO;
			currentGraph->lowestY += temp / 2.0 - (temp2 / 2.0);
			currentGraph->highestY -= temp / 2.0 - (temp2 / 2.0);
			temp = currentGraph->highestY - currentGraph->lowestY;
			temp = fabs(temp);
			currentGraph->yScale = (double) currentGraph->height / temp;

			/* set y-axis and redraw graph window */

			set_y_axis(currentGraph);
			draw_graph(currentGraph->neuron);

			XtUnmanageChild(newGraphYZoomBB);
		}
		break;

	case DIALOG_CLOSE_GRAPH:		/* close graph window */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		/* unrealize and destroy graph form widget */

		XtUnrealizeWidget(XtParent(neuron->graph->formWidget));
		XtDestroyWidget(XtParent(neuron->graph->formWidget));

		/* free graph memory */

		free(neuron->graph->soma);
		free(neuron->graph->dend);
		free(neuron->graph->synC);
		free(neuron->graph->totC);
		free(neuron->graph->iNA);
		free(neuron->graph->iK);
		free(neuron->graph->iCA);
		free(neuron->graph->iCA1);
		free(neuron->graph->iCA2);
		free(neuron->graph->iKCA);
		free(neuron->graph->iA);
		free(neuron->graph->iIR);

		free(neuron->graph);
		neuron->graph = NULL;

		/* correct number of graphs in net */

		graphNumber--;
		break;

	case DIALOG_SAVE_GRAPH:			/* save graph */

		xmstrings[0] = XmStringCreateLtoR(saveGraphString, defaultFont);
		xmstrings[1] = XmStringCreateLtoR(filesString, defaultFont);
		xmstrings[2] = XmStringCreateLtoR(filterString, defaultFont);
		xmstrings[3] = XmStringCreateLtoR(selectionString, defaultFont);
		xmstrings[4] = XmStringCreateLtoR(graphOutputDirectory, defaultFont);
		xmstrings[5] = XmStringCreateLtoR(okString, defaultFont);
		xmstrings[6] = XmStringCreateLtoR(noString, defaultFont);
		xmstrings[7] = XmStringCreateLtoR(helpString, defaultFont);

		n = 0;
		XtSetArg(args[n], XmNdialogTitle, xmstrings[0]); n++;
		XtSetArg(args[n], XmNlistLabelString, xmstrings[1]); n++;
		XtSetArg(args[n], XmNfilterLabelString, xmstrings[2]); n++;
		XtSetArg(args[n], XmNselectionLabelString, xmstrings[3]); n++;
		XtSetArg(args[n], XmNdirMask, xmstrings[4]); n++;
		XtSetArg(args[n], XmNlistVisibleItemCount, 10); n++;
		XtSetArg(args[n], XmNokLabelString, xmstrings[5]); n++;
		XtSetArg(args[n], XmNcancelLabelString, xmstrings[6]); n++;
		XtSetArg(args[n], XmNhelpLabelString, xmstrings[7]); n++;
		saveGraphDialog = XmCreateFileSelectionDialog(XtParent(w), "save graph selection dialog", args, n);
		XtAddCallback(saveGraphDialog, XmNokCallback, save_graph_CB, (caddr_t *) w);
		XtAddCallback(saveGraphDialog, XmNcancelCallback, unmanage_link_CB, (caddr_t *) &saveGraphDialog);
		XtAddCallback(saveGraphDialog, XmNhelpCallback, dialog_help3_CB, (caddr_t *) DIALOG_SAVE_GRAPH);

		XmStringFree(xmstrings[0]);
		XmStringFree(xmstrings[1]);
		XmStringFree(xmstrings[2]);
		XmStringFree(xmstrings[3]);
		XmStringFree(xmstrings[4]);
		XmStringFree(xmstrings[5]);
		XmStringFree(xmstrings[6]);
		XmStringFree(xmstrings[7]);

		XtManageChild(saveGraphDialog);
		break;

	case DIALOG_REFRESH_WINDOWS:	/* update graph window for synapses */

		/* determine current graph */

		determine_current_graphS(w, DIALOG_REFRESH_WINDOWS);

		/* get position and dimension of graph */

		n = 0;
		XtSetArg(args[n], XmNx, &x); n++;
		XtSetArg(args[n], XmNy, &y); n++;
		XtSetArg(args[n], XmNwidth, &oldwidth); n++;
		XtSetArg(args[n], XmNheight, &oldheight); n++;
		XtGetValues(currentGraphS->drawingArea, args, n);
		n = 0;
		XtSetArg(args[n], XmNwidth, &width); n++;
		XtSetArg(args[n], XmNheight, &height); n++;
		XtGetValues(currentGraphS->formWidget, args, n);

		if (width >= 100 && height >= 100)
		{
			/* resize graph */

			XtResizeWidget(currentGraphS->drawingArea, (Dimension) (width -  x),
				(Dimension) (height -  y), 0);

			/* set new graph values */

			currentGraphS->width = (int) (width - x - mvSpace);
			currentGraphS->height = (int) (height - y - msSpace);
			currentGraphS->xScale = ((double) currentGraphS->width /
				(currentGraphS->lastX - currentGraphS->firstX));
			temp = currentGraphS->highestY - currentGraphS->lowestY;
			temp = fabs(temp);
			currentGraphS->yScale = (double) currentGraphS->height / temp;

			/* initialize x- and y-axis of graph */

			set_x_axisS(currentGraphS);
			set_y_axisS(currentGraphS);

			/* draw the graph from scratch */

			draw_graphS(currentGraphS->synapse);
		}

		break;

	case DIALOG_ASCOUTS:		/* show dialog box for input of graph output interval for synapses */

		number = currentGraphS->asciiDataOutputInterval * T_SCALE;

		if ((number < ASCOUT_MIN) || (number > ASCOUT_MAX))
			number = (double) ASCOUT_DEF;

		sprintf(val, "%f", number);
		XmTextSetString(asciiOutputIntervalSText, val);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(asciiOutputIntervalSScale, args, n);

		number *= pow((double) 10, (double) decimals);
		n = 0;
		XtSetArg(args[n], XmNvalue, (int) number); n++;
		XtSetValues(asciiOutputIntervalSScale, args, n);

		XtManageChild(asciiOutputIntervalSBB);

		/* determine current graph */

		determine_current_graphS(w, DIALOG_ASCIIS);

		break;

	case DIALOG_ASCIIS:		/* graph output interval for synapses */

		value = XmTextGetString(asciiOutputIntervalSText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < ASCOUT_MIN) || (number > ASCOUT_MAX))
		{
			error(46);
			free(value);
			break;
		}
		else ASCOUT = number;
		free(value);

		currentGraphS->asciiDataOutputInterval = (double) (ASCOUT / T_SCALE);
		XtUnmanageChild(asciiOutputIntervalSBB);
		break;

	case DIALOG_XSCS:		/* scaling x-axis for synapses */

		/* get start scaling of x-axis */

		value = XmTextGetString(newGraphXScalingSStartText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < XSC_MIN) || (number > LTSTOP * T_SCALE))
		{
			error(47);
			free(value);
			break;
		}
		else XSSC = number;
		free(value);

		/* get end scaling of x-axis */

		value = XmTextGetString(newGraphXScalingSEndText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < XSC_MIN) || (number > LTSTOP * T_SCALE))
		{
			error(48);
			free(value);
			break;
		}
		else XESC = number;
		free(value);

		if (! ((XESC - XSSC) >= 1))
			error(49);
		else if (! (XESC > XSSC))
			error(50);
		else if (! (XSSC >= 0))
			error(51);
		else if (! (XESC <= LTSTOP * T_SCALE))
			error(52);
		else
		{
			/* look if this value should be applied to all existing synapse graph windows */

			if (scaleAllSWindows)
			{
				for (currentNeuron = neuronListHead; currentNeuron != NULL;
				     currentNeuron = currentNeuron->next)
					for (currentSynapse = currentNeuron->connectionList; currentSynapse != NULL;
					     currentSynapse = currentSynapse->nextConnection)
					{
						/* look if graph for this neuron exist */

						currentGraphS = currentSynapse->graph;
						if (currentGraphS)
						{
							/* reallocate memory for graph traces */

							graphLength = (unsigned int) rint((XESC + 2) / STEP
								/ T_SCALE * sizeof(float));

							realloc_graphS(currentGraphS, graphLength);

							/* set scale values for x-axis in graph */

							currentGraphS->firstX = (double) XSSC;
							currentGraphS->lastX = (double) XESC;

							/* set graph scaling for x-axis and redraw graph window */

							currentGraphS->xScale = ((double) currentGraphS->width
								/ (XESC - XSSC));

							set_x_axisS(currentGraphS);
							draw_graphS(currentGraphS->synapse);
						}
					}
				XtUnmanageChild(newGraphXScalingSBB);
			}
			else	/* update only for this window */
			{
				/* reallocate memory for graph traces */

				graphLength = (unsigned int) rint((XESC + 2) / STEP / T_SCALE * sizeof(float));

				realloc_graphS(currentGraphS, graphLength);

				/* set scale values for x-axis in graph */

				currentGraphS->firstX = (double) XSSC;
				currentGraphS->lastX = (double) XESC;

				/* set graph scaling for x-axis and redraw graph window */

				currentGraphS->xScale = ((double) currentGraphS->width / (XESC - XSSC));

				set_x_axisS(currentGraphS);
				draw_graphS(currentGraphS->synapse);

				XtUnmanageChild(newGraphXScalingSBB);
			}
		}
		break;

	case DIALOG_YSCS:		/* scaling y-axis for synapses */

		/* get start scaling of y-axis */

		value = XmTextGetString(newGraphYScalingSStartText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < YSC_MIN) || (number > YSC_MAX))
		{
			error(53);
			free(value);
			break;
		}
		else YSSC = number;
		free(value);

		/* get end scaling of y-axis */

		value = XmTextGetString(newGraphYScalingSEndText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < YSC_MIN) || (number > YSC_MAX))
		{
			error(54);
			free(value);
			break;
		}
		else YESC = number;
		free(value);

		if (! ((YESC - YSSC) >= 0.001))
			error(55);
		else if (! (YESC > YSSC))
			error(56);
		else if (! (YESC <= YSC_MAX))
			error(57);
		else if (! (YSSC >= YSC_MIN))
			error(58);
		else
		{
			/* look if this value should be applied to all existing synapse graph windows */

			if (scaleAllSWindows)
			{
				for (currentNeuron = neuronListHead; currentNeuron != NULL;
				     currentNeuron = currentNeuron->next)
					for (currentSynapse = currentNeuron->connectionList; currentSynapse != NULL;
					     currentSynapse = currentSynapse->nextConnection)
					{
						/* look if graph for this neuron exist */

						currentGraphS = currentSynapse->graph;
						if (currentGraphS)
						{
							/* set scale values for y-axis in graph */

							currentGraphS->lowestY = (double) YSSC;
							currentGraphS->highestY = (double) YESC;
							temp = currentGraphS->highestY - currentGraphS->lowestY;
							temp = fabs(temp);
							currentGraphS->yScale = (double) currentGraphS->height / temp;

							/* set graph scaling for y-axis and redraw graph window */

							set_y_axisS(currentGraphS);
							draw_graphS(currentGraphS->synapse);
						}
					}
				XtUnmanageChild(newGraphYScalingSBB);
			}
			else	/* update only for this window */
			{
				/* set scale values for y-axis in graph */

				currentGraphS->lowestY = (double) YSSC;
				currentGraphS->highestY = (double) YESC;
				temp = currentGraphS->highestY - currentGraphS->lowestY;
				temp = fabs(temp);
				currentGraphS->yScale = (double) currentGraphS->height / temp;

				/* set graph scaling for y-axis and redraw graph window */

				set_y_axisS(currentGraphS);
				draw_graphS(currentGraphS->synapse);

				XtUnmanageChild(newGraphYScalingSBB);
			}
		}
		break;

	case DIALOG_XZOS:		/* zoom x-axis for synapses */

		/* get zoom factor of x-axis */

		value = XmTextGetString(newGraphXZoomSMagText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < XZO_MIN) || (number > XZO_MAX))
		{
			error(59);
			free(value);
			break;
		}
		else XZO = number;
		free(value);

		/* look if this value should be applied to all existing synapse graph windows */

		if (zoomAllSWindows)
		{
			for (currentNeuron = neuronListHead; currentNeuron != NULL;
			     currentNeuron = currentNeuron->next)
				for (currentSynapse = currentNeuron->connectionList; currentSynapse != NULL;
				     currentSynapse = currentSynapse->nextConnection)
				{
					/* look if graph for this neuron exist */

					currentGraphS = currentSynapse->graph;
					if (currentGraphS)
					{
						temp = fabs(currentGraphS->lastX - currentGraphS->firstX);
						temp2 = temp / (double) XZO;
						temp3 = currentGraph->firstX + 0.5 * (temp - temp2);
						temp4 = currentGraph->lastX + 0.5 * (temp2 - temp);

						/* reallocate memory for graph traces */

						graphLength = (unsigned int) rint((temp4 + 2) / STEP / T_SCALE
							* sizeof(float));

						realloc_graphS(currentGraphS, graphLength);

						/* set zoom value in graph -> calculate x-scaling */

						currentGraphS->xScale = ((double) currentGraphS->width
							/ (temp4 - temp3));

						/* set x-axis and redraw graph window */

						set_x_axisS(currentGraphS);
						draw_graphS(currentGraphS->synapse);
					}
				}
			XtUnmanageChild(newGraphXZoomSBB);
		}
		else	/* update only for this window */
		{
			temp = fabs(currentGraphS->lastX - currentGraphS->firstX);
			temp2 = temp / (double) XZO;
			temp3 = currentGraph->firstX + 0.5 * (temp - temp2);
			temp4 = currentGraph->lastX + 0.5 * (temp2 - temp);

			/* reallocate memory for graph traces */

			graphLength = (unsigned int) rint((temp4 + 2) / STEP / T_SCALE * sizeof(float));

			realloc_graphS(currentGraphS, graphLength);

			/* set zoom value in graph -> calculate x-scaling */

			currentGraphS->xScale = ((double) currentGraphS->width / (temp4 - temp3));

			/* set x-axis and redraw graph window */

			set_x_axisS(currentGraphS);
			draw_graphS(currentGraphS->synapse);

			XtUnmanageChild(newGraphXZoomSBB);
		}
		break;

	case DIALOG_YZOS:		/* zoom y-axis for synapses */

		/* get zoom factor of y-axis */

		value = XmTextGetString(newGraphYZoomSMagText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < YZO_MIN) || (number > YZO_MAX))
		{
			error(60);
			free(value);
			break;
		}
		else YZO = number;
		free(value);

		/* look if this value should be applied to all existing synapse graph windows */

		if (zoomAllSWindows)
		{
			for (currentNeuron = neuronListHead; currentNeuron != NULL;
			     currentNeuron = currentNeuron->next)
				for (currentSynapse = currentNeuron->connectionList; currentSynapse != NULL;
				     currentSynapse = currentSynapse->nextConnection)
				{
					/* look if graph for this neuron exist */

					currentGraphS = currentSynapse->graph;
					if (currentGraphS)
					{
						/* set zoom value in graph -> calculate y-scaling */

						temp = fabs(currentGraphS->highestY - currentGraphS->lowestY);
						temp2 = temp / (double) YZO;
						currentGraphS->lowestY += temp / 2.0 - (temp2 / 2.0);
						currentGraphS->highestY -= temp / 2.0 - (temp2 / 2.0);
						temp = currentGraphS->highestY - currentGraphS->lowestY;
						temp = fabs(temp);
						currentGraphS->yScale = (double) currentGraphS->height / temp;

						/* set y-axis and redraw graph window */

						set_y_axisS(currentGraphS);
						draw_graphS(currentGraphS->synapse);
					}
				}
			XtUnmanageChild(newGraphYZoomSBB);
		}
		else	/* update only for this window */
		{
			/* set zoom value in graph -> calculate y-scaling */

			temp = fabs(currentGraphS->highestY - currentGraphS->lowestY);
			temp2 = temp / (double) YZO;
			currentGraphS->lowestY += temp / 2.0 - (temp2 / 2.0);
			currentGraphS->highestY -= temp / 2.0 - (temp2 / 2.0);
			temp = currentGraphS->highestY - currentGraphS->lowestY;
			temp = fabs(temp);
			currentGraphS->yScale = (double) currentGraphS->height / temp;

			/* set y-axis and redraw graph window */

			set_y_axisS(currentGraphS);
			draw_graphS(currentGraphS->synapse);

			XtUnmanageChild(newGraphYZoomSBB);
		}
		break;

	case DIALOG_CLOSE_GRAPHS:		/* close graph window for synapses */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		synapse = get_synapse_from_graph_title(graph);

		/* correct number of graphs in net */

		if (synapse->axoSynapseNumber > 0)	/* axo-axonic synapse */
			graphNumberAS--;
		else	graphNumberS--;

		/* unrealize and destroy graph form widget */

		XtUnrealizeWidget(XtParent(synapse->graph->formWidget));
		XtDestroyWidget(XtParent(synapse->graph->formWidget));

		/* free graph memory */

		free(synapse->graph->pot);
		free(synapse->graph->mem);
		free(synapse->graph->str);
		free(synapse->graph->con);

		free(synapse->graph);
		synapse->graph = NULL;

		break;

	case DIALOG_SAVE_GRAPHS:		/* save graph for synapses */

		xmstrings[0] = XmStringCreateLtoR(saveGraphString, defaultFont);
		xmstrings[1] = XmStringCreateLtoR(filesString, defaultFont);
		xmstrings[2] = XmStringCreateLtoR(filterString, defaultFont);
		xmstrings[3] = XmStringCreateLtoR(selectionString, defaultFont);
		xmstrings[4] = XmStringCreateLtoR(graphOutputDirectory, defaultFont);
		xmstrings[5] = XmStringCreateLtoR(okString, defaultFont);
		xmstrings[6] = XmStringCreateLtoR(noString, defaultFont);
		xmstrings[7] = XmStringCreateLtoR(helpString, defaultFont);

		n = 0;
		XtSetArg(args[n], XmNdialogTitle, xmstrings[0]); n++;
		XtSetArg(args[n], XmNlistLabelString, xmstrings[1]); n++;
		XtSetArg(args[n], XmNfilterLabelString, xmstrings[2]); n++;
		XtSetArg(args[n], XmNselectionLabelString, xmstrings[3]); n++;
		XtSetArg(args[n], XmNdirMask, xmstrings[4]); n++;
		XtSetArg(args[n], XmNlistVisibleItemCount, 10); n++;
		XtSetArg(args[n], XmNokLabelString, xmstrings[5]); n++;
		XtSetArg(args[n], XmNcancelLabelString, xmstrings[6]); n++;
		XtSetArg(args[n], XmNhelpLabelString, xmstrings[7]); n++;
		saveGraphSDialog = XmCreateFileSelectionDialog(XtParent(w), "save graph selection dialog", args, n);
		XtAddCallback(saveGraphSDialog, XmNokCallback, save_graphS_CB, (caddr_t *) w);
		XtAddCallback(saveGraphSDialog, XmNcancelCallback, unmanage_link_CB, (caddr_t *) &saveGraphSDialog);
		XtAddCallback(saveGraphSDialog, XmNhelpCallback, dialog_help3_CB, (caddr_t *) DIALOG_SAVE_GRAPHS);

		XmStringFree(xmstrings[0]);
		XmStringFree(xmstrings[1]);
		XmStringFree(xmstrings[2]);
		XmStringFree(xmstrings[3]);
		XmStringFree(xmstrings[4]);
		XmStringFree(xmstrings[5]);
		XmStringFree(xmstrings[6]);
		XmStringFree(xmstrings[7]);

		XtManageChild(saveGraphSDialog);
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in ACCEPT3_DIALOG occured !\n");
		break;
	}

} /* end of dialog_accept3_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_help3_CB(w, client_data, call_data)
 
	PURPOSE		: callback for help buttons

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_help3_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	/* check widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_ASCII:
	case DIALOG_ASCIIS:

		sendhelp(w, "helpserver", "biosim", HELP_ASCII);
		break;

	case DIALOG_XSC:
	case DIALOG_YSC:
	case DIALOG_XSCS:
	case DIALOG_YSCS:

		sendhelp(w, "helpserver", "biosim", HELP_SCALE);
		break;

	case DIALOG_XZO:
	case DIALOG_YZO:
	case DIALOG_XZOS:
	case DIALOG_YZOS:

		sendhelp(w, "helpserver", "biosim", HELP_ZOOM);
		break;

	case DIALOG_SAVE_GRAPH:
	case DIALOG_SAVE_GRAPHS:

		sendhelp(w, "helpserver", "biosim", HELP_SAVEGRAPH);
		break;

	case DIALOG_HELP_INDEX:

		sendhelp(w, "helpserver", "biosim", HELP_INDEX);
		break;

	case DIALOG_HELP_FEATURES:

		sendhelp(w, "helpserver", "biosim", HELP_FEATURES);
		break;

	case DIALOG_HELP_INTRO:

		sendhelp(w, "helpserver", "biosim", HELP_INTRO);
		break;

	case DIALOG_HELP_TARGET:

		sendhelp(w, "helpserver", "biosim", HELP_TARGET);
		break;

	case DIALOG_HELP_CELLMODEL:

		sendhelp(w, "helpserver", "biosim", HELP_CELLMODEL);
		break;

	case DIALOG_HELP_CONTEXT:

		sendhelp(w, "helpserver", "biosim", HELP_CONTEXT);
		break;

	case DIALOG_HELP_MOUSE:

		sendhelp(w, "helpserver", "biosim", HELP_MOUSE);
		break;

	case DIALOG_HELP_KEYBOARD:

		sendhelp(w, "helpserver", "biosim", HELP_KEYBOARD);
		break;

	case DIALOG_HELP_GLOSSAR:

		sendhelp(w, "helpserver", "biosim", HELP_GLOSSAR);
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in HELP3_DIALOG occured !\n");
		break;
	}

} /* end of dialog_help3_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_toggle3_CB(w, client_data, call_data)
 
	PURPOSE		: callback for toggle buttons

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_toggle3_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	XmToggleButtonCallbackStruct *button = (XmToggleButtonCallbackStruct *) call_data;
	Neuron 		*neuron;		/* current neuron */
	Connection	*synapse;		/* current synapse */
	Widget 		graph;			/* current graph */
	double		temp;			/* temporary variable */
	Boolean 	set = button->set;	/* button state */

	/* check widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_ZOOM_ALL:	/* zoom all windows */

		/* set status of toggle button */

		zoomAllWindows = set;
			
		break;

	case DIALOG_S_ZOOM_ALL:	/* zoom all windows */

		/* set status of toggle button */

		zoomAllSWindows = set;

		break;

	case DIALOG_SCALE_ALL:	/* zoom all windows */

		/* set status of toggle button */

		scaleAllWindows = set;

		break;

	case DIALOG_S_SCALE_ALL:	/* zoom all windows */

		/* set status of toggle button */

		scaleAllSWindows = set;

		break;

	case DIALOG_X_AXE:	/* draw grid for x-axis in graph window */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(XtParent(w))))));
		neuron = get_neuron_from_graph_title(graph);

		if (set)
		{
			if (neuron->graph->axis == 0)
				neuron->graph->axis = 1;
			if (neuron->graph->axis == 2)
				neuron->graph->axis = 3;
		}
		else
		{
			if (neuron->graph->axis == 1)
				neuron->graph->axis = 0;
			if (neuron->graph->axis == 3)
				neuron->graph->axis = 2;
		}
		break;

	case DIALOG_Y_AXE:	/* draw grid for y-axis in graph window */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(XtParent(w))))));
		neuron = get_neuron_from_graph_title(graph);

		if (set)
		{
			if (neuron->graph->axis == 0)
				neuron->graph->axis = 2;
			if (neuron->graph->axis == 1)
				neuron->graph->axis = 3;
		}
		else
		{
			if (neuron->graph->axis == 2)
				neuron->graph->axis = 0;
			if (neuron->graph->axis == 3)
				neuron->graph->axis = 1;
		}
		break;

	case DIALOG_DOTS:	/* draw dots as grid pattern */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(XtParent(w))))));
		neuron = get_neuron_from_graph_title(graph);

		if (set)
		{
			neuron->graph->gridType = 1;
		}
		else
		{
			if (neuron->graph->gridType == 1)
				neuron->graph->gridType = 0;
		}
		break;

	case DIALOG_LINES:	/* draw lines as grid pattern */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(XtParent(w))))));
		neuron = get_neuron_from_graph_title(graph);

		if (set)
		{
			neuron->graph->gridType = 2;
		}
		else
		{
			if (neuron->graph->gridType == 2)
				neuron->graph->gridType = 0;
		}
		break;

	case DIALOG_SOMA:	/* draw soma trace */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		neuron->graph->traceSoma = set;
		break;

	case DIALOG_DENDRIT:	/* ask user for a dendrit segment to be plotted */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);
		currentGraph = neuron->graph;

		if (set)
		{
			currentGraph->traceDendrit = TRUE;
			XtManageChild(askDendritBB);
		}
		else currentGraph->traceDendrit = FALSE;

		break;

	case DIALOG_GATE_VARIABLES:	/* set special flag in currentGraph for drawing gate variables in graph */

		/* determine current graph */

		determine_current_graph(w, DIALOG_GATE_VARIABLES);

		if (set)
		{
			currentGraph->gateVariables = TRUE;

			/* change y-axis scaling */

			currentGraph->lowestY = 0.0;
			currentGraph->highestY = 1.0;
			currentGraph->yScale = (double) currentGraph->height;

			set_y_axis(currentGraph);
			draw_graph(currentGraph->neuron);
		}
		else
		{
			currentGraph->gateVariables = FALSE;

			/* change y-axis scaling */

			currentGraph->lowestY = YSSC_DEF;
			currentGraph->highestY = (double) YESC_DEF;
			temp = currentGraph->highestY - currentGraph->lowestY;
			temp = fabs(temp);
			currentGraph->yScale = (double) currentGraph->height / temp;

			set_y_axis(currentGraph);
			draw_graph(currentGraph->neuron);
		}
		break;

	case DIALOG_SYNAPTIC_CURRENT:	/* draw synaptic current trace */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		neuron->graph->traceSynapticCurrent = set;
		break;

	case DIALOG_TOTAL_CURRENT:	/* draw total current trace */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		neuron->graph->traceTotalCurrent = set;
		break;

	case DIALOG_NA:		/* draw sodium current trace */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		neuron->graph->traceNA = set;
		break;

	case DIALOG_K:		/* draw potassium current trace */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		neuron->graph->traceK = set;
		break;

	case DIALOG_CA:		/* draw calcium current trace */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		neuron->graph->traceCA = set;
		break;

	case DIALOG_CA1:	/* draw first calcium current trace */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		neuron->graph->traceCA1 = set;
		break;

	case DIALOG_CA2:	/* draw second calcium current trace */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		neuron->graph->traceCA2 = set;
		break;

	case DIALOG_KCA:	/* draw calcium dependend potassium current trace */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		neuron->graph->traceKCA = set;
		break;

	case DIALOG_A:		/* draw A-current trace */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		neuron->graph->traceA = set;
		break;

	case DIALOG_IR:		/* draw IR-current trace */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		neuron->graph->traceIR = set;
		break;

	case DIALOG_P:		/* draw P-current trace */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		neuron->graph->traceP = set;
		break;

	case DIALOG_N:		/* draw Noise-current trace */

		/* get neuron from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		neuron = get_neuron_from_graph_title(graph);

		neuron->graph->traceN = set;
		break;

	case DIALOG_X_AXES:	/* draw grid for x-axis in graph window for synapses */

		/* get synapse from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(XtParent(w))))));
		synapse = get_synapse_from_graph_title(graph);

		if (set)
		{
			if (synapse->graph->axis == 0)
				synapse->graph->axis = 1;
			if (synapse->graph->axis == 2)
				synapse->graph->axis = 3;
		}
		else
		{
			if (synapse->graph->axis == 1)
				synapse->graph->axis = 0;
			if (synapse->graph->axis == 3)
				synapse->graph->axis = 2;
		}
		break;

	case DIALOG_Y_AXES:	/* draw grid for y-axis in graph window for synapses */

		/* get synapse from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(XtParent(w))))));
		synapse = get_synapse_from_graph_title(graph);

		if (set)
		{
			if (synapse->graph->axis == 0)
				synapse->graph->axis = 2;
			if (synapse->graph->axis == 1)
				synapse->graph->axis = 3;
		}
		else
		{
			if (synapse->graph->axis == 2)
				synapse->graph->axis = 0;
			if (synapse->graph->axis == 3)
				synapse->graph->axis = 1;
		}
		break;

	case DIALOG_DOTSS:	/* draw dots as grid pattern for synapses */

		/* get synapse from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(XtParent(w))))));
		synapse = get_synapse_from_graph_title(graph);

		if (set)
		{
			synapse->graph->gridType = 1;
		}
		else
		{
			if (synapse->graph->gridType == 1)
				synapse->graph->gridType = 0;
		}
		break;

	case DIALOG_LINESS:	/* draw lines as grid pattern for synapses */

		/* get synapse from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(XtParent(w))))));
		synapse = get_synapse_from_graph_title(graph);

		if (set)
		{
			synapse->graph->gridType = 2;
		}
		else
		{
			if (synapse->graph->gridType == 2)
				synapse->graph->gridType = 0;
		}
		break;

	case DIALOG_POTENTIAL:	/* draw synapse potential trace */

		/* get synapse from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		synapse = get_synapse_from_graph_title(graph);

		synapse->graph->tracePot = set;
		break;

	case DIALOG_MEMORY:		/* draw memory trace */

		/* get synapse from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		synapse = get_synapse_from_graph_title(graph);

		synapse->graph->traceMem = set;
		break;

	case DIALOG_CONDUCTANCE:	/* draw current conductance trace for synapses */

		/* get synapse from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		synapse = get_synapse_from_graph_title(graph);

		synapse->graph->traceCon = set;
		break;

	case DIALOG_INHIBITION:		/* draw current inhibition trace for synapses */

		/* get synapse from graph window title */

		graph = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));
		synapse = get_synapse_from_graph_title(graph);

		synapse->graph->traceStr = set;
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in TOGGLE3_DIALOG occured !\n");
		break;
	}

} /* end of dialog_toggle3_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_def3_CB(w, client_data, call_data)
 
	PURPOSE		: callback for default buttons

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_def3_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	Arg		args[20];		/* argument list for manipulating widgets */
	Cardinal	n;			/* used as argument counter for manipulating widgets */
	short int 	decimals;		/* number of decimals for scale widget */
	char		text[20];		/* number as string */

	/* check widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_ASCII:		/* output graph interval */

		sprintf(text,"%f", (double) ASCOUT_DEF);
		XmTextSetString(asciiOutputIntervalText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(asciiOutputIntervalScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (ASCOUT_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(asciiOutputIntervalScale, args, n);
		break;

	case DIALOG_XSSC:		/* start value of x-scaling */

		sprintf(text,"%f", (double) XSSC_DEF);
		XmTextSetString(newGraphXScalingStartText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphXScalingStartScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (XSSC_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphXScalingStartScale, args, n);
		break;

	case DIALOG_XESC:		/* end value of x-scaling */

		sprintf(text,"%f", (double) LTSTOP * T_SCALE);
		XmTextSetString(newGraphXScalingEndText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphXScalingEndScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (LTSTOP * T_SCALE * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphXScalingEndScale, args, n);
		break;

	case DIALOG_YSSC:		/* start value of y-scaling */

		sprintf(text,"%f", (double) YSSC_DEF);
		XmTextSetString(newGraphYScalingStartText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphYScalingStartScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (YSSC_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphYScalingStartScale, args, n);
		break;

	case DIALOG_YESC:		/* end value of y-scaling */

		sprintf(text,"%f", (double) YESC_DEF);
		XmTextSetString(newGraphYScalingEndText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphYScalingEndScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (YESC_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphYScalingEndScale, args, n);
		break;

	case DIALOG_XZO:		/* zoom x-axis */

		sprintf(text,"%f", (double) XZO_DEF);
		XmTextSetString(newGraphXZoomMagText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphXZoomMagScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (XZO_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphXZoomMagScale, args, n);
		break;

	case DIALOG_YZO:		/* zoom y-axis */

		sprintf(text,"%f", (double) YZO_DEF);
		XmTextSetString(newGraphYZoomMagText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphYZoomMagScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (YZO_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphYZoomMagScale, args, n);
		break;

	case DIALOG_ASCIIS:		/* output graph interval for synapses */

		sprintf(text,"%f", (double) ASCOUT_DEF);
		XmTextSetString(asciiOutputIntervalSText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(asciiOutputIntervalSScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (ASCOUT_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(asciiOutputIntervalSScale, args, n);
		break;

	case DIALOG_XSSCS:		/* start value of x-scaling for synapses */

		sprintf(text,"%f", (double) XSSC_DEF);
		XmTextSetString(newGraphXScalingSStartText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphXScalingSStartScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (XSSC_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphXScalingSStartScale, args, n);
		break;

	case DIALOG_XESCS:		/* end value of x-scaling for synapses */

		sprintf(text,"%f", (double) LTSTOP * T_SCALE);
		XmTextSetString(newGraphXScalingSEndText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphXScalingSEndScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (LTSTOP * T_SCALE * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphXScalingSEndScale, args, n);
		break;

	case DIALOG_YSSCS:		/* start value of y-scaling for synapses */

		sprintf(text,"%f", (double) YSSC_DEF);
		XmTextSetString(newGraphYScalingSStartText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphYScalingSStartScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (YSSC_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphYScalingSStartScale, args, n);
		break;

	case DIALOG_YESCS:		/* end value of y-scaling for synapses */

		sprintf(text,"%f", (double) YESC_DEF);
		XmTextSetString(newGraphYScalingSEndText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphYScalingSEndScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (YESC_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphYScalingSEndScale, args, n);
		break;

	case DIALOG_XZOS:		/* zoom x-axis for synapses */

		sprintf(text,"%f", (double) XZO_DEF);
		XmTextSetString(newGraphXZoomSMagText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphXZoomSMagScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (XZO_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphXZoomSMagScale, args, n);
		break;

	case DIALOG_YZOS:		/* zoom y-axis for synapses */

		sprintf(text,"%f", (double) YZO_DEF);
		XmTextSetString(newGraphYZoomSMagText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newGraphYZoomSMagScale, args, n);

		n = 0;
		XtSetArg(args[n], XmNvalue, (int) (YZO_DEF * pow((double) 10, (double) decimals))); n++;
		XtSetValues(newGraphYZoomSMagScale, args, n);
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in DEF3_DIALOG occured !\n");
		break;
	}
} /* end of dialog_def3_CB */
#endif
