/************************************************************************************************************************

	PROGRAM:	BIOSIM

	FILENAME:	menu2.h

	PURPOSE:	definitions and structures used in menu2.c

************************************************************************************************************************/

/******	definitions	******/

#define DIALOG_TEXT_SWIM_NAEQ		101
#define DIALOG_TEXT_SWIM_NACON		102
#define DIALOG_TEXT_SWIM_KEQ		103
#define DIALOG_TEXT_SWIM_KCON		104
#define DIALOG_TEXT_SWIM_CAEQ		105
#define DIALOG_TEXT_SWIM_CACON		106
#define DIALOG_TEXT_SWIM_STH		107
#define DIALOG_TEXT_CON			108
#define DIALOG_TEXT_LEAK		109
#define DIALOG_TEXT_CAP			110
#define DIALOG_TEXT_TOD			111
#define DIALOG_TEXT_POT			112
#define DIALOG_TEXT_DPOT		113
#define DIALOG_TEXT_DCON		114
#define DIALOG_TEXT_DLEAK		115
#define DIALOG_TEXT_DCAP		116
#define DIALOG_TEXT_TOS			117
#define DIALOG_TEXT_TT			118
#define DIALOG_TEXT_STR			119
#define DIALOG_TEXT_TRT			120
#define DIALOG_TEXT_TRS			121
#define DIALOG_TEXT_DSTART		122
#define DIALOG_TEXT_DEND		123
#define DIALOG_TEXT_DCUR		124
#define DIALOG_TEXT_SSTART		125
#define DIALOG_TEXT_SEND		126
#define DIALOG_TEXT_SCUR		127
#define DIALOG_TEXT_SIMLEN		128
#define DIALOG_TEXT_SIMSIZE		129
#define DIALOG_TEXT_SEQ			130
#define DIALOG_TEXT_ONOFF_NAEQ		131
#define DIALOG_TEXT_ONOFF_NACON		132
#define DIALOG_TEXT_ONOFF_NADUR		133
#define DIALOG_TEXT_ONOFF_KEQ		134
#define DIALOG_TEXT_ONOFF_KCON		135
#define DIALOG_TEXT_ONOFF_KSTART	136
#define DIALOG_TEXT_ONOFF_KDUR		137
#define DIALOG_TEXT_ONOFF_CAEQ		138
#define DIALOG_TEXT_ONOFF_CACON		139
#define DIALOG_TEXT_ONOFF_CASTART	140
#define DIALOG_TEXT_ONOFF_CADUR		141
#define DIALOG_TEXT_ONOFF_STH		142
#define DIALOG_TEXT_HH_NAEQ		143
#define DIALOG_TEXT_HH_NACON		144
#define DIALOG_TEXT_HH_KEQ		145
#define DIALOG_TEXT_HH_KCON		146
#define DIALOG_TEXT_HH_STH		147
#define DIALOG_TEXT_GB_NAEQ		148
#define DIALOG_TEXT_GB_NACON		149
#define DIALOG_TEXT_GB_KEQ		150
#define DIALOG_TEXT_GB_KCON		151
#define DIALOG_TEXT_GB_CA1CON		152
#define DIALOG_TEXT_GB_CA2CON		153
#define DIALOG_TEXT_GB_KCAEQ		154
#define DIALOG_TEXT_GB_KCACON		155
#define DIALOG_TEXT_GB_AEQ		156
#define DIALOG_TEXT_GB_ACON		157
#define DIALOG_TEXT_GB_IREQ		158
#define DIALOG_TEXT_GB_IRCON		159
#define DIALOG_TEXT_GB_PEQ		160
#define DIALOG_TEXT_GB_PCON		161
#define DIALOG_TEXT_GB_STH		162
#define DIALOG_TEXT_MAXSTR		163
#define DIALOG_TEXT_TARGET		164
#define DIALOG_TEXT_LOCATION		165
#define DIALOG_TEXT_REGION		166
#define DIALOG_TEXT_NACTINT		167

#define DIALOG_SCALE_SWIM_NAEQ		700
#define DIALOG_SCALE_SWIM_NACON		701
#define DIALOG_SCALE_SWIM_KEQ		702
#define DIALOG_SCALE_SWIM_KCON		703
#define DIALOG_SCALE_SWIM_CAEQ		704
#define DIALOG_SCALE_SWIM_CACON		705
#define DIALOG_SCALE_SWIM_STH		706
#define DIALOG_SCALE_CON		707
#define DIALOG_SCALE_LEAK		708
#define DIALOG_SCALE_CAP		709
#define DIALOG_SCALE_TOD		710
#define DIALOG_SCALE_POT		711
#define DIALOG_SCALE_DPOT		712
#define DIALOG_SCALE_DCON		713
#define DIALOG_SCALE_DLEAK		714
#define DIALOG_SCALE_DCAP		715
#define DIALOG_SCALE_TOS		716
#define DIALOG_SCALE_TT			717
#define DIALOG_SCALE_STR		718
#define DIALOG_SCALE_TRT		719
#define DIALOG_SCALE_TRS		720
#define DIALOG_SCALE_SCUR		721
#define DIALOG_SCALE_SSTART		722
#define DIALOG_SCALE_SEND		723
#define DIALOG_SCALE_DCUR		724
#define DIALOG_SCALE_DSTART		725
#define DIALOG_SCALE_DEND		726
#define DIALOG_SCALE_SIMLEN		727
#define DIALOG_SCALE_SIMSIZE		728
#define DIALOG_SCALE_SEQ		729
#define DIALOG_SCALE_ONOFF_NAEQ		730
#define DIALOG_SCALE_ONOFF_NACON	731
#define DIALOG_SCALE_ONOFF_NADUR	732
#define DIALOG_SCALE_ONOFF_KEQ		733
#define DIALOG_SCALE_ONOFF_KCON		734
#define DIALOG_SCALE_ONOFF_KSTART	735
#define DIALOG_SCALE_ONOFF_KDUR		736
#define DIALOG_SCALE_ONOFF_CAEQ		737
#define DIALOG_SCALE_ONOFF_CACON	738
#define DIALOG_SCALE_ONOFF_CASTART	739
#define DIALOG_SCALE_ONOFF_CADUR	740
#define DIALOG_SCALE_ONOFF_STH		741
#define DIALOG_SCALE_HH_NAEQ		742
#define DIALOG_SCALE_HH_NACON		743
#define DIALOG_SCALE_HH_KEQ		744
#define DIALOG_SCALE_HH_KCON		745
#define DIALOG_SCALE_HH_STH		746
#define DIALOG_SCALE_GB_NAEQ		747
#define DIALOG_SCALE_GB_NACON		748
#define DIALOG_SCALE_GB_KEQ		749
#define DIALOG_SCALE_GB_KCON		750
#define DIALOG_SCALE_GB_CA1CON		751
#define DIALOG_SCALE_GB_CA2CON		752
#define DIALOG_SCALE_GB_KCAEQ		753
#define DIALOG_SCALE_GB_KCACON		754
#define DIALOG_SCALE_GB_AEQ		755
#define DIALOG_SCALE_GB_ACON		756
#define DIALOG_SCALE_GB_IREQ		757
#define DIALOG_SCALE_GB_IRCON		758
#define DIALOG_SCALE_GB_PEQ		759
#define DIALOG_SCALE_GB_PCON		760
#define DIALOG_SCALE_GB_STH		761
#define DIALOG_SCALE_MAXSTR		762
#define DIALOG_SCALE_TARGET		763
#define DIALOG_SCALE_LOCATION		764
#define DIALOG_SCALE_REGION		765
#define DIALOG_SCALE_NACTINT		766

#define DIALOG_DEF_CON			500
#define DIALOG_DEF_LEAK			501
#define DIALOG_DEF_CAP			502
#define DIALOG_DEF_POT			503
#define DIALOG_DEF_TOD			504
#define DIALOG_DEF_DCON			505
#define DIALOG_DEF_DCAP			506
#define DIALOG_DEF_DLEAK		507
#define DIALOG_DEF_DPOT			508
#define DIALOG_DEF_TOS			509
#define DIALOG_DEF_SWIM_NAEQ		510
#define DIALOG_DEF_SWIM_NACON		511
#define DIALOG_DEF_SWIM_KEQ		512
#define DIALOG_DEF_SWIM_KCON		513
#define DIALOG_DEF_SWIM_CAEQ		514
#define DIALOG_DEF_SWIM_CACON		515
#define DIALOG_DEF_SWIM_STH		516
#define DIALOG_DEF_TRT			517
#define DIALOG_DEF_TRS			518
#define DIALOG_DEF_STR			519
#define DIALOG_DEF_TT			520
#define DIALOG_DEF_SIMLEN		521
#define DIALOG_DEF_SIMSIZE		522
#define DIALOG_DEF_SCUR			523
#define DIALOG_DEF_SSTART		524
#define DIALOG_DEF_SEND			525
#define DIALOG_DEF_DCUR			526
#define DIALOG_DEF_DSTART		527
#define DIALOG_DEF_DEND			528
#define DIALOG_DEF_SEQ			529
#define DIALOG_DEF_ONOFF_NAEQ		530
#define DIALOG_DEF_ONOFF_NACON		531
#define DIALOG_DEF_ONOFF_NADUR		532
#define DIALOG_DEF_ONOFF_KEQ		533
#define DIALOG_DEF_ONOFF_KCON		534
#define DIALOG_DEF_ONOFF_KSTART		535
#define DIALOG_DEF_ONOFF_KDUR		536
#define DIALOG_DEF_ONOFF_CAEQ		537
#define DIALOG_DEF_ONOFF_CACON		538
#define DIALOG_DEF_ONOFF_CASTART	539
#define DIALOG_DEF_ONOFF_CADUR		540
#define DIALOG_DEF_ONOFF_STH		541
#define DIALOG_DEF_HH_NAEQ		542
#define DIALOG_DEF_HH_NACON		543
#define DIALOG_DEF_HH_KEQ		544
#define DIALOG_DEF_HH_KCON		545
#define DIALOG_DEF_HH_STH		546
#define DIALOG_DEF_GB_NAEQ		547
#define DIALOG_DEF_GB_NACON		548
#define DIALOG_DEF_GB_KEQ		549
#define DIALOG_DEF_GB_KCON		550
#define DIALOG_DEF_GB_CA1CON		551
#define DIALOG_DEF_GB_CA2CON		552
#define DIALOG_DEF_GB_KCAEQ		553
#define DIALOG_DEF_GB_KCACON		554
#define DIALOG_DEF_GB_AEQ		555
#define DIALOG_DEF_GB_ACON		556
#define DIALOG_DEF_GB_IREQ		557
#define DIALOG_DEF_GB_IRCON		558
#define DIALOG_DEF_GB_PEQ		559
#define DIALOG_DEF_GB_PCON		560
#define DIALOG_DEF_GB_STH		561
#define DIALOG_DEF_MAXSTR		562
#define DIALOG_DEF_TARGET		563
#define DIALOG_DEF_LOCATION		564
#define DIALOG_DEF_REGION		565
#define DIALOG_DEF_NACTINT		566

#define	DIALOG_OBJECTS			601
#define	DIALOG_SWIM_CHANNELS		602
#define	DIALOG_NEURON			603
#define	DIALOG_CURRENT			604
#define	DIALOG_ADD_SYNAPSE		605
#define	DIALOG_EDIT_SYNAPSE		606
#define	DIALOG_SIMPARS			607
#define DIALOG_NEW_STYPE		608
#define DIALOG_SYNAPSE			609
#define DIALOG_AXO_SYNAPSE		610
#define DIALOG_DELETE_SYNAPSE		611
#define DIALOG_ONOFF_CHANNELS		612
#define DIALOG_CONNECTION		613
#define DIALOG_CONNECT_OBJECTS		614
#define DIALOG_INFO			615
#define DIALOG_ALL_GRAPHS		616
#define	DIALOG_SELECT_CHANNELS		617
#define	DIALOG_SELECT_NEURON		618
#define	DIALOG_SELECT_CURRENT		619
#define DIALOG_SPECIFY			620
#define DIALOG_HH_CHANNELS		621
#define DIALOG_GB_CHANNELS		622
#define DIALOG_DELETE_OBJECTS		623
#define	DIALOG_INFO_SYNAPSE		624
#define	DIALOG_WINDOW_SYNAPSE		625

#define SODIUM				630
#define POTASSIUM			631
#define CHEMICAL			632
#define ELECTRICAL			633
#define NOISE_TOGGLE			634

#define DIALOG_NEW_GRAPH		640
#define DIALOG_NEW_GRAPHS		641
#define DIALOG_TOPOLOGY			642
#define DIALOG_NORMAL_STATE		643
#define DIALOG_INPUT_NEURONS		644
#define DIALOG_OUTPUT_NEURONS		645
#define DIALOG_INPUT_OUTPUT_NEURONS	646

#define DIALOG_BUTTON_LOAD_CHANNEL	650
#define DIALOG_BUTTON_LOAD_SOMA		651
#define DIALOG_BUTTON_LOAD_DENDRIT	652
#define DIALOG_BUTTON_LOAD_GENERAL	653
#define DIALOG_BUTTON_SAVE_CHANNEL	654
#define DIALOG_BUTTON_SAVE_GENERAL	655

#define DIALOG_LOAD_GENERAL		660
#define DIALOG_SAVE_GENERAL		661

#define DIALOG_SIMINF_START		670
#define DIALOG_SIMINF_PAUSE		671
#define DIALOG_SIMINF_STOP		672
#define DIALOG_SIMINF_STEP		673

#define DIALOG_SELECT_LEARNPARAM	1160

/******	structures	******/

/***	structure for selected synapse parameters	***/

struct ItemSelectedStruct
{
	double	STRENGTH;
	double	TT;
	double	TRT;
	double	TRS;
	int	LOC;
	int	type;
	int	position;
};

/***	structure for selected neuron ion channel parameters	***/

struct ChannelsSelection
{
	double	NAEQ;
	double	NACON;
	double	NADUR;
	double	KEQ;
	double	KCON;
	double	KSTART;
	double	KDUR;
	double	CAEQ;
	double	CACON;
	double	CASTART;
	double	CADUR;
	double	STH;
	double  CA1CON;
	double  CA2CON;
	double  KCAEQ;
	double  KCACON;
	double  AEQ;
	double  ACON;
	double  IREQ;
	double  IRCON;
	double  PEQ;
	double  PCON;
};

/***	structure for selected neuron general parameters	***/

struct NeuronSelection
{
	double	CONDUCTANCE;
	double	LEAK;
	double	CAP;
	double	TOD;
	double	POTENTIAL;
	double	DCON;
	double	DPOT;
	double	DLEAK;
	double	DCAP;
	double	TOS;
};

/***	structure for selected neuron external current parameters	***/

struct CurrentSelection
{
	double	SSTART;
	double	SEND;
	double	SCUR;
	double	DSTART;
	double	DEND;
	double	DCUR;
	int	REG;
	Boolean	NOISE;
};
