/************************************************************************************************************************

	PROGRAM:	BIOSIM

	FILENAME:	menu2.c

	PURPOSE:	handles all functions for dialog boxes from the main menu

	FUNCTIONS:	in order of appearance

	create_popupMenu		- creates the popup menu in the drawing area reached with middle mouse button
	create_infoObject		- creates information box about selected object
	create_onOffParams		- creates dialog box for edit ONOFF channels of neurons
	create_swimParams		- creates dialog box for edit SWIM channels of neurons
	create_hhParams			- creates dialog box for edit HH channels of neurons
	create_gbParams			- creates dialog box for edit GB channels of neurons
	create_editNeuron		- creates dialog box for edit neuron parameters
	create_editCurrent		- creates dialog box for edit extern neuron currents
	create_newSType			- creates dialog box for input new synaptic types
	create_addSynapse		- creates dialog box for connect to neurons
	create_editSynapse		- creates dialog box for edit a connection
	create_editSimPars		- creates dialog box for edit simulation parameters
	create_simInf			- creates dialog box for simulation information parameters
	set_synaptic_types		- set possible synaptic types in add synapse list widget
	dialog_accept2_CB		- callback for ok buttons
	dialog_cancel2_CB		- callback for cancel buttons
	dialog_help2_CB			- callback for help buttons
	radio_box2_CB			- callback for radio boxes
	dialog_text2_CB			- callback for text widgets
	dialog_scale2_CB		- callback for scale widgets
	dialog_def2_CB			- callback for default buttons
	dialog_button2_CB		- callback for special buttons, such as load and save parameters
	dialog_selection2_CB		- callback for selections from selection lists
	show_synaptic_connections	- shows synaptic connections in the editSynapseList

************************************************************************************************************************/

#ifndef BATCH
#include "copying.h"
#include "biosim.h"
#include "functions.h"
#include "menu2.h"

/****** global variables ******/

Widget onOffParamsBB;					/* mask for edit ONOFF channels */
Widget swimParamsBB;					/* mask for edit SWIM channels */
Widget hhParamsBB;					/* mask for edit HH channels */
Widget gbParamsBB;					/* mask for edit GB channels */
Widget editNeuronBB;					/* mask for edit global neuron parameters */
Widget editCurrentBB;					/* mask for edit currents */
Widget addSynapseBB;					/* mask for add synapse */
Widget editSynapseBB;					/* mask for edit synapse */
Widget editSimParsBB;					/* mask for edit simulation parameters */
Widget newSTypeBB;					/* mask for add new synaptic type */
Widget simInfBB;					/* mask for show simulation information */
Widget newGraphForm;					/* mask for new graph window for neurons */
Widget newGraphSForm;					/* mask for new graph window for synapses */
Widget popupMenu;					/* popup menu in drawing area */
Widget deleteObjectsButton;				/* button in popup menu in drawing area */
Widget connectObjectsButton;				/* button in popup menu in drawing area */
Widget editChannelButton;				/* button in popup menu in drawing area */
Widget editNeuronButton;				/* button in popup menu in drawing area */
Widget editCurrentButton;				/* button in popup menu in drawing area */
Widget informationObjectButton;				/* button in popup menu in drawing area */
Widget editConnectionButton;				/* button in popup menu in drawing area */
Widget editAxoConnectionButton;				/* button in popup menu in drawing area */
Widget attachWindowButton;				/* button in popup menu in drawing area */
Widget attachWindowSButton;				/* button in popup menu in drawing area */
Widget selectNeuronsButton;				/* button in popup menu in drawing area */
Widget selectSynapsesButton;				/* button in popup menu in drawing area */
Widget selectAxoSynapsesButton;				/* button in popup menu in drawing area */
Widget selectGraphsButton;				/* button in popup menu in drawing area */
Widget showTopologyButton;				/* button in popup menu in drawing area */
Widget showInputNeuronsButton;				/* button in popup menu in drawing area */
Widget showOutputNeuronsButton;				/* button in popup menu in drawing area */
Widget showInputOutputNeuronsButton;			/* button in popup menu in drawing area */
Widget showNormalStateButton;				/* button in popup menu in drawing area */
Widget specifyObjectsButton;				/* button in popup menu in drawing area */
Widget addSynapseLearnButton;				/* button in addSynapse dialog box */
Widget simInfStopButton;				/* button in show simulation information */
Widget simInfCompletedText;				/* text field in show simulation information */
Widget simInfLengthText;				/* text field in show simulation information */
Widget editSimParsSimLenText;				/* text field in edit simulation parameter */
Widget editSimParsStepSizeText;				/* text field in edit simulation parameter */
Widget neuronActivityIntervalText;			/* text field in edit simulation parameter */
Widget editSimParsSimLenScale;				/* scale field in edit simulation parameter */
Widget editSimParsStepSizeScale;			/* scale field in edit simulation parameter */
Widget neuronActivityIntervalScale;			/* scale field in edit simulation parameter */
Widget addSynapseTargetScale;				/* scale widget in add synapse mask */
Widget editSynapseLocationScale;			/* scale widget in edit synapse mask */
Widget editCurrentLocationScale;			/* scale widget in edit current mask */
Widget addSynapseTargetText;				/* text widget in add synapse mask */
Widget editSynapseLocationText;				/* text widget in edit synapse mask */
Widget editCurrentLocationText;				/* text widget in edit current mask */
Widget editCurrentSomaEndScale;				/* scale widget */
Widget editCurrentDendritEndScale;			/* scale widget */
Widget editCurrentSomaStartScale;			/* scale widget */
Widget editCurrentDendritStartScale;			/* scale widget */

/****** local variables ******/

static struct ItemSelectedStruct itemSelected;		/* selected synapse parameters */
static struct ChannelsSelection channelsSelection;	/* selected neuron ion channel parameters */
static struct NeuronSelection neuronSelection;		/* selected neuron general parameters */
static struct CurrentSelection currentSelection;	/* selected neuron extern current parameters */

static Widget swimParamsNaEqText;			/* text widget */
static Widget swimParamsNaConText;			/* text widget */
static Widget swimParamsKEqText;			/* text widget */
static Widget swimParamsKConText;			/* text widget */
static Widget swimParamsCaEqText;			/* text widget */
static Widget swimParamsCaConText;			/* text widget */
static Widget swimParamsSpikeThresholdText;		/* text widget */
static Widget hhParamsNaEqText;				/* text widget */
static Widget hhParamsNaConText;			/* text widget */
static Widget hhParamsKEqText;				/* text widget */
static Widget hhParamsKConText;				/* text widget */
static Widget hhParamsSpikeThresholdText;		/* text widget */
static Widget gbParamsNaEqText;				/* text widget */
static Widget gbParamsNaConText;			/* text widget */
static Widget gbParamsKEqText;				/* text widget */
static Widget gbParamsKConText;				/* text widget */
static Widget gbParamsCa1ConText;			/* text widget */
static Widget gbParamsCa2ConText;			/* text widget */
static Widget gbParamsKCAEqText;			/* text widget */
static Widget gbParamsKCAConText;			/* text widget */
static Widget gbParamsAEqText;				/* text widget */
static Widget gbParamsAConText;				/* text widget */
static Widget gbParamsIREqText;				/* text widget */
static Widget gbParamsIRConText;			/* text widget */
static Widget gbParamsPEqText;				/* text widget */
static Widget gbParamsPConText;				/* text widget */
static Widget gbParamsSpikeThresholdText;		/* text widget */
static Widget editNeuronToDendritConductanceText;	/* text widget */
static Widget editNeuronPotentialText;			/* text widget */
static Widget editNeuronCapacityText;			/* text widget */
static Widget editNeuronLeakText;			/* text widget */
static Widget editNeuronConductanceText;		/* text widget */
static Widget editNeuronDConductanceText;		/* text widget */
static Widget editNeuronDLeakText;			/* text widget */
static Widget editNeuronDCapacityText;			/* text widget */
static Widget editNeuronDPotentialText;			/* text widget */
static Widget editNeuronToSomaConductanceText;		/* text widget */
static Widget addSynapseTTText;				/* text widget */
static Widget addSynapseStrText;			/* text widget */
static Widget addSynapseMaxStrText;			/* text widget */
static Widget addSynapseTRTText;			/* text widget */
static Widget addSynapseTRSText;			/* text widget */
static Widget editCurrentDendritStartText;		/* text widget */
static Widget editCurrentDendritCurrentText;		/* text widget */
static Widget editCurrentSomaEndText;			/* text widget */
static Widget editCurrentSomaStartText;			/* text widget */
static Widget editCurrentSomaCurrentText;		/* text widget */
static Widget editCurrentDendritEndText;		/* text widget */
static Widget newSTypeEqPotText;			/* text widget */
static Widget editSynapseFromText;			/* text widget */
static Widget editSynapseToText;			/* text widget */
static Widget onOffParamsNaEqPotText;			/* text widget */
static Widget onOffParamsNaConductanceText;		/* text widget */
static Widget onOffParamsNaDurText;			/* text widget */
static Widget onOffParamsKEqPotText;			/* text widget */
static Widget onOffParamsKStartText;			/* text widget */
static Widget onOffParamsKConductanceText;		/* text widget */
static Widget onOffParamsKDurText;			/* text widget */
static Widget onOffParamsCaEqPotText;			/* text widget */
static Widget onOffParamsCaStartText;			/* text widget */
static Widget onOffParamsCaConductanceText;		/* text widget */
static Widget onOffParamsCaDurText;			/* text widget */
static Widget onOffParamsSpikeThresholdText;		/* text widget */
static Widget infoObjectText;				/* text widget */

static Widget swimParamsNaEqScale;			/* scale widget */
static Widget swimParamsNaConScale;			/* scale widget */
static Widget swimParamsKEqScale;			/* scale widget */
static Widget swimParamsKConScale;			/* scale widget */
static Widget swimParamsCaEqScale;			/* scale widget */
static Widget swimParamsCaConScale;			/* scale widget */
static Widget swimParamsSpikeThresholdScale;		/* scale widget */
static Widget hhParamsNaEqScale;			/* scale widget */
static Widget hhParamsNaConScale;			/* scale widget */
static Widget hhParamsKEqScale;				/* scale widget */
static Widget hhParamsKConScale;			/* scale widget */
static Widget hhParamsSpikeThresholdScale;		/* scale widget */
static Widget gbParamsNaEqScale;			/* scale widget */
static Widget gbParamsNaConScale;			/* scale widget */
static Widget gbParamsKEqScale;				/* scale widget */
static Widget gbParamsKConScale;			/* scale widget */
static Widget gbParamsCa1ConScale;			/* scale widget */
static Widget gbParamsCa2ConScale;			/* scale widget */
static Widget gbParamsKCAEqScale;			/* scale widget */
static Widget gbParamsKCAConScale;			/* scale widget */
static Widget gbParamsAEqScale;				/* scale widget */
static Widget gbParamsAConScale;			/* scale widget */
static Widget gbParamsIREqScale;			/* scale widget */
static Widget gbParamsIRConScale;			/* scale widget */
static Widget gbParamsPEqScale;				/* scale widget */
static Widget gbParamsPConScale;			/* scale widget */
static Widget gbParamsSpikeThresholdScale;		/* scale widget */
static Widget editNeuronToDendritConductanceScale;	/* scale widget */
static Widget editNeuronPotentialScale;			/* scale widget */
static Widget editNeuronCapacityScale;			/* scale widget */
static Widget editNeuronLeakScale;			/* scale widget */
static Widget editNeuronConductanceScale;		/* scale widget */
static Widget editNeuronDConductanceScale;		/* scale widget */
static Widget editNeuronDLeakScale;			/* scale widget */
static Widget editNeuronDCapacityScale;			/* scale widget */
static Widget editNeuronDPotentialScale;		/* scale widget */
static Widget editNeuronToSomaConductanceScale;		/* scale widget */
static Widget addSynapseTTScale;			/* scale widget */
static Widget addSynapseStrScale;			/* scale widget */
static Widget addSynapseMaxStrScale;			/* scale widget */
static Widget addSynapseTRTScale;			/* scale widget */
static Widget addSynapseTRSScale;			/* scale widget */
static Widget editCurrentSomaCurrentScale;		/* scale widget */
static Widget editCurrentDendritCurrentScale;		/* scale widget */
static Widget newSTypeEqPotScale;			/* scale widget */
static Widget onOffParamsNaEqPotScale;			/* scale widget */
static Widget onOffParamsSpikeThresholdScale;		/* scale widget */
static Widget onOffParamsNaConductanceScale;		/* scale widget */
static Widget onOffParamsNaDurScale;			/* scale widget */
static Widget onOffParamsKEqPotScale;			/* scale widget */
static Widget onOffParamsKStartScale;			/* scale widget */
static Widget onOffParamsKConductanceScale;		/* scale widget */
static Widget onOffParamsKDurScale;			/* scale widget */
static Widget onOffParamsCaEqPotScale;			/* scale widget */
static Widget onOffParamsCaStartScale;			/* scale widget */
static Widget onOffParamsCaConductanceScale;		/* scale widget */
static Widget onOffParamsCaDurScale;			/* scale widget */

static Widget editCurrentNoiseToggle;			/* toggle button widget */

static Widget addSynapseList;				/* list widget */
static Widget editSynapseList;				/* list widget */

static Widget loadGeneralDialog;			/* dialog box widget */
static Widget saveGeneralDialog;			/* dialog box widget */
static Widget infoObjectBB;				/* bulletin board widget */

static double NAEQ;					/* sodium equilibrium potential */
static double NACON;					/* sodium conductance */
static double KEQ;					/* potassium equilibrium potential */
static double KCON;					/* potassium conductance */
static double CAEQ;					/* calcium equilibrium potential */
static double CACON;					/* calcium conductance */
static double CA1CON;					/* calcium conductance for first Ca-channel */
static double CA2CON;					/* calcium conductance for second Ca-channel */
static double KCAEQ;					/* calcium dependend potassium equilibrium potential */
static double KCACON;					/* calcium dependend potassium conductance */
static double AEQ;					/* equilibrium potential of A-channel */
static double ACON;					/* conductance of A-channel */
static double IREQ;					/* equilibrium potential of inward rectifier channel */
static double IRCON;					/* conductance of inward rectifier channel */
static double PEQ;					/* equilibrium potential of proctolin channel */
static double PCON;					/* conductance of proctolin channel */
static double CONDUCTANCE;				/* neuron membrane conductance */
static double LEAK;					/* neuron resting potential */
static double CAP;					/* neuron capacity */
static double TOD;					/* soma to dendrite conductance */
static double POTENTIAL;				/* neuron start potential */
static double DPOT;					/* dendrite start potential */
static double DCON;					/* dendrite membrane conductance */
static double DLEAK;					/* dendrite resting potential */
static double DCAP;					/* dendrite capacity */
static double TOS;					/* dendrite to soma conductance */
static double TT;					/* synaptic transmission time */
static double STRENGTH;					/* synaptic strength */
static double MAXSTR;					/* maximal synaptic conductance */
static double TRT;					/* synaptic transmitter release threshold */
static double TRS;					/* synaptic transmitter satiate threshold */
static double DSTART;					/* extern dendritic current start value */
static double DEND;					/* extern dendritic current end value */
static double DCUR;					/* extern dendritic current value */
static double SSTART;					/* extern somatic current start value */
static double SEND;					/* extern somatic current end value */
static double SCUR;					/* extern somatic current value */
static double SIMLEN;					/* simulation length */
static double SIMSIZE;					/* simulation step size */
static int NACTINT;					/* neuron activity interval */
static double SEQ;					/* synapse equilibrium potential for new synapse types */
static double NADUR;					/* sodium channel opening duration for on/off-model */
static double KDUR;					/* potassium channel opening duration for on/off-model */
static double CADUR;					/* calcium channel opening duration for on/off-model */
static double KSTART;					/* potassium channel start point for on/off-model */
static double CASTART;					/* sodium channel start point for on/off-model */
static double STH;					/* spike threshold for on/off-model */
static int REG;						/* region for extern dendritic current input */
static int LOC;						/* location of synapse during connecting neurons */
static int STYPE = 2;					/* synaptic type */
static int typeNum;					/* synaptic type number */
static Boolean NOISE;					/* flag for adding noise to soma */
static Boolean editFlag;				/* flag if network has been edited */

/****** functions ******/

/************************************************************************************************************************

 	FUNCTION	: create_popupMenu(parent)
 
	PURPOSE		: creates the popup menu in the drawing area reached with middle mouse button

	RETURNS		: nothing

************************************************************************************************************************/

void create_popupMenu(parent)
Widget parent;	/* widget id of parent widget */
{
	Arg args[10];		/* Arg List */
	Cardinal n;		/* Arg Count */
	XmString xmstrings[10]; /* temporary storage for XmStrings */
	Widget 	separator1,
		separator2,
		separator3;	/* widgets for internal use */

	/* create widgets */

	n = 0;
	XtSetArg(args[n], XmNmenuAccelerator, "<Key>F4"); n++;
	XtSetArg(args[n], XmNwhichButton, 2); n++;
	popupMenu = XmCreatePopupMenu ( parent, "popupMenu", args, n );

	n = 0;
	showNormalStateButton = XmCreatePushButton ( popupMenu, "showNormalStateButton", args, n );
	XtAddCallback(showNormalStateButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_NORMAL_STATE);

	n = 0;
	showTopologyButton = XmCreatePushButton ( popupMenu, "showTopologyButton", args, n );
	XtAddCallback(showTopologyButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_TOPOLOGY);

	n = 0;
	selectNeuronsButton = XmCreatePushButton ( popupMenu, "selectNeuronsButton", args, n );
	XtAddCallback(selectNeuronsButton, XmNactivateCallback, select_all_neurons_CB, (caddr_t *) NULL);

	n = 0;
	selectSynapsesButton = XmCreatePushButton ( popupMenu, "selectSynapsesButton", args, n );
	XtAddCallback(selectSynapsesButton, XmNactivateCallback, select_all_synapses_CB, (caddr_t *) NULL);

	n = 0;
	selectAxoSynapsesButton = XmCreatePushButton ( popupMenu, "selectAxoSynapsesButton", args, n );
	XtAddCallback(selectAxoSynapsesButton, XmNactivateCallback, select_all_axo_synapses_CB, (caddr_t *) NULL);

	n = 0;
	selectGraphsButton = XmCreatePushButton ( popupMenu, "selectGraphsButton", args, n );
	XtAddCallback(selectGraphsButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_ALL_GRAPHS);

	n = 0;
	separator1 = XmCreateSeparator( popupMenu, "separator1", args, n );

	n = 0;
	specifyObjectsButton = XmCreatePushButton ( popupMenu, "specifyObjectsButton", args, n );
	XtAddCallback(specifyObjectsButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_SPECIFY);

	n = 0;
	deleteObjectsButton = XmCreatePushButton ( popupMenu, "deleteObjectsButton", args, n );
	XtAddCallback(deleteObjectsButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_DELETE_OBJECTS);

	n = 0;
	editConnectionButton = XmCreatePushButton ( popupMenu, "editConnectionButton", args, n );
	XtAddCallback(editConnectionButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_SYNAPSE);

	n = 0;
	editAxoConnectionButton = XmCreatePushButton ( popupMenu, "editAxoConnectionButton", args, n );
	XtAddCallback(editAxoConnectionButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_AXO_SYNAPSE);

	n = 0;
	informationObjectButton = XmCreatePushButton ( popupMenu, "informationObjectButton", args, n );
	XtAddCallback(informationObjectButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_INFO);

	n = 0;
	separator2 = XmCreateSeparator( popupMenu, "separator2", args, n );

	n = 0;
	editChannelButton = XmCreatePushButton ( popupMenu, "editChannelButton", args, n );
	XtAddCallback(editChannelButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_SELECT_CHANNELS);

	n = 0;
	editNeuronButton = XmCreatePushButton ( popupMenu, "editNeuronButton", args, n );
	XtAddCallback(editNeuronButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_SELECT_NEURON);

	n = 0;
	editCurrentButton = XmCreatePushButton ( popupMenu, "editCurrentButton", args, n );
	XtAddCallback(editCurrentButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_SELECT_CURRENT);

	n = 0;
	connectObjectsButton = XmCreatePushButton ( popupMenu, "connectObjetctsButton", args, n );
	XtAddCallback(connectObjectsButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_CONNECT_OBJECTS);

	n = 0;
	separator3 = XmCreateSeparator( popupMenu, "separator3", args, n );

	n = 0;
	attachWindowButton = XmCreatePushButton ( popupMenu, "attachWindowButton", args, n );
	XtAddCallback(attachWindowButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_NEW_GRAPH);

	n = 0;
	attachWindowSButton = XmCreatePushButton ( popupMenu, "attachWindowSButton", args, n );
	XtAddCallback(attachWindowSButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_NEW_GRAPHS);

	n = 0;
	showInputNeuronsButton = XmCreatePushButton ( popupMenu, "showInputNeuronButton", args, n );
	XtAddCallback(showInputNeuronsButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_INPUT_NEURONS);

	n = 0;
	showOutputNeuronsButton = XmCreatePushButton ( popupMenu, "showOutputNeuronButton", args, n );
	XtAddCallback(showOutputNeuronsButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_OUTPUT_NEURONS);

	n = 0;
	showInputOutputNeuronsButton = XmCreatePushButton ( popupMenu, "showInputOutputNeuronButton", args, n );
	XtAddCallback(showInputOutputNeuronsButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_INPUT_OUTPUT_NEURONS);

	/* manage widgets */

	XtManageChild(showNormalStateButton);
	XtManageChild(showTopologyButton);
	XtManageChild(selectNeuronsButton);
	XtManageChild(selectSynapsesButton);
	XtManageChild(selectAxoSynapsesButton);
	XtManageChild(selectGraphsButton);
	XtManageChild(separator1);
	XtManageChild(specifyObjectsButton);
	XtManageChild(deleteObjectsButton);
	XtManageChild(editChannelButton);
	XtManageChild(informationObjectButton);
	XtManageChild(separator2);
	XtManageChild(editNeuronButton);
	XtManageChild(editCurrentButton);
	XtManageChild(editConnectionButton);
	XtManageChild(editAxoConnectionButton);
	XtManageChild(connectObjectsButton);
	XtManageChild(separator3);
	XtManageChild(attachWindowButton);
	XtManageChild(attachWindowSButton);
	XtManageChild(showInputNeuronsButton);
	XtManageChild(showOutputNeuronsButton);
	XtManageChild(showInputOutputNeuronsButton);

	/* attach widgets */

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(showNormalStateString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( showNormalStateButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(showTopologyString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, showNormalStateButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( showTopologyButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(selectAllNeuronsString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, showTopologyButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( selectNeuronsButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(selectAllSynapsesString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, selectNeuronsButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( selectSynapsesButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(selectAllAxoSynapsesString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, selectSynapsesButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( selectAxoSynapsesButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(selectAllGraphsString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, selectAxoSynapsesButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( selectGraphsButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, selectGraphsButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( separator1,args, n );

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(specifyObjectsString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, separator1); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( specifyObjectsButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(deleteObjectsString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, specifyObjectsButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( deleteObjectsButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(editConnectionString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, deleteObjectsButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( editConnectionButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(editAxoConnectionString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, editConnectionButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( editAxoConnectionButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(informationObjectString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, editAxoConnectionButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( informationObjectButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, informationObjectButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( separator2,args, n );

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(channelParamString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, separator2); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( editChannelButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(neuronParamString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, editChannelButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( editNeuronButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(currentParamString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, editNeuronButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( editCurrentButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(connectObjectsString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, editCurrentButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( connectObjectsButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, connectObjectsButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( separator3,args, n );

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(attachWindowString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, separator3); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( attachWindowButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(attachWindowSString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, attachWindowButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( attachWindowSButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(showInputNeuronsString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, attachWindowSButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( showInputNeuronsButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(showOutputNeuronsString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, showInputNeuronsButton); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( showOutputNeuronsButton,args, n );
	XmStringFree(xmstrings[0]);

	n = 0;
	xmstrings[0] = XmStringCreateLtoR(showInputOutputNeuronsString, defaultFont);
	XtSetArg(args[n], XmNlabelString, xmstrings[0]); n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, showOutputNeuronsButton); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_NONE); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
	XtSetValues ( showInputOutputNeuronsButton,args, n );
	XmStringFree(xmstrings[0]);

} /* end of create_popupMenu */

/************************************************************************************************************************

 	FUNCTION	: create_infoObject( parent )
 
	PURPOSE		: creates information box about selected object

	RETURNS		: nothing

************************************************************************************************************************/

void create_infoObject( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget children[3];      	/* Children to manage */
	Arg al[64];           		/* Arg List */
	register int ac = 0;      	/* Arg Count */
	XmString xmstrings[10];    	/* temporary storage for XmStrings */
	Widget	infoObject,
		infoObjectForm,
		infoObjectScrolledText,
		infoObjectSeparator,
		infoObjectOkButton;	/* used for internal use */

	XtSetArg(al[ac], XmNtitle, informationObjectString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	infoObject = XmCreateDialogShell ( parent, "infoObject", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	infoObjectBB = XmCreateBulletinBoard ( infoObject, "infoObjectBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	infoObjectForm = XmCreateForm ( infoObjectBB, "infoObjectForm", al, ac );
	XmAddTabGroup(infoObjectForm);

	ac = 0;
	XtSetArg(al[ac], XmNeditMode, XmMULTI_LINE_EDIT); ac++;
	XtSetArg(al[ac], XmNcolumns, 80); ac++;
	XtSetArg(al[ac], XmNrows, 25); ac++;
	XtSetArg(al[ac], XmNautoShowCursorPosition, FALSE); ac++;
	XtSetArg(al[ac], XmNeditable, FALSE); ac++;
	XtSetArg(al[ac], XmNcursorPositionVisible, FALSE); ac++;
	infoObjectText = XmCreateScrolledText ( infoObjectForm, "infoObjectScrolledText", al, ac );

	infoObjectScrolledText = XtParent ( infoObjectText );

	ac = 0;
	infoObjectSeparator = XmCreateSeparator ( infoObjectForm, "infoObjectSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	infoObjectOkButton = XmCreatePushButton ( infoObjectForm, "infoObjectOkButton", al, ac );

	XmStringFree ( xmstrings [ 0 ] );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( infoObjectScrolledText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, infoObjectScrolledText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( infoObjectSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, infoObjectSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( infoObjectOkButton,al, ac );

	XtManageChild(infoObjectText);

	XtAddCallback (infoObjectOkButton,XmNactivateCallback, unmanage_link_CB, (caddr_t *) &infoObjectBB);
	XtAddCallback (infoObjectOkButton,XmNactivateCallback, remove_selected_objects_from_selectionList_CB,
		(caddr_t *) &infoObjectBB);

	ac = 0;
	children[ac++] = infoObjectSeparator;
	children[ac++] = infoObjectOkButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = infoObjectForm;
	XtManageChildren(children, ac);

} /* end of create_infoObject */

/************************************************************************************************************************

 	FUNCTION	: create_onOffParams( parent )
 
	PURPOSE		: creates dialog box for ion channel parameters of on/off-model

	RETURNS		: nothing

************************************************************************************************************************/

void create_onOffParams( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	onOffParams,
		onOffParamsForm,
		onOffParamsNaChannelLabel,
		onOffParamsNaEqPotLabel,
		onOffParamsNaConductanceLabel,
		onOffParamsNaDurLabel,
		onOffParamsSeparator,
		onOffParamsKChannelLabel,
		onOffParamsKEqPotLabel,
		onOffParamsKStartLabel,
		onOffParamsKConductanceLabel,
		onOffParamsKDurLabel,
		onOffParamsSeparator2,
		onOffParamsCaChannelLabel,
		onOffParamsCaEqPotLabel,
		onOffParamsCaStartLabel,
		onOffParamsCaConductanceLabel,
		onOffParamsCaDurLabel,
		onOffParamsSeparator3,
		onOffParamsOkButton,
		onOffParamsCancelButton,
		onOffParamsHelpButton,
		onOffParamsSpikeThresholdLabel,
		onOffParamsNaEqPotDef,
		onOffParamsSpikeThresholdDef,
		onOffParamsNaConductanceDef,
		onOffParamsNaDurDef,
		onOffParamsKEqPotDef,
		onOffParamsKStartDef,
		onOffParamsKConducutanceDef,
		onOffParamsKDurDef,
		onOffParamsCaEqPotDef,
		onOffParamsCaStartDef,
		onOffParamsCaConductanceDef,
		onOffParamsCaDurDef; /* widgets for internal use */

	Widget children[57];    /* Children to manage */
	Arg al[64];           	/* Arg List */
	register int ac = 0;    /* Arg Count */
	XmString xmstrings[10]; /* temporary storage for XmStrings */

	/* create widgets */

	XtSetArg(al[ac], XmNtitle, ionChannelParamString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	onOffParams = XmCreateDialogShell ( parent, "onOffParams", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	onOffParamsBB = XmCreateBulletinBoard ( onOffParams, "onOffParamsBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsForm = XmCreateForm ( onOffParamsBB, "onOffParamsForm", al, ac );
	XmAddTabGroup(onOffParamsForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(naChannelParamString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsNaChannelLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsNaChannelLabel", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(sodiumEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsNaEqPotLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsNaEqPotLabel", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsNaEqPotText = XmCreateText ( onOffParamsForm, "onOffParamsNaEqPotText", al, ac );

	XmAddTabGroup(onOffParamsNaEqPotText);
	XtAddCallback(onOffParamsNaEqPotText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_ONOFF_NAEQ);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) NAEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) NAEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) NAEQ_MIN); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsNaEqPotScale = XmCreateScale ( onOffParamsForm, "onOffParamsNaEqPotScale", al, ac );

	XmAddTabGroup(onOffParamsNaEqPotScale);
	XtAddCallback(onOffParamsNaEqPotScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_NAEQ);
	XtAddCallback(onOffParamsNaEqPotScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_NAEQ);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsNaEqPotDef = XmCreatePushButton ( onOffParamsForm, "onOffParamsNaEqPotDef", al, ac );

	XtAddCallback(onOffParamsNaEqPotDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_ONOFF_NAEQ);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(spikeThresholdString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsSpikeThresholdLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsSpikeThresholdLabel", al, ac);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsSpikeThresholdText = XmCreateText ( onOffParamsForm, "onOffParamsSpikeThresholdText", al, ac );

	XmAddTabGroup(onOffParamsSpikeThresholdText);
	XtAddCallback(onOffParamsSpikeThresholdText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_ONOFF_STH);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) STH_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) STH_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) STH_MIN); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsSpikeThresholdScale = XmCreateScale ( onOffParamsForm, "onOffParamsSpikeThresholdScale", al, ac);

	XmAddTabGroup(onOffParamsSpikeThresholdScale);
	XtAddCallback(onOffParamsSpikeThresholdScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_STH);
	XtAddCallback(onOffParamsSpikeThresholdScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_STH);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsSpikeThresholdDef = XmCreatePushButton ( onOffParamsForm, "onOffParamsSpikeThresholdDef", al, ac);

	XtAddCallback(onOffParamsSpikeThresholdDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_ONOFF_STH);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(sodiumConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsNaConductanceLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsNaConductanceLabel", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsNaConductanceText = XmCreateText ( onOffParamsForm, "onOffParamsNaConductanceText", al, ac );

	XmAddTabGroup(onOffParamsNaConductanceText);
	XtAddCallback(onOffParamsNaConductanceText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_ONOFF_NACON);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) NACON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) NACON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) NACON_MIN); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsNaConductanceScale = XmCreateScale ( onOffParamsForm, "onOffParamsNaConductanceScale", al, ac );

	XmAddTabGroup(onOffParamsNaConductanceScale);
	XtAddCallback(onOffParamsNaConductanceScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_NACON);
	XtAddCallback(onOffParamsNaConductanceScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_NACON);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsNaConductanceDef = XmCreatePushButton ( onOffParamsForm, "onOffParamsNaConductanceDef", al, ac );

	XtAddCallback(onOffParamsNaConductanceDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_ONOFF_NACON);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(naChannelOpenDurString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsNaDurLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsNaDurLabel", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsNaDurText = XmCreateText ( onOffParamsForm, "onOffParamsNaDurText", al, ac );

	XmAddTabGroup(onOffParamsNaDurText);
	XtAddCallback(onOffParamsNaDurText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_ONOFF_NADUR);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) NADUR_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) NADUR_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) NADUR_MIN * 100); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsNaDurScale = XmCreateScale ( onOffParamsForm, "onOffParamsNaDurScale", al, ac );

	XmAddTabGroup(onOffParamsNaDurScale);
	XtAddCallback(onOffParamsNaDurScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_NADUR);
	XtAddCallback(onOffParamsNaDurScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_NADUR);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsNaDurDef = XmCreatePushButton ( onOffParamsForm, "onOffParamsNaDurDef", al, ac );

	XtAddCallback(onOffParamsNaDurDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_ONOFF_NADUR);

	ac = 0;
	onOffParamsSeparator = XmCreateSeparator ( onOffParamsForm, "onOffParamsSeparator", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(kChannelParamString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsKChannelLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsKChannelLabel", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(potassiumEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsKEqPotLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsKEqPotLabel", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsKEqPotText = XmCreateText ( onOffParamsForm, "onOffParamsKEqPotText", al, ac );

	XmAddTabGroup(onOffParamsKEqPotText);
	XtAddCallback(onOffParamsKEqPotText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_ONOFF_KEQ);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) KEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) KEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) KEQ_MIN); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsKEqPotScale = XmCreateScale ( onOffParamsForm, "onOffParamsKEqPotScale", al, ac );

	XmAddTabGroup(onOffParamsKEqPotScale);
	XtAddCallback(onOffParamsKEqPotScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_KEQ);
	XtAddCallback(onOffParamsKEqPotScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_KEQ);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsKEqPotDef = XmCreatePushButton ( onOffParamsForm, "onOffParamsKEqPotDef", al, ac );

	XtAddCallback(onOffParamsKEqPotDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_ONOFF_KEQ);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(kChannelStartString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsKStartLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsKStartLabel", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsKStartText = XmCreateText ( onOffParamsForm, "onOffParamsKStartText", al, ac );

	XmAddTabGroup(onOffParamsKStartText);
	XtAddCallback(onOffParamsKStartText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_ONOFF_KSTART);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) KSTART_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) KSTART_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) KSTART_MIN * 100); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsKStartScale = XmCreateScale ( onOffParamsForm, "onOffParamsKStartScale", al, ac );

	XmAddTabGroup(onOffParamsKStartScale);
	XtAddCallback(onOffParamsKStartScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_KSTART);
	XtAddCallback(onOffParamsKStartScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_KSTART);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsKStartDef = XmCreatePushButton ( onOffParamsForm, "onOffParamsKStartDef", al, ac );

	XtAddCallback(onOffParamsKStartDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_ONOFF_KSTART);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(potassiumConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsKConductanceLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsKConductanceLabel", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsKConductanceText = XmCreateText ( onOffParamsForm, "onOffParamsKConductanceText", al, ac );

	XmAddTabGroup(onOffParamsKConductanceText);
	XtAddCallback(onOffParamsKConductanceText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_ONOFF_KCON);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) KCON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) KCON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) KCON_MIN); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsKConductanceScale = XmCreateScale ( onOffParamsForm, "onOffParamsKConductanceScale", al, ac );

	XmAddTabGroup(onOffParamsKConductanceScale);
	XtAddCallback(onOffParamsKConductanceScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_KCON);
	XtAddCallback(onOffParamsKConductanceScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_KCON);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsKConducutanceDef = XmCreatePushButton ( onOffParamsForm, "onOffParamsKConducutanceDef", al, ac );

	XtAddCallback(onOffParamsKConducutanceDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_ONOFF_KCON);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(kChannelOpenDurString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsKDurLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsKDurLabel", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsKDurText = XmCreateText ( onOffParamsForm, "onOffParamsKDurText", al, ac );

	XmAddTabGroup(onOffParamsKDurText);
	XtAddCallback(onOffParamsKDurText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_ONOFF_KDUR);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) KDUR_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) KDUR_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) KDUR_MIN * 100); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsKDurScale = XmCreateScale ( onOffParamsForm, "onOffParamsKDurScale", al, ac );

	XmAddTabGroup(onOffParamsKDurScale);
	XtAddCallback(onOffParamsKDurScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_KDUR);
	XtAddCallback(onOffParamsKDurScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_KDUR);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsKDurDef = XmCreatePushButton ( onOffParamsForm, "onOffParamsKDurDef", al, ac );

	XtAddCallback(onOffParamsKDurDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_ONOFF_KDUR);

	ac = 0;
	onOffParamsSeparator2 = XmCreateSeparator ( onOffParamsForm, "onOffParamsSeparator2", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(caChannelParamString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsCaChannelLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsCaChannelLabel", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(calciumEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsCaEqPotLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsCaEqPotLabel", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsCaEqPotText = XmCreateText ( onOffParamsForm, "onOffParamsCaEqPotText", al, ac );

	XmAddTabGroup(onOffParamsCaEqPotText);
	XtAddCallback(onOffParamsCaEqPotText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_ONOFF_CAEQ);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) CAEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) CAEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) CAEQ_MIN); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsCaEqPotScale = XmCreateScale ( onOffParamsForm, "onOffParamsCaEqPotScale", al, ac );

	XmAddTabGroup(onOffParamsCaEqPotScale);
	XtAddCallback(onOffParamsCaEqPotScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_CAEQ);
	XtAddCallback(onOffParamsCaEqPotScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_CAEQ);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsCaEqPotDef = XmCreatePushButton ( onOffParamsForm, "onOffParamsCaEqPotDef", al, ac );

	XtAddCallback(onOffParamsCaEqPotDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_ONOFF_CAEQ);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(caChannelStartString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsCaStartLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsCaStartLabel", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsCaStartText = XmCreateText ( onOffParamsForm, "onOffParamsCaStartText", al, ac );

	XmAddTabGroup(onOffParamsCaStartText);
	XtAddCallback(onOffParamsCaStartText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_ONOFF_CASTART);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) CASTART_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) CASTART_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) CASTART_MIN); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsCaStartScale = XmCreateScale ( onOffParamsForm, "onOffParamsCaStartScale", al, ac );

	XmAddTabGroup(onOffParamsCaStartScale);
	XtAddCallback(onOffParamsCaStartScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_CASTART);
	XtAddCallback(onOffParamsCaStartScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_CASTART);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsCaStartDef = XmCreatePushButton ( onOffParamsForm, "onOffParamsCaStartDef", al, ac );

	XtAddCallback(onOffParamsCaStartDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_ONOFF_CASTART);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(calciumConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsCaConductanceLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsCaConductanceLabel", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsCaConductanceText = XmCreateText ( onOffParamsForm, "onOffParamsCaConductanceText", al, ac );

	XmAddTabGroup(onOffParamsCaConductanceText);
	XtAddCallback(onOffParamsCaConductanceText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_ONOFF_CACON);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) CACON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) CACON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) CACON_MIN); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsCaConductanceScale = XmCreateScale ( onOffParamsForm, "onOffParamsCaConductanceScale", al, ac );

	XmAddTabGroup(onOffParamsCaConductanceScale);
	XtAddCallback(onOffParamsCaConductanceScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_CACON);
	XtAddCallback(onOffParamsCaConductanceScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_CACON);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsCaConductanceDef = XmCreatePushButton ( onOffParamsForm, "onOffParamsCaConductanceDef", al, ac );

	XtAddCallback(onOffParamsCaConductanceDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_ONOFF_CACON);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(caChannelOpenDurString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	onOffParamsCaDurLabel = XmCreateLabel ( onOffParamsForm, "onOffParamsCaDurLabel", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsCaDurText = XmCreateText ( onOffParamsForm, "onOffParamsCaDurText", al, ac );

	XmAddTabGroup(onOffParamsCaDurText);
	XtAddCallback(onOffParamsCaDurText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_ONOFF_CADUR);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) CADUR_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) CADUR_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) CADUR_MIN * 100); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsCaDurScale = XmCreateScale ( onOffParamsForm, "onOffParamsCaDurScale", al, ac );

	XmAddTabGroup(onOffParamsCaDurScale);
	XtAddCallback(onOffParamsCaDurScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_CADUR);
	XtAddCallback(onOffParamsCaDurScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_ONOFF_CADUR);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsCaDurDef = XmCreatePushButton ( onOffParamsForm, "onOffParamsCaDurDef", al, ac );
	XtAddCallback(onOffParamsCaDurDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_ONOFF_CADUR);

	ac = 0;
	onOffParamsSeparator3 = XmCreateSeparator ( onOffParamsForm, "onOffParamsSeparator3", al, ac );

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsOkButton = XmCreatePushButton ( onOffParamsForm, "onOffParamsOkButton", al, ac );

	XtAddCallback(onOffParamsOkButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_ONOFF_CHANNELS);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsCancelButton = XmCreatePushButton ( onOffParamsForm, "onOffParamsCancelButton", al, ac );

	XtAddCallback(onOffParamsCancelButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &onOffParamsBB);
	XtAddCallback(onOffParamsCancelButton, XmNactivateCallback, remove_selected_objects_from_selectionList_CB,
	    (caddr_t *) DIALOG_ONOFF_CHANNELS);

	ac = 0;
	XmStringFree ( xmstrings [ 0 ] );
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	onOffParamsHelpButton = XmCreatePushButton ( onOffParamsForm, "onOffParamsHelpButton", al, ac );

	XtAddCallback(onOffParamsHelpButton, XmNactivateCallback, dialog_help2_CB, (caddr_t *) DIALOG_ONOFF_CHANNELS);

	XmStringFree ( xmstrings [ 0 ] );

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsNaChannelLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaChannelLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsNaEqPotLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaEqPotLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaEqPotLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsNaEqPotText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaEqPotText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsNaConductanceLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaConductanceLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaEqPotText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsNaConductanceText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaConductanceDef); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 15); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaConductanceDef); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsNaDurLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaDurLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaDurLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsNaDurText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaConductanceText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( onOffParamsSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKChannelLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKChannelLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKEqPotLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKEqPotLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaConductanceText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKEqPotText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKEqPotDef); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 15); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKEqPotDef); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKStartLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKStartLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaDurText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKStartText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKEqPotText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKConductanceLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKConductanceLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKEqPotText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKConductanceText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKConducutanceDef); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 15); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKConducutanceDef); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKDurLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKDurLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKStartText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKDurText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKConductanceText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsSeparator2,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsSeparator2); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaChannelLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaChannelLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaEqPotLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaEqPotLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKConductanceText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaEqPotText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaEqPotDef); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 15); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsCaEqPotDef); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaStartLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaStartLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKDurText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaStartText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaEqPotText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaConductanceLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaConductanceLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsCaEqPotText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaConductanceText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaConductanceDef); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 15); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsCaConductanceDef); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaDurLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaDurLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsCaStartText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaDurText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaConductanceText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( onOffParamsSeparator3,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsSeparator3); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsSeparator3); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
        XtSetValues ( onOffParamsCancelButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsSeparator3); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( onOffParamsHelpButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaEqPotText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaEqPotText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsNaEqPotScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaEqPotScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaEqPotScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsNaEqPotDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaEqPotDef); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 15); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaEqPotDef); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsSpikeThresholdLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsSpikeThresholdLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaDurText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsSpikeThresholdText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsSpikeThresholdText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsSpikeThresholdText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsSpikeThresholdScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsSpikeThresholdScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsSpikeThresholdScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsSpikeThresholdDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaConductanceText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaConductanceText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsNaConductanceScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaConductanceScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaConductanceScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsNaConductanceDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaDurText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaDurText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsNaDurScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsNaDurScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsNaDurScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsNaDurDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKEqPotText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKEqPotText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKEqPotScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKEqPotScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKEqPotScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKEqPotDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKStartText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKStartText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKStartScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKStartScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKStartScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKStartDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKConductanceText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKConductanceText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKConductanceScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKConductanceScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKConductanceScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKConducutanceDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKDurText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKDurText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKDurScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsKDurScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsKDurScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsKDurDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaEqPotText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsCaEqPotText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaEqPotScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaEqPotScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsCaEqPotScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaEqPotDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaStartText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsCaStartText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaStartScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaStartScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsCaStartScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaStartDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaConductanceText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsCaConductanceText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaConductanceScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaConductanceScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsCaConductanceScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaConductanceDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaDurText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsCaDurText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaDurScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, onOffParamsCaDurScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, onOffParamsCaDurScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( onOffParamsCaDurDef,al, ac );

	ac = 0;
	children[ac++] = onOffParamsNaChannelLabel;
	children[ac++] = onOffParamsNaEqPotLabel;
	children[ac++] = onOffParamsNaEqPotText;
	children[ac++] = onOffParamsNaConductanceLabel;
	children[ac++] = onOffParamsNaConductanceText;
	children[ac++] = onOffParamsNaDurLabel;
	children[ac++] = onOffParamsNaDurText;
	children[ac++] = onOffParamsSeparator;
	children[ac++] = onOffParamsKChannelLabel;
	children[ac++] = onOffParamsKEqPotLabel;
	children[ac++] = onOffParamsKEqPotText;
	children[ac++] = onOffParamsKStartLabel;
	children[ac++] = onOffParamsKStartText;
	children[ac++] = onOffParamsKConductanceLabel;
	children[ac++] = onOffParamsKConductanceText;
	children[ac++] = onOffParamsKDurLabel;
	children[ac++] = onOffParamsKDurText;
	children[ac++] = onOffParamsSeparator2;
	children[ac++] = onOffParamsCaChannelLabel;
	children[ac++] = onOffParamsCaEqPotLabel;
	children[ac++] = onOffParamsCaEqPotText;
	children[ac++] = onOffParamsCaStartLabel;
	children[ac++] = onOffParamsCaStartText;
	children[ac++] = onOffParamsCaConductanceLabel;
	children[ac++] = onOffParamsCaConductanceText;
	children[ac++] = onOffParamsCaDurLabel;
	children[ac++] = onOffParamsCaDurText;
	children[ac++] = onOffParamsSeparator3;
	children[ac++] = onOffParamsOkButton;
	children[ac++] = onOffParamsCancelButton;
	children[ac++] = onOffParamsHelpButton;
	children[ac++] = onOffParamsNaEqPotScale;
	children[ac++] = onOffParamsNaEqPotDef;
	children[ac++] = onOffParamsSpikeThresholdLabel;
	children[ac++] = onOffParamsSpikeThresholdText;
	children[ac++] = onOffParamsSpikeThresholdScale;
	children[ac++] = onOffParamsSpikeThresholdDef;
	children[ac++] = onOffParamsNaConductanceScale;
	children[ac++] = onOffParamsNaConductanceDef;
	children[ac++] = onOffParamsNaDurScale;
	children[ac++] = onOffParamsNaDurDef;
	children[ac++] = onOffParamsKEqPotScale;
	children[ac++] = onOffParamsKEqPotDef;
	children[ac++] = onOffParamsKStartScale;
	children[ac++] = onOffParamsKStartDef;
	children[ac++] = onOffParamsKConductanceScale;
	children[ac++] = onOffParamsKConducutanceDef;
	children[ac++] = onOffParamsKDurScale;
	children[ac++] = onOffParamsKDurDef;
	children[ac++] = onOffParamsCaEqPotScale;
	children[ac++] = onOffParamsCaEqPotDef;
	children[ac++] = onOffParamsCaStartScale;
	children[ac++] = onOffParamsCaStartDef;
	children[ac++] = onOffParamsCaConductanceScale;
	children[ac++] = onOffParamsCaConductanceDef;
	children[ac++] = onOffParamsCaDurScale;
	children[ac++] = onOffParamsCaDurDef;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = onOffParamsForm;
	XtManageChildren(children, ac);

} /* end of create_onOffParams */

/************************************************************************************************************************

 	FUNCTION	: create_swimParams( parent )
 
	PURPOSE		: creates dialog box for edit SWIM channels of neurons

	RETURNS		: nothing

************************************************************************************************************************/

void create_swimParams( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	swimParams,
		swimParamsForm,
		swimParamsNaEqLabel,
		swimParamsNaConLabel,
		swimParamsKEqLabel,
		swimParamsKConLabel,
		swimParamsCaEqLabel,
		swimParamsCaConLabel,
		swimParamsSeparator,
		swimParamsOkButton,
		swimParamsNoButton,
		swimParamsHelpButton,
		swimParamsNaEqDef,
		swimParamsNaConDef,
		swimParamsKEqDef,
		swimParamsKConDef,
		swimParamsCaEqDef,
		swimParamsCaConDef,
		swimParamsSpikeThresholdLabel,
		swimParamsSpikeThresholdDef;	/* widgets for internal use */

	Widget children[32];    /* Children to manage */
	Arg al[25];      	/* Arg List */
	register int ac; 	/* Arg Count */
	XmString xmstrings[10];	/* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	XtSetArg(al[ac], XmNtitle, editChannelString); ac++;
	swimParams = XmCreateDialogShell ( parent, "swimParams", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	swimParamsBB = XmCreateBulletinBoard ( swimParams, "swimParamsBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsForm = XmCreateForm ( swimParamsBB, "swimParamsForm", al, ac );
	XmAddTabGroup(swimParamsForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(sodiumEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	swimParamsNaEqLabel = XmCreateLabel ( swimParamsForm, "swimParamsNaEqLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsNaEqText = XmCreateText ( swimParamsForm, "swimParamsNaEqText", al, ac );

	XmAddTabGroup(swimParamsNaEqText);
	XtAddCallback(swimParamsNaEqText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_SWIM_NAEQ);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) NAEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) NAEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) NAEQ_MIN); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsNaEqScale = XmCreateScale ( swimParamsForm, "swimParamsNaEqScale", al, ac );

	XmAddTabGroup(swimParamsNaEqScale);
	XtAddCallback(swimParamsNaEqScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_NAEQ);
	XtAddCallback(swimParamsNaEqScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_NAEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsNaEqDef = XmCreatePushButton ( swimParamsForm, "swimParamsNaEqDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(swimParamsNaEqDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_SWIM_NAEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(sodiumConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	swimParamsNaConLabel = XmCreateLabel ( swimParamsForm, "swimParamsNaConLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsNaConText = XmCreateText ( swimParamsForm, "swimParamsNaConText", al, ac );

	XmAddTabGroup(swimParamsNaConText);
	XtAddCallback(swimParamsNaConText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_SWIM_NACON);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) NACON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) NACON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) NACON_MIN); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsNaConScale = XmCreateScale ( swimParamsForm, "swimParamsNaConScale", al, ac );

	XmAddTabGroup(swimParamsNaConScale);
	XtAddCallback(swimParamsNaConScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_NACON);
	XtAddCallback(swimParamsNaConScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_NACON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsNaConDef = XmCreatePushButton ( swimParamsForm, "swimParamsNaConDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(swimParamsNaConDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_SWIM_NACON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(potassiumEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	swimParamsKEqLabel = XmCreateLabel ( swimParamsForm, "swimParamsKEqLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsKEqText = XmCreateText ( swimParamsForm, "swimParamsKEqText", al, ac );

	XmAddTabGroup(swimParamsKEqText);
	XtAddCallback(swimParamsKEqText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_SWIM_KEQ);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) KEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) KEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) KEQ_MIN); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsKEqScale = XmCreateScale ( swimParamsForm, "swimParamsKEqScale", al, ac );

	XmAddTabGroup(swimParamsKEqScale);
	XtAddCallback(swimParamsKEqScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_KEQ);
	XtAddCallback(swimParamsKEqScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_KEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsKEqDef = XmCreatePushButton ( swimParamsForm, "swimParamsKEqDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(swimParamsKEqDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_SWIM_KEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(potassiumConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	swimParamsKConLabel = XmCreateLabel ( swimParamsForm, "swimParamsKConLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsKConText = XmCreateText ( swimParamsForm, "swimParamsKConText", al, ac );

	XmAddTabGroup(swimParamsKConText);
	XtAddCallback(swimParamsKConText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_SWIM_KCON);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) KCON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) KCON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) KCON_MIN); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsKConScale = XmCreateScale ( swimParamsForm, "swimParamsKConScale", al, ac );

	XmAddTabGroup(swimParamsKConScale);
	XtAddCallback(swimParamsKConScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_KCON);
	XtAddCallback(swimParamsKConScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_KCON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsKConDef = XmCreatePushButton ( swimParamsForm, "swimParamsKConDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(swimParamsKConDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_SWIM_KCON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(calciumEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	swimParamsCaEqLabel = XmCreateLabel ( swimParamsForm, "swimParamsCaEqLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsCaEqText = XmCreateText ( swimParamsForm, "swimParamsCaEqText", al, ac );

	XmAddTabGroup(swimParamsCaEqText);
	XtAddCallback(swimParamsCaEqText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_SWIM_CAEQ);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) CAEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) CAEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) CAEQ_MIN); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsCaEqScale = XmCreateScale ( swimParamsForm, "swimParamsCaEqScale", al, ac );

	XmAddTabGroup(swimParamsCaEqScale);
	XtAddCallback(swimParamsCaEqScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_CAEQ);
	XtAddCallback(swimParamsCaEqScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_CAEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsCaEqDef = XmCreatePushButton ( swimParamsForm, "swimParamsCaEqDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(swimParamsCaEqDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_SWIM_CAEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(calciumConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	swimParamsCaConLabel = XmCreateLabel ( swimParamsForm, "swimParamsCaConLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsCaConText = XmCreateText ( swimParamsForm, "swimParamsCaConText", al, ac );

	XmAddTabGroup(swimParamsCaConText);
	XtAddCallback(swimParamsCaConText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_SWIM_CACON);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) CACON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) CACON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) CACON_MIN); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsCaConScale = XmCreateScale ( swimParamsForm, "swimParamsCaConScale", al, ac );

	XmAddTabGroup(swimParamsCaConScale);
	XtAddCallback(swimParamsCaConScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_CACON);
	XtAddCallback(swimParamsCaConScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_CACON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsCaConDef = XmCreatePushButton ( swimParamsForm, "swimParamsCaConDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(swimParamsCaConDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_SWIM_CACON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(spikeThresholdString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	swimParamsSpikeThresholdLabel = XmCreateLabel ( swimParamsForm, "swimParamsSpikeThresholdLabel", al, ac);
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsSpikeThresholdText = XmCreateText ( swimParamsForm, "swimParamsSpikeThresholdText", al, ac );

	XmAddTabGroup(swimParamsSpikeThresholdText);
	XtAddCallback(swimParamsSpikeThresholdText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_SWIM_STH);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) STH_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) STH_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) STH_MIN); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsSpikeThresholdScale = XmCreateScale ( swimParamsForm, "swimParamsSpikeThresholdScale", al, ac);

	XmAddTabGroup(swimParamsSpikeThresholdScale);
	XtAddCallback(swimParamsSpikeThresholdScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_STH);
	XtAddCallback(swimParamsSpikeThresholdScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SWIM_STH);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsSpikeThresholdDef = XmCreatePushButton ( swimParamsForm, "swimParamsSpikeThresholdDef", al, ac);
	XmStringFree(xmstrings[0]);

	XtAddCallback(swimParamsSpikeThresholdDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_SWIM_STH);

	ac = 0;
	swimParamsSeparator = XmCreateSeparator ( swimParamsForm, "swimParamsSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsOkButton = XmCreatePushButton ( swimParamsForm, "swimParamsOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(swimParamsOkButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_SWIM_CHANNELS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsNoButton = XmCreatePushButton ( swimParamsForm, "swimParamsNoButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(swimParamsNoButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &swimParamsBB);
	XtAddCallback(swimParamsNoButton, XmNactivateCallback, remove_selected_objects_from_selectionList_CB,
		(caddr_t *) DIALOG_SWIM_CHANNELS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	swimParamsHelpButton = XmCreatePushButton ( swimParamsForm, "swimParamsHelpButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(swimParamsHelpButton, XmNactivateCallback, dialog_help2_CB, (caddr_t *) DIALOG_SWIM_CHANNELS);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsNaEqLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsNaEqLabel); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsNaEqText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsNaEqText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsNaEqScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsNaEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsNaConLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsNaConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsNaEqText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsNaConText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsNaConText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsNaConText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsNaConScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 30); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsNaConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsKEqLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsKEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsNaConText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsKEqText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsKEqText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsKEqText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsKEqScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsKEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsKConLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsKConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsKEqText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsKConText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsKConText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsKConText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsKConScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 30); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsKConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsCaEqLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsCaEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsKConText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsCaEqText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsCaEqText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsCaEqText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsCaEqScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsCaEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsCaConLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsCaConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsCaEqText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsCaConText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsCaConText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsCaConText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsCaConScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsSpikeThresholdText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
        XtSetValues ( swimParamsNoButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( swimParamsHelpButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsNaEqScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsNaEqDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsNaConScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsNaConScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsNaConDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsKEqScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsKEqScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsKEqDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsKConScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsKConScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsKConDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsCaEqScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsCaEqScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsCaEqDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsCaConScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsCaConScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsCaConDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 30); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsCaConLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsSpikeThresholdLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsSpikeThresholdLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsCaEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsSpikeThresholdText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsSpikeThresholdText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsSpikeThresholdText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsSpikeThresholdScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, swimParamsSpikeThresholdScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, swimParamsSpikeThresholdScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( swimParamsSpikeThresholdDef,al, ac );

	/* manage widgets */

	ac = 0;
	children[ac++] = swimParamsNaEqLabel;
	children[ac++] = swimParamsNaEqText;
	children[ac++] = swimParamsNaEqScale;
	children[ac++] = swimParamsNaConLabel;
	children[ac++] = swimParamsNaConText;
	children[ac++] = swimParamsNaConScale;
	children[ac++] = swimParamsKEqLabel;
	children[ac++] = swimParamsKEqText;
	children[ac++] = swimParamsKEqScale;
	children[ac++] = swimParamsKConLabel;
	children[ac++] = swimParamsKConText;
	children[ac++] = swimParamsKConScale;
	children[ac++] = swimParamsCaEqLabel;
	children[ac++] = swimParamsCaEqText;
	children[ac++] = swimParamsCaEqScale;
	children[ac++] = swimParamsCaConLabel;
	children[ac++] = swimParamsCaConText;
	children[ac++] = swimParamsCaConScale;
	children[ac++] = swimParamsSeparator;
	children[ac++] = swimParamsOkButton;
	children[ac++] = swimParamsNoButton;
	children[ac++] = swimParamsHelpButton;
	children[ac++] = swimParamsNaEqDef;
	children[ac++] = swimParamsNaConDef;
	children[ac++] = swimParamsKEqDef;
	children[ac++] = swimParamsKConDef;
	children[ac++] = swimParamsCaEqDef;
	children[ac++] = swimParamsCaConDef;
	children[ac++] = swimParamsSpikeThresholdLabel;
	children[ac++] = swimParamsSpikeThresholdText;
	children[ac++] = swimParamsSpikeThresholdScale;
	children[ac++] = swimParamsSpikeThresholdDef;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = swimParamsForm;
	XtManageChildren(children, ac);

} /* end of create_swimParams */

/************************************************************************************************************************

 	FUNCTION	: create_hhParams( parent )
 
	PURPOSE		: creates dialog box for edit ion channels of neurons

	RETURNS		: nothing

************************************************************************************************************************/

void create_hhParams( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	hhParams,
		hhParamsForm,
		hhParamsNaEqLabel,
		hhParamsNaConLabel,
		hhParamsKEqLabel,
		hhParamsKConLabel,
		hhParamsSeparator,
		hhParamsOkButton,
		hhParamsNoButton,
		hhParamsHelpButton,
		hhParamsNaEqDef,
		hhParamsNaConDef,
		hhParamsKEqDef,
		hhParamsKConDef,
		hhParamsSpikeThresholdLabel,
		hhParamsSpikeThresholdDef;	/* widgets for internal use */

	Arg al[25];     	/* Arg List */
	register int ac; 	/* Arg Count */
	XmString xmstrings[10];	/* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	XtSetArg(al[ac], XmNtitle, editChannelString); ac++;
	hhParams = XmCreateDialogShell ( parent, "hhParams", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	hhParamsBB = XmCreateBulletinBoard ( hhParams, "hhParamsBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsForm = XmCreateForm ( hhParamsBB, "hhParamsForm", al, ac );
	XmAddTabGroup(hhParamsForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(sodiumEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	hhParamsNaEqLabel = XmCreateLabel ( hhParamsForm, "hhParamsNaEqLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsNaEqText = XmCreateText ( hhParamsForm, "hhParamsNaEqText", al, ac );

	XmAddTabGroup(hhParamsNaEqText);
	XtAddCallback(hhParamsNaEqText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_HH_NAEQ);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) NAEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) NAEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) NAEQ_MIN); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsNaEqScale = XmCreateScale ( hhParamsForm, "hhParamsNaEqScale", al, ac );

	XmAddTabGroup(hhParamsNaEqScale);
	XtAddCallback(hhParamsNaEqScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_HH_NAEQ);
	XtAddCallback(hhParamsNaEqScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_HH_NAEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(sodiumConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	hhParamsNaConLabel = XmCreateLabel ( hhParamsForm, "hhParamsNaConLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsNaConText = XmCreateText ( hhParamsForm, "hhParamsNaConText", al, ac );

	XmAddTabGroup(hhParamsNaConText);
	XtAddCallback(hhParamsNaConText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_HH_NACON);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) NACON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) NACON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) NACON_MIN); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsNaConScale = XmCreateScale ( hhParamsForm, "hhParamsNaConScale", al, ac );

	XmAddTabGroup(hhParamsNaConScale);
	XtAddCallback(hhParamsNaConScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_HH_NACON);
	XtAddCallback(hhParamsNaConScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_HH_NACON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(potassiumEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	hhParamsKEqLabel = XmCreateLabel ( hhParamsForm, "hhParamsKEqLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsKEqText = XmCreateText ( hhParamsForm, "hhParamsKEqText", al, ac );

	XmAddTabGroup(hhParamsKEqText);
	XtAddCallback(hhParamsKEqText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_HH_KEQ);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) KEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) KEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) KEQ_MIN); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsKEqScale = XmCreateScale ( hhParamsForm, "hhParamsKEqScale", al, ac );

	XmAddTabGroup(hhParamsKEqScale);
	XtAddCallback(hhParamsKEqScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_HH_KEQ);
	XtAddCallback(hhParamsKEqScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_HH_KEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(potassiumConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	hhParamsKConLabel = XmCreateLabel ( hhParamsForm, "hhParamsKConLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsKConText = XmCreateText ( hhParamsForm, "hhParamsKConText", al, ac );

	XmAddTabGroup(hhParamsKConText);
	XtAddCallback(hhParamsKConText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_HH_KCON);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) KCON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) KCON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) KCON_MIN); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsKConScale = XmCreateScale ( hhParamsForm, "hhParamsKConScale", al, ac );

	XmAddTabGroup(hhParamsKConScale);
	XtAddCallback(hhParamsKConScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_HH_KCON);
	XtAddCallback(hhParamsKConScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_HH_KCON);

	ac = 0;
	hhParamsSeparator = XmCreateSeparator ( hhParamsForm, "hhParamsSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsOkButton = XmCreatePushButton ( hhParamsForm, "hhParamsOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(hhParamsOkButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_HH_CHANNELS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsNoButton = XmCreatePushButton ( hhParamsForm, "hhParamsNoButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(hhParamsNoButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &hhParamsBB);
	XtAddCallback(hhParamsNoButton, XmNactivateCallback, remove_selected_objects_from_selectionList_CB,
		(caddr_t *) DIALOG_HH_CHANNELS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsHelpButton = XmCreatePushButton ( hhParamsForm, "hhParamsHelpButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(hhParamsHelpButton, XmNactivateCallback, dialog_help2_CB, (caddr_t *) DIALOG_HH_CHANNELS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsNaEqDef = XmCreatePushButton ( hhParamsForm, "hhParamsNaEqDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(hhParamsNaEqDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_HH_NAEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsNaConDef = XmCreatePushButton ( hhParamsForm, "hhParamsNaConDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(hhParamsNaConDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_HH_NACON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsKEqDef = XmCreatePushButton ( hhParamsForm, "hhParamsKEqDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(hhParamsKEqDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_HH_KEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsKConDef = XmCreatePushButton ( hhParamsForm, "hhParamsKConDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(hhParamsKConDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_HH_KCON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(spikeThresholdString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	hhParamsSpikeThresholdLabel = XmCreateLabel ( hhParamsForm, "hhParamsSpikeThresholdLabel", al, ac);
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsSpikeThresholdText = XmCreateText ( hhParamsForm, "hhParamsSpikeThresholdText", al, ac );

	XmAddTabGroup(hhParamsSpikeThresholdText);
	XtAddCallback(hhParamsSpikeThresholdText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_HH_STH);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) STH_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) STH_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) STH_MIN); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsSpikeThresholdScale = XmCreateScale ( hhParamsForm, "hhParamsSpikeThresholdScale", al, ac);

	XmAddTabGroup(hhParamsSpikeThresholdScale);
	XtAddCallback(hhParamsSpikeThresholdScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_HH_STH);
	XtAddCallback(hhParamsSpikeThresholdScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_HH_STH);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	hhParamsSpikeThresholdDef = XmCreatePushButton ( hhParamsForm, "hhParamsSpikeThresholdDef", al, ac);
	XmStringFree(xmstrings[0]);

	XtAddCallback(hhParamsSpikeThresholdDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_HH_STH);

	/* manage widgets */

	XtManageChild(hhParamsNaEqLabel);
	XtManageChild(hhParamsNaEqText);
	XtManageChild(hhParamsNaEqScale);
	XtManageChild(hhParamsNaConLabel);
	XtManageChild(hhParamsNaConText);
	XtManageChild(hhParamsNaConScale);
	XtManageChild(hhParamsKEqLabel);
	XtManageChild(hhParamsKEqText);
	XtManageChild(hhParamsKEqScale);
	XtManageChild(hhParamsKConLabel);
	XtManageChild(hhParamsKConText);
	XtManageChild(hhParamsKConScale);
	XtManageChild(hhParamsSeparator);
	XtManageChild(hhParamsOkButton);
	XtManageChild(hhParamsNoButton);
	XtManageChild(hhParamsHelpButton);
	XtManageChild(hhParamsNaEqDef);
	XtManageChild(hhParamsNaConDef);
	XtManageChild(hhParamsKEqDef);
	XtManageChild(hhParamsKConDef);
	XtManageChild(hhParamsSpikeThresholdLabel);
	XtManageChild(hhParamsSpikeThresholdText);
	XtManageChild(hhParamsSpikeThresholdScale);
	XtManageChild(hhParamsSpikeThresholdDef);
	XtManageChild(hhParamsForm);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsNaEqLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsNaEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsNaEqLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsNaEqText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsNaEqText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsNaEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsNaEqScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsNaEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsNaConLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsNaConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsNaEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsNaConText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsNaConText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsNaConText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsNaConScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 30); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsNaConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsKEqLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsKEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsNaConText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsKEqText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsKEqText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsKEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsKEqScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsKEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsKConLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsKConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsKEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsKConText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsKConText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsKConText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsKConScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsSpikeThresholdText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsSpikeThresholdLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightOffset, 10); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( hhParamsOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
        XtSetValues ( hhParamsNoButton,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( hhParamsHelpButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsNaEqScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsNaEqScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsNaEqDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsNaConScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsNaConScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsNaConDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsKEqScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsKEqScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsKEqDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsKConScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsKConScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsKConDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 30); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsKConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsSpikeThresholdLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsSpikeThresholdLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsKConText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsSpikeThresholdText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsSpikeThresholdText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsSpikeThresholdText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsSpikeThresholdScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, hhParamsSpikeThresholdScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, hhParamsSpikeThresholdScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( hhParamsSpikeThresholdDef,al, ac );

} /* end of create_hhParams */

/************************************************************************************************************************

 	FUNCTION	: create_gbParams( parent )
 
	PURPOSE		: creates dialog box for edit ion channels of neurons

	RETURNS		: nothing

************************************************************************************************************************/

void create_gbParams( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	gbParams,
		gbParamsForm,
		gbParamsNaEqLabel,
		gbParamsNaConLabel,
		gbParamsKEqLabel,
		gbParamsKConLabel,
		gbParamsCa1ConLabel,
		gbParamsCa2ConLabel,
		gbParamsKCAEqLabel,
		gbParamsKCAConLabel,
		gbParamsAEqLabel,
		gbParamsAConLabel,
		gbParamsIREqLabel,
		gbParamsIRConLabel,
		gbParamsPEqLabel,
		gbParamsPConLabel,
		gbParamsSeparator,
		gbParamsOkButton,
		gbParamsNoButton,
		gbParamsHelpButton,
		gbParamsNaEqDef,
		gbParamsNaConDef,
		gbParamsKEqDef,
		gbParamsKConDef,
		gbParamsCa1ConDef,
		gbParamsCa2ConDef,
		gbParamsKCAEqDef,
		gbParamsKCAConDef,
		gbParamsAEqDef,
		gbParamsAConDef,
		gbParamsPEqDef,
		gbParamsPConDef,
		gbParamsIREqDef,
		gbParamsIRConDef,
		gbParamsSpikeThresholdLabel,
		gbParamsSpikeThresholdDef;	/* widgets for internal use */

	Arg al[25];      	/* Arg List */
	register int ac; 	/* Arg Count */
	XmString xmstrings[10]; /* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	XtSetArg(al[ac], XmNtitle, editChannelString); ac++;
	gbParams = XmCreateDialogShell ( parent, "gbParams", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	gbParamsBB = XmCreateBulletinBoard ( gbParams, "gbParamsBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsForm = XmCreateForm ( gbParamsBB, "gbParamsForm", al, ac );
	XmAddTabGroup(gbParamsForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(sodiumEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsNaEqLabel = XmCreateLabel ( gbParamsForm, "gbParamsNaEqLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsNaEqText = XmCreateText ( gbParamsForm, "gbParamsNaEqText", al, ac );

	XmAddTabGroup(gbParamsNaEqText);
	XtAddCallback(gbParamsNaEqText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_NAEQ);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) NAEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) NAEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) NAEQ_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsNaEqScale = XmCreateScale ( gbParamsForm, "gbParamsNaEqScale", al, ac );

	XmAddTabGroup(gbParamsNaEqScale);
	XtAddCallback(gbParamsNaEqScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_NAEQ);
	XtAddCallback(gbParamsNaEqScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_NAEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(sodiumConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsNaConLabel = XmCreateLabel ( gbParamsForm, "gbParamsNaConLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsNaConText = XmCreateText ( gbParamsForm, "gbParamsNaConText", al, ac );

	XmAddTabGroup(gbParamsNaConText);
	XtAddCallback(gbParamsNaConText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_NACON);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) NACON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) NACON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) NACON_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsNaConScale = XmCreateScale ( gbParamsForm, "gbParamsNaConScale", al, ac );

	XmAddTabGroup(gbParamsNaConScale);
	XtAddCallback(gbParamsNaConScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_NACON);
	XtAddCallback(gbParamsNaConScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_NACON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(potassiumEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsKEqLabel = XmCreateLabel ( gbParamsForm, "gbParamsKEqLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsKEqText = XmCreateText ( gbParamsForm, "gbParamsKEqText", al, ac );

	XmAddTabGroup(gbParamsKEqText);
	XtAddCallback(gbParamsKEqText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_KEQ);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) KEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) KEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) KEQ_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsKEqScale = XmCreateScale ( gbParamsForm, "gbParamsKEqScale", al, ac );

	XmAddTabGroup(gbParamsKEqScale);
	XtAddCallback(gbParamsKEqScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_KEQ);
	XtAddCallback(gbParamsKEqScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_KEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(potassiumConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsKConLabel = XmCreateLabel ( gbParamsForm, "gbParamsKConLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsKConText = XmCreateText ( gbParamsForm, "gbParamsKConText", al, ac );

	XmAddTabGroup(gbParamsKConText);
	XtAddCallback(gbParamsKConText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_KCON);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) KCON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) KCON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) KCON_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsKConScale = XmCreateScale ( gbParamsForm, "gbParamsKConScale", al, ac );

	XmAddTabGroup(gbParamsKConScale);
	XtAddCallback(gbParamsKConScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_KCON);
	XtAddCallback(gbParamsKConScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_KCON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(calcium1ConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsCa1ConLabel = XmCreateLabel ( gbParamsForm, "gbParamsCa1ConLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsCa1ConText = XmCreateText ( gbParamsForm, "gbParamsCa1ConText", al, ac );

	XmAddTabGroup(gbParamsCa1ConText);
	XtAddCallback(gbParamsCa1ConText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_CA1CON);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) CACON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) CACON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) CA1CON_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsCa1ConScale = XmCreateScale ( gbParamsForm, "gbParamsCa1ConScale", al, ac );

	XmAddTabGroup(gbParamsCa1ConScale);
	XtAddCallback(gbParamsCa1ConScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_CA1CON);
	XtAddCallback(gbParamsCa1ConScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_CA1CON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(calcium2ConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsCa2ConLabel = XmCreateLabel ( gbParamsForm, "gbParamsCa2ConLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsCa2ConText = XmCreateText ( gbParamsForm, "gbParamsCa2ConText", al, ac );

	XmAddTabGroup(gbParamsCa2ConText);
	XtAddCallback(gbParamsCa2ConText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_CA2CON);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) CACON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) CACON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) CA2CON_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsCa2ConScale = XmCreateScale ( gbParamsForm, "gbParamsCa2ConScale", al, ac );

	XmAddTabGroup(gbParamsCa2ConScale);
	XtAddCallback(gbParamsCa2ConScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_CA2CON);
	XtAddCallback(gbParamsCa2ConScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_CA2CON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(kCaEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsKCAEqLabel = XmCreateLabel ( gbParamsForm, "gbParamsKCAEqLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsKCAEqText = XmCreateText ( gbParamsForm, "gbParamsKCAEqText", al, ac );

	XmAddTabGroup(gbParamsKCAEqText);
	XtAddCallback(gbParamsKCAEqText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_KCAEQ);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) KCAEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) KCAEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) KCAEQ_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsKCAEqScale = XmCreateScale ( gbParamsForm, "gbParamsKCAEqScale", al, ac );

	XmAddTabGroup(gbParamsKCAEqScale);
	XtAddCallback(gbParamsKCAEqScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_KCAEQ);
	XtAddCallback(gbParamsKCAEqScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_KCAEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(kCaConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsKCAConLabel = XmCreateLabel ( gbParamsForm, "gbParamsKCAConLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsKCAConText = XmCreateText ( gbParamsForm, "gbParamsKCAConText", al, ac );

	XmAddTabGroup(gbParamsKCAConText);
	XtAddCallback(gbParamsKCAConText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_KCACON);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) KCACON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) KCACON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) KCACON_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsKCAConScale = XmCreateScale ( gbParamsForm, "gbParamsKCAConScale", al, ac );

	XmAddTabGroup(gbParamsKCAConScale);
	XtAddCallback(gbParamsKCAConScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_KCACON);
	XtAddCallback(gbParamsKCAConScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_KCACON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(aEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsAEqLabel = XmCreateLabel ( gbParamsForm, "gbParamsAEqLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsAEqText = XmCreateText ( gbParamsForm, "gbParamsAEqText", al, ac );

	XmAddTabGroup(gbParamsAEqText);
	XtAddCallback(gbParamsAEqText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_AEQ);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) AEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) AEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) AEQ_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsAEqScale = XmCreateScale ( gbParamsForm, "gbParamsAEqScale", al, ac );

	XmAddTabGroup(gbParamsAEqScale);
	XtAddCallback(gbParamsAEqScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_AEQ);
	XtAddCallback(gbParamsAEqScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_AEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(aConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsAConLabel = XmCreateLabel ( gbParamsForm, "gbParamsAConLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsAConText = XmCreateText ( gbParamsForm, "gbParamsAConText", al, ac );

	XmAddTabGroup(gbParamsAConText);
	XtAddCallback(gbParamsAConText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_ACON);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) ACON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) ACON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) ACON_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsAConScale = XmCreateScale ( gbParamsForm, "gbParamsAConScale", al, ac );

	XmAddTabGroup(gbParamsAConScale);
	XtAddCallback(gbParamsAConScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_ACON);
	XtAddCallback(gbParamsAConScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_ACON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(irEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsIREqLabel = XmCreateLabel ( gbParamsForm, "gbParamsIREqLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsIREqText = XmCreateText ( gbParamsForm, "gbParamsIREqText", al, ac );

	XmAddTabGroup(gbParamsIREqText);
	XtAddCallback(gbParamsIREqText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_IREQ);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) IREQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) IREQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) IREQ_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsIREqScale = XmCreateScale ( gbParamsForm, "gbParamsIREqScale", al, ac );

	XmAddTabGroup(gbParamsIREqScale);
	XtAddCallback(gbParamsIREqScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_IREQ);
	XtAddCallback(gbParamsIREqScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_IREQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(irConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsIRConLabel = XmCreateLabel ( gbParamsForm, "gbParamsIRConLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsIRConText = XmCreateText ( gbParamsForm, "gbParamsIRConText", al, ac );

	XmAddTabGroup(gbParamsIRConText);
	XtAddCallback(gbParamsIRConText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_IRCON);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) IRCON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) IRCON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) IRCON_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsIRConScale = XmCreateScale ( gbParamsForm, "gbParamsIRConScale", al, ac );

	XmAddTabGroup(gbParamsIRConScale);
	XtAddCallback(gbParamsIRConScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_IRCON);
	XtAddCallback(gbParamsIRConScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_IRCON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(pEqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsPEqLabel = XmCreateLabel ( gbParamsForm, "gbParamsPEqLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsPEqText = XmCreateText ( gbParamsForm, "gbParamsPEqText", al, ac );

	XmAddTabGroup(gbParamsPEqText);
	XtAddCallback(gbParamsPEqText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_PEQ);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) PEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) PEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) PEQ_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsPEqScale = XmCreateScale ( gbParamsForm, "gbParamsPEqScale", al, ac );

	XmAddTabGroup(gbParamsPEqScale);
	XtAddCallback(gbParamsPEqScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_PEQ);
	XtAddCallback(gbParamsPEqScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_PEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(pConString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsPConLabel = XmCreateLabel ( gbParamsForm, "gbParamsPConLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsPConText = XmCreateText ( gbParamsForm, "gbParamsPConText", al, ac );

	XmAddTabGroup(gbParamsPConText);
	XtAddCallback(gbParamsPConText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_PCON);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) PCON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) PCON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) PCON_GB_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsPConScale = XmCreateScale ( gbParamsForm, "gbParamsPConScale", al, ac );

	XmAddTabGroup(gbParamsPConScale);
	XtAddCallback(gbParamsPConScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_PCON);
	XtAddCallback(gbParamsPConScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_PCON);

	ac = 0;
	gbParamsSeparator = XmCreateSeparator ( gbParamsForm, "gbParamsSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsOkButton = XmCreatePushButton ( gbParamsForm, "gbParamsOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsOkButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_GB_CHANNELS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsNoButton = XmCreatePushButton ( gbParamsForm, "gbParamsNoButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsNoButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &gbParamsBB);
	XtAddCallback(gbParamsNoButton, XmNactivateCallback, remove_selected_objects_from_selectionList_CB,
		(caddr_t *) DIALOG_GB_CHANNELS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsHelpButton = XmCreatePushButton ( gbParamsForm, "gbParamsHelpButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsHelpButton, XmNactivateCallback, dialog_help2_CB, (caddr_t *) DIALOG_GB_CHANNELS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsNaEqDef = XmCreatePushButton ( gbParamsForm, "gbParamsNaEqDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsNaEqDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_NAEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsNaConDef = XmCreatePushButton ( gbParamsForm, "gbParamsNaConDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsNaConDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_NACON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsKEqDef = XmCreatePushButton ( gbParamsForm, "gbParamsKEqDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsKEqDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_KEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsKConDef = XmCreatePushButton ( gbParamsForm, "gbParamsKConDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsKConDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_KCON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsCa1ConDef = XmCreatePushButton ( gbParamsForm, "gbParamsCa1ConDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsCa1ConDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_CA1CON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsCa2ConDef = XmCreatePushButton ( gbParamsForm, "gbParamsCa2ConDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsCa2ConDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_CA2CON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsKCAEqDef = XmCreatePushButton ( gbParamsForm, "gbParamsKCAEqDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsKCAEqDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_KCAEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsKCAConDef = XmCreatePushButton ( gbParamsForm, "gbParamsKCAConDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsKCAConDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_KCACON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsAEqDef = XmCreatePushButton ( gbParamsForm, "gbParamsAEqDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsAEqDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_AEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsAConDef = XmCreatePushButton ( gbParamsForm, "gbParamsAConDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsAConDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_ACON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsIREqDef = XmCreatePushButton ( gbParamsForm, "gbParamsIREqDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsIREqDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_IREQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsIRConDef = XmCreatePushButton ( gbParamsForm, "gbParamsIRConDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsIRConDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_IRCON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsPEqDef = XmCreatePushButton ( gbParamsForm, "gbParamsPEqDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsPEqDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_PEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsPConDef = XmCreatePushButton ( gbParamsForm, "gbParamsPConDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsPConDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_PCON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(spikeThresholdString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	gbParamsSpikeThresholdLabel = XmCreateLabel ( gbParamsForm, "gbParamsSpikeThresholdLabel", al, ac);
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsSpikeThresholdText = XmCreateText ( gbParamsForm, "gbParamsSpikeThresholdText", al, ac );

	XmAddTabGroup(gbParamsSpikeThresholdText);
	XtAddCallback(gbParamsSpikeThresholdText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_GB_STH);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) STH_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) STH_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) STH_MIN); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsSpikeThresholdScale = XmCreateScale ( gbParamsForm, "gbParamsSpikeThresholdScale", al, ac);

	XmAddTabGroup(gbParamsSpikeThresholdScale);
	XtAddCallback(gbParamsSpikeThresholdScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_STH);
	XtAddCallback(gbParamsSpikeThresholdScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_GB_STH);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	gbParamsSpikeThresholdDef = XmCreatePushButton ( gbParamsForm, "gbParamsSpikeThresholdDef", al, ac);
	XmStringFree(xmstrings[0]);

	XtAddCallback(gbParamsSpikeThresholdDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_GB_STH);

	/* manage widgets */

	XtManageChild(gbParamsNaEqLabel);
	XtManageChild(gbParamsNaEqText);
	XtManageChild(gbParamsNaEqScale);
	XtManageChild(gbParamsNaConLabel);
	XtManageChild(gbParamsNaConText);
	XtManageChild(gbParamsNaConScale);
	XtManageChild(gbParamsKEqLabel);
	XtManageChild(gbParamsKEqText);
	XtManageChild(gbParamsKEqScale);
	XtManageChild(gbParamsKConLabel);
	XtManageChild(gbParamsKConText);
	XtManageChild(gbParamsKConScale);
	XtManageChild(gbParamsCa1ConLabel);
	XtManageChild(gbParamsCa1ConText);
	XtManageChild(gbParamsCa1ConScale);
	XtManageChild(gbParamsCa2ConLabel);
	XtManageChild(gbParamsCa2ConText);
	XtManageChild(gbParamsCa2ConScale);
	XtManageChild(gbParamsKCAEqLabel);
	XtManageChild(gbParamsKCAEqText);
	XtManageChild(gbParamsKCAEqScale);
	XtManageChild(gbParamsKCAConLabel);
	XtManageChild(gbParamsKCAConText);
	XtManageChild(gbParamsKCAConScale);
	XtManageChild(gbParamsAEqLabel);
	XtManageChild(gbParamsAEqText);
	XtManageChild(gbParamsAEqScale);
	XtManageChild(gbParamsAConLabel);
	XtManageChild(gbParamsAConText);
	XtManageChild(gbParamsAConScale);
	XtManageChild(gbParamsIREqLabel);
	XtManageChild(gbParamsIREqText);
	XtManageChild(gbParamsIREqScale);
	XtManageChild(gbParamsIRConLabel);
	XtManageChild(gbParamsIRConText);
	XtManageChild(gbParamsIRConScale);
	XtManageChild(gbParamsPEqLabel);
	XtManageChild(gbParamsPEqText);
	XtManageChild(gbParamsPEqScale);
	XtManageChild(gbParamsPConLabel);
	XtManageChild(gbParamsPConText);
	XtManageChild(gbParamsPConScale);
	XtManageChild(gbParamsSeparator);
	XtManageChild(gbParamsOkButton);
	XtManageChild(gbParamsNoButton);
	XtManageChild(gbParamsHelpButton);
	XtManageChild(gbParamsNaEqDef);
	XtManageChild(gbParamsNaConDef);
	XtManageChild(gbParamsKEqDef);
	XtManageChild(gbParamsKConDef);
	XtManageChild(gbParamsCa1ConDef);
	XtManageChild(gbParamsCa2ConDef);
	XtManageChild(gbParamsKCAEqDef);
	XtManageChild(gbParamsKCAConDef);
	XtManageChild(gbParamsAEqDef);
	XtManageChild(gbParamsAConDef);
	XtManageChild(gbParamsIREqDef);
	XtManageChild(gbParamsIRConDef);
	XtManageChild(gbParamsPEqDef);
	XtManageChild(gbParamsPConDef);
	XtManageChild(gbParamsSpikeThresholdLabel);
	XtManageChild(gbParamsSpikeThresholdText);
	XtManageChild(gbParamsSpikeThresholdScale);
	XtManageChild(gbParamsSpikeThresholdDef);
	XtManageChild(gbParamsForm);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsNaEqLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsNaEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsNaEqText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsNaEqText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsNaEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsNaEqScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsNaEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsNaConLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsNaConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsNaConText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsNaConText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsNaConText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsNaConScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 30); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsNaConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKEqLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKEqText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKEqText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKEqScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKConLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKConText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKConText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKConText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKConScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 30); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsCa1ConLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsCa1ConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsCa1ConText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsCa1ConText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsCa1ConText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsCa1ConScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsCa1ConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsCa2ConLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsCa2ConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsCa2ConText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsCa2ConText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsCa2ConText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsCa2ConScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 30); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsCa2ConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKCAEqLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKCAEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKCAEqText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKCAEqScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKCAEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKCAConLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKCAConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKCAConText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKCAConText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAConText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKCAConScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 30); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKCAConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsAEqLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsAEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsAEqText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsAEqText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsAEqScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsAEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsAConLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsAConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsAConText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsAConText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsAConText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsAConScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 30); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsAConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsIREqLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsIREqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsIREqText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsIREqText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsIREqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsIREqScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsIREqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsIRConLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsIRConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsIRConText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsIRConText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsIRConText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsIRConScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 30); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsIRConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsPEqLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsPEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsPEqText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsPEqText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsPEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsPEqScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsPEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsPConLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsPConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsPConText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsPConText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsPConText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsPConScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsSpikeThresholdText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsSpikeThresholdLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightOffset, 10); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( gbParamsOkButton,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
        XtSetValues ( gbParamsNoButton,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( gbParamsHelpButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsNaEqScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsNaEqScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsNaEqDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsNaConScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsNaConScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsNaConDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKEqScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKEqScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKEqDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKConScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKConScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKConDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsCa1ConScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsCa1ConScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsCa1ConDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsCa2ConScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsCa2ConScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsCa2ConDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKCAEqScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAEqScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKCAEqDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsKCAConScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAConScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsKCAConDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsAEqScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsAEqScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsAEqDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsAConScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsAConScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsAConDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsIREqScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsIREqScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsIREqDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsIRConScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsIRConScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsIRConDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsPEqScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsPEqScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsPEqDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsPConScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsPConScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsPConDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 30); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsPConLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsSpikeThresholdLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsSpikeThresholdLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsKCAConText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsSpikeThresholdText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsSpikeThresholdText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsSpikeThresholdText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsSpikeThresholdScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, gbParamsSpikeThresholdScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, gbParamsSpikeThresholdScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( gbParamsSpikeThresholdDef,al, ac );

} /* end of create_gbParams */

/************************************************************************************************************************

 	FUNCTION	: create_editNeuron( parent )
 
	PURPOSE		: creates dialog box for edit neuron parameters

	RETURNS		: nothing

************************************************************************************************************************/

void create_editNeuron( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	editNeuron,
		editNeuronForm,
		editNeuronSomaLabel,
		editNeuronConductanceLabel,
		editNeuronLeakLabel,
		editNeuronCapacityLabel,
		editNeuronPotentialLabel,
		editNeuronToDendritConductanceLabel,
		editNeuronLoadGeneralButton,
		editNeuronSeparator,
		editNeuronOkButton,
		editNeuronDendritLabel,
		editNeuronDConductanceLabel,
		editNeuronDLeakLabel,
		editNeuronDCapacityLabel,
		editNeuronDPotentialLabel,
		editNeuronToSomaConductanceLabel,
		editNeuronSaveParamsButton,
		editNeuronHelpButton,
		editNeuronNoButton,
		editNeuronSeparator2,
		editNeuronConductanceDef,
		editNeuronLeakDef,
		editNeuronCapacityDef,
		editNeuronPotentialDef,
		editNeuronToDendritConductanceDef,
		editNeuronDConductanceDef,
		editNeuronDLeakDef,
		editNeuronDCapacityDef,
		editNeuronDPotentialDef,
		editNeuronToSomaConductanceDef;		/* widgets for internal use */

	Arg al[25];    		/* Arg List */
	register int ac;	/* Arg Count */
	char text[20];	 	/* text for number conversion */
	XmString xmstrings[10]; /* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, generalNeuronParamsString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	editNeuron = XmCreateDialogShell ( parent, "editNeuron", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	editNeuronBB = XmCreateBulletinBoard ( editNeuron, "editNeuronBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronForm = XmCreateForm ( editNeuronBB, "editNeuronForm", al, ac );
	XmAddTabGroup(editNeuronForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(somaParameterString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editNeuronSomaLabel = XmCreateLabel ( editNeuronForm, "editNeuronSomaLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(conductanceString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editNeuronConductanceLabel = XmCreateLabel ( editNeuronForm, "editNeuronConductanceLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(initialLeakPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editNeuronLeakLabel = XmCreateLabel ( editNeuronForm, "editNeuronLeakLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(capacityString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editNeuronCapacityLabel = XmCreateLabel ( editNeuronForm, "editNeuronCapacityLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(potentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editNeuronPotentialLabel = XmCreateLabel ( editNeuronForm, "editNeuronPotentialLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(conductanceToDendritString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editNeuronToDendritConductanceLabel = XmCreateLabel ( editNeuronForm, "editNeuronToDendritConductanceLabel",
	    al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	editNeuronSeparator = XmCreateSeparator ( editNeuronForm, "editNeuronSeparator", al, ac );

	ac = 0;
	sprintf(text,"%f", (double) CON_SWIM_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronConductanceText = XmCreateText ( editNeuronForm, "editNeuronConductanceText", al, ac );

	XmAddTabGroup(editNeuronConductanceText);
	XtAddCallback(editNeuronConductanceText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_CON);

	ac = 0;
	sprintf(text,"%f", (double) LEAK_SWIM_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronLeakText = XmCreateText ( editNeuronForm, "editNeuronLeakText", al, ac );

	XmAddTabGroup(editNeuronLeakText);
	XtAddCallback(editNeuronLeakText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_LEAK);

	ac = 0;
	sprintf(text,"%f", (double) CAP_SWIM_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronCapacityText = XmCreateText ( editNeuronForm, "editNeuronCapacityText", al, ac );

	XmAddTabGroup(editNeuronCapacityText);
	XtAddCallback(editNeuronCapacityText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_CAP);

	ac = 0;
	sprintf(text,"%f", (double) POT_SWIM_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronPotentialText = XmCreateText ( editNeuronForm, "editNeuronPotentialText", al, ac );

	XmAddTabGroup(editNeuronPotentialText);
	XtAddCallback(editNeuronPotentialText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_POT);

	ac = 0;
	sprintf(text,"%f", (double) TOD_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronToDendritConductanceText = XmCreateText (editNeuronForm, "editNeuronToDendritConductanceText", al, ac);

	XmAddTabGroup(editNeuronToDendritConductanceText);
	XtAddCallback(editNeuronToDendritConductanceText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_TOD);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) CON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) CON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) CON_SWIM_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronConductanceScale = XmCreateScale ( editNeuronForm, "editNeuronConductanceScale", al, ac );

	XmAddTabGroup(editNeuronConductanceScale);
	XtAddCallback(editNeuronConductanceScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_CON);
	XtAddCallback(editNeuronConductanceScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_CON);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) LEAK_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) LEAK_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) LEAK_SWIM_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronLeakScale = XmCreateScale ( editNeuronForm, "editNeuronLeakScale", al, ac );

	XmAddTabGroup(editNeuronLeakScale);
	XtAddCallback(editNeuronLeakScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_LEAK);
	XtAddCallback(editNeuronLeakScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_LEAK);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) CAP_MIN * 10); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) CAP_MAX * 10); ac++;
	XtSetArg(al[ac], XmNvalue, (int) CAP_SWIM_DEF * 10); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 1); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronCapacityScale = XmCreateScale ( editNeuronForm, "editNeuronCapacityScale", al, ac );

	XmAddTabGroup(editNeuronCapacityScale);
	XtAddCallback(editNeuronCapacityScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_CAP);
	XtAddCallback(editNeuronCapacityScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_CAP);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) POT_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) POT_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) POT_SWIM_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronPotentialScale = XmCreateScale ( editNeuronForm, "editNeuronPotentialScale", al, ac );

	XmAddTabGroup(editNeuronPotentialScale);
	XtAddCallback(editNeuronPotentialScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_POT);
	XtAddCallback(editNeuronPotentialScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_POT);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) TOD_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) TOD_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) TOD_DEF * 100); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronToDendritConductanceScale = XmCreateScale ( editNeuronForm, "editNeuronToDendritConductanceScale",
	    al, ac );

	XmAddTabGroup(editNeuronToDendritConductanceScale);
	XtAddCallback(editNeuronToDendritConductanceScale , XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_TOD);
	XtAddCallback(editNeuronToDendritConductanceScale , XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_TOD);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronConductanceDef = XmCreatePushButton ( editNeuronForm, "editNeuronConductanceDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronConductanceDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_CON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronLeakDef = XmCreatePushButton ( editNeuronForm, "editNeuronLeakDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronLeakDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_LEAK);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronCapacityDef = XmCreatePushButton ( editNeuronForm, "editNeuronCapacityDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronCapacityDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_CAP);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronPotentialDef = XmCreatePushButton ( editNeuronForm, "editNeuronPotentialDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronPotentialDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_POT);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronToDendritConductanceDef = XmCreatePushButton ( editNeuronForm, "editNeuronToDendritConductanceDef",
		al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronToDendritConductanceDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_TOD);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(dendritParameterString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editNeuronDendritLabel = XmCreateLabel ( editNeuronForm, "editNeuronDendritLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(conductanceString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editNeuronDConductanceLabel = XmCreateLabel ( editNeuronForm, "editNeuronDConductanceLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(initialLeakPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editNeuronDLeakLabel = XmCreateLabel ( editNeuronForm, "editNeuronDLeakLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(capacityString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editNeuronDCapacityLabel = XmCreateLabel ( editNeuronForm, "editNeuronDCapacityLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(potentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editNeuronDPotentialLabel = XmCreateLabel ( editNeuronForm, "editNeuronDPotentialLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(conductanceToSomaString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editNeuronToSomaConductanceLabel = XmCreateLabel ( editNeuronForm, "editNeuronToSomaConductanceLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	sprintf(text,"%f", (double) DCON_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronDConductanceText = XmCreateText ( editNeuronForm, "editNeuronDConductanceText", al, ac );

	XmAddTabGroup(editNeuronDConductanceText);
	XtAddCallback(editNeuronDConductanceText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_DCON);

	ac = 0;
	sprintf(text,"%f", (double) DLEAK_SWIM_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronDLeakText = XmCreateText ( editNeuronForm, "editNeuronDLeakText", al, ac );

	XmAddTabGroup(editNeuronDLeakText);
	XtAddCallback(editNeuronDLeakText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_DLEAK);

	ac = 0;
	sprintf(text,"%f", (double) DCAP_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronDCapacityText = XmCreateText ( editNeuronForm, "editNeuronDCapacityText", al, ac );

	XmAddTabGroup(editNeuronDCapacityText);
	XtAddCallback(editNeuronDCapacityText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_DCAP);

	ac = 0;
	sprintf(text,"%f", (double) DPOT_SWIM_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronDPotentialText = XmCreateText ( editNeuronForm, "editNeuronDPotentialText", al, ac );

	XmAddTabGroup(editNeuronDPotentialText);
	XtAddCallback(editNeuronDPotentialText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_DPOT);

	ac = 0;
	sprintf(text,"%f", (double) TOS_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronToSomaConductanceText = XmCreateText ( editNeuronForm, "editNeruonToSomaConductanceText", al, ac);

	XmAddTabGroup(editNeuronToSomaConductanceText);
	XtAddCallback(editNeuronToSomaConductanceText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_TOS);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) DCON_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) DCON_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) DCON_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronDConductanceScale = XmCreateScale ( editNeuronForm, "editNeuronDConductanceScale", al, ac );

	XmAddTabGroup(editNeuronDConductanceScale);
	XtAddCallback(editNeuronDConductanceScale , XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_DCON);
	XtAddCallback(editNeuronDConductanceScale , XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_DCON);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) DLEAK_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) DLEAK_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) DLEAK_SWIM_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronDLeakScale = XmCreateScale ( editNeuronForm, "editNeuronDLeakScale", al, ac );

	XmAddTabGroup(editNeuronDLeakScale);
	XtAddCallback(editNeuronDLeakScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_DLEAK);
	XtAddCallback(editNeuronDLeakScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_DLEAK);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) DCAP_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) DCAP_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) DCAP_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronDCapacityScale = XmCreateScale ( editNeuronForm, "editNeuronDCapacityScale", al, ac );

	XmAddTabGroup(editNeuronDCapacityScale);
	XtAddCallback(editNeuronDCapacityScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_DCAP);
	XtAddCallback(editNeuronDCapacityScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_DCAP);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) DPOT_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) DPOT_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) DPOT_SWIM_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronDPotentialScale = XmCreateScale ( editNeuronForm, "editNeuronDPotentialScale", al, ac );

	XmAddTabGroup(editNeuronDPotentialScale);
	XtAddCallback(editNeuronDPotentialScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_DPOT);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) TOS_MIN * 100); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) TOS_MAX * 100); ac++;
	XtSetArg(al[ac], XmNvalue, (int) TOS_DEF * 100); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronToSomaConductanceScale = XmCreateScale ( editNeuronForm, "editNeuronToSomaConductanceScale", al, ac );

	XmAddTabGroup(editNeuronToSomaConductanceScale);
	XtAddCallback(editNeuronToSomaConductanceScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_TOS);
	XtAddCallback(editNeuronToSomaConductanceScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_TOS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronDConductanceDef = XmCreatePushButton ( editNeuronForm, "editNeuronDConductanceDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronDConductanceDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_DCON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronDLeakDef = XmCreatePushButton ( editNeuronForm, "editNeuronDLeakDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronDLeakDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_DLEAK);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronDCapacityDef = XmCreatePushButton ( editNeuronForm, "editNeuronDCapacityDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronDCapacityDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_DCAP);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronDPotentialDef = XmCreatePushButton ( editNeuronForm, "editNeuronDPotentialDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronDPotentialDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_DPOT);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronToSomaConductanceDef = XmCreatePushButton ( editNeuronForm, "editNeuronToSomaConductanceDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronToSomaConductanceDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_TOS);

	ac = 0;
	editNeuronSeparator2 = XmCreateSeparator ( editNeuronForm, "editNeuronSeparator2", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(loadGeneralParameterString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronLoadGeneralButton = XmCreatePushButton ( editNeuronForm, "editNeuronLoadGeneralButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronLoadGeneralButton, XmNactivateCallback, dialog_button2_CB, (caddr_t *) DIALOG_BUTTON_LOAD_GENERAL);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(saveGeneralParameterString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronSaveParamsButton = XmCreatePushButton ( editNeuronForm, "editNeuronSaveParamsButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronSaveParamsButton, XmNactivateCallback, dialog_button2_CB, (caddr_t *) DIALOG_BUTTON_SAVE_GENERAL);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronOkButton = XmCreatePushButton ( editNeuronForm, "editNeuronOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronOkButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_NEURON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronNoButton = XmCreatePushButton ( editNeuronForm, "editNeuronNoButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronNoButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &editNeuronBB);
	XtAddCallback(editNeuronNoButton, XmNactivateCallback, remove_selected_objects_from_selectionList_CB,
		(caddr_t *) DIALOG_NEURON);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editNeuronHelpButton = XmCreatePushButton ( editNeuronForm, "editNeuronHelpButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editNeuronHelpButton, XmNactivateCallback, dialog_help2_CB, (caddr_t *) DIALOG_NEURON);

	/* manage widgets */

	XtManageChild(editNeuronSomaLabel);
	XtManageChild(editNeuronConductanceLabel);
	XtManageChild(editNeuronLeakLabel);
	XtManageChild(editNeuronCapacityLabel);
	XtManageChild(editNeuronPotentialLabel);
	XtManageChild(editNeuronToDendritConductanceLabel);
	XtManageChild(editNeuronLoadGeneralButton);
	XtManageChild(editNeuronSeparator);
	XtManageChild(editNeuronOkButton);
	XtManageChild(editNeuronToDendritConductanceText);
	XtManageChild(editNeuronPotentialText);
	XtManageChild(editNeuronCapacityText);
	XtManageChild(editNeuronLeakText);
	XtManageChild(editNeuronConductanceText);
	XtManageChild(editNeuronConductanceScale);
	XtManageChild(editNeuronLeakScale);
	XtManageChild(editNeuronCapacityScale);
	XtManageChild(editNeuronPotentialScale);
	XtManageChild(editNeuronConductanceDef);
	XtManageChild(editNeuronLeakDef);
	XtManageChild(editNeuronCapacityDef);
	XtManageChild(editNeuronPotentialDef);
	XtManageChild(editNeuronToDendritConductanceDef);
	XtManageChild(editNeuronToDendritConductanceScale);
	XtManageChild(editNeuronDendritLabel);
	XtManageChild(editNeuronDConductanceLabel);
	XtManageChild(editNeuronDLeakLabel);
	XtManageChild(editNeuronDCapacityLabel);
	XtManageChild(editNeuronDPotentialLabel);
	XtManageChild(editNeuronToSomaConductanceLabel);
	XtManageChild(editNeuronSaveParamsButton);
	XtManageChild(editNeuronHelpButton);
	XtManageChild(editNeuronNoButton);
	XtManageChild(editNeuronDConductanceText);
	XtManageChild(editNeuronDLeakText);
	XtManageChild(editNeuronDCapacityText);
	XtManageChild(editNeuronDPotentialText);
	XtManageChild(editNeuronToSomaConductanceText);
	XtManageChild(editNeuronDConductanceScale);
	XtManageChild(editNeuronDLeakScale);
	XtManageChild(editNeuronDCapacityScale);
	XtManageChild(editNeuronDPotentialScale);
	XtManageChild(editNeuronToSomaConductanceScale);
	XtManageChild(editNeuronDConductanceDef);
	XtManageChild(editNeuronDLeakDef);
	XtManageChild(editNeuronDCapacityDef);
	XtManageChild(editNeuronDPotentialDef);
	XtManageChild(editNeuronToSomaConductanceDef);
	XtManageChild(editNeuronSeparator2);
	XtManageChild(editNeuronForm);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronSomaLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronSeparator2); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronConductanceLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronConductanceLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronLeakLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronLeakLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronCapacityLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronCapacityLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronPotentialLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronPotentialLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronToDendritConductanceLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronToDendritConductanceLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronLoadGeneralButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronLoadGeneralButton); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronToDendritConductanceLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToDendritConductanceLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronToDendritConductanceText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronPotentialLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToDendritConductanceLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronPotentialText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronCapacityLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToDendritConductanceLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronCapacityText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronLeakLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToDendritConductanceLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronLeakText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronConductanceLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToDendritConductanceLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronConductanceText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronConductanceText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronConductanceText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronConductanceScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronLeakText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronLeakText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronLeakScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronCapacityText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronCapacityText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronCapacityScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronPotentialText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronPotentialText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronPotentialScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronToDendritConductanceText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToDendritConductanceText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronToDendritConductanceScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronConductanceScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronConductanceScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronConductanceDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronLeakScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronLeakScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronLeakDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronCapacityScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronCapacityScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronCapacityDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronPotentialScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronPotentialScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronPotentialDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronToDendritConductanceScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToDendritConductanceScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronToDendritConductanceDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronConductanceDef); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDendritLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronSeparator2); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronConductanceDef); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDConductanceLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDConductanceLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronConductanceDef); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDLeakLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDLeakLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronConductanceDef); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDCapacityLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDCapacityLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronConductanceDef); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDPotentialLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDPotentialLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronConductanceDef); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronToSomaConductanceLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 15); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronToSomaConductanceLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToSomaConductanceLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronSaveParamsButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronOkButton); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronSaveParamsButton); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronNoButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronHelpButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDConductanceLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToSomaConductanceLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDConductanceText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDLeakLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToSomaConductanceLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDLeakText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDCapacityLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToSomaConductanceLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDCapacityText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDPotentialLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToSomaConductanceLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDPotentialText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronToSomaConductanceLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToSomaConductanceLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronToSomaConductanceText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDConductanceText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronDConductanceText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDConductanceScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDLeakText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronDLeakText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDLeakScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDCapacityText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronDCapacityText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDCapacityScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDPotentialText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronDPotentialText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDPotentialScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronToSomaConductanceText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToSomaConductanceText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronToSomaConductanceScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDConductanceScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronDConductanceScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDConductanceDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDLeakScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronDLeakScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDLeakDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDCapacityScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronDCapacityScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDCapacityDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronDPotentialScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronDPotentialScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronDPotentialDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronToSomaConductanceScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editNeuronToSomaConductanceScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronToSomaConductanceDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editNeuronSomaLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetValues ( editNeuronSeparator2,al, ac );

} /* end of create_editNeuron */

/************************************************************************************************************************

 	FUNCTION	: create_editCurrent( parent )
 
	PURPOSE		: creates dialog box for edit extern neuron currents

	RETURNS		: nothing

************************************************************************************************************************/

void create_editCurrent( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	editCurrent,
		editCurrentForm,
		editCurrentSomaLabel,
		editCurrentSomaStartLabel,
		editCurrentDendritLabel,
		editCurrentSomaEndLabel,
		editCurrentDendritStartLabel,
		editCurrentLocationLabel,
		editCurrentSeparator,
		editCurrentOkButton,
		editCurrentDendritEndLabel,
		editCurrentHelpButton,
		editCurrentNoButton,
		editCurrentLocationDef,
		editCurrentSomaCurrentDef,
		editCurrentSomaStartDef,
		editCurrentSomaEndDef,
		editCurrentDendritCurrentDef,
		editCurrentDendritStartDef,
		editCurrentDendritEndDef;	/* widgets for internal use */

	Arg al[25];      	/* Arg List */
	register int ac; 	/* Arg Count */
	Widget children[33];    /* Children to manage */
	char	text[20];	/* text for number conversion */
	XmString xmstrings[10];	/* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, currentParameterString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	editCurrent = XmCreateDialogShell ( parent, "editCurrent", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	editCurrentBB = XmCreateBulletinBoard ( editCurrent, "editCurrentBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentForm = XmCreateForm ( editCurrentBB, "editCurrentForm", al, ac );
	XmAddTabGroup(editCurrentForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(somaCurrentString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editCurrentSomaLabel = XmCreateLabel ( editCurrentForm, "editCurrentSomaLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(startTimeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editCurrentSomaStartLabel = XmCreateLabel ( editCurrentForm, "editCurrentSomaStartLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(dendritCurrentString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editCurrentDendritLabel = XmCreateLabel ( editCurrentForm, "editCurrentDendritLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(endTimeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editCurrentSomaEndLabel = XmCreateLabel ( editCurrentForm, "editCurrentSomaEndLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(startTimeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editCurrentDendritStartLabel = XmCreateLabel ( editCurrentForm, "editCurrentDendritStartLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(endTimeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editCurrentDendritEndLabel = XmCreateLabel ( editCurrentForm, "editCurrentDendritEndLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(dendritLocationString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editCurrentLocationLabel = XmCreateLabel ( editCurrentForm, "editCurrentLocationLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noiseString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	editCurrentNoiseToggle = XmCreateToggleButtonGadget ( editCurrentForm, "editCurrentNoiseToggle", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editCurrentNoiseToggle, XmNvalueChangedCallback, radio_box2_CB, (caddr_t *) NOISE_TOGGLE);

	ac = 0;
	editCurrentSeparator = XmCreateSeparator ( editCurrentForm, "editCurrentSeparator", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10);
	sprintf(text,"%f", (double) SCUR_DEF); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentSomaCurrentText = XmCreateText ( editCurrentForm, "editCurrentSomaCurrentText", al, ac );

	XmAddTabGroup(editCurrentSomaCurrentText);
	XtAddCallback(editCurrentSomaCurrentText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_SCUR);

	ac = 0;
	sprintf(text,"%f", (double) SSTART_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentSomaStartText = XmCreateText ( editCurrentForm, "editCurrentSomaStartText", al, ac );

	XmAddTabGroup(editCurrentSomaStartText);
	XtAddCallback(editCurrentSomaStartText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_SSTART);

	ac = 0;
	sprintf(text,"%f", (double) SEND_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentSomaEndText = XmCreateText ( editCurrentForm, "editCurrentSomaEndText", al, ac );

	XmAddTabGroup(editCurrentSomaEndText);
	XtAddCallback(editCurrentSomaEndText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_SEND);

	ac = 0;
	sprintf(text,"%f", (double) DCUR_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentDendritCurrentText = XmCreateText ( editCurrentForm, "editCurrentDendritCurrentText", al, ac );

	XmAddTabGroup(editCurrentDendritCurrentText);
	XtAddCallback(editCurrentDendritCurrentText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_DCUR);

	ac = 0;
	sprintf(text,"%f", (double) DSTART_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentDendritStartText = XmCreateText ( editCurrentForm, "editCurrentDendritStartText", al, ac );

	XmAddTabGroup(editCurrentDendritStartText);
	XtAddCallback(editCurrentDendritStartText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_DSTART);

	ac = 0;
	sprintf(text,"%f", (double) DEND_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentDendritEndText = XmCreateText ( editCurrentForm, "editCurrentDendritEndText", al, ac );

	XmAddTabGroup(editCurrentDendritEndText);
	XtAddCallback(editCurrentDendritEndText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_DEND);

	ac = 0;
	sprintf(text, "%d", TARGET_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentLocationText = XmCreateText ( editCurrentForm, "editCurrentLocationText", al, ac );

	XmAddTabGroup ( editCurrentLocationText );
	XtAddCallback (editCurrentLocationText, XmNactivateCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_REGION);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) SCUR_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) SCUR_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) SCUR_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentSomaCurrentScale = XmCreateScale ( editCurrentForm, "editCurrentSomaCurrentScale", al, ac );

	XmAddTabGroup(editCurrentSomaCurrentScale);
	XtAddCallback(editCurrentSomaCurrentScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SCUR);
	XtAddCallback(editCurrentSomaCurrentScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SCUR);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentSomaCurrentDef = XmCreatePushButton ( editCurrentForm, "editCurrentSomaCurrentDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editCurrentSomaCurrentDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_SCUR);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) SSTART_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) SSTART_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) SSTART_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentSomaStartScale = XmCreateScale ( editCurrentForm, "editCurrentSomaStartScale", al, ac );

	XmAddTabGroup(editCurrentSomaStartScale);
	XtAddCallback(editCurrentSomaStartScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SSTART);
	XtAddCallback(editCurrentSomaStartScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SSTART);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentSomaStartDef = XmCreatePushButton ( editCurrentForm, "editCurrentSomaStartDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editCurrentSomaStartDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_SSTART);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) SEND_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) SEND_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) SEND_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentSomaEndScale = XmCreateScale ( editCurrentForm, "editCurrentSomaEndScale", al, ac );

	XmAddTabGroup(editCurrentSomaEndScale);
	XtAddCallback(editCurrentSomaEndScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SEND);
	XtAddCallback(editCurrentSomaEndScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SEND);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentSomaEndDef = XmCreatePushButton ( editCurrentForm, "editCurrentSomaEndDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editCurrentSomaEndDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_SEND);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) DCUR_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) DCUR_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) DCUR_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentDendritCurrentScale = XmCreateScale ( editCurrentForm, "editCurrentDendritCurrentScale", al, ac);

	XmAddTabGroup(editCurrentDendritCurrentScale);
	XtAddCallback(editCurrentDendritCurrentScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_DCUR);
	XtAddCallback(editCurrentDendritCurrentScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_DCUR);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentDendritCurrentDef = XmCreatePushButton ( editCurrentForm, "editCurrentDendritCurrentDef", al, ac);
	XmStringFree(xmstrings[0]);

	XtAddCallback(editCurrentDendritCurrentDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_DCUR);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) DSTART_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) DSTART_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) DSTART_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentDendritStartScale = XmCreateScale ( editCurrentForm, "editCurrentDendritStartScale", al, ac );

	XmAddTabGroup(editCurrentDendritStartScale);
	XtAddCallback(editCurrentDendritStartScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_DSTART);
	XtAddCallback(editCurrentDendritStartScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_DSTART);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentDendritStartDef = XmCreatePushButton ( editCurrentForm, "editCurrentDendritStartDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editCurrentDendritStartDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_DSTART);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) DEND_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) DEND_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) DEND_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentDendritEndScale = XmCreateScale ( editCurrentForm, "editCurrentDendritEndScale", al, ac );

	XmAddTabGroup(editCurrentDendritEndScale);
	XtAddCallback(editCurrentDendritEndScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_DEND);
	XtAddCallback(editCurrentDendritEndScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_DEND);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentDendritEndDef = XmCreatePushButton ( editCurrentForm, "editCurrentDendritEndDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editCurrentDendritEndDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_DEND);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, TARGET_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, curNumOfDendSegs); ac++;
	XtSetArg(al[ac], XmNvalue, TARGET_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentLocationScale = XmCreateScale ( editCurrentForm, "editCurrentLocationScale", al, ac );

	XmAddTabGroup ( editCurrentLocationScale );
	XtAddCallback (editCurrentLocationScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_REGION);
	XtAddCallback (editCurrentLocationScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_REGION);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentLocationDef = XmCreatePushButton ( editCurrentForm, "editCurrentLocationDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback (editCurrentLocationDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_REGION);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentOkButton = XmCreatePushButton ( editCurrentForm, "editCurrentOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editCurrentOkButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_CURRENT);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentNoButton = XmCreatePushButton ( editCurrentForm, "editCurrentNoButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editCurrentNoButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &editCurrentBB);
	XtAddCallback(editCurrentNoButton, XmNactivateCallback, remove_selected_objects_from_selectionList_CB,
		(caddr_t *) DIALOG_CURRENT);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editCurrentHelpButton = XmCreatePushButton ( editCurrentForm, "editCurrentHelpButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editCurrentHelpButton, XmNactivateCallback, dialog_help2_CB, (caddr_t *) DIALOG_CURRENT);

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentSomaLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 20); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentSomaLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentSomaStartLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 20); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentSomaStartLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentDendritLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentSomaStartDef); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentSomaStartDef); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentSomaEndLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 20); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentDendritLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentDendritStartLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 20); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentDendritStartLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentLocationLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentNoiseToggle); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentDendritStartLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentDendritCurrentText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentDendritStartText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentDendritLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentDendritLabel); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentDendritCurrentText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentSomaEndLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentSomaEndLabel); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentSomaEndText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentSomaStartLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentDendritCurrentText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentSomaStartText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentDendritCurrentText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentSomaCurrentText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentDendritStartDef); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentDendritStartDef); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentDendritEndLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentHelpButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentNoButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentDendritEndLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentDendritEndLabel); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentDendritEndText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentLocationLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentDendritCurrentText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentLocationText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentLocationText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentLocationText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentLocationScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentLocationScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentLocationScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentLocationDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentSomaCurrentText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentSomaCurrentScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentSomaCurrentScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentSomaCurrentDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentSomaStartText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentSomaStartText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentSomaStartScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentSomaStartScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentSomaStartScale); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentSomaStartDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentSomaEndText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentSomaEndText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentSomaEndScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentSomaEndScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentSomaEndScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentSomaEndDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentDendritCurrentText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentDendritCurrentText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentDendritCurrentScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentDendritCurrentScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentDendritCurrentScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentDendritCurrentDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentDendritStartText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentDendritStartText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentDendritStartScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentDendritStartScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentDendritStartScale); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentDendritStartDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentDendritEndText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentDendritEndText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentDendritEndScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentDendritEndScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editCurrentDendritEndScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentDendritEndDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 20); ac++;
	XtSetArg(al[ac], XmNtopWidget, editCurrentLocationLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editCurrentNoiseToggle,al, ac );

	/* manage widgets */

	ac = 0;
	children[ac++] = editCurrentSomaLabel;
	children[ac++] = editCurrentSomaStartLabel;
	children[ac++] = editCurrentDendritLabel;
	children[ac++] = editCurrentSomaEndLabel;
	children[ac++] = editCurrentDendritStartLabel;
	children[ac++] = editCurrentLocationLabel;
	children[ac++] = editCurrentSeparator;
	children[ac++] = editCurrentOkButton;
	children[ac++] = editCurrentDendritStartText;
	children[ac++] = editCurrentDendritCurrentText;
	children[ac++] = editCurrentSomaEndText;
	children[ac++] = editCurrentSomaStartText;
	children[ac++] = editCurrentSomaCurrentText;
	children[ac++] = editCurrentDendritEndLabel;
	children[ac++] = editCurrentHelpButton;
	children[ac++] = editCurrentNoButton;
	children[ac++] = editCurrentDendritEndText;
	children[ac++] = editCurrentLocationText;
	children[ac++] = editCurrentLocationScale;
	children[ac++] = editCurrentLocationDef;
	children[ac++] = editCurrentSomaCurrentScale;
	children[ac++] = editCurrentSomaCurrentDef;
	children[ac++] = editCurrentSomaStartScale;
	children[ac++] = editCurrentSomaStartDef;
	children[ac++] = editCurrentSomaEndScale;
	children[ac++] = editCurrentSomaEndDef;
	children[ac++] = editCurrentDendritCurrentScale;
	children[ac++] = editCurrentDendritCurrentDef;
	children[ac++] = editCurrentDendritStartScale;
	children[ac++] = editCurrentDendritStartDef;
	children[ac++] = editCurrentDendritEndScale;
	children[ac++] = editCurrentDendritEndDef;
	children[ac++] = editCurrentNoiseToggle;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = editCurrentForm;
	XtManageChildren(children, ac);

} /* end of create_editCurrent */

/************************************************************************************************************************

 	FUNCTION	: create_newSType( parent )
 
	PURPOSE		: creates dialog box for input new synaptic types

	RETURNS		: nothing

************************************************************************************************************************/

void create_newSType( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	newSType,
		newSTypeForm,
		newSTypeEqPotLabel,
		newSTypeEqPotDef,
		newSTypeIonTypeLabel,
		newSTypeRadioBox,
		newSTypeSodiumToggle,
		newSTypePotassiumToggle,
		newSTypeChemicalToggle,
		newSTypeSeparator,
		newSTypeOkButton,
		newSTypeNoButton,
		newSTypeHelpButton; /* widgets for internal use */

	Arg al[25];      	/* Arg List */
	register int ac; 	/* Arg Count */
	Widget children[10];    /* Children to manage */
	char text[20];	 	/* text for number conversion */
	XmString xmstrings[10];	/* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, newSynapticTypeString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	newSType = XmCreateDialogShell ( parent, "newSType", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	newSTypeBB = XmCreateBulletinBoard ( newSType, "newSTypeBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newSTypeForm = XmCreateForm ( newSTypeBB, "newSTypeForm", al, ac );
	XmAddTabGroup(newSTypeForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(synapticEQPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newSTypeEqPotLabel = XmCreateLabel ( newSTypeForm, "newSTypeEqPotLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	sprintf(text, "%f", (double) SEQ_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newSTypeEqPotText = XmCreateText ( newSTypeForm, "newSTypeEqPotText", al, ac );

	XmAddTabGroup(newSTypeEqPotText);
	XtAddCallback(newSTypeEqPotText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_SEQ);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) SEQ_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) SEQ_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) SEQ_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newSTypeEqPotScale = XmCreateScale ( newSTypeForm, "newSTypeEqPotScale", al, ac );

	XmAddTabGroup(newSTypeEqPotScale);
	XtAddCallback(newSTypeEqPotScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SEQ);
	XtAddCallback(newSTypeEqPotScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newSTypeEqPotDef = XmCreatePushButton ( newSTypeForm, "newSTypeEqPotDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newSTypeEqPotDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_SEQ);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(ionTypeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	newSTypeIonTypeLabel = XmCreateLabel ( newSTypeForm, "newSTypeIonTypeLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newSTypeRadioBox = XmCreateRadioBox ( newSTypeForm, "newSTypeRadioBox", al, ac );
	XmAddTabGroup(newSTypeRadioBox);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(sodiumString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newSTypeSodiumToggle = XmCreateToggleButtonGadget ( newSTypeRadioBox, "newSTypeSodiumToggle", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newSTypeSodiumToggle, XmNvalueChangedCallback, radio_box2_CB, (caddr_t *) SODIUM);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(potassiumString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	XtSetArg(al[ac], XmNset, TRUE); ac++;	/* Default value */
	newSTypePotassiumToggle = XmCreateToggleButtonGadget ( newSTypeRadioBox, "newSTypePotassiumToggle", al, ac);
	XmStringFree(xmstrings[0]);

	XtAddCallback(newSTypePotassiumToggle, XmNvalueChangedCallback, radio_box2_CB, (caddr_t *) POTASSIUM);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(chemicalString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNselectColor, selectedToggleButtonColor); ac++;
	newSTypeChemicalToggle = XmCreateToggleButtonGadget ( newSTypeRadioBox, "newSTypeChemicalToggle", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newSTypeChemicalToggle, XmNvalueChangedCallback, radio_box2_CB, (caddr_t *) CHEMICAL);

	ac = 0;
	newSTypeSeparator = XmCreateSeparator ( newSTypeForm, "newSTypeSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newSTypeOkButton = XmCreatePushButton ( newSTypeForm, "newSTypeOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newSTypeOkButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_NEW_STYPE);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newSTypeNoButton = XmCreatePushButton ( newSTypeForm, "newSTypeNoButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newSTypeNoButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &newSTypeBB);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	newSTypeHelpButton = XmCreatePushButton ( newSTypeForm, "newSTypeHelpButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(newSTypeHelpButton, XmNactivateCallback, dialog_help2_CB, (caddr_t *) DIALOG_NEW_STYPE);

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( newSTypeEqPotLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newSTypeEqPotLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newSTypeEqPotLabel); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( newSTypeEqPotText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newSTypeEqPotText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newSTypeEqPotText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( newSTypeEqPotScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newSTypeEqPotScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newSTypeEqPotScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( newSTypeEqPotDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 20); ac++;
	XtSetArg(al[ac], XmNtopWidget, newSTypeEqPotLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( newSTypeIonTypeLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, newSTypeIonTypeLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, newSTypeIonTypeLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( newSTypeRadioBox,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newSTypeRadioBox); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( newSTypeSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newSTypeSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( newSTypeOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newSTypeSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
        XtSetValues ( newSTypeNoButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, newSTypeSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( newSTypeHelpButton,al, ac );

	ac = 0;
	children[ac++] = newSTypeSodiumToggle;
	children[ac++] = newSTypePotassiumToggle;
	children[ac++] = newSTypeChemicalToggle;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = newSTypeEqPotLabel;
	children[ac++] = newSTypeEqPotText;
	children[ac++] = newSTypeEqPotScale;
	children[ac++] = newSTypeEqPotDef;
	children[ac++] = newSTypeIonTypeLabel;
	children[ac++] = newSTypeRadioBox;
	children[ac++] = newSTypeSeparator;
	children[ac++] = newSTypeOkButton;
	children[ac++] = newSTypeNoButton;
	children[ac++] = newSTypeHelpButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = newSTypeForm;
	XtManageChildren(children, ac);

} /* end of create_newSType */

/************************************************************************************************************************

 	FUNCTION	: create_addSynapse( parent )
 
	PURPOSE		: creates dialog box for connect to neurons

	RETURNS		: nothing

************************************************************************************************************************/

void create_addSynapse( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	addSynapse,
		addSynapseForm,
		addSynapseStrLabel,
		addSynapseStrDef,
		addSynapseMaxStrLabel,
		addSynapseMaxStrDef,
		addSynapseTTLabel,
		addSynapseTTDef,
		addSynapseTRTLabel,
		addSynapseTRTDef,
		addSynapseTRSLabel,
		addSynapseTRSDef,
		addSynapseTargetLabel,
		addSynapseTargetDef,
		addSynapseSeparator,
		addSynapseTypesLabel,
		addSynapseNumberLabel,
		addSynapseTypeLabel,
		addSynapseEqLabel,
		addSynapseFrame,
		addSynapseScrolledList,
		addSynapseSeparator2,
		addSynapseOkButton,
		addSynapseNoButton,
		addSynapseNewTypeButton,
		addSynapseHelpButton;	/* widgets for internal use */

        Widget children[36];      	/* Children to manage */
        Arg al[64];           		/* Arg List */
        register int ac = 0;   	   	/* Arg Count */
	char	text[20];		/* text for number conversion */
	XmString xmstrings[10];		/* temporary storage for XmStrings */

	/* create widgets */

	XtSetArg(al[ac], XmNtitle, addConnectionString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	addSynapse = XmCreateDialogShell ( parent, "addSynapse", al, ac );

        ac = 0;
        XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
        XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
        XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
        addSynapseBB = XmCreateBulletinBoard ( addSynapse, "addSynapseBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseForm = XmCreateForm ( addSynapseBB, "addSynapseForm", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(synapticStrengthString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	addSynapseStrLabel = XmCreateLabel ( addSynapseForm, "addSynapseStrLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	sprintf(text,"%f", (double) STR_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseStrText = XmCreateText ( addSynapseForm, "addSynapseStrText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) STR_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) STR_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) STR_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseStrScale = XmCreateScale ( addSynapseForm, "addSynapseStrScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseStrDef = XmCreatePushButton ( addSynapseForm, "addSynapseStrDef", al, ac );
	XmStringFree(xmstrings[0]);

        ac = 0;
	xmstrings[0] = XmStringCreateLtoR(synapticMaxStrengthString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	addSynapseMaxStrLabel = XmCreateLabel ( addSynapseForm, "addSynapseMaxStrLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	sprintf(text,"%f", (double) MAXSTR_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseMaxStrText = XmCreateText ( addSynapseForm, "addSynapseMaxStrText", al, ac );

        ac = 0;
        XtSetArg(al[ac], XmNminimum, MAXSTR_MIN); ac++;
        XtSetArg(al[ac], XmNmaximum, MAXSTR_MAX); ac++;
        XtSetArg(al[ac], XmNvalue, MAXSTR_DEF); ac++;
        XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
        XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
        XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
        XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
        addSynapseMaxStrScale = XmCreateScale ( addSynapseForm, "addSynapseMaxStrScale", al, ac );

        ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseMaxStrDef = XmCreatePushButton ( addSynapseForm, "addSynapseMaxStrDef", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(synapticTransmissionString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	addSynapseTTLabel = XmCreateLabel ( addSynapseForm, "addSynapseTTLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	sprintf(text,"%f", (double) TT_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseTTText = XmCreateText ( addSynapseForm, "addSynapseTTText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) TT_MIN * 10); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) TT_MAX * 10); ac++;
	XtSetArg(al[ac], XmNvalue, (int) TT_DEF * 10); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 1); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseTTScale = XmCreateScale ( addSynapseForm, "addSynapseTTScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseTTDef = XmCreatePushButton ( addSynapseForm, "addSynapseTTDef", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(transmitterReleaseString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	addSynapseTRTLabel = XmCreateLabel ( addSynapseForm, "addSynapseTRTLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	sprintf(text,"%f", (double) TRT_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseTRTText = XmCreateText ( addSynapseForm, "addSynapseTRTText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) TRT_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) TRT_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) TRT_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseTRTScale = XmCreateScale ( addSynapseForm, "addSynapseTRTScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseTRTDef = XmCreatePushButton ( addSynapseForm, "addSynapseTRTDef", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(transmitterSatiationString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	addSynapseTRSLabel = XmCreateLabel ( addSynapseForm, "addSynapseTRSLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	sprintf(text,"%f", (double) TRS_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseTRSText = XmCreateText ( addSynapseForm, "addSynapseTRSText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNminimum, (int) TRS_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) TRS_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) TRS_DEF); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseTRSScale = XmCreateScale ( addSynapseForm, "addSynapseTRSScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseTRSDef = XmCreatePushButton ( addSynapseForm, "addSynapseTRSDef", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(targetConnectionString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	addSynapseTargetLabel = XmCreateLabel ( addSynapseForm, "addSynapseTargetLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	sprintf(text,"%d", TARGET_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseTargetText = XmCreateText ( addSynapseForm, "addSynapseTargetText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNminimum, TARGET_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, curNumOfDendSegs); ac++;
	XtSetArg(al[ac], XmNvalue, TARGET_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseTargetScale = XmCreateScale ( addSynapseForm, "addSynapseTargetScale", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseTargetDef = XmCreatePushButton ( addSynapseForm, "addSynapseTargetDef", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	addSynapseSeparator = XmCreateSeparator ( addSynapseForm, "addSynapseSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(synapticTypesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	addSynapseTypesLabel = XmCreateLabel ( addSynapseForm, "addSynapseTypesLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(numberString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	addSynapseNumberLabel = XmCreateLabel ( addSynapseForm, "addSynapseNumberLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(ionTypeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	addSynapseTypeLabel = XmCreateLabel ( addSynapseForm, "addSynapseTypeLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(eqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	addSynapseEqLabel = XmCreateLabel ( addSynapseForm, "addSynapseEqLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseFrame = XmCreateFrame ( addSynapseForm, "addSynapseFrame", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNlistSpacing, 2); ac++;
	XtSetArg(al[ac], XmNvisibleItemCount, 4); ac++;
	XtSetArg(al[ac], XmNitemCount, 0); ac++;
	XtSetArg(al[ac], XmNitems, NULL); ac++;
	XtSetArg(al[ac], XmNselectionPolicy, XmSINGLE_SELECT); ac++;
	XtSetArg(al[ac], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseList = XmCreateScrolledList ( addSynapseFrame, "addSynapseScrolledList", al, ac );
	addSynapseScrolledList = XtParent ( addSynapseList );

	ac = 0;
	addSynapseSeparator2 = XmCreateSeparator ( addSynapseForm, "addSynapseSeparator2", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseOkButton = XmCreatePushButton ( addSynapseForm, "addSynapseOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseNoButton = XmCreatePushButton ( addSynapseForm, "addSynapseNoButton", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(newTypeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseNewTypeButton = XmCreatePushButton ( addSynapseForm, "addSynapseNewTypeButton", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(learnParameterString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNsensitive, FALSE); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseLearnButton = XmCreatePushButton ( addSynapseForm, "addSynapseLearnButton", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	addSynapseHelpButton = XmCreatePushButton ( addSynapseForm, "addSynapseHelpButton", al, ac );
	XmStringFree(xmstrings[0]);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseStrLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 40); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseStrLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseStrText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseStrText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseStrScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseStrScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseStrDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseStrText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseMaxStrLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseMaxStrLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseStrText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseMaxStrText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseMaxStrText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseMaxStrText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseMaxStrScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseMaxStrScale); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseMaxStrScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseMaxStrDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseMaxStrText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTTLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTTLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseStrText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTTText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTTText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseTTText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTTScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTTScale); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseTTScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTTDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTTText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTRTLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTRTLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseStrText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTRTText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTRTText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseTRTText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTRTScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTRTScale); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseTRTScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTRTDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTRTText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTRSLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTRSLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseStrText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTRSText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTRSText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseTRSText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTRSScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTRSScale); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseTRSScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTRSDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTRSText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTargetLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTargetLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseStrText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTargetText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTargetText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseTargetText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTargetScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTargetScale); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseTargetScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTargetDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTargetText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTypesLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTypesLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseNumberLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseNumberLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseNumberLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseTypeLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseTypeLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, addSynapseTypeLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseEqLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseNumberLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseFrame,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseFrame); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseSeparator2,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseSeparator2); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseSeparator2); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 25); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseNoButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseSeparator2); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 50); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseNewTypeButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseSeparator2); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 80); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseLearnButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, addSynapseSeparator2); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( addSynapseHelpButton,al, ac );

	/* add callbacks and tab groups */

	XmAddTabGroup ( addSynapseForm );
	XmAddTabGroup ( addSynapseStrText );
	XmAddTabGroup ( addSynapseStrScale );
        XmAddTabGroup ( addSynapseMaxStrText );
        XmAddTabGroup ( addSynapseMaxStrScale );
	XmAddTabGroup ( addSynapseTTText );
	XmAddTabGroup ( addSynapseTTScale );
	XmAddTabGroup ( addSynapseTRTText );
	XmAddTabGroup ( addSynapseTRTScale );
	XmAddTabGroup ( addSynapseTRSText );
	XmAddTabGroup ( addSynapseTRSScale );
	XmAddTabGroup ( addSynapseTargetText );
	XmAddTabGroup ( addSynapseTargetScale );
	XmAddTabGroup ( addSynapseFrame );
	XmAddTabGroup ( addSynapseList );

	XtAddCallback (addSynapseStrText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_STR);
	XtAddCallback (addSynapseStrScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_STR);
	XtAddCallback (addSynapseStrScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_STR);
	XtAddCallback (addSynapseStrDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_STR);
        XtAddCallback (addSynapseMaxStrText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_MAXSTR);
        XtAddCallback (addSynapseMaxStrScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_MAXSTR);
        XtAddCallback (addSynapseMaxStrScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_MAXSTR);
        XtAddCallback (addSynapseMaxStrDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_MAXSTR);
	XtAddCallback (addSynapseTTText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_TT);
	XtAddCallback (addSynapseTTScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_TT);
	XtAddCallback (addSynapseTTScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_TT);
	XtAddCallback (addSynapseTTDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_TT);
	XtAddCallback (addSynapseTRTText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_TRT);
	XtAddCallback (addSynapseTRTScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_TRT);
	XtAddCallback (addSynapseTRTScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_TRT);
	XtAddCallback (addSynapseTRTDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_TRT);
	XtAddCallback (addSynapseTRSText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_TRS);
	XtAddCallback (addSynapseTRSScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_TRS);
	XtAddCallback (addSynapseTRSScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_TRS);
	XtAddCallback (addSynapseTRSDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_TRS);
	XtAddCallback (addSynapseTargetText, XmNactivateCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_TARGET);
	XtAddCallback (addSynapseTargetScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_TARGET);
	XtAddCallback (addSynapseTargetScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_TARGET);
	XtAddCallback (addSynapseTargetDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_TARGET);
	XtAddCallback (addSynapseList, XmNsingleSelectionCallback, dialog_selection2_CB, (caddr_t *) DIALOG_ADD_SYNAPSE);
	XtAddCallback (addSynapseOkButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_ADD_SYNAPSE);
	XtAddCallback (addSynapseNoButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &addSynapseBB);
	XtAddCallback (addSynapseNoButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &editSynapseBB);
	XtAddCallback (addSynapseNoButton, XmNactivateCallback, remove_selected_objects_from_selectionList_CB,
		(caddr_t *) DIALOG_ADD_SYNAPSE);
	XtAddCallback (addSynapseNewTypeButton, XmNactivateCallback, manage_link_CB, (caddr_t *) &newSTypeBB);
        XtAddCallback (addSynapseLearnButton, XmNactivateCallback, dialog_accept4_CB, (caddr_t *) DIALOG_SELECT_LEARNPARAM);
	XtAddCallback (addSynapseHelpButton, XmNactivateCallback, dialog_help2_CB, (caddr_t *) DIALOG_ADD_SYNAPSE);

	/* manage widgets */

	XtManageChild(addSynapseList);
	ac = 0;
	children[ac++] = addSynapseStrLabel;
	children[ac++] = addSynapseStrText;
	children[ac++] = addSynapseStrScale;
	children[ac++] = addSynapseStrDef;
        children[ac++] = addSynapseMaxStrLabel;
        children[ac++] = addSynapseMaxStrText;
        children[ac++] = addSynapseMaxStrScale;
        children[ac++] = addSynapseMaxStrDef;
	children[ac++] = addSynapseTTLabel;
	children[ac++] = addSynapseTTText;
	children[ac++] = addSynapseTTScale;
	children[ac++] = addSynapseTTDef;
	children[ac++] = addSynapseTRTLabel;
	children[ac++] = addSynapseTRTText;
	children[ac++] = addSynapseTRTScale;
	children[ac++] = addSynapseTRTDef;
	children[ac++] = addSynapseTRSLabel;
	children[ac++] = addSynapseTRSText;
	children[ac++] = addSynapseTRSScale;
	children[ac++] = addSynapseTRSDef;
	children[ac++] = addSynapseTargetLabel;
	children[ac++] = addSynapseTargetText;
	children[ac++] = addSynapseTargetScale;
	children[ac++] = addSynapseTargetDef;
	children[ac++] = addSynapseSeparator;
	children[ac++] = addSynapseTypesLabel;
	children[ac++] = addSynapseNumberLabel;
	children[ac++] = addSynapseTypeLabel;
	children[ac++] = addSynapseEqLabel;
	children[ac++] = addSynapseFrame;
	children[ac++] = addSynapseSeparator2;
	children[ac++] = addSynapseOkButton;
	children[ac++] = addSynapseNoButton;
	children[ac++] = addSynapseNewTypeButton;
	children[ac++] = addSynapseLearnButton;
	children[ac++] = addSynapseHelpButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = addSynapseForm;
	XtManageChildren(children, ac);

} /* end of create_addSynapse */

/************************************************************************************************************************

 	FUNCTION	: create_editSynapse( parent )
 
	PURPOSE		: creates dialog box for edit a connection

	RETURNS		: nothing

************************************************************************************************************************/

void create_editSynapse( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	editSynapse,
		editSynapseForm,
		editSynapseFromLabel,
		editSynapseToLabel,
		editSynapseSeparator,
		editSynapseSynapsesLabel,
		editSynapseNumberLabel,
		editSynapseIonTypeLabel,
		editSynapseEqLabel,
		editSynapseResistanceLabel,
		editSynapseTTLabel,
		editSynapseFrame,
		editSynapseLocationDef,
		editSynapseScrolledList,
		editSynapseSeparator2,
		editSynapseLocationLabel,
		editSynapseSeparator3,
		editSynapseEditButton,
		editSynapseInfoButton,
		editSynapseWindowButton,
		editSynapseDeleteButton,
		editSynapseCancelButton,
		editSynapseHelpButton; /* widgets for internal use */

	Arg al[25];       	/* Arg List */
	register int ac;  	/* Arg Count */
	char	text[20]; 	/* text for number conversion */
	Widget children[24];    /* Children to manage */
	XmString xmstrings[10];	/* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, editSynapseString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	editSynapse = XmCreateDialogShell ( parent, "editSynapse", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	editSynapseBB = XmCreateBulletinBoard ( editSynapse, "editSynapseBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSynapseForm = XmCreateForm ( editSynapseBB, "editSynapseForm", al, ac );
	XmAddTabGroup(editSynapseForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(fromNeuronString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editSynapseFromLabel = XmCreateLabel ( editSynapseForm, "editSynapseFromLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 4); ac++;
	XtSetArg(al[ac], XmNeditable, FALSE); ac++;
	XtSetArg(al[ac], XmNtraversalOn, FALSE); ac++;
	editSynapseFromText = XmCreateText ( editSynapseForm, "editSynapeFromText", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(toNeuronString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editSynapseToLabel = XmCreateLabel ( editSynapseForm, "editSynapseToLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 4); ac++;
	XtSetArg(al[ac], XmNeditable, FALSE); ac++;
	XtSetArg(al[ac], XmNtraversalOn, FALSE); ac++;
	editSynapseToText = XmCreateText ( editSynapseForm, "editSynapseToText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNseparatorType, XmDOUBLE_LINE); ac++;
	editSynapseSeparator = XmCreateSeparator ( editSynapseForm, "editSynapseSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(synapsesString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editSynapseSynapsesLabel = XmCreateLabel ( editSynapseForm, "editSynapseSynapsesLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(numberString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editSynapseNumberLabel = XmCreateLabel ( editSynapseForm, "editSynapseNumberLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(ionTypeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editSynapseIonTypeLabel = XmCreateLabel ( editSynapseForm, "editSynapseIonTypeLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(eqPotentialString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editSynapseEqLabel = XmCreateLabel ( editSynapseForm, "editSynapseEqLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(synapseStrengthString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editSynapseResistanceLabel = XmCreateLabel ( editSynapseForm, "editSynapseResistanceLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(transmissionTimeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editSynapseTTLabel = XmCreateLabel ( editSynapseForm, "editSynapseTTLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSynapseFrame = XmCreateFrame ( editSynapseForm, "editSynapseFrame", al, ac );

	XmAddTabGroup(editSynapseFrame);

	ac = 0;
	XtSetArg(al[ac], XmNlistSpacing, 2); ac++;
	XtSetArg(al[ac], XmNvisibleItemCount, 4); ac++;
	XtSetArg(al[ac], XmNselectionPolicy, XmSINGLE_SELECT); ac++;
	XtSetArg(al[ac], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSynapseList = XmCreateScrolledList ( editSynapseFrame, "editSynapseScrolledList", al, ac );

	XmAddTabGroup(editSynapseList);
	XtAddCallback(editSynapseList, XmNsingleSelectionCallback, dialog_selection2_CB, (caddr_t *) DIALOG_EDIT_SYNAPSE);

	editSynapseScrolledList = XtParent ( editSynapseList );

	ac = 0;
	XtSetArg(al[ac], XmNseparatorType, XmDOUBLE_LINE); ac++;
	editSynapseSeparator2 = XmCreateSeparator ( editSynapseForm, "editSynapseSeparator2", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(locationString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editSynapseLocationLabel = XmCreateLabel ( editSynapseForm, "editSynapseLocationLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	sprintf(text,"%d", TARGET_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSynapseLocationText = XmCreateText ( editSynapseForm, "editSynapseLocationText", al, ac );

	XmAddTabGroup ( editSynapseLocationText );
	XtAddCallback (editSynapseLocationText, XmNactivateCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_LOCATION);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, TARGET_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, curNumOfDendSegs); ac++;
	XtSetArg(al[ac], XmNvalue, TARGET_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSynapseLocationScale = XmCreateScale ( editSynapseForm, "editSynapseLocationScale", al, ac );

	XmAddTabGroup ( editSynapseLocationScale );
	XtAddCallback (editSynapseLocationScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_LOCATION);
	XtAddCallback (editSynapseLocationScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_LOCATION);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSynapseLocationDef = XmCreatePushButton ( editSynapseForm, "editSynapseLocationDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback (editSynapseLocationDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_LOCATION);

	ac = 0;
	editSynapseSeparator3 = XmCreateSeparator ( editSynapseForm, "editSynapseSeparator3", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(editString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSynapseEditButton = XmCreatePushButton ( editSynapseForm, "editSynapseEditButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editSynapseEditButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_EDIT_SYNAPSE);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(infoString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSynapseInfoButton = XmCreatePushButton ( editSynapseForm, "editSynapseInfoButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editSynapseInfoButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_INFO_SYNAPSE);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(attachSynapseWindowString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSynapseWindowButton = XmCreatePushButton ( editSynapseForm, "editSynapseWindowButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editSynapseWindowButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_WINDOW_SYNAPSE);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(deleteString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSynapseDeleteButton = XmCreatePushButton ( editSynapseForm, "editSynapseDeleteButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editSynapseDeleteButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_DELETE_SYNAPSE);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSynapseCancelButton = XmCreatePushButton ( editSynapseForm, "editSynapseCancelButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editSynapseCancelButton, XmNactivateCallback, dialog_cancel2_CB, (caddr_t *) DIALOG_EDIT_SYNAPSE);
	XtAddCallback(editSynapseCancelButton, XmNactivateCallback, remove_selected_objects_from_selectionList_CB,
		(caddr_t *) DIALOG_EDIT_SYNAPSE);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSynapseHelpButton = XmCreatePushButton ( editSynapseForm, "editSynapseHelpButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editSynapseHelpButton, XmNactivateCallback, dialog_help2_CB, (caddr_t *) DIALOG_EDIT_SYNAPSE);

	/* attach widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseFromLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSynapseFromLabel); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseFromText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseFromText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseToLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseToLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSynapseFromText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseToText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseToText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseSynapsesLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseSynapsesLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseNumberLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseNumberLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSynapseNumberLabel); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseIonTypeLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseIonTypeLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSynapseIonTypeLabel); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseEqLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseEqLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSynapseEqLabel); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseResistanceLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseResistanceLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSynapseResistanceLabel); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseTTLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseNumberLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseFrame,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseFrame); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseSeparator2,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseSeparator2); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseLocationLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseLocationLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSynapseLocationLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseLocationText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseLocationText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSynapseLocationText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseLocationScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseLocationScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSynapseLocationScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseLocationDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseLocationText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseSeparator3,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseSeparator3); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseEditButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseSeparator3); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSynapseEditButton); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseInfoButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseSeparator3); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSynapseInfoButton); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseWindowButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseSeparator3); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSynapseWindowButton); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseDeleteButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseSeparator3); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSynapseDeleteButton); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseCancelButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSynapseSeparator3); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSynapseHelpButton,al, ac );

	/* manage widgets */

	XtManageChild(editSynapseList);

	ac = 0;
	children[ac++] = editSynapseFromLabel;
	children[ac++] = editSynapseFromText;
	children[ac++] = editSynapseToLabel;
	children[ac++] = editSynapseToText;
	children[ac++] = editSynapseSeparator;
	children[ac++] = editSynapseSynapsesLabel;
	children[ac++] = editSynapseNumberLabel;
	children[ac++] = editSynapseIonTypeLabel;
	children[ac++] = editSynapseEqLabel;
	children[ac++] = editSynapseResistanceLabel;
	children[ac++] = editSynapseTTLabel;
	children[ac++] = editSynapseFrame;
	children[ac++] = editSynapseSeparator2;
	children[ac++] = editSynapseLocationLabel;
	children[ac++] = editSynapseLocationText;
	children[ac++] = editSynapseLocationScale;
	children[ac++] = editSynapseLocationDef;
	children[ac++] = editSynapseSeparator3;
	children[ac++] = editSynapseEditButton;
	children[ac++] = editSynapseInfoButton;
	children[ac++] = editSynapseWindowButton;
	children[ac++] = editSynapseCancelButton;
	children[ac++] = editSynapseHelpButton;
	children[ac++] = editSynapseDeleteButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = editSynapseForm;
	XtManageChildren(children, ac);

} /* end of create_editSynapse */

/************************************************************************************************************************

 	FUNCTION	: create_editSimPars( parent )
 
	PURPOSE		: creates dialog box for edit simulation parameters

	RETURNS		: nothing

************************************************************************************************************************/

void create_editSimPars( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	editSimPars,
		editSimParsForm,
		editSimParsLengthLabel,
		editSimParsStepSizeLabel,
		neuronActivityIntervalLabel,
		editSimParsSeparator,
		editSimParsOkButton,
		editSimParsCancelButton,
		editSimParsHelpButton,
		editSimParsSimLenDef,
		editSimParsSimSizeDef,
		neuronActivityIntervalDef;	/* widgets for internal use */

	Arg al[25];       	/* Arg List */
	register int ac;  	/* Arg Count */
	Widget children[16];    /* Children to manage */
	char	text[20]; 	/* text for number conversion */
	XmString xmstrings[10];	/* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, simulationParameterString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	editSimPars = XmCreateDialogShell ( parent, "editSimPars", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	editSimParsBB = XmCreateBulletinBoard ( editSimPars, "editSimParsBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSimParsForm = XmCreateForm ( editSimParsBB, "editSimParsForm", al, ac );
	XmAddTabGroup(editSimParsForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(neuronActivityIntervalString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	neuronActivityIntervalLabel = XmCreateLabel ( editSimParsForm, "neuronActivityIntervalLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	sprintf(text,"%d", NACTINT_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	neuronActivityIntervalText = XmCreateText ( editSimParsForm, "neuronActivityIntervalText", al, ac );

	XmAddTabGroup(neuronActivityIntervalText);
	XtAddCallback(neuronActivityIntervalText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_NACTINT);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, NACTINT_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, NACTINT_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, NACTINT_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	neuronActivityIntervalScale = XmCreateScale ( editSimParsForm, "neuronActivityIntervalScale", al, ac );

	XmAddTabGroup(neuronActivityIntervalScale);
	XtAddCallback(neuronActivityIntervalScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_NACTINT);
	XtAddCallback(neuronActivityIntervalScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_NACTINT);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	neuronActivityIntervalDef = XmCreatePushButton ( editSimParsForm, "neuronActivityIntervalDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(neuronActivityIntervalDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_NACTINT);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(simDurationString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editSimParsLengthLabel = XmCreateLabel ( editSimParsForm, "editSimParsLengthLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	sprintf(text,"%f", (double) SIMLEN_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSimParsSimLenText = XmCreateText ( editSimParsForm, "editSimParsSimLenText", al, ac );

	XmAddTabGroup(editSimParsSimLenText);
	XtAddCallback(editSimParsSimLenText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_SIMLEN);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) SIMLEN_MIN); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) SIMLEN_MAX); ac++;
	XtSetArg(al[ac], XmNvalue, (int) SIMLEN_DEF); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSimParsSimLenScale = XmCreateScale ( editSimParsForm, "editSimParsSimLenScale", al, ac );

	XmAddTabGroup(editSimParsSimLenScale);
	XtAddCallback(editSimParsSimLenScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SIMLEN);
	XtAddCallback(editSimParsSimLenScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SIMLEN);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSimParsSimLenDef = XmCreatePushButton ( editSimParsForm, "editSimParsSimLenDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editSimParsSimLenDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_SIMLEN);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(stepCurrentString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	editSimParsStepSizeLabel = XmCreateLabel ( editSimParsForm, "editSimParsStepSizeLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	sprintf(text,"%f", (double) SIMSIZE_DEF);
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNvalue, text); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSimParsStepSizeText = XmCreateText ( editSimParsForm, "editSimParsStepSizeText", al, ac );

	XmAddTabGroup(editSimParsStepSizeText);
	XtAddCallback(editSimParsStepSizeText, XmNvalueChangedCallback, dialog_text2_CB, (caddr_t *) DIALOG_TEXT_SIMSIZE);

	ac = 0;
	XtSetArg(al[ac], XmNminimum, (int) (SIMSIZE_MIN * 100)); ac++;
	XtSetArg(al[ac], XmNmaximum, (int) (SIMSIZE_MAX * 100)); ac++;
	XtSetArg(al[ac], XmNvalue, (int) (SIMSIZE_DEF * 100)); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
	XtSetArg(al[ac], XmNscaleHeight, 25); ac++;
	XtSetArg(al[ac], XmNdecimalPoints, 2); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSimParsStepSizeScale = XmCreateScale ( editSimParsForm, "editSimParsStepSizeScale", al, ac );

	XmAddTabGroup(editSimParsStepSizeScale);
	XtAddCallback(editSimParsStepSizeScale, XmNdragCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SIMSIZE);
	XtAddCallback(editSimParsStepSizeScale, XmNvalueChangedCallback, dialog_scale2_CB, (caddr_t *) DIALOG_SCALE_SIMSIZE);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(defaultString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSimParsSimSizeDef = XmCreatePushButton ( editSimParsForm, "editSimParsSimSizeDef", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editSimParsSimSizeDef, XmNactivateCallback, dialog_def2_CB, (caddr_t *) DIALOG_DEF_SIMSIZE);

	ac = 0;
	editSimParsSeparator = XmCreateSeparator ( editSimParsForm, "editSimParsSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(okString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSimParsOkButton = XmCreatePushButton ( editSimParsForm, "editSimParsOkButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editSimParsOkButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_SIMPARS);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(noString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSimParsCancelButton = XmCreatePushButton ( editSimParsForm, "editSimParsCancelButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editSimParsCancelButton, XmNactivateCallback, unmanage_link_CB, (caddr_t *) &editSimParsBB);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(helpString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	editSimParsHelpButton = XmCreatePushButton ( editSimParsForm, "editSimParsHelpButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(editSimParsHelpButton, XmNactivateCallback, dialog_help2_CB, (caddr_t *) DIALOG_SIMPARS);

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( neuronActivityIntervalLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, neuronActivityIntervalLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, neuronActivityIntervalLabel); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( neuronActivityIntervalText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, neuronActivityIntervalText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, neuronActivityIntervalText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( neuronActivityIntervalScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, neuronActivityIntervalScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, neuronActivityIntervalScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( neuronActivityIntervalDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, neuronActivityIntervalText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSimParsLengthLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSimParsLengthLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, neuronActivityIntervalLabel); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSimParsSimLenText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSimParsSimLenText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSimParsSimLenText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSimParsSimLenScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSimParsSimLenScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSimParsSimLenScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSimParsSimLenDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSimParsSimLenText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSimParsStepSizeLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSimParsStepSizeLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, neuronActivityIntervalLabel); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSimParsStepSizeText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSimParsStepSizeText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSimParsStepSizeText); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSimParsStepSizeScale,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSimParsStepSizeScale); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, editSimParsStepSizeScale); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSimParsSimSizeDef,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSimParsStepSizeText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSimParsSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSimParsSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSimParsOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSimParsSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNrightPosition, 53); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSimParsCancelButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, editSimParsSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( editSimParsHelpButton,al, ac );

	ac = 0;
	children[ac++] = neuronActivityIntervalLabel;
	children[ac++] = neuronActivityIntervalText;
	children[ac++] = neuronActivityIntervalScale;
	children[ac++] = neuronActivityIntervalDef;
	children[ac++] = editSimParsLengthLabel;
	children[ac++] = editSimParsSimLenText;
	children[ac++] = editSimParsSimLenScale;
	children[ac++] = editSimParsSimLenDef;
	children[ac++] = editSimParsStepSizeLabel;
	children[ac++] = editSimParsStepSizeText;
	children[ac++] = editSimParsStepSizeScale;
	children[ac++] = editSimParsSimSizeDef;
	children[ac++] = editSimParsSeparator;
	children[ac++] = editSimParsOkButton;
	children[ac++] = editSimParsCancelButton;
	children[ac++] = editSimParsHelpButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = editSimParsForm;
	XtManageChildren(children, ac);

} /* end of create_editSimPars */

/************************************************************************************************************************

 	FUNCTION	: create_simInf( parent )
 
	PURPOSE		: creates dialog box for simulation information parameters

	RETURNS		: nothing

************************************************************************************************************************/

void create_simInf( parent )
Widget parent;	/* widget id of parent widget */
{
	Widget 	simInf,
		simInfForm,
		simInfStatusLabel,
		simInfCompletedLabel,
		simInfLengthLabel,
		simInfStartButton,
		simInfPauseButton,
		simInfSingleStepButton,
		simInfSeparator; /* widgets for internal use */

	Arg al[25];      	/* Arg List */
	Widget children[10];    /* Children to manage */
	register int ac; 	/* Arg Count */
	XmString xmstrings[10];	/* temporary storage for XmStrings */

	/* create widgets */

	ac = 0;
	XtSetArg(al[ac], XmNtitle, simInfString); ac++;
	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	simInf = XmCreateDialogShell ( parent, "simInf", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmarginWidth, 10); ac++;
	XtSetArg(al[ac], XmNmarginHeight, 10); ac++;
	XtSetArg(al[ac], XmNautoUnmanage, TRUE); ac++;
	simInfBB = XmCreateBulletinBoard ( simInf, "simInfBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	simInfForm = XmCreateForm ( simInfBB, "simInfForm", al, ac );
	XmAddTabGroup(simInfForm);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(simStatusString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	simInfStatusLabel = XmCreateLabel ( simInfForm, "simInfStatusLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(simTimeString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	simInfCompletedLabel = XmCreateLabel ( simInfForm, "simInfCompletedLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNeditable, FALSE); ac++;
	XtSetArg(al[ac], XmNvalue, "0.0"); ac++;
	XtSetArg(al[ac], XmNtraversalOn, FALSE); ac++;
	simInfCompletedText = XmCreateText ( simInfForm, "simInfCompletedText", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(simDurationString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	simInfLengthLabel = XmCreateLabel ( simInfForm, "simInfLengthLabel", al, ac );
	XmStringFree(xmstrings[0]);

	ac = 0;
	XtSetArg(al[ac], XmNcolumns, 10); ac++;
	XtSetArg(al[ac], XmNeditable, FALSE); ac++;
	XtSetArg(al[ac], XmNtraversalOn, FALSE); ac++;
	simInfLengthText = XmCreateText ( simInfForm, "simInfLengthText", al, ac );

	ac = 0;
	simInfSeparator = XmCreateSeparator ( simInfForm, "simInfSeparator", al, ac );

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(startString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	simInfStartButton = XmCreatePushButton ( simInfForm, "simInfStartButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(simInfStartButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_SIMINF_START);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(pauseString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	simInfPauseButton = XmCreatePushButton ( simInfForm, "simInfPauseButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(simInfPauseButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_SIMINF_PAUSE);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(stopString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	simInfStopButton = XmCreatePushButton ( simInfForm, "simInfStopButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(simInfStopButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_SIMINF_STOP);

	ac = 0;
	xmstrings[0] = XmStringCreateLtoR(singleStepString, defaultFont);
	XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
	XtSetArg(al[ac], XmNtraversalOn, TRUE); ac++;
	simInfSingleStepButton = XmCreatePushButton ( simInfForm, "simInfSingleStepButton", al, ac );
	XmStringFree(xmstrings[0]);

	XtAddCallback(simInfSingleStepButton, XmNactivateCallback, dialog_accept2_CB, (caddr_t *) DIALOG_SIMINF_STEP);

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftOffset, 50); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( simInfStatusLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, simInfStatusLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( simInfCompletedLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, simInfCompletedLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 20); ac++;
	XtSetArg(al[ac], XmNleftWidget, simInfCompletedLabel); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( simInfCompletedText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, simInfCompletedText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( simInfLengthLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, simInfLengthLabel); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftWidget, simInfCompletedText); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( simInfLengthText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, simInfLengthText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( simInfSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, simInfSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( simInfStartButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, simInfSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, simInfStartButton); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( simInfPauseButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, simInfSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, simInfPauseButton); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( simInfStopButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, simInfSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, simInfStopButton); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( simInfSingleStepButton,al, ac );

	ac = 0;
	children[ac++] = simInfStatusLabel;
	children[ac++] = simInfCompletedLabel;
	children[ac++] = simInfLengthLabel;
	children[ac++] = simInfCompletedText;
	children[ac++] = simInfLengthText;
	children[ac++] = simInfSeparator;
	children[ac++] = simInfPauseButton;
	children[ac++] = simInfStopButton;
	children[ac++] = simInfStartButton;
	children[ac++] = simInfSingleStepButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = simInfForm;
	XtManageChildren(children, ac);

} /* end of create_simInf */

/************************************************************************************************************************

 	FUNCTION	: set_synaptic_types(void)
 
	PURPOSE		: set possible synaptic types in add synapse list widget

	RETURNS		: nothing

************************************************************************************************************************/
void set_synaptic_types()
{
	Arg		args[20];		/* argument list for manipulating widgets */
	Cardinal 	n;			/* used as argument counter for manipulating widgets */
	XmString	str = NULL;		/* single list entry for list widget */
	char		type[20],		/* synaptic type */
			listString[256];	/* self constructed item for a list widget */
	int		i;			/* loop variable */

	/* if complex model selected, set learnParam button sensitive */

	if (complexModel) /* complex model ? */
	{
		XtSetSensitive(addSynapseLearnButton, TRUE);
	}
	else /* no complex model */
	{
		XtSetSensitive(addSynapseLearnButton, FALSE);
	}

	/* clear list in the add synapse list widget */

	n = 0;
	XtSetArg(args[n], XmNitemCount, 0); n++;
	XtSetArg(args[n], XmNitems, NULL); n++;
	XtSetValues(addSynapseList, args, n);

	/* loop through all existing synpatic types */

	for (i = 0; i < numTypes; i++)
	{
		switch (synapseTypes[i].ionType)
		{
		case 1:
			strcpy(type, sodiumString);
			break;

		case 2:
			strcpy(type, potassiumString);
			break;

		case 3:
			strcpy(type, chemicalString);
			break;

		case 4:
			strcpy(type, electricalString);
			break;
		}

		if (synapseTypes[i].ionType == 4)	/* electrical synapse ? */
			sprintf(listString, "%-18d%-22s", i, type);
		else	/* chemical synapse */
			sprintf(listString, "%-18d%-22s%-+#f", i, type,
				(double) synapseTypes[i].equilPotential * E_SCALE);

		/* build single list entry */

		str = XmStringCreateLtoR(listString, defaultFont);

		/* add list entry into list widget */

		XmListAddItemUnselected(addSynapseList, str, 0);
	}

	/* free the allocated memory for the string */

	XmStringFree(str);

} /* end of set_synaptic_types */

/************************************************************************************************************************

 	FUNCTION	: dialog_accept2_CB(w, client_data, call_data)
 
	PURPOSE		: callback for ok buttons

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_accept2_CB(w, client_data, call_data)
Widget          w;                      /*  widget id           */
caddr_t         client_data;            /*  data from application   */
caddr_t		call_data; 		/*  data from widget class  */
{
	Arg		args[20];		/* argument list for manipulating widgets */
	Cardinal 	n;			/* used as argument counter for manipulating widgets */
	XmString	str = NULL,		/* single list entry for list widget */
			xmstrings[10];		/* temporary storage for XmStrings */
	XmStringTable	*items = NULL;		/* contains the items of the add synapse list widget */
	char		textnumber[20],		/* number as string */
			info[4096],		/* information string for info about object box */
			currents[512],		/* current information for info about object box */
			*value = NULL,		/* value of a text widget */
			*item = NULL,		/* used to get an item in a list of a list widget */
			val[20],		/* used for double to string conversion */
			type[20],		/* synaptic type */
			listString[256],	/* self constructed item for a list widget */
			*filename = NULL,	/* selected filename */
			*ptr,			/* pointer to filename; needed to look for filename extension */
			temp[128];		/* full pathname and filename */
	unsigned int	graphLength;		/* length of a graph for reallocation */
	short int	decimals;		/* number of decimals for scale widget */
	double		number;			/* number of scale value */
	int		num,			/* used as item counter for list widgets */
			itemCount,		/* number of items in a list widget */
			sF,			/* scaling factor */
			scaleValue,		/* value of scale widget */
			fg, bg,			/* foreground and background color */
			i;			/* loop variable */
	unsigned long	poolNumber,		/* number of pools in net */
			senderNumber,		/* number of senders in net */
			axoSenderNumber,	/* number of axo-axonic senders in net */
			processQueueMemory,	/* number of allocated memory with process queues */
			neuronMemory,		/* memory for a standard neuron */
			graphMemory,		/* number of allocated memory for neuron graphs */
			graphSMemory,		/* number of allocated memory for synapse graphs */
			programSize,		/* size of program */
			totalMemory;		/* total memory used by program */
	Widget		button,
			questionDialog,
			questionMessageBox;	/* internal widget ids */
	Boolean		newType = TRUE;		/* flag which indicates if the type is new or exists */
	FILE		*fp, *pipe;		/* file pointer and pipe pointer */
	SelectionListNeurons	*actptr;	/* pointer to selected neurons */
	SelectionListSynapses	*actualSynapse;	/* pointer to selected synapses */
	Connection 		*connection;	/* current synapse */
	ChemicalPool		*currentPool;	/* current pool */
	XmFileSelectionBoxCallbackStruct *selection = (XmFileSelectionBoxCallbackStruct *) call_data;


	/* check number dependend on the widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_SIMINF_START:	/* start of simulation in simulation information dialog box */

		/* update graphs of neurons all 100 simulation steps */

		if (workProcId)
			XtRemoveWorkProc(workProcId);
		workProcId = XtAddWorkProc(run_simulation_step, (caddr_t *) 100);

		break;

	case DIALOG_SIMINF_PAUSE:	/* pause of simulation in simulation information dialog box */

		if (workProcId)
			XtRemoveWorkProc(workProcId);

		break;

	case DIALOG_SIMINF_STOP:	/* stop of simulation in simulation information dialog box */

		if (workProcId)
			XtRemoveWorkProc(workProcId);
		workProcId = (XtWorkProcId) NULL;
		XtUnmanageChild(simInfBB);

		break;

	case DIALOG_SIMINF_STEP:	/* single step of simulation in simulation information dialog box */

		if (workProcId)
			XtRemoveWorkProc(workProcId);
		workProcId = XtAddWorkProc(run_simulation_step, (caddr_t *) 1);

		break;

	case DIALOG_SELECT_CHANNELS:	/* fill up text fields in ion channel mask with default values */

		currentNeuron = selectionListNeuronsHead->neuronPtr;

		if (networkmodel == 1)	/* OnOff - Model */
		{
			channelsSelection.NAEQ = ONOFF_NA_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.NAEQ);
			XmTextSetString(onOffParamsNaEqPotText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(onOffParamsNaEqPotScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.NAEQ * sF);
			XmScaleSetValue(onOffParamsNaEqPotScale, scaleValue);

			channelsSelection.NACON = ONOFF_NA_CONDUCTANCE * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.NACON);
			XmTextSetString(onOffParamsNaConductanceText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(onOffParamsNaConductanceScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.NACON * sF);
			XmScaleSetValue(onOffParamsNaConductanceScale, scaleValue);

			channelsSelection.NADUR = ONOFF_NA_DURATION * T_SCALE;
			sprintf(textnumber,"%f", channelsSelection.NADUR);
			XmTextSetString(onOffParamsNaDurText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(onOffParamsNaDurScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.NADUR * sF);
			XmScaleSetValue(onOffParamsNaDurScale, scaleValue);

			channelsSelection.KEQ = ONOFF_K_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.KEQ);
			XmTextSetString(onOffParamsKEqPotText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(onOffParamsKEqPotScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.KEQ * sF);
			XmScaleSetValue(onOffParamsKEqPotScale, scaleValue);

			channelsSelection.KCON = ONOFF_K_CONDUCTANCE * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.KCON);
			XmTextSetString(onOffParamsKConductanceText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(onOffParamsKConductanceScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.KCON * sF);
			XmScaleSetValue(onOffParamsKConductanceScale, scaleValue);

			channelsSelection.KSTART = ONOFF_K_START * T_SCALE;
			sprintf(textnumber,"%f", channelsSelection.KSTART);
			XmTextSetString(onOffParamsKStartText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(onOffParamsKStartScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.KSTART * sF);
			XmScaleSetValue(onOffParamsKStartScale, scaleValue);

			channelsSelection.KDUR = ONOFF_K_DURATION * T_SCALE;
			sprintf(textnumber,"%f", channelsSelection.KDUR);
			XmTextSetString(onOffParamsKDurText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(onOffParamsKDurScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.KDUR * sF);
			XmScaleSetValue(onOffParamsKDurScale, scaleValue);

			channelsSelection.CAEQ = ONOFF_CA_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.CAEQ);
			XmTextSetString(onOffParamsCaEqPotText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(onOffParamsCaEqPotScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.CAEQ * sF);
			XmScaleSetValue(onOffParamsCaEqPotScale, scaleValue);

			channelsSelection.CACON = ONOFF_CA_CONDUCTANCE * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.CACON);
			XmTextSetString(onOffParamsCaConductanceText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(onOffParamsCaConductanceScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.CACON * sF);
			XmScaleSetValue(onOffParamsCaConductanceScale, scaleValue);

			channelsSelection.CASTART = ONOFF_CA_START * T_SCALE;
			sprintf(textnumber,"%f", channelsSelection.CASTART);
			XmTextSetString(onOffParamsCaStartText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(onOffParamsCaStartScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.CASTART * sF);
			XmScaleSetValue(onOffParamsCaStartScale, scaleValue);

			channelsSelection.CADUR = ONOFF_CA_DURATION * T_SCALE;
			sprintf(textnumber,"%f", channelsSelection.CADUR);
			XmTextSetString(onOffParamsCaDurText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(onOffParamsCaDurScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.CADUR * sF);
			XmScaleSetValue(onOffParamsCaDurScale, scaleValue);

			channelsSelection.STH = ONOFF_SPIKE_THRESHOLD * E_SCALE;
			sprintf(textnumber,"%f",channelsSelection.STH);
			XmTextSetString(onOffParamsSpikeThresholdText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(onOffParamsSpikeThresholdScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.STH * sF);
			XmScaleSetValue(onOffParamsSpikeThresholdScale, scaleValue);

			XtManageChild(onOffParamsBB);
		}
		else if (networkmodel == 2)	/* SWIM model */
		{
			channelsSelection.NAEQ = SWIM_NA_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.NAEQ);
			XmTextSetString(swimParamsNaEqText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(swimParamsNaEqScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.NAEQ * sF);
			XmScaleSetValue(swimParamsNaEqScale, scaleValue);

			channelsSelection.NACON = SWIM_NA_G * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.NACON);
			XmTextSetString(swimParamsNaConText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(swimParamsNaConScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.NACON * sF);
			XmScaleSetValue(swimParamsNaConScale, scaleValue);

			channelsSelection.KEQ = SWIM_K_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.KEQ);
			XmTextSetString(swimParamsKEqText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(swimParamsKEqScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.KEQ * sF);
			XmScaleSetValue(swimParamsKEqScale, scaleValue);

			channelsSelection.KCON = SWIM_K_G * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.KCON);
			XmTextSetString(swimParamsKConText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(swimParamsKConScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.KCON * sF);
			XmScaleSetValue(swimParamsKConScale, scaleValue);

			channelsSelection.CAEQ = SWIM_CA_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.CAEQ);
			XmTextSetString(swimParamsCaEqText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(swimParamsCaEqScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.CAEQ * sF);
			XmScaleSetValue(swimParamsCaEqScale, scaleValue);

			channelsSelection.CACON = SWIM_CA_G * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.CACON);
			XmTextSetString(swimParamsCaConText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(swimParamsCaConScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.CACON * sF);
			XmScaleSetValue(swimParamsCaConScale, scaleValue);

			channelsSelection.STH = SWIM_SPIKE_THRESHOLD * E_SCALE;
			sprintf(textnumber,"%f",channelsSelection.STH);
			XmTextSetString(swimParamsSpikeThresholdText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(swimParamsSpikeThresholdScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.STH * sF);
			XmScaleSetValue(swimParamsSpikeThresholdScale, scaleValue);

			XtManageChild(swimParamsBB);
		}
		else if (networkmodel == 3)	/* HH model */
		{
			channelsSelection.NAEQ = HH_NA_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.NAEQ);
			XmTextSetString(hhParamsNaEqText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(hhParamsNaEqScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.NAEQ * sF);
			XmScaleSetValue(hhParamsNaEqScale, scaleValue);

			channelsSelection.NACON = HH_NA_G * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.NACON);
			XmTextSetString(hhParamsNaConText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(hhParamsNaConScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.NACON * sF);
			XmScaleSetValue(hhParamsNaConScale, scaleValue);

			channelsSelection.KEQ = HH_K_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.KEQ);
			XmTextSetString(hhParamsKEqText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(hhParamsKEqScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.KEQ * sF);
			XmScaleSetValue(hhParamsKEqScale, scaleValue);

			channelsSelection.KCON = HH_K_G * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.KCON);
			XmTextSetString(hhParamsKConText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(hhParamsKConScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.KCON * sF);
			XmScaleSetValue(hhParamsKConScale, scaleValue);

			channelsSelection.STH = HH_SPIKE_THRESHOLD * E_SCALE;
			sprintf(textnumber,"%f",channelsSelection.STH);
			XmTextSetString(hhParamsSpikeThresholdText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(hhParamsSpikeThresholdScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.STH * sF);
			XmScaleSetValue(hhParamsSpikeThresholdScale, scaleValue);

			XtManageChild(hhParamsBB);
		}
		else if (networkmodel == 4)	/* GB model */
		{
			channelsSelection.NAEQ = GB_NA_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.NAEQ);
			XmTextSetString(gbParamsNaEqText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsNaEqScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.NAEQ * sF);
			XmScaleSetValue(gbParamsNaEqScale, scaleValue);

			channelsSelection.NACON = GB_NA_G * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.NACON);
			XmTextSetString(gbParamsNaConText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsNaConScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.NACON * sF);
			XmScaleSetValue(gbParamsNaConScale, scaleValue);

			channelsSelection.KEQ = GB_K_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.KEQ);
			XmTextSetString(gbParamsKEqText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsKEqScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.KEQ * sF);
			XmScaleSetValue(gbParamsKEqScale, scaleValue);

			channelsSelection.KCON = GB_K_G * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.KCON);
			XmTextSetString(gbParamsKConText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsKConScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.KCON * sF);
			XmScaleSetValue(gbParamsKConScale, scaleValue);

			channelsSelection.CA1CON = GB_CA1_G * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.CA1CON);
			XmTextSetString(gbParamsCa1ConText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsCa1ConScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.CA1CON * sF);
			XmScaleSetValue(gbParamsCa1ConScale, scaleValue);

			channelsSelection.CA2CON = GB_CA2_G * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.CA2CON);
			XmTextSetString(gbParamsCa2ConText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsCa2ConScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.CA2CON * sF);
			XmScaleSetValue(gbParamsCa2ConScale, scaleValue);

			channelsSelection.KCAEQ = GB_KCA_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.KCAEQ);
			XmTextSetString(gbParamsKCAEqText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsKCAEqScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.KCAEQ * sF);
			XmScaleSetValue(gbParamsKCAEqScale, scaleValue);

			channelsSelection.KCACON = GB_KCA_G * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.KCACON);
			XmTextSetString(gbParamsKCAConText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsKCAConScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.KCACON * sF);
			XmScaleSetValue(gbParamsKCAConScale, scaleValue);

			channelsSelection.AEQ = GB_A_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.AEQ);
			XmTextSetString(gbParamsAEqText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsAEqScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.AEQ * sF);
			XmScaleSetValue(gbParamsAEqScale, scaleValue);

			channelsSelection.ACON = GB_A_G * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.ACON);
			XmTextSetString(gbParamsAConText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsAConScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.ACON * sF);
			XmScaleSetValue(gbParamsAConScale, scaleValue);

			channelsSelection.IREQ = GB_IR_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.IREQ);
			XmTextSetString(gbParamsIREqText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsIREqScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.IREQ * sF);
			XmScaleSetValue(gbParamsIREqScale, scaleValue);

			channelsSelection.IRCON = GB_IR_G * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.IRCON);
			XmTextSetString(gbParamsIRConText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsIRConScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.IRCON * sF);
			XmScaleSetValue(gbParamsIRConScale, scaleValue);

			channelsSelection.PEQ = GB_P_E * E_SCALE;
			sprintf(textnumber,"%f", channelsSelection.PEQ);
			XmTextSetString(gbParamsPEqText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsPEqScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.PEQ * sF);
			XmScaleSetValue(gbParamsPEqScale, scaleValue);

			channelsSelection.PCON = GB_P_G * S_SCALE;
			sprintf(textnumber,"%f", channelsSelection.PCON);
			XmTextSetString(gbParamsPConText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsPConScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.PCON * sF);
			XmScaleSetValue(gbParamsPConScale, scaleValue);

			channelsSelection.STH = GB_SPIKE_THRESHOLD * E_SCALE;
			sprintf(textnumber,"%f",channelsSelection.STH);
			XmTextSetString(gbParamsSpikeThresholdText, textnumber);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(gbParamsSpikeThresholdScale, args, n);
			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (channelsSelection.STH * sF);
			XmScaleSetValue(gbParamsSpikeThresholdScale, scaleValue);

			XtManageChild(gbParamsBB);
		}
		break;

	case DIALOG_SELECT_NEURON:	/* fill up text fields in edit neuron mask with default values */

		currentNeuron = selectionListNeuronsHead->neuronPtr;

		neuronSelection.TOD = SOMA_Gcore * S_SCALE;
		sprintf(textnumber,"%f", neuronSelection.TOD);
		XmTextSetString(editNeuronToDendritConductanceText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronToDendritConductanceScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (neuronSelection.TOD * sF);
		XmScaleSetValue(editNeuronToDendritConductanceScale, scaleValue);

		neuronSelection.POTENTIAL = SOMA_E_INITIAL * E_SCALE;
		sprintf(textnumber,"%f", neuronSelection.POTENTIAL);
		XmTextSetString(editNeuronPotentialText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronPotentialScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (neuronSelection.POTENTIAL * sF);
		XmScaleSetValue(editNeuronPotentialScale, scaleValue);

		neuronSelection.CAP = SOMA_Cm * C_SCALE;
		sprintf(textnumber,"%f", neuronSelection.CAP);
		XmTextSetString(editNeuronCapacityText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronCapacityScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (neuronSelection.CAP * sF);
		XmScaleSetValue(editNeuronCapacityScale, scaleValue);

		neuronSelection.LEAK = SOMA_Eleak_INITIAL * E_SCALE;
		sprintf(textnumber,"%f", neuronSelection.LEAK);
		XmTextSetString(editNeuronLeakText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronLeakScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (neuronSelection.LEAK * sF);
		XmScaleSetValue(editNeuronLeakScale, scaleValue);

		neuronSelection.CONDUCTANCE = SOMA_REST_Gm * S_SCALE;
		sprintf(textnumber,"%f", neuronSelection.CONDUCTANCE);
		XmTextSetString(editNeuronConductanceText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronConductanceScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (neuronSelection.CONDUCTANCE * sF);
		XmScaleSetValue(editNeuronConductanceScale, scaleValue);

		neuronSelection.TOS = DENDRITE_Gcore * S_SCALE;
		sprintf(textnumber,"%f", neuronSelection.TOS);
		XmTextSetString(editNeuronToSomaConductanceText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronToSomaConductanceScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (neuronSelection.TOS * sF);
		XmScaleSetValue(editNeuronToSomaConductanceScale, scaleValue);

		neuronSelection.DPOT = DENDRITE_E_INITIAL * E_SCALE;
		sprintf(textnumber,"%f", neuronSelection.DPOT);
		XmTextSetString(editNeuronDPotentialText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDPotentialScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (neuronSelection.DPOT * sF);
		XmScaleSetValue(editNeuronDPotentialScale, scaleValue);

		neuronSelection.DCAP = DENDRITE_Cm * C_SCALE;
		sprintf(textnumber,"%f", neuronSelection.DCAP);
		XmTextSetString(editNeuronDCapacityText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDCapacityScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (neuronSelection.DCAP * sF);
		XmScaleSetValue(editNeuronDCapacityScale, scaleValue);

		neuronSelection.DLEAK = DENDRITE_Eleak_INITIAL * E_SCALE;
		sprintf(textnumber,"%f", neuronSelection.DLEAK);
		XmTextSetString(editNeuronDLeakText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDLeakScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (neuronSelection.DLEAK * sF);
		XmScaleSetValue(editNeuronDLeakScale, scaleValue);

		neuronSelection.DCON = DENDRITE_REST_Gm * S_SCALE;
		sprintf(textnumber,"%f", neuronSelection.DCON);
		XmTextSetString(editNeuronDConductanceText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDConductanceScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (neuronSelection.DCON * sF);
		XmScaleSetValue(editNeuronDConductanceScale, scaleValue);

		XtManageChild(editNeuronBB);

		break;

	case DIALOG_SELECT_CURRENT:	/* fill up text fields in edit current mask with default values */

		currentNeuron = selectionListNeuronsHead->neuronPtr;

		if (SDSTRT > LTSTOP)
			SDSTRT = LTSTOP;

		XmScaleSetValue(editCurrentDendritStartScale, DSTART_MIN);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentDendritStartScale, args, n);
		n = 0;
		XtSetArg(args[n], XmNmaximum, (int) (LTSTOP * T_SCALE * pow((double) 10, (double) decimals))); n++;
		XtSetValues(editCurrentDendritStartScale, args, n);

		currentSelection.DSTART = SDSTRT * T_SCALE;
		sprintf(textnumber,"%f", currentSelection.DSTART);
		XmTextSetString(editCurrentDendritStartText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentDendritStartScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (currentSelection.DSTART * sF);
		XmScaleSetValue(editCurrentDendritStartScale, scaleValue);

		if (SDSTP > LTSTOP)
			SDSTP = LTSTOP;

		XmScaleSetValue(editCurrentDendritEndScale, DEND_MIN);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentDendritEndScale, args, n);
		n = 0;
		XtSetArg(args[n], XmNmaximum, (int) (LTSTOP * T_SCALE * pow((double) 10, (double) decimals))); n++;
		XtSetValues(editCurrentDendritEndScale, args, n);

		currentSelection.DEND = SDSTP * T_SCALE;
		sprintf(textnumber,"%f", currentSelection.DEND);
		XmTextSetString(editCurrentDendritEndText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentDendritEndScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (currentSelection.DEND * sF);
		XmScaleSetValue(editCurrentDendritEndScale, scaleValue);

		currentSelection.DCUR = DendCur * S_SCALE;
		sprintf(textnumber,"%f", currentSelection.DCUR);
		XmTextSetString(editCurrentDendritCurrentText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentDendritCurrentScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (currentSelection.DCUR * sF);
		XmScaleSetValue(editCurrentDendritCurrentScale, scaleValue);

		if (SCSTRT > LTSTOP)
			SCSTRT = LTSTOP;

		XmScaleSetValue(editCurrentSomaStartScale, SSTART_MIN);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentSomaStartScale, args, n);
		n = 0;
		XtSetArg(args[n], XmNmaximum, (int) (LTSTOP * T_SCALE * pow((double) 10, (double) decimals))); n++;
		XtSetValues(editCurrentSomaStartScale, args, n);

		currentSelection.SSTART = SCSTRT * T_SCALE;
		sprintf(textnumber,"%f", currentSelection.SSTART);
		XmTextSetString(editCurrentSomaStartText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentSomaStartScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (currentSelection.SSTART * sF);
		XmScaleSetValue(editCurrentSomaStartScale, scaleValue);

		if (SCSTP > LTSTOP)
			SCSTP = LTSTOP;

		XmScaleSetValue(editCurrentSomaEndScale, SEND_MIN);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentSomaEndScale, args, n);
		n = 0;
		XtSetArg(args[n], XmNmaximum, (int) (LTSTOP * T_SCALE * pow((double) 10, (double) decimals))); n++;
		XtSetValues(editCurrentSomaEndScale, args, n);

		currentSelection.SEND = SCSTP * T_SCALE;
		sprintf(textnumber,"%f", currentSelection.SEND);
		XmTextSetString(editCurrentSomaEndText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentSomaEndScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (currentSelection.SEND * sF);
		XmScaleSetValue(editCurrentSomaEndScale, scaleValue);

		currentSelection.SCUR = SomaCur * S_SCALE;
		sprintf(textnumber,"%f", currentSelection.SCUR);
		XmTextSetString(editCurrentSomaCurrentText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentSomaCurrentScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (currentSelection.SCUR * sF);
		XmScaleSetValue(editCurrentSomaCurrentScale, scaleValue);

		if (ActualIRegion > curNumOfDendSegs)
			ActualIRegion = curNumOfDendSegs;

		XmScaleSetValue(editCurrentLocationScale, TARGET_MIN);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentLocationScale, args, n);
		n = 0;
		if (curNumOfDendSegs == TARGET_MIN)
		{
			XtSetArg(args[n], XmNmaximum, (int) ((TARGET_MIN + 1) * pow((double) 10, (double) decimals)));
			n++;
		}
		else
		{
			XtSetArg(args[n], XmNmaximum, (int) (curNumOfDendSegs * pow((double) 10, (double) decimals)));
			n++;
		}
		XtSetValues(editCurrentLocationScale, args, n);

		currentSelection.REG = ActualIRegion;
		sprintf(textnumber,"%d", currentSelection.REG);
		XmTextSetString(editCurrentLocationText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentLocationScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (currentSelection.REG * sF);
		XmScaleSetValue(editCurrentLocationScale, scaleValue);

		currentSelection.NOISE = Noise;

		XtManageChild(editCurrentBB);

		break;

	case DIALOG_SWIM_CHANNELS:	/* check values for validity and accept numbers in edit SWIM channels mask */

		value = XmTextGetString(swimParamsNaEqText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < NAEQ_MIN) || (number > NAEQ_MAX))
		{
			error(5);
			free(value);
			break;
		}
		else NAEQ = number / E_SCALE;
		free(value);

		value = XmTextGetString(swimParamsNaConText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < NACON_MIN) || (number > NACON_MAX))
		{
			error(6);
			free(value);
			break;
		}
		else NACON = number / S_SCALE;
		free(value);

		value = XmTextGetString(swimParamsKEqText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < KEQ_MIN) || (number > KEQ_MAX))
		{
			error(7);
			free(value);
			break;
		}
		else KEQ = number / E_SCALE;
		free(value);

		value = XmTextGetString(swimParamsKConText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < KCON_MIN) || (number > KCON_MAX))
		{
			error(8);
			free(value);
			break;
		}
		else KCON = number / S_SCALE;
		free(value);

		value = XmTextGetString(swimParamsCaEqText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < CAEQ_MIN) || (number > CAEQ_MAX))
		{
			error(9);
			free(value);
			break;
		}
		else CAEQ = number / E_SCALE;
		free(value);

		value = XmTextGetString(swimParamsCaConText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < CACON_MIN) || (number > CACON_MAX))
		{
			error(10);
			free(value);
			break;
		}
		else CACON = number / S_SCALE;
		free(value);

		value = XmTextGetString(swimParamsSpikeThresholdText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < STH_MIN) || (number > STH_MAX))
		{
			error(43);
			free(value);
			break;
		}
		else STH = number / E_SCALE;
		free(value);

		for (actptr = selectionListNeuronsHead; actptr != NULL; actptr = actptr->next)
		{
			currentNeuron = actptr->neuronPtr;
			if (channelsSelection.NAEQ != NAEQ * E_SCALE)
				SWIM_NA_E = NAEQ;
			if (channelsSelection.NACON != NACON * S_SCALE)
				SWIM_NA_G = NACON;
			if (channelsSelection.KEQ != KEQ * E_SCALE)
				SWIM_K_E  = KEQ;
			if (channelsSelection.KCON != KCON * S_SCALE)
				SWIM_K_G  = KCON;
			if (channelsSelection.CAEQ != CAEQ * E_SCALE)
				SWIM_CA_E = CAEQ;
			if (channelsSelection.CACON != CACON * S_SCALE)
				SWIM_CA_G = CACON;
			if (channelsSelection.STH != STH * E_SCALE)
				SWIM_SPIKE_THRESHOLD = STH;
		}

		fileSaved = FALSE;
		XtUnmanageChild(swimParamsBB);

		/* remove all actually selected objects from the selection list */

		remove_selected_objects_from_selectionList();

		break;

	case DIALOG_HH_CHANNELS:	/* check values for validity and accept numbers in edit HH channels mask */

		value = XmTextGetString(hhParamsNaEqText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < NAEQ_MIN) || (number > NAEQ_MAX))
		{
			error(5);
			free(value);
			break;
		}
		else NAEQ = number / E_SCALE;
		free(value);

		value = XmTextGetString(hhParamsNaConText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < NACON_MIN) || (number > NACON_MAX))
		{
			error(6);
			free(value);
			break;
		}
		else NACON = number / S_SCALE;
		free(value);

		value = XmTextGetString(hhParamsKEqText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < KEQ_MIN) || (number > KEQ_MAX))
		{
			error(7);
			free(value);
			break;
		}
		else KEQ = number / E_SCALE;
		free(value);

		value = XmTextGetString(hhParamsKConText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < KCON_MIN) || (number > KCON_MAX))
		{
			error(8);
			free(value);
			break;
		}
		else KCON = number / S_SCALE;
		free(value);

		value = XmTextGetString(hhParamsSpikeThresholdText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < STH_MIN) || (number > STH_MAX))
		{
			error(43);
			free(value);
			break;
		}
		else 	STH = number / E_SCALE;
		free(value);

		for (actptr = selectionListNeuronsHead; actptr != NULL; actptr = actptr->next)
		{
			currentNeuron = actptr->neuronPtr;
			if (channelsSelection.NAEQ != NAEQ * E_SCALE)
				HH_NA_E = NAEQ;
			if (channelsSelection.NACON != NACON * S_SCALE)
				HH_NA_G = NACON;
			if (channelsSelection.KEQ != KEQ * E_SCALE)
				HH_K_E  = KEQ;
			if (channelsSelection.KCON != KCON * S_SCALE)
				HH_K_G  = KCON;
			if (channelsSelection.STH != STH * E_SCALE)
				HH_SPIKE_THRESHOLD  = STH;
		}

		fileSaved = FALSE;
		XtUnmanageChild(hhParamsBB);

		/* remove all actually selected objects from the selection list */

		remove_selected_objects_from_selectionList();

		break;

	case DIALOG_GB_CHANNELS:	/* check values for validity and accept numbers in edit GB channels mask */

		value = XmTextGetString(gbParamsNaEqText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < NAEQ_MIN) || (number > NAEQ_MAX))
		{
			error(5);
			free(value);
			break;
		}
		else NAEQ = number / E_SCALE;
		free(value);

		value = XmTextGetString(gbParamsNaConText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < NACON_MIN) || (number > NACON_MAX))
		{
			error(6);
			free(value);
			break;
		}
		else NACON = number / S_SCALE;
		free(value);

		value = XmTextGetString(gbParamsKEqText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < KEQ_MIN) || (number > KEQ_MAX))
		{
			error(7);
			free(value);
			break;
		}
		else KEQ = number / E_SCALE;
		free(value);

		value = XmTextGetString(gbParamsKConText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < KCON_MIN) || (number > KCON_MAX))
		{
			error(8);
			free(value);
			break;
		}
		else KCON = number / S_SCALE;
		free(value);

		value = XmTextGetString(gbParamsCa1ConText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < CACON_MIN) || (number > CACON_MAX))
		{
			error(9);
			free(value);
			break;
		}
		else CA1CON = number / S_SCALE;
		free(value);

		value = XmTextGetString(gbParamsCa2ConText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < CACON_MIN) || (number > CACON_MAX))
		{
			error(10);
			free(value);
			break;
		}
		else CA2CON = number / S_SCALE;
		free(value);

		value = XmTextGetString(gbParamsKCAEqText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < KCAEQ_MIN) || (number > KCAEQ_MAX))
		{
			error(7);
			free(value);
			break;
		}
		else KCAEQ = number / E_SCALE;
		free(value);

		value = XmTextGetString(gbParamsKCAConText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < KCACON_MIN) || (number > KCACON_MAX))
		{
			error(8);
			free(value);
			break;
		}
		else KCACON = number / S_SCALE;
		free(value);

		value = XmTextGetString(gbParamsAEqText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < AEQ_MIN) || (number > AEQ_MAX))
		{
			error(7);
			free(value);
			break;
		}
		else AEQ = number / E_SCALE;
		free(value);

		value = XmTextGetString(gbParamsAConText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < ACON_MIN) || (number > ACON_MAX))
		{
			error(8);
			free(value);
			break;
		}
		else ACON = number / S_SCALE;
		free(value);

		value = XmTextGetString(gbParamsIREqText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < IREQ_MIN) || (number > IREQ_MAX))
		{
			error(7);
			free(value);
			break;
		}
		else IREQ = number / E_SCALE;
		free(value);

		value = XmTextGetString(gbParamsIRConText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < IRCON_MIN) || (number > IRCON_MAX))
		{
			error(8);
			free(value);
			break;
		}
		else IRCON = number / S_SCALE;
		free(value);

		value = XmTextGetString(gbParamsPEqText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < PEQ_MIN) || (number > PEQ_MAX))
		{
			error(7);
			free(value);
			break;
		}
		else PEQ = number / E_SCALE;
		free(value);

		value = XmTextGetString(gbParamsPConText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < PCON_MIN) || (number > PCON_MAX))
		{
			error(8);
			free(value);
			break;
		}
		else PCON = number / S_SCALE;
		free(value);

		value = XmTextGetString(gbParamsSpikeThresholdText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < STH_MIN) || (number > STH_MAX))
		{
			error(43);
			free(value);
			break;
		}
		else 	STH = number / E_SCALE;
		free(value);

		for (actptr = selectionListNeuronsHead; actptr != NULL; actptr = actptr->next)
		{
			currentNeuron = actptr->neuronPtr;
			if (channelsSelection.NAEQ != NAEQ * E_SCALE)
				GB_NA_E = NAEQ;
			if (channelsSelection.NACON != NACON * S_SCALE)
				GB_NA_G = NACON;
			if (channelsSelection.KEQ != KEQ * E_SCALE)
				GB_K_E  = KEQ;
			if (channelsSelection.KCON != KCON * S_SCALE)
				GB_K_G  = KCON;
			if (channelsSelection.CA1CON != CA1CON * S_SCALE)
				GB_CA1_G = CA1CON;
			if (channelsSelection.CA2CON != CA2CON * S_SCALE)
				GB_CA2_G = CA2CON;
			if (channelsSelection.KCAEQ != KCAEQ * E_SCALE)
				GB_KCA_E  = KCAEQ;
			if (channelsSelection.KCACON != KCACON * S_SCALE)
				GB_KCA_G  = KCACON;
			if (channelsSelection.AEQ != AEQ * E_SCALE)
				GB_A_E  = AEQ;
			if (channelsSelection.ACON != ACON * S_SCALE)
				GB_A_G  = ACON;
			if (channelsSelection.IREQ != IREQ * E_SCALE)
				GB_IR_E  = IREQ;
			if (channelsSelection.IRCON != IRCON * S_SCALE)
				GB_IR_G  = IRCON;
			if (channelsSelection.PEQ != PEQ * E_SCALE)
				GB_P_E  = PEQ;
			if (channelsSelection.PCON != PCON * S_SCALE)
				GB_P_G  = PCON;
			if (channelsSelection.STH != STH * E_SCALE)
				GB_SPIKE_THRESHOLD  = STH;
		}

		fileSaved = FALSE;
		XtUnmanageChild(gbParamsBB);

		/* remove all actually selected objects from the selection list */

		remove_selected_objects_from_selectionList();

		break;

	case DIALOG_NEURON:	/* check values for validity and accept numbers in edit neurons mask */

		value = XmTextGetString(editNeuronConductanceText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < CON_MIN) || (number > CON_MAX))
		{
			error(11);
			free(value);
			break;
		}
		else CONDUCTANCE = number / S_SCALE;
		free(value);

		value = XmTextGetString(editNeuronLeakText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < LEAK_MIN) || (number > LEAK_MAX))
		{
			error(12);
			free(value);
			break;
		}
		else LEAK = number / E_SCALE;
		free(value);

		value = XmTextGetString(editNeuronCapacityText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < CAP_MIN) || (number > CAP_MAX))
		{
			error(13);
			free(value);
			break;
		}
		else CAP = number / C_SCALE;
		free(value);

		value = XmTextGetString(editNeuronToDendritConductanceText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < TOD_MIN) || (number > TOD_MAX))
		{
			error(14);
			free(value);
			break;
		}
		else TOD = number / S_SCALE;
		free(value);

		value = XmTextGetString(editNeuronPotentialText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < POT_MIN) || (number > POT_MAX))
		{
			error(15);
			free(value);
			break;
		}
		else POTENTIAL = number / E_SCALE;
		free(value);

		value = XmTextGetString(editNeuronDConductanceText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < DCON_MIN) || (number > DCON_MAX))
		{
			error(16);
			free(value);
			break;
		}
		else DCON = number / S_SCALE;
		free(value);

		value = XmTextGetString(editNeuronDPotentialText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < DPOT_MIN) || (number > DPOT_MAX))
		{
			error(17);
			free(value);
			break;
		}
		else DPOT = number / E_SCALE;
		free(value);

		value = XmTextGetString(editNeuronDLeakText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < DLEAK_MIN) || (number > DLEAK_MAX))
		{
			error(18);
			free(value);
			break;
		}
		else DLEAK = number / E_SCALE;
		free(value);

		value = XmTextGetString(editNeuronDCapacityText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < DCAP_MIN) || (number > DCAP_MAX))
		{
			error(19);
			free(value);
			break;
		}
		else DCAP = number / C_SCALE;
		free(value);

		value = XmTextGetString(editNeuronToSomaConductanceText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < TOS_MIN) || (number > TOS_MAX))
		{
			error(20);
			free(value);
			break;
		}
		else TOS = number / S_SCALE;
		free(value);

		for (actptr = selectionListNeuronsHead; actptr != NULL; actptr = actptr->next)
		{
			currentNeuron = actptr->neuronPtr;
			if (neuronSelection.CONDUCTANCE != CONDUCTANCE * S_SCALE)
				SOMA_REST_Gm		= CONDUCTANCE;
			if (neuronSelection.LEAK != LEAK * E_SCALE)
				SOMA_Eleak_INITIAL	= LEAK;
			if (neuronSelection.CAP != CAP * C_SCALE)
				SOMA_Cm			= CAP;
			if (neuronSelection.POTENTIAL != POTENTIAL * E_SCALE)
				SOMA_E_INITIAL		= POTENTIAL;
			if (neuronSelection.TOD != TOD * S_SCALE)
				SOMA_Gcore		= TOD;
			if (neuronSelection.DCON != DCON * S_SCALE)
				DENDRITE_REST_Gm	= DCON;
			if (neuronSelection.DLEAK != DLEAK * E_SCALE)
				DENDRITE_Eleak_INITIAL 	= DLEAK;
			if (neuronSelection.DCAP != DCAP * C_SCALE)
				DENDRITE_Cm		= DCAP;
			if (neuronSelection.DPOT != DPOT * E_SCALE)
				DENDRITE_E_INITIAL	= DPOT;
			if (neuronSelection.TOS != TOS * S_SCALE)
				DENDRITE_Gcore		= TOS;
		}

		fileSaved = FALSE;
		XtUnmanageChild(editNeuronBB);

		/* remove all actually selected objects from the selection list */

		remove_selected_objects_from_selectionList();

		break;

	case DIALOG_CURRENT:	/* check values for validity and accept numbers in edit currents mask */

		value = XmTextGetString(editCurrentSomaCurrentText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < SCUR_MIN) || (number > SCUR_MAX))
		{
			error(21);
			free(value);
			break;
		}
		else SCUR = number / S_SCALE;
		free(value);

		value = XmTextGetString(editCurrentSomaStartText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < SSTART_MIN) || (number > LTSTOP * T_SCALE))
		{
			error(22);
			free(value);
			break;
		}
		else SSTART = number / T_SCALE;
		free(value);

		value = XmTextGetString(editCurrentSomaEndText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < SEND_MIN) || (number > LTSTOP * T_SCALE))
		{
			error(23);
			free(value);
			break;
		}
		else SEND = number / T_SCALE;
		free(value);

		value = XmTextGetString(editCurrentDendritCurrentText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < DCUR_MIN) || (number > DCUR_MAX))
		{
			error(24);
			free(value);
			break;
		}
		else DCUR = number / S_SCALE;
		free(value);

		value = XmTextGetString(editCurrentDendritStartText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < DSTART_MIN) || (number > LTSTOP * T_SCALE))
		{
			error(25);
			free(value);
			break;
		}
		else DSTART = number / T_SCALE;
		free(value);

		value = XmTextGetString(editCurrentDendritEndText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < DEND_MIN) || (number > LTSTOP * T_SCALE))
		{
			error(26);
			free(value);
			break;
		}
		else DEND = number / T_SCALE;
		free(value);

		value = XmTextGetString(editCurrentLocationText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < TARGET_MIN) || (number > curNumOfDendSegs))
		{
			error(64);
			free(value);
			break;
		}
		else REG = atoi(value);
		free(value);

		NOISE = XmToggleButtonGadgetGetState(editCurrentNoiseToggle);

		for (actptr = selectionListNeuronsHead; actptr != NULL; actptr = actptr->next)
		{
			currentNeuron = actptr->neuronPtr;
			if (currentSelection.SSTART != SSTART * T_SCALE)
				SCSTRT		= SSTART;
			if (currentSelection.SEND != SEND * T_SCALE)
				SCSTP		= SEND;
			if (currentSelection.SCUR != SCUR * S_SCALE)
				SomaCur		= SCUR;
			if (currentSelection.DSTART != DSTART * T_SCALE)
				SDSTRT		= DSTART;
			if (currentSelection.DEND != DEND * T_SCALE)
				SDSTP		= DEND;
			if (currentSelection.DCUR != DCUR * S_SCALE)
				DendCur		= DCUR;
			if (currentSelection.REG != REG)
				ActualIRegion	= REG;
			if (currentSelection.NOISE != NOISE)
				Noise		= NOISE;
		}
		fileSaved = FALSE;
		XtUnmanageChild(editCurrentBB);

		/* remove all actually selected objects from the selection list */

		remove_selected_objects_from_selectionList();

		break;

	case DIALOG_AXO_SYNAPSE:	/* show the values of the selected axo-axonic synapse */

		/* set synaptic types */

		set_synaptic_types();

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(axoSynapseTTScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (selectionListSynapsesHead->synapsePtr->deliveryTime * T_SCALE * sF);
		XmScaleSetValue(axoSynapseTTScale, scaleValue);

		sprintf(textnumber,"%f", selectionListSynapsesHead->synapsePtr->deliveryTime * T_SCALE);
		XmTextSetString(axoSynapseTTText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(axoSynapseStrScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (selectionListSynapsesHead->synapsePtr->initialInhibitionFactor * sF);
		XmScaleSetValue(axoSynapseStrScale, scaleValue);

		sprintf(textnumber,"%f", selectionListSynapsesHead->synapsePtr->initialInhibitionFactor);
		XmTextSetString(axoSynapseStrText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(axoSynapseMaxStrScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (selectionListSynapsesHead->synapsePtr->maxInhibitionFactor * sF);
		XmScaleSetValue(axoSynapseMaxStrScale, scaleValue);

		sprintf(textnumber,"%f", selectionListSynapsesHead->synapsePtr->maxInhibitionFactor);
		XmTextSetString(axoSynapseMaxStrText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(axoSynapseTRTScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (selectionListSynapsesHead->synapsePtr->transmitterReleaseThreshold * E_SCALE * sF);
		XmScaleSetValue(axoSynapseTRTScale, scaleValue);

		sprintf(textnumber,"%f", selectionListSynapsesHead->synapsePtr->transmitterReleaseThreshold * E_SCALE);
		XmTextSetString(axoSynapseTRTText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(axoSynapseTRSScale, args, n);
		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (selectionListSynapsesHead->synapsePtr->transmitterSatiate * E_SCALE * sF);
		XmScaleSetValue(axoSynapseTRSScale, scaleValue);

		sprintf(textnumber,"%f", selectionListSynapsesHead->synapsePtr->transmitterSatiate * E_SCALE);
		XmTextSetString(axoSynapseTRSText, textnumber);

		XtManageChild(axoSynapseBB);
		break;

	case DIALOG_CONNECT_OBJECTS:	/* show mask for connecting objects */

		/* set synaptic types */

		set_synaptic_types();

		/* check if connection is axo-axonic */

		if (selectionListNeuronsCounter == 1 && selectionListSynapsesCounter == 1)
			XtManageChild(axoSynapseBB);
		else	XtManageChild(addSynapseBB);

		break;

	case DIALOG_SYNAPSE:	/* if synapses are selected directly, show the values of the first selected synapse,
				   else search the synapse via the selected neurons and show the mask for editing
				   the synapse */

		/* set synaptic types */

		set_synaptic_types();

		/* check if synapses are selected directly */

		if (selectionListSynapsesHead != NULL)	/* synapses directly selected ? */
		{
			/*** get first selected synapse and show their values ***/

			connection = selectionListSynapsesHead->synapsePtr;

			/* get synaptic types from widget list */

			n = 0;
			XtSetArg(args[n], XmNitems, &items); n++;
			XtSetArg(args[n], XmNitemCount, &itemCount); n++;
			XtGetValues(addSynapseList, args, n);

			/* check connections and highlight (select) the first choosen synaptic type */

			for (num = 0; num < itemCount; num++)
			{
				XmStringGetLtoR(items[num], defaultFont, &item);
				if (connection->synapticType == atoi(item))
				{
					XmListSelectPos(addSynapseList, num + 1, FALSE);
					break;	/* leave for loop */
				}
			}

			/* set synapse conductance */

			sprintf(val, "%f", connection->initialConductance * S_SCALE);
			XmTextSetString(addSynapseStrText, val);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(addSynapseStrScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (connection->initialConductance * S_SCALE) * sF;

			if (scaleValue > (STR_MAX * sF))
				scaleValue = (STR_MAX * sF);
			else if (scaleValue < (STR_MIN * sF))
				scaleValue = (STR_MIN * sF);
			XmScaleSetValue(addSynapseStrScale, scaleValue);

			/* set maximal synapse conductance */

			sprintf(val, "%f", connection->maxConductance * S_SCALE);
			XmTextSetString(addSynapseMaxStrText, val);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(addSynapseMaxStrScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (connection->maxConductance * S_SCALE) * sF;

			if (scaleValue > (MAXSTR_MAX * sF))
				scaleValue = (MAXSTR_MAX * sF);
			else if (scaleValue < (MAXSTR_MIN * sF))
				scaleValue = (MAXSTR_MIN * sF);
			XmScaleSetValue(addSynapseMaxStrScale, scaleValue);

			/* set synapse transmission time */

			sprintf(val, "%f", connection->deliveryTime * T_SCALE);
			XmTextSetString(addSynapseTTText, val);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(addSynapseTTScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (connection->deliveryTime * T_SCALE) * sF;

			if (scaleValue > (TT_MAX * sF))
				scaleValue = (TT_MAX * sF);
			else if (scaleValue < (TT_MIN * sF))
				scaleValue = (TT_MIN * sF);
			XmScaleSetValue(addSynapseTTScale, scaleValue);

			/* set synapse transmitter release threshold */

			sprintf(val, "%f", connection->transmitterReleaseThreshold * E_SCALE);
			XmTextSetString(addSynapseTRTText, val);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(addSynapseTRTScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (connection->transmitterReleaseThreshold * E_SCALE) * sF;

			if (scaleValue > (TRT_MAX * sF))
				scaleValue = (TRT_MAX * sF);
			else if (scaleValue < (TRT_MIN * sF))
				scaleValue = (TRT_MIN * sF);
			XmScaleSetValue(addSynapseTRTScale, scaleValue);

			/* set synapse transmitter satiate */

			sprintf(val, "%f", connection->transmitterSatiate * E_SCALE);
			XmTextSetString(addSynapseTRSText, val);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(addSynapseTRSScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = (int) (connection->transmitterSatiate * E_SCALE) * sF;

			if (scaleValue > (TRS_MAX * sF))
				scaleValue = (TRS_MAX * sF);
			else if (scaleValue < (TRS_MIN * sF))
				scaleValue = (TRS_MIN * sF);
			XmScaleSetValue(addSynapseTRSScale, scaleValue);

			/* set synaptic location */

			sprintf(val, "%d", connection->targetArea);
			XmTextSetString(addSynapseTargetText, val);
			XmTextSetString(editSynapseLocationText, val);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(addSynapseTargetScale, args, n);

			sF = (int) pow((double) 10, (double) decimals);
			scaleValue = connection->targetArea * sF;

			if (scaleValue > (curNumOfDendSegs * sF))
				scaleValue = (curNumOfDendSegs * sF);
			else if (scaleValue < (TARGET_MIN * sF))
				scaleValue = (TARGET_MIN * sF);
			XmScaleSetValue(addSynapseTargetScale, scaleValue);
			XmScaleSetValue(editSynapseLocationScale, scaleValue);

			/* save synpatic values for further operations (i.E. copying values to other synapses) */

			itemSelected.STRENGTH = connection->initialConductance;
			itemSelected.TT = connection->deliveryTime;
			itemSelected.LOC = connection->targetArea;
			itemSelected.type = connection->synapticType;
			LOC = connection->targetArea;
			STRENGTH = connection->initialConductance;
			TT = connection->deliveryTime;
			typeNum = connection->synapticType;

			/* show mask for edit synapse */

			XtManageChild(addSynapseBB);

			break;	/* leave case statement */
		}

		/*** at this point no synapses are chosen directly ***/

		/*** look if a connection between the selected neurons exists ***/

		/* if the two selected neurons are not connected show an error message */

		if (! is_connected(selectionListNeuronsHead->neuronPtr, selectionListNeuronsTail->neuronPtr))
		{
			error(27);
			break;	/* leave case statement */
		}

		/* show all synaptic connections in edit synapse mask */

		show_synaptic_connections();

		/* now show the dialog box for selecting a synapse for edit purposes */

		editFlag = TRUE;
		XtManageChild(editSynapseBB);

		break;

	case DIALOG_ADD_SYNAPSE:	/* the ok button in the add synapse mask was pressed and now the values must be
					   checked and if valid used for the selected synapses */

		/* check transmission time of synapse */

		value = XmTextGetString(addSynapseTTText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < TT_MIN) || (number > TT_MAX))
		{
			error(28);
			free(value);

			break;	/* leave case statement */
		}
		else TT = number / T_SCALE;
		free(value);

		/* check synaptic conductance */

		value = XmTextGetString(addSynapseStrText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < STR_MIN) || (number > STR_MAX))
		{
			error(29);
			free(value);

			break;	/* leave case statement */
		}
		else STRENGTH = number / S_SCALE;
		free(value);

		/* check maximal synaptic conductance */

		value = XmTextGetString(addSynapseMaxStrText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < MAXSTR_MIN) || (number > MAXSTR_MAX))
		{
			error(72);
			free(value);

			break;	/* leave case statement */
		}
		else MAXSTR = number / S_SCALE;
		free(value);

		/* check if the transmitter release threshold is valid */

		value = XmTextGetString(addSynapseTRTText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < TRT_MIN) || (number > TRT_MAX))
		{
			error(35);
			free(value);

			break;
		}
		else 	TRT = number / E_SCALE;
		free(value);

		/* check if the transmitter satiate threshold is valid */

		value = XmTextGetString(addSynapseTRSText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < TRS_MIN) || (number > TRS_MAX))
		{
			error(36);
			free(value);

			break;
		}

		TRS = number / E_SCALE;
		if (TRS <= TRT)
		{
			error(37);
			free(value);

			break;
		}

		/* check if the target region is valid */

		value = XmTextGetString(addSynapseTargetText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < TARGET_MIN) || (number > curNumOfDendSegs))
		{
			error(63);
			free(value);

			break;
		}

		LOC = atoi(value);

		/* check if a synaptic type was selected in the add synapse mask */

		n = 0;
		XtSetArg(args[n], XmNselectedItemCount, &itemCount); n++;
		XtGetValues(addSynapseList, args, n);

		if (itemCount > 0)	/* synaptic type selected ? */
		{
			/* add synpase mask can now disappear */

			XtUnmanageChild(addSynapseBB);

			/* if editFlag == TRUE, then DIALOG_ADD_SYNAPSE is called after a connection has
			   been chosen for edit purpose and the correct connection must first searched */

			if (editFlag == TRUE)	/* a single synapse to be edit exists */
			{
				/* clear synpatic connection list in the edit synapse list widget */

				n = 0;
				XtSetArg(args[n], XmNitemCount, 0); n++;
				XtSetArg(args[n], XmNitems, NULL); n++;
				XtSetValues(editSynapseList, args, n);

				/* change synaptic values */

				currentSynapse = selectionListSynapsesHead->synapsePtr;

				change_synaptic_values(currentSynapse, typeNum, STRENGTH, TT, TRT, TRS, LOC);
				currentSynapse->maxConductance = MAXSTR;

				/* reset the edit flag and clear the edit synapse mask */

				editFlag = FALSE;
				XtUnmanageChild(editSynapseBB);
			}
			else	/* either a list of selected synapses to be edit exists or
				   no synpase was selected and the connection doesn't exist
				   and must therefor created */
			{
				/* if synapses are directly selected then change all of them */

				for (actualSynapse = selectionListSynapsesHead; actualSynapse != NULL;
					actualSynapse = actualSynapse->next)
				{
					double	conductance;	/* synaptic conduction */
					double	deliveryTime;	/* synaptic transmission time */
					int	typ;		/* synaptic type */
					int	location;	/* synaptic location */

					currentSynapse = actualSynapse->synapsePtr;

					/* look which entries in the add synapse mask has been changed for the
					   first synapse and change only this entries for all selected
					   synapses */

					if (itemSelected.type != typeNum)
						typ = typeNum;
					else
						typ = currentSynapse->synapticType;

					if (itemSelected.STRENGTH != STRENGTH)
						conductance = STRENGTH;
					else
						conductance = currentSynapse->initialConductance;

					if (itemSelected.TT != TT)
						deliveryTime = TT;
					else
						deliveryTime = currentSynapse->deliveryTime;

					if (itemSelected.LOC != LOC)
						location = LOC;
					else
						location = currentSynapse->targetArea;

					/* change synaptic values */

					change_synaptic_values(currentSynapse, typ, conductance, deliveryTime,
						TRT, TRS, location);
					currentSynapse->maxConductance = MAXSTR;
				}

				/* if no synapse is selected directly then create new connection */

				if (selectionListSynapsesHead == NULL)
				{
					connect_neurons(selectionListNeuronsHead->neuronPtr,
						selectionListNeuronsTail->neuronPtr,
						typeNum, STRENGTH, TT, TRT, TRS, LOC, NULL);
					selectionListNeuronsHead->neuronPtr->connectionList->maxConductance = MAXSTR;
				}
			}
		}
		else	/* no synapse selected -> print out an error message */
			error(30);

		/* reset the file save status cause the net has been changed */

		fileSaved = FALSE;
		free(value);

		/* remove all actually selected objects from the selection list */

		remove_selected_objects_from_selectionList();

		break;

	case DIALOG_DELETE_OBJECTS:	/* ask user if he really wants to delete the selected objects */

		/* create question dialog */

		n = 0;
		XtSetArg(args[n], XmNallowShellResize, TRUE); n++;
		questionDialog = XmCreateDialogShell(w, "questionDialog", args, n);

		xmstrings[0] = XmStringCreateLtoR(deleteObjectsString, defaultFont);
		xmstrings[1] = XmStringCreateLtoR(areYouShureString, defaultFont);
		xmstrings[2] = XmStringCreateLtoR(yesString, defaultFont);
		xmstrings[3] = XmStringCreateLtoR(noString, defaultFont);
		xmstrings[4] = XmStringCreateLtoR(helpString, defaultFont);

		n = 0;
		XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
		XtSetArg(args[n], XmNdialogType, XmDIALOG_QUESTION); n++;
		XtSetArg(args[n], XmNdialogTitle, xmstrings[0]); n++;
		XtSetArg(args[n], XmNmessageString, xmstrings[1]); n++;
		XtSetArg(args[n], XmNokLabelString, xmstrings[2]); n++;
		XtSetArg(args[n], XmNcancelLabelString, xmstrings[3]); n++;
		XtSetArg(args[n], XmNhelpLabelString, xmstrings[4]); n++;
		questionMessageBox = XmCreateMessageBox(questionDialog, "questionBox", args, n);
		XtAddCallback(questionMessageBox, XmNokCallback, remove_selected_objects_CB, (caddr_t *) NULL);
		XtAddCallback(questionMessageBox, XmNcancelCallback, unmanage_link_CB, (caddr_t *) &questionMessageBox);
		XtAddCallback(questionMessageBox, XmNcancelCallback, remove_selected_objects_from_selectionList_CB, (caddr_t *) NULL);

		XmStringFree(xmstrings[0]);
		XmStringFree(xmstrings[1]);
		XmStringFree(xmstrings[2]);
		XmStringFree(xmstrings[3]);
		XmStringFree(xmstrings[4]);

		n = 0;
		XtSetArg(args[n], XmNforeground, &fg); n++;
		XtSetArg(args[n], XmNbackground, &bg); n++;
		XtGetValues(questionMessageBox, args, n);

		n = 0;
		XtSetArg(args[n], XmNsymbolPixmap, XmGetPixmap(XtScreen(questionDialog), "default_xm_question", fg, bg)); n++;
		XtSetValues(questionMessageBox, args, n);

		/* help button is not needed, remove him */

		button = XmMessageBoxGetChild(questionMessageBox, XmDIALOG_HELP_BUTTON);
		XtUnmanageChild(button);

		/* show question window: are you shure ? */

		XtManageChild(questionMessageBox);

		break;

	case DIALOG_DELETE_SYNAPSE:	/* the selected synapse should be deleted */

		/* look if a synapse was selected in the edit synapse mask */

		n = 0;
		XtSetArg(args[n], XmNselectedItemCount, &itemCount); n++;
		XtGetValues(editSynapseList, args, n);

		if (itemCount == 0)
		{
			error(31);
			break;	/* exit, cause nothing is selected */
		}

		/* search connection */

		for (connection = selectionListNeuronsHead->neuronPtr->connectionList;
		    connection != NULL;
		    connection = connection->nextConnection)
		{
			char conStr[24], strStr[24], delStr[24], ttStr[24];

			/* convert floats to strings, because of rounding problems */

			sprintf(conStr, "%f", connection->initialConductance);
			sprintf(strStr, "%f", itemSelected.STRENGTH);
			sprintf(delStr, "%f", connection->deliveryTime);
			sprintf(ttStr, "%f", itemSelected.TT);

			if ((connection->targetNeuron == selectionListNeuronsTail->neuronPtr) &&
			    (strcmp(conStr, strStr) == NULL) &&
			    (strcmp(delStr, ttStr) == NULL) &&
			    (connection->targetArea == itemSelected.LOC) &&
			    (connection->synapticType == itemSelected.type))
			{
				/* delete connection in edit synpase mask and physical */

				XmListDeletePos(editSynapseList, itemSelected.position);
				delete_connection(selectionListNeuronsHead->neuronPtr, connection);

				break;
			}
		}

		/* reset the file save status cause the net has been changed */

		fileSaved = FALSE;
		editFlag = FALSE;

		XtUnmanageChild(editSynapseBB);

		/* remove all actually selected objects from the selection list */

		remove_selected_objects_from_selectionList();

		break;

	case DIALOG_EDIT_SYNAPSE:	/* the edit button in the edit synapse mask was pressed, so edit the
					   selected synapse for edit purposes */

		/* set synaptic types */

		set_synaptic_types();

		/* check if a synapse was selected in the list of synapses */

		n = 0;
		XtSetArg(args[n], XmNselectedItemCount, &itemCount); n++;
		XtGetValues(editSynapseList, args, n);

		if (itemCount == 0)	/* no connection selected -> print out an error message */
		{
			error(31);
			break;	/* exit, cause nothing is selected */
		}

		/* search for selected connection to be edited and fill in the default values */

		for (connection = selectionListNeuronsHead->neuronPtr->connectionList;
		    connection != NULL;
		    connection = connection->nextConnection)
		{
			char conStr[24], strStr[24], delStr[24], ttStr[24];

			/* convert floats to strings, because of rounding problems */

			sprintf(conStr, "%f", connection->initialConductance);
			sprintf(strStr, "%f", itemSelected.STRENGTH);
			sprintf(delStr, "%f", connection->deliveryTime);
			sprintf(ttStr, "%f", itemSelected.TT);

			if ((connection->targetNeuron == selectionListNeuronsTail->neuronPtr) &&
			    (strcmp(conStr, strStr) == NULL) &&
			    (strcmp(delStr, ttStr) == NULL) &&
			    (connection->targetArea == itemSelected.LOC) &&
			    (connection->synapticType == itemSelected.type))
			{
				/* get all posible connections from the list */

				n = 0;
				XtSetArg(args[n], XmNitems, &items); n++;
				XtSetArg(args[n], XmNitemCount, &itemCount); n++;
				XtGetValues(addSynapseList, args, n);

				/* search the selected synpase */

				for (num = 0; num < itemCount; num++)
				{
					XmStringGetLtoR(items[num], defaultFont, &item);
					if (itemSelected.type == atoi(item))
					{
						XmListSelectPos(addSynapseList, num + 1, FALSE);

						break;
					}
				}

				/* set the synaptic conductance */

				sprintf(val, "%f", connection->initialConductance * S_SCALE);
				XmTextSetString(addSynapseStrText, val);

				n = 0;
				XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
				XtGetValues(addSynapseStrScale, args, n);

				sF = (int) pow((double) 10, (double) decimals);
				scaleValue = (int) (connection->initialConductance * S_SCALE) * sF;

				if (scaleValue > (STR_MAX * sF))
					scaleValue = (STR_MAX * sF);
				else if (scaleValue < (STR_MIN * sF))
					scaleValue = (STR_MIN * sF);
				XmScaleSetValue(addSynapseStrScale, scaleValue);

				/* set maximal synapse conductance */

				sprintf(val, "%f", connection->maxConductance * S_SCALE);
				XmTextSetString(addSynapseMaxStrText, val);

				n = 0;
				XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
				XtGetValues(addSynapseMaxStrScale, args, n);

				sF = (int) pow((double) 10, (double) decimals);
				scaleValue = (int) (connection->maxConductance * S_SCALE) * sF;

				if (scaleValue > (MAXSTR_MAX * sF))
					scaleValue = (MAXSTR_MAX * sF);
				else if (scaleValue < (MAXSTR_MIN * sF))
					scaleValue = (MAXSTR_MIN * sF);
				XmScaleSetValue(addSynapseMaxStrScale, scaleValue);

				/* set the synaptic transmission time */

				sprintf(val, "%f", connection->deliveryTime * T_SCALE);
				XmTextSetString(addSynapseTTText, val);

				n = 0;
				XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
				XtGetValues(addSynapseTTScale, args, n);

				sF = (int) pow((double) 10, (double) decimals);
				scaleValue = (int) (connection->deliveryTime * T_SCALE) * sF;

				if (scaleValue > (TT_MAX * sF))
					scaleValue = (TT_MAX * sF);
				else if (scaleValue < (TT_MIN * sF))
					scaleValue = (TT_MIN * sF);
				XmScaleSetValue(addSynapseTTScale, scaleValue);

				/* set synapse transmitter release threshold */

				sprintf(val, "%f", connection->transmitterReleaseThreshold * E_SCALE);
				XmTextSetString(addSynapseTRTText, val);

				n = 0;
				XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
				XtGetValues(addSynapseTRTScale, args, n);

				sF = (int) pow((double) 10, (double) decimals);
				scaleValue = (int) (connection->transmitterReleaseThreshold * E_SCALE) * sF;

				if (scaleValue > (TRT_MAX * sF))
					scaleValue = (TRT_MAX * sF);
				else if (scaleValue < (TRT_MIN * sF))
					scaleValue = (TRT_MIN * sF);
				XmScaleSetValue(addSynapseTRTScale, scaleValue);

				/* set synapse transmitter satiate */

				sprintf(val, "%f", connection->transmitterSatiate * E_SCALE);
				XmTextSetString(addSynapseTRSText, val);

				n = 0;
				XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
				XtGetValues(addSynapseTRSScale, args, n);

				sF = (int) pow((double) 10, (double) decimals);
				scaleValue = (int) (connection->transmitterSatiate * E_SCALE) * sF;

				if (scaleValue > (TRS_MAX * sF))
					scaleValue = (TRS_MAX * sF);
				else if (scaleValue < (TRS_MIN * sF))
					scaleValue = (TRS_MIN * sF);
				XmScaleSetValue(addSynapseTRSScale, scaleValue);

				/* set synaptic location */

				sprintf(val, "%d", connection->targetArea);
				XmTextSetString(addSynapseTargetText, val);
				XmTextSetString(editSynapseLocationText, val);

				n = 0;
				XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
				XtGetValues(addSynapseTargetScale, args, n);

				sF = (int) pow((double) 10, (double) decimals);
				scaleValue = connection->targetArea * sF;

				if (scaleValue > (curNumOfDendSegs * sF))
					scaleValue = (curNumOfDendSegs * sF);
				else if (scaleValue < (TARGET_MIN * sF))
					scaleValue = (TARGET_MIN * sF);
				XmScaleSetValue(addSynapseTargetScale, scaleValue);
				XmScaleSetValue(editSynapseLocationScale, scaleValue);

				/* remove selected neurons from selection list and add found synapse to selection list */

				remove_selected_objects_from_selectionList();
				add_synapse_to_selection_list(connection);

				break;
			}
		}

		/* reset the file save status cause the net has been changed */

		fileSaved = FALSE;

		/* deselect all synapses in the edit synapse list and show the add synapse mask */

		XmListDeselectAllItems(editSynapseList);

		XtManageChild(addSynapseBB);

		break;

	case DIALOG_INFO_SYNAPSE:	/* the info button in the edit synapse mask was pressed, so show the
					   information window for the selected synapse */

		/* set synaptic types */

		set_synaptic_types();

		/* check if a synapse was selected in the list of synapses */

		n = 0;
		XtSetArg(args[n], XmNselectedItemCount, &itemCount); n++;
		XtGetValues(editSynapseList, args, n);

		if (itemCount == 0)	/* no connection selected -> print out an error message */
		{
			error(31);
			break;	/* exit, cause nothing is selected */
		}

		/* search for selected connection to be shown */

		for (connection = selectionListNeuronsHead->neuronPtr->connectionList;
		    connection != NULL;
		    connection = connection->nextConnection)
		{
			char conStr[24], strStr[24], delStr[24], ttStr[24];

			/* convert floats to strings, because of rounding problems */

			sprintf(conStr, "%f", connection->initialConductance);
			sprintf(strStr, "%f", itemSelected.STRENGTH);
			sprintf(delStr, "%f", connection->deliveryTime);
			sprintf(ttStr, "%f", itemSelected.TT);

			if ((connection->targetNeuron == selectionListNeuronsTail->neuronPtr) &&
			    (strcmp(conStr, strStr) == NULL) &&
			    (strcmp(delStr, ttStr) == NULL) &&
			    (connection->targetArea == itemSelected.LOC) &&
			    (connection->synapticType == itemSelected.type))
			{
				/* show information about synapse */

				currentSynapse = connection;

				strcpy(info, infoSString);
				strcat(info, "\n\n");

				if (currentSynapse->axoSynapseNumber > 0)	/* axo-axonic connection */
				{
					strcat(info, axoSynapseNumberString);
					strcat(info, "\t");
					sprintf(textnumber, "%d", currentSynapse->axoSynapseNumber);
					strcat(info, textnumber);
					strcat(info, "\n");
					strcat(info, targetSynapseNumberString);
					strcat(info, "\t\t");
					sprintf(textnumber, "%d", currentSynapse->synapseID);
					strcat(info, textnumber);
					strcat(info, "\n\n");
				}
				else	/* not axo-axonic */
				{
					strcat(info, synapseIDString);
					strcat(info, "\t");
					sprintf(textnumber, "%d", currentSynapse->synapseID);
					strcat(info, textnumber);
					strcat(info, "\n");
					strcat(info, synapseFromNeuronString);
					strcat(info, " ");
					sprintf(textnumber, "%d", currentSynapse->parentNeuron->neuronId);
					strcat(info, textnumber);
					strcat(info, " ");
					strcat(info, toNeuronString);
					strcat(info, " ");
					sprintf(textnumber, "%d", currentSynapse->targetNeuron->neuronId);
					strcat(info, textnumber);
					strcat(info, "\n");
					strcat(info, targetConnectionString);
					strcat(info, "\t");

					if (currentSynapse->targetArea == 0)	/* Soma */
					{
						strcat(info, somaString);
						strcat(info, "\n");
					
					}
					else	/* Dendrit */
					{
						strcat(info, dendritSegmentString);
						strcat(info, "\t");
						sprintf(textnumber, "%d", currentSynapse->targetArea);
						strcat(info, textnumber);
						strcat(info, "\n");
					}

					strcat(info, "\n");

					strcat(info, synapticTypeString);
					strcat(info, "\t\t\t\t");

					switch(synapseTypes[currentSynapse->synapticType].ionType)
					{
					case 1:	
						strcat(info, sodiumString);
						break;
					case 2:	
						strcat(info, potassiumString);
						break;
					case 3:	
						strcat(info, chemicalString);
						break;
					case 4:	
						strcat(info, electricalString);
						break;
					}

					strcat(info, "\n");
					strcat(info, synapticEQPotentialString);
					strcat(info, "\t");
					sprintf(textnumber, "%.2f", synapseTypes[currentSynapse->synapticType].equilPotential
						* E_SCALE);
					strcat(info, textnumber);
					strcat(info, "\n\n");
				}

				strcat(info, synapticTransmissionString);
				strcat(info, "\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->deliveryTime * T_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");

				strcat(info, synapsePotentialString);
				strcat(info, "\t\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->potential * E_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n\n");

				strcat(info, transmitterReleaseString);
				strcat(info, "\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->transmitterReleaseThreshold * E_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, transmitterSatiationString);
				strcat(info, "\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->transmitterSatiate * E_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n\n");

				if (currentSynapse->axoSynapseNumber > 0)	/* axo-axonic connection */
				{
					strcat(info, initialInhibitionString);
					strcat(info, "\t\t\t");
					sprintf(textnumber, "%.2f", currentSynapse->initialInhibitionFactor * P_SCALE);
					strcat(info, textnumber);
					strcat(info, "\n");
					strcat(info, currentInhibitionString);
					strcat(info, "\t\t\t");
					sprintf(textnumber, "%.2f", currentSynapse->currentInhibitionFactor * P_SCALE);
					strcat(info, textnumber);
					strcat(info, "\n");
					strcat(info, maxInhibitionString);
					strcat(info, "\t\t\t");
					sprintf(textnumber, "%.2f", currentSynapse->maxInhibitionFactor * P_SCALE);
					strcat(info, textnumber);
					strcat(info, "\n\n");
				}
				else	/* not axo-axonic */
				{
					strcat(info, initialConductanceString);
					strcat(info, "\t\t\t");
					sprintf(textnumber, "%.2f", currentSynapse->initialConductance * S_SCALE);
					strcat(info, textnumber);
					strcat(info, "\n");
					strcat(info, normalConductanceString);
					strcat(info, "\t\t\t");
					sprintf(textnumber, "%.2f", currentSynapse->conductance * S_SCALE);
					strcat(info, textnumber);
					strcat(info, "\n");
					strcat(info, currentConductanceString);
					strcat(info, "\t\t\t");
					sprintf(textnumber, "%.2f", currentSynapse->currentConductance * S_SCALE);
					strcat(info, textnumber);
					strcat(info, "\n");
					strcat(info, maxConductanceString);
					strcat(info, "\t\t\t");
					sprintf(textnumber, "%.2f", currentSynapse->maxConductance * S_SCALE);
					strcat(info, textnumber);
					strcat(info, "\n\n");
				}

				/* Learnparameter */

				strcat(info, learnParameterString);
				strcat(info, "\n\n");
				strcat(info, learnStimuliString);
				strcat(info, "\n\n");
				strcat(info, stmCntString);
				strcat(info, "\t\t\t\t");
				sprintf(textnumber, "%d", currentSynapse->stmCnt);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, condCntString);
				strcat(info, "\t\t\t\t");
				sprintf(textnumber, "%d", currentSynapse->condCnt);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, hebbCntString);
				strcat(info, "\t\t\t\t\t");
				sprintf(textnumber, "%d", currentSynapse->hebbCnt);
				strcat(info, textnumber);
				strcat(info, "\n\n");
				strcat(info, synapticMemorySTPString);
				strcat(info, "\t");
				sprintf(textnumber, "%.2f", currentSynapse->synapticMemorySTP * P_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, trainingFlagString);
				strcat(info, "\t\t\t\t");
				if (currentSynapse->trainingFlagSTP)
					strcat(info, longTermForgettingString);
				else	strcat(info, shortTermForgettingString);
				strcat(info, "\n");
				strcat(info, synapticMemoryHebbString);
				strcat(info, "\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->synapticMemoryHebb * P_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, trainingFlagString);
				strcat(info, "\t\t\t\t");
				if (currentSynapse->trainingFlagHebb)
					strcat(info, longTermForgettingString);
				else	strcat(info, shortTermForgettingString);
				strcat(info, "\n");
				strcat(info, synapticMemoryCondString);
				strcat(info, "\t");
				sprintf(textnumber, "%.2f", currentSynapse->synapticMemoryCond * P_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, trainingFlagString);
				strcat(info, "\t\t\t\t");
				if (currentSynapse->trainingFlagCond)
					strcat(info, longTermForgettingString);
				else	strcat(info, shortTermForgettingString);
				strcat(info, "\n\n");
				strcat(info, learnCurveSlopeString);
				strcat(info, "\t\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->slope);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, shortTermMemoryString);
				strcat(info, "\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->shortTermMemory);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, longTermThresholdString);
				strcat(info, "\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->longTermThreshold);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, longTermMinimumString);
				strcat(info, "\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->longTermMinimum * P_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, hebbIntervalString);
				strcat(info, "\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->hebbIntervall * T_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, hebbLearnFactorString);
				strcat(info, "\t\t\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->hebbLearnFactor);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, competitiveLearnFactorString);
				strcat(info, "\t\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->competitiveLearnFactor);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, shortTermLearnFactorString);
				strcat(info, "\t\t\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->shortTermPlasticityLearnFactor);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, conditioningLearnFactorString);
				strcat(info, "\t\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->conditioningLearnFactor);
				strcat(info, textnumber);

				/* show the information about synapse mask */

				XmTextSetString(infoObjectText, info);
				XtManageChild(infoObjectBB);

				break;
			}
		}

		/* deselect all synapses in the edit synapse list and unmanage the edit synapse mask */

		XmListDeselectAllItems(editSynapseList);

		XtUnmanageChild(editSynapseBB);

		break;

	case DIALOG_WINDOW_SYNAPSE:	/* the attach window button in the edit synapse mask was pressed,
					   so create the window for the selected synapse */

		/* set synaptic types */

		set_synaptic_types();

		/* check if a synapse was selected in the list of synapses */

		n = 0;
		XtSetArg(args[n], XmNselectedItemCount, &itemCount); n++;
		XtGetValues(editSynapseList, args, n);

		if (itemCount == 0)	/* no connection selected -> print out an error message */
		{
			error(31);
			break;	/* exit, cause nothing is selected */
		}

		/* search for selected connection to be shown */

		for (connection = selectionListNeuronsHead->neuronPtr->connectionList;
		    connection != NULL;
		    connection = connection->nextConnection)
		{
			char conStr[24], strStr[24], delStr[24], ttStr[24];

			/* convert floats to strings, because of rounding problems */

			sprintf(conStr, "%f", connection->initialConductance);
			sprintf(strStr, "%f", itemSelected.STRENGTH);
			sprintf(delStr, "%f", connection->deliveryTime);
			sprintf(ttStr, "%f", itemSelected.TT);

			if ((connection->targetNeuron == selectionListNeuronsTail->neuronPtr) &&
			    (strcmp(conStr, strStr) == NULL) &&
			    (strcmp(delStr, ttStr) == NULL) &&
			    (connection->targetArea == itemSelected.LOC) &&
			    (connection->synapticType == itemSelected.type))
			{
				/* create graph window for the selected synapse */

				remove_selected_objects_from_selectionList();
				add_synapse_to_selection_list(connection);
				create_newGraphS(mainWindow);

				/* remove all actually selected objects from the selection list */

				remove_selected_objects_from_selectionList();

				break;
			}
		}
		XtUnmanageChild(editSynapseBB);

		break;

	case DIALOG_NEW_STYPE:	/* a new synaptic type was created by the user */

		/* check equilibrium potential of the synaptic type */

		value = XmTextGetString(newSTypeEqPotText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < SEQ_MIN) || (number > SEQ_MAX))
		{
			error(32);
			free(value);
			break;
		}

		SEQ = number / E_SCALE;

		/* look if synaptic type already exists */

		for (num = 0; num < numTypes; num++)
		{
			if ((synapseTypes[num].ionType == STYPE) &&
			    (synapseTypes[num].equilPotential == SEQ))
			{
				newType = FALSE;

				break;	/* leave for loop */
			}
		}

		/* if the type not exists yet create it */

		if (newType == TRUE)
		{
			/* reallocated memory for the synapse types table */

			synapseTypes = (Synapse *) realloc(synapseTypes, (size_t) ((numTypes + 1) * sizeof(Synapse)));

			if (! synapseTypes)
			{
				error(126);
				return;
			}

			/* insert new synaptic type in the synapse type table */

			synapseTypes[numTypes].ionType = STYPE;
			synapseTypes[numTypes++].equilPotential = SEQ;

			/* create a new entry in the synapse type list from the add synapse list widget */

			switch (STYPE)
			{
			case 1:
				strcpy(type, sodiumString);
				break;

			case 2:
				strcpy(type, potassiumString);
				break;

			case 3:
				strcpy(type, chemicalString);
				break;
			}

			sprintf(listString, "%-18d%-22s%-+#f", numTypes - 1, type, (double) SEQ * E_SCALE);
			str = XmStringCreateLtoR(listString, defaultFont);
			XmListAddItemUnselected(addSynapseList, str, 0);
		}

		/* the mask for the new synaptic type can now disappear */

		XtUnmanageChild(newSTypeBB);
		XmStringFree(str);
		free(value);

		/* reset the file save status cause the net has been changed */

		fileSaved = FALSE;

		break;

	case DIALOG_SIMPARS:	/* the ok button from the edit simulation parameters was pressed */

		/* check if simulation step size is valid */

		value = XmTextGetString(editSimParsStepSizeText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < SIMSIZE_MIN) || (number > SIMSIZE_MAX))
		{
			error(34);
			free(value);
			break;
		}
		else	SIMSIZE = number / T_SCALE;
		free(value);

		/* check if neuron activity interval is valid */

		value = XmTextGetString(neuronActivityIntervalText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < NACTINT_MIN) || (number > NACTINT_MAX))
		{
			error(34);
			free(value);
			break;
		}
		else	NACTINT = (int) rint(number);
		free(value);

		/* check if simulation length is valid */

		value = XmTextGetString(editSimParsSimLenText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < SIMLEN_MIN))
		{
			error(33);
			free(value);
			break;
		}
		else
		{
			/* if the simulation step size is lower than before, realloc memory for graphs */

			if (STEP != SIMSIZE || SIMLEN != number / T_SCALE)
				variables_initialized = FALSE;	/* take care that variables will be initialized */

			SIMLEN = number / T_SCALE;
			LTSTOP = SIMLEN;
			neuronActivityInterval = NACTINT;

			if (STEP > SIMSIZE)
			{
				STEP = SIMSIZE;

				/* set in each neuron the simulation end time in the input current structure */

				for (currentNeuron = neuronListHead; currentNeuron != NULL;
				     currentNeuron = currentNeuron->next)
				{
					reset_extern_input_currents(currentNeuron);	/* reset input current */

					if (currentNeuron->graph)
					{
						graphLength = (unsigned int) rint(((currentNeuron->graph->lastX + 2) /
							T_SCALE) / STEP * sizeof(float));

						realloc_graph(currentNeuron->graph, graphLength);
					}

					for (currentSynapse = currentNeuron->connectionList; currentSynapse != NULL;
					     currentSynapse = currentSynapse->nextConnection)
					{
						if (currentSynapse->graph)
						{
							graphLength = (unsigned int) rint(((currentSynapse->graph->lastX + 2) /
								T_SCALE) / STEP * sizeof(float));

							realloc_graphS(currentSynapse->graph, graphLength);
						}
					}
				}
			}
			else
			{
				STEP = SIMSIZE;

				for (currentNeuron = neuronListHead; currentNeuron != NULL;
				     currentNeuron = currentNeuron->next)
				{
					reset_extern_input_currents(currentNeuron);	/* reset input current */
				}
			}

			XtUnmanageChild(editSimParsBB);
		}
		free(value);

		/* reset the file save status cause the net has been changed */

		fileSaved = FALSE;

		break;

	case DIALOG_ONOFF_CHANNELS:	/* the ok button in the ion channels mask for the On/Off-model was pressed */

		/* check the sodium channel equilibrium potential */

		value = XmTextGetString(onOffParamsNaEqPotText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < NAEQ_MIN) || (number > NAEQ_MAX))
		{
			error(5);
			free(value);
			break;
		}
		else 	NAEQ = number / E_SCALE;
		free(value);

		/* check the sodium channel conductance */

		value = XmTextGetString(onOffParamsNaConductanceText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < NACON_MIN) || (number > NACON_MAX))
		{
			error(6);
			free(value);
			break;
		}
		else 	NACON = number / S_SCALE;
		free(value);

		/* check the sodium channels opening duration */

		value = XmTextGetString(onOffParamsNaDurText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < NADUR_MIN) || (number > NADUR_MAX))
		{
			error(38);
			free(value);
			break;
		}
		else 	NADUR = number / T_SCALE;
		free(value);

		/* check potassium channel equilibrium potential */

		value = XmTextGetString(onOffParamsKEqPotText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < KEQ_MIN) || (number > KEQ_MAX))
		{
			error(7);
			free(value);
			break;
		}
		else 	KEQ = number / E_SCALE;
		free(value);

		/* check potassium channel start time */

		value = XmTextGetString(onOffParamsKStartText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < KSTART_MIN) || (number > KSTART_MAX))
		{
			error(39);
			free(value);
			break;
		}
		else 	KSTART = number / T_SCALE;
		free(value);

		/* check potassium channel opening duration */

		value = XmTextGetString(onOffParamsKDurText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < KDUR_MIN) || (number > KDUR_MAX))
		{
			error(40);
			free(value);
			break;
		}
		else 	KDUR = number / T_SCALE;
		free(value);

		/* check potassium channel conductance */

		value = XmTextGetString(onOffParamsKConductanceText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < KCON_MIN) || (number > KCON_MAX))
		{
			error(8);
			free(value);
			break;
		}
		else 	KCON = number / S_SCALE;
		free(value);

		/* check calcium channel equilibrium potential */

		value = XmTextGetString(onOffParamsCaEqPotText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < CAEQ_MIN) || (number > CAEQ_MAX))
		{
			error(9);
			free(value);
			break;
		}
		else 	CAEQ = number / E_SCALE;
		free(value);

		/* check calcium channel start time */

		value = XmTextGetString(onOffParamsCaStartText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < CASTART_MIN) || (number > CASTART_MAX))
		{
			error(41);
			free(value);
			break;
		}
		else 	CASTART = number / T_SCALE;
		free(value);

		/* check calcium channel opening duration */

		value = XmTextGetString(onOffParamsCaDurText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < CADUR_MIN) || (number > CADUR_MAX))
		{
			error(42);
			free(value);
			break;
		}
		else 	CADUR = number / T_SCALE;
		free(value);

		/* check calcium channel conductance */

		value = XmTextGetString(onOffParamsCaConductanceText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < CACON_MIN) || (number > CACON_MAX))
		{
			error(10);
			free(value);
			break;
		}
		else 	CACON = number / S_SCALE;
		free(value);

		/* check spike threshold */

		value = XmTextGetString(onOffParamsSpikeThresholdText);
		number = strtod(value, (char **) NULL);

		if ((! is_it_a_number(value)) || (number < STH_MIN) || (number > STH_MAX))
		{
			error(43);
			free(value);
			break;
		}
		else 	STH = number / E_SCALE;
		free(value);

		/* for all selected neurons set the changed values */

		for (actptr = selectionListNeuronsHead; actptr != NULL; actptr = actptr->next)
		{
			currentNeuron = actptr->neuronPtr;

			if (channelsSelection.NAEQ != NAEQ * E_SCALE)
				ONOFF_NA_E 		= NAEQ;
			if (channelsSelection.NACON != NACON * S_SCALE)
				ONOFF_NA_CONDUCTANCE 	= NACON;
			if (channelsSelection.NADUR != NADUR * T_SCALE)
				ONOFF_NA_DURATION 	= NADUR;
			if (channelsSelection.KEQ != KEQ * E_SCALE)
				ONOFF_K_E 		= KEQ;
			if (channelsSelection.KCON != KCON * S_SCALE)
				ONOFF_K_CONDUCTANCE 	= KCON;
			if (channelsSelection.KSTART != KSTART * T_SCALE)
				ONOFF_K_START 		= KSTART;
			if (channelsSelection.KDUR != KDUR * T_SCALE)
				ONOFF_K_DURATION 	= KDUR;
			if (channelsSelection.CAEQ != CAEQ * E_SCALE)
				ONOFF_CA_E 		= CAEQ;
			if (channelsSelection.CACON != CACON * S_SCALE)
				ONOFF_CA_CONDUCTANCE 	= CACON;
			if (channelsSelection.CASTART != CASTART * T_SCALE)
				ONOFF_CA_START 		= CASTART;
			if (channelsSelection.CADUR != CADUR * T_SCALE)
				ONOFF_CA_DURATION 	= CADUR;
			if (channelsSelection.STH != STH * E_SCALE)
				ONOFF_SPIKE_THRESHOLD	= STH;
		}
		free(value);

		/* the mask can now disappear */

		XtUnmanageChild(onOffParamsBB);

		/* reset the file save status cause the net has been changed */

		fileSaved = FALSE;

		/* remove all actually selected objects from the selection list */

		remove_selected_objects_from_selectionList();

		break;

	case DIALOG_NEW_GRAPH:	/* a new graph should be created for a neuron */

		create_newGraph(mainWindow);

		/* remove all actually selected objects from the selection list */

		remove_selected_objects_from_selectionList();

		break;

	case DIALOG_ALL_GRAPHS:	/* each neuron in the net should have a graph window, so create it */

		/* remove all actually selected objects from the selection list */

		remove_selected_objects_from_selectionList();

		/* loop through all neurons in the net */

		for (currentNeuron = neuronListHead; currentNeuron != NULL; currentNeuron = currentNeuron->next)
		{
			/* first of all add the current neuron to the selection list; this is needed cause the
			   create_newGraph function creates a graph for the first neuron in the selection list */

			add_neuron_to_selection_list(currentNeuron);
			create_newGraph(mainWindow);
			remove_neuron_from_selection_list(currentNeuron);

			for (currentSynapse = currentNeuron->connectionList; currentSynapse != NULL;
			     currentSynapse = currentSynapse->nextConnection)
			{
				/* first of all add the current synapse to the selection list; this is needed cause the
				   create_newGraphS function creates a graph for the first synapse in the selection list */

				add_synapse_to_selection_list(currentSynapse);
				create_newGraphS(mainWindow);
				remove_synapse_from_selection_list(currentSynapse);
			}
		}

		break;

	case DIALOG_NEW_GRAPHS:	/* a new graph should be created for a synapse */

		create_newGraphS(mainWindow);

		/* remove all actually selected objects from the selection list */

		remove_selected_objects_from_selectionList();

		break;

	case DIALOG_INPUT_NEURONS:	/* show input neurons in a different color */

		show_input_neurons(selectionListNeuronsHead->neuronPtr);

		break;

	case DIALOG_OUTPUT_NEURONS:	/* show output neurons in a different color */

		show_output_neurons(selectionListNeuronsHead->neuronPtr);

		break;

	case DIALOG_INPUT_OUTPUT_NEURONS:	/* show input and output neurons in a different color */

		show_input_output_neurons(selectionListNeuronsHead->neuronPtr);

		break;

	case DIALOG_TOPOLOGY:	/* fit the whole net into the window */

		show_topology();

		break;

	case DIALOG_NORMAL_STATE:	/* restore the graphical output to its original size and deselect all objects */

		show_normal_state();
		remove_selected_objects_from_selectionList();

		break;

	case DIALOG_LOAD_GENERAL:	/* read general neuron parameters from file;
					   the filename comes from the load general mask */

		/* get filename from load general mask */

		XmStringGetLtoR(selection->value, defaultFont, &filename);

		/* read in file information for all selected neurons */

		for (actptr = selectionListNeuronsHead; actptr != NULL; actptr = actptr->next)
		{
			read_general_neuron_parameters(filename, actptr->neuronPtr);
		}

		currentNeuron = selectionListNeuronsHead->neuronPtr;

		/*** fill edit neuron general parameters mask with read in values ***/

		/* set soma membrane conductance */

		sprintf(textnumber,"%f", SOMA_Gcore * S_SCALE);
		XmTextSetString(editNeuronToDendritConductanceText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronToDendritConductanceScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (SOMA_Gcore * S_SCALE * sF);

		XmScaleSetValue(editNeuronToDendritConductanceScale, scaleValue);

		/* set soma start potential */

		sprintf(textnumber,"%f", SOMA_E_INITIAL * E_SCALE);
		XmTextSetString(editNeuronPotentialText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronPotentialScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (SOMA_E_INITIAL * E_SCALE * sF);

		XmScaleSetValue(editNeuronPotentialScale, scaleValue);

		/* set soma capacity */

		sprintf(textnumber,"%f", SOMA_Cm * C_SCALE);
		XmTextSetString(editNeuronCapacityText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronCapacityScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (SOMA_Cm * C_SCALE * sF);

		XmScaleSetValue(editNeuronCapacityScale, scaleValue);

		/* set soma resting potential */

		sprintf(textnumber,"%f", SOMA_Eleak_INITIAL * E_SCALE);
		XmTextSetString(editNeuronLeakText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronLeakScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (SOMA_Eleak_INITIAL * E_SCALE * sF);

		XmScaleSetValue(editNeuronLeakScale, scaleValue);

		/* set soma membrane conductance */

		sprintf(textnumber,"%f", SOMA_REST_Gm * S_SCALE);
		XmTextSetString(editNeuronConductanceText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronConductanceScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (SOMA_REST_Gm * S_SCALE * sF);

		XmScaleSetValue(editNeuronConductanceScale, scaleValue);

		/* set soma to dendrite conductance */

		sprintf(textnumber,"%f", DENDRITE_Gcore * S_SCALE);
		XmTextSetString(editNeuronToSomaConductanceText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronToSomaConductanceScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (DENDRITE_Gcore * S_SCALE * sF);

		XmScaleSetValue(editNeuronToSomaConductanceScale, scaleValue);

		/* set dendrite start potential */

		sprintf(textnumber,"%f", DENDRITE_E_INITIAL * E_SCALE);
		XmTextSetString(editNeuronDPotentialText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDPotentialScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (DENDRITE_E_INITIAL * E_SCALE * sF);

		XmScaleSetValue(editNeuronDPotentialScale, scaleValue);

		/* set dendrite capacity */

		sprintf(textnumber,"%f", DENDRITE_Cm * C_SCALE);
		XmTextSetString(editNeuronDCapacityText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDCapacityScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (DENDRITE_Cm * C_SCALE * sF);

		XmScaleSetValue(editNeuronDCapacityScale, scaleValue);

		/* set dendrite resting potential */

		sprintf(textnumber,"%f", DENDRITE_Eleak_INITIAL * E_SCALE);
		XmTextSetString(editNeuronDLeakText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDLeakScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (DENDRITE_Eleak_INITIAL * E_SCALE * sF);

		XmScaleSetValue(editNeuronDLeakScale, scaleValue);

		/* set dendrite conductance */

		sprintf(textnumber,"%f", DENDRITE_REST_Gm * S_SCALE);
		XmTextSetString(editNeuronDConductanceText, textnumber);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDConductanceScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) (DENDRITE_REST_Gm * S_SCALE * sF);

		XmScaleSetValue(editNeuronDConductanceScale, scaleValue);

		/* the load general mask is no longer needed, so it can be disappear */

		XtUnmanageChild(loadGeneralDialog);

		break;

	case DIALOG_SAVE_GENERAL:	/* save neuron parameters of selected neuron
					   the filename comes from the save general mask */

		/* get filename from save general mask */

		XmStringGetLtoR(selection->value, defaultFont, &filename);
		strcpy(temp, filename);

		if (! strchr(temp, (int) '/')) /* contains the filename no subdirectory ? */
		{
			/* create the full pathname using the default neuron parameter directory */

			strcpy(temp, neuronParameterDirectory);
			temp[strlen(temp) - 5] = '\0'; /* cut extension */
			strcat(temp, filename);

			if (! strchr(temp, (int) '.')) /* does no extension exist ? */
			{
				strcat(temp, ".gen");	/* append extension .gen */
			}
			else	/* look if extension is .gen */
			{
				ptr = strrchr(temp, (int) '.');
				if ((*(ptr + 1) != 'g') || (*(ptr + 2) != 'e') || (*(ptr + 3) != 'n'))
				{
					error(4);
					XtManageChild(saveGeneralDialog);

					break;
				}
			}
		}
		else	/* the filename contains a subdirectory, so a full pathname was specified for saving */
		{
			if (! strchr(temp, (int) '.')) /* does no extension exist ? */
			{
				strcat(temp, ".gen");	/* append extension .gen */
			}
			else	/* look if extension is .gen */
			{
				ptr = strrchr(temp, (int) '.');
				if ((*(ptr + 1) != 'g') || (*(ptr + 2) != 'e') || (*(ptr + 3) != 'n'))
				{
					error(4);
					XtManageChild(saveGeneralDialog);

					break;
				}
			}
		}

		/* save information in file */

		save_general_neuron_parameters(temp, selectionListNeuronsHead->neuronPtr);

		/* the save general mask is no longer needed, so it can be disappear */

		XtUnmanageChild(saveGeneralDialog);

		break;

	case DIALOG_INFO:	/* show information about the selected object */

		if (selectionListNeuronsHead != NULL)
		{
			/* show information about neuron */

			currentNeuron = selectionListNeuronsHead->neuronPtr;

			strcpy(info, infoNString);
			strcat(info, "\n\n");
			strcat(info, neuronNumberString);
			strcat(info, "\t\t\t");
			sprintf(textnumber, "%d", currentNeuron->neuronId);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, neuronTypeString);
			strcat(info, "\t\t\t");

			strcpy(currents, currentsString);
			strcat(currents, "\n\n");
			strcat(currents, naCurrentString);
			strcat(currents, "\t\t\t");
			sprintf(textnumber, "%.2f", I_NA * S_SCALE);
			strcat(currents, textnumber);
			strcat(currents, "\n");
			strcat(currents, kCurrentString);
			strcat(currents, "\t\t\t");
			sprintf(textnumber, "%.2f", I_K * S_SCALE);
			strcat(currents, textnumber);
			strcat(currents, "\n");
			strcpy(val, "spiker");

			switch(networkmodel)
			{
			case 1: /* ON/OFF model */

				if (ONOFF_NA_CONDUCTANCE == (double) 0.0 && ONOFF_K_CONDUCTANCE == (double) 0.0)
					strcpy(val, "non-spiker");

				strcat(currents, caCurrentString);
				strcat(currents, "\t\t\t");
				sprintf(textnumber, "%.2f", I_CA * S_SCALE);
				strcat(currents, textnumber);
				strcat(currents, "\n\n");
				break;
        
			case 2: /* SWIM model */

				if (SWIM_NA_G == (double) 0.0 && SWIM_K_G == (double) 0.0)
					strcpy(val, "non-spiker");

				strcat(currents, caCurrentString);
				strcat(currents, "\t\t\t");
				sprintf(textnumber, "%.2f", I_CA * S_SCALE);
				strcat(currents, textnumber);
				strcat(currents, "\n\n");
				break;

			case 3: /* HH model */

				if (HH_NA_G == (double) 0.0 && HH_K_G == (double) 0.0)
					strcpy(val, "non-spiker");

				strcat(currents, "\n");
				break;

			case 4: /* GB model */

				if (GB_NA_G == (double) 0.0 && GB_K_G == (double) 0.0)
					strcpy(val, "non-spiker");

				strcat(currents, ca1CurrentString);
				strcat(currents, "\t\t");
				sprintf(textnumber, "%.2f", GB_I_CA1 * S_SCALE);
				strcat(currents, textnumber);
				strcat(currents, "\n");
				strcat(currents, ca2CurrentString);
				strcat(currents, "\t\t");
				sprintf(textnumber, "%.2f", GB_I_CA2 * S_SCALE);
				strcat(currents, textnumber);
				strcat(currents, "\n");
				strcat(currents, kCaCurrentString);
				strcat(currents, "\t");
				sprintf(textnumber, "%.2f", GB_I_KCA * S_SCALE);
				strcat(currents, textnumber);
				strcat(currents, "\n");
				strcat(currents, aCurrentString);
				strcat(currents, "\t\t\t");
				sprintf(textnumber, "%.2f", GB_I_A * S_SCALE);
				strcat(currents, textnumber);
				strcat(currents, "\n");
				strcat(currents, irCurrentString);
				strcat(currents, "\t\t\t");
				sprintf(textnumber, "%.2f", GB_I_IR * S_SCALE);
				strcat(currents, textnumber);
				strcat(currents, "\n\n");
				strcat(currents, caConcString);
				strcat(currents, "\t\t");
				sprintf(textnumber, "%.2f", GB_CONC_CA * 1e6);
				strcat(currents, textnumber);
				strcat(currents, "\n");
				strcat(currents, calciumEqPotentialString);
				strcat(currents, "\t");
				sprintf(textnumber, "%.2f", GB_CA_E * E_SCALE);
				strcat(currents, textnumber);
				strcat(currents, "\n\n");
				break;
			}

			strcat(info, val);
			strcat(info, "\n");
			strcat(info, spikeCounterString);
			strcat(info, "\t\t\t");
			sprintf(textnumber, "%d", SpikeCounter);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, spikeFrequencyString);
			strcat(info, "\t\t\t");
			if (L == 0.0)
				sprintf(textnumber, "%d", 0);
			else	sprintf(textnumber, "%.2f", SpikeCounter / L);
			strcat(info, textnumber);
			strcat(info, "\n\n");
			strcat(info, currents);
			strcat(info, potentialsString);
			strcat(info, "\n\n");
			strcat(info, somaPotentialString);
			strcat(info, "\t\t\t");
			sprintf(textnumber, "%.2f", E_POT[0] * E_SCALE);
			strcat(info, textnumber);
			strcat(info, "\n\n");
			strcat(info, dendritPotentialsString);
			strcat(info, "\n\n");

			for (i = 1; i <= curNumOfDendSegs; i++)
			{
				strcat(info, dendritPotentialString);
				sprintf(textnumber, "%d", i);
				strcat(info, textnumber);
				strcat(info, " [mV]:\t");
				sprintf(textnumber, "%.2f", E_POT[i] * E_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
			}

			strcat(info, "\n");
			strcat(info, chemicalCurrentString);
			strcat(info, "\n\n");
			strcat(info, chemicalSomaCurrentString);
			strcat(info, "\t\t");
			sprintf(textnumber, "%.2f", ICH[0] * S_SCALE);
			strcat(info, textnumber);
			strcat(info, "\n");

			for (i = 1; i <= curNumOfDendSegs; i++)
			{
				strcat(info, chemicalCurrentCompartmentString);
				sprintf(textnumber, "%d", i);
				strcat(info, textnumber);
				strcat(info, " [nA]:\t");
				sprintf(textnumber, "%.2f", ICH[i] * S_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
			}

			strcat(info, "\n");
			strcat(info, electricalCurrentString);
			strcat(info, "\n\n");
			strcat(info, electricalSomaCurrentString);
			strcat(info, "\t\t");
			sprintf(textnumber, "%.2f", IEL[0] * S_SCALE);
			strcat(info, textnumber);
			strcat(info, "\n");

			for (i = 1; i <= curNumOfDendSegs; i++)
			{
				strcat(info, electricalCurrentCompartmentString);
				sprintf(textnumber, "%d", i);
				strcat(info, textnumber);
				strcat(info, " [nA]:\t");
				sprintf(textnumber, "%.2f", IEL[i] * S_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
			}

			/* show the information about neuron mask */

			XmTextSetString(infoObjectText, info);
			XtManageChild(infoObjectBB);
		}
		else if (selectionListSynapsesHead != NULL)
		{
			/* show information about synapse */

			currentSynapse = selectionListSynapsesHead->synapsePtr;

			strcpy(info, infoSString);
			strcat(info, "\n\n");

			if (currentSynapse->axoSynapseNumber > 0)	/* axo-axonic connection */
			{
				strcat(info, axoSynapseNumberString);
				strcat(info, "\t");
				sprintf(textnumber, "%d", currentSynapse->axoSynapseNumber);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, targetSynapseNumberString);
				strcat(info, "\t\t");
				sprintf(textnumber, "%d", currentSynapse->synapseID);
				strcat(info, textnumber);
				strcat(info, "\n\n");
			}
			else	/* not axo-axonic */
			{
				strcat(info, synapseIDString);
				strcat(info, "\t");
				sprintf(textnumber, "%d", currentSynapse->synapseID);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, synapseFromNeuronString);
				strcat(info, " ");
				sprintf(textnumber, "%d", currentSynapse->parentNeuron->neuronId);
				strcat(info, textnumber);
				strcat(info, " ");
				strcat(info, toNeuronString);
				strcat(info, " ");
				sprintf(textnumber, "%d", currentSynapse->targetNeuron->neuronId);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, targetConnectionString);
				strcat(info, "\t");

				if (currentSynapse->targetArea == 0)	/* Soma */
				{
					strcat(info, somaString);
					strcat(info, "\n");
				
				}
				else	/* Dendrit */
				{
					strcat(info, dendritSegmentString);
					strcat(info, "\t");
					sprintf(textnumber, "%d", currentSynapse->targetArea);
					strcat(info, textnumber);
					strcat(info, "\n");
				}

				strcat(info, "\n");

				strcat(info, synapticTypeString);
				strcat(info, "\t\t\t\t");

				switch(synapseTypes[currentSynapse->synapticType].ionType)
				{
				case 1:	
					strcat(info, sodiumString);
					break;
				case 2:	
					strcat(info, potassiumString);
					break;
				case 3:	
					strcat(info, chemicalString);
					break;
				case 4:	
					strcat(info, electricalString);
					break;
				}

				strcat(info, "\n");
				strcat(info, synapticEQPotentialString);
				strcat(info, "\t");
				sprintf(textnumber, "%.2f", synapseTypes[currentSynapse->synapticType].equilPotential
					* E_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n\n");
			}

			strcat(info, synapticTransmissionString);
			strcat(info, "\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->deliveryTime * T_SCALE);
			strcat(info, textnumber);
			strcat(info, "\n");

			strcat(info, synapsePotentialString);
			strcat(info, "\t\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->potential * E_SCALE);
			strcat(info, textnumber);
			strcat(info, "\n\n");

			strcat(info, transmitterReleaseString);
			strcat(info, "\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->transmitterReleaseThreshold * E_SCALE);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, transmitterSatiationString);
			strcat(info, "\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->transmitterSatiate * E_SCALE);
			strcat(info, textnumber);
			strcat(info, "\n\n");

			if (currentSynapse->axoSynapseNumber > 0)	/* axo-axonic connection */
			{
				strcat(info, initialInhibitionString);
				strcat(info, "\t\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->initialInhibitionFactor * P_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, currentInhibitionString);
				strcat(info, "\t\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->currentInhibitionFactor * P_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, maxInhibitionString);
				strcat(info, "\t\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->maxInhibitionFactor * P_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n\n");
			}
			else	/* not axo-axonic */
			{
				strcat(info, initialConductanceString);
				strcat(info, "\t\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->initialConductance * S_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, normalConductanceString);
				strcat(info, "\t\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->conductance * S_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, currentConductanceString);
				strcat(info, "\t\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->currentConductance * S_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n");
				strcat(info, maxConductanceString);
				strcat(info, "\t\t\t");
				sprintf(textnumber, "%.2f", currentSynapse->maxConductance * S_SCALE);
				strcat(info, textnumber);
				strcat(info, "\n\n");
			}

			/* Learnparameter */

			strcat(info, learnParameterString);
			strcat(info, "\n\n");
			strcat(info, learnStimuliString);
			strcat(info, "\n\n");
			strcat(info, stmCntString);
			strcat(info, "\t\t\t\t");
			sprintf(textnumber, "%d", currentSynapse->stmCnt);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, condCntString);
			strcat(info, "\t\t\t\t");
			sprintf(textnumber, "%d", currentSynapse->condCnt);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, hebbCntString);
			strcat(info, "\t\t\t\t\t");
			sprintf(textnumber, "%d", currentSynapse->hebbCnt);
			strcat(info, textnumber);
			strcat(info, "\n\n");
			strcat(info, synapticMemorySTPString);
			strcat(info, "\t");
			sprintf(textnumber, "%.2f", currentSynapse->synapticMemorySTP * P_SCALE);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, trainingFlagString);
			strcat(info, "\t\t\t\t");
			if (currentSynapse->trainingFlagSTP)
				strcat(info, longTermForgettingString);
			else	strcat(info, shortTermForgettingString);
			strcat(info, "\n");
			strcat(info, synapticMemoryHebbString);
			strcat(info, "\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->synapticMemoryHebb * P_SCALE);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, trainingFlagString);
			strcat(info, "\t\t\t\t");
			if (currentSynapse->trainingFlagHebb)
				strcat(info, longTermForgettingString);
			else	strcat(info, shortTermForgettingString);
			strcat(info, "\n");
			strcat(info, synapticMemoryCondString);
			strcat(info, "\t");
			sprintf(textnumber, "%.2f", currentSynapse->synapticMemoryCond * P_SCALE);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, trainingFlagString);
			strcat(info, "\t\t\t\t");
			if (currentSynapse->trainingFlagCond)
				strcat(info, longTermForgettingString);
			else	strcat(info, shortTermForgettingString);
			strcat(info, "\n\n");
			strcat(info, learnCurveSlopeString);
			strcat(info, "\t\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->slope);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, shortTermMemoryString);
			strcat(info, "\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->shortTermMemory);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, longTermThresholdString);
			strcat(info, "\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->longTermThreshold);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, longTermMinimumString);
			strcat(info, "\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->longTermMinimum * P_SCALE);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, hebbIntervalString);
			strcat(info, "\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->hebbIntervall * T_SCALE);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, hebbLearnFactorString);
			strcat(info, "\t\t\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->hebbLearnFactor);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, competitiveLearnFactorString);
			strcat(info, "\t\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->competitiveLearnFactor);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, shortTermLearnFactorString);
			strcat(info, "\t\t\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->shortTermPlasticityLearnFactor);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, conditioningLearnFactorString);
			strcat(info, "\t\t\t");
			sprintf(textnumber, "%.2f", currentSynapse->conditioningLearnFactor);
			strcat(info, textnumber);

			/* show the information about synapse mask */

			XmTextSetString(infoObjectText, info);
			XtManageChild(infoObjectBB);
		}
		else
		{
			/* calculate current allocated memory */

			poolNumber = 0;
			senderNumber = 0;
			axoSenderNumber = 0;
			processQueueMemory = 0;
			graphMemory = 0;
			graphSMemory = 0;

			/* start shell script to read in current program size */

			strcpy(temp, biosimDir);
			strcat(temp, "/askpgmsize ");
			strcat(temp, programName);
			strcpy(textnumber, "");
			pipe = popen(temp,"r");
			while (! feof(pipe))
			{
				fscanf(pipe, "%s", textnumber);
			}
			pclose(pipe);
			if (! is_it_a_number(textnumber) || atoi(textnumber) == 0)
				strcpy(textnumber, "???");

			programSize = atol(textnumber);

			totalMemory = programSize;
			neuronMemory = 0;

			for (currentNeuron = neuronListHead; currentNeuron != NULL; currentNeuron = currentNeuron->next)
			{
				totalMemory += (unsigned long) currentNeuron->neuronSize;
				neuronMemory += (unsigned long) currentNeuron->neuronSize;

				currentGraph = currentNeuron->graph;
				if (currentGraph)
					graphMemory += (unsigned long) (14 * currentGraph->graphSize);

				for (currentSynapse = currentNeuron->connectionList; currentSynapse != NULL;
				    currentSynapse = currentSynapse->nextConnection)
				{
					currentGraphS = currentSynapse->graph;
					if (currentGraphS)
						graphSMemory += (unsigned long) (4 * currentGraphS->graphSize);

					if (currentSynapse->axoSynapseNumber > 0)	/* axo-axonic connection */
					{
						axoSenderNumber++;
						processQueueMemory += (unsigned long) (TTdSS *
							sizeof(currentSynapse->axoSenderList->processQueue));
					}
					else	/* not axo-axonic */
					{
						senderNumber++;

						for (currentPool = currentNeuron->poolList; currentPool != NULL;
						     currentPool = currentPool->nextPool)
						{
							processQueueMemory += (unsigned long) (LTTdSS *
								sizeof(currentPool->processQueue));
							poolNumber++;
						}
					}
				}
			}

			neuronMemory = (unsigned long) rint((double) (neuronMemory / neuronNumber));

			totalMemory += (synapseNumber + axoSynapsesNumber) * sizeof(Connection);
			totalMemory += graphNumber * sizeof(Graph);
			totalMemory += graphMemory;
			totalMemory += graphNumberS * sizeof(SGraph);
			totalMemory += graphSMemory;
			totalMemory += numTypes * sizeof(Synapse);
			totalMemory += poolNumber * sizeof(ChemicalPool);
			totalMemory += senderNumber * sizeof(ChemicalSenderList);
			totalMemory += axoSenderNumber * sizeof(AxoAxonicSenderList);
			totalMemory += processQueueMemory;

			/* show information about the system */

			strcpy(info, systemInformationString);
			strcat(info, "\n\n");
			strcat(info, systemInformationPagingSpaceString);

			/* start shell script to read in free paging space */

			strcpy(temp, biosimDir);
			strcat(temp, "/askps");
			strcpy(textnumber, "");
			pipe = popen(temp,"r");
			while (! feof(pipe))
			{
				fscanf(pipe, "%s", textnumber);
			}
			pclose(pipe);
			if (! is_it_a_number(textnumber) || atoi(textnumber) == 0)
				strcpy(textnumber, "???");

			strcat(info, textnumber);
			strcat(info, " KBytes\n\n");
			strcat(info, systemInformationNeuronsString);
			strcat(info, "\t\t\t");
			sprintf(textnumber, "%d", neuronNumber);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, systemInformationSynapsesString);
			strcat(info, "\t\t\t");
			sprintf(textnumber, "%d", synapseNumber + axoSynapsesNumber);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, systemInformationAxoSynapsesString);
			strcat(info, "\t\t");
			sprintf(textnumber, "%d", axoSynapsesNumber);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, systemInformationAverageSynapsesString);
			strcat(info, "\t");
			if (neuronNumber == 0)
				strcpy(textnumber, "0");
			else	sprintf(textnumber, "%.2f", (float) (synapseNumber + axoSynapsesNumber) / neuronNumber);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, systemInformationGraphString);
			strcat(info, "\t");
			sprintf(textnumber, "%d", graphNumber);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, systemInformationGraphSString);
			strcat(info, "\t");
			sprintf(textnumber, "%d", graphNumberS + graphNumberAS);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, systemInformationSynapticTypesString);
			strcat(info, "\t\t\t");
			sprintf(textnumber, "%d", numTypes);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, systemInformationProgMemoryString);
			strcat(info, "\t\t");
			sprintf(textnumber, "%d", programSize);
			strcat(info, textnumber);
			strcat(info, byteString);
			strcat(info, "\n");
			strcat(info, systemInformationNeuronMemoryString);
			strcat(info, "\t\t\t");
			sprintf(textnumber, "%d%s", neuronMemory, byteString);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, systemInformationSynapseMemoryString);
			strcat(info, "\t\t\t");
			sprintf(textnumber, "%d%s", sizeof(Connection), byteString);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, systemInformationGraphMemoryString);
			strcat(info, "\t");
			sprintf(textnumber, "%d%s", graphNumber * sizeof(Graph) + graphMemory, byteString);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, systemInformationGraphSMemoryString);
			strcat(info, "\t");
			sprintf(textnumber, "%d%s", (graphNumberS + graphNumberAS) * sizeof(SGraph) + graphSMemory,
				byteString);
			strcat(info, textnumber);
			strcat(info, "\n");
			strcat(info, systemInformationTotalMemoryString);
			strcat(info, "\t\t\t");
			sprintf(textnumber, "%u%s", totalMemory, byteString);
			strcat(info, textnumber);

			/* show the information about synapse mask */

			XmTextSetString(infoObjectText, info);
			XtManageChild(infoObjectBB);
		}

		break;

	case DIALOG_SPECIFY:	/* the selected objects must be written to a file */

		/* open the file in override write mode */

		if ((fp = fopen(selectedObjectsFile, "w")) == 0)
			error(115);

		fprintf(fp, "%i\n", SELECTION_FILE);	/* write out identification number of filetype */

		if (selectionListNeuronsCounter != 0)	/* neurons are selected */

			/* loop through all selected neurons */

			for (actptr = selectionListNeuronsHead; actptr != NULL; actptr = actptr->next)

				fprintf(fp, "Neuron %i\n", actptr->neuronPtr->neuronId);
		else
		if (selectionListSynapsesCounter != 0)	/* synapses are selected */
		{
			/* loop through all selected synapses */

			for (actualSynapse = selectionListSynapsesHead; actualSynapse != NULL;
				actualSynapse = actualSynapse->next)
			{
				currentSynapse = actualSynapse->synapsePtr;

				/* in case of axo-axonic connection write out parent neuron id and all data of
				   target chemical connection */

				if (complexModel && (currentSynapse->axoSynapseNumber > 0))
					fprintf(fp, "Axo-Synapse %i %i %i %i\n", currentSynapse->parentNeuron->neuronId,
						currentSynapse->targetSynapse->parentNeuron->neuronId,
						currentSynapse->targetSynapse->targetNeuron->neuronId,
						currentSynapse->targetSynapse->targetArea);
				else fprintf(fp, "Synapse %i %i %i\n", currentSynapse->parentNeuron->neuronId,
					currentSynapse->targetNeuron->neuronId, currentSynapse->targetArea);
			}
		}

		/* close the file */

		if (fclose(fp) != 0)
			error(101);

		/* remove all actually selected objects from the selection list */

		remove_selected_objects_from_selectionList();

		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in ACCEPT2_DIALOG occured !\n");
		break;
	}
} /* end of dialog_accept2_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_cancel2_CB(w, client_data, call_data)
 
	PURPOSE		: callback for cancel buttons

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_cancel2_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	switch((int) client_data)
	{
	case DIALOG_EDIT_SYNAPSE:	editFlag = FALSE;
					XtUnmanageChild(editSynapseBB);
					break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in CANCEL2_DIALOG occured !\n");
		break;
	}

} /* end of dialog_cancel2_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_help2_CB(w, client_data, call_data)
 
	PURPOSE		: callback for help buttons

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_help2_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	/* help is not available at the moment */

	switch((int) client_data)
	{
	case DIALOG_ONOFF_CHANNELS:

		sendhelp(w, "helpserver", "biosim", HELP_ONOFFMODEL);
		break;

	case DIALOG_HH_CHANNELS:

		sendhelp(w, "helpserver", "biosim", HELP_HHMODEL);
		break;

	case DIALOG_SWIM_CHANNELS:

		sendhelp(w, "helpserver", "biosim", HELP_SWIMMODEL);
		break;

	case DIALOG_GB_CHANNELS:

		sendhelp(w, "helpserver", "biosim", HELP_GBMODEL);
		break;

	case DIALOG_NEURON:

		sendhelp(w, "helpserver", "biosim", HELP_NEURON);
		break;

	case DIALOG_CURRENT:

		sendhelp(w, "helpserver", "biosim", HELP_CURRENT);
		break;

	case DIALOG_ADD_SYNAPSE:

		sendhelp(w, "helpserver", "biosim", HELP_ADDSYNAPSE);
		break;

	case DIALOG_EDIT_SYNAPSE:

		sendhelp(w, "helpserver", "biosim", HELP_EDITSYNAPSE);
		break;

	case DIALOG_SIMPARS:

		sendhelp(w, "helpserver", "biosim", HELP_SIMPARS);
		break;

	case DIALOG_NEW_STYPE:

		sendhelp(w, "helpserver", "biosim", HELP_NEWSTYPE);
		break;

	case DIALOG_LOAD_GENERAL:
	case DIALOG_SAVE_GENERAL:

		sendhelp(w, "helpserver", "biosim", HELP_LOADGENERAL);
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in HELP2_DIALOG occured !\n");
		break;
	}

} /* end of dialog_help2_CB */

/************************************************************************************************************************

 	FUNCTION	: radio_box2_CB(w, client_data, call_data)
 
	PURPOSE		: callback for radio boxes

	RETURNS		: nothing

************************************************************************************************************************/

void radio_box2_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	XmToggleButtonCallbackStruct *button = (XmToggleButtonCallbackStruct *) call_data;
	Boolean 	set = button->set;		/* status of radio box button */
	char		text[20];			/* used for number to string conversion */

	/* evaluate client data */

	switch((int) client_data)
	{
	case SODIUM:	/* a new excitatory synapse type should be defined */

		if (set == TRUE)
		{
			STYPE = 1;
			sprintf(text,"%f", (double) NAEQ_SWIM_DEF);
			XmTextSetString(newSTypeEqPotText, text);
		}
		break;

	case POTASSIUM:	/* a new inhibitory synapse type should be defined */

		if (set == TRUE)
		{
			STYPE = 2;
			sprintf(text,"%f", (double) KEQ_SWIM_DEF);
			XmTextSetString(newSTypeEqPotText, text);
		}
		break;

	case CHEMICAL:	/* a new chemical synapse type should be defined */

		if (set == TRUE)
		{
			STYPE = 3;
			XmTextSetString(newSTypeEqPotText, "");
		}
		break;

	case NOISE_TOGGLE:	/* the noise toggle button in edit current dialog was pressed */

		NOISE = set;
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in RADIO_BOX occured !\n");
		break;
	}

} /* end of radio_box2_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_text2_CB(w, client_data, call_data)
 
	PURPOSE		: callback for text widgets

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_text2_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	Arg		args[20];		/* argument list for manipulating widgets */
	Cardinal	n;			/* used as argument counter for manipulating widgets */
	char		*value = NULL;		/* used for detection of valid number string */
	int		scaleValue;		/* value of scale widget */
	int		sF;			/* scaling factor */
	short int	decimals;		/* number of decimals for scale widget */
	double		number;			/* number read from text widget */

	/* check if number beginns with a valid sign */

	value = XmTextGetString(w);

	if ((strlen(value) == 0) ||
	    (strcmp(value,"+") == 0) ||
	    (strcmp(value,"-") == 0) ||
	    (strcmp(value,".") == 0) ||
	    (strcmp(value," +") == 0) ||
	    (strcmp(value," -") == 0) ||
	    (strcmp(value," .") == 0) ||
	    (strcmp(value,"+ ") == 0) ||
	    (strcmp(value,"- ") == 0) ||
	    (strcmp(value," + ") == 0) ||
	    (strcmp(value," - ") == 0))
	{
		free(value);
		return;
	}

	number = strtod(value, (char **) NULL);

	/* check if number is valid */

	if (! is_it_a_number(value))
	{
		free(value);
		error(45);
		return;
	}

	/* check number dependend on the widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_TEXT_SWIM_NAEQ:	/* the sodium channel equilibrium potential was edited */

		NAEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsNaEqScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (NAEQ_MAX * sF))
			scaleValue = (NAEQ_MAX * sF);
		else if (scaleValue < (NAEQ_MIN * sF))
			scaleValue = (NAEQ_MIN * sF);

		XmScaleSetValue(swimParamsNaEqScale, scaleValue);
		break;

	case DIALOG_TEXT_SWIM_NACON:	/* the sodium channel conductance was edited */

		NACON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsNaConScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (NACON_MAX * sF))
			scaleValue = (NACON_MAX * sF);
		else if (scaleValue < (NACON_MIN * sF))
			scaleValue = (NACON_MIN * sF);

		XmScaleSetValue(swimParamsNaConScale, scaleValue);
		break;

	case DIALOG_TEXT_SWIM_KEQ:	/* the potassium channel equilibrium potential was edited */

		KEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsKEqScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (KEQ_MAX * sF))
			scaleValue = (KEQ_MAX * sF);
		else if (scaleValue < (KEQ_MIN * sF))
			scaleValue = (KEQ_MIN * sF);

		XmScaleSetValue(swimParamsKEqScale, scaleValue);
		break;

	case DIALOG_TEXT_SWIM_KCON:	/* the potassium channel conductance was edited */

		KCON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsKConScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (KCON_MAX * sF))
			scaleValue = (KCON_MAX * sF);
		else if (scaleValue < (KCON_MIN * sF))
			scaleValue = (KCON_MIN * sF);

		XmScaleSetValue(swimParamsKConScale, scaleValue);
		break;

	case DIALOG_TEXT_SWIM_CAEQ:	/* the calcium channel equilibrium potential was edited */

		CAEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsCaEqScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (CAEQ_MAX * sF))
			scaleValue = (CAEQ_MAX * sF);
		else if (scaleValue < (CAEQ_MIN * sF))
			scaleValue = (CAEQ_MIN * sF);

		XmScaleSetValue(swimParamsCaEqScale, scaleValue);
		break;

	case DIALOG_TEXT_SWIM_CACON:	/* the calcium channel conductance was edited */

		CACON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsCaConScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (CACON_MAX * sF))
			scaleValue = (CACON_MAX * sF);
		else if (scaleValue < (CACON_MIN * sF))
			scaleValue = (CACON_MIN * sF);

		XmScaleSetValue(swimParamsCaConScale, scaleValue);
		break;

	case DIALOG_TEXT_HH_NAEQ:	/* the sodium channel equilibrium potential was edited */

		NAEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(hhParamsNaEqScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (NAEQ_MAX * sF))
			scaleValue = (NAEQ_MAX * sF);
		else if (scaleValue < (NAEQ_MIN * sF))
			scaleValue = (NAEQ_MIN * sF);

		XmScaleSetValue(hhParamsNaEqScale, scaleValue);
		break;

	case DIALOG_TEXT_HH_NACON:	/* the sodium channel conductance was edited */

		NACON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(hhParamsNaConScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (NACON_MAX * sF))
			scaleValue = (NACON_MAX * sF);
		else if (scaleValue < (NACON_MIN * sF))
			scaleValue = (NACON_MIN * sF);

		XmScaleSetValue(hhParamsNaConScale, scaleValue);
		break;

	case DIALOG_TEXT_HH_KEQ:	/* the potassium channel equilibrium potential was edited */

		KEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(hhParamsKEqScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (KEQ_MAX * sF))
			scaleValue = (KEQ_MAX * sF);
		else if (scaleValue < (KEQ_MIN * sF))
			scaleValue = (KEQ_MIN * sF);

		XmScaleSetValue(hhParamsKEqScale, scaleValue);
		break;

	case DIALOG_TEXT_HH_KCON:	/* the potassium channel conductance was edited */

		KCON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(hhParamsKConScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (KCON_MAX * sF))
			scaleValue = (KCON_MAX * sF);
		else if (scaleValue < (KCON_MIN * sF))
			scaleValue = (KCON_MIN * sF);

		XmScaleSetValue(hhParamsKConScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_NAEQ:	/* the sodium channel equilibrium potential was edited */

		NAEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsNaEqScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (NAEQ_MAX * sF))
			scaleValue = (NAEQ_MAX * sF);
		else if (scaleValue < (NAEQ_MIN * sF))
			scaleValue = (NAEQ_MIN * sF);

		XmScaleSetValue(gbParamsNaEqScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_NACON:	/* the sodium channel conductance was edited */

		NACON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsNaConScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (NACON_MAX * sF))
			scaleValue = (NACON_MAX * sF);
		else if (scaleValue < (NACON_MIN * sF))
			scaleValue = (NACON_MIN * sF);

		XmScaleSetValue(gbParamsNaConScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_KEQ:	/* the potassium channel equilibrium potential was edited */

		KEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsKEqScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (KEQ_MAX * sF))
			scaleValue = (KEQ_MAX * sF);
		else if (scaleValue < (KEQ_MIN * sF))
			scaleValue = (KEQ_MIN * sF);

		XmScaleSetValue(gbParamsKEqScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_KCON:	/* the potassium channel conductance was edited */

		KCON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsKConScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (KCON_MAX * sF))
			scaleValue = (KCON_MAX * sF);
		else if (scaleValue < (KCON_MIN * sF))
			scaleValue = (KCON_MIN * sF);

		XmScaleSetValue(gbParamsKConScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_CA1CON:	/* the first calcium channel conductance was edited */

		CA1CON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsCa1ConScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (CACON_MAX * sF))
			scaleValue = (CACON_MAX * sF);
		else if (scaleValue < (CACON_MIN * sF))
			scaleValue = (CACON_MIN * sF);

		XmScaleSetValue(gbParamsCa1ConScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_CA2CON:	/* the second calcium channel conductance was edited */

		CA2CON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsCa2ConScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (CACON_MAX * sF))
			scaleValue = (CACON_MAX * sF);
		else if (scaleValue < (CACON_MIN * sF))
			scaleValue = (CACON_MIN * sF);

		XmScaleSetValue(gbParamsCa2ConScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_KCAEQ:	/* the calcium dependend potassium channel equilibrium potential was edited */

		KCAEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsKCAEqScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (KCAEQ_MAX * sF))
			scaleValue = (KCAEQ_MAX * sF);
		else if (scaleValue < (KCAEQ_MIN * sF))
			scaleValue = (KCAEQ_MIN * sF);

		XmScaleSetValue(gbParamsKCAEqScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_KCACON:	/* the calcium dependend potassium channel conductance was edited */

		KCACON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsKCAConScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (KCACON_MAX * sF))
			scaleValue = (KCACON_MAX * sF);
		else if (scaleValue < (KCACON_MIN * sF))
			scaleValue = (KCACON_MIN * sF);

		XmScaleSetValue(gbParamsKCAConScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_AEQ:	/* the A channel equilibrium potential was edited */

		AEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsAEqScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (AEQ_MAX * sF))
			scaleValue = (AEQ_MAX * sF);
		else if (scaleValue < (AEQ_MIN * sF))
			scaleValue = (AEQ_MIN * sF);

		XmScaleSetValue(gbParamsAEqScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_ACON:	/* the A channel conductance was edited */

		ACON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsAConScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (ACON_MAX * sF))
			scaleValue = (ACON_MAX * sF);
		else if (scaleValue < (ACON_MIN * sF))
			scaleValue = (ACON_MIN * sF);

		XmScaleSetValue(gbParamsAConScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_IREQ:	/* the IR channel equilibrium potential was edited */

		IREQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsIREqScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (IREQ_MAX * sF))
			scaleValue = (IREQ_MAX * sF);
		else if (scaleValue < (IREQ_MIN * sF))
			scaleValue = (IREQ_MIN * sF);

		XmScaleSetValue(gbParamsIREqScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_IRCON:	/* the IR channel conductance was edited */

		IRCON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsIRConScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (IRCON_MAX * sF))
			scaleValue = (IRCON_MAX * sF);
		else if (scaleValue < (IRCON_MIN * sF))
			scaleValue = (IRCON_MIN * sF);

		XmScaleSetValue(gbParamsIRConScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_PEQ:	/* the P channel equilibrium potential was edited */

		PEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsPEqScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (PEQ_MAX * sF))
			scaleValue = (PEQ_MAX * sF);
		else if (scaleValue < (PEQ_MIN * sF))
			scaleValue = (PEQ_MIN * sF);

		XmScaleSetValue(gbParamsPEqScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_PCON:	/* the P channel conductance was edited */

		PCON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsPConScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (PCON_MAX * sF))
			scaleValue = (PCON_MAX * sF);
		else if (scaleValue < (PCON_MIN * sF))
			scaleValue = (PCON_MIN * sF);

		XmScaleSetValue(gbParamsPConScale, scaleValue);
		break;

	case DIALOG_TEXT_CON:	/* the soma membrane conductance was edited */

		CONDUCTANCE = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronConductanceScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (CON_MAX * sF))
			scaleValue = (CON_MAX * sF);
		else if (scaleValue < (CON_MIN * sF))
			scaleValue = (CON_MIN * sF);

		XmScaleSetValue(editNeuronConductanceScale, scaleValue);
		break;

	case DIALOG_TEXT_LEAK:	/* the soma resting potential was edited */

		LEAK = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronLeakScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (LEAK_MAX * sF))
			scaleValue = (LEAK_MAX * sF);
		else if (scaleValue < (LEAK_MIN * sF))
			scaleValue = (LEAK_MIN * sF);

		XmScaleSetValue(editNeuronLeakScale, scaleValue);
		break;

	case DIALOG_TEXT_CAP:	/* the soma capacity was edited */

		CAP = number / C_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronCapacityScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (CAP_MAX * sF))
			scaleValue = (CAP_MAX * sF);
		else if (scaleValue < (CAP_MIN * sF))
			scaleValue = (CAP_MIN * sF);

		XmScaleSetValue(editNeuronCapacityScale, scaleValue);
		break;

	case DIALOG_TEXT_TOD:	/* the soma to dendrite conductance was edited */

		TOD = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronToDendritConductanceScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (TOD_MAX * sF))
			scaleValue = (TOD_MAX * sF);
		else if (scaleValue < (TOD_MIN * sF))
			scaleValue = (TOD_MIN * sF);

		XmScaleSetValue(editNeuronToDendritConductanceScale, scaleValue);
		break;

	case DIALOG_TEXT_POT:	/* the soma initial potential was edited */

		POTENTIAL = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronPotentialScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (POT_MAX * sF))
			scaleValue = (POT_MAX * sF);
		else if (scaleValue < (POT_MIN * sF))
			scaleValue = (POT_MIN * sF);

		XmScaleSetValue(editNeuronPotentialScale, scaleValue);
		break;

	case DIALOG_TEXT_DPOT:	/* the dendrite initial potential was edited */

		DPOT = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDPotentialScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (DPOT_MAX * sF))
			scaleValue = (DPOT_MAX * sF);
		else if (scaleValue < (DPOT_MIN * sF))
			scaleValue = (DPOT_MIN * sF);

		XmScaleSetValue(editNeuronDPotentialScale, scaleValue);
		break;

	case DIALOG_TEXT_DCON:	/* the dendrite conductance was edited */

		DCON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDConductanceScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (DCON_MAX * sF))
			scaleValue = (DCON_MAX * sF);
		else if (scaleValue < (DCON_MIN * sF))
			scaleValue = (DCON_MIN * sF);

		XmScaleSetValue(editNeuronDConductanceScale, scaleValue);
		break;

	case DIALOG_TEXT_DLEAK:	/* the dendrite resting potential was edited */

		DLEAK = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDLeakScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (DLEAK_MAX * sF))
			scaleValue = (DLEAK_MAX * sF);
		else if (scaleValue < (DLEAK_MIN * sF))
			scaleValue = (DLEAK_MIN * sF);

		XmScaleSetValue(editNeuronDLeakScale, scaleValue);
		break;

	case DIALOG_TEXT_DCAP:	/* the dendrite capacity was edited */

		DCAP = number / C_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDCapacityScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (DCAP_MAX * sF))
			scaleValue = (DCAP_MAX * sF);
		else if (scaleValue < (DCAP_MIN * sF))
			scaleValue = (DCAP_MIN * sF);

		XmScaleSetValue(editNeuronDCapacityScale, scaleValue);
		break;

	case DIALOG_TEXT_TOS:	/* the dendrite to soma conductance was edited */

		TOS = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronToSomaConductanceScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (TOS_MAX * sF))
			scaleValue = (TOS_MAX * sF);
		else if (scaleValue < (TOS_MIN * sF))
			scaleValue = (TOS_MIN * sF);

		XmScaleSetValue(editNeuronToSomaConductanceScale, scaleValue);
		break;

	case DIALOG_TEXT_TT:	/* the synaptic transmission time was edited */

		TT = number / T_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(addSynapseTTScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (TT_MAX * sF))
			scaleValue = (TT_MAX * sF);
		else if (scaleValue < (TT_MIN * sF))
			scaleValue = (TT_MIN * sF);

		XmScaleSetValue(addSynapseTTScale, scaleValue);
		break;

	case DIALOG_TEXT_STR:	/* the synaptic conductance was edited */

		STRENGTH = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(addSynapseStrScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (STR_MAX * sF))
			scaleValue = (STR_MAX * sF);
		else if (scaleValue < (STR_MIN * sF))
			scaleValue = (STR_MIN * sF);

		XmScaleSetValue(addSynapseStrScale, scaleValue);
		break;

	case DIALOG_TEXT_MAXSTR:	/* the maximal synaptic conductance was edited */

		MAXSTR = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(addSynapseMaxStrScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (MAXSTR_MAX * sF))
			scaleValue = (MAXSTR_MAX * sF);
		else if (scaleValue < (MAXSTR_MIN * sF))
			scaleValue = (MAXSTR_MIN * sF);

		XmScaleSetValue(addSynapseMaxStrScale, scaleValue);
		break;

	case DIALOG_TEXT_TRT:	/* the synaptic transmitter release treshold was edited */

		TRT = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(addSynapseTRTScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (TRT_MAX * sF))
			scaleValue = (TRT_MAX * sF);
		else if (scaleValue < (TRT_MIN * sF))
			scaleValue = (TRT_MIN * sF);

		XmScaleSetValue(addSynapseTRTScale, scaleValue);
		break;

	case DIALOG_TEXT_TRS:	/* the synaptic transmitter release satiate was edited */

		TRS = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(addSynapseTRSScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (TRS_MAX * sF))
			scaleValue = (TRS_MAX * sF);
		else if (scaleValue < (TRS_MIN * sF))
			scaleValue = (TRS_MIN * sF);

		XmScaleSetValue(addSynapseTRSScale, scaleValue);
		break;

	case DIALOG_TEXT_TARGET:	/* the synaptic location was edited */

		LOC = atoi(value);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(addSynapseTargetScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = LOC * sF;

		if (scaleValue > (curNumOfDendSegs * sF))
			scaleValue = (curNumOfDendSegs * sF);
		else if (scaleValue < (TARGET_MIN * sF))
			scaleValue = (TARGET_MIN * sF);

		XmScaleSetValue(addSynapseTargetScale, scaleValue);
		XmScaleSetValue(editSynapseLocationScale, scaleValue);

		/* show synaptic connections in edit synapse list */

		show_synaptic_connections();
		break;

	case DIALOG_TEXT_LOCATION:	/* the synaptic location was edited */

		LOC = atoi(value);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editSynapseLocationScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = LOC * sF;

		if (scaleValue > (curNumOfDendSegs * sF))
			scaleValue = (curNumOfDendSegs * sF);
		else if (scaleValue < (TARGET_MIN * sF))
			scaleValue = (TARGET_MIN * sF);

		XmScaleSetValue(editSynapseLocationScale, scaleValue);

		/* show synaptic connections in edit synapse list */

		show_synaptic_connections();
		break;

	case DIALOG_TEXT_REGION:	/* the current location was edited */

		REG = atoi(value);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentLocationScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = REG * sF;

		if (scaleValue > (curNumOfDendSegs * sF))
			scaleValue = (curNumOfDendSegs * sF);
		else if (scaleValue < (TARGET_MIN * sF))
			scaleValue = (TARGET_MIN * sF);

		XmScaleSetValue(editCurrentLocationScale, scaleValue);
		break;

	case DIALOG_TEXT_DSTART:	/* the external dendritic current start time was edited */

		DSTART = number / T_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentDendritStartScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (LTSTOP * T_SCALE * sF))
			scaleValue = (LTSTOP * T_SCALE * sF);
		else if (scaleValue < (DSTART_MIN * sF))
			scaleValue = (DSTART_MIN * sF);

		XmScaleSetValue(editCurrentDendritStartScale, scaleValue);
		break;

	case DIALOG_TEXT_DEND:	/* the external dendritic current end time was edited */

		DEND = number / T_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentDendritEndScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (LTSTOP * T_SCALE * sF))
			scaleValue = (LTSTOP * T_SCALE * sF);
		else if (scaleValue < (DEND_MIN * sF))
			scaleValue = (DEND_MIN * sF);

		XmScaleSetValue(editCurrentDendritEndScale, scaleValue);
		break;

	case DIALOG_TEXT_DCUR:	/* the external dendritic current was edited */

		DCUR = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentDendritCurrentScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (DCUR_MAX * sF))
			scaleValue = (DCUR_MAX * sF);
		else if (scaleValue < (DCUR_MIN * sF))
			scaleValue = (DCUR_MIN * sF);

		XmScaleSetValue(editCurrentDendritCurrentScale, scaleValue);
		break;

	case DIALOG_TEXT_SSTART:	/* the external soma current start time was edited */

		SSTART = number / T_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentSomaStartScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (LTSTOP * T_SCALE * sF))
			scaleValue = (LTSTOP * T_SCALE * sF);
		else if (scaleValue < (SSTART_MIN * sF))
			scaleValue = (SSTART_MIN * sF);

		XmScaleSetValue(editCurrentSomaStartScale, scaleValue);
		break;

	case DIALOG_TEXT_SEND:	/* the external soma current end time was edited */

		SEND = number / T_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentSomaEndScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (LTSTOP * T_SCALE * sF))
			scaleValue = (LTSTOP * T_SCALE * sF);
		else if (scaleValue < (SEND_MIN * sF))
			scaleValue = (SEND_MIN * sF);

		XmScaleSetValue(editCurrentSomaEndScale, scaleValue);
		break;

	case DIALOG_TEXT_SCUR:	/* the external soma current was edited */

		SCUR = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentSomaCurrentScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (SCUR_MAX * sF))
			scaleValue = (SCUR_MAX * sF);
		else if (scaleValue < (SCUR_MIN * sF))
			scaleValue = (SCUR_MIN * sF);

		XmScaleSetValue(editCurrentSomaCurrentScale, scaleValue);
		break;

	case DIALOG_TEXT_SIMLEN:	/* the simulation length was edited */

		SIMLEN = number / T_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editSimParsSimLenScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue < (SIMLEN_MIN * sF))
			scaleValue = (SIMLEN_MIN * sF);

		XmScaleSetValue(editSimParsSimLenScale, scaleValue);
		break;

	case DIALOG_TEXT_SIMSIZE:	/* the simulation step size was edited */

		SIMSIZE = number / T_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editSimParsStepSizeScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (SIMSIZE_MAX * sF))
			scaleValue = (SIMSIZE_MAX * sF);
		else if (scaleValue < (SIMSIZE_MIN * sF))
			scaleValue = (SIMSIZE_MIN * sF);

		XmScaleSetValue(editSimParsStepSizeScale, scaleValue);
		break;

	case DIALOG_TEXT_NACTINT:	/* the neuron activity interval was edited */

		NACTINT = (int) rint(number);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(neuronActivityIntervalScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (NACTINT_MAX * sF))
			scaleValue = (NACTINT_MAX * sF);
		else if (scaleValue < (NACTINT_MIN * sF))
			scaleValue = (NACTINT_MIN * sF);

		XmScaleSetValue(neuronActivityIntervalScale, scaleValue);
		break;

	case DIALOG_TEXT_SEQ:	/* the equilibrium potential of a new synaptic type was edited */

		SEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newSTypeEqPotScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (SEQ_MAX * sF))
			scaleValue = (SEQ_MAX * sF);
		else if (scaleValue < (SEQ_MIN * sF))
			scaleValue = (SEQ_MIN * sF);

		XmScaleSetValue(newSTypeEqPotScale, scaleValue);
		break;

	case DIALOG_TEXT_ONOFF_NAEQ:	/* the sodium channel equilibrium potential in the On/Off-model was edited */

		NAEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsNaEqPotScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (NAEQ_MAX * sF))
			scaleValue = (NAEQ_MAX * sF);
		else if (scaleValue < (NAEQ_MIN * sF))
			scaleValue = (NAEQ_MIN * sF);

		XmScaleSetValue(onOffParamsNaEqPotScale, scaleValue);
		break;

	case DIALOG_TEXT_ONOFF_NACON:	/* the sodium channel conductance in the On/Off-model was edited */

		NACON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsNaConductanceScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (NACON_MAX * sF))
			scaleValue = (NACON_MAX * sF);
		else if (scaleValue < (NACON_MIN * sF))
			scaleValue = (NACON_MIN * sF);

		XmScaleSetValue(onOffParamsNaConductanceScale, scaleValue);
		break;

	case DIALOG_TEXT_ONOFF_NADUR:	/* the sodium channel opening duration in the On/Off-model was edited */

		NADUR = number / T_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsNaDurScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (NADUR_MAX * sF))
			scaleValue = (NADUR_MAX * sF);
		else if (scaleValue < (NADUR_MIN * sF))
			scaleValue = (NADUR_MIN * sF);

		XmScaleSetValue(onOffParamsNaDurScale, scaleValue);
		break;

	case DIALOG_TEXT_ONOFF_KEQ:	/* the potassium channel equilibrium potential in the On/Off-model was edited */

		KEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsKEqPotScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (KEQ_MAX * sF))
			scaleValue = (KEQ_MAX * sF);
		else if (scaleValue < (KEQ_MIN * sF))
			scaleValue = (KEQ_MIN * sF);

		XmScaleSetValue(onOffParamsKEqPotScale, scaleValue);
		break;

	case DIALOG_TEXT_ONOFF_KCON:	/* the potassium channel conductance in the On/Off-model was edited */

		KCON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsKConductanceScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (KCON_MAX * sF))
			scaleValue = (KCON_MAX * sF);
		else if (scaleValue < (KCON_MIN * sF))
			scaleValue = (KCON_MIN * sF);

		XmScaleSetValue(onOffParamsKConductanceScale, scaleValue);
		break;

	case DIALOG_TEXT_ONOFF_KSTART:	/* the potassium channel start time in the On/Off-model was edited */

		KSTART = number / T_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsKStartScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (KSTART_MAX * sF))
			scaleValue = (KSTART_MAX * sF);
		else if (scaleValue < (KSTART_MIN * sF))
			scaleValue = (KSTART_MIN * sF);

		XmScaleSetValue(onOffParamsKStartScale, scaleValue);
		break;

	case DIALOG_TEXT_ONOFF_KDUR:	/* the potassium channel opening duration in the On/Off-model was edited */

		KDUR = number / T_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsKDurScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (KDUR_MAX * sF))
			scaleValue = (KDUR_MAX * sF);
		else if (scaleValue < (KDUR_MIN * sF))
			scaleValue = (KDUR_MIN * sF);

		XmScaleSetValue(onOffParamsKDurScale, scaleValue);
		break;

	case DIALOG_TEXT_ONOFF_CAEQ:	/* the calcium channel equilibrium potential in the On/Off-model was edited */

		CAEQ = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsCaEqPotScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (CAEQ_MAX * sF))
			scaleValue = (CAEQ_MAX * sF);
		else if (scaleValue < (CAEQ_MIN * sF))
			scaleValue = (CAEQ_MIN * sF);

		XmScaleSetValue(onOffParamsCaEqPotScale, scaleValue);
		break;

	case DIALOG_TEXT_ONOFF_CACON:	/* the calcium channel conductance in the On/Off-model was edited */

		CACON = number / S_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsCaConductanceScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (CACON_MAX * sF))
			scaleValue = (CACON_MAX * sF);
		else if (scaleValue < (CACON_MIN * sF))
			scaleValue = (CACON_MIN * sF);

		XmScaleSetValue(onOffParamsCaConductanceScale, scaleValue);
		break;

	case DIALOG_TEXT_ONOFF_CASTART:	/* the calcium channel start time in the On/Off-model was edited */

		CASTART = number / T_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsCaStartScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (CASTART_MAX * sF))
			scaleValue = (CASTART_MAX * sF);
		else if (scaleValue < (CASTART_MIN * sF))
			scaleValue = (CASTART_MIN * sF);

		XmScaleSetValue(onOffParamsCaStartScale, scaleValue);
		break;

	case DIALOG_TEXT_ONOFF_CADUR:	/* the calcium channel opening duration in the On/Off-model was edited */

		CADUR = number / T_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsCaDurScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (CADUR_MAX * sF))
			scaleValue = (CADUR_MAX * sF);
		else if (scaleValue < (CADUR_MIN * sF))
			scaleValue = (CADUR_MIN * sF);

		XmScaleSetValue(onOffParamsCaDurScale, scaleValue);
		break;

	case DIALOG_TEXT_ONOFF_STH:	/* the spike threshold in the On/Off-model was edited */

		STH = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsSpikeThresholdScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (STH_MAX * sF))
			scaleValue = (STH_MAX * sF);
		else if (scaleValue < (STH_MIN * sF))
			scaleValue = (STH_MIN * sF);

		XmScaleSetValue(onOffParamsSpikeThresholdScale, scaleValue);
		break;

	case DIALOG_TEXT_SWIM_STH:	/* the spike threshold in the SWIM-model was edited */

		STH = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsSpikeThresholdScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (STH_MAX * sF))
			scaleValue = (STH_MAX * sF);
		else if (scaleValue < (STH_MIN * sF))
			scaleValue = (STH_MIN * sF);

		XmScaleSetValue(swimParamsSpikeThresholdScale, scaleValue);
		break;

	case DIALOG_TEXT_HH_STH:	/* the spike threshold in the HH-model was edited */

		STH = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(hhParamsSpikeThresholdScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (STH_MAX * sF))
			scaleValue = (STH_MAX * sF);
		else if (scaleValue < (STH_MIN * sF))
			scaleValue = (STH_MIN * sF);

		XmScaleSetValue(hhParamsSpikeThresholdScale, scaleValue);
		break;

	case DIALOG_TEXT_GB_STH:	/* the spike threshold in the GB-model was edited */

		STH = number / E_SCALE;

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsSpikeThresholdScale, args, n);

		sF = (int) pow((double) 10, (double) decimals);
		scaleValue = (int) number * sF;

		if (scaleValue > (STH_MAX * sF))
			scaleValue = (STH_MAX * sF);
		else if (scaleValue < (STH_MIN * sF))
			scaleValue = (STH_MIN * sF);

		XmScaleSetValue(gbParamsSpikeThresholdScale, scaleValue);
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in DIALOG_TEXT occured !\n");
		break;
	}

	free(value);

} /* end of dialog_text2_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_scale2_CB(w, client_data, call_data)
 
	PURPOSE		: callback for scale widgets

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_scale2_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	Arg		args[20];	/* argument list for manipulating widgets */
	Cardinal 	n;		/* used as argument counter for manipulating widgets */
	int		value;		/* value of the scale widget */
	short int 	decimals;	/* number of decimals for scale widget */
	double		number;		/* number of scale value */
	char		text[20];	/* text representation of number */

	/* set text value dependend on the widget from which it comes */

	n = 0;
	XtSetArg(args[n], XmNvalue, &value); n++;
	XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
	XtGetValues(w, args, n);

	number = (double) value / pow((double) 10, (double) decimals);
	sprintf(text,"%f", number);

	switch((int) client_data)
	{
	case DIALOG_SCALE_SWIM_NAEQ:		/* the sodium channel equilibrium potential was edited */

		XmTextSetString(swimParamsNaEqText, text);
		break;

	case DIALOG_SCALE_SWIM_NACON:	/* the sodium channel conductance was edited */

		XmTextSetString(swimParamsNaConText, text);
		break;

	case DIALOG_SCALE_SWIM_KEQ:		/* the potassium channel equilibrium potential was edited */

		XmTextSetString(swimParamsKEqText, text);
		break;

	case DIALOG_SCALE_SWIM_KCON:		/* the potassium channel conductance was edited */

		XmTextSetString(swimParamsKConText, text);
		break;

	case DIALOG_SCALE_SWIM_CAEQ:		/* the calcium channel equilibrium potential was edited */

		XmTextSetString(swimParamsCaEqText, text);
		break;

	case DIALOG_SCALE_SWIM_CACON:	/* the calcium channel conductance was edited */

		XmTextSetString(swimParamsCaConText, text);
		break;

	case DIALOG_SCALE_HH_NAEQ:		/* the sodium channel equilibrium potential was edited */

		XmTextSetString(hhParamsNaEqText, text);
		break;

	case DIALOG_SCALE_HH_NACON:	/* the sodium channel conductance was edited */

		XmTextSetString(hhParamsNaConText, text);
		break;

	case DIALOG_SCALE_HH_KEQ:		/* the potassium channel equilibrium potential was edited */

		XmTextSetString(hhParamsKEqText, text);
		break;

	case DIALOG_SCALE_HH_KCON:		/* the potassium channel conductance was edited */

		XmTextSetString(hhParamsKConText, text);
		break;

	case DIALOG_SCALE_GB_NAEQ:		/* the sodium channel equilibrium potential was edited */

		XmTextSetString(gbParamsNaEqText, text);
		break;

	case DIALOG_SCALE_GB_NACON:	/* the sodium channel conductance was edited */

		XmTextSetString(gbParamsNaConText, text);
		break;

	case DIALOG_SCALE_GB_KEQ:		/* the potassium channel equilibrium potential was edited */

		XmTextSetString(gbParamsKEqText, text);
		break;

	case DIALOG_SCALE_GB_KCON:		/* the potassium channel conductance was edited */

		XmTextSetString(gbParamsKConText, text);
		break;

	case DIALOG_SCALE_GB_CA1CON:		/* the first calcium channel conductance was edited */

		XmTextSetString(gbParamsCa1ConText, text);
		break;

	case DIALOG_SCALE_GB_CA2CON:		/* the second calcium channel conductance was edited */

		XmTextSetString(gbParamsCa2ConText, text);
		break;

	case DIALOG_SCALE_GB_KCAEQ:		/* the potassium dependend Ca-channel equilibrium potential was edited */

		XmTextSetString(gbParamsKCAEqText, text);
		break;

	case DIALOG_SCALE_GB_KCACON:		/* the potassium dependend Ca-channel conductance was edited */

		XmTextSetString(gbParamsKCAConText, text);
		break;

	case DIALOG_SCALE_GB_AEQ:		/* the A channel equilibrium potential was edited */

		XmTextSetString(gbParamsAEqText, text);
		break;

	case DIALOG_SCALE_GB_ACON:		/* the A channel conductance was edited */

		XmTextSetString(gbParamsAConText, text);
		break;

	case DIALOG_SCALE_GB_IREQ:		/* the IR channel equilibrium potential was edited */

		XmTextSetString(gbParamsIREqText, text);
		break;

	case DIALOG_SCALE_GB_IRCON:		/* the IR channel conductance was edited */

		XmTextSetString(gbParamsIRConText, text);
		break;

	case DIALOG_SCALE_GB_PEQ:		/* the P channel equilibrium potential was edited */

		XmTextSetString(gbParamsPEqText, text);
		break;

	case DIALOG_SCALE_GB_PCON:		/* the P channel conductance was edited */

		XmTextSetString(gbParamsPConText, text);
		break;

	case DIALOG_SCALE_CON:		/* the soma membrane conductance was edited */

		XmTextSetString(editNeuronConductanceText, text);
		break;

	case DIALOG_SCALE_LEAK:		/* the soma resting potential was edited */

		XmTextSetString(editNeuronLeakText, text);
		break;

	case DIALOG_SCALE_CAP:		/* the soma capacity was edited */

		XmTextSetString(editNeuronCapacityText, text);
		break;

	case DIALOG_SCALE_TOD:		/* the soma to dendrite conductance was edited */

		XmTextSetString(editNeuronToDendritConductanceText, text);
		break;

	case DIALOG_SCALE_POT:		/* the soma initial potential was edited */

		XmTextSetString(editNeuronPotentialText, text);
		break;

	case DIALOG_SCALE_DPOT:		/* the dendrite initial potential was edited */

		XmTextSetString(editNeuronDPotentialText, text);
		break;

	case DIALOG_SCALE_DCON:		/* the dendrite conductance was edited */

		XmTextSetString(editNeuronDConductanceText, text);
		break;

	case DIALOG_SCALE_DLEAK:	/* the dendrite resting potential was edited */

		XmTextSetString(editNeuronDLeakText, text);
		break;

	case DIALOG_SCALE_DCAP:		/* the dendrite capacity was edited */

		XmTextSetString(editNeuronDCapacityText, text);
		break;

	case DIALOG_SCALE_TOS:		/* the dendrite to soma conductance was edited */

		XmTextSetString(editNeuronToSomaConductanceText, text);
		break;

	case DIALOG_SCALE_TT:		/* the synaptic transmission time was edited */

		XmTextSetString(addSynapseTTText, text);
		break;

	case DIALOG_SCALE_STR:		/* the synaptic conductance was edited */

		XmTextSetString(addSynapseStrText, text);
		break;

	case DIALOG_SCALE_MAXSTR:	/* the maximal synaptic conductance was edited */

		XmTextSetString(addSynapseMaxStrText, text);
		break;

	case DIALOG_SCALE_TRT:		/* the synaptic transmitter release treshold was edited */

		XmTextSetString(addSynapseTRTText, text);
		break;

	case DIALOG_SCALE_TRS:		/* the synaptic transmitter release satiate was edited */

		XmTextSetString(addSynapseTRSText, text);
		break;

	case DIALOG_SCALE_TARGET:	/* the synaptic location was edited */

		XmTextSetString(addSynapseTargetText, text);
		XmTextSetString(editSynapseLocationText, text);
		XmScaleSetValue(editSynapseLocationScale, atoi(text));

		/* show synaptic connections in edit synapse list */

		LOC = (int) number;
		show_synaptic_connections();
		break;

	case DIALOG_SCALE_LOCATION:	/* the synaptic location was edited */

		XmTextSetString(editSynapseLocationText, text);

		/* show synaptic connections in edit synapse list */

		LOC = (int) number;
		show_synaptic_connections();
		break;

	case DIALOG_SCALE_REGION:	/* the current location was edited */

		XmTextSetString(editCurrentLocationText, text);
		REG = (int) number;
		break;

	case DIALOG_SCALE_SCUR:		/* the external soma current was edited */

		XmTextSetString(editCurrentSomaCurrentText, text);
		break;

	case DIALOG_SCALE_SSTART:	/* the external soma current start time was edited */

		XmTextSetString(editCurrentSomaStartText, text);
		break;

	case DIALOG_SCALE_SEND:		/* the external soma current end time was edited */

		XmTextSetString(editCurrentSomaEndText, text);
		break;

	case DIALOG_SCALE_DCUR:		/* the external dendritic current was edited */

		XmTextSetString(editCurrentDendritCurrentText, text);
		break;

	case DIALOG_SCALE_DSTART:	/* the external dendritic current start time was edited */

		XmTextSetString(editCurrentDendritStartText, text);
		break;

	case DIALOG_SCALE_DEND:		/* the external dendritic current end time was edited */

		XmTextSetString(editCurrentDendritEndText, text);
		break;

	case DIALOG_SCALE_SIMLEN:	/* the simulation length was edited */

		XmTextSetString(editSimParsSimLenText, text);
		break;

	case DIALOG_SCALE_SIMSIZE:	/* the simulation step size was edited */

		XmTextSetString(editSimParsStepSizeText, text);
		break;

	case DIALOG_SCALE_NACTINT:	/* the neuron activity interval was edited */

		XmTextSetString(neuronActivityIntervalText, text);
		break;

	case DIALOG_SCALE_SEQ:		/* the equilibrium potential of a new synaptic type was edited */

		XmTextSetString(newSTypeEqPotText, text);
		break;

	case DIALOG_SCALE_ONOFF_NAEQ:	/* the sodium channel equilibrium potential in the On/Off-model was edited */

		XmTextSetString(onOffParamsNaEqPotText, text);
		break;

	case DIALOG_SCALE_ONOFF_NACON:	/* the sodium channel conductance in the On/Off-model was edited */

		XmTextSetString(onOffParamsNaConductanceText, text);
		break;

	case DIALOG_SCALE_ONOFF_NADUR:	/* the sodium channel opening duration in the On/Off-model was edited */

		XmTextSetString(onOffParamsNaDurText, text);
		break;

	case DIALOG_SCALE_ONOFF_KEQ:	/* the potassium channel equilibrium potential in the On/Off-model was edited */

		XmTextSetString(onOffParamsKEqPotText, text);
		break;

	case DIALOG_SCALE_ONOFF_KCON:	/* the potassium channel conductance in the On/Off-model was edited */

		XmTextSetString(onOffParamsKConductanceText, text);
		break;

	case DIALOG_SCALE_ONOFF_KSTART:	/* the potassium channel start time in the On/Off-model was edited */

		XmTextSetString(onOffParamsKStartText, text);
		break;

	case DIALOG_SCALE_ONOFF_KDUR:	/* the potassium channel opening duration in the On/Off-model was edited */

		XmTextSetString(onOffParamsKDurText, text);
		break;

	case DIALOG_SCALE_ONOFF_CAEQ:	/* the calcium channel equilibrium potential in the On/Off-model was edited */

		XmTextSetString(onOffParamsCaEqPotText, text);
		break;

	case DIALOG_SCALE_ONOFF_CACON:	/* the calcium channel conductance in the On/Off-model was edited */

		XmTextSetString(onOffParamsCaConductanceText, text);
		break;

	case DIALOG_SCALE_ONOFF_CASTART: /* the calcium channel start time in the On/Off-model was edited */

		XmTextSetString(onOffParamsCaStartText, text);
		break;

	case DIALOG_SCALE_ONOFF_CADUR:	/* the calcium channel opening duration in the On/Off-model was edited */

		XmTextSetString(onOffParamsCaDurText, text);
		break;

	case DIALOG_SCALE_ONOFF_STH:	/* the spike threshold in the On/Off-model was edited */

		XmTextSetString(onOffParamsSpikeThresholdText, text);
		break;

	case DIALOG_SCALE_SWIM_STH:	/* the spike threshold in the SWIM-model was edited */

		XmTextSetString(swimParamsSpikeThresholdText, text);
		break;

	case DIALOG_SCALE_HH_STH:	/* the spike threshold in the HH-model was edited */

		XmTextSetString(hhParamsSpikeThresholdText, text);
		break;

	case DIALOG_SCALE_GB_STH:	/* the spike threshold in the GB-model was edited */

		XmTextSetString(gbParamsSpikeThresholdText, text);
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in DIALOG_SCALE occured !\n");
		break;
	}

} /* end of dialog_scale2_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_def2_CB(w, client_data, call_data)
 
	PURPOSE		: callback for default buttons

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_def2_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	Arg		args[20];	/* argument list for manipulating widgets */
	Cardinal	n;		/* used as argument counter for manipulating widgets */
	short int 	decimals;	/* number of decimals for scale widget */
	char		text[20];	/* text representation of number */

	/* set text and scale value dependend on the widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_DEF_CON:	/* the soma membrane conductance is reset to default */

		switch(networkmodel)
		{
		case 1:	/* ONOFF model */
			sprintf(text,"%f", (double) CON_ONOFF_DEF);
			XmTextSetString(editNeuronConductanceText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronConductanceScale, args, n);
			XmScaleSetValue(editNeuronConductanceScale,
				(int) (CON_ONOFF_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 2:	/* SWIM model */
			sprintf(text,"%f", (double) CON_SWIM_DEF);
			XmTextSetString(editNeuronConductanceText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronConductanceScale, args, n);
			XmScaleSetValue(editNeuronConductanceScale,
				(int) (CON_SWIM_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 3:	/* HH model */
			sprintf(text,"%f", (double) CON_HH_DEF);
			XmTextSetString(editNeuronConductanceText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronConductanceScale, args, n);
			XmScaleSetValue(editNeuronConductanceScale,
				(int) (CON_HH_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 4:	/* GB model */
			sprintf(text,"%f", (double) CON_GB_DEF);
			XmTextSetString(editNeuronConductanceText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronConductanceScale, args, n);
			XmScaleSetValue(editNeuronConductanceScale,
				(int) (CON_GB_DEF * pow((double) 10, (double) decimals)));
			break;
		}

		break;

	case DIALOG_DEF_LEAK:	/* the soma resting potential is reset to default */

		switch(networkmodel)
		{
		case 1:	/* ONOFF model */
			sprintf(text,"%f", (double) LEAK_ONOFF_DEF);
			XmTextSetString(editNeuronLeakText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronLeakScale, args, n);
			XmScaleSetValue(editNeuronLeakScale,
				(int) (LEAK_ONOFF_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 2:	/* SWIM model */
			sprintf(text,"%f", (double) LEAK_SWIM_DEF);
			XmTextSetString(editNeuronLeakText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronLeakScale, args, n);
			XmScaleSetValue(editNeuronLeakScale,
				(int) (LEAK_SWIM_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 3:	/* HH model */
			sprintf(text,"%f", (double) LEAK_HH_DEF);
			XmTextSetString(editNeuronLeakText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronLeakScale, args, n);
			XmScaleSetValue(editNeuronLeakScale,
				(int) (LEAK_HH_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 4:	/* GB model */
			sprintf(text,"%f", (double) LEAK_GB_DEF);
			XmTextSetString(editNeuronLeakText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronLeakScale, args, n);
			XmScaleSetValue(editNeuronLeakScale,
				(int) (LEAK_GB_DEF * pow((double) 10, (double) decimals)));
			break;
		}

		break;

	case DIALOG_DEF_CAP:	/* the soma capacity is reset to default */

		switch(networkmodel)
		{
		case 1:	/* ONOFF model */
			sprintf(text,"%f", (double) CAP_ONOFF_DEF);
			XmTextSetString(editNeuronCapacityText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronCapacityScale, args, n);
			XmScaleSetValue(editNeuronCapacityScale,
				(int) (CAP_ONOFF_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 2:	/* SWIM model */
			sprintf(text,"%f", (double) CAP_SWIM_DEF);
			XmTextSetString(editNeuronCapacityText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronCapacityScale, args, n);
			XmScaleSetValue(editNeuronCapacityScale,
				(int) (CAP_SWIM_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 3:	/* HH model */
			sprintf(text,"%f", (double) CAP_HH_DEF);
			XmTextSetString(editNeuronCapacityText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronCapacityScale, args, n);
			XmScaleSetValue(editNeuronCapacityScale,
				(int) (CAP_HH_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 4:	/* GB model */
			sprintf(text,"%f", (double) CAP_GB_DEF);
			XmTextSetString(editNeuronCapacityText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronCapacityScale, args, n);
			XmScaleSetValue(editNeuronCapacityScale,
				(int) (CAP_GB_DEF * pow((double) 10, (double) decimals)));
			break;
		}

		break;

	case DIALOG_DEF_POT:	/* the soma initial potential is reset to default */

		switch(networkmodel)
		{
		case 1:	/* ONOFF model */
			sprintf(text,"%f", (double) POT_ONOFF_DEF);
			XmTextSetString(editNeuronPotentialText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronPotentialScale, args, n);
			XmScaleSetValue(editNeuronPotentialScale,
				(int) (POT_ONOFF_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 2:	/* SWIM model */
			sprintf(text,"%f", (double) POT_SWIM_DEF);
			XmTextSetString(editNeuronPotentialText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronPotentialScale, args, n);
			XmScaleSetValue(editNeuronPotentialScale,
				(int) (POT_SWIM_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 3:	/* HH model */
			sprintf(text,"%f", (double) POT_HH_DEF);
			XmTextSetString(editNeuronPotentialText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronPotentialScale, args, n);
			XmScaleSetValue(editNeuronPotentialScale,
				(int) (POT_HH_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 4:	/* GB model */
			sprintf(text,"%f", (double) POT_GB_DEF);
			XmTextSetString(editNeuronPotentialText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronPotentialScale, args, n);
			XmScaleSetValue(editNeuronPotentialScale,
				(int) (POT_GB_DEF * pow((double) 10, (double) decimals)));
			break;
		}

		break;

	case DIALOG_DEF_TOD:	/* the soma to dendrite conductance is reset to default */

		sprintf(text,"%f", (double) TOD_DEF);
		XmTextSetString(editNeuronToDendritConductanceText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronToDendritConductanceScale, args, n);
		XmScaleSetValue(editNeuronToDendritConductanceScale,
			(int) (TOD_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_DCON:	/* the dendrite conductance is reset to default */

		sprintf(text,"%f", (double) DCON_DEF);
		XmTextSetString(editNeuronDConductanceText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDConductanceScale, args, n);
		XmScaleSetValue(editNeuronDConductanceScale, (int) (DCON_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_DLEAK:	/* the dendrite resting potential is reset to default */

		switch(networkmodel)
		{
		case 1:	/* ONOFF model */
			sprintf(text,"%f", (double) DLEAK_ONOFF_DEF);
			XmTextSetString(editNeuronDLeakText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronDLeakScale, args, n);
			XmScaleSetValue(editNeuronDLeakScale,
				(int) (DLEAK_ONOFF_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 2:	/* SWIM model */
			sprintf(text,"%f", (double) DLEAK_SWIM_DEF);
			XmTextSetString(editNeuronDLeakText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronDLeakScale, args, n);
			XmScaleSetValue(editNeuronDLeakScale,
				(int) (DLEAK_SWIM_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 3:	/* HH model */
			sprintf(text,"%f", (double) DLEAK_HH_DEF);
			XmTextSetString(editNeuronDLeakText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronDLeakScale, args, n);
			XmScaleSetValue(editNeuronDLeakScale,
				(int) (DLEAK_HH_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 4:	/* GB model */
			sprintf(text,"%f", (double) DLEAK_GB_DEF);
			XmTextSetString(editNeuronDLeakText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronDLeakScale, args, n);
			XmScaleSetValue(editNeuronDLeakScale,
				(int) (DLEAK_GB_DEF * pow((double) 10, (double) decimals)));
			break;
		}

		break;

	case DIALOG_DEF_DCAP:	/* the dendrite capacity is reset to default */

		sprintf(text,"%f", (double) DCAP_DEF);
		XmTextSetString(editNeuronDCapacityText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronDCapacityScale, args, n);
		XmScaleSetValue(editNeuronDCapacityScale,
			(int) (DCAP_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_DPOT:	/* the dendrite initial potential is reset to default */

		switch(networkmodel)
		{
		case 1:	/* ONOFF model */
			sprintf(text,"%f", (double) DPOT_ONOFF_DEF);
			XmTextSetString(editNeuronDPotentialText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronDPotentialScale, args, n);
			XmScaleSetValue(editNeuronDPotentialScale,
				(int) (DPOT_ONOFF_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 2:	/* SWIM model */
			sprintf(text,"%f", (double) DPOT_SWIM_DEF);
			XmTextSetString(editNeuronDPotentialText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronDPotentialScale, args, n);
			XmScaleSetValue(editNeuronDPotentialScale,
				(int) (DPOT_SWIM_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 3:	/* HH model */
			sprintf(text,"%f", (double) DPOT_HH_DEF);
			XmTextSetString(editNeuronDPotentialText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronDPotentialScale, args, n);
			XmScaleSetValue(editNeuronDPotentialScale,
				(int) (DPOT_HH_DEF * pow((double) 10, (double) decimals)));
			break;
		
		case 4:	/* GB model */
			sprintf(text,"%f", (double) DPOT_GB_DEF);
			XmTextSetString(editNeuronDPotentialText, text);

			n = 0;
			XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
			XtGetValues(editNeuronDPotentialScale, args, n);
			XmScaleSetValue(editNeuronDPotentialScale,
				(int) (DPOT_GB_DEF * pow((double) 10, (double) decimals)));
			break;
		}

		break;

	case DIALOG_DEF_TOS:	/* the dendrite to soma conductance is reset to default */

		sprintf(text,"%f", (double) TOS_DEF);
		XmTextSetString(editNeuronToSomaConductanceText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editNeuronToSomaConductanceScale, args, n);
		XmScaleSetValue(editNeuronToSomaConductanceScale, (int) (TOS_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_SWIM_NAEQ:	/* the sodium channel equilibrium potential is reset to default */

		sprintf(text,"%f", (double) NAEQ_SWIM_DEF);
		XmTextSetString(swimParamsNaEqText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsNaEqScale, args, n);
		XmScaleSetValue(swimParamsNaEqScale, (int) (NAEQ_SWIM_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_SWIM_NACON:	/* the sodium channel conductance is reset to default */

		sprintf(text,"%f", (double) NACON_SWIM_DEF);
		XmTextSetString(swimParamsNaConText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsNaConScale, args, n);
		XmScaleSetValue(swimParamsNaConScale, (int) (NACON_SWIM_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_SWIM_KEQ:	/* the potassium channel equilibrium potential is reset to default */

		sprintf(text,"%f", (double) KEQ_SWIM_DEF);
		XmTextSetString(swimParamsKEqText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsKEqScale, args, n);
		XmScaleSetValue(swimParamsKEqScale, (int) (KEQ_SWIM_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_SWIM_KCON:	/* the potassium channel conductance is reset to default */

		sprintf(text,"%f", (double) KCON_SWIM_DEF);
		XmTextSetString(swimParamsKConText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsKConScale, args, n);
		XmScaleSetValue(swimParamsKConScale, (int) (KCON_SWIM_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_SWIM_CAEQ:	/* the calcium channel equilibrium potential is reset to default */

		sprintf(text,"%f", (double) CAEQ_SWIM_DEF);
		XmTextSetString(swimParamsCaEqText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsCaEqScale, args, n);
		XmScaleSetValue(swimParamsCaEqScale, (int) (CAEQ_SWIM_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_SWIM_CACON:	/* the calcium channel conductance is reset to default */

		sprintf(text,"%f", (double) CACON_SWIM_DEF);
		XmTextSetString(swimParamsCaConText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsCaConScale, args, n);
		XmScaleSetValue(swimParamsCaConScale, (int) (CACON_SWIM_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_HH_NAEQ:	/* the sodium channel equilibrium potential is reset to default */

		sprintf(text,"%f", (double) NAEQ_HH_DEF);
		XmTextSetString(hhParamsNaEqText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(hhParamsNaEqScale, args, n);
		XmScaleSetValue(hhParamsNaEqScale, (int) (NAEQ_HH_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_HH_NACON:	/* the sodium channel conductance is reset to default */

		sprintf(text,"%f", (double) NACON_HH_DEF);
		XmTextSetString(hhParamsNaConText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(hhParamsNaConScale, args, n);
		XmScaleSetValue(hhParamsNaConScale, (int) (NACON_HH_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_HH_KEQ:	/* the potassium channel equilibrium potential is reset to default */

		sprintf(text,"%f", (double) KEQ_HH_DEF);
		XmTextSetString(hhParamsKEqText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(hhParamsKEqScale, args, n);
		XmScaleSetValue(hhParamsKEqScale, (int) (KEQ_HH_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_HH_KCON:	/* the potassium channel conductance is reset to default */

		sprintf(text,"%f", (double) KCON_HH_DEF);
		XmTextSetString(hhParamsKConText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(hhParamsKConScale, args, n);
		XmScaleSetValue(hhParamsKConScale, (int) (KCON_HH_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_NAEQ:	/* the sodium channel equilibrium potential is reset to default */

		sprintf(text,"%f", (double) NAEQ_GB_DEF);
		XmTextSetString(gbParamsNaEqText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsNaEqScale, args, n);
		XmScaleSetValue(gbParamsNaEqScale, (int) (NAEQ_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_NACON:	/* the sodium channel conductance is reset to default */

		sprintf(text,"%f", (double) NACON_GB_DEF);
		XmTextSetString(gbParamsNaConText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsNaConScale, args, n);
		XmScaleSetValue(gbParamsNaConScale, (int) (NACON_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_KEQ:	/* the potassium channel equilibrium potential is reset to default */

		sprintf(text,"%f", (double) KEQ_GB_DEF);
		XmTextSetString(gbParamsKEqText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsKEqScale, args, n);
		XmScaleSetValue(gbParamsKEqScale, (int) (KEQ_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_KCON:	/* the potassium channel conductance is reset to default */

		sprintf(text,"%f", (double) KCON_GB_DEF);
		XmTextSetString(gbParamsKConText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsKConScale, args, n);
		XmScaleSetValue(gbParamsKConScale, (int) (KCON_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_CA1CON:	/* the first calcium channel conductance is reset to default */

		sprintf(text,"%f", (double) CA1CON_GB_DEF);
		XmTextSetString(gbParamsCa1ConText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsCa1ConScale, args, n);
		XmScaleSetValue(gbParamsCa1ConScale, (int) (CA1CON_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_CA2CON:	/* the second calcium channel conductance is reset to default */

		sprintf(text,"%f", (double) CA2CON_GB_DEF);
		XmTextSetString(gbParamsCa2ConText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsCa2ConScale, args, n);
		XmScaleSetValue(gbParamsCa2ConScale, (int) (CA2CON_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_KCAEQ:	/* the calcium dependend potassium channel equilibrium potential is reset */

		sprintf(text,"%f", (double) KCAEQ_GB_DEF);
		XmTextSetString(gbParamsKEqText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsKCAEqScale, args, n);
		XmScaleSetValue(gbParamsKCAEqScale, (int) (KCAEQ_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_KCACON:	/* the calcium dependend potassium channel conductance is reset to default */

		sprintf(text,"%f", (double) KCACON_GB_DEF);
		XmTextSetString(gbParamsKCAConText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsKCAConScale, args, n);
		XmScaleSetValue(gbParamsKCAConScale, (int) (KCACON_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_AEQ:	/* the A channel equilibrium potential is reset to default */

		sprintf(text,"%f", (double) AEQ_GB_DEF);
		XmTextSetString(gbParamsAEqText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsAEqScale, args, n);
		XmScaleSetValue(gbParamsAEqScale, (int) (AEQ_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_ACON:	/* the A channel conductance is reset to default */

		sprintf(text,"%f", (double) ACON_GB_DEF);
		XmTextSetString(gbParamsAConText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsAConScale, args, n);
		XmScaleSetValue(gbParamsAConScale, (int) (ACON_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_IREQ:	/* the IR channel equilibrium potential is reset to default */

		sprintf(text,"%f", (double) IREQ_GB_DEF);
		XmTextSetString(gbParamsIREqText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsIREqScale, args, n);
		XmScaleSetValue(gbParamsIREqScale, (int) (IREQ_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_IRCON:	/* the IR channel conductance is reset to default */

		sprintf(text,"%f", (double) IRCON_GB_DEF);
		XmTextSetString(gbParamsIRConText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsIRConScale, args, n);
		XmScaleSetValue(gbParamsIRConScale, (int) (IRCON_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_PEQ:	/* the P channel equilibrium potential is reset to default */

		sprintf(text,"%f", (double) PEQ_GB_DEF);
		XmTextSetString(gbParamsPEqText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsPEqScale, args, n);
		XmScaleSetValue(gbParamsPEqScale, (int) (PEQ_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_PCON:	/* the P channel conductance is reset to default */

		sprintf(text,"%f", (double) PCON_GB_DEF);
		XmTextSetString(gbParamsPConText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsPConScale, args, n);
		XmScaleSetValue(gbParamsPConScale, (int) (PCON_GB_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_TRT:	/* the synaptic transmitter release treshold is reset to default */

		sprintf(text,"%f", (double) TRT_DEF);
		XmTextSetString(addSynapseTRTText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(addSynapseTRTScale, args, n);
		XmScaleSetValue(addSynapseTRTScale, (int) (TRT_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_TRS:	/* the synaptic transmitter release satiate is reset to default */

		sprintf(text,"%f", (double) TRS_DEF);
		XmTextSetString(addSynapseTRSText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(addSynapseTRSScale, args, n);
		XmScaleSetValue(addSynapseTRSScale, (int) (TRS_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_TARGET:	/* the synaptic location is reset to default */

		sprintf(text,"%d", TARGET_DEF);
		XmTextSetString(addSynapseTargetText, text);
		XmTextSetString(editSynapseLocationText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(addSynapseTargetScale, args, n);
		XmScaleSetValue(addSynapseTargetScale, (int) (TARGET_DEF * pow((double) 10, (double) decimals)));
		XmScaleSetValue(editSynapseLocationScale, (int) (TARGET_DEF * pow((double) 10, (double) decimals)));

		/* show synaptic connections in edit synapse list */

		LOC = TARGET_DEF;
		show_synaptic_connections();
		break;

	case DIALOG_DEF_LOCATION:	/* the synaptic location is reset to default */

		sprintf(text,"%d", TARGET_DEF);
		XmTextSetString(editSynapseLocationText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editSynapseLocationScale, args, n);
		XmScaleSetValue(editSynapseLocationScale, (int) (TARGET_DEF * pow((double) 10, (double) decimals)));

		/* show synaptic connections in edit synapse list */

		LOC = TARGET_DEF;
		show_synaptic_connections();
		break;

	case DIALOG_DEF_REGION:		/* the current location is reset to default */

		sprintf(text,"%d", TARGET_DEF);
		XmTextSetString(editCurrentLocationText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentLocationScale, args, n);
		XmScaleSetValue(editCurrentLocationScale, (int) (TARGET_DEF * pow((double) 10, (double) decimals)));
		REG = TARGET_DEF;

		break;

	case DIALOG_DEF_STR:	/* the synaptic conductance is reset to default */

		sprintf(text,"%f", (double) STR_DEF);
		XmTextSetString(addSynapseStrText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(addSynapseStrScale, args, n);
		XmScaleSetValue(addSynapseStrScale, (int) (STR_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_MAXSTR:	/* the maximal synaptic conductance is reset to default */

		sprintf(text,"%f", (double) MAXSTR_DEF);
		XmTextSetString(addSynapseMaxStrText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(addSynapseMaxStrScale, args, n);
		XmScaleSetValue(addSynapseMaxStrScale, (int) (MAXSTR_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_TT:	/* the synaptic transmission time is reset to default */

		sprintf(text,"%f", (double) TT_DEF);
		XmTextSetString(addSynapseTTText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(addSynapseTTScale, args, n);
		XmScaleSetValue(addSynapseTTScale, (int) (TT_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_SIMLEN:	/* the simulation length is reset to default */

		sprintf(text,"%f", (double) SIMLEN_DEF);
		XmTextSetString(editSimParsSimLenText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editSimParsSimLenScale, args, n);
		XmScaleSetValue(editSimParsSimLenScale, (int) (SIMLEN_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_SIMSIZE: /* the simulation step size is reset to default */

		sprintf(text,"%f", (double) SIMSIZE_DEF);
		XmTextSetString(editSimParsStepSizeText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editSimParsStepSizeScale, args, n);
		XmScaleSetValue(editSimParsStepSizeScale, (int) (SIMSIZE_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_NACTINT: /* the neuron activity interval is reset to default */

		sprintf(text,"%d", NACTINT_DEF);
		XmTextSetString(neuronActivityIntervalText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(neuronActivityIntervalScale, args, n);
		XmScaleSetValue(neuronActivityIntervalScale, (int) (NACTINT_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_SCUR:	/* the external soma current is reset to default */

		sprintf(text,"%f", (double) SCUR_DEF);
		XmTextSetString(editCurrentSomaCurrentText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentSomaCurrentScale, args, n);
		XmScaleSetValue(editCurrentSomaCurrentScale, (int) (SCUR_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_SSTART:	/* the external soma current start time is reset to default */

		sprintf(text,"%f", (double) SSTART_DEF);
		XmTextSetString(editCurrentSomaStartText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentSomaStartScale, args, n);
		XmScaleSetValue(editCurrentSomaStartScale, (int) (SSTART_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_SEND:	/* the external soma current end time is reset to default */

		sprintf(text,"%f", (double) LTSTOP * T_SCALE);
		XmTextSetString(editCurrentSomaEndText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentSomaEndScale, args, n);
		XmScaleSetValue(editCurrentSomaEndScale, (int) (LTSTOP * T_SCALE * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_DCUR:	/* the external dendritic current is reset to default */

		sprintf(text,"%f", (double) DCUR_DEF);
		XmTextSetString(editCurrentDendritCurrentText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentDendritCurrentScale, args, n);
		XmScaleSetValue(editCurrentDendritCurrentScale, (int) (DCUR_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_DSTART:	/* the external dendritic current start time is reset to default */

		sprintf(text,"%f", (double) DSTART_DEF);
		XmTextSetString(editCurrentDendritStartText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentDendritStartScale, args, n);
		XmScaleSetValue(editCurrentDendritStartScale, (int) (DSTART_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_DEND:	/* the external dendritic current end time is reset to default */

		sprintf(text,"%f", (double) LTSTOP * T_SCALE);
		XmTextSetString(editCurrentDendritEndText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(editCurrentDendritEndScale, args, n);
		XmScaleSetValue(editCurrentDendritEndScale,
			(int) (LTSTOP * T_SCALE * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_SEQ:	/* the equilibrium potential of a new synaptic type is reset to default */

		sprintf(text,"%f", (double) SEQ_DEF);
		XmTextSetString(newSTypeEqPotText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(newSTypeEqPotScale, args, n);
		XmScaleSetValue(newSTypeEqPotScale, (int) (SEQ_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_ONOFF_NAEQ:	/* sodium channel equilibrium potential in On/Off-model is reset to default */

		sprintf(text,"%f", (double) NAEQ_ONOFF_DEF);
		XmTextSetString(onOffParamsNaEqPotText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsNaEqPotScale, args, n);
		XmScaleSetValue(onOffParamsNaEqPotScale, (int) (NAEQ_ONOFF_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_ONOFF_NACON:	/* the sodium channel conductance in the On/Off-model is reset to default */

		sprintf(text,"%f", (double) NACONONOFF_DEF);
		XmTextSetString(onOffParamsNaConductanceText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsNaConductanceScale, args, n);
		XmScaleSetValue(onOffParamsNaConductanceScale,
			(int) (NACONONOFF_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_ONOFF_NADUR:	/* the sodium channel opening duration in the On/Off-model is reset to default */

		sprintf(text,"%f", (double) NADUR_DEF);
		XmTextSetString(onOffParamsNaDurText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsNaDurScale, args, n);
		XmScaleSetValue(onOffParamsNaDurScale, (int) (NADUR_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_ONOFF_KEQ:	/* potassium channel equilibrium potential in On/Off-model is reset to default */

		sprintf(text,"%f", (double) KEQ_ONOFF_DEF);
		XmTextSetString(onOffParamsKEqPotText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsKEqPotScale, args, n);
		XmScaleSetValue(onOffParamsKEqPotScale, (int) (KEQ_ONOFF_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_ONOFF_KCON:	/* the potassium channel conductance in the On/Off-model is reset to default */

		sprintf(text,"%f", (double) KCONONOFF_DEF);
		XmTextSetString(onOffParamsKConductanceText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsKConductanceScale, args, n);
		XmScaleSetValue(onOffParamsKConductanceScale,
			(int) (KCONONOFF_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_ONOFF_KSTART:	/* the potassium channel start time in the On/Off-model is reset to default */

		sprintf(text,"%f", (double) KSTART_DEF);
		XmTextSetString(onOffParamsKStartText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsKStartScale, args, n);
		XmScaleSetValue(onOffParamsKStartScale, (int) (KSTART_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_ONOFF_KDUR:	/* potassium channel opening duration in On/Off-model is reset to default */

		sprintf(text,"%f", (double) KDUR_DEF);
		XmTextSetString(onOffParamsKDurText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsKDurScale, args, n);
		XmScaleSetValue(onOffParamsKDurScale, (int) (KDUR_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_ONOFF_CAEQ:	/* calcium channel equilibrium potential in On/Off-model is reset to default */

		sprintf(text,"%f", (double) CAEQ_ONOFF_DEF);
		XmTextSetString(onOffParamsCaEqPotText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsCaEqPotScale, args, n);
		XmScaleSetValue(onOffParamsCaEqPotScale, (int) (CAEQ_ONOFF_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_ONOFF_CACON:	/* the calcium channel conductance in the On/Off-model is reset to default */

		sprintf(text,"%f", (double) CACONONOFF_DEF);
		XmTextSetString(onOffParamsCaConductanceText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsCaConductanceScale, args, n);
		XmScaleSetValue(onOffParamsCaConductanceScale,
			(int) (CACONONOFF_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_ONOFF_CASTART:	/* the calcium channel start time in the On/Off-model is reset to default */

		sprintf(text,"%f", (double) CASTART_DEF);
		XmTextSetString(onOffParamsCaStartText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsCaStartScale, args, n);
		XmScaleSetValue(onOffParamsCaStartScale, (int) (CASTART_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_ONOFF_CADUR:	/* calcium channel opening duration in the On/Off-model is reset to default */

		sprintf(text,"%f", (double) CADUR_DEF);
		XmTextSetString(onOffParamsCaDurText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsCaDurScale, args, n);
		XmScaleSetValue(onOffParamsCaDurScale, (int) (CADUR_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_ONOFF_STH:	/* the spike threshold in the On/Off-model is reset to default */

		sprintf(text,"%f", (double) STH_DEF);
		XmTextSetString(onOffParamsSpikeThresholdText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(onOffParamsSpikeThresholdScale, args, n);
		XmScaleSetValue(onOffParamsSpikeThresholdScale, (int) (STH_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_SWIM_STH:	/* the spike threshold in the SWIM-model is reset to default */

		sprintf(text,"%f", (double) STH_DEF);
		XmTextSetString(swimParamsSpikeThresholdText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(swimParamsSpikeThresholdScale, args, n);
		XmScaleSetValue(swimParamsSpikeThresholdScale, (int) (STH_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_HH_STH:	/* the spike threshold in the HH-model is reset to default */

		sprintf(text,"%f", (double) STH_DEF);
		XmTextSetString(hhParamsSpikeThresholdText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(hhParamsSpikeThresholdScale, args, n);
		XmScaleSetValue(hhParamsSpikeThresholdScale, (int) (STH_DEF * pow((double) 10, (double) decimals)));

		break;

	case DIALOG_DEF_GB_STH:	/* the spike threshold in the GB-model is reset to default */

		sprintf(text,"%f", (double) STH_DEF);
		XmTextSetString(gbParamsSpikeThresholdText, text);

		n = 0;
		XtSetArg(args[n], XmNdecimalPoints, &decimals); n++;
		XtGetValues(gbParamsSpikeThresholdScale, args, n);
		XmScaleSetValue(gbParamsSpikeThresholdScale, (int) (STH_DEF * pow((double) 10, (double) decimals)));

		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in DIALOG_DEF occured !\n");
		break;
	}

} /* end of dialog_def2_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_button2_CB(w, client_data, call_data)
 
	PURPOSE		: callback for special buttons, such as load and save parameters

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_button2_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	Arg		args[20];		/* argument list for manipulating widgets */
	Cardinal 	n;			/* used as argument counter for manipulating widgets */
	XmString 	xmstrings[10]; 		/* temporary storage for XmStrings */

	/* check widget from which it comes */

	switch((int) client_data)
	{

	case DIALOG_BUTTON_LOAD_GENERAL:	/* show a file selection box for choosing a filename */

		xmstrings[0] = XmStringCreate(loadGeneralTitleString, defaultFont);
		xmstrings[1] = XmStringCreate(neuronParameterDirectory, defaultFont);
		xmstrings[2] = XmStringCreate(filesString, defaultFont);
		xmstrings[3] = XmStringCreate(filterString, defaultFont);
		xmstrings[4] = XmStringCreate(selectionString, defaultFont);
		xmstrings[5] = XmStringCreate(okString, defaultFont);
		xmstrings[6] = XmStringCreate(noString, defaultFont);
		xmstrings[7] = XmStringCreate(helpString, defaultFont);

		/* create file selection box */

		n = 0;
		XtSetArg(args[n], XmNdialogTitle, xmstrings[0]); n++;
		XtSetArg(args[n], XmNlistLabelString, xmstrings[2]); n++;
		XtSetArg(args[n], XmNfilterLabelString, xmstrings[3]); n++;
		XtSetArg(args[n], XmNselectionLabelString, xmstrings[4]); n++;
		XtSetArg(args[n], XmNdirMask, xmstrings[1]); n++;
		XtSetArg(args[n], XmNlistVisibleItemCount, 10); n++;
		XtSetArg(args[n], XmNokLabelString, xmstrings[5]); n++;
		XtSetArg(args[n], XmNcancelLabelString, xmstrings[6]); n++;
		XtSetArg(args[n], XmNhelpLabelString, xmstrings[7]); n++;
		loadGeneralDialog = XmCreateFileSelectionDialog(XtParent(w), "load general dialog", args, n);

		XtAddCallback(loadGeneralDialog, XmNokCallback, dialog_accept2_CB, (caddr_t *) DIALOG_LOAD_GENERAL);
		XtAddCallback(loadGeneralDialog, XmNcancelCallback, unmanage_link_CB, (caddr_t *) &loadGeneralDialog);
		XtAddCallback(loadGeneralDialog, XmNhelpCallback, dialog_help2_CB, (caddr_t *) DIALOG_LOAD_GENERAL);

		XmStringFree(xmstrings[0]);
		XmStringFree(xmstrings[1]);
		XmStringFree(xmstrings[2]);
		XmStringFree(xmstrings[3]);
		XmStringFree(xmstrings[4]);
		XmStringFree(xmstrings[5]);
		XmStringFree(xmstrings[6]);
		XmStringFree(xmstrings[7]);

		XtManageChild(loadGeneralDialog);
		break;

	case DIALOG_BUTTON_SAVE_GENERAL:	/* show a file selection box for choosing a filename */

		xmstrings[0] = XmStringCreate(saveGeneralTitleString, defaultFont);
		xmstrings[1] = XmStringCreate(neuronParameterDirectory, defaultFont);
		xmstrings[2] = XmStringCreate(filesString, defaultFont);
		xmstrings[3] = XmStringCreate(filterString, defaultFont);
		xmstrings[4] = XmStringCreate(selectionString, defaultFont);
		xmstrings[5] = XmStringCreate(okString, defaultFont);
		xmstrings[6] = XmStringCreate(noString, defaultFont);
		xmstrings[7] = XmStringCreate(helpString, defaultFont);

		/* create file selection box */

		n = 0;
		XtSetArg(args[n], XmNdialogTitle, xmstrings[0]); n++;
		XtSetArg(args[n], XmNlistLabelString, xmstrings[2]); n++;
		XtSetArg(args[n], XmNfilterLabelString, xmstrings[3]); n++;
		XtSetArg(args[n], XmNselectionLabelString, xmstrings[4]); n++;
		XtSetArg(args[n], XmNdirMask, xmstrings[1]); n++;
		XtSetArg(args[n], XmNlistVisibleItemCount, 10); n++;
		XtSetArg(args[n], XmNokLabelString, xmstrings[5]); n++;
		XtSetArg(args[n], XmNcancelLabelString, xmstrings[6]); n++;
		XtSetArg(args[n], XmNhelpLabelString, xmstrings[7]); n++;
		saveGeneralDialog = XmCreateFileSelectionDialog(XtParent(w), "save general dialog", args, n);

		XtAddCallback(saveGeneralDialog, XmNokCallback, dialog_accept2_CB, (caddr_t *) DIALOG_SAVE_GENERAL);
		XtAddCallback(saveGeneralDialog, XmNcancelCallback, unmanage_link_CB, (caddr_t *) &saveGeneralDialog);
		XtAddCallback(saveGeneralDialog, XmNhelpCallback, dialog_help2_CB, (caddr_t *) DIALOG_SAVE_GENERAL);

		XmStringFree(xmstrings[0]);
		XmStringFree(xmstrings[1]);
		XmStringFree(xmstrings[2]);
		XmStringFree(xmstrings[3]);
		XmStringFree(xmstrings[4]);
		XmStringFree(xmstrings[5]);
		XmStringFree(xmstrings[6]);
		XmStringFree(xmstrings[7]);

		XtManageChild(saveGeneralDialog);
		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in DIALOG_BUTTON occured !\n");
		break;
	}

} /* end of dialog_button2_CB */

/************************************************************************************************************************

 	FUNCTION	: dialog_selection2_CB(w, client_data, call_data)
 
	PURPOSE		: callback for selections from selection lists

	RETURNS		: nothing

************************************************************************************************************************/

void dialog_selection2_CB(w, client_data, call_data)
Widget          w;              /*  widget id           */
caddr_t         client_data;    /*  data from application   */
caddr_t         call_data;      /*  data from widget class  */
{
	XmListCallbackStruct	*selection = (XmListCallbackStruct *) call_data;
	char		number[10];	/* number of synaptic type */
	char		text[40];	/* used for conversion of synaptic conductance and transmission time */
	char		*item = NULL;	/* selected item in list widget of edit synapse mask or add synapse mask */
	int		i;		/* loop variable */

	/* check widget from which it comes */

	switch((int) client_data)
	{
	case DIALOG_EDIT_SYNAPSE:	/* parse selected item from edit synapse list widget and store information */

		/* get selected item */

		XmStringGetLtoR(selection->item, defaultFont, &item);

		/* store synaptic type in itemSelected record */

		strncpy(number, item, 18);
		strcat(number, "\0");
		itemSelected.type = atoi(number);
		typeNum = itemSelected.type;

		/* store synaptic conductance in itemSelected record */

		for (i = 88; i < 123; i++)
			text[i - 88] = item[i];
		strcat(text, "\0");
		itemSelected.STRENGTH = strtod(text, (char **) NULL) / S_SCALE;

		/* store synaptic transmission time in itemSelected record */

		for (i = 123; i < strlen(item); i++)
			text[i - 123] = item[i];
		strcat(text, "\0");
		itemSelected.TT = strtod(text, (char **) NULL) / T_SCALE;

		/* store synaptic position in itemSelected record */

		itemSelected.position = selection->item_position;

		/* store synaptic location in itemSelected record */

		itemSelected.LOC = LOC;

		break;

	case DIALOG_ADD_SYNAPSE:	/* set typeNum to the selected synaptic type; needed for connecting neurons */

		/* get selected item */

		XmStringGetLtoR(selection->item, defaultFont, &item);

		strncpy(number, item, 9);
		strcat(number, "\0");
		typeNum = atoi(number);

		break;

	default:	/* unknown callback type */
		fprintf(stderr, "Warning: unknown callback in DIALOG_SELECTION occured !\n");
		break;
	}

} /* end of dialog_selection2_CB */

/************************************************************************************************************************

 	FUNCTION	: show_synaptic_connections()
 
	PURPOSE		: shows synaptic connections in the editSynapseList

	RETURNS		: nothing

************************************************************************************************************************/

void show_synaptic_connections()
{
	Arg		args[20];			/* argument list for manipulating widgets */
	Cardinal	n;				/* used as argument counter for manipulating widgets */
	int		typeNr;				/* synaptic type number */
	char		val[20];			/* used for converting neuron id's */
	char		type[20];			/* synaptic type string */
	char		listString[256];		/* string for list widget entry */
	Neuron 		*actPtr;			/* current neuron */
	Connection	*connection;			/* current synapse */
	XmString 	str;		 		/* temporary storage for XmStrings */

	/* return if no neuron was selected */

	if (! selectionListNeuronsHead)
		return;

	/* delete all items in the edit synapse list widget */

	n = 0;
	XtSetArg(args[n], XmNitemCount, 0); n++;
	XtSetArg(args[n], XmNitems, NULL); n++;
	XtSetValues(editSynapseList, args, n);

	/* loop through all synapses outgoing from the source neuron */

	for (connection = selectionListNeuronsHead->neuronPtr->connectionList;
	    connection != NULL;
	    connection = connection->nextConnection)
	{
		/* if target neuron of the current connection is the selected target neuron
		   then add connection to the edit synapse list widget in case of synapse
		   location is identical to selected location */

		if (connection->targetNeuron == selectionListNeuronsTail->neuronPtr)
		{
			/* fill in edit synapse mask source and target neuron number */

			actPtr = selectionListNeuronsHead->neuronPtr;

			/* set source neuron id */

			sprintf(val, "%d", actPtr->neuronId);
			XmTextSetString(editSynapseFromText, val);

			actPtr = selectionListNeuronsTail->neuronPtr;

			/* set target neuron id */

			sprintf(val, "%d", actPtr->neuronId);
			XmTextSetString(editSynapseToText, val);

			/* check if target location is identical with selected location */

			if (connection->targetArea == LOC)
			{
				/* set synaptic location */

				sprintf(val, "%d", connection->targetArea);
				XmTextSetString(editSynapseLocationText, val);

				/* create list widget entry */

				typeNr = connection->synapticType;

				switch (synapseTypes[typeNr].ionType)
				{
				case 1:
					strcpy(type, sodiumString);
					break;

				case 2:
					strcpy(type, potassiumString);
					break;

				case 3:
					strcpy(type, chemicalString);
					break;

				case 4:
					strcpy(type, electricalString);
					break;
				}

				if (synapseTypes[typeNr].ionType == 4)
					sprintf(listString, "%-18d%-70s%-+#35f%-+#f", typeNr, type,
						connection->initialConductance * S_SCALE,
						connection->deliveryTime * T_SCALE);
				else
					sprintf(listString, "%-18d%-30s%-+#40f%-+#35f%-+#f", typeNr, type,
					    synapseTypes[typeNr].equilPotential * E_SCALE,
					    connection->initialConductance * S_SCALE, connection->deliveryTime * T_SCALE);

				/* add list widget entry to edit synapse list widget */

				str = XmStringCreateLtoR(listString, defaultFont);
				XmListAddItemUnselected(editSynapseList, str, 0);
				XmStringFree(str);
			}
		}
	}
} /* end of show_synaptic_connections */
#endif
