/************************************************************************************************************************

	PROGRAM:	BIOSIM

	FILENAME:	functions.h

	PURPOSE:	all functions used in biosim are declared here

************************************************************************************************************************/

/* functions declared in biosim.c */

#ifndef BATCH
void read_commands();
#endif
void main();

/* functions declared in calculations.c */

void run_simulation();
#ifndef BATCH
Boolean run_simulation_step();
#endif
void init_learn_parameter();
void initialize_variables();
void init_pools();
double integration_method();
double calculate_form_parameter();
void calculate_new_learning_values();
void calculate_synapses();
void calculate_synaptic_influences();
void calculate_onoff_neuron();
void calculate_HH_neuron();
void calculate_SWIM_neuron();
void calculate_GB_neuron();

/* functions declared in fileopen.c */

Boolean read_input_currents();
#ifndef BATCH
Boolean read_general_neuron_parameters();
#endif
Boolean read_network();
#ifndef BATCH
Boolean read_parameter();
Boolean read_configuration();
#endif
Boolean readf();
Boolean get_neuron();
#ifndef BATCH
Boolean read_on_off_channels();
Boolean read_swim_channels();
Boolean read_HH_channels();
Boolean read_golowasch_channels();
#endif

/* functions declared in filesave.c */

#ifndef BATCH
Boolean save_general_neuron_parameters();
Boolean save_network();
void save_neuron();
Boolean save_parameter();
Boolean save_configuration();
#endif
Boolean save_graph();
Boolean save_graphS();

/* functions declared in graph.c */

#ifndef BATCH
void update_graph();
void draw_graph();
#endif
void graph_output();
#ifndef BATCH
void set_x_axis();
void set_y_axis();
void draw_lines();
void draw_dots();
void draw_axises();
void update_graphS();
void draw_graphS();
void set_x_axisS();
void set_y_axisS();
void draw_linesS();
void draw_dotsS();
void draw_axisesS();
#endif

/* functions declared in graphic.c */

void add_neuron_to_neuron_list();
void remove_neuron_from_neuron_list();
void add_neuron_to_selection_list();
void remove_neuron_from_selection_list();
void add_synapse_to_selection_list();
void remove_synapse_from_selection_list();
void remove_selected_objects_from_selectionList();
void clear_neuron();
void clear_neuron_no_channels();
void clear_neurons();
void clear_network();
void reset_network();
#ifndef BATCH
void change_neuron_color();
void set_neuron_color();
void change_synapse_color();
void show_all_objects_in_drawing_area();
void show_input_neurons();
void show_output_neurons();
void show_input_output_neurons();
void show_topology();
void show_normal_state();
void process_buttonevent();
Boolean is_connected();
Boolean connection_exists();
void delete_graphical_connection();
#endif
void delete_connection();
#ifndef BATCH
void change_synaptic_values();
Region connect_neurons_graphical();
#endif
void connect_neurons();
#ifndef BATCH
Region draw_synapse();
void calculate_graphical_synapse();
void select_all_neurons_CB();
void select_all_synapses_CB();
void select_all_axo_synapses_CB();
void drawing_input_CB();
void drawing_expose_CB();
void drawing_resize_CB();
void remove_selected_objects_CB();
void remove_selected_objects_from_selectionList_CB();
#endif

/* functions declared in menu.c */

#ifndef BATCH
Widget create_menubar();
void create_askModelPoint();
void create_noiseDialog();
void create_stddevDialog();
Widget generate_file_selection_box();
void set_max_scale();
void dialog_accept_CB();
void dialog_text_CB();
void dialog_cancel_CB();
void dialog_help_CB();
void dialog_option_button_CB();
void dialog_stochastic_button_CB();
void dialog_learn_button_CB();
void dialog_model_button_CB();
void dialog_integrationMethods_button_CB();
void edit_sim_pars_CB();
#endif

/* functions declared in menu2.c */

#ifndef BATCH
void create_popupMenu();
void create_infoObject();
void create_onOffParams();
void create_swimParams();
void create_hhParams();
void create_gbParams();
void create_editNeuron();
void create_editCurrent();
void create_newSType();
void create_addSynapse();
void create_editSynapse();
void create_editSimPars();
void create_simInf();
void set_synaptic_types();
void dialog_accept2_CB();
void dialog_cancel2_CB();
void dialog_help2_CB();
void radio_box2_CB();
void dialog_text2_CB();
void dialog_scale2_CB();
void dialog_def2_CB();
void dialog_button2_CB();
void dialog_selection2_CB();
void show_synaptic_connections();
#endif

/* functions declared in menu3.c */

#ifndef BATCH
void create_asciiOutputInterval();
void create_newGraphYZoom();
void create_newGraphXZoom();
void create_newGraphYScaling();
void create_newGraphXScaling();
#endif
void create_newGraph();
#ifndef BATCH
void create_askDendrit();
void create_asciiOutputIntervalS();
void create_newGraphYZoomS();
void create_newGraphXZoomS();
void create_newGraphYScalingS();
void create_newGraphXScalingS();
#endif
void create_newGraphS();
#ifndef BATCH
void draw_graph_CB();
void determine_current_graph();
Neuron *get_neuron_from_graph_title();
void save_graph_CB();
void draw_graphS_CB();
void determine_current_graphS();
Connection *get_synapse_from_graph_title();
void save_graphS_CB();
void dialog_text3_CB();
void dialog_scale3_CB();
void dialog_accept3_CB();
void dialog_help3_CB();
void dialog_toggle3_CB();
void dialog_def3_CB();
#endif

/* functions declared in menu4.c */

#ifndef BATCH
void create_axoSynapse();
void create_learnParam();
void dialog_text4_CB();
void dialog_scale4_CB();
void dialog_def4_CB();
void dialog_accept4_CB();
void dialog_help4_CB();
#endif

/* functions declared in utilities.c */

#ifndef BATCH
void manage_link_CB();
void unmanage_link_CB();
void map_link_CB();
void unmap_link_CB();
void enable_link_CB();
void disable_link_CB();
unsigned long get_color();
void load_colors();
Widget create_information_box();
Widget create_warning_box();
Widget create_error_box();
#endif
Boolean is_it_a_number();
Boolean is_it_a_float_number();
double intpower();
char *convert_number();
double random_number_between_zero_and_one();
double uniform_random();
double normal_random();
double noiseevents();
void realloc_graph();
void realloc_graphS();
void reset_extern_input_currents();
void error();
