/************************************************************************************************************************

	PROGRAM:	BIOSIM

	FILENAME:	calculations.h

	PURPOSE:	definitions used in calculations.c

************************************************************************************************************************/

#define PRECISION	1e-3

#define Euler(y, dy)		((y) + (dy) * STEP)
#define Trapezoid(y, A, B)	(((y) * (1 - STEP * (B) / 2.0) + STEP * (A)) / (1 + STEP * (B) / 2.0))

#define TERM1(E, U, V)			((U) + (V) * (E))
#define TERM2(E, W, X, Y, Z)		((W) + (Z) * exp(((E) + (X)) / (Y)))
#define MUL_FORM(E, U, V, W, X, Y, Z)	((U) + (V) * (E)) * ((W) + (Z) * exp(((E) + (X)) / (Y)))
#define DIV_FORM(E, U, V, W, X, Y, Z)	((U) + (V) * (E)) / ((W) + (Z) * exp(((E) + (X)) / (Y)))
