/************************************************************************************************************************

	PROGRAM:	HELPSYSTEM

	FILENAME:	helpSystem.c

	PURPOSE:	contains function to create the application window

	FUNCTIONS:	in order of appearance

	XDmanage_link			- manage (make it visible) a widget given by pointer
	XDunmanage_link			- unmanage (make it invisible) a widget given by pointer
	XDmap_link			- map a widget given by pointer
	XDunmap_link			- unmap a widget given by pointer
	create_explainHelpShell		- creates help over help window
	create_previousShell		- create history window
	create_searchShell		- create window for searching themes
	create_defineShell		- create window for defining bookmarks
	create_openShell		- create window for open file dialog
	create_mainWindow		- create window for the main application

************************************************************************************************************************/

#include "help.h"

extern void show_glossary_CB ( );
extern void show_previous_theme_CB ( );
extern void show_theme_list_CB ( );
extern void show_content_CB ( );
extern void exit_helpServer_CB ( );
extern void print_current_theme_CB ( );
extern void dialog_CB ( );

/************************************************************************************************************************

 	FUNCTION	: XDmanage_link(w, client_data, call_data)
 
	PURPOSE		: manage (make it visible) a widget given by pointer

	RETURNS		: nothing

************************************************************************************************************************/

void XDmanage_link (w, client_data, call_data)
Widget w;		/*  widget id           */
Widget *client_data;	/*  data from application   */
caddr_t call_data;      /*  data from widget class  */
{
    XtManageChild ( *client_data );
}

/************************************************************************************************************************

 	FUNCTION	: XDunmanage_link(w, client_data, call_data)
 
	PURPOSE		: unmanage (make it invisible) a widget given by pointer

	RETURNS		: nothing

************************************************************************************************************************/

void XDunmanage_link (w, client_data, call_data)
Widget w;		/*  widget id           */
Widget *client_data;	/*  data from application   */
caddr_t call_data;      /*  data from widget class  */
{
    XtUnmanageChild ( *client_data );
}

/************************************************************************************************************************

 	FUNCTION	: XDmap_link(w, client_data, call_data)
 
	PURPOSE		: map a widget given by pointer

	RETURNS		: nothing

************************************************************************************************************************/

void XDmap_link (w, client_data, call_data)
Widget w;		/*  widget id           */
Widget *client_data;	/*  data from application   */
caddr_t call_data;      /*  data from widget class  */
{
    Arg             al[2];          /*  arg list            */
    register int    ac;             /*  arg count           */
    ac = 0;
    XtSetArg (al[ac], XmNmappedWhenManaged, TRUE);  ac++;
    XtSetValues ( *client_data, al, ac );
}

/************************************************************************************************************************

 	FUNCTION	: XDunmap_link(w, client_data, call_data)
 
	PURPOSE		: unmap a widget given by pointer

	RETURNS		: nothing

************************************************************************************************************************/

void XDunmap_link (w, client_data, call_data)
Widget w;		/*  widget id           */
Widget *client_data;	/*  data from application   */
caddr_t call_data;      /*  data from widget class  */
{
    Arg             al[2];          /*  arg list            */
    register int    ac;             /*  arg count           */
    ac = 0;
    XtSetArg (al[ac], XmNmappedWhenManaged, FALSE);  ac++;
    XtSetValues ( *client_data, al, ac );
}

/************************************************************************************************************************

 	FUNCTION	: create_explainHelpShell(parent)
 
	PURPOSE		: creates help over help window

	RETURNS		: nothing

************************************************************************************************************************/

void create_explainHelpShell( parent )
Widget parent;
{
	Widget children[3];      /* Children to manage */
	Arg al[16];              /* Arg List */
	register int ac = 0;     /* Arg Count */

	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	explainHelpShell = XmCreateDialogShell ( parent, "explainHelpShell", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
	explainHelpBB = XmCreateBulletinBoard ( explainHelpShell, "explainHelpBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
	explainHelpForm = XmCreateForm ( explainHelpBB, "explainHelpForm", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNeditMode, XmMULTI_LINE_EDIT); ac++;
	XtSetArg(al[ac], XmNcolumns, 80); ac++;
	XtSetArg(al[ac], XmNrows, 25); ac++;
	explainHelpWindow = XmCreateScrolledText ( explainHelpForm, "explainHelpScrolledText", al, ac );

	explainHelpScrolledText = XtParent ( explainHelpWindow );

	ac = 0;
	explainHelpSeparator = XmCreateSeparator ( explainHelpForm, "explainHelpSeparator", al, ac );

	ac = 0;
	explainHelpOkButton = XmCreatePushButton ( explainHelpForm, "explainHelpOkButton", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( explainHelpScrolledText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, explainHelpScrolledText); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( explainHelpSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, explainHelpSeparator); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( explainHelpOkButton,al, ac );

	XtManageChild(explainHelpWindow);

	XtAddCallback (explainHelpOkButton,XmNactivateCallback, XDunmap_link, (caddr_t *) &explainHelpBB );
	XtAddCallback (explainHelpOkButton,XmNactivateCallback, XDunmanage_link, (caddr_t *) &explainHelpBB );

	ac = 0;
	children[ac++] = explainHelpSeparator;
	children[ac++] = explainHelpOkButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = explainHelpForm;
	XtManageChildren(children, ac);

} /* end of create_explainHelpShell */

/************************************************************************************************************************

 	FUNCTION	: create_previousShell(parent)
 
	PURPOSE		: create history window

	RETURNS		: nothing

************************************************************************************************************************/

void create_previousShell( parent )
Widget parent;
{
	Widget children[3];      /* Children to manage */
	Arg al[16];              /* Arg List */
	register int ac = 0;     /* Arg Count */

	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	previousShell = XmCreateDialogShell ( parent, "previousShell", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
	previousBB = XmCreateBulletinBoard ( previousShell, "previousBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
	previousForm = XmCreateForm ( previousBB, "previousForm", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE); ac++;
	XtSetArg(al[ac], XmNlistSpacing, 2); ac++;
	XtSetArg(al[ac], XmNvisibleItemCount, 10); ac++;
	previousThemeList = XmCreateScrolledList ( previousForm, "previousScrolledWindow", al, ac );

	previousScrolledWindow = XtParent ( previousThemeList );

	ac = 0;
	previousSeparator = XmCreateSeparator ( previousForm, "previousSeparator", al, ac );

	ac = 0;
	previousCancelButton = XmCreatePushButton ( previousForm, "previousCancelButton", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( previousScrolledWindow,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, previousScrolledWindow); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( previousSeparator,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, previousSeparator); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( previousCancelButton,al, ac );

	XtManageChild(previousThemeList);

	XtAddCallback (previousThemeList, XmNbrowseSelectionCallback, dialog_CB,(caddr_t *) PREVIOUS_THEME);
	XtAddCallback (previousCancelButton,XmNactivateCallback, XDunmanage_link, (caddr_t *) &previousBB );
	XtAddCallback (previousCancelButton,XmNactivateCallback, XDunmap_link, (caddr_t *) &previousBB );

	ac = 0;
	children[ac++] = previousSeparator;
	children[ac++] = previousCancelButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = previousForm;
	XtManageChildren(children, ac);

} /* end of create_previousShell */

/************************************************************************************************************************

 	FUNCTION	: create_searchShell(parent)
 
	PURPOSE		: create window for searching themes

	RETURNS		: nothing

************************************************************************************************************************/

void create_searchShell( parent )
Widget parent;
{
	Widget children[5];      /* Children to manage */
	Arg al[16];              /* Arg List */
	register int ac = 0;     /* Arg Count */

	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	searchShell = XmCreateDialogShell ( parent, "searchShell", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
	searchBB = XmCreateBulletinBoard ( searchShell, "searchBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
	searchForm = XmCreateForm ( searchBB, "searchForm", al, ac );

	ac = 0;
	searchLabel = XmCreateLabel ( searchForm, "searchLabel", al, ac );

	ac = 0;
	searchText = XmCreateText ( searchForm, "searchText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE); ac++;
	XtSetArg(al[ac], XmNlistSpacing, 2); ac++;
	XtSetArg(al[ac], XmNvisibleItemCount, 10); ac++;
	searchList = XmCreateScrolledList ( searchForm, "searchScrolledWindow", al, ac );

	searchScrolledWindow = XtParent ( searchList );

	ac = 0;
	searchGotoButton = XmCreatePushButton ( searchForm, "searchGotoButton", al, ac );

	ac = 0;
	searchCancelButton = XmCreatePushButton ( searchForm, "searchCancelButton", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( searchLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, searchLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( searchText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, searchText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( searchScrolledWindow,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, searchText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( searchGotoButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, searchScrolledWindow); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( searchCancelButton,al, ac );

	XtManageChild(searchList);

	XtAddCallback (searchList, XmNbrowseSelectionCallback, dialog_CB,(caddr_t *) SELECT_THEME);
	XtAddCallback (searchList, XmNdefaultActionCallback, dialog_CB,(caddr_t *) SELECT_THEME);
	XtAddCallback (searchList, XmNdefaultActionCallback, dialog_CB,(caddr_t *) GOTO_THEME);
	XtAddCallback (searchText, XmNactivateCallback, dialog_CB,(caddr_t *) GOTO_THEME);
	XtAddCallback (searchGotoButton, XmNactivateCallback, dialog_CB,(caddr_t *) GOTO_THEME);
	XtAddCallback (searchCancelButton,XmNactivateCallback, XDunmanage_link, (caddr_t *) &searchBB );
	XtAddCallback (searchCancelButton,XmNactivateCallback, XDunmap_link, (caddr_t *) &searchBB );

	ac = 0;
	children[ac++] = searchLabel;
	children[ac++] = searchText;
	children[ac++] = searchGotoButton;
	children[ac++] = searchCancelButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = searchForm;
	XtManageChildren(children, ac);

} /* end of create_searchShell */

/************************************************************************************************************************

 	FUNCTION	: create_defineShell(parent)
 
	PURPOSE		: create window for defining bookmarks

	RETURNS		: nothing

************************************************************************************************************************/

void create_defineShell( parent )
Widget parent;
{
	Widget children[5];      /* Children to manage */
	Arg al[16];              /* Arg List */
	register int ac = 0;     /* Arg Count */

	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	defineShell = XmCreateDialogShell ( parent, "defineShell", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
	defineBB = XmCreateBulletinBoard ( defineShell, "defineBB", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
	defineForm = XmCreateForm ( defineBB, "defineForm", al, ac );

	ac = 0;
	defineBookMarkLabel = XmCreateLabel ( defineForm, "defineBookMarkLabel", al, ac );

	ac = 0;
	defineBookMarkText = XmCreateText ( defineForm, "defineBookMarkText", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE); ac++;
	XtSetArg(al[ac], XmNlistSpacing, 2); ac++;
	XtSetArg(al[ac], XmNvisibleItemCount, 6); ac++;
	defineBookMarkList = XmCreateScrolledList ( defineForm, "defineScrolledWindow", al, ac );

	defineScrolledWindow = XtParent ( defineBookMarkList );

	defineOkButton = XmCreatePushButton ( defineForm, "defineOkButton", al, ac );

	ac = 0;
	defineCancelButton = XmCreatePushButton ( defineForm, "defineCancelButton", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( defineBookMarkLabel,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, defineBookMarkLabel); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( defineBookMarkText,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopOffset, 10); ac++;
	XtSetArg(al[ac], XmNtopWidget, defineBookMarkText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNrightWidget, defineBookMarkText); ac++;
        XtSetValues ( defineScrolledWindow,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); ac++;
	XtSetArg(al[ac], XmNtopWidget, defineBookMarkText); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetValues ( defineOkButton,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
	XtSetArg(al[ac], XmNleftOffset, 10); ac++;
	XtSetArg(al[ac], XmNleftWidget, defineScrolledWindow); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
        XtSetValues ( defineCancelButton,al, ac );

	XtManageChild(defineBookMarkList);

	XtAddCallback (defineBookMarkText, XmNactivateCallback, dialog_CB,(caddr_t *) DEFINE_BOOKMARK);
	XtAddCallback (defineOkButton, XmNactivateCallback, dialog_CB,(caddr_t *) DEFINE_BOOKMARK);
	XtAddCallback (defineCancelButton,XmNactivateCallback, XDunmap_link, (caddr_t *) &defineBB );
	XtAddCallback (defineCancelButton,XmNactivateCallback, XDunmanage_link, (caddr_t *) &defineBB );

	ac = 0;
	children[ac++] = defineBookMarkLabel;
	children[ac++] = defineBookMarkText;
	children[ac++] = defineOkButton;
	children[ac++] = defineCancelButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = defineForm;
	XtManageChildren(children, ac);

} /* end of create_defineShell */

/************************************************************************************************************************

 	FUNCTION	: create_openShell(parent)
 
	PURPOSE		: create window for open file dialog

	RETURNS		: nothing

************************************************************************************************************************/

void create_openShell( parent )
Widget parent;
{
	Arg al[16];               /* Arg List */
	register int ac = 0;      /* Arg Count */
	Widget openFilterButton;

	openShell = XmCreateFileSelectionDialog ( parent, "openShell", al, ac );

	openFilterButton = XmSelectionBoxGetChild ( openShell, XmDIALOG_APPLY_BUTTON );

	ac = 0;
	XtSetArg(al[ac], XmNdefaultButton, openFilterButton); ac++;
	XtSetValues(openShell, al, ac);

	XtAddCallback (openShell, XmNokCallback, dialog_CB, (caddr_t *) OPEN_FILE);
	XtAddCallback (openShell, XmNcancelCallback, XDunmap_link, (caddr_t *) &openShell);
	XtAddCallback (openShell, XmNcancelCallback, XDunmanage_link, (caddr_t *) &openShell);

} /* end of create_openShell */

/************************************************************************************************************************

 	FUNCTION	: create_mainWindow(parent)
 
	PURPOSE		: create window for the main application

	RETURNS		: nothing

************************************************************************************************************************/

void create_mainWindow( parent )
Widget parent;
{
	Widget children[7];      /* Children to manage */
	Arg al[16];              /* Arg List */
	register int ac = 0;     /* Arg Count */

	XtSetArg(al[ac], XmNscrollingPolicy, XmAUTOMATIC); ac++;
	mainWindow = XmCreateMainWindow ( applShell, "mainWindow", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNhorizontalScrollBar, &vSB ); ac++;
	XtSetArg(al[ac], XmNverticalScrollBar, &hSB ); ac++;
	XtGetValues(mainWindow, al, ac );

	mainWindowSeparator1 = XmMainWindowSep1 ( mainWindow );
	mainWindowSeparator2 = XmMainWindowSep2 ( mainWindow );

	ac = 0;
	menuBar = XmCreateMenuBar ( mainWindow, "menuBar", al, ac );

	ac = 0;
	fileSubMenu = XmCreatePulldownMenu ( menuBar, "fileSubMenu", al, ac );

	ac = 0;
	openButton = XmCreatePushButton ( fileSubMenu, "openButton", al, ac );

	ac = 0;
	printButton = XmCreatePushButton ( fileSubMenu, "printButton", al, ac );

	ac = 0;
	filePulldownMenuSeparator = XmCreateSeparator ( fileSubMenu, "filePulldownMenuSeparator", al, ac );

	ac = 0;
	quitButton = XmCreatePushButton ( fileSubMenu, "quitButton", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNsubMenuId, fileSubMenu); ac++;
	fileMenu = XmCreateCascadeButton ( menuBar, "fileMenu", al, ac );

	ac = 0;
	bookMarkSubMenu = XmCreatePulldownMenu ( menuBar, "bookMarkSubMenu", al, ac );

	ac = 0;
	defineButton = XmCreatePushButton ( bookMarkSubMenu, "defineButton", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNsubMenuId, bookMarkSubMenu); ac++;
	bookMarkMenu = XmCreateCascadeButton ( menuBar, "bookMarkMenu", al, ac );

	ac = 0;
	helpSubMenu = XmCreatePulldownMenu ( menuBar, "helpSubMenu", al, ac );

	ac = 0;
	usingHelpButton = XmCreatePushButton ( helpSubMenu, "usingHelpButton", al, ac );

	ac = 0;
	helpPulldownMenuSeparator = XmCreateSeparator ( helpSubMenu, "helpPulldownMenuSeparator", al, ac );

	ac = 0;
	helpInfoButton = XmCreatePushButton ( helpSubMenu, "helpInfoButton", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNsubMenuId, helpSubMenu); ac++;
	helpMenu = XmCreateCascadeButton ( menuBar, "helpMenu", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNmenuHelpWidget, helpMenu); ac++;
	XtSetValues ( menuBar,al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
	XtSetArg(al[ac], XmNpacking, XmPACK_COLUMN); ac++;
	XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
	commandLine = XmCreateRowColumn ( mainWindow, "commandLine", al, ac );

	ac = 0;
	contentButton = XmCreatePushButton ( commandLine, "contentButton", al, ac );

	ac = 0;
	searchButton = XmCreatePushButton ( commandLine, "searchButton", al, ac );

	ac = 0;
	backButton = XmCreatePushButton ( commandLine, "backButton", al, ac );

	ac = 0;
	previousButton = XmCreatePushButton ( commandLine, "previousButton", al, ac );

	ac = 0;
	glossarButton = XmCreatePushButton ( commandLine, "glossarButton", al, ac );

	ac = 0;
	XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
	helpForm = XmCreateForm ( mainWindow, "helpForm", al, ac );

	XtAddCallback (openButton,XmNactivateCallback, XDmap_link, (caddr_t *) &openShell );
	XtAddCallback (openButton,XmNactivateCallback, XDmanage_link, (caddr_t *) &openShell );
	XtAddCallback (printButton, XmNactivateCallback, print_current_theme_CB,(caddr_t *) NULL);
	XtAddCallback (quitButton,XmNactivateCallback, XDunmanage_link, (caddr_t *) &mainWindow );
	XtAddCallback (quitButton,XmNactivateCallback, XDunmap_link, (caddr_t *) &mainWindow );
	XtAddCallback (quitButton, XmNactivateCallback, exit_helpServer_CB,(caddr_t *) NULL);

	ac = 0;
	children[ac++] = openButton;
	children[ac++] = printButton;
	children[ac++] = filePulldownMenuSeparator;
	children[ac++] = quitButton;
	XtManageChildren(children, ac);

	XtAddCallback (defineButton,XmNactivateCallback, XDmanage_link, (caddr_t *) &defineBB );
	XtAddCallback (defineButton,XmNactivateCallback, XDmap_link, (caddr_t *) &defineBB );

	ac = 0;
	children[ac++] = defineButton;
	XtManageChildren(children, ac);

	XtAddCallback (usingHelpButton,XmNactivateCallback, XDmap_link, (caddr_t *) &explainHelpBB );
	XtAddCallback (usingHelpButton,XmNactivateCallback, XDmanage_link, (caddr_t *) &explainHelpBB );
	XtAddCallback (helpInfoButton, XmNactivateCallback, XDmanage_link,(caddr_t *) &aboutHelpServer);

	ac = 0;
	children[ac++] = usingHelpButton;
	children[ac++] = helpPulldownMenuSeparator;
	children[ac++] = helpInfoButton;
	XtManageChildren(children, ac);

	ac = 0;
	children[ac++] = fileMenu;
	children[ac++] = bookMarkMenu;
	children[ac++] = helpMenu;
	XtManageChildren(children, ac);

	ac = 0;
	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( helpForm,al, ac );

	XtAddCallback (contentButton, XmNactivateCallback, show_content_CB,(caddr_t *) NULL);
	XtAddCallback (searchButton, XmNactivateCallback, show_theme_list_CB,(caddr_t *) NULL);
	XtAddCallback (backButton, XmNactivateCallback, show_previous_theme_CB,(caddr_t *) NULL);
	XtAddCallback (previousButton,XmNactivateCallback, XDmap_link, (caddr_t *) &previousBB );
	XtAddCallback (previousButton,XmNactivateCallback, XDmanage_link, (caddr_t *) &previousBB );
	XtAddCallback (glossarButton, XmNactivateCallback, show_glossary_CB,(caddr_t *) NULL);

	ac = 0;
	children[ac++] = contentButton;
	children[ac++] = searchButton;
	children[ac++] = backButton;
	children[ac++] = previousButton;
	children[ac++] = glossarButton;
	XtManageChildren(children, ac);

	XtManageChild (commandLine);
	XtManageChild (menuBar);
	XtManageChild (helpForm);

	XmMainWindowSetAreas(mainWindow, menuBar, commandLine, vSB, hSB, helpForm);

} /* end of create_mainWindow */
