/************************************************************************************************************************

	PROGRAM:	HELPSYSTEM

	FILENAME:	help.h

	PURPOSE:	The header file for HELPSYSTEM
			This file contains several DEFINES, structures and global variable declarations for HELPSYSTEM 

************************************************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include <signal.h>

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#ifdef X11R5
#include <X11/Xmu/Editres.h>
#endif

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/DialogS.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrollBar.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/LabelG.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/Protocols.h>

#ifndef TRUE
	#define TRUE	1
	#define FALSE	0
#endif

#ifndef Boolean
	#define Boolean	int
#endif

#define maxLineLength	256       	/* maximum number of characters per line in a helpfile */
#define maxUserFonts	16		/* maximum number of user definable fonts */
#define lineBufCnt	3200		/* counter for realloc requests for lines */
#define themeBufCnt	100		/* counter for realloc requests for themes */
#define glossBufCnt	120		/* counter for realloc requests for glossary entries */

/************ typedefs and structure definition section ************/


typedef struct _LineStatus {
		unsigned index : 1;
		unsigned theme : 1;
		unsigned glossaryEntry : 1;
		unsigned reference : 1;
		unsigned newFont : 1;
		unsigned newPage : 1;
		unsigned boldFace : 1;
		unsigned italic : 1;
		unsigned fontLine : 1;
		unsigned fileLine : 1;
		unsigned filePath : 1;
} LineStatus;

typedef struct _Zeile {
		LineStatus	status;			/* contains the status information of the line */
		char		content[maxLineLength];	/* contains the line as a character string */
} Zeile;

typedef struct _Entry {
		unsigned int	begin;			/* line number of begin of the entry */
		unsigned int	end;			/* line number of end of the entry */
		char		content[maxLineLength];	/* contains the real information */
} Entry;

typedef struct _ActualTheme {
		int		number;			/* number of current theme */
		char		application[32];	/* application name */
} ActualTheme;

typedef struct _Helpfile {
	unsigned int lineNumber;       	/* current line number */
        unsigned int maxLines;          /* maximal number of lines in helpfile */
        unsigned int themeNumber;       /* number of theme */
        unsigned int glossaryNumber;    /* number of glossary entries */
        unsigned int indexNumber;    	/* number of index theme */
	unsigned int glossarBegin;	/* start line number of glossar */
	unsigned int glossarEnd;	/* end line number of glossar */
	unsigned int indexBegin;	/* start line number of main index */
	unsigned int indexEnd;		/* end line number of main index */
        Zeile	*line;			/* contains all lines of the helptext */
        Entry	*thema;			/* contains all themes in the helptext */
        Entry	*glossar;		/* contains all glossary entries in the helptext */
	char	**themeList;		/* contains array of char pointers of theme strings */
} Helpfile;

/************ define section ************/

#define LineNumber helpfile.lineNumber
#define MaxLines helpfile.maxLines
#define ThemeNumber helpfile.themeNumber
#define GlossaryNumber helpfile.glossaryNumber
#define IndexNumber helpfile.indexNumber
#define Line helpfile.line
#define Theme helpfile.thema
#define ThemeList helpfile.themeList
#define Glossar helpfile.glossar
#define GlossarBegin helpfile.glossarBegin
#define GlossarEnd helpfile.glossarEnd
#define IndexBegin helpfile.indexBegin
#define IndexEnd helpfile.indexEnd

#define OPEN_FILE		100
#define DEFINE_BOOKMARK		101
#define GOTO_THEME		102
#define SELECT_THEME		103
#define PREVIOUS_THEME		104

#define fileOpenErrorString "Error: Help file could not be loaded correctly."
#define tempFileErrorString "Error: Temporary file needed for printing could not be generated."
#define helpTextNotFoundString "Warning: File helptext not found."

/************ global variable definitions ************/

Display *display;       		/* Display */
Screen	*screen;			/* Screen */
Window	rootWindow;			/* Root window of screen */
XFontStruct *currentFont;		/* current user font */
XFontStruct *userFont[maxUserFonts];	/* user defined fonts */
int	screenNr;			/* Screen number */
int	userFontNr;			/* used user font number */
int	lastFontNr;			/* last user font  = subscribe font */
XImage	*image;				/* Image loaded */
Pixmap	pixmap;				/* Image as pixmap */
Colormap xcmap;				/* Colormap for images */
Cursor busyCursor;			/* Busy cursor */
Helpfile	helpfile;		/* current helpfile */
ActualTheme	currentTheme;		/* current theme */
XmStringCharSet	defaultCharset;		/* default character set */
Boolean		newHelpSearchList;	/* status of search list */
char		charset[32];		/* character set currently used */
char		filePath[128];		/* file path of image files */
char		fileName[128];		/* file name of help file */
char		textColour[64];		/* color name of text */
char		textBackgroundColour[64];/* color name of background of text */
char		referenceColour[64];	/* color name of reference entries */
char		glossaryColour[64];	/* color name of glossary entries */
char		printerCommand[64];	/* printer command */
unsigned long	textColor;		/* color of text */
unsigned long	textBackgroundColor;	/* color of background of text */
unsigned long	referenceColor;		/* color of reference entries */
unsigned long	glossaryColor;		/* color of glossary entries */
Widget		button;			/* used to handle button widgets */
Widget		aboutHelpServer;	/* shows info about help server */

/* Atoms for communication via X-Properties */

Atom ICCM_COMMAND;	/* Property with actual command to this service */
Atom ICCM_EXPLICIT;	/* Property with actual command to this service/host */
Atom ICCM_SERVICEID;	/* Property to identify this process as server */
Atom ICCM_SERVERID;	/* like SERVICEID but explicit this host/server */

/* widgets for the application window */

Widget explainHelpShell;
Widget explainHelpBB;
Widget explainHelpForm;
Widget explainHelpScrolledText;
Widget explainHelpHSB;
Widget explainHelpVSB;
Widget explainHelpWindow;
Widget explainHelpSeparator;
Widget explainHelpOkButton;

Widget previousShell;
Widget previousBB;
Widget previousForm;
Widget previousScrolledWindow;
Widget previousHSB;
Widget previousVSB;
Widget previousThemeList;
Widget previousSeparator;
Widget previousCancelButton;

Widget searchShell;
Widget searchBB;
Widget searchForm;
Widget searchLabel;
Widget searchText;
Widget searchScrolledWindow;
Widget searchHSB;
Widget searchVSB;
Widget searchList;
Widget searchGotoButton;
Widget searchCancelButton;

Widget defineShell;
Widget defineBB;
Widget defineForm;
Widget defineBookMarkLabel;
Widget defineBookMarkText;
Widget defineScrolledWindow;
Widget defineHSB;
Widget defineVSB;
Widget defineBookMarkList;
Widget defineOkButton;
Widget defineCancelButton;

Widget openShell;

Widget applShell;
Widget mainWindow;
Widget vSB;
Widget hSB;
Widget mainWindowSeparator1;
Widget mainWindowSeparator2;
Widget menuBar;
Widget fileMenu;
Widget fileSubMenu;
Widget openButton;
Widget printButton;
Widget filePulldownMenuSeparator;
Widget quitButton;
Widget bookMarkMenu;
Widget bookMarkSubMenu;
Widget defineButton;
Widget helpMenu;
Widget helpSubMenu;
Widget usingHelpButton;
Widget helpPulldownMenuSeparator;
Widget helpInfoButton;
Widget commandLine;
Widget contentButton;
Widget searchButton;
Widget backButton;
Widget previousButton;
Widget glossarButton;
Widget helpForm;
Widget helpRC;
