% File: getfiles_2.pl
% Created: 15-Feb-93
% Last Update: 
% Author: Afzal Ballim? (don't remember)
% Purpose: 
% Needs: norm_diff_2.pl, appendD_3.pl

%============================================================
% Predicate: get_file_names/2
% Modes: get_file_names(+TokList,-FileList)
% 
% Purpose: given TokList, a list of tokens (words and separators)
%	   generate FileList, a list of file names. The actual work
%	   is done by getfile/3, getfiles/2 is just a wrapper.
% 
% Licensed Use: get_file_names(+TokList,-FileList)
% 
% Created: 11-Feb-93
% Last Update: 
%============================================================

getfiles([Ifile1|Ifiles],Ofiles) :-
    name(Ifile1,Ifile1l),!,
    norm_diff(Ifile1l,Ifile1lD),!,
    getfile(Ifile1lD,Ifiles,Ofiles).

getfiles([],[]).

%============================================================
% Predicate: getfile/3
% Modes: getfile(+IncmpName,+TokList,-FileList)
% 
% Purpose: IncmpName is a difference list of an incomplete
%	   file name. TokList is a set of tokens yet to be
%	   processed. FileList is the list of files that
%	   is created from these two.
%    
% 
% Licensed Use: getfile(+IncmpName,+TokList,-FileList)
% 
% Created: 11-Feb-93
% Last Update: 
%============================================================

% if nothing else in Ifiles, then return atomic name of last thing
getfile(IfileD/[],[],[Ifiletxt])
    :-
    name(Ifiletxt,IfileD),!.

% if next character is a '.' then we have a compound name
getfile(Ifile1,['.',Ifile1x|Ifiles],Ofiles)
    :-
    name(Ifile1x,[H|L2]),  % turn second part into list
    L3 = [46,H|L2],	   % put in the '.'
    norm_diff(L3,L4),
    appendD(Ifile1,L4,Ifilen), % append the two and continue
    !,getfile(Ifilen,Ifiles,Ofiles).

% if next character is a '/' then we have a compound name
getfile(Ifile1,['/',Ifile1x|Ifiles],Ofiles)
    :-
    name(Ifile1x,[H|L2]),  % turn second part into list
    L3 = [47,H|L2],	   % put in the '/'
    norm_diff(L3,L4),
    appendD(Ifile1,L4,Ifilen), % append the two and continue
    !,getfile(Ifilen,Ifiles,Ofiles).

% if next character is a ',' then we have a separator
getfile(Ifile/[],[','|Ifiles],[Ifiletxt|Ofiles])
:-
    name(Ifiletxt,Ifile),!,
    getfiles(Ifiles,Ofiles).

% otherwise continue processing
getfile(Ifile,[Ifilen|Ifiles],Ofiles)
    :-
    name(Ifilen,Ifilex),
    norm_diff(Ifilex,L1),
    appendD(Ifile,L1,Ifilel),!,
    getfile(Ifilel,Ifiles,Ofiles).

