%============================================================
% Predicate: cond/1
% Modes: cond(+TAList)
% 
% Purpose: TAList is a list of Test-Action pairs, i.e., a clause
%	   to be called, and whose success entails a second
%	   clause to be called. Terminates when the first 'Test'
%	   succeeds. Succeeds if the 'Action' of that 'Test'
%	   succeeds. If the test is 't', then the action is
%	   immediately called.
% 
% Licensed Use: cond(+TAList)
% 
% Created: 11-Feb-93
% Last Update: 
%============================================================

cond([[t,Action]|_]) :-
    !,Action.

cond([[Test,Action]|_]) :-
    Test,!,Action.

cond([_|Conds])
:-
    !,cond(Conds).

