% File: ddll.pl
% Created: 23-Feb-93
% Last Update: 
% Author: Afzal Ballim
% Purpose: dynamic double linked lists ("ddll"s)
% Needs: ddln, cell

%============================================================
% Predicate: list2ddll/2
% Modes: list2ddll(+List,-D)
% 
% Purpose: D is the ddll that corresponds to List
% 
% Licensed Use: 
% 
% Created: 23-Feb-93
% Last Update: 
%============================================================

list2ddll(L,D) :-
	ddll_null(D0),
	ddll_l2d(L,D0,D).

ddll_l2d([],D,D).
ddll_l2d([H|T],D0,D) :-
	ddll_new_last(H,D0,Dn),
	ddll_l2d(T,Dn,D).

%============================================================
% Predicate: ddll_null/1
% Modes: ddll_null(?D)
% 
% Purpose: D is a null ddll.
% 
% Licensed Use: 
% 
% Created: 23-Feb-93
% Last Update: 
%============================================================

ddll_null(ddll(null,null)).

%============================================================
% Predicate: ddll_new_first/3
% Modes: ddll_new_first(+Contents,+Do,-Dn)
% 
% Purpose: Dn is the double linked list that has a first node
%	   containing Contents, and the rest of which is Do.
%	   Considered destructive on Do.
% 
% Licensed Use: 
% 
% Created: 23-Feb-93
% Last Update: 
%============================================================

ddll_new_first(Contents,Do,Dn) :-
	ddll_null(Do),!,
	ddln_create(Contents,null,null,Ref),
	Dn=ddll(Ref,Ref).

ddll_new_first(Contents,ddll(F,L),ddll(Nf,L)) :-
	ddln_create(Contents,null,F,Nf),
	ddln_update_prev(F,_,Nf).

%============================================================
% Predicate: ddll_new_last/3
% Modes: ddll_new_last(+Contents,+Do,-Dn)
% 
% Purpose: Dn is the double linked list that has a last node
%	   containing Contents, and the rest of which is Do.
%	   Considered destructive on Do.
% 
% Licensed Use: 
% 
% Created: 23-Feb-93
% Last Update: 
%============================================================

ddll_new_last(Contents,Do,Dn) :-
	ddll_null(Do),!,
	ddln_create(Contents,null,null,Ref),
	Dn=ddll(Ref,Ref).

ddll_new_last(Contents,ddll(F,L),ddll(F,Nl)) :-
	ddln_create(Contents,L,null,Nl),
	ddln_update_next(L,_,Nl).



%============================================================
% Predicate: portray/1
% Modes: 
% 
% Purpose: 
% 
% Licensed Use: 
% 
% Created: 23-Feb-93
% Last Update: 
%============================================================

portray(ddll(F,L)) :-
	write('['),
	ddll_portray(F,L).

ddll_portray(L,L) :-
	ddln_contents(L,C),
	write(C),write(']').

ddll_portray(N,L) :-
	ddln_contents(N,C),
	write(C),write(':'),
	ddln_next(N,Nx),
	ddll_portray(Nx,L).

ddll_portray(_,_) :- write(']').
