% First, predicates supplied to the library user to examine
% the available libraries, and (of course) to load them.

% user_library/1
% user_library(+LibName)
% load a library
user_library(X) :- 
    name(X,LibName),
    name(Y,[108,105,98|LibName]),
    ensure_loaded(library(Y)).


% library_list/0
% go through all the library descriptions.
library_list :-
    lib_synopsis(Lib,Desc),
    tab(20),write(Lib),nl,
    name(Lib,LN),length(LN,Len),
    tab(20),format("~*c",[Len,0'=]),nl,nl,
    write(Desc),nl,nl,
    fail.

% library_description/1
% details of a library.
library_description(Lib) :-
    lib_synopsis(Lib,Desc),
    tab(20),write(Lib),nl,
    name(Lib,LN),length(LN,Len),
    tab(20),format("~*c",[Len,0'=]),nl,nl,
    write(Desc),nl,nl,
    write('Public predicates are:'),nl,
    lib_publics(Lib,LibP),
    library_description_preds(LibP),nl,nl,
    write('Includes the Files:'),nl,
    lib_includes(Lib,LibI),
    library_description_incs(LibI),nl,nl,
    write('Depends on the Files:'),nl,
    lib_dependencies(Lib,LibD),
    library_description_deps(LibD),nl,nl.

library_description_preds([]).
library_description_preds([H|T]) :- 
	tab(10),write(H),nl,library_description_preds(T).

library_description_incs([]).
library_description_incs([H|T]) :- 
	tab(10),write(H),nl,library_description_incs(T).

library_description_deps([]).
library_description_deps([H|T]) :- 
	tab(10),write(H),nl,library_description_deps(T).

