library IEEE;
use IEEE.STD_LOGIC_1164.all ;
use IEEE.STD_LOGIC_ARITH.all;
use Work.Clock_Utils.all;
entity Harness is
	generic	( WIDTH: NATURAL := 12;
		  LATENCY: NATURAL := 4;
		  PERIOD: NATURAL := 1
		);
end Harness;


architecture EXERCISE of Harness is
	component Multiplier
	port	( A,B : in	STD_LOGIC_VECTOR (WIDTH-1 downto 0);
		  VALID : in 	STD_LOGIC;
		  C : out	STD_LOGIC_VECTOR (WIDTH+WIDTH-1 downto 0);
		  CLK : in	STD_LOGIC
		);
	end component;

	signal a,b:STD_LOGIC_VECTOR (WIDTH-1 downto 0) := 
			STD_LOGIC_VECTOR'(WIDTH-1 downto 0 => '0');
	signal c:STD_LOGIC_VECTOR (WIDTH+WIDTH-1 downto 0);
	signal valid,clk: STD_LOGIC := '0';

	type EXPECT_TYPE is array (INTEGER range 0 to LATENCY-1) of 
		STD_LOGIC_VECTOR(WIDTH+WIDTH-1 downto 0);
begin

	M1:Multiplier	port map 	( a,b,valid,c,clk);
	C1:Clock(clk, 50 ns, 50 ns);

	process (clk)  -- Handle the assertion of VALID.
		variable f_ptr: INTEGER:= -1;
	begin
		if (rising_edge(clk)) then
			f_ptr := (f_ptr + 1) rem PERIOD;
			if (f_ptr = 0) then
				VALID <= '1' after 1 ns;
			else
				VALID <= '0' after 1 ns;
			end if;
		end if;
	end process;		
		

	process (clk)  -- Handle the multiplication.
		variable c_expect_array : EXPECT_TYPE;
		variable c_ptr: INTEGER:= 0;
	begin
	  if (rising_edge(clk)) then
	    assert ((c_expect_array(c_ptr) = 
		     STD_LOGIC_VECTOR'(WIDTH+WIDTH-1 downto 0 => 'U')) or 
		    (c_expect_array(c_ptr) = c))
		   report "Error!"
		   severity ERROR;
	
	    a <= a + 15 mod 345 after 1 ns;
	    b <= b + 357 mod 897 after 1 ns;
	    if (VALID = '1') then
		c_expect_array(c_ptr) := a * b;
	    else
		c_expect_array(c_ptr) := 
			STD_LOGIC_VECTOR'(WIDTH+WIDTH-1 downto 0 => 'U');
	    end if;
	    c_ptr := (c_ptr + 1) mod LATENCY;
	  end if;
	end process;

	process -- handle to termination procedure.
	begin
		wait for 10000 ns;
		assert false
			report "Successful Test Completion"
			severity FAILURE;
	end process;

end Exercise;
