/* Identifying information for project team */
typedef struct {
  /* Full name of first team member */
  char *name1;
  /* Complete email address of first team member */
  char *id1;
  /* Full name of second team member */
  char *name2;
  /* Complete email address of second team member */
  char *id2;
  /* Full name of third team member */
  char *name3;
  /* Complete email address of third team member */
  char *id3;
} team_struct;

/* Some useful macros */

/* Create a mask of bits HI through 0: */
/* Unsigned */
#define IBITS(HI) (((1u << (HI)) << 1) - 1u)
/* Unsigned long */
#define LBITS(HI) (((1uL << (HI)) << 1L) - 1uL)

/* Create a mask of bits HI through LOW (must both be > 0): */
/* Unsigned */
#define IMASK(HI, LOW) (IBITS(HI) ^ IBITS((LOW)-1))
/* Unsigned */
#define LMASK(HI, LOW) (LBITS((unsigned long)(HI)/*+1L*/) ^ LBITS((unsigned long)(LOW)-1))


double float_to_double(float arg);
float  double_to_float(double arg);

