/* Utility for timing function evaluations */

#include <stdio.h>
#include <sys/time.h>
#include "ftime.h"

#define MAX_ETIME 86400   

/* static variable that holds the initial value of the interval timer */
static struct itimerval first_u; /* user time */

/* 
 * elapsed user time routines 
 */

/* init the timer */
static void init_etime(void)
{
    first_u.it_interval.tv_sec = 0;
    first_u.it_interval.tv_usec = 0;
    first_u.it_value.tv_sec = MAX_ETIME;
    first_u.it_value.tv_usec = 0;
    setitimer(ITIMER_VIRTUAL, &first_u, NULL);
}

/* return elapsed seconds since call to init_etime */
static double get_etime(void) {
    struct itimerval curr;

    getitimer(ITIMER_VIRTUAL, &curr);
    return (double) ((first_u.it_value.tv_sec - curr.it_value.tv_sec) +
		     (first_u.it_value.tv_usec - curr.it_value.tv_usec)*1e-6);
}

/* Need to compute value of timer delay */
static double delta_t = 0.0;

double ftime(test_funct P, double E)
{
  int cnt = 1;
  double tmin;
  double tmeas = 0.0;
  /* Make sure timer interval has been computed */
  if (delta_t == 0.0) {
    double start;
    init_etime();
    start = get_etime();
    while ((delta_t = get_etime() - start) <= 1e-6)
      ;
    printf("Delta = %0.3f\n", delta_t);
  }
  tmin = delta_t / E + delta_t;
  while (tmeas < tmin) {
    int c = cnt;
    double start = get_etime();
    while (c-- > 0) {
      P();
    }
    tmeas = get_etime() - start;
    if (tmeas < tmin)
      cnt += cnt;
  }
  return tmeas / cnt;
}

/* Some memory locations to prevent dead code elimination */
int ax = 0;
int bx = 0;
int cx = 0;


/* Compute peformance of CPU doing repeated additions */
static void add_test(void)
{
  int a = ax;
  int b = bx;
  int c = cx;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;

  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;
  a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c; a += b; a += c;

  ax = a + b + c;
}

static void add_dummy(void)
{
  int a = ax;
  int b = bx;
  int c = cx;
  ax = a + b + c;
}

/* Compute clock frequency in MHz */
double freq() {
  /* Compute clock frequency */
  double mhz;
  double secs;
  double atime = ftime(add_test, 0.01);
  double dtime = ftime(add_dummy, 0.01);
  
  secs = atime - dtime; 
  mhz = (200.0/secs)/1000000.0;
  printf("The clock frequency is approximately %0.1f Megahertz\n", mhz);
  return mhz;
}
