/******************************************************************************
 *	pipe.h
 *
 *	Code for implementing pipelined processor simulators
 ******************************************************************************/

#ifndef PIPE_H
#define PIPE_H

/******************************************************************************
 *	#includes
 ******************************************************************************/

#include <stdio.h>

/******************************************************************************
 *	typedefs
 ******************************************************************************/

/* Different control operations for pipeline register */
/* LOAD:   Copy next state to current   */
/* STALL:  Keep current state unchanged */
/* BUBBLE: Set current state to 0's     */

typedef enum { P_LOAD, P_STALL, P_BUBBLE } p_status_t;

typedef struct {
  /* Current and next register state */
  void *current;
  void *next;
  /* Number of state bytes */
  int count;
  /* How should state be updated next time? */
  p_status_t op;
} pipe_ele, *pipe_ptr;

/******************************************************************************
 *	function declarations
 ******************************************************************************/

/* Create new pipe with count bytes of state */
pipe_ptr new_pipe(int count);

/* Update all pipes */
void update_pipes();

/* Set all pipes to zero */
void clear_pipes();

/* Utility code */
void wprint(unsigned x, int bpd, int bpw, FILE *fp);
void wstring(unsigned x, int bpd, int bpw, char *s);

void dump_state(unsigned *state, char **text, int count, FILE *fp, int byte_address);

unsigned load_state(unsigned *state, char **text, FILE *fp, int byte_address,
		    int report);

void clear_state(unsigned *state, char **text, int count);

void dump_all_state(unsigned *state, char **text, int count, FILE *fp,
		int byte_address);

/******************************************************************************/

#endif /* PIPE_H */



