/* Simulator for pipelined implementation of MIPS */
#include <stdio.h>
#include <stdlib.h>
#include "sim.h"

#if macintosh
# include <console.h>
#endif

/* Provide mechanism for simulator to update register display */
void signal_register_update(unsigned char Waddr, unsigned Wdata) {
  printf("Register 0x%x set to 0x%x\n", Waddr, Wdata);
}

void signal_register_clear()
{
  printf("Register File Cleared\n");
}

/* Mechanism for simulator to list line of data/code */ 
void report_line(int addr, unsigned data, char *text) {
}

/* Provide mechanism for simulator to report which instructions are in
   which stages */
void report_pc(unsigned fpc, unsigned char fpcv,
	       unsigned dpc, unsigned char dpcv,
	       unsigned epc, unsigned char epcv,
	       unsigned mpc, unsigned char mpcv,
	       unsigned wpc, unsigned char wpcv)
{
}

/* Report single line of pipeline state */
void report_state(char *id, int current, char *txt) {
}


void signal_sources(void) {}

/* Run the simulator */
/* Arguments should be the names of the code, cycle limit, and mode
   (w = wedged, s = stall, f = forward)  */ 
void main(int argc, char *argv[])
{
  int clock_limit = 100;
  x_status_t exception;

#if macintosh
	argc = ccommand( &argv );
#endif

  if (argc == 1) {
    fprintf(stderr, "Usage: %s instr_file [limit [w|s|f]]\n", argv[0]);
    exit(0);
  }
  if (argc > 1) {
    FILE *code_file = fopen(argv[1], "r");
    int code_count;
    if (!code_file) {
      fprintf(stderr, "Cannot open code file '%s'\n", argv[1]);
      exit(1);
    }
    sim_set_dumpfile(stdout);
    code_count = code_load(code_file);
    if (code_count == 0) {
      fprintf(stderr, "No lines of code found\n");
      exit(1);
    }
    fprintf(stdout, "%u lines of code read\n", code_count);
    code_dump(stdout);
    fclose(code_file);
  }
  if (argc > 2) {
    sscanf(argv[2], "%u", &clock_limit);
  }
  if (argc > 3) {
    switch (*argv[3]) {
    case 's':
      sim_mode = S_STALL;
      break;
    case 'w':
      sim_mode = S_WEDGED;
      break;
    case 'f':
      sim_mode = S_FORWARD;
      break;
    default:
      fprintf(stderr, "Don't understand simulation mode '%c'\n", *argv[1]);
      exit(1);
    }
  }
  exception = sim_run_pipe(clock_limit);
  printf("Exception Status = %s\n", x_name(exception));
  printf("Final Nonzero Register State:\n");
  reg_display(stdout);
  printf("Final Nonzero Memory State:\n");
  data_dump(stdout);
  exit(0);
}
