/* Definition of MIPS instruction set */

/* Declare different instruction opcodes */

#define I_OP     0
#define I_ADDIU 9
#define I_LW    35
#define I_SW    43
#define I_BEQ    4
#define I_BNE    5
#define I_J      2
#define I_JAL    3
#define I_LUI   15

/* Declare different values for funct field */
#define O_SLL     0
#define O_ADDU   33
#define O_BREAK  13
#define O_NOR    39
#define O_OR     37
#define O_SLT    42
#define O_SLTU   43
#define O_SUBU   35
#define O_XOR    38

/* Declare different forms of JR */
#define O_JALR   9
#define O_JR     8

#define ALU_INSTR(fun, rd, rs, rt) \
  ((I_OP)<<26|(rs)<<21|(rt)<<16|(rd)<<11|(fun))

#define SLL_INSTR(rd, rt, sa) \
  ((I_OP)<<26|(rt)<<16|(rd)<<11|(sa)<<6|(O_SLL))

#define ADDU_INSTR(rd, rs, rt) ALU_INSTR(O_ADDU, rd, rs, rt)
#define BREAK_INSTR(code)      ((I_OP)<<26|(code)<<6|O_BREAK)
#define NOR_INSTR(rd, rs, rt) ALU_INSTR(O_NOR, rd, rs, rt)
#define OR_INSTR(rd, rs, rt) ALU_INSTR(O_OR, rd, rs, rt)
#define SLT_INSTR(rd, rs, rt) ALU_INSTR(O_SLT, rd, rs, rt)
#define SLTU_INSTR(rd, rs, rt) ALU_INSTR(O_SLTU, rd, rs, rt)
#define SUBU_INSTR(rd, rs, rt) ALU_INSTR(O_SUBU, rd, rs, rt)
#define XOR_INSTR(rd, rs, rt) ALU_INSTR(O_XOR, rd, rs, rt)

#define LW_INSTR(rt, dis, rs) \
  ((I_LW)<<26|(rs)<<21|(rt)<<16|(dis)&0xffff)
#define SW_INSTR(rt, dis, rs) \
  ((I_SW)<<26|(rs)<<21|(rt)<<16|(dis)&0xffff)

#define ADDIU_INSTR(rt, rs, dat) \
  ((I_ADDIU)<<26|(rs)<<21|(rt)<<16|(dat)&0xffff)


#define BRANCH_INSTR(b_op, rs, rt, offset) \
  ((b_op)<<26|(rs)<<21|(rt)<<16|(offset)&0xffff)
#define BEQ_INSTR(rs, rt, offset) \
  BRANCH_INSTR(I_BEQ, rs, rt, offset)
#define BNE_INSTR(rs, rt, offset) \
  BRANCH_INSTR(I_BNE, rs, rt, offset)

#define J_INSTR(tgt) ((I_J)<<26|tgt)

#define JAL_INSTR(tgt) ((I_JAL)<<26|tgt)

#define JR_INSTR(rs) ((I_OP)<<26|(rs)<<21|(O_JR))
#define JALR_INSTR(rs) ((I_OP)<<26|(rs)<<21|(O_JALR))

#define LUI_INSTR(rt, dat) ((I_LUI)<<26|(rt)<<16|(dat))
#define NOP_INSTR 0

/* Field Extractors */
#define GET_OPCODE(instr) ((instr)>>26&0x3f)
#define GET_RS(instr) ((instr)>>21&0x1f)
#define GET_RT(instr) ((instr)>>16&0x1f)
#define GET_RD(instr) ((instr)>>11&0x1f)
#define GET_I16(instr) ((instr)&0xffff)
#define GET_I26(instr) ((instr)&0x3ffffff)
#define GET_FUN(instr) ((instr)&0x3f)
