#!/usr/local/bin/perl

# Run test of pipeline for block & determine CPE
use Getopt::Std;

$blocklen = 64;
$yas = "../misc/yas";
$pipe = "./pipe_tty";
$gendriver = "./gen-driver.pl";
$fname = "bdriver";
$ncopy = "ncopy";
$verbose = 1;

getopts('hqn:f:');

if ($opt_h) {
    print STDERR "Usage $argv[0] [-h] [-n N] [-f FILE]\n";
    print STDERR "   -h      print help message\n";
    print STDERR "   -q      quiet mode\n";
    print STDERR "   -n N    set max. number of elements (up to 64)\n";
    print STDERR "   -f FILE set input file (default 'ncopy.ys')\n";
    die "\n";
}

if ($opt_q) {
    $verbose = 0;
}

if ($opt_n) {
    $blocklen = $opt_n;
    if ($blocklen < 0 || $blocklen > 64) {
	print STDERR "n must be between 0 and 64\n";
	die "\n";
    }
}

if ($opt_f) {
    $ncopy = $opt_f;
    # Strip off .ys
    $ncopy =~ s/\.ys//;
}

if ($verbose) {
    print "\t$ncopy\n";
}

$tcpe = 0;
for ($i = 1; $i <= $blocklen; $i++) {
    !(system "$gendriver -n $i -f $ncopy.ys > $fname$i.ys") ||
	die "Couldn't generate driver file $fname$i.ys\n";
    !(system "$yas $fname$i.ys") ||
	die "Couldn't assemble file $fname$i.ys\n";
    $stat = `$pipe -v 0 $fname$i.yo` ||
	die "Couldn't simulate file $fname$i.yo\n";
    !(system "rm $fname$i.ys $fname$i.yo") ||
	die "Couldn't remove files $fname$i.ys and/or $fname$i.yo\n";
    chomp $stat;
    $stat =~ s/[ ]*CPI:[ ]*//;
    $stat =~ s/ cycles.*//;
    $cpe = $stat/$i;
    if ($verbose) {
	printf "%d\t%.2f\n", $i, $cpe;
    }
    $tcpe += $cpe;
}

$acpe = $tcpe/$blocklen;
printf "avg\t%.2f\n", $acpe;


