/*
 * adder.c - simple CGI script that adds two numbers together
 *
 * Expects "arg1&arg2" in QUERY_STRING
 * Warning: doesn't parse args properly (e.g., doesn't interpret
 *  "       %20" sequences as spaces.)
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BUFSIZE 128
#define CONTENTSIZE 1024

int main() {
  char *buf, *p;
  char arg1[BUFSIZE];
  char arg2[BUFSIZE];
  char content[CONTENTSIZE];
  int n1, n2;

  /* parse the argument list */
  if ((buf = getenv("QUERY_STRING")) == NULL) {
    exit(1);
  }

  p = strchr(buf, '&');
  *p = '\0';
  strcpy(arg1, buf);
  strcpy(arg2, p+1);
  n1 = atoi(arg1);
  n2 = atoi(arg2);

  /* generate the result */
  sprintf(content, "Welcome to add.com: THE Internet addition portal.\n<p>The answer is: %d + %d = %d\n<p>Thanks for visiting!\n", 
	  n1, n2, n1+n2);
  
  /* generate the dynamic content */
  printf("Content-length: %d\n", strlen(content));
  printf("Content-type: text/html\n");
  printf("\r\n");
  printf("%s", content);
  fflush(stdout);
  exit(0);
}
